﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/LoginMaster.Master" Inherits="System.Web.Mvc.ViewPage<XtremeERP.WEB.MemberCredentials>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    SULUHU DT SACCO - Member Login
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        
    /* Center login card */
    .login-wrapper {
        min-height: calc(100vh - 100px);
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 0px;
    }

    .login-card {
        background: #fff;
        border-radius: 12px;
        max-width: 400px;
        width: 100%;
        box-shadow: 0 8px 20px rgba(0,0,0,0.15);
        transition: all 0.3s ease;
    }

    .login-logo {
        width: 100px;
        height: 100px;
        object-fit: contain;
        border-radius: 50%;
        border: 3px solid var(--suluhu-green);
        padding: 8px;
        background-color: #fff;
        box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
    }

    .company-title {
        font-size: 22px;
        color: var(--suluhu-blue);
        font-weight: 600;
        margin-bottom: 4px;
    }

    .login-sub {
        font-size: 14px;
        color: #555;
    }

    @media (max-width: 768px) {
        .login-card {
            padding: 0px;
            max-width: 90%;
        }
        .login-logo {
            width: 80px;
            height: 80px;
        }
        .company-title {
            font-size: 20px;
        }
        .login-sub {
            font-size: 13px;
        }
    }

    @media (max-width: 480px) {
        .login-card {
            padding: 1px;
            max-width: 95%;
        }
        .login-logo {
            width: 70px;
            height: 70px;
        }
        .company-title {
            font-size: 18px;
        }
        .login-sub {
            font-size: 12px;
        }
    }

    </style>



    <script type="text/javascript">
        $(document).ready(function () {
            // Remove elements with "noscript" class - <noscript> is not allowed in XHTML
            var noscripts = document.getElementsByClassName("noscript");
            for (var i = 0; i < noscripts.length; i++) {
                noscripts[i].parentNode.removeChild(noscripts[i]);
            }
            

            $("#NenoSiriCapture").val("");
            $("#UserNameCapture").val("");
            $("#NenoSiri").val("");
            $("#UserName").val("");
            $("#UserName").focus();

            $("#UserNameCapture").focus("");

            //$("#lblMessage").html("<p><b>Loading....</b></p>");
            
            
            setTimeout(function () {
                $("#NenoSiriCapture").val("");
                //$("#UserNameCapture").val("");
                $("#NenoSiri").val("");
                $("#UserName").val("");
                if ($("#lblMessage").html() == "") {
                    $("#lblMessage").html("<p><b>Enter Valid Credentials</b></p>");
                }
            }, 2000);
            
            
            
            $("#cboLoginAs").addClass("form-control");
            //$("#link_RequestPassword").addClass("btn").addClass("btn-info");
            $("#cboLoginAs").on('change click', function (e) {
                var strloginas = $("#cboLoginAs option:selected").val();
                $("#SelectedLoginAs").val(strloginas);
                var strdisplaytext = "";
                if (strloginas.toUpperCase() === "payrollno".toUpperCase()) { strdisplaytext = "Payroll No." };
                if (strloginas.toUpperCase() === "memberno".toUpperCase()) { strdisplaytext = "Member No." };
                if (strloginas.toUpperCase() === "idnumber".toUpperCase()) { strdisplaytext = "ID Number" };
                if (strdisplaytext != "") {
                    $("#lblLoginAs").text(strdisplaytext);
                    $("#UserNameCapture").attr("placeholder", "Enter " + strdisplaytext);
                }
                //e.preventDefault();
            });
            $("#cboLoginAs").trigger("change");
            $('#NenoSiriCapture').on('contextmenu', function (e) {
                alert("Pasting disabled");
                e.preventDefault();
            });

            $('#NenoSiriCapture').on('keypress', function (e) {
                if (e.keyCode == 13 || e.which == 13) {
                    e.preventDefault();
                    $('#btnLogin').trigger('click');
                }
            });



            $('#btnLogin').removeAttr("readonly");
            $('#btnLogin').prop('disabled', false);



            $('#ReturnURL').val(getUrlParameter("ReturnUrl"));

            $('#UserNameCapture').keypress(function (e) {
                if (e.keyCode == 13 || e.which == 13) {
                    e.preventDefault();
                    $('#NenoSiriCapture').focus();
                }

            });

            $('#NenoSiriCapture').keypress(function (e) {
                if (e.keyCode == 13 || e.which == 13) {
                    e.preventDefault();
                    $('#Branch').focus();
                }

            });
            $('#Branch').keypress(function (e) {
                if (e.keyCode == 13 || e.which == 13) {
                    e.preventDefault();
                    $('#ClassCode').focus();
                }

            });
            $('#ClassCode').keypress(function (e) {
                if (e.keyCode == 13 || e.which == 13) {
                    e.preventDefault();
                    $('#btnLogin').trigger('click');
                }

            });

            //$.reject({
            //    reject: {
            //        all: false,
            //        msie5: true, msie6: true, msie7: true, msie9: true
            //    }, // test reject all renderers
            //    close: true,
            //    display: ['firefox', 'chrome', 'msie'],
            //    header: 'Xtreme-ERP Web Interface<br>Your browser is not supported here', // Header Text
            //    paragraph1: 'Please install one of the many optional browsers below to proceed',
            //    closeMessage: 'By closing this window you acknowledge that your experience ' +
            //        'on this website may be degraded', // Message below close window link
            //    closeLink: 'Close This Window', // Text for closing link  
            //    closeURL: '#', // Close URL  
            //    closeESC: true, // Allow closing of window with esc key  

            //    // If cookies should be used to remmember if the window was closed  
            //    // See cookieSettings for more options  
            //    closeCookie: false,
            //    // Cookie settings are only used if closeCookie is true  
            //    cookieSettings: {
            //        // Path for the cookie to be saved on  
            //        // Should be root domain in most cases  
            //        path: '/',
            //        // Expiration Date (in seconds)  
            //        // 0 (default) means it ends with the current session  
            //        expires: 0
            //    },

            //    imagePath: '/Content/jsrejectimages/', // Path where images are located  
            //    overlayBgColor: '#000', // Background color for overlay  
            //    overlayOpacity: 0.8, // Background transparency (0-1)  

            //    // Fade in time on open ('slow','medium','fast' or integer in ms)  
            //    fadeInTime: 'fast',
            //    // Fade out time on close ('slow','medium','fast' or integer in ms)  
            //    fadeOutTime: 'fast',

            //    // Google Analytics Link Tracking (Optional)  
            //    // Set to true to enable  
            //    // Note: Analytics tracking code must be added separately  
            //    analytics: false
            //});

        });


        function SubmitForm() {

            if ($('#UserNameCapture').val().trim() == '') {
                alert("Enter UserName");
                $('#UserNameCapture').focus();
                return false;
            } else if ($('#NenoSiriCapture').val().trim().length < 4) {
                alert("Enter Password (Min 4 Characters)");
                $('#NenoSiriCapture').focus();
                return false;
            } else {
                $("#SelectedLoginAs").val ($("#cboLoginAs").val());
                $('#NenoSiri').val($("#NenoSiriCapture").val());
                $('#UserName').val($("#UserNameCapture").val());
                
                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5($("#NenoSiri").val()).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();
                $('#NenoSiri').val(sltpwd);
                
                $('#Salt').val(pwdslt);
                

                $("#NenoSiriCapture").val('');
                $("#UserNameCapture").val('');
                $("#lblMessage").html("<b>Logging in...Please wait</b>");
                return true;
            }
        }
        function getUrlParameter(paramName) {
            var searchString = window.location.search.substring(1),
                i, val, params = searchString.split("&");

            for (i = 0; i < params.length; i++) {
                val = params[i].split("=");
                if (val[0] == paramName) {
                    return unescape(val[1]);
                }
            }
            return null;
        }
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

<div class="login-wrapper">

    <!-- Login Card -->
    <div class="login-card mx-auto p-4 shadow-sm">

        <!-- Logo & Title -->
        <div class="text-center mb-4">
            <h2 class="company-title mb-1">Suluhu Member Portal</h2>
            <p class="login-sub text-muted mb-3">Enter your credentials to access your account</p>
        </div>

        <!-- Fake fields to prevent autocomplete -->
        <input type="text" id="UserName1" style="visibility:hidden; width:0; height:0" autocomplete="off" />
        <input type="password" id="NenoSiri1" style="visibility:hidden; width:0; height:0" autocomplete="off" />

        <!-- LOGIN USING -->
        <div class="mb-3">
            <label for="cboLoginAs" class="form-label">Login Using</label>
            <%: Html.DropDownListFor(
                    model => model.LoginAs,
                    ViewBag.select_login_as as List<SelectListItem>,
                    new { id = "cboLoginAs", name="cboLoginAs", @class="form-select" }
                )
            %>
        </div>

        <!-- USERNAME -->
        <div class="mb-3">
            <label id="lblLoginAs" for="UserNameCapture" class="form-label">Login As:</label>
            <input type="text" id="UserNameCapture" name="UserNameCapture"
                   autocomplete="off" class="form-control" placeholder="Enter your username" />
        </div>

        <!-- PASSWORD -->
        <div class="mb-3">
            <label for="NenoSiriCapture" class="form-label">Password</label>
            <input type="password" id="NenoSiriCapture" name="NenoSiriCapture"
                   autocomplete="off" placeholder="Enter Password"
                   class="form-control" />
        </div>

        <!-- FORM -->
        <form id="frmLogin" class="form" method="post"
              autocomplete="off"
              action="<%: Url.Content("~/Login/Member") %>"
              onsubmit="return SubmitForm()">

            <%= Html.AntiForgeryToken() %>

            <!-- Hidden true fields -->
            <input type="text" id="UserName" name="UserName" style="visibility:hidden; width:0; height:0" autocomplete="off" />
            <input type="password" id="NenoSiri" name="NenoSiri" style="visibility:hidden; width:0; height:0" autocomplete="off" />
            <input type="text" id="SelectedLoginAs" name="SelectedLoginAs" style="visibility:hidden; width:0; height:0" autocomplete="off" />

            <!-- ERROR MESSAGE -->
            <% if (!String.IsNullOrWhiteSpace(ViewBag.Message)) { %>
                <div class="alert alert-danger text-center py-2 mb-3" id="diverror">
                    <p id="lblMessage" class="m-0"><%: ViewBag.Message %></p>
                </div>
            <% } %>

            <!-- LOGIN BUTTON -->
            <div class="mb-3">
                <input type="submit" id="btnLogin" value="Login"
                       class="btn btn-success w-100 btn-lg" />
            </div>

            <!-- REQUEST PASSWORD -->
            <div class="mb-3">
                <%= Html.ActionLink(
                        "Request Password",
                        "RequestMemberPassword",
                        "Login",
                        new { Area = "" },
                        new { id="link_RequestPassword", @class="btn btn-primary w-100 btn-lg" }
                    )
                %>
            </div>

            <%: Html.HiddenFor(model => model.Salt) %>
            <%: Html.HiddenFor(model => model.ReturnURL, System.Web.HttpContext.Current.Request["ReturnUrl"]) %>

        </form>

    </div>

</div>



</asp:Content>
