﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Suluhu Dt Sacco System</title>

    <link href="<%: Url.Content("~/favicon.ico") %>" rel="shortcut icon" type="image/x-icon" />

    <!-- Suluhu Theme Styles -->
    <style>
        :root {
            --suluhu-green: #1bb145;
            --suluhu-blue: #005eb8;
            --suluhu-red: #e32845;
            --white: #ffffff;
            --gray: #f4f6f8;
        }

        body {
            background-color: var(--white);
            font-family: "Segoe UI", sans-serif;
            margin: 0;
            min-height: 100vh;
            padding: 20px;
        }

        /* Gradient soft lighting */
        body::before,
        body::after {
            content: "";
            position: fixed;
            left: 0;
            right: 0;
            height: 50%;
            z-index: -1; 
            pointer-events: none;
        }

        body::before {
            top: 0;
            background: linear-gradient(to bottom, rgba(27,177,69,0.18), transparent);
        }
        body::after {
            bottom: 0;
            background: linear-gradient(to top, rgba(0,94,184,0.18), transparent);
        }

        /* Center container card */
        .login-wrapper {
            max-width: 900px;
            margin: auto;
            background: rgba(255,255,255,0.9);
            border-radius: 15px;
            padding: 35px;
            box-shadow: 0 8px 25px rgba(0,0,0,0.10);
        }

        .logo-box {
            text-align: center;
            margin-bottom: 20px;
        }

        .logo-box img {
            width: 130px;
            height: 130px;
            object-fit: contain;
            background: #fff;
            padding: 10px;
            border-radius: 50%;
            border: 3px solid var(--suluhu-green);
            box-shadow: 0 5px 10px rgba(0,0,0,0.1);
        }

        h2.company-title {
            text-align: center;
            font-weight: 600;
            margin-top: 15px;
            color: var(--suluhu-blue);
        }

        .divider {
            margin: 25px 0;
        }

        .divider hr {
            border: 0;
            height: 4px;
            border-radius: 3px;
        }

        .divider .blue {
            background: var(--suluhu-blue);
            margin-bottom: 4px;
        }

        .divider .green {
            background: var(--suluhu-green);
        }

        /* Login options */
        .login-options {
            margin-top: 20px;
        }

        .login-card {
            padding: 20px;
            background: var(--gray);
            border-radius: 10px;
            text-align: center;
            transition: 0.3s;
            box-shadow: 0 5px 10px rgba(0,0,0,0.05);
        }

        .login-card:hover {
            transform: translateY(-6px);
            box-shadow: 0 10px 18px rgba(0,0,0,0.12);
            background: #fff;
        }

        .login-card h1 {
            font-size: 22px;
        }

        .login-card a {
            text-decoration: none;
            color: var(--suluhu-blue);
            font-weight: bold;
        }

        .login-card a:hover {
            color: var(--suluhu-green);
        }
    </style>

    <%: Scripts.Render("~/bundles/jquery") %>
    <%: Scripts.Render("~/bundles/bootstrap") %>

    <%: Styles.Render("~/Content/bootstrap") %>
</head>

<body>

<div class="login-wrapper">

    <!-- Logo -->
    <div class="logo-box">
        <img src='<%: Url.Content("~/SaccoLogo/sacco_logo.jpg") %>' />
    </div>

    <!-- Company Name -->
    <%
        XtremeERP.Common.Data.SaccoSettings saccoSettings = ViewBag.saccoSettings as XtremeERP.Common.Data.SaccoSettings;
    %>
    <% if (saccoSettings == null) { %>
        <h2 class="company-title">SACCO NAME MISSING (ERROR)</h2>
    <% } else { %>
        <h2 class="company-title"><%= saccoSettings.CompanyName %><br /><small><%= saccoSettings.CompanyAddress %></small></h2>
    <% } %>

    <!-- Divider lines -->
    <div class="divider">
        <hr class="blue" />
        <hr class="green" />
    </div>

    <!-- Login Options -->
    <div class="row login-options text-center">

        <div class="col-md-4 mb-3">
            <div class="login-card">
                <h1><%= Html.ActionLink("Members Login", "member", "Login") %></h1>
            </div>
        </div>

        <!-- <div class="col-md-4 mb-3">
            <div class="login-card">
                <h1><%= Html.ActionLink("HR Login", "payroll", "Login") %></h1>
            </div>
        </div>

        <div class="col-md-4 mb-3">
            <div class="login-card">
                <h1><%= Html.ActionLink("Staff Login", "staff", "Login") %></h1>
            </div> -->
        </div>

    </div>

    <!-- Bottom Divider -->
    <div class="divider">
        <hr class="blue" />
        <hr class="green" />
    </div>

</div>

</body>
</html>
