﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/LoginMaster.Master" Inherits="System.Web.Mvc.ViewPage<XtremeERP.WEB.MemberCredentials>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Xtreme-ERP.Net - Member Login
</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        /* --- Base layout --- */
        body {
            background: linear-gradient(135deg, #0f2027, #203a43, #2c5364);
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
            height: 100vh;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        #divLg {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
            padding: 40px;
            width: 100%;
            max-width: 420px;
            animation: fadeIn 0.7s ease-in-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* --- Header --- */
        #divLg h3 {
            text-align: center;
            color: #2c5364;
            font-weight: 600;
            margin-bottom: 0.5em;
        }

        hr {
            border: none;
            border-top: 2px solid #2c5364;
            width: 60%;
            margin: 10px auto 30px auto;
        }

        /* --- Table styling --- */
        table {
            width: 100%;
            border-collapse: collapse;
        }

        td {
            padding: 10px 5px;
            vertical-align: middle;
        }

        /* --- Inputs --- */
        input[type="text"], input[type="password"], select {
            width: 100%;
            padding: 10px;
            border-radius: 6px;
            border: 1px solid #ccc;
            font-size: 1em;
            transition: all 0.3s ease;
        }

        input[type="text"]:focus, input[type="password"]:focus, select:focus {
            outline: none;
            border-color: #2c5364;
            box-shadow: 0 0 5px rgba(44, 83, 100, 0.5);
        }

        /* --- Buttons --- */
        .btn-success {
            background: linear-gradient(90deg, #2c5364, #203a43);
            color: #fff;
            border: none;
            padding: 12px 20px;
            border-radius: 6px;
            width: 100%;
            font-size: 1em;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        .btn-success:hover {
            background: linear-gradient(90deg, #203a43, #0f2027);
        }

        /* --- Links --- */
        a {
            text-decoration: none;
            color: #2c5364;
            font-weight: 500;
            transition: color 0.3s;
        }

        a:hover {
            color: #0f2027;
        }

        /* --- Error message --- */
        #diverror h3 {
            color: red;
            font-size: 1em;
            text-align: center;
            margin-top: 10px;
        }

        /* --- Responsive --- */
        @media (max-width: 480px) {
            #divLg {
                padding: 25px;
            }

            input, select, .btn-success {
                font-size: 0.9em;
            }
        }
    </style>
</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <form id="frmLogin" method="post" autocomplete="off" action="<%: Url.Content("~/Login/Member") %>" onsubmit="return SubmitForm()">
        <div id="divLg">
            <%= Html.AntiForgeryToken() %>

            <h3>XtremeERP.NET - MEMBER LOGIN</h3>
            <hr />

            <table>
                <tr>
                    <td colspan="2">
                        <%: Html.DropDownListFor(model => model.LoginAs, ViewBag.select_login_as as List<SelectListItem>)%>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <input type="text" name="UserNameCapture" id="UserNameCapture" placeholder="Username" autocomplete="off" />
                        <input type="text" name="UserName" id="UserName" style="display:none;" autocomplete="off" />
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <input type="password" name="NenoSiriCapture" id="NenoSiriCapture" autocomplete="off" disabled="disabled" placeholder="Password" />
                        <input type="password" name="NenoSiri" id="NenoSiri" style="display:none;" autocomplete="off" disabled="disabled" />
                    </td>
                </tr>

                <% if (!String.IsNullOrWhiteSpace(ViewBag.Message)) { %>
                    <tr>
                        <td colspan="2">
                            <div id="diverror"><h3><%: ViewBag.Message %></h3></div>
                        </td>
                    </tr>
                <% } %>

                <tr>
                    <td colspan="2">
                        <input type="submit" value="Login" id="btnLogin" class="btn btn-success" disabled="disabled" />
                    </td>
                </tr>
                <tr>
                    <td style="text-align:left">
                        <%= Html.ActionLink("Request Password", "RequestMemberPassword", "Login", new { Area = "" }, new { id = "link_RequestPassword" }) %>
                    </td>
                    <td style="text-align:right">
                        <%= Html.ActionLink("About App", "GetAbout", "AboutApp", new { Area = "" }, new { id = "lnkGetAbout" }) %>
                    </td>
                </tr>
            </table>

            <%: Html.HiddenFor(model => model.Salt) %>
            <%: Html.HiddenFor(model => model.ReturnURL, System.Web.HttpContext.Current.Request["ReturnUrl"]) %>
        </div>
    </form>
</asp:Content>
