﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loan Witness Requests
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
   
    /* === UNIVERSAL TABLE STYLE === */
    .table-responsive {
        display: block;
        width: 100%;
        max-width: 100vw;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        border: 1px solid #ddd;
        border-radius: 6px;
        background-color: #fff;
        margin-bottom: 1rem;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        white-space: nowrap;
    }

    th, td {
        padding: 8px 10px;
        border: 1px solid #ddd;
        text-align: left;
        vertical-align: middle;
    }

    th {
        background-color: #1bb145;
        color: #fff;
        font-weight: 600;
        text-align: center;
    }

    tr:hover td {
        background-color: #f8f9fa;
    }

    /* === FILTERS TABLE === */
    #frmMain table.table {
        width: 100%;
        background: #fdfdfd;
        border: 1px solid #ccc;
        border-radius: 6px;
        margin-bottom: 1rem;
    }

    #frmMain td {
        padding: 6px;
    }

    select, input {
        width: 100%;
        max-width: 100%;
        padding: 5px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }

    /* === MOBILE STACKED VIEW FOR WITNESS REQUESTS === */
@media (max-width: 768px) {

    /* Hide header and switch table elements to block */
    #tblWitnessesRequests,
    #tblWitnessesRequests thead,
    #tblWitnessesRequests tbody,
    #tblWitnessesRequests th,
    #tblWitnessesRequests td,
    #tblWitnessesRequests tr {
        display: block;
        width: 100%;
    }

    /* Hide table headers on mobile */
    #tblWitnessesRequests thead {
        display: none;
    }

    /* Make each row look like a card */
    #tblWitnessesRequests tr {
        margin-bottom: 1rem;
        border: 1px solid #ddd;
        border-radius: 8px;
        background: #fff;
        box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1);
        padding: 10px;
    }

    #tblWitnessesRequests td {
        border: none;
        border-bottom: 1px solid #eee;
        position: relative;
        padding-left: 45%;
        text-align: left;
        white-space: normal;
        word-wrap: break-word;
        font-size: 0.9rem;
    }

    #tblWitnessesRequests td:last-child {
        border-bottom: none;
    }

    /* Add labels for each column (based on header order) */
    #tblWitnessesRequests td:nth-child(1)::before { content: "Date: "; }
    #tblWitnessesRequests td:nth-child(2)::before { content: "Ref.No: "; }
    #tblWitnessesRequests td:nth-child(3)::before { content: "Member No: "; }
    #tblWitnessesRequests td:nth-child(4)::before { content: "Names: "; }
    #tblWitnessesRequests td:nth-child(5)::before { content: "Loan Type: "; }
    #tblWitnessesRequests td:nth-child(6)::before { content: "Loan Amount: "; }
    #tblWitnessesRequests td:nth-child(7)::before { content: "Status: "; }
    #tblWitnessesRequests td:nth-child(8)::before { content: "Respond: "; }
    #tblWitnessesRequests td:nth-child(9)::before { content: "Loan Request Status: "; }

    /* Style for labels */
    #tblWitnessesRequests td::before {
        position: absolute;
        top: 6px;
        left: 10px;
        width: 40%;
        font-weight: 600;
        color: #1a5d3f;
        white-space: nowrap;
    }
}

/* Extra small screens */
@media (max-width: 480px) {
    #tblWitnessesRequests td {
        font-size: 0.85rem;
        padding-left: 40%;
    }
}

</style>



    <script type="text/javascript"  >
        $(document).ready(function () {
            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/MembersSystemApi/GetYears") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    LoadWitnessesRequests();
                },
                error: function (xhr, status, error) {

                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });

            $("#cboYear").on("change", function () {
                LoadWitnessesRequests();
            });
            $("#cboLnApplicationStatus").on("change", function () {
                LoadWitnessesRequests();
            });
            $('#tblWitnessesRequests').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $('#bdWitnessRequests').on('click', 'a', function (event) {
                event.preventDefault();
                var ln_ref_no = $(this).closest('tr').find('td').eq(1).text();
                var ln_mem_no = $(this).closest('tr').find('td').eq(2).text();
                var ln_requested_loanee_name = $(this).closest('tr').find('td').eq(3).text();
                var ln_requested_loan_type = $(this).closest('tr').find('td').eq(4).text();
                var ln_loan_amt = $(this).closest('tr').find('td').eq(5).text();
                var ln_requested_amt = $(this).closest('tr').find('td').eq(6).text();
                $('<div id="divWitnessRequestDialog"></div>').dialog({
                    modal: true,
                    title: "Respond to Witness Request",
                    height: 520,
                    width: 500,
                    autoOpen: true,
                    responsive:true,
                    show: {
                        effect: "drop",
                        direction: "up",
                        duration: 500
                    },

                    buttons: {
                        'OK': {
                            'text': 'OK',
                            'id': 'btnOK',
                            'click': function () {
                                var accepted_amount = $("#txtAcceptedAmt").val();
                                var ConfirmMessage = "";
                                if (document.getElementById("cboWitnesssResponse").selectedIndex == 1) {
                                    
                                    ConfirmMessage = "Confirm Acceptance of Loan Application Witness?";
                                } else if (document.getElementById("cboWitnesssResponse").selectedIndex == 2) {
                                    ConfirmMessage = "Confirm Rejection of Loan Application Request?";
                                } else if (document.getElementById("cboWitnesssResponse").selectedIndex == 0) {
                                    alert("Select Response");
                                    return;
                                }
                                xDialogConfirm(ConfirmMessage, "Confirm").then(function () {
                                    xDialogMemberCredetials().then(function (data) {
                                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                                        var Password = data.UserPass;
                                        var pwdslt = getRandomInt(1000, 30000);
                                        pwdslt = pwdslt.toString();
                                        var pwd = CryptoJS.MD5(Password).toString();
                                        pwd = pwd + pwdslt;
                                        var sltpwd = CryptoJS.MD5(pwd).toString();
                                        var outData = {
                                            'DBName': $("#cboYear").val(),
                                            'LoanRefNo': $("#txtRequestLoanRefNo").val(),
                                            'Response': $("#cboWitnesssResponse").val(),
                                            'Notes': $("#txtResponseReason").val(),
                                            'Password': sltpwd,
                                            'Salt': pwdslt
                                        }
                                        outData = JSON.stringify(outData);
                                        $.ajax({
                                            headers: { __RequestVerificationToken: csrfToken },
                                            type: "POST",
                                            url: "<%: Url.Content("~/api/MembersSystemApi/ProcessMemberLoanApplicationWitnessResponse") %>",
                                            data: outData,
                                            contentType: "application/json; charset=utf-8",
                                            dataType: "json",
                                            success: function (response) {
                                                alert(response);
                                                $("#divWitnessRequestDialog").dialog("close");
                                                LoadWitnessesRequests();
                                            },
                                            error: function (xhr, status, error) {
                                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                                alert('Error - ' + errorMessage);
                                            }
                                        });
                                    });
                                });
                            }
                        },
                        Cancel: function () {
                            $(this).dialog("close");
                        }
                    },
                    open: function () {
                        var tbl = "<table id='tblRespondWitnessRequest' border=1>";
                        tbl += "<tbody>";
                        tbl += "<tr><td><b>Loan Ref. No:</b></td><td><input type='text' id='txtRequestLoanRefNo' value='" + ln_ref_no + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loanee:</b></td><td><input type='text' id='txtRequestLoaneeName' value='" + ln_requested_loanee_name + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loane MemberNo:</b></td><td><input type='text' id='txtRequestLoaneeMemberNo' value='" + ln_mem_no + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loan Type:</b></td><td><input type='text' id='txtRequestLoanType' value='" + ln_requested_loan_type + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loan Amount:</b></td><td><input type='text' id='txtRequestLoanAmount' value='" + ln_loan_amt + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Reponse:</b></td><td><select id='cboWitnesssResponse'><option value='' selected>(SELECT)</option><option value='accepted'>Accept</option><option value='rejected'>Reject</option></select></td></tr>";
                        tbl += "<tr><td><b>Notes/Reason:</b></td><td><textarea id='txtResponseReason' disabled/></textarea></td></tr>";
                        tbl += "</tbody></table>";
                        $(this).html(tbl);
                        $("#cboWitnesssResponse").focus;
                    },
                    close: function (event, ui) {
                        $(this).dialog("destroy").remove();
                    }
                });
                $("#txtPassword").on("keyup", function (e) {
                    var kcode = (e.keyCode ? e.keyCode : e.which);
                    if (kcode == $.ui.keyCode.ENTER) {
                        $("#btnOK").trigger("click");
                    }
                    e.stopPropagation();
                });

                $("#cboWitnesssResponse").on('change', function () {
                    $("#txtResponseReason").attr("disabled", true);
                    $("#txtResponseReason").val("");

                    if ($("#cboWitnesssResponse option:selected").index() == 1) {
                        $("#txtResponseReason").attr("disabled", false);
                    }
                    else if ($("#cboWitnesssResponse option:selected").index() == 2) {
                        //$("#txtResponseReason").attr("disabled", true);
                        $("#txtResponseReason").attr("disabled", false);
                    }
                });
            });

            function LoadWitnessesRequests() {
                $("#tblWitnessesRequests > tbody:last").children().remove();
                
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberWitnessRequests") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'LoanStatus': $("#cboLnApplicationStatus").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var WitnessRequests = response;
                        var tbl_row = "";
                        
                        $.each(WitnessRequests, function (index, WitnessRequest) {
                           
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + WitnessRequest.LoanDate + "</td>";
                            tbl_row += "<td>" + WitnessRequest.LoanRefNo + "</td>";
                            tbl_row += "<td>" + WitnessRequest.LoaneeMemberNo + "</td>";
                            tbl_row += "<td>" + WitnessRequest.LoaneeNames + "</td>";
                            tbl_row += "<td>" + WitnessRequest.LoanTypeName + "</td>";
                            tbl_row += "<td>" + (+WitnessRequest.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + WitnessRequest.WitnessResponse + "</td>";
                            tbl_row += "<td><a href=''>Respond</td>";
                            tbl_row += "<td>" + WitnessRequest.LoanProcessStatus + "</td>";  
                            tbl_row += "</tr>";
                        });
                        if (tbl_row != "") { $("#bdWitnessRequests").append(tbl_row); }

                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="container">
        <h3>Loan Witnesses Requests</h3>
        <div class="row">
            <div id="div1" class="col-md-12 table-responsive">
                <form id="frmMain" name="frmMain" class="form">
                    <%= Html.AntiForgeryToken() %>
                    <table border="1" style="padding: 1px; margin: 1px;" class="table">
                        <tr>
                            <td colspan="4"><b>Filters</b></td>
                        </tr>
                        <tr>
                            <td>Financial Year:</td>
                            <td colspan="3">
                                <select id="cboYear">
                                    <option value="selectyear">SELECT YEAR</option>
                                </select></td>
                        </tr>
                        <tr>
                            <td>Loan Application Status:</td>
                            <td >
                                <select id="cboLnApplicationStatus">
                                    <option value="pending" selected>ACTIVE</option>
                                    <option value="">ANY</option>
                                </select></td>
                        </tr>
                    </table>

                    <div id="divWitnessesRequests">
                        <table id='tblWitnessesRequests' class='display'>
                            <thead>
                                <tr>
                                    <th><b>Date</b></th>
                                    <th><b>Ref.No</b></th>
                                    <th><b>MemberNo</b></th>
                                    <th><b>Names</b></th>
                                    <th><b>Loan Type</b></th>
                                    <th><b>Loan Amount</b></th>
                                    <th><b>Status</b></th>
                                    <th><b>Respond</b></th>
                                    <th><b>Loan Request Status</b></th>
                                </tr>
                            </thead>
                            <tbody id='bdWitnessRequests'>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
</asp:Content>


