﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loan Application
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style>
        /* General Layout */
        body {
            background: #f4f6f8;
            font-family: Arial, sans-serif;
        }

        .dashboard-wrapper {
            padding: 20px;
        }

        .card {
            background: #fff;
            border-radius: 8px;
            border: 1px solid #ddd;
        }

        .card-header {
            background: #1e90ff !important;
            color: white;
            font-weight: bold;
            border-radius: 8px 8px 0 0;
        }

        /* Tabs */
        .nav-tabs .nav-link {
            border: none;
            border-bottom: 2px solid transparent;
            color: #444;
            font-weight: bold;
        }

        .nav-tabs .nav-link.active {
            border-bottom: 2px solid #1e90ff;
            color: #1e90ff;
        }

        /* Dotted-line input styling */
        .form-control,
        .form-select,
        textarea,
        input[type="number"],
        input[type="text"] {
            border: none !important;
            border-bottom: 1px dotted #000 !important;
            border-radius: 0 !important;
            background: transparent !important;
            padding: 4px 6px !important;
            box-shadow: none !important;
        }

        .form-control:focus,
        .form-select:focus {
            outline: none !important;
            box-shadow: none !important;
            border-bottom: 1px solid #1e90ff !important;
        }

        label {
            font-weight: bold;
            min-width: 150px;
        }

        .row.mb-3 {
            align-items: center;
        }

        /* Section titles */
        h6 {
            font-weight: bold;
            text-decoration: underline;
            margin-top: 20px;
        }

        /* Dotted containers */
        #divLoanProperties,
        #divAmountInWords,
        #divGuarantors,
        #divAttachments,
        #divSelectFiles,
        #divLoanApplicationList,
        #divLoanProgress,
        #divLoanDetails {
            border: 1px dotted #ccc !important;
            border-radius: 4px;
            background: #fafafa;
            padding: 8px;
        }

        /* Buttons */
        .btn {
            border-radius: 4px !important;
        }

        .btn-primary {
            background: #1e90ff !important;
            border-color: #1e90ff !important;
        }

        .btn-danger {
            background: #ff4d4d !important;
        }

        .btn-success {
            background: #28a745 !important;
        }

        .small.text-muted {
            font-size: 13px;
            color: #555 !important;
        }

        /* Guarantors and Attachments */
        #divGuarantors table, #divAttachments table {
            width: 100%;
            border-collapse: collapse;
        }

        #divGuarantors th, #divGuarantors td {
            border: 1px solid #ccc;
            padding: 6px;
            font-size: 14px;
        }

        /* Terms checkbox */
        .form-check-label a {
            color: #1e90ff;
            text-decoration: underline;
        }

        /* Dotted underline header mimic */
        .card-header h5 {
            text-decoration: underline;
            text-underline-offset: 3px;
        }
    </style>





    <script type="text/javascript">

        var hod_managers_list = null;

        var LoanTypeList = null;
        var MemberBalances = null;
        var MemberDetails = null;
        var AppliedLoanType = null;
        $(document).ready(function () {
            var loan_saving_scheme = "";
            var SavedLoanApplicationNumber = "";
            var bolNomineeRequired = true;

            var SASRASubSector2 = null;
            var SASRASubSector1 = null;
            var SASRAMainSectors = null;

            var ln_app_to_edit = null;
            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });

            $("#txtLoanAmount").on('change keyup paste mouseup', function () {
                $("#divAmountInWords").html("");
                try {
                    var amtToWords = toWords($("#txtLoanAmount").val());
                    amtToWords = toTitleCase(amtToWords);
                    $("#divAmountInWords").html(amtToWords);
                    CalcRepayAmount();
                } catch (err) {

                }
            });
            $("#txtRepaymentPeriod").on('change keyup paste mouseup', function () {
                CalcRepayAmount();
            });

            $('#btnAddFile').on('click', function (event) {
                $('#divSelectFiles').append('<div><input type="file" accept=".pdf,.doc,.docx,.jpeg,.jpg,.bmp"> <a href="#" id="lnkRemoveFile"> Remove File<a/></div>');
            });
            $('#divSelectFiles').on('click', 'a', function (event) {
                event.preventDefault();
                var parentDiv = $(this).closest('div');
                //var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                //var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove file?", "Confirm").then(function () {
                    parentDiv.remove();
                });
                return false;
            });

            $("#flAddFileToLoanApplication").on('change', function () {
                
                try {
                    //coz error will be thrown ( seems error is thrown in console only) if user cancels select file dialog
                    //var file = $(this).files[0]; will not work see members masterfile for alternative //https://stackoverflow.com/questions/19954073/whats-the-reason-that-document-getelementbyid-works-but-jquery-doesnt
                    var file = $(this)[0].files[0]; //https://stackoverflow.com/questions/19954073/whats-the-reason-that-document-getelementbyid-works-but-jquery-doesnt
                    var filename = file.name;
                    var filesize = file.size;
                    var filetype = file.type;
                    var maxFileMB = 5 * 1024 * 1024; //5MB
                    var filepath = $(this).val();

                    //alert("New File Selected " + filepath + " File Name " + filename + " Size MB " + filesize / (1024 * 1024) + " File Type " + filetype); //returns fake path!!
                    //return;
                    if (file) {
                        var postdata = new FormData();
                        var fileCount = 0;
                        postdata.append("MemberLoanApplicationFile" + fileCount, file, filename);

                        if (filesize > maxFileMB) {
                            DispUserError("Maximum file attachment for upload is 5MB. " + filename + " is " + filesize / 1024 / 1024 + " MB which exceeds the acceptable size.");
                            return;
                        }
                        //alert("Done Size is" + filesize);

                        postdata.append("LoanRefNo", ln_app_to_edit.LoanRefNo);
                        postdata.append("IsNewLoan", "N");
                        postdata.append("DBName", $("#cboApplicationYear").val()); // will force controller to use latest dbname


                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: "<%: Url.Content("~/api/MembersSystemApi/UploadMemberLoanApplicationFiles") %>",
                            contentType: false,
                            data: postdata,
                            processData: false,
                            success: function (data) {
                                alert("File Added");
                                DispAppliedLoanDocs(data);

                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                DispUserError('Error Uploading Files: - ' + errorMessage);
                            }
                        });

                    } else {
                        DispUserError("No File Selected");
                    }

                }
                catch (err) {
                    alert(err.message);
                    DispUserError(err.message);
                }
            });

            $('#divSelectFilesSavedLoan').on('click', 'a', function (event) {
                event.preventDefault();
                var parentDiv = $(this).closest('div');
                //var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                //var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove file?", "Confirm").then(function () {
                    parentDiv.remove();
                });
                return false;
            });

            $('#btnTestSaveFile').on('click', function () {
                //SaveFiles();
            });

            /*
            $("#tblLoanProperties").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            */

            /*
            $("#tblOffsets").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            */

            //$("#tblGuarantors").dataTable({
            //    "paging": false,
            //    "ordering": false,
            //    "info": false,
            //    "searching": false
            //});
            //$("#tblLoanApplicationList").dataTable({
            //    "paging": false,
            //    "ordering": false,
            //    "info": false,
            //    "searching": false
            //});

            //$("#tblLoanProgress").dataTable({
            //    "paging": false,
            //    "ordering": false,
            //    "info": false,
            //    "searching": false
            //});

            /*
            $("#tblSavedLoanGuarantors").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            */

            //$("#tblSavedAppliedLoanProperties").dataTable({
            //    "paging": false,
            //    "ordering": false,
            //    "info": false,
            //    "searching": false
            //});


            $('#bdGuarantors').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Guarantor Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    $(rm_row).remove();
                    AddNewGuarantorsTotals();
                });
                return false;
            });


            $("#cboLoanMainSector").on('change', function () {
                //alert($("#cboLoanMainSector").val());
                var filteredSectors = SASRASubSector1;
                if ($("#cboLoanMainSector").val() != "") {
                    filteredSectors = SASRASubSector1.filter(function (lnSector) {
                        return lnSector.MainSectorCode == $("#cboLoanMainSector").val();
                    });
                }
                $("#cboLoanSector1").empty();
                $("#cboLoanSector1").append('<option selected>(SELECT REASON FOR LOAN)</option>');
                $("#cboLoanSector2").empty();
                $("#cboLoanSector2").append('<option selected>(SELECT REASON FOR LOAN)</option>');
                $.each(filteredSectors, function (index, objSASRASubsector1) {
                    $("#cboLoanSector1").append("<option value='" + objSASRASubsector1.SubSector1Code + "'>" + objSASRASubsector1.SubSector1Name + "</option'>");
                });
            });
            $("#cboLoanSector1").on('change', function () {
                //alert($("#cboLoanMainSector").val());
                var filteredSectors = SASRASubSector2;
                if ($("#cboLoanSector1").val() != "") {
                    filteredSectors = SASRASubSector2.filter(function (lnSector) {
                        return lnSector.SubSector1Code == $("#cboLoanSector1").val();
                    });
                }
                $("#cboLoanSector2").empty();
                $("#cboLoanSector2").append('<option selected>(SELECT REASON FOR LOAN)</option>');
                $.each(filteredSectors, function (index, objSASRASubsector2) {
                    $("#cboLoanSector2").append("<option value='" + objSASRASubsector2.SubSector2Code + "'>" + objSASRASubsector2.SubSector2Name + "</option'>");
                });
            });

            $('#bdWitnesses').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Witness Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    $(rm_row).remove();
                });
                return false;
            });

            function DispAppliedLoanDocs(appliedLoanDocs) {
                var tbl_row = "";
                $("#tblSavedLoanAttachments > tbody:last").children().remove();
                var rootUrl = getRootUrl();
                //alert(rootUrl);
                //alert(global_site_root);
                $.each(appliedLoanDocs, function (index, lnDoc) {
                    tbl_row += "<tr>";
                    tbl_row += "<td><a target='_blank' href='" + global_site_root + "/Members/MembersSystem/GetMemberLoanApplicationFile?DBName=" + $("#cboApplicationYear").val() + "&LoanRefNo=" + ln_app_to_edit.LoanRefNo +"&DocID=" + lnDoc.DocID + "'>" + lnDoc.FileName + "</a></td>";
                    //tbl_row += "<td><a href='" + rootUrl + "Members/MembersSystem/GetMemberLoanApplicationFile?DBName=" + $("#cboApplicationYear").val() + "&LoanRefNo=" + ln_app_to_edit.LoanRefNo + "&DocID=" + lnDoc.DocID + "'>" + lnDoc.FileName + "</a></td>";
                    tbl_row += "<td style='display:none'>" + lnDoc.DocID + "</td>";
                    tbl_row += "<td><a href=''>Remove</a></td>";
                    tbl_row += "</tr>";
                });
                $("#bdSavedLoanAttachments").append(tbl_row);
            }


            $("#tblSavedLoanAttachments").on("click", "a", function (e) {
                e.preventDefault();
                var row = $(this).closest("tr");

                var col = $(this).closest("td");
                var col_index = col.index();
                //alert("col index is " + col_index + " col text is " + col.text()) ;

                //var firstCellValue = row.find("td").first().text();
                //alert(firstCellValue);
                //console.log(firstCellValue);
                if (col_index == 0)  //disp doc
                {
                    var docUrl = $(this).attr("href");
                    alert(editurl);
                    return false;
                } else if (col_index == 2) {  //remove saved doc

                    //var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                    //var rm_row = $(this).closest('tr');
                    var docurl = $(this).closest('tr').find('td').eq(0).find('a').attr("href");
                    var docid = $(this).closest('tr').find('td').eq(1).text();
                    var docUserFileName = $(this).closest('tr').find('td').eq(0).text();
                    //alert("File Name " + docUserFileName + " doc id " + docid);
                    //return;
                    xDialogConfirm("Remove file name " + docUserFileName + " from loan application number " + ln_app_to_edit.LoanRefNo + "?", "Confirm").then(function () { //TODO -security- ensure user file name is html encoded
                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        var outData = {
                            'DBName': $("#cboApplicationYear").val(),
                            'LoanRefNo': ln_app_to_edit.LoanRefNo,
                            'DocID': docid
                        }
                        
                        outData = JSON.stringify(outData);
                        

                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: "<%: Url.Content("~/api/MembersSystemApi/RemoveMemberLoanApplicationFile") %>",
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                DispAppliedLoanDocs(response);
                                //$(row).remove();
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                //alert('Error - ' + errorMessage);
                                DispUserError('Error - ' + errorMessage);
                            }
                        });
                    });
                    return false;
                }
            });

            $('#bdLoanApplicationList').on('click', 'tr', function (event) {
                var sel_row = $(this)
                $("#lblLoanRefNo").html("");
                var loan_ref_no = sel_row.find('td').eq(0).text();
                $("#lblLoanRefNo").html("<b>Loan Details for Ref No.: " + loan_ref_no + "</b><br/>");


                ln_app_to_edit = null;
                $('#bdLoanApplicationList tr').removeClass('row_selected');
                $(this).addClass('row_selected');

                $("#bdSavedLoanWitnesses > tbody:last").children().remove();
                $("#tblSavedLoanGuarantors > tbody:last").children().remove();
                $("#tblSavedFXDBalances > tbody:last").children().remove();
                $("#tblSavedOffsets > tbody:last").children().remove();
                $("#tblSavedAppliedLoanProperties > tbody:last").children().remove();
                $("#tblLoanProperties > tbody:last").children().remove();
                $("#tblSavedLoanWitnesses > tbody:last").children().remove();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboApplicationYear").val(),
                    'LoanRefNo': loan_ref_no
                }
                outData = JSON.stringify(outData);

                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanApplicationDetails") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {

                        ln_app_to_edit = response;
                        var row_datas = response.memberLoanApplicationGuarantor;
                        var tbl_row = "";
                        var savedFXDBalances = response.FXDBalances;
                        var savedOffsets = response.memberLoanApplicationOffset;
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.GuarantorMemberNo + "</td>";
                            tbl_row += "<td>" + row_data.GuarantorName + "</td>";
                            tbl_row += "<td>" + (+row_data.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.AcceptedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + row_data.GuarantorResponse + "</td>";
                            tbl_row += "<td>" + row_data.GuarantorNotes + "</td>";
                            tbl_row += "<td><a href=''>Remove</a></td>";

                            tbl_row += "</tr>";
                        });
                        $("#bdSavedLoanGuarantors").append(tbl_row);

                        DispAppliedLoanDocs(response.memberLoanApplicationDocs);


                        CalculateSavedGuarantorsTotals();

                        var tbl_row = "";
                        //below checkboxes disabled coz we dont support editing of saved FXD Amounts
                        $.each(savedFXDBalances, function (index, savedFXDBalance) {
                            tbl_row += "<tr><td><input type='checkbox' " + ((+savedFXDBalance.TransAmount) > 0 ? "checked" : "") + " disabled /></td><td>" + savedFXDBalance.BalType + "</td><td>" + savedFXDBalance.BalCode + "</td><td>" + savedFXDBalance.BalName + "</td><td>" + (+savedFXDBalance.BalAmount).formatMoney() + "</td><td><input type='text' value='" + savedFXDBalance.BalAmount + "' disabled /></td></tr>"
                        });
                        $("#bdSavedFXDBalances").append(tbl_row);

                        var tbl_row = "";
                        //below checkboxes disabled coz we dont support editing of saved Offsets
                        $.each(savedOffsets, function (index, savedOffset) {
                            tbl_row += "<tr><td><input type='checkbox' " + ((+savedOffset.Amount) > 0 ? "checked" : "") + " disabled /></td><td>" + savedOffset.OffsetType + "</td><td>" + savedOffset.LoanSerialNo + "</td><td>" + savedOffset.LN_LoanTypeName + "</td><td>" + (+savedOffset.LN_LoanBalance).formatMoney() + "</td><td><input type='text' value='" + savedOffset.Amount + "' disabled /></td></tr>"
                        });
                        $("#bdSavedOffsets").append(tbl_row);

                        row_datas = response.memberLoanApplicationWitness;
                        tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.WitnessMemberNo + "</td>";
                            tbl_row += "<td>" + row_data.WitnessNames + "</td>";
                            tbl_row += "<td>" + row_data.WitnessResponse + "</td>";
                            tbl_row += "<td>" + row_data.WitnessNotes + "</td>";
                            tbl_row += "<td>" + row_data.RequestDate + "</td>";
                            tbl_row += "<td>" + row_data.ResponseDate + "</td>";
                            tbl_row += "<td><a href=''>Remove</a></td>";

                            tbl_row += "</tr>";
                        });
                        $("#bdSavedLoanWitnesses").append(tbl_row);

                        row_datas = response.memberLoanApplication;
                        tbl_row = "";

                        tbl_row += "<tr>";
                        tbl_row += "<td>Payment Mode</td>";
                        tbl_row += "<td>" + row_datas.PaymentMode.toUpperCase() + "</td>";
                        tbl_row += "</tr>";

                        if (row_datas.PaymentMode.toLowerCase() == "BANK".toLowerCase()) {


                            tbl_row += "<tr>";
                            tbl_row += "<td>Bank Name</td>";
                            tbl_row += "<td>" + row_datas.BankName.toUpperCase() + "</td>";
                            tbl_row += "</tr>";

                            tbl_row += "<tr>";
                            tbl_row += "<td>Bank A/c: </td>";
                            tbl_row += "<td>" + row_datas.BankAccountNo.toUpperCase() + "</td>";
                            tbl_row += "</tr>";
                        } else if (row_datas.PaymentMode.toLowerCase() == "MOBILE".toLowerCase()) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>Mobile No:</td>";
                            tbl_row += "<td>" + row_datas.MobileNo.toUpperCase() + "</td>";
                            tbl_row += "</tr>";

                            tbl_row += "<tr>";
                            tbl_row += "<td>Mobile Provider:</td>";
                            tbl_row += "<td>" + row_datas.MobilePaymentType.toUpperCase() + "</td>";
                            tbl_row += "</tr>";
                        } else if (row_datas.PaymentMode.toLowerCase() == "FOSA".toLowerCase()) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>FOSA Account:</td>";
                            tbl_row += "<td>" + row_datas.FOSAAccount.toUpperCase() + "</td>";
                            tbl_row += "</tr>";

                        } else {
                            tbl_row += "<tr>";
                            tbl_row += "<td></td>";
                            tbl_row += "<td>Invalid Payment Details Provided</td>";
                            tbl_row += "</tr>";
                        }

                        tbl_row += "<tr>";
                        tbl_row += "<td>Reason Code</td>";
                        tbl_row += "<td>" + row_datas.SubSector2Code + "</td>";
                        tbl_row += "</tr>";

                        tbl_row += "<tr>";
                        tbl_row += "<td>Reason Name</td>";
                        tbl_row += "<td>" + row_datas.SubSector2Name + "</td>";
                        tbl_row += "</tr>";

                        tbl_row += "<tr>";
                        tbl_row += "<td>Manager Comments</td>";
                        tbl_row += "<td>" + row_datas.ManagerComments + "</td>";
                        tbl_row += "</tr>";

                        tbl_row += "<tr>";
                        tbl_row += "<td>Manager Response Date</td>";
                        tbl_row += "<td>" + row_datas.ManagerApprovalDate + "</td>";
                        tbl_row += "</tr>";

                        $("#bdSavedAppliedLoanProperties").append(tbl_row);


                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        //$("#txtErrorMessage").val('Error - ' + errorMessage);
                        //$("#txtErrorMessage").focus();
                        DispUserError('Error - ' + errorMessage);
                    }
                });

                return false;
            });

            $('#bdSavedLoanGuarantors').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Guarantor Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    var outData = {
                        'DBName': $("#cboApplicationYear").val(),
                        'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                        'GuarantorMemberNo': rm_memno
                    }
                    outData = JSON.stringify(outData);
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/MembersSystemApi/RemoveGuarantorFromMemberLoanApplication") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $(rm_row).remove();
                            CalculateSavedGuarantorsTotals();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            //alert('Error - ' + errorMessage);
                            DispUserError('Error - ' + errorMessage);
                        }
                    });
                });
                return false;
            });


            $('#bdSavedLoanWitnesses').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Witness Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    var outData = {
                        'DBName': $("#cboApplicationYear").val(),
                        'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                        'WitnessMemberNo': rm_memno
                    }
                    outData = JSON.stringify(outData);
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/MembersSystemApi/RemoveWitnessFromMemberLoanApplication") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $(rm_row).remove();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            //alert('Error - ' + errorMessage);
                            DispUserError('Error - ' + errorMessage);
                        }
                    });
                });
                return false;
            });

            InitForm();
            $("#btnListManagers").on('click', function () {
                xDialogSelectManager(hod_managers_list).then(function (data) {
                    $("#txtNormnieeUserID").val(data);
                    $("#txtNormnieeUserID").trigger('focusout');
                    $("#txtNormnieeUserID").focus();
                });
            });
            $("#txtNormnieeUserID").on("focusout", function () {
                $("#divNormineeName").html("");
                if ($("#txtNormnieeUserID").val().trim() != "") {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/MembersSystemApi/GetExternalUserName") %>",
                        data: JSON.stringify({ 'UserID': $("#txtNormnieeUserID").val() }),
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $("#divNormineeName").html(response);
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            //alert('Error - ' + errorMessage);
                            DispUserError('Error - ' + errorMessage);
                        }
                    });
                }
            });

            $("#cboLoanType").on('change', function () {
                AppliedLoanType = null;
                $("#tblLoanProperties > tbody:last").children().remove();
                loan_saving_scheme = "";
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var LoanType = LoanTypeList.filter(function (lnType) {
                    return lnType.LoanTypeCode == $("#cboLoanType").val();
                });
                if (LoanType.length > 0) {
                    AppliedLoanType = LoanType[0];
                    $("#txtRepaymentPeriod").val(AppliedLoanType.LoanMaxDuration);
                    var tbl_row = "";
                    loan_saving_scheme = AppliedLoanType.SchemeUsed;
                    tbl_row += "<tr><td>Loan Name</td><td>" + AppliedLoanType.LoanTypeName + "</td></tr>";
                    tbl_row += "<tr><td>Max Amount</td><td>" + (+AppliedLoanType.LoanMaxAmount).formatMoney() + "</td></tr>";
                    tbl_row += "<tr><td>Repayment Period in Months</td><td>" + AppliedLoanType.LoanMaxDuration + "</td></tr>";
                    tbl_row += "<tr><td>Interest Rate</td><td>" + AppliedLoanType.Percentage + " %</td></tr>";

                    tbl_row += "<tr><td>CanAlmagmateAll</td><td>" + (AppliedLoanType.CanAlmagmateAll ? "YES" : "NO") + "</td></tr>";
                    tbl_row += "<tr><td>CanBridgeItself</td><td>" + (AppliedLoanType.CanBridgeItself ? "YES" : "NO") + "</td></tr>";
                    $("#bdLoanProperties").append(tbl_row);
                    //var x = (AppliedLoanType.CanBridgeItself && !AppliedLoanType.CanAlmagmateAll).toString();
                    //alert(x);
                    //$("#divOnlyBridgeAllowed").html(x);


                    //Default to displaying all loans
                    var LoansToDisplayForOffset = MemberBalances.filter(function (lnType) {
                        return lnType.BalType.toString().toUpperCase() == "L".toUpperCase() || lnType.BalType.toString().toUpperCase() == "I".toUpperCase()
                    });


                    if (!AppliedLoanType.CanBridgeItself && !AppliedLoanType.CanAlmagmateAll) {
                        LoansToDisplayForOffset = null;
                    } else if (AppliedLoanType.CanAlmagmateAll) {
                        LoansToDisplayForOffset = LoansToDisplayForOffset;
                    } else if (AppliedLoanType.CanBridgeItself) {
                        //only display loans of the same type
                        LoansToDisplayForOffset = LoansToDisplayForOffset.filter(function (lnType) {
                            return lnType.BalCode.charAt(0).toUpperCase() == AppliedLoanType.LoanSerialIdentifier.toUpperCase()
                        });
                    }
                    $("#tblOffsets > tbody:last").children().remove();
                    if (LoansToDisplayForOffset != null) {
                        var tbl_row = "";
                        $.each(LoansToDisplayForOffset, function (index, LnOffset) {
                            tbl_row += "<tr><td><input type='checkbox' /></td><td>" + LnOffset.BalType + "</td><td>" + LnOffset.BalCode + "</td><td>" + LnOffset.BalName + "</td><td class='colamount'>" + (+LnOffset.BalAmount).formatMoney() + "</td><td><input type='text' class='colamount' value='" + LnOffset.BalAmount + "' disabled /></td></tr>"
                        });
                        $("#bdOffsets").append(tbl_row);
                    }
                    CalcRepayAmount();
                }

            });








            $("#cboApplicationYear").on('change', function () {
                GetMemberLoanApplicationsListing();
            });
            $("#cboProgressYear").on('change', function () {
                GetMemberLoansInProgress();
            });
            $("#cboLoanProgressStatus").on('change', function () {
                GetMemberLoansInProgress();
            });
            $("#btnProgressRefresh").on('click', function () {
                GetMemberLoansInProgress();
            });




            $("#btnRefresh").on('click', function () {
                GetMemberLoanApplicationsListing();
            });
            $("#btnCancel").on('click', function () {
                InitForm();
            });
            $("#btnAddGuarantor").on('click', function () {
                xDialogMemberAddGuarantor(loan_saving_scheme, null, null).then(function (data) {
                    var tbl_row = "<tr><td>" + data.GuarantorMemberNo + "</td><td>" + data.GuarantorNames + "</td><td class='colamount'>" + (+data.GuarantorAmount).formatMoney() + "</td><td><a href=''>Remove</a></td></tr>";
                    $("#bdGuarantors").append(tbl_row);
                    AddNewGuarantorsTotals();
                });
            });
            $("#btnAddWitness").on('click', function () {
                xDialogMemberAddWitness(null, null).then(function (data) {
                    var tbl_row = "<tr><td>" + data.WitnessMemberNo + "</td><td>" + data.WitnessNames + "</td><td><a href=''>Remove</a></td></tr>";
                    $("#bdWitnesses").append(tbl_row);
                });
            });
            $("#btnAddMoreGuarantor").on('click', function () {
                if (ln_app_to_edit == null) return;
                xDialogMemberAddGuarantor(ln_app_to_edit.LoanType.SchemeUsed, $("#cboApplicationYear").val(), ln_app_to_edit.LoanRefNo).then(function (data) {
                    if (data != null) {
                        var tbl_row = "<tr>";
                        tbl_row += "<td>" + data.GuarantorMemberNo + "</td>";
                        tbl_row += "<td>" + data.GuarantorNames + "</td>";
                        tbl_row += "<td>" + (+data.GuarantorAmount).formatMoney() + "</td>";
                        tbl_row += "<td>0.00</td>";
                        tbl_row += "<td>Pending</td>";
                        tbl_row += "<td></td>";
                        tbl_row += "<td><a href=''>Remove</a></td>";
                        tbl_row += "</tr>";
                        $("#bdSavedLoanGuarantors").append(tbl_row);
                    }
                });

            });

            $("#btnAddMoreWitness").on('click', function () {
                if (ln_app_to_edit == null) return;
                xDialogMemberAddWitness($("#cboApplicationYear").val(), ln_app_to_edit.LoanRefNo).then(function (data) {
                    if (data != null) {
                        var tbl_row = "<tr>";
                        tbl_row += "<td>" + data.WitnessMemberNo + "</td>";
                        tbl_row += "<td>" + data.WitnessNames + "</td>";
                        tbl_row += "<td>Pending</td>";
                        tbl_row += "<td></td>";
                        tbl_row += "<td></td>";
                        tbl_row += "<td></td>";
                        tbl_row += "<td><a href=''>Remove</a></td>";
                        tbl_row += "</tr>";
                        $("#bdSavedLoanWitnesses").append(tbl_row);
                    }
                });

            });

            $("#btnCancelApplication").on('click', function () {
                if (ln_app_to_edit == null) {
                    alert("Select Loan to cancel");
                    return;
                }
                xDialogConfirm("Are you sure you want to Cancel the selected loan application?<br/>Loan No=" + ln_app_to_edit.LoanRefNo + "<br/>Loan Type=" + ln_app_to_edit.LoanType.LoanTypeName + "<br/>Applied Amount " + (ln_app_to_edit.memberLoanApplication.RequestedAmount).formatMoney() + " ?", "Confirm").then(function () {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    var outData = {
                        'DBName': $("#cboApplicationYear").val(),
                        'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                    }
                    outData = JSON.stringify(outData);
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/MembersSystemApi/CancelMemberLoanApplication") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            GetMemberLoanApplicationsListing();
                            alert("Loan application  number " + ln_app_to_edit.LoanRefNo + " successfully cancelled");
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            //alert('Error - ' + errorMessage);
                            DispUserError('Error - ' + errorMessage);
                        }
                    });
                });
            });

            $("#btnSubmitLoanApplication").on('click', function () {
                if (ln_app_to_edit == null) {
                    alert("Select Loan to Submit");
                    return;
                }

                xDialogConfirm("Are you sure you want to Submit the selected loan application for processing?<br/>Loan No=" + ln_app_to_edit.LoanRefNo + "<br/>Loan Type=" + ln_app_to_edit.LoanType.LoanTypeName + "<br/>Applied Amount " + (ln_app_to_edit.memberLoanApplication.RequestedAmount).formatMoney() + " ?", "Confirm").then(function () {

                    xDialogMemberCredetials().then(function (data) {
                        SubmitLoanApplication(data);
                    });

                });
            });
            $("#chkLoanTOC").on('change', function (e) {
                $("#btnSave").prop('disabled', true);
                if ($(this).is(':checked')) {
                    $("#btnSave").prop('disabled', false);
                }
            });
            $("#cboPreferredPaymentMode").on('change', function () {
                $("#divFOSAAccounts").hide();
                $("#divBankDetails").hide();
                $("#divMobileDetails").hide();
                var prefPayMode = $("#cboPreferredPaymentMode option:selected").text();
                prefPayMode = prefPayMode.toString().toLowerCase();
                if (prefPayMode == "bank".toLowerCase()) $("#divBankDetails").show();
                if (prefPayMode == "fosa".toLowerCase()) $("#divFOSAAccounts").show();
                if (prefPayMode == "mobile".toLowerCase()) $("#divMobileDetails").show();

            });
            $("#btnSave").on('click', function () {
                if (document.getElementById("cboLoanType").selectedIndex == 0) {
                    //alert("Select Loan Type");
                    DispUserError("Select Loan Type");
                    return;
                }
                if (document.getElementById("cboPreferredPaymentMode").selectedIndex == 0) {
                    //alert("Select Loan Type");
                    DispUserError("Select Preferred Payment Mode");
                    return;
                }

                if (!isNumber(ConvertMoneyToDouble($("#txtLoanAmount").val()))) {
                    DispUserError("Invalid Amount");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRepaymentAmount").val()))) {
                    DispUserError("Invalid Repayment Amount");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRepaymentPeriod").val()))) {
                    DispUserError("Invalid Repayment Period");
                    return;
                }
                if ($("#txtSasraLoanPurpose").val() == "") {
                    DispUserError("Specify loan purpose");
                    return;
                }
                var fileCount = 0;
                var shouldSendFiles = true;
                $('#divSelectFiles input[type=file]').each(function () {
                    if (!window.FileReader) { // This is VERY unlikely, browser support is near-universal ( 30Apri2023 tested and working in Android WebView. Check File Size and File Type though)
                        DispUserError("Please update your browser");
                        return;
                    }
                    var file = $(this)[0].files[0]; //https://stackoverflow.com/questions/19954073/whats-the-reason-that-document-getelementbyid-works-but-jquery-doesnt
                    var maxFileMB = 5 * 1024 * 1024; //5MB
                    if (file) {
                        var filename = file.name;
                        var filesize = file.size;
                        //alert("File " + filename + " is " + file.size + " bytes in size");
                        if (filesize > maxFileMB) {
                            DispUserError("Maximum file attachment for upload is 5MB. " + filename + " is " + filesize / 1024 / 1024 + " MB which exceeds the acceptable size.");
                            shouldSendFiles = false;
                            return;
                        }
                        if (IsValidUploadFile(filename)) {
                            fileCount++;
                        } else {
                            DispUserError("Error - Invalid File:" + filename);
                            return;
                        }
                    } else {
                        //https://stackoverflow.com/questions/3717793/javascript-file-upload-size-validation
                        DispUserError("Please update your browser.")// This is VERY unlikely, browser support is near-universal
                        return;
                    }
                });
                if (shouldSendFiles) {
                    xDialogConfirm("Ensure you have attached all the necessary documents.\n " + fileCount + " file(s) will be attached. \n Confirm Loan Application<br/>Loan Type=" + $("#cboLoanType option:selected").text() + "<br/>Amount " + (ConvertMoneyToDouble($("#txtLoanAmount").val())).formatMoney() + " ?", "Confirm Loan Application...").then(function () {
                        xDialogMemberCredetials().then(function (data) {
                            SaveMemberLoanApplication(data);
                        });
                    });
                }
            });
            function SaveFiles() {
                var postdata = new FormData();
                var fileCount = 0;
                $('#divSelectFiles input[type=file]').each(function () {
                    var file = $(this)[0].files[0]; //https://stackoverflow.com/questions/19954073/whats-the-reason-that-document-getelementbyid-works-but-jquery-doesnt
                    if (file) {
                        filename = file.name;
                        //                        alert(filename);
                        if (IsValidUploadFile(filename)) {
                            var ext = filename.substring(filename.lastIndexOf('.') + 1).toLowerCase();
                            fileCount++;
                            postdata.append("MemberLoanApplicationFile" + fileCount, file, filename);
                        }
                    }
                });

                postdata.append("LoanRefNo", SavedLoanApplicationNumber);
                postdata.append("IsNewLoan", "Y");
                postdata.append("DBName", ""); // will force controller to use latest dbname
                if (+fileCount > 0) {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/MembersSystemApi/UploadMemberLoanApplicationFiles") %>",
                        contentType: false,
                        data: postdata,
                        processData: false,
                        success: function (messages) {
                            alert("File(s) Updated");
                            InitForm();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            DispUserError('Error Uploading Files: - ' + errorMessage);
                            InitForm(); //member to restart application or delete applied loan from system if we cannot attach required files
                        }
                    });
                } else {
                    InitForm();
                }
            }
            function IsValidUploadFile(filename) {


                if (filename.length < 1) {
                    alert("File Name cannot be empty"); return false;
                }


                var validExtensions = new Array();
                var ext = filename.substring(filename.lastIndexOf('.') + 1).toLowerCase();

                validExtensions[0] = 'jpg';
                validExtensions[1] = 'jpeg';
                validExtensions[2] = 'bmp';
                validExtensions[3] = 'png';
                validExtensions[4] = 'gif';
                validExtensions[5] = 'pdf';
                validExtensions[6] = 'doc';
                validExtensions[7] = 'docx';


                for (var i = 0; i < validExtensions.length; i++) {
                    if (ext == validExtensions[i]) return true;
                }

                alert('The file extension ' + ext.toUpperCase() + ' is not allowed!');
                return false;
            }
            function SubmitLoanApplication(credentials) {
                if (ln_app_to_edit == null) {
                    alert("Select Loan to Submit");
                    return;
                }
                var Password = credentials.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();

                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var outData = {
                    'DBName': $("#cboApplicationYear").val(),
                    'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                    'Password': sltpwd,
                    'Salt': pwdslt
                }



                outData = JSON.stringify(outData);

                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/SubmitMemberLoanApplication") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        GetMemberLoanApplicationsListing();
                        alert("Loan application  number " + ln_app_to_edit.LoanRefNo + " successfully submitted for processing");
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }
                });

            }

            function CalcRepayAmount() {
                $("#txtRepaymentAmount").val(0);
                if (AppliedLoanType == null) return;
                try {
                    var LoanAmount = $("#txtLoanAmount").val();
                    var RepayPeriod = $("#txtRepaymentPeriod").val();
                    var RepayAmt = 0;
                    if (AppliedLoanType.IsAmortized) {
                        console.log("Loan Is Amortized");
                        RepayAmt = GetAmortizedLoanRepayment(LoanAmount, AppliedLoanType.Percentage, RepayPeriod);
                    } else {
                        console.log("Loan Is Not Amortized");
                        RepayAmt = GetNonAmortizedLoanRepayment(LoanAmount, AppliedLoanType.Percentage, RepayPeriod);
                    }
                    RepayAmt = Math.round(RepayAmt);
                    $("#txtRepaymentAmount").val(RepayAmt.formatMoney());
                } catch (err) {
                    alert(err.message);
                }
            }
            function GetMemberLoanApplicationsListing() {


                $("#lblLoanRefNo").html("");
                $("#tblLoanApplicationList > tbody:last").children().remove();
                $("#tblSavedLoanGuarantors > tbody:last").children().remove();
                $("#tblSavedLoanWitnesses > tbody:last").children().remove();
                $("#tblSavedAppliedLoanProperties > tbody:last").children().remove();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboApplicationYear").val(),
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanApplicationsListing") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#tblLoanApplicationList > tbody:last").children().remove();
                        var row_datas = response;
                        var tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.LoanRefNo + "</td>";
                            tbl_row += "<td>" + row_data.LoanDate + "</td>";
                            tbl_row += "<td>" + row_data.LoanTypeName + "</td>";
                            tbl_row += "<td>" + (+row_data.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + row_data.ProcessStatus + "</td>";
                            tbl_row += "<td>" + row_data.ManagerApprovalStatus + "</td>";
                            tbl_row += "</tr>";
                        });
                        $("#bdLoanApplicationList").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }

                });
            }
            function GetMemberLoansInProgress() {
                $("#tblLoanProgress > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboProgressYear").val(),
                    'LoanStatus': $("#cboLoanProgressStatus").val()
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoansInProgress") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#tblLoanProgress > tbody:last").children().remove();
                        var row_datas = response;
                        var tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.LoanSerialNumber + "</td>";
                            tbl_row += "<td>" + row_data.OnlineApplicationNo + "</td>";
                            tbl_row += "<td>" + row_data.LoanDate + "</td>";
                            tbl_row += "<td>" + row_data.LoanTypeName + "</td>";
                            tbl_row += "<td>" + row_data.LoanStatus + "</td>";
                            tbl_row += "<td>" + (+row_data.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.RecommendedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.ApprovedAmount).formatMoney() + "</td>";
                            tbl_row += "<td><a href='" + row_data.LoanSerialNumber + "' class='approveLink'>" + row_data.MemberAcceptance + "</a></td>";
                            if (row_data.LoanStatus.toString().toLowerCase() == "approved".toLowerCase()) {
                                tbl_row += "<td><a href='/Members/MembersSystem/OfferLetter?DBName=" + $("#cboProgressYear").val() + "&LoanSerialNumber=" + row_data.LoanSerialNumber + "'>Offer Letter</a></td>";
                            } else {
                                tbl_row += "<td>N/A</td>";
                            }
                            tbl_row += "</tr>";
                        });
                        $("#bdLoanProgress").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }

                });
            }

            $('body').on('click', '.approveLink', function (e) {
                MemberAcceptRejectLoan(this);
                e.preventDefault();
                return false;
            });
            function MemberAcceptRejectLoan(approvelink) {

                var ApproveLoanSerialNumber = approvelink.getAttribute("href");
                var Criteria = {
                    "LoanSerialNumber": ApproveLoanSerialNumber,
                    "DBName": $("#cboProgressYear").val()
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetLoanDetails") %>",
                    data: JSON.stringify(Criteria),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        ProcessMemberLoanAcceptance(response);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }
                });
            }
            function AddNewGuarantorsTotals() {
                var GuarantorsRequestsTotals = +0;
                $("#spanGuarantorTotals").text(GuarantorsRequestsTotals.formatMoney());
                $("#bdGuarantors tr").each(function (i) {
                    var row = $(this);
                    var requestedAmt = ConvertMoneyToDouble(row.find('td:eq(2)').text());
                    GuarantorsRequestsTotals += requestedAmt;
                    $("#spanGuarantorTotals").text(GuarantorsRequestsTotals.formatMoney());
                });
            }
            function CalculateSavedGuarantorsTotals() {
                var GuarantorsRequestsTotals = +0;
                var GuarantorsAcceptedTotals = +0;
                var GuarantorCount = +0;
                var TotalRequested = +0;
                var TotalAcceptedCount = +0;

                $("#spanNoOfGuarantors").text("0");
                $("#spanGuarantorsAcceptedCount").text("0");
                $("#spanTotalGuarantorsRequested").text("0.00");
                $("#spanTotalGuarantorsAccepted").text("0.00");

                $("#bdSavedLoanGuarantors tr").each(function (i) {
                    GuarantorCount++;
                    var row = $(this);
                    var Amt = ConvertMoneyToDouble(row.find('td:eq(2)').text());
                    GuarantorsRequestsTotals += Amt;
                    Amt = ConvertMoneyToDouble(row.find('td:eq(3)').text());
                    GuarantorsAcceptedTotals += Amt;
                    var AcceptedStatus = row.find('td:eq(4)').text();
                    AcceptedStatus = String(AcceptedStatus);
                    if (AcceptedStatus === "Accepted") {
                        TotalAcceptedCount++;
                    }
                    $("#spanGuarantorTotals").text(GuarantorsRequestsTotals.formatMoney());

                    $("#spanNoOfGuarantors").text(GuarantorCount);
                    $("#spanGuarantorsAcceptedCount").text(TotalAcceptedCount);
                    $("#spanTotalGuarantorsRequested").text(GuarantorsRequestsTotals.formatMoney());
                    $("#spanTotalGuarantorsAccepted").text(GuarantorsAcceptedTotals.formatMoney());
                });
            }
            function ProcessMemberLoanAcceptance(LoanToApprove) {
                $('<div id="divApproveLoanDialog"></div>').dialog({
                    modal: true,
                    title: "Accept/Reject Loan",
                    height: 700,
                    width: 500,
                    autoOpen: true,
                    show: {
                        effect: "drop",
                        direction: "up",
                        duration: 500
                    },

                    buttons: {
                        'OK': {
                            'text': 'OK',
                            'id': 'btnOK',
                            'click': function () {
                                var ConfirmMessage = "";
                                if (document.getElementById("cboMemberResponse").selectedIndex == 0) {
                                    alert("Select Response");
                                    return;
                                }
                                ConfirmMessage = "Please confirm you want to " + $("#cboMemberResponse option:selected").text() + " this loan?";

                                xDialogConfirm(ConfirmMessage, "Confirm").then(function () {
                                    xDialogMemberCredetials().then(function (data) {
                                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                                        var Password = data.UserPass;
                                        var pwdslt = getRandomInt(1000, 30000);
                                        pwdslt = pwdslt.toString();
                                        var pwd = CryptoJS.MD5(Password).toString();
                                        pwd = pwd + pwdslt;
                                        var sltpwd = CryptoJS.MD5(pwd).toString();

                                        var outData = {
                                            'DBName': LoanToApprove.DBName,
                                            'MemberNo': LoanToApprove.mLoanAppraisals.MemberNumber,
                                            'LoanSerialNumber': LoanToApprove.LoanSerialNumber,
                                            'Response': $("#cboMemberResponse").val(),
                                            'Salt': pwdslt,
                                            'Password': sltpwd
                                        }
                                        outData = JSON.stringify(outData);
                                        $.ajax({
                                            headers: { __RequestVerificationToken: csrfToken },
                                            type: "POST",
                                            url: "<%: Url.Content("~/api/MembersSystemApi/ProcessMemberLoanResponse") %>",
                                            data: outData,
                                            contentType: "application/json; charset=utf-8",
                                            dataType: "json",
                                            success: function (response) {
                                                $("#tblLoanProgress tr").each(function (i) {
                                                    var row = $(this);
                                                    if (row.find('td:eq(1)').text() == LoanToApprove.LoanSerialNumber) {
                                                        row.find('td:eq(8)').html("<a href='" + LoanToApprove.LoanSerialNumber + "' class='approveLink'>" + $("#cboMemberResponse").val() + "</a>");

                                                    }
                                                });
                                                alert("Response successfully updated");
                                                $("#divApproveLoanDialog").dialog("close");

                                            },
                                            error: function (xhr, status, error) {
                                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                                //alert('Error - ' + errorMessage);
                                                DispUserError('Error - ' + errorMessage);
                                            }
                                        });
                                    });
                                });
                            }
                        },
                        Cancel: function () {
                            $(this).dialog("close");
                        }
                    },
                    open: function () {
                        var approved_amount = 0;
                        var recommended_amount = 0;
                        var repay_period = 1;

                        if (LoanToApprove.mAppraisalReport) {
                            recommended_amount = LoanToApprove.mAppraisalReport.RecommendedAmount;
                            repay_period = LoanToApprove.mAppraisalReport.RepaymentPeriod;
                        }
                        if (LoanToApprove.mApprovedLoans) {
                            approved_amount = LoanToApprove.mApprovedLoans.ApprovedAmount;
                            repay_period = LoanToApprove.mApprovedLoans.RepaymentPeriod;
                        }
                        var tbl = "<table id='tblApproveLoan' border=1>";
                        tbl += "<tbody>";
                        tbl += "<tr><td><b>Loan Serial Number:</b></td><td><input type='text' id='txtLoanSerialNumber' value='" + LoanToApprove.LoanSerialNumber + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loanee:</b></td><td><input type='text' id='txtLoaneeName' value='" + LoanToApprove.saccoMember.FullNames + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>MemberNo:</b></td><td><input type='text' id='txtLoaneeMemberNo' value='" + LoanToApprove.saccoMember.MemberNo + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>PayrollNo:</b></td><td><input type='text' id='txtLoaneePayrollNo' value='" + LoanToApprove.saccoMember.PayrollNo + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loan Type:</b></td><td><input type='text' id='txtLoanType' value='" + LoanToApprove.mLoanType.LoanTypeName + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Requested Amount:</b></td><td><input type='text' id='txtRequestedAmount' value='" + (+LoanToApprove.mLoanAppraisals.RequestedAmount).formatMoney() + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loan Status:</b></td><td><input type='text' id='txtLoanStatus' value='" + LoanToApprove.mLoanAppraisals.LoanStatus + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Recommended Amount</b></td><td><input type='text' id='txtRecommendedAmount' value='" + (+recommended_amount).formatMoney() + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Approved Amount</b></td><td><input type='text' id='txtApprovedAmount' value='" + (+approved_amount).formatMoney() + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Amt In Words:</b></td><td><div id='divAmountInWords' /></td></tr>";
                        tbl += "<tr><td><b>HR Ability:</b></td><td><input type='text' id='txtHRRepayAmt' value='" + LoanToApprove.mLoanAppraisals.HRRepayAmt + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>HR Approved:</b></td><td><input type='text' id='txtHRAbility' value='" + LoanToApprove.mLoanAppraisals.HRApproved + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Repayment Period:</b></td><td><input type='text' id='txtRepaymentPeriod' value='" + repay_period + "' /></td></tr>";
                        tbl += "<tr><td><b>Reponse:</b></td><td><select id='cboMemberResponse'><option value='' selected>(SELECT)</option><option value='accepted'>Accept</option><option value='rejected'>Reject</option></select></td></tr>";
                        tbl += "<tr><td><b>Notes/Reason:</b></td><td><textarea id='txtResponseReason' value='" + LoanToApprove.mLoanAppraisals.MemberAcceptanceComments + "' /></textarea></td></tr>";

                        tbl += "</tbody></table>";
                        $(this).html(tbl);
                        ShowAmtInWords();
                        $("#cboMemberResponse").focus;

                        function ShowAmtInWords() {
                            $("#divAmountInWords").html("");
                            try {
                                $("#divAmountInWords").html(toWords($("#txtApprovedAmount").val()));
                            } catch (err) {

                            }
                        }
                    },
                    close: function (event, ui) {
                        $(this).dialog("destroy").remove();
                    }
                });
            }

            function SaveMemberLoanApplication(credetials) {
                var LoanApplicationValid = true;
                var validCount = 0;
                var OffSetsList = new Array();
                var dblTotalAmount = 0;
                $("#tblOffsets tbody").find('tr').each(function (i) {
                    var OffSetEntry = {};
                    var row = $(this); //store in variable for faster access

                    OffSetEntry.BalType = row.find('td:eq(1)').text();
                    OffSetEntry.BalCode = row.find('td:eq(2)').text();
                    OffSetEntry.BalName = row.find('td:eq(3)').text();
                    OffSetEntry.BalAmount = row.find('td:eq(4)').text();
                    var txtAmt = row.find('td:eq(5)').find('input:eq(0)');


                    if (!isNumber(txtAmt.val())) {
                        LoanApplicationValid = false;
                        alert("Invalid offset amount at row " + i);
                        return;
                    }
                    var line_amount = txtAmt.val();
                    line_amount = +line_amount;
                    if (line_amount < 0) {
                        LoanApplicationValid = false;
                        alert("Offset Amount  " + line_amount + " should be more than or equal to Zero. At row " + i);
                        return;
                    }
                    if (row.find('input[type="checkbox"]').is(':checked')) {
                        if (line_amount > 0) {
                            dblTotalAmount = dblTotalAmount + line_amount;
                            OffSetEntry.TransAmount = line_amount;
                            OffSetsList[validCount] = OffSetEntry;
                            validCount++;
                        }
                    }
                });

                var validCount = 0;
                var FXDSecurityList = new Array();
                var dblTotalAmount = 0;
                $("#tblFXDBalances tbody").find('tr').each(function (i) {
                    var FXDSecurityEntry = {};
                    var row = $(this); //store in variable for faster access

                    FXDSecurityEntry.BalType = row.find('td:eq(1)').text();
                    FXDSecurityEntry.BalCode = row.find('td:eq(2)').text();
                    FXDSecurityEntry.BalName = row.find('td:eq(3)').text();
                    FXDSecurityEntry.BalAmount = row.find('td:eq(4)').text();
                    var txtAmt = row.find('td:eq(5)').find('input:eq(0)');


                    if (!isNumber(txtAmt.val())) {
                        LoanApplicationValid = false;
                        alert("Invalid FXD Amount amount at row " + i);
                        return;
                    }
                    var line_amount = txtAmt.val();
                    line_amount = +line_amount;
                    if (line_amount < 0) {
                        LoanApplicationValid = false;
                        alert("FXD Amount  " + line_amount + " should be more than or equal to Zero. At row " + i);
                        return;
                    }
                    if (row.find('input[type="checkbox"]').is(':checked')) {
                        if (line_amount > 0) {
                            dblTotalAmount = dblTotalAmount + line_amount;
                            FXDSecurityEntry.TransAmount = line_amount;
                            FXDSecurityList[validCount] = FXDSecurityEntry;
                            validCount++;
                        }
                    }
                });

                var GuarantorsList = new Array();
                var dblTotalAmount = 0;

                $("#tblGuarantors tbody").find('tr').each(function (i) {
                    var GuarantorEntry = {};
                    var row = $(this); //store in variable for faster access
                    GuarantorEntry.LoanSerialNumber = "";
                    GuarantorEntry.GuarantorMemberNumber = row.find('td:eq(0)').text();

                    var GuarantorAmt = row.find('td:eq(2)').text();

                    if (!isNumber(GuarantorAmt)) { //contains commas at this point
                        LoanApplicationValid = false;
                        alert("Invalid Guarantor amount " + GuarantorAmt + " at row " + i);
                        return;
                    }
                    GuarantorAmt = ConvertMoneyToDouble(GuarantorAmt);
                    var line_amount = GuarantorAmt;
                    line_amount = +line_amount;
                    if (line_amount <= 0) {
                        LoanApplicationValid = false;
                        alert("Guarantor's Amount " + line_amount + " should be more than Zero. At row " + i);
                        return;
                    }


                    GuarantorEntry.SharesToCommit = line_amount;
                    GuarantorsList[i] = GuarantorEntry;


                });

                var WitnessesList = new Array();
                var dblTotalAmount = 0;

                $("#tblWitnesses tbody").find('tr').each(function (i) {
                    var WitnessesEntry = {};
                    var row = $(this); //store in variable for faster access
                    var WitnessMemberNo = row.find('td:eq(0)').text();
                    WitnessesList[i] = WitnessMemberNo;

                });
                if ($("#txtSasraReasonCode").val() == "") {
                    LoanApplicationValid = false;
                    alert("Specify reason/purpose for loan");
                }
                if (LoanApplicationValid == false) {
                    return;
                }
                var Password = credetials.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var outData = {
                    'Guarantors': GuarantorsList,
                    'Witnesses': WitnessesList,
                    'OffSets': OffSetsList,
                    'FXDSecurityList': FXDSecurityList,
                    'LoanTypeCode': $("#cboLoanType").val(),
                    'LoanAmount': $("#txtLoanAmount").val(),
                    'RepaymentPeriod': $("#txtRepaymentPeriod").val(),
                    'LoanPurpose': $("#txtLoanPurpose").val(),
                    'SasraReason2Code': $("#txtSasraReasonCode").val(),

                    'PaymentMode': $("#cboPreferredPaymentMode").val(),
                    'MobilePaymentType': $("#cboMobileProvider").val(),
                    'FOSAAccount': $("#cboFOSAAccount").val(),
                    'BankName': $("#lblBankName").text(),
                    'BankAccountNo': $("#lblBankAccNo").text(),
                    'MobileNo': $("#lblPhoneNo").text(),




                    'Instructions': $("#txtInstructions").val(),
                    'NormineeUserID': $("#txtNormnieeUserID").val(),
                    'Password': sltpwd,
                    'Salt': pwdslt
                }
                //https://www.w3schools.com/js/js_json_stringify.asp
                var objToString = JSON.stringify(outData, null, 4);
                //console.log(objToString);
                outData = JSON.stringify(outData);


                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/SaveMemberLoanApplication") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {

                        alert("Loan Application Saved Successfully. Uploading files...");
                        SavedLoanApplicationNumber = response;

                        SaveFiles();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }

                });

            }
            $('#tabs').on('tabsactivate', function (event, ui) {//jquery
                var newIndex = ui.newTab.index();
                if (newIndex == 1) {
                    GetMemberLoanApplicationsListing();
                } else if (newIndex == 2) {
                    GetMemberLoansInProgress();
                }
            });
            $('#tabs').on('tabs-activate', function (e, activeTab) {//jquery-responsive-tabs
                var newTabId = activeTab.id
                if (newTabId == 1) {
                    GetMemberLoanApplicationsListing();
                } else if (newTabId == 2) {
                    GetMemberLoansInProgress();
                }
            });
            $("#btnTab2").on('click', function (e) {
                $('#tabs').responsiveTabs('activate', 1);
            });

            $("#btnSearchSasra").on('click', function (e) {
                e.preventDefault();
                xDialogSearchLoanPurpose(SASRASubSector2).then(function (data) {
                    //alert(data.Reason2Code + " " + data.Reason2Name);
                    $("#cboLoanMainSector").prop('selectedIndex', 0);
                    $("#cboLoanSector1").prop('selectedIndex', 0);
                    $("#cboLoanSector2").prop('selectedIndex', 0);

                    $("#cboLoanMainSector").val(data.MainReasonCode);
                    $("#cboLoanSector1").val(data.Reason1Code);
                    $("#cboLoanSector2").val(data.Reason2Code);

                    $("#txtSasraLoanPurpose").val(data.Reason2Name);
                    $("#txtSasraReasonCode").val(data.Reason2Code);

                });
            });
            function InitForm() {

                $("#cboLoanType").empty();
                $("#cboFOSAAccount").empty();
                $("#txtLoanAmount").val(0.00);
                $("#txtRepaymentPeriod").val(0.00);
                $("#txtRepaymentAmount").val(0.00);
                $("#txtInstructions").val("");
                $("#txtLoanPurpose").val("");
                $("#txtSasraLoanPurpose").val("");
                $("#txtSasraReasonCode").val("");
                $("#txtNormnieeUserID").val("");
                $("#cboApplicationYear").empty();
                $("#cboProgressYear").empty();
                $("#tblLoanProperties > tbody:last").children().remove();
                $("#tblOffsets > tbody:last").children().remove();
                $("#tblFXDBalances > tbody:last").children().remove();
                $("#tblGuarantors > tbody:last").children().remove();
                $("#tblWitnesses > tbody:last").children().remove();
                $("#tblLoanApplicationList > tbody:last").children().remove();

                $("#tblSavedLoanGuarantors > tbody:last").children().remove();
                $("#tblSavedLoanWitnesses > tbody:last").children().remove();
                $("#divSelectFiles").empty();
                $("#divAmountInWords").empty();
                $("#tblMemberBalances > tbody:last").children().remove();

                AddNewGuarantorsTotals();

                $("#cboPreferredPaymentMode").prop('selectedIndex', 0);
                $("#divFOSAAccounts").hide();
                $("#divBankDetails").hide();
                $("#divMobileDetails").hide();

                $('#chkLoanTOC').prop('checked', false);


                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanApplicationConfig") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        MemberDetails = response.MemberDetails;
                        $("#lblPhoneNo").text(MemberDetails.PhoneNo);
                        $("#lblBankName").text(MemberDetails.MainBankName);
                        $("#lblBankAccNo").text(MemberDetails.AccountNo);
                        LoanTypeList = response.LoanTypes;
                        MemberBalances = response.MemberBalances.MemberBals;
                        var Years = response.Years;
                        SASRASubSector2 = response.SASRASubsector2;
                        SASRASubSector1 = response.SASRASubsector1;
                        SASRAMainSectors = response.SASRAMainSectors;
                        bolNomineeRequired = response.NomineeRequired;
                        FXD_Balances = response.FXD_Balances
                        var FOSAAccounts = response.FOSAAccounts;
                        //console.log(SASRASubSector2);
                        //console.log(SASRASubSector1);
                        //console.log(SASRAMainSectors);
                        //console.log(response.NomineeRequired);
                        //console.log(typeof response.NomineeRequired);
                        //console.log(MemberDetails.Surname);
                        //console.log(typeof MemberDetails.Surname);

                        //bolNomineeRequired = (bolNomineeRequired === "True" || bolNomineeRequired === "true" || bolNomineeRequired === true);
                        //console.log(bolNomineeRequired);
                        if (bolNomineeRequired) {
                            //console.log("bolNomineeRequired is True ");

                        } else {
                            //console.log("bolNomineeRequired is False ");
                            $("#trNormineeID").hide();
                            $("#trNormineeName").hide();
                        }
                        hod_managers_list = response.Managers;

                        $("#cboFOSAAccount").append('<option value="" selected>(SELECT)</option>');
                        $.each(FOSAAccounts, function (index, objFOSAAcc) {
                            $("#cboFOSAAccount").append("<option value='" + objFOSAAcc.AccountNo + "'>" + objFOSAAcc.AccountNo + "(" + objFOSAAcc.AccountName + ")" + "</option'>");
                        });
                        var PayModes = response.PaymentModes;
                        $("#cboPreferredPaymentMode").empty();
                        $("#cboPreferredPaymentMode").append('<option value="" selected>(SELECT)</option>');

                        $.each(PayModes, function (index, objPayMode) {
                            $("#cboPreferredPaymentMode").append("<option value='" + objPayMode + "'>" + objPayMode + "</option'>");
                        });
                        $("#cboLoanType").empty();
                        $("#cboApplicationYear").empty();

                        $("#cboLoanType").append('<option selected>(SELECT LOAN TYPE)</option>');

                        $("#cboLoanSector2").empty();
                        $("#cboLoanSector2").append('<option value="" selected>(SELECT REASON FOR LOAN)</option>');
                        $.each(SASRASubSector2, function (index, objSASRASubsector2) {
                            $("#cboLoanSector2").append("<option value='" + objSASRASubsector2.SubSector2Code + "'>" + objSASRASubsector2.SubSector2Name + "</option'>");
                        });
                        $("#cboLoanSector1").empty();
                        $("#cboLoanSector1").append('<option value="" selected>(SELECT REASON FOR LOAN)</option>');
                        $.each(SASRASubSector1, function (index, objSASRASubsector1) {
                            $("#cboLoanSector1").append("<option value='" + objSASRASubsector1.SubSector1Code + "'>" + objSASRASubsector1.SubSector1Name + "</option'>");
                        });
                        $("#cboLoanMainSector").empty();
                        $("#cboLoanMainSector").append('<option value="" selected>(SELECT REASON FOR LOAN)</option>');
                        $.each(SASRAMainSectors, function (index, objSASRAMainSector) {
                            $("#cboLoanMainSector").append("<option value='" + objSASRAMainSector.MainSectorCode + "'>" + objSASRAMainSector.MainSectorName + "</option'>");
                        });

                        $.each(LoanTypeList, function (index, LoanType) {
                            $("#cboLoanType").append("<option value='" + LoanType.LoanTypeCode + "'>" + LoanType.LoanTypeName + "</option'>");
                        });

                        var tbl_row = "";
                        $.each(MemberBalances, function (index, MemberBalance) {
                            if (MemberBalance.BalType.toString().toUpperCase() == "L".toUpperCase() || MemberBalance.BalType.toString().toUpperCase() == "I".toUpperCase()) {
                                tbl_row += "<tr><td><input type='checkbox' /></td><td>" + MemberBalance.BalType + "</td><td>" + MemberBalance.BalCode + "</td><td>" + MemberBalance.BalName + "</td><td>" + (+MemberBalance.BalAmount).formatMoney() + "</td><td><input type='text' value='" + MemberBalance.BalAmount + "' disabled /></td></tr>"
                            }
                        });
                        $("#bdOffsets").append(tbl_row);

                        var tbl_row = "";
                        $.each(FXD_Balances, function (index, MemberBalance) {
                            tbl_row += "<tr><td><input type='checkbox' /></td><td>" + MemberBalance.BalType + "</td><td>" + MemberBalance.BalCode + "</td><td>" + MemberBalance.BalName + "</td><td>" + (+MemberBalance.BalAmount).formatMoney() + "</td><td><input type='text' value='" + MemberBalance.BalAmount + "' disabled /></td></tr>"
                        });
                        $("#bdFXDBalances").append(tbl_row);

                        $.each(Years, function (index, yr) {
                            $("#cboApplicationYear").append("<option value='" + yr.DBName + "' selected>" + yr.UserDefinedYearName + "</option'>");
                        });
                        $("#cboApplicationYear").get(0).selectedIndex = 0;
                        $.each(Years, function (index, yr) {
                            $("#cboProgressYear").append("<option value='" + yr.DBName + "' selected>" + yr.UserDefinedYearName + "</option'>");
                        });
                        $("#cboProgressYear").get(0).selectedIndex = 0;
                        $("#cboProgressYear").get(0).selectedIndex = 0; //first $("#cboProgressYear").get(0).selectedIndex = 0; not working
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);

                    }
                });
            }



            /*
            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
            */

            $('#tabs').responsiveTabs({
                // Start with the panels collapsed if the view is currently accordion based
                startCollapsed: 'accordion',
                // Tabs can be collapsed
                collapsible: true,
                // Tabs auto rotate
                rotate: false
            });

        });
    </script>
</asp:Content>



<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loan Application
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        #tblSasraLoanSectors tr.header, #tblSasraLoanSectors tr:hover {
            /* Add a grey background color to the table header and on hover */
            background-color: #f1f1f1;
        }

        .tblDRCRDetails {
            margin: 1px;
            border: 1em;
            padding-left: 1em;
            padding-top: 1em;
            border-collapse: separate;
        }

        /*use this for to calculate totals*/
        .colamount {
            text-align: right;
        }

        .td_amount_col {
            text-align: right;
        }

        tr.row_selected td {
            background-color: lawngreen;
        }
    </style>


    <script type="text/javascript">

        var hod_managers_list = null;

        var LoanTypeList = null;
        var MemberBalances = null;
        var MemberDetails = null;
        var AppliedLoanType = null;
        $(document).ready(function () {
            var loan_saving_scheme = "";
            var SavedLoanApplicationNumber = "";
            var bolNomineeRequired = true;

            var SASRASubSector2 = null;
            var SASRASubSector1 = null;
            var SASRAMainSectors = null;

            var ln_app_to_edit = null;
            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });

            $("#txtLoanAmount").on('change keyup paste mouseup', function () {
                $("#divAmountInWords").html("");
                try {
                    var amtToWords = toWords($("#txtLoanAmount").val());
                    amtToWords = toTitleCase(amtToWords);
                    $("#divAmountInWords").html(amtToWords);
                    CalcRepayAmount();
                } catch (err) {

                }
            });
            $("#txtRepaymentPeriod").on('change keyup paste mouseup', function () {
                CalcRepayAmount();
            });

            $('#btnAddFile').on('click', function (event) {
                $('#divSelectFiles').append('<div><input type="file" accept=".pdf,.doc,.docx,.jpeg,.jpg,.bmp"> <a href="#" id="lnkRemoveFile"> Remove File<a/></div>');
            });
            $('#divSelectFiles').on('click', 'a', function (event) {
                event.preventDefault();
                var parentDiv = $(this).closest('div');
                //var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                //var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove file?", "Confirm").then(function () {
                    parentDiv.remove();
                });
                return false;
            });

            $("#flAddFileToLoanApplication").on('change', function () {
                
                try {
                    //coz error will be thrown ( seems error is thrown in console only) if user cancels select file dialog
                    //var file = $(this).files[0]; will not work see members masterfile for alternative //https://stackoverflow.com/questions/19954073/whats-the-reason-that-document-getelementbyid-works-but-jquery-doesnt
                    var file = $(this)[0].files[0]; //https://stackoverflow.com/questions/19954073/whats-the-reason-that-document-getelementbyid-works-but-jquery-doesnt
                    var filename = file.name;
                    var filesize = file.size;
                    var filetype = file.type;
                    var maxFileMB = 5 * 1024 * 1024; //5MB
                    var filepath = $(this).val();

                    //alert("New File Selected " + filepath + " File Name " + filename + " Size MB " + filesize / (1024 * 1024) + " File Type " + filetype); //returns fake path!!
                    //return;
                    if (file) {
                        var postdata = new FormData();
                        var fileCount = 0;
                        postdata.append("MemberLoanApplicationFile" + fileCount, file, filename);

                        if (filesize > maxFileMB) {
                            DispUserError("Maximum file attachment for upload is 5MB. " + filename + " is " + filesize / 1024 / 1024 + " MB which exceeds the acceptable size.");
                            return;
                        }
                        //alert("Done Size is" + filesize);

                        postdata.append("LoanRefNo", ln_app_to_edit.LoanRefNo);
                        postdata.append("IsNewLoan", "N");
                        postdata.append("DBName", $("#cboApplicationYear").val()); // will force controller to use latest dbname


                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: "<%: Url.Content("~/api/MembersSystemApi/UploadMemberLoanApplicationFiles") %>",
                            contentType: false,
                            data: postdata,
                            processData: false,
                            success: function (data) {
                                alert("File Added");
                                DispAppliedLoanDocs(data);

                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                DispUserError('Error Uploading Files: - ' + errorMessage);
                            }
                        });

                    } else {
                        DispUserError("No File Selected");
                    }

                }
                catch (err) {
                    alert(err.message);
                    DispUserError(err.message);
                }
            });

            $('#divSelectFilesSavedLoan').on('click', 'a', function (event) {
                event.preventDefault();
                var parentDiv = $(this).closest('div');
                //var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                //var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove file?", "Confirm").then(function () {
                    parentDiv.remove();
                });
                return false;
            });

            $('#btnTestSaveFile').on('click', function () {
                //SaveFiles();
            });

            /*
            $("#tblLoanProperties").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            */

            /*
            $("#tblOffsets").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            */

            //$("#tblGuarantors").dataTable({
            //    "paging": false,
            //    "ordering": false,
            //    "info": false,
            //    "searching": false
            //});
            //$("#tblLoanApplicationList").dataTable({
            //    "paging": false,
            //    "ordering": false,
            //    "info": false,
            //    "searching": false
            //});

            //$("#tblLoanProgress").dataTable({
            //    "paging": false,
            //    "ordering": false,
            //    "info": false,
            //    "searching": false
            //});

            /*
            $("#tblSavedLoanGuarantors").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            */

            //$("#tblSavedAppliedLoanProperties").dataTable({
            //    "paging": false,
            //    "ordering": false,
            //    "info": false,
            //    "searching": false
            //});


            $('#bdGuarantors').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Guarantor Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    $(rm_row).remove();
                    AddNewGuarantorsTotals();
                });
                return false;
            });


            $("#cboLoanMainSector").on('change', function () {
                //alert($("#cboLoanMainSector").val());
                var filteredSectors = SASRASubSector1;
                if ($("#cboLoanMainSector").val() != "") {
                    filteredSectors = SASRASubSector1.filter(function (lnSector) {
                        return lnSector.MainSectorCode == $("#cboLoanMainSector").val();
                    });
                }
                $("#cboLoanSector1").empty();
                $("#cboLoanSector1").append('<option selected>(SELECT REASON FOR LOAN)</option>');
                $("#cboLoanSector2").empty();
                $("#cboLoanSector2").append('<option selected>(SELECT REASON FOR LOAN)</option>');
                $.each(filteredSectors, function (index, objSASRASubsector1) {
                    $("#cboLoanSector1").append("<option value='" + objSASRASubsector1.SubSector1Code + "'>" + objSASRASubsector1.SubSector1Name + "</option'>");
                });
            });
            $("#cboLoanSector1").on('change', function () {
                //alert($("#cboLoanMainSector").val());
                var filteredSectors = SASRASubSector2;
                if ($("#cboLoanSector1").val() != "") {
                    filteredSectors = SASRASubSector2.filter(function (lnSector) {
                        return lnSector.SubSector1Code == $("#cboLoanSector1").val();
                    });
                }
                $("#cboLoanSector2").empty();
                $("#cboLoanSector2").append('<option selected>(SELECT REASON FOR LOAN)</option>');
                $.each(filteredSectors, function (index, objSASRASubsector2) {
                    $("#cboLoanSector2").append("<option value='" + objSASRASubsector2.SubSector2Code + "'>" + objSASRASubsector2.SubSector2Name + "</option'>");
                });
            });

            $('#bdWitnesses').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Witness Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    $(rm_row).remove();
                });
                return false;
            });

            function DispAppliedLoanDocs(appliedLoanDocs) {
                var tbl_row = "";
                $("#tblSavedLoanAttachments > tbody:last").children().remove();
                var rootUrl = getRootUrl();
                //alert(rootUrl);
                //alert(global_site_root);
                $.each(appliedLoanDocs, function (index, lnDoc) {
                    tbl_row += "<tr>";
                    tbl_row += "<td><a target='_blank' href='" + global_site_root + "/Members/MembersSystem/GetMemberLoanApplicationFile?DBName=" + $("#cboApplicationYear").val() + "&LoanRefNo=" + ln_app_to_edit.LoanRefNo +"&DocID=" + lnDoc.DocID + "'>" + lnDoc.FileName + "</a></td>";
                    //tbl_row += "<td><a href='" + rootUrl + "Members/MembersSystem/GetMemberLoanApplicationFile?DBName=" + $("#cboApplicationYear").val() + "&LoanRefNo=" + ln_app_to_edit.LoanRefNo + "&DocID=" + lnDoc.DocID + "'>" + lnDoc.FileName + "</a></td>";
                    tbl_row += "<td style='display:none'>" + lnDoc.DocID + "</td>";
                    tbl_row += "<td><a href=''>Remove</a></td>";
                    tbl_row += "</tr>";
                });
                $("#bdSavedLoanAttachments").append(tbl_row);
            }


            $("#tblSavedLoanAttachments").on("click", "a", function (e) {
                e.preventDefault();
                var row = $(this).closest("tr");

                var col = $(this).closest("td");
                var col_index = col.index();
                //alert("col index is " + col_index + " col text is " + col.text()) ;

                //var firstCellValue = row.find("td").first().text();
                //alert(firstCellValue);
                //console.log(firstCellValue);
                if (col_index == 0)  //disp doc
                {
                    var docUrl = $(this).attr("href");
                    alert(editurl);
                    return false;
                } else if (col_index == 2) {  //remove saved doc

                    //var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                    //var rm_row = $(this).closest('tr');
                    var docurl = $(this).closest('tr').find('td').eq(0).find('a').attr("href");
                    var docid = $(this).closest('tr').find('td').eq(1).text();
                    var docUserFileName = $(this).closest('tr').find('td').eq(0).text();
                    //alert("File Name " + docUserFileName + " doc id " + docid);
                    //return;
                    xDialogConfirm("Remove file name " + docUserFileName + " from loan application number " + ln_app_to_edit.LoanRefNo + "?", "Confirm").then(function () { //TODO -security- ensure user file name is html encoded
                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        var outData = {
                            'DBName': $("#cboApplicationYear").val(),
                            'LoanRefNo': ln_app_to_edit.LoanRefNo,
                            'DocID': docid
                        }
                        
                        outData = JSON.stringify(outData);
                        

                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: "<%: Url.Content("~/api/MembersSystemApi/RemoveMemberLoanApplicationFile") %>",
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                DispAppliedLoanDocs(response);
                                //$(row).remove();
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                //alert('Error - ' + errorMessage);
                                DispUserError('Error - ' + errorMessage);
                            }
                        });
                    });
                    return false;
                }
            });

            $('#bdLoanApplicationList').on('click', 'tr', function (event) {
                var sel_row = $(this)
                $("#lblLoanRefNo").html("");
                var loan_ref_no = sel_row.find('td').eq(0).text();
                $("#lblLoanRefNo").html("<b>Loan Details for Ref No.: " + loan_ref_no + "</b><br/>");


                ln_app_to_edit = null;
                $('#bdLoanApplicationList tr').removeClass('row_selected');
                $(this).addClass('row_selected');

                $("#bdSavedLoanWitnesses > tbody:last").children().remove();
                $("#tblSavedLoanGuarantors > tbody:last").children().remove();
                $("#tblSavedFXDBalances > tbody:last").children().remove();
                $("#tblSavedOffsets > tbody:last").children().remove();
                $("#tblSavedAppliedLoanProperties > tbody:last").children().remove();
                $("#tblLoanProperties > tbody:last").children().remove();
                $("#tblSavedLoanWitnesses > tbody:last").children().remove();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboApplicationYear").val(),
                    'LoanRefNo': loan_ref_no
                }
                outData = JSON.stringify(outData);

                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanApplicationDetails") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {

                        ln_app_to_edit = response;
                        var row_datas = response.memberLoanApplicationGuarantor;
                        var tbl_row = "";
                        var savedFXDBalances = response.FXDBalances;
                        var savedOffsets = response.memberLoanApplicationOffset;
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.GuarantorMemberNo + "</td>";
                            tbl_row += "<td>" + row_data.GuarantorName + "</td>";
                            tbl_row += "<td>" + (+row_data.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.AcceptedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + row_data.GuarantorResponse + "</td>";
                            tbl_row += "<td>" + row_data.GuarantorNotes + "</td>";
                            tbl_row += "<td><a href=''>Remove</a></td>";

                            tbl_row += "</tr>";
                        });
                        $("#bdSavedLoanGuarantors").append(tbl_row);

                        DispAppliedLoanDocs(response.memberLoanApplicationDocs);


                        CalculateSavedGuarantorsTotals();

                        var tbl_row = "";
                        //below checkboxes disabled coz we dont support editing of saved FXD Amounts
                        $.each(savedFXDBalances, function (index, savedFXDBalance) {
                            tbl_row += "<tr><td><input type='checkbox' " + ((+savedFXDBalance.TransAmount) > 0 ? "checked" : "") + " disabled /></td><td>" + savedFXDBalance.BalType + "</td><td>" + savedFXDBalance.BalCode + "</td><td>" + savedFXDBalance.BalName + "</td><td>" + (+savedFXDBalance.BalAmount).formatMoney() + "</td><td><input type='text' value='" + savedFXDBalance.BalAmount + "' disabled /></td></tr>"
                        });
                        $("#bdSavedFXDBalances").append(tbl_row);

                        var tbl_row = "";
                        //below checkboxes disabled coz we dont support editing of saved Offsets
                        $.each(savedOffsets, function (index, savedOffset) {
                            tbl_row += "<tr><td><input type='checkbox' " + ((+savedOffset.Amount) > 0 ? "checked" : "") + " disabled /></td><td>" + savedOffset.OffsetType + "</td><td>" + savedOffset.LoanSerialNo + "</td><td>" + savedOffset.LN_LoanTypeName + "</td><td>" + (+savedOffset.LN_LoanBalance).formatMoney() + "</td><td><input type='text' value='" + savedOffset.Amount + "' disabled /></td></tr>"
                        });
                        $("#bdSavedOffsets").append(tbl_row);

                        row_datas = response.memberLoanApplicationWitness;
                        tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.WitnessMemberNo + "</td>";
                            tbl_row += "<td>" + row_data.WitnessNames + "</td>";
                            tbl_row += "<td>" + row_data.WitnessResponse + "</td>";
                            tbl_row += "<td>" + row_data.WitnessNotes + "</td>";
                            tbl_row += "<td>" + row_data.RequestDate + "</td>";
                            tbl_row += "<td>" + row_data.ResponseDate + "</td>";
                            tbl_row += "<td><a href=''>Remove</a></td>";

                            tbl_row += "</tr>";
                        });
                        $("#bdSavedLoanWitnesses").append(tbl_row);

                        row_datas = response.memberLoanApplication;
                        tbl_row = "";

                        tbl_row += "<tr>";
                        tbl_row += "<td>Payment Mode</td>";
                        tbl_row += "<td>" + row_datas.PaymentMode.toUpperCase() + "</td>";
                        tbl_row += "</tr>";

                        if (row_datas.PaymentMode.toLowerCase() == "BANK".toLowerCase()) {


                            tbl_row += "<tr>";
                            tbl_row += "<td>Bank Name</td>";
                            tbl_row += "<td>" + row_datas.BankName.toUpperCase() + "</td>";
                            tbl_row += "</tr>";

                            tbl_row += "<tr>";
                            tbl_row += "<td>Bank A/c: </td>";
                            tbl_row += "<td>" + row_datas.BankAccountNo.toUpperCase() + "</td>";
                            tbl_row += "</tr>";
                        } else if (row_datas.PaymentMode.toLowerCase() == "MOBILE".toLowerCase()) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>Mobile No:</td>";
                            tbl_row += "<td>" + row_datas.MobileNo.toUpperCase() + "</td>";
                            tbl_row += "</tr>";

                            tbl_row += "<tr>";
                            tbl_row += "<td>Mobile Provider:</td>";
                            tbl_row += "<td>" + row_datas.MobilePaymentType.toUpperCase() + "</td>";
                            tbl_row += "</tr>";
                        } else if (row_datas.PaymentMode.toLowerCase() == "FOSA".toLowerCase()) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>FOSA Account:</td>";
                            tbl_row += "<td>" + row_datas.FOSAAccount.toUpperCase() + "</td>";
                            tbl_row += "</tr>";

                        } else {
                            tbl_row += "<tr>";
                            tbl_row += "<td></td>";
                            tbl_row += "<td>Invalid Payment Details Provided</td>";
                            tbl_row += "</tr>";
                        }

                        tbl_row += "<tr>";
                        tbl_row += "<td>Reason Code</td>";
                        tbl_row += "<td>" + row_datas.SubSector2Code + "</td>";
                        tbl_row += "</tr>";

                        tbl_row += "<tr>";
                        tbl_row += "<td>Reason Name</td>";
                        tbl_row += "<td>" + row_datas.SubSector2Name + "</td>";
                        tbl_row += "</tr>";

                        tbl_row += "<tr>";
                        tbl_row += "<td>Manager Comments</td>";
                        tbl_row += "<td>" + row_datas.ManagerComments + "</td>";
                        tbl_row += "</tr>";

                        tbl_row += "<tr>";
                        tbl_row += "<td>Manager Response Date</td>";
                        tbl_row += "<td>" + row_datas.ManagerApprovalDate + "</td>";
                        tbl_row += "</tr>";

                        $("#bdSavedAppliedLoanProperties").append(tbl_row);


                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        //$("#txtErrorMessage").val('Error - ' + errorMessage);
                        //$("#txtErrorMessage").focus();
                        DispUserError('Error - ' + errorMessage);
                    }
                });

                return false;
            });

            $('#bdSavedLoanGuarantors').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Guarantor Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    var outData = {
                        'DBName': $("#cboApplicationYear").val(),
                        'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                        'GuarantorMemberNo': rm_memno
                    }
                    outData = JSON.stringify(outData);
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/MembersSystemApi/RemoveGuarantorFromMemberLoanApplication") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $(rm_row).remove();
                            CalculateSavedGuarantorsTotals();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            //alert('Error - ' + errorMessage);
                            DispUserError('Error - ' + errorMessage);
                        }
                    });
                });
                return false;
            });


            $('#bdSavedLoanWitnesses').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Witness Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    var outData = {
                        'DBName': $("#cboApplicationYear").val(),
                        'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                        'WitnessMemberNo': rm_memno
                    }
                    outData = JSON.stringify(outData);
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/MembersSystemApi/RemoveWitnessFromMemberLoanApplication") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $(rm_row).remove();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            //alert('Error - ' + errorMessage);
                            DispUserError('Error - ' + errorMessage);
                        }
                    });
                });
                return false;
            });

            InitForm();
            $("#btnListManagers").on('click', function () {
                xDialogSelectManager(hod_managers_list).then(function (data) {
                    $("#txtNormnieeUserID").val(data);
                    $("#txtNormnieeUserID").trigger('focusout');
                    $("#txtNormnieeUserID").focus();
                });
            });
            $("#txtNormnieeUserID").on("focusout", function () {
                $("#divNormineeName").html("");
                if ($("#txtNormnieeUserID").val().trim() != "") {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/MembersSystemApi/GetExternalUserName") %>",
                        data: JSON.stringify({ 'UserID': $("#txtNormnieeUserID").val() }),
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $("#divNormineeName").html(response);
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            //alert('Error - ' + errorMessage);
                            DispUserError('Error - ' + errorMessage);
                        }
                    });
                }
            });

            $("#cboLoanType").on('change', function () {
                AppliedLoanType = null;
                $("#tblLoanProperties > tbody:last").children().remove();
                loan_saving_scheme = "";
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var LoanType = LoanTypeList.filter(function (lnType) {
                    return lnType.LoanTypeCode == $("#cboLoanType").val();
                });
                if (LoanType.length > 0) {
                    AppliedLoanType = LoanType[0];
                    $("#txtRepaymentPeriod").val(AppliedLoanType.LoanMaxDuration);
                    var tbl_row = "";
                    loan_saving_scheme = AppliedLoanType.SchemeUsed;
                    tbl_row += "<tr><td>Loan Name</td><td>" + AppliedLoanType.LoanTypeName + "</td></tr>";
                    tbl_row += "<tr><td>Max Amount</td><td>" + (+AppliedLoanType.LoanMaxAmount).formatMoney() + "</td></tr>";
                    tbl_row += "<tr><td>Repayment Period in Months</td><td>" + AppliedLoanType.LoanMaxDuration + "</td></tr>";
                    tbl_row += "<tr><td>Interest Rate</td><td>" + AppliedLoanType.Percentage + " %</td></tr>";

                    tbl_row += "<tr><td>CanAlmagmateAll</td><td>" + (AppliedLoanType.CanAlmagmateAll ? "YES" : "NO") + "</td></tr>";
                    tbl_row += "<tr><td>CanBridgeItself</td><td>" + (AppliedLoanType.CanBridgeItself ? "YES" : "NO") + "</td></tr>";
                    $("#bdLoanProperties").append(tbl_row);
                    //var x = (AppliedLoanType.CanBridgeItself && !AppliedLoanType.CanAlmagmateAll).toString();
                    //alert(x);
                    //$("#divOnlyBridgeAllowed").html(x);


                    //Default to displaying all loans
                    var LoansToDisplayForOffset = MemberBalances.filter(function (lnType) {
                        return lnType.BalType.toString().toUpperCase() == "L".toUpperCase() || lnType.BalType.toString().toUpperCase() == "I".toUpperCase()
                    });


                    if (!AppliedLoanType.CanBridgeItself && !AppliedLoanType.CanAlmagmateAll) {
                        LoansToDisplayForOffset = null;
                    } else if (AppliedLoanType.CanAlmagmateAll) {
                        LoansToDisplayForOffset = LoansToDisplayForOffset;
                    } else if (AppliedLoanType.CanBridgeItself) {
                        //only display loans of the same type
                        LoansToDisplayForOffset = LoansToDisplayForOffset.filter(function (lnType) {
                            return lnType.BalCode.charAt(0).toUpperCase() == AppliedLoanType.LoanSerialIdentifier.toUpperCase()
                        });
                    }
                    $("#tblOffsets > tbody:last").children().remove();
                    if (LoansToDisplayForOffset != null) {
                        var tbl_row = "";
                        $.each(LoansToDisplayForOffset, function (index, LnOffset) {
                            tbl_row += "<tr><td><input type='checkbox' /></td><td>" + LnOffset.BalType + "</td><td>" + LnOffset.BalCode + "</td><td>" + LnOffset.BalName + "</td><td class='colamount'>" + (+LnOffset.BalAmount).formatMoney() + "</td><td><input type='text' class='colamount' value='" + LnOffset.BalAmount + "' disabled /></td></tr>"
                        });
                        $("#bdOffsets").append(tbl_row);
                    }
                    CalcRepayAmount();
                }

            });








            $("#cboApplicationYear").on('change', function () {
                GetMemberLoanApplicationsListing();
            });
            $("#cboProgressYear").on('change', function () {
                GetMemberLoansInProgress();
            });
            $("#cboLoanProgressStatus").on('change', function () {
                GetMemberLoansInProgress();
            });
            $("#btnProgressRefresh").on('click', function () {
                GetMemberLoansInProgress();
            });




            $("#btnRefresh").on('click', function () {
                GetMemberLoanApplicationsListing();
            });
            $("#btnCancel").on('click', function () {
                InitForm();
            });
            $("#btnAddGuarantor").on('click', function () {
                xDialogMemberAddGuarantor(loan_saving_scheme, null, null).then(function (data) {
                    var tbl_row = "<tr><td>" + data.GuarantorMemberNo + "</td><td>" + data.GuarantorNames + "</td><td class='colamount'>" + (+data.GuarantorAmount).formatMoney() + "</td><td><a href=''>Remove</a></td></tr>";
                    $("#bdGuarantors").append(tbl_row);
                    AddNewGuarantorsTotals();
                });
            });
            $("#btnAddWitness").on('click', function () {
                xDialogMemberAddWitness(null, null).then(function (data) {
                    var tbl_row = "<tr><td>" + data.WitnessMemberNo + "</td><td>" + data.WitnessNames + "</td><td><a href=''>Remove</a></td></tr>";
                    $("#bdWitnesses").append(tbl_row);
                });
            });
            $("#btnAddMoreGuarantor").on('click', function () {
                if (ln_app_to_edit == null) return;
                xDialogMemberAddGuarantor(ln_app_to_edit.LoanType.SchemeUsed, $("#cboApplicationYear").val(), ln_app_to_edit.LoanRefNo).then(function (data) {
                    if (data != null) {
                        var tbl_row = "<tr>";
                        tbl_row += "<td>" + data.GuarantorMemberNo + "</td>";
                        tbl_row += "<td>" + data.GuarantorNames + "</td>";
                        tbl_row += "<td>" + (+data.GuarantorAmount).formatMoney() + "</td>";
                        tbl_row += "<td>0.00</td>";
                        tbl_row += "<td>Pending</td>";
                        tbl_row += "<td></td>";
                        tbl_row += "<td><a href=''>Remove</a></td>";
                        tbl_row += "</tr>";
                        $("#bdSavedLoanGuarantors").append(tbl_row);
                    }
                });

            });

            $("#btnAddMoreWitness").on('click', function () {
                if (ln_app_to_edit == null) return;
                xDialogMemberAddWitness($("#cboApplicationYear").val(), ln_app_to_edit.LoanRefNo).then(function (data) {
                    if (data != null) {
                        var tbl_row = "<tr>";
                        tbl_row += "<td>" + data.WitnessMemberNo + "</td>";
                        tbl_row += "<td>" + data.WitnessNames + "</td>";
                        tbl_row += "<td>Pending</td>";
                        tbl_row += "<td></td>";
                        tbl_row += "<td></td>";
                        tbl_row += "<td></td>";
                        tbl_row += "<td><a href=''>Remove</a></td>";
                        tbl_row += "</tr>";
                        $("#bdSavedLoanWitnesses").append(tbl_row);
                    }
                });

            });

            $("#btnCancelApplication").on('click', function () {
                if (ln_app_to_edit == null) {
                    alert("Select Loan to cancel");
                    return;
                }
                xDialogConfirm("Are you sure you want to Cancel the selected loan application?<br/>Loan No=" + ln_app_to_edit.LoanRefNo + "<br/>Loan Type=" + ln_app_to_edit.LoanType.LoanTypeName + "<br/>Applied Amount " + (ln_app_to_edit.memberLoanApplication.RequestedAmount).formatMoney() + " ?", "Confirm").then(function () {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    var outData = {
                        'DBName': $("#cboApplicationYear").val(),
                        'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                    }
                    outData = JSON.stringify(outData);
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/MembersSystemApi/CancelMemberLoanApplication") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            GetMemberLoanApplicationsListing();
                            alert("Loan application  number " + ln_app_to_edit.LoanRefNo + " successfully cancelled");
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            //alert('Error - ' + errorMessage);
                            DispUserError('Error - ' + errorMessage);
                        }
                    });
                });
            });

            $("#btnSubmitLoanApplication").on('click', function () {
                if (ln_app_to_edit == null) {
                    alert("Select Loan to Submit");
                    return;
                }

                xDialogConfirm("Are you sure you want to Submit the selected loan application for processing?<br/>Loan No=" + ln_app_to_edit.LoanRefNo + "<br/>Loan Type=" + ln_app_to_edit.LoanType.LoanTypeName + "<br/>Applied Amount " + (ln_app_to_edit.memberLoanApplication.RequestedAmount).formatMoney() + " ?", "Confirm").then(function () {

                    xDialogMemberCredetials().then(function (data) {
                        SubmitLoanApplication(data);
                    });

                });
            });
            $("#chkLoanTOC").on('change', function (e) {
                $("#btnSave").prop('disabled', true);
                if ($(this).is(':checked')) {
                    $("#btnSave").prop('disabled', false);
                }
            });
            $("#cboPreferredPaymentMode").on('change', function () {
                $("#divFOSAAccounts").hide();
                $("#divBankDetails").hide();
                $("#divMobileDetails").hide();
                var prefPayMode = $("#cboPreferredPaymentMode option:selected").text();
                prefPayMode = prefPayMode.toString().toLowerCase();
                if (prefPayMode == "bank".toLowerCase()) $("#divBankDetails").show();
                if (prefPayMode == "fosa".toLowerCase()) $("#divFOSAAccounts").show();
                if (prefPayMode == "mobile".toLowerCase()) $("#divMobileDetails").show();

            });
            $("#btnSave").on('click', function () {
                if (document.getElementById("cboLoanType").selectedIndex == 0) {
                    //alert("Select Loan Type");
                    DispUserError("Select Loan Type");
                    return;
                }
                if (document.getElementById("cboPreferredPaymentMode").selectedIndex == 0) {
                    //alert("Select Loan Type");
                    DispUserError("Select Preferred Payment Mode");
                    return;
                }

                if (!isNumber(ConvertMoneyToDouble($("#txtLoanAmount").val()))) {
                    DispUserError("Invalid Amount");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRepaymentAmount").val()))) {
                    DispUserError("Invalid Repayment Amount");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRepaymentPeriod").val()))) {
                    DispUserError("Invalid Repayment Period");
                    return;
                }
                if ($("#txtSasraLoanPurpose").val() == "") {
                    DispUserError("Specify loan purpose");
                    return;
                }
                var fileCount = 0;
                var shouldSendFiles = true;
                $('#divSelectFiles input[type=file]').each(function () {
                    if (!window.FileReader) { // This is VERY unlikely, browser support is near-universal ( 30Apri2023 tested and working in Android WebView. Check File Size and File Type though)
                        DispUserError("Please update your browser");
                        return;
                    }
                    var file = $(this)[0].files[0]; //https://stackoverflow.com/questions/19954073/whats-the-reason-that-document-getelementbyid-works-but-jquery-doesnt
                    var maxFileMB = 5 * 1024 * 1024; //5MB
                    if (file) {
                        var filename = file.name;
                        var filesize = file.size;
                        //alert("File " + filename + " is " + file.size + " bytes in size");
                        if (filesize > maxFileMB) {
                            DispUserError("Maximum file attachment for upload is 5MB. " + filename + " is " + filesize / 1024 / 1024 + " MB which exceeds the acceptable size.");
                            shouldSendFiles = false;
                            return;
                        }
                        if (IsValidUploadFile(filename)) {
                            fileCount++;
                        } else {
                            DispUserError("Error - Invalid File:" + filename);
                            return;
                        }
                    } else {
                        //https://stackoverflow.com/questions/3717793/javascript-file-upload-size-validation
                        DispUserError("Please update your browser.")// This is VERY unlikely, browser support is near-universal
                        return;
                    }
                });
                if (shouldSendFiles) {
                    xDialogConfirm("Ensure you have attached all the necessary documents.\n " + fileCount + " file(s) will be attached. \n Confirm Loan Application<br/>Loan Type=" + $("#cboLoanType option:selected").text() + "<br/>Amount " + (ConvertMoneyToDouble($("#txtLoanAmount").val())).formatMoney() + " ?", "Confirm Loan Application...").then(function () {
                        xDialogMemberCredetials().then(function (data) {
                            SaveMemberLoanApplication(data);
                        });
                    });
                }
            });
            function SaveFiles() {
                var postdata = new FormData();
                var fileCount = 0;
                $('#divSelectFiles input[type=file]').each(function () {
                    var file = $(this)[0].files[0]; //https://stackoverflow.com/questions/19954073/whats-the-reason-that-document-getelementbyid-works-but-jquery-doesnt
                    if (file) {
                        filename = file.name;
                        //                        alert(filename);
                        if (IsValidUploadFile(filename)) {
                            var ext = filename.substring(filename.lastIndexOf('.') + 1).toLowerCase();
                            fileCount++;
                            postdata.append("MemberLoanApplicationFile" + fileCount, file, filename);
                        }
                    }
                });

                postdata.append("LoanRefNo", SavedLoanApplicationNumber);
                postdata.append("IsNewLoan", "Y");
                postdata.append("DBName", ""); // will force controller to use latest dbname
                if (+fileCount > 0) {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/MembersSystemApi/UploadMemberLoanApplicationFiles") %>",
                        contentType: false,
                        data: postdata,
                        processData: false,
                        success: function (messages) {
                            alert("File(s) Updated");
                            InitForm();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            DispUserError('Error Uploading Files: - ' + errorMessage);
                            InitForm(); //member to restart application or delete applied loan from system if we cannot attach required files
                        }
                    });
                } else {
                    InitForm();
                }
            }
            function IsValidUploadFile(filename) {


                if (filename.length < 1) {
                    alert("File Name cannot be empty"); return false;
                }


                var validExtensions = new Array();
                var ext = filename.substring(filename.lastIndexOf('.') + 1).toLowerCase();

                validExtensions[0] = 'jpg';
                validExtensions[1] = 'jpeg';
                validExtensions[2] = 'bmp';
                validExtensions[3] = 'png';
                validExtensions[4] = 'gif';
                validExtensions[5] = 'pdf';
                validExtensions[6] = 'doc';
                validExtensions[7] = 'docx';


                for (var i = 0; i < validExtensions.length; i++) {
                    if (ext == validExtensions[i]) return true;
                }

                alert('The file extension ' + ext.toUpperCase() + ' is not allowed!');
                return false;
            }
            function SubmitLoanApplication(credentials) {
                if (ln_app_to_edit == null) {
                    alert("Select Loan to Submit");
                    return;
                }
                var Password = credentials.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();

                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var outData = {
                    'DBName': $("#cboApplicationYear").val(),
                    'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                    'Password': sltpwd,
                    'Salt': pwdslt
                }



                outData = JSON.stringify(outData);

                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/SubmitMemberLoanApplication") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        GetMemberLoanApplicationsListing();
                        alert("Loan application  number " + ln_app_to_edit.LoanRefNo + " successfully submitted for processing");
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }
                });

            }

            function CalcRepayAmount() {
                $("#txtRepaymentAmount").val(0);
                if (AppliedLoanType == null) return;
                try {
                    var LoanAmount = $("#txtLoanAmount").val();
                    var RepayPeriod = $("#txtRepaymentPeriod").val();
                    var RepayAmt = 0;
                    if (AppliedLoanType.IsAmortized) {
                        console.log("Loan Is Amortized");
                        RepayAmt = GetAmortizedLoanRepayment(LoanAmount, AppliedLoanType.Percentage, RepayPeriod);
                    } else {
                        console.log("Loan Is Not Amortized");
                        RepayAmt = GetNonAmortizedLoanRepayment(LoanAmount, AppliedLoanType.Percentage, RepayPeriod);
                    }
                    RepayAmt = Math.round(RepayAmt);
                    $("#txtRepaymentAmount").val(RepayAmt.formatMoney());
                } catch (err) {
                    alert(err.message);
                }
            }
            function GetMemberLoanApplicationsListing() {


                $("#lblLoanRefNo").html("");
                $("#tblLoanApplicationList > tbody:last").children().remove();
                $("#tblSavedLoanGuarantors > tbody:last").children().remove();
                $("#tblSavedLoanWitnesses > tbody:last").children().remove();
                $("#tblSavedAppliedLoanProperties > tbody:last").children().remove();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboApplicationYear").val(),
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanApplicationsListing") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#tblLoanApplicationList > tbody:last").children().remove();
                        var row_datas = response;
                        var tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.LoanRefNo + "</td>";
                            tbl_row += "<td>" + row_data.LoanDate + "</td>";
                            tbl_row += "<td>" + row_data.LoanTypeName + "</td>";
                            tbl_row += "<td>" + (+row_data.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + row_data.ProcessStatus + "</td>";
                            tbl_row += "<td>" + row_data.ManagerApprovalStatus + "</td>";
                            tbl_row += "</tr>";
                        });
                        $("#bdLoanApplicationList").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }

                });
            }
            function GetMemberLoansInProgress() {
                $("#tblLoanProgress > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboProgressYear").val(),
                    'LoanStatus': $("#cboLoanProgressStatus").val()
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoansInProgress") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#tblLoanProgress > tbody:last").children().remove();
                        var row_datas = response;
                        var tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.LoanSerialNumber + "</td>";
                            tbl_row += "<td>" + row_data.OnlineApplicationNo + "</td>";
                            tbl_row += "<td>" + row_data.LoanDate + "</td>";
                            tbl_row += "<td>" + row_data.LoanTypeName + "</td>";
                            tbl_row += "<td>" + row_data.LoanStatus + "</td>";
                            tbl_row += "<td>" + (+row_data.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.RecommendedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.ApprovedAmount).formatMoney() + "</td>";
                            tbl_row += "<td><a href='" + row_data.LoanSerialNumber + "' class='approveLink'>" + row_data.MemberAcceptance + "</a></td>";
                            if (row_data.LoanStatus.toString().toLowerCase() == "approved".toLowerCase()) {
                                tbl_row += "<td><a href='/Members/MembersSystem/OfferLetter?DBName=" + $("#cboProgressYear").val() + "&LoanSerialNumber=" + row_data.LoanSerialNumber + "'>Offer Letter</a></td>";
                            } else {
                                tbl_row += "<td>N/A</td>";
                            }
                            tbl_row += "</tr>";
                        });
                        $("#bdLoanProgress").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }

                });
            }

            $('body').on('click', '.approveLink', function (e) {
                MemberAcceptRejectLoan(this);
                e.preventDefault();
                return false;
            });
            function MemberAcceptRejectLoan(approvelink) {

                var ApproveLoanSerialNumber = approvelink.getAttribute("href");
                var Criteria = {
                    "LoanSerialNumber": ApproveLoanSerialNumber,
                    "DBName": $("#cboProgressYear").val()
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetLoanDetails") %>",
                    data: JSON.stringify(Criteria),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        ProcessMemberLoanAcceptance(response);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }
                });
            }
            function AddNewGuarantorsTotals() {
                var GuarantorsRequestsTotals = +0;
                $("#spanGuarantorTotals").text(GuarantorsRequestsTotals.formatMoney());
                $("#bdGuarantors tr").each(function (i) {
                    var row = $(this);
                    var requestedAmt = ConvertMoneyToDouble(row.find('td:eq(2)').text());
                    GuarantorsRequestsTotals += requestedAmt;
                    $("#spanGuarantorTotals").text(GuarantorsRequestsTotals.formatMoney());
                });
            }
            function CalculateSavedGuarantorsTotals() {
                var GuarantorsRequestsTotals = +0;
                var GuarantorsAcceptedTotals = +0;
                var GuarantorCount = +0;
                var TotalRequested = +0;
                var TotalAcceptedCount = +0;

                $("#spanNoOfGuarantors").text("0");
                $("#spanGuarantorsAcceptedCount").text("0");
                $("#spanTotalGuarantorsRequested").text("0.00");
                $("#spanTotalGuarantorsAccepted").text("0.00");

                $("#bdSavedLoanGuarantors tr").each(function (i) {
                    GuarantorCount++;
                    var row = $(this);
                    var Amt = ConvertMoneyToDouble(row.find('td:eq(2)').text());
                    GuarantorsRequestsTotals += Amt;
                    Amt = ConvertMoneyToDouble(row.find('td:eq(3)').text());
                    GuarantorsAcceptedTotals += Amt;
                    var AcceptedStatus = row.find('td:eq(4)').text();
                    AcceptedStatus = String(AcceptedStatus);
                    if (AcceptedStatus === "Accepted") {
                        TotalAcceptedCount++;
                    }
                    $("#spanGuarantorTotals").text(GuarantorsRequestsTotals.formatMoney());

                    $("#spanNoOfGuarantors").text(GuarantorCount);
                    $("#spanGuarantorsAcceptedCount").text(TotalAcceptedCount);
                    $("#spanTotalGuarantorsRequested").text(GuarantorsRequestsTotals.formatMoney());
                    $("#spanTotalGuarantorsAccepted").text(GuarantorsAcceptedTotals.formatMoney());
                });
            }
            function ProcessMemberLoanAcceptance(LoanToApprove) {
                $('<div id="divApproveLoanDialog"></div>').dialog({
                    modal: true,
                    title: "Accept/Reject Loan",
                    height: 700,
                    width: 500,
                    autoOpen: true,
                    show: {
                        effect: "drop",
                        direction: "up",
                        duration: 500
                    },

                    buttons: {
                        'OK': {
                            'text': 'OK',
                            'id': 'btnOK',
                            'click': function () {
                                var ConfirmMessage = "";
                                if (document.getElementById("cboMemberResponse").selectedIndex == 0) {
                                    alert("Select Response");
                                    return;
                                }
                                ConfirmMessage = "Please confirm you want to " + $("#cboMemberResponse option:selected").text() + " this loan?";

                                xDialogConfirm(ConfirmMessage, "Confirm").then(function () {
                                    xDialogMemberCredetials().then(function (data) {
                                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                                        var Password = data.UserPass;
                                        var pwdslt = getRandomInt(1000, 30000);
                                        pwdslt = pwdslt.toString();
                                        var pwd = CryptoJS.MD5(Password).toString();
                                        pwd = pwd + pwdslt;
                                        var sltpwd = CryptoJS.MD5(pwd).toString();

                                        var outData = {
                                            'DBName': LoanToApprove.DBName,
                                            'MemberNo': LoanToApprove.mLoanAppraisals.MemberNumber,
                                            'LoanSerialNumber': LoanToApprove.LoanSerialNumber,
                                            'Response': $("#cboMemberResponse").val(),
                                            'Salt': pwdslt,
                                            'Password': sltpwd
                                        }
                                        outData = JSON.stringify(outData);
                                        $.ajax({
                                            headers: { __RequestVerificationToken: csrfToken },
                                            type: "POST",
                                            url: "<%: Url.Content("~/api/MembersSystemApi/ProcessMemberLoanResponse") %>",
                                            data: outData,
                                            contentType: "application/json; charset=utf-8",
                                            dataType: "json",
                                            success: function (response) {
                                                $("#tblLoanProgress tr").each(function (i) {
                                                    var row = $(this);
                                                    if (row.find('td:eq(1)').text() == LoanToApprove.LoanSerialNumber) {
                                                        row.find('td:eq(8)').html("<a href='" + LoanToApprove.LoanSerialNumber + "' class='approveLink'>" + $("#cboMemberResponse").val() + "</a>");

                                                    }
                                                });
                                                alert("Response successfully updated");
                                                $("#divApproveLoanDialog").dialog("close");

                                            },
                                            error: function (xhr, status, error) {
                                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                                //alert('Error - ' + errorMessage);
                                                DispUserError('Error - ' + errorMessage);
                                            }
                                        });
                                    });
                                });
                            }
                        },
                        Cancel: function () {
                            $(this).dialog("close");
                        }
                    },
                    open: function () {
                        var approved_amount = 0;
                        var recommended_amount = 0;
                        var repay_period = 1;

                        if (LoanToApprove.mAppraisalReport) {
                            recommended_amount = LoanToApprove.mAppraisalReport.RecommendedAmount;
                            repay_period = LoanToApprove.mAppraisalReport.RepaymentPeriod;
                        }
                        if (LoanToApprove.mApprovedLoans) {
                            approved_amount = LoanToApprove.mApprovedLoans.ApprovedAmount;
                            repay_period = LoanToApprove.mApprovedLoans.RepaymentPeriod;
                        }
                        var tbl = "<table id='tblApproveLoan' border=1>";
                        tbl += "<tbody>";
                        tbl += "<tr><td><b>Loan Serial Number:</b></td><td><input type='text' id='txtLoanSerialNumber' value='" + LoanToApprove.LoanSerialNumber + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loanee:</b></td><td><input type='text' id='txtLoaneeName' value='" + LoanToApprove.saccoMember.FullNames + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>MemberNo:</b></td><td><input type='text' id='txtLoaneeMemberNo' value='" + LoanToApprove.saccoMember.MemberNo + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>PayrollNo:</b></td><td><input type='text' id='txtLoaneePayrollNo' value='" + LoanToApprove.saccoMember.PayrollNo + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loan Type:</b></td><td><input type='text' id='txtLoanType' value='" + LoanToApprove.mLoanType.LoanTypeName + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Requested Amount:</b></td><td><input type='text' id='txtRequestedAmount' value='" + (+LoanToApprove.mLoanAppraisals.RequestedAmount).formatMoney() + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loan Status:</b></td><td><input type='text' id='txtLoanStatus' value='" + LoanToApprove.mLoanAppraisals.LoanStatus + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Recommended Amount</b></td><td><input type='text' id='txtRecommendedAmount' value='" + (+recommended_amount).formatMoney() + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Approved Amount</b></td><td><input type='text' id='txtApprovedAmount' value='" + (+approved_amount).formatMoney() + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Amt In Words:</b></td><td><div id='divAmountInWords' /></td></tr>";
                        tbl += "<tr><td><b>HR Ability:</b></td><td><input type='text' id='txtHRRepayAmt' value='" + LoanToApprove.mLoanAppraisals.HRRepayAmt + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>HR Approved:</b></td><td><input type='text' id='txtHRAbility' value='" + LoanToApprove.mLoanAppraisals.HRApproved + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Repayment Period:</b></td><td><input type='text' id='txtRepaymentPeriod' value='" + repay_period + "' /></td></tr>";
                        tbl += "<tr><td><b>Reponse:</b></td><td><select id='cboMemberResponse'><option value='' selected>(SELECT)</option><option value='accepted'>Accept</option><option value='rejected'>Reject</option></select></td></tr>";
                        tbl += "<tr><td><b>Notes/Reason:</b></td><td><textarea id='txtResponseReason' value='" + LoanToApprove.mLoanAppraisals.MemberAcceptanceComments + "' /></textarea></td></tr>";

                        tbl += "</tbody></table>";
                        $(this).html(tbl);
                        ShowAmtInWords();
                        $("#cboMemberResponse").focus;

                        function ShowAmtInWords() {
                            $("#divAmountInWords").html("");
                            try {
                                $("#divAmountInWords").html(toWords($("#txtApprovedAmount").val()));
                            } catch (err) {

                            }
                        }
                    },
                    close: function (event, ui) {
                        $(this).dialog("destroy").remove();
                    }
                });
            }

            function SaveMemberLoanApplication(credetials) {
                var LoanApplicationValid = true;
                var validCount = 0;
                var OffSetsList = new Array();
                var dblTotalAmount = 0;
                $("#tblOffsets tbody").find('tr').each(function (i) {
                    var OffSetEntry = {};
                    var row = $(this); //store in variable for faster access

                    OffSetEntry.BalType = row.find('td:eq(1)').text();
                    OffSetEntry.BalCode = row.find('td:eq(2)').text();
                    OffSetEntry.BalName = row.find('td:eq(3)').text();
                    OffSetEntry.BalAmount = row.find('td:eq(4)').text();
                    var txtAmt = row.find('td:eq(5)').find('input:eq(0)');


                    if (!isNumber(txtAmt.val())) {
                        LoanApplicationValid = false;
                        alert("Invalid offset amount at row " + i);
                        return;
                    }
                    var line_amount = txtAmt.val();
                    line_amount = +line_amount;
                    if (line_amount < 0) {
                        LoanApplicationValid = false;
                        alert("Offset Amount  " + line_amount + " should be more than or equal to Zero. At row " + i);
                        return;
                    }
                    if (row.find('input[type="checkbox"]').is(':checked')) {
                        if (line_amount > 0) {
                            dblTotalAmount = dblTotalAmount + line_amount;
                            OffSetEntry.TransAmount = line_amount;
                            OffSetsList[validCount] = OffSetEntry;
                            validCount++;
                        }
                    }
                });

                var validCount = 0;
                var FXDSecurityList = new Array();
                var dblTotalAmount = 0;
                $("#tblFXDBalances tbody").find('tr').each(function (i) {
                    var FXDSecurityEntry = {};
                    var row = $(this); //store in variable for faster access

                    FXDSecurityEntry.BalType = row.find('td:eq(1)').text();
                    FXDSecurityEntry.BalCode = row.find('td:eq(2)').text();
                    FXDSecurityEntry.BalName = row.find('td:eq(3)').text();
                    FXDSecurityEntry.BalAmount = row.find('td:eq(4)').text();
                    var txtAmt = row.find('td:eq(5)').find('input:eq(0)');


                    if (!isNumber(txtAmt.val())) {
                        LoanApplicationValid = false;
                        alert("Invalid FXD Amount amount at row " + i);
                        return;
                    }
                    var line_amount = txtAmt.val();
                    line_amount = +line_amount;
                    if (line_amount < 0) {
                        LoanApplicationValid = false;
                        alert("FXD Amount  " + line_amount + " should be more than or equal to Zero. At row " + i);
                        return;
                    }
                    if (row.find('input[type="checkbox"]').is(':checked')) {
                        if (line_amount > 0) {
                            dblTotalAmount = dblTotalAmount + line_amount;
                            FXDSecurityEntry.TransAmount = line_amount;
                            FXDSecurityList[validCount] = FXDSecurityEntry;
                            validCount++;
                        }
                    }
                });

                var GuarantorsList = new Array();
                var dblTotalAmount = 0;

                $("#tblGuarantors tbody").find('tr').each(function (i) {
                    var GuarantorEntry = {};
                    var row = $(this); //store in variable for faster access
                    GuarantorEntry.LoanSerialNumber = "";
                    GuarantorEntry.GuarantorMemberNumber = row.find('td:eq(0)').text();

                    var GuarantorAmt = row.find('td:eq(2)').text();

                    if (!isNumber(GuarantorAmt)) { //contains commas at this point
                        LoanApplicationValid = false;
                        alert("Invalid Guarantor amount " + GuarantorAmt + " at row " + i);
                        return;
                    }
                    GuarantorAmt = ConvertMoneyToDouble(GuarantorAmt);
                    var line_amount = GuarantorAmt;
                    line_amount = +line_amount;
                    if (line_amount <= 0) {
                        LoanApplicationValid = false;
                        alert("Guarantor's Amount " + line_amount + " should be more than Zero. At row " + i);
                        return;
                    }


                    GuarantorEntry.SharesToCommit = line_amount;
                    GuarantorsList[i] = GuarantorEntry;


                });

                var WitnessesList = new Array();
                var dblTotalAmount = 0;

                $("#tblWitnesses tbody").find('tr').each(function (i) {
                    var WitnessesEntry = {};
                    var row = $(this); //store in variable for faster access
                    var WitnessMemberNo = row.find('td:eq(0)').text();
                    WitnessesList[i] = WitnessMemberNo;

                });
                if ($("#txtSasraReasonCode").val() == "") {
                    LoanApplicationValid = false;
                    alert("Specify reason/purpose for loan");
                }
                if (LoanApplicationValid == false) {
                    return;
                }
                var Password = credetials.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var outData = {
                    'Guarantors': GuarantorsList,
                    'Witnesses': WitnessesList,
                    'OffSets': OffSetsList,
                    'FXDSecurityList': FXDSecurityList,
                    'LoanTypeCode': $("#cboLoanType").val(),
                    'LoanAmount': $("#txtLoanAmount").val(),
                    'RepaymentPeriod': $("#txtRepaymentPeriod").val(),
                    'LoanPurpose': $("#txtLoanPurpose").val(),
                    'SasraReason2Code': $("#txtSasraReasonCode").val(),

                    'PaymentMode': $("#cboPreferredPaymentMode").val(),
                    'MobilePaymentType': $("#cboMobileProvider").val(),
                    'FOSAAccount': $("#cboFOSAAccount").val(),
                    'BankName': $("#lblBankName").text(),
                    'BankAccountNo': $("#lblBankAccNo").text(),
                    'MobileNo': $("#lblPhoneNo").text(),




                    'Instructions': $("#txtInstructions").val(),
                    'NormineeUserID': $("#txtNormnieeUserID").val(),
                    'Password': sltpwd,
                    'Salt': pwdslt
                }
                //https://www.w3schools.com/js/js_json_stringify.asp
                var objToString = JSON.stringify(outData, null, 4);
                //console.log(objToString);
                outData = JSON.stringify(outData);


                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/SaveMemberLoanApplication") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {

                        alert("Loan Application Saved Successfully. Uploading files...");
                        SavedLoanApplicationNumber = response;

                        SaveFiles();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }

                });

            }
            $('#tabs').on('tabsactivate', function (event, ui) {//jquery
                var newIndex = ui.newTab.index();
                if (newIndex == 1) {
                    GetMemberLoanApplicationsListing();
                } else if (newIndex == 2) {
                    GetMemberLoansInProgress();
                }
            });
            $('#tabs').on('tabs-activate', function (e, activeTab) {//jquery-responsive-tabs
                var newTabId = activeTab.id
                if (newTabId == 1) {
                    GetMemberLoanApplicationsListing();
                } else if (newTabId == 2) {
                    GetMemberLoansInProgress();
                }
            });
            $("#btnTab2").on('click', function (e) {
                $('#tabs').responsiveTabs('activate', 1);
            });

            $("#btnSearchSasra").on('click', function (e) {
                e.preventDefault();
                xDialogSearchLoanPurpose(SASRASubSector2).then(function (data) {
                    //alert(data.Reason2Code + " " + data.Reason2Name);
                    $("#cboLoanMainSector").prop('selectedIndex', 0);
                    $("#cboLoanSector1").prop('selectedIndex', 0);
                    $("#cboLoanSector2").prop('selectedIndex', 0);

                    $("#cboLoanMainSector").val(data.MainReasonCode);
                    $("#cboLoanSector1").val(data.Reason1Code);
                    $("#cboLoanSector2").val(data.Reason2Code);

                    $("#txtSasraLoanPurpose").val(data.Reason2Name);
                    $("#txtSasraReasonCode").val(data.Reason2Code);

                });
            });
            function InitForm() {

                $("#cboLoanType").empty();
                $("#cboFOSAAccount").empty();
                $("#txtLoanAmount").val(0.00);
                $("#txtRepaymentPeriod").val(0.00);
                $("#txtRepaymentAmount").val(0.00);
                $("#txtInstructions").val("");
                $("#txtLoanPurpose").val("");
                $("#txtSasraLoanPurpose").val("");
                $("#txtSasraReasonCode").val("");
                $("#txtNormnieeUserID").val("");
                $("#cboApplicationYear").empty();
                $("#cboProgressYear").empty();
                $("#tblLoanProperties > tbody:last").children().remove();
                $("#tblOffsets > tbody:last").children().remove();
                $("#tblFXDBalances > tbody:last").children().remove();
                $("#tblGuarantors > tbody:last").children().remove();
                $("#tblWitnesses > tbody:last").children().remove();
                $("#tblLoanApplicationList > tbody:last").children().remove();

                $("#tblSavedLoanGuarantors > tbody:last").children().remove();
                $("#tblSavedLoanWitnesses > tbody:last").children().remove();
                $("#divSelectFiles").empty();
                $("#divAmountInWords").empty();
                $("#tblMemberBalances > tbody:last").children().remove();

                AddNewGuarantorsTotals();

                $("#cboPreferredPaymentMode").prop('selectedIndex', 0);
                $("#divFOSAAccounts").hide();
                $("#divBankDetails").hide();
                $("#divMobileDetails").hide();

                $('#chkLoanTOC').prop('checked', false);


                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanApplicationConfig") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        MemberDetails = response.MemberDetails;
                        $("#lblPhoneNo").text(MemberDetails.PhoneNo);
                        $("#lblBankName").text(MemberDetails.MainBankName);
                        $("#lblBankAccNo").text(MemberDetails.AccountNo);
                        LoanTypeList = response.LoanTypes;
                        MemberBalances = response.MemberBalances.MemberBals;
                        var Years = response.Years;
                        SASRASubSector2 = response.SASRASubsector2;
                        SASRASubSector1 = response.SASRASubsector1;
                        SASRAMainSectors = response.SASRAMainSectors;
                        bolNomineeRequired = response.NomineeRequired;
                        FXD_Balances = response.FXD_Balances
                        var FOSAAccounts = response.FOSAAccounts;
                        //console.log(SASRASubSector2);
                        //console.log(SASRASubSector1);
                        //console.log(SASRAMainSectors);
                        //console.log(response.NomineeRequired);
                        //console.log(typeof response.NomineeRequired);
                        //console.log(MemberDetails.Surname);
                        //console.log(typeof MemberDetails.Surname);

                        //bolNomineeRequired = (bolNomineeRequired === "True" || bolNomineeRequired === "true" || bolNomineeRequired === true);
                        //console.log(bolNomineeRequired);
                        if (bolNomineeRequired) {
                            //console.log("bolNomineeRequired is True ");

                        } else {
                            //console.log("bolNomineeRequired is False ");
                            $("#trNormineeID").hide();
                            $("#trNormineeName").hide();
                        }
                        hod_managers_list = response.Managers;

                        $("#cboFOSAAccount").append('<option value="" selected>(SELECT)</option>');
                        $.each(FOSAAccounts, function (index, objFOSAAcc) {
                            $("#cboFOSAAccount").append("<option value='" + objFOSAAcc.AccountNo + "'>" + objFOSAAcc.AccountNo + "(" + objFOSAAcc.AccountName + ")" + "</option'>");
                        });
                        var PayModes = response.PaymentModes;
                        $("#cboPreferredPaymentMode").empty();
                        $("#cboPreferredPaymentMode").append('<option value="" selected>(SELECT)</option>');

                        $.each(PayModes, function (index, objPayMode) {
                            $("#cboPreferredPaymentMode").append("<option value='" + objPayMode + "'>" + objPayMode + "</option'>");
                        });
                        $("#cboLoanType").empty();
                        $("#cboApplicationYear").empty();

                        $("#cboLoanType").append('<option selected>(SELECT LOAN TYPE)</option>');

                        $("#cboLoanSector2").empty();
                        $("#cboLoanSector2").append('<option value="" selected>(SELECT REASON FOR LOAN)</option>');
                        $.each(SASRASubSector2, function (index, objSASRASubsector2) {
                            $("#cboLoanSector2").append("<option value='" + objSASRASubsector2.SubSector2Code + "'>" + objSASRASubsector2.SubSector2Name + "</option'>");
                        });
                        $("#cboLoanSector1").empty();
                        $("#cboLoanSector1").append('<option value="" selected>(SELECT REASON FOR LOAN)</option>');
                        $.each(SASRASubSector1, function (index, objSASRASubsector1) {
                            $("#cboLoanSector1").append("<option value='" + objSASRASubsector1.SubSector1Code + "'>" + objSASRASubsector1.SubSector1Name + "</option'>");
                        });
                        $("#cboLoanMainSector").empty();
                        $("#cboLoanMainSector").append('<option value="" selected>(SELECT REASON FOR LOAN)</option>');
                        $.each(SASRAMainSectors, function (index, objSASRAMainSector) {
                            $("#cboLoanMainSector").append("<option value='" + objSASRAMainSector.MainSectorCode + "'>" + objSASRAMainSector.MainSectorName + "</option'>");
                        });

                        $.each(LoanTypeList, function (index, LoanType) {
                            $("#cboLoanType").append("<option value='" + LoanType.LoanTypeCode + "'>" + LoanType.LoanTypeName + "</option'>");
                        });

                        var tbl_row = "";
                        $.each(MemberBalances, function (index, MemberBalance) {
                            if (MemberBalance.BalType.toString().toUpperCase() == "L".toUpperCase() || MemberBalance.BalType.toString().toUpperCase() == "I".toUpperCase()) {
                                tbl_row += "<tr><td><input type='checkbox' /></td><td>" + MemberBalance.BalType + "</td><td>" + MemberBalance.BalCode + "</td><td>" + MemberBalance.BalName + "</td><td>" + (+MemberBalance.BalAmount).formatMoney() + "</td><td><input type='text' value='" + MemberBalance.BalAmount + "' disabled /></td></tr>"
                            }
                        });
                        $("#bdOffsets").append(tbl_row);

                        var tbl_row = "";
                        $.each(FXD_Balances, function (index, MemberBalance) {
                            tbl_row += "<tr><td><input type='checkbox' /></td><td>" + MemberBalance.BalType + "</td><td>" + MemberBalance.BalCode + "</td><td>" + MemberBalance.BalName + "</td><td>" + (+MemberBalance.BalAmount).formatMoney() + "</td><td><input type='text' value='" + MemberBalance.BalAmount + "' disabled /></td></tr>"
                        });
                        $("#bdFXDBalances").append(tbl_row);

                        $.each(Years, function (index, yr) {
                            $("#cboApplicationYear").append("<option value='" + yr.DBName + "' selected>" + yr.UserDefinedYearName + "</option'>");
                        });
                        $("#cboApplicationYear").get(0).selectedIndex = 0;
                        $.each(Years, function (index, yr) {
                            $("#cboProgressYear").append("<option value='" + yr.DBName + "' selected>" + yr.UserDefinedYearName + "</option'>");
                        });
                        $("#cboProgressYear").get(0).selectedIndex = 0;
                        $("#cboProgressYear").get(0).selectedIndex = 0; //first $("#cboProgressYear").get(0).selectedIndex = 0; not working
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);

                    }
                });
            }



            /*
            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
            */

            $('#tabs').responsiveTabs({
                // Start with the panels collapsed if the view is currently accordion based
                startCollapsed: 'accordion',
                // Tabs can be collapsed
                collapsible: true,
                // Tabs auto rotate
                rotate: false
            });

        });
    </script>
</asp:Content>



<%@ Page Title="Loan Application" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <div class="dashboard-wrapper">
        <div class="container-fluid py-2">
            <div class="card shadow-sm rounded-3 mb-3">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Loan Application</h5>
                </div>

                <div class="card-body">
                    <div id="tabs">
                        <ul class="nav nav-tabs" id="loanTabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="loan-tab" data-bs-toggle="tab" data-bs-target="#tab-loan" type="button" role="tab">Loan Application</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="status-tab" data-bs-toggle="tab" data-bs-target="#tab-status" type="button" role="tab">Loan Application Status</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="progress-tab" data-bs-toggle="tab" data-bs-target="#tab-progress" type="button" role="tab">Loan Progress</button>
                            </li>
                        </ul>

                        <div class="tab-content mt-3" id="loanTabsContent">

                            <!-- TAB 1 -->
                            <div class="tab-pane fade show active" id="tab-loan" role="tabpanel">

                                <form id="frmMain" class="form">
                                    <%= Html.AntiForgeryToken() %>

                                    <div class="row mb-3">
                                        <label for="cboLoanType" class="col-md-2 col-form-label">Loan Type</label>
                                        <div class="col-md-4">
                                            <select id="cboLoanType" class="form-select"></select>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-md-2 col-form-label">Loan Properties</label>
                                        <div class="col-md-10 border rounded p-2" id="divLoanProperties"></div>
                                    </div>

                                    <div class="row mb-3">
                                        <label for="txtLoanAmount" class="col-md-2 col-form-label">Applied Loan Amount</label>
                                        <div class="col-md-4">
                                            <input type="number" id="txtLoanAmount" class="form-control" placeholder="Loan Amount">
                                        </div>
                                        <label class="col-md-2 col-form-label">Amount in Words</label>
                                        <div class="col-md-4 border rounded p-2" id="divAmountInWords"></div>
                                    </div>

                                    <div class="row mb-3">
                                        <label for="txtRepaymentPeriod" class="col-md-2 col-form-label">Repayment Period (Months)</label>
                                        <div class="col-md-4">
                                            <input type="number" id="txtRepaymentPeriod" class="form-control">
                                        </div>
                                        <label for="txtRepaymentAmount" class="col-md-2 col-form-label">Repayment Amount</label>
                                        <div class="col-md-4">
                                            <input type="text" id="txtRepaymentAmount" class="form-control" readonly>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label for="txtSasraLoanPurpose" class="col-md-2 col-form-label">Purpose</label>
                                        <div class="col-md-6">
                                            <textarea id="txtSasraLoanPurpose" readonly class="form-control" placeholder="Select Loan Purpose"></textarea>
                                            <input type="hidden" id="txtSasraReasonCode" />
                                        </div>
                                        <div class="col-md-4">
                                            <input type="button" id="btnSearchSasra" value="Search Loan Purpose" class="btn btn-primary btn-sm">
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-md-2 col-form-label">Send Approval Request to PF No:</label>
                                        <div class="col-md-4 d-flex">
                                            <input type="text" id="txtNormnieeUserID" class="form-control me-2">
                                            <input type="button" id="btnListManagers" value="Find" class="btn btn-secondary">
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-md-2 col-form-label">Norminee Names:</label>
                                        <div class="col-md-10" id="divNormineeName"></div>
                                    </div>

                                    <!-- Guarantors -->
                                    <div class="mb-3">
                                        <h6>Guarantors</h6>
                                        <div id="divGuarantors" class="border rounded p-2 mb-2"></div>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <input type="button" id="btnAddGuarantor" value="Add Guarantor" class="btn btn-primary">
                                            <span>Guarantor Totals: <strong id="spanGuarantorTotals">0.00</strong></span>
                                        </div>
                                    </div>

                                    <!-- Attachments -->
                                    <div class="mb-3">
                                        <h6>Attachments</h6>
                                        <div id="divAttachments" class="border rounded p-2 mb-2">
                                            <p class="small text-muted mb-2">Attach payslips, logbook etc.</p>
                                            <input type="button" id="btnAddFile" value="Add File" class="btn btn-sm btn-primary">
                                            <div id="divSelectFiles" class="mt-2"></div>
                                        </div>
                                    </div>

                                    <!-- Terms -->
                                    <div class="form-check mb-3">
                                        <input type="checkbox" id="chkLoanTOC" class="form-check-input">
                                        <label for="chkLoanTOC" class="form-check-label">
                                            I accept the <a target="_blank" href="<%: Url.Content("~/TermsAndConditions/LoansTOC.pdf") %>">terms and conditions</a>
                                        </label>
                                    </div>

                                    <div class="d-flex">
                                        <input type="button" value="Cancel" id="btnCancel" class="btn btn-danger me-2">
                                        <input type="button" value="Save" id="btnSave" class="btn btn-success" disabled>
                                    </div>
                                </form>
                            </div>

                            <!-- TAB 2 -->
                            <div class="tab-pane fade" id="tab-status" role="tabpanel">
                                <div class="row mb-3">
                                    <label class="col-md-2 col-form-label">Financial Year:</label>
                                    <div class="col-md-4">
                                        <select id="cboApplicationYear" class="form-select">
                                            <option>SELECT YEAR</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 text-end">
                                        <input type="button" id="btnRefresh" value="Refresh" class="btn btn-secondary me-2">
                                        <input type="button" id="btnCancelApplication" value="Cancel Application" class="btn btn-danger me-2">
                                        <input type="button" id="btnSubmitLoanApplication" value="Submit Application" class="btn btn-primary">
                                    </div>
                                </div>

                                <div id="divLoanApplicationList" class="border rounded p-2" style="height: 250px; overflow:auto;">
                                    <h6>Loan Application List</h6>
                                    <div id="bdLoanApplicationList"></div>
                                </div>
                            </div>

                            <!-- TAB 3 -->
                            <div class="tab-pane fade" id="tab-progress" role="tabpanel">
                                <div class="row mb-3">
                                    <label class="col-md-2 col-form-label">Financial Year:</label>
                                    <div class="col-md-4">
                                        <select id="cboProgressYear" class="form-select">
                                            <option value="">SELECT YEAR</option>
                                        </select>
                                    </div>
                                    <label class="col-md-2 col-form-label">Loan Status:</label>
                                    <div class="col-md-4">
                                        <select id="cboLoanProgressStatus" class="form-select">
                                            <option>(ALL)</option>
                                            <option>Active</option>
                                            <option>Appraised</option>
                                            <option>Approved</option>
                                            <option>Rejected</option>
                                        </select>
                                    </div>
                                </div>

                                <div id="divLoanProgress" class="border rounded p-2 mb-3" style="height:auto; overflow:auto;">
                                </div>
                                <div id="divLoanDetails" class="border rounded p-2" style="height:120px; overflow:auto;">
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</asp:Content>
