﻿<%@ Page Title="Member Change Password" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Member Change Password
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-4">
                <div class="card shadow-lg border-0 rounded-4">
                    <div class="card-body p-4">
                        <h4 class="text-center mb-4 text-primary fw-bold">Change Password</h4>

                        <form class="form" id="frmChangePassword" method="post" autocomplete="off" action="#">
                            <%= Html.AntiForgeryToken() %>

                            <!-- Hidden fake inputs to block browser autocomplete -->
                            <div class="hidden">
                                <input type="password" />
                                <input type="password" name="fake_pass4" id="fake_pass4" value="*****" />
                            </div>
                            <input type="password" name="fake_pass5" id="fake_pass5" style="width: 0px; height: 0px" value="*****" />

                            <!-- Password Fields -->
                            <div class="form-group mb-3">
                                <label for="txtOldPassword" class="form-label">Current Password</label>
                                <input class="form-control" type="password" name="txtOldPassword" id="txtOldPassword" autocomplete="off" placeholder="Enter Old Password" />
                            </div>

                            <div class="form-group mb-3">
                                <label for="txtNewPassword" class="form-label">New Password</label>
                                <input class="form-control" type="password" name="txtNewPassword" id="txtNewPassword" autocomplete="off" placeholder="Enter New Password" />
                            </div>

                            <div class="form-group mb-3">
                                <label for="txtConfirmPassword" class="form-label">Confirm New Password</label>
                                <input class="form-control" type="password" name="txtConfirmPassword" id="txtConfirmPassword" autocomplete="off" placeholder="Confirm New Password" />
                            </div>

                            <div id="diverror" class="text-center mb-3 text-danger fw-bold">
                                <% if (!String.IsNullOrWhiteSpace(ViewBag.Message)) { %>
                                    <%: ViewBag.Message %>
                                <% } %>
                            </div>

                            <input type="hidden" id="txtSalt" name="txtSalt" value="" />

                            <div class="d-flex justify-content-between">
                                <button type="submit" id="btnChangePassword" class="btn btn-success w-50 me-2">Change</button>
                                <button type="button" id="btnCancelChangePassword" class="btn btn-danger w-50">Cancel</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</asp:Content>

<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <!-- Include CryptoJS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/4.1.1/crypto-js.min.js"></script>

    <script type="text/javascript">
        // Define minimum password length
        var PortalSettings = { MinimumPasswordLength: 6 };

        $(document).ready(function () {

            // Random integer generator
            function getRandomInt(min, max) {
                return Math.floor(Math.random() * (max - min + 1)) + min;
            }

            // Cancel button redirects back
            $("#btnCancelChangePassword").click(function () {
                window.location.href = '<%: Url.Content("~/Members/Dashboard") %>';
            });

            // Handle form submit
            $("#frmChangePassword").submit(function (e) {
                e.preventDefault();
                return SubmitForm();
            });

            function SubmitForm() {
                // Validate input
                if ($('#txtOldPassword').val().trim() === '') {
                    return ShowError("Enter Old Password", "#txtOldPassword");
                } else if ($('#txtNewPassword').val().trim().length < PortalSettings.MinimumPasswordLength) {
                    return ShowError("Enter New Password (Min " + PortalSettings.MinimumPasswordLength + " Characters)", "#txtNewPassword");
                } else if ($('#txtConfirmPassword').val().trim().length < 4) {
                    return ShowError("Confirm New Password (Min 4 Characters)", "#txtConfirmPassword");
                } else if ($('#txtNewPassword').val() !== $('#txtConfirmPassword').val()) {
                    return ShowError("Password confirmation failed", "#txtConfirmPassword");
                } else if ($('#txtOldPassword').val() === $('#txtNewPassword').val()) {
                    return ShowError("New password must be different from old password", "#txtNewPassword");
                }

                // Hashing passwords
                var newpasswd = CryptoJS.MD5($("#txtNewPassword").val()).toString();
                var confirmpasswd = CryptoJS.MD5($("#txtConfirmPassword").val()).toString();
                var pwdslt = getRandomInt(1000, 30000).toString();
                var pwd = CryptoJS.MD5($("#txtOldPassword").val()).toString() + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var outData = JSON.stringify({
                    'OldPassword': sltpwd,
                    'Salt': pwdslt,
                    'NewPassword': newpasswd,
                    'ConfirmPassword': confirmpasswd
                });

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var url_change_password = '<%: Url.Content("~/api/MembersSystemApi/ChangeMemberPassword") %>';

                // AJAX call
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: url_change_password,
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (data) {
                        alert("✅ Password changed successfully!");
                        window.location.href = '<%: Url.Content("~/Login/Member") %>';
                    },
                    error: function (xhr, status, error) {
                        ShowError("❌ " + (xhr.responseText || error));
                    }
                });

                return false;
            }

            // Helper to show errors
            function ShowError(msg, focusSelector) {
                $("#diverror").html("<p style='color: red; font-weight:bold; text-align:center;'>" + msg + "</p>");
                if (focusSelector) $(focusSelector).focus();
                return false;
            }
        });
    </script>
</asp:Content>
