﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Teller Cash Transactions
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
     <style type="text/css">
         td_amount_col{
             text-align:right;
         }
         div#loading, div#finished {
             position: absolute;
             width: 100%;
             height: 25px;
             background-color: #000;
             color: #FFF;
             text-align: center;
             padding-top: 5px;
         }
        #divMemberPhoto {
            width: 180px;
            height: 180px;
            background-position: center center;
            background-size: cover;
            -webkit-box-shadow: 0 0 1px 1px rgba(0, 0, 0, .3);
            display: inline-block;
        }
        #divMemberSignature {
            width: 180px;
            height: 180px;
            background-position: center center;
            background-size: cover;
            -webkit-box-shadow: 0 0 1px 1px rgba(0, 0, 0, .3);
            display: inline-block;
        }
        #divAccountDetails {
            width: 300px;
            height: 240px;
            /*height:100px;*/
            overflow:auto;
            /*width:auto;*/
            background-position: center center;
            background-size: cover;
            -webkit-box-shadow: 0 0 1px 1px rgba(0, 0, 0, .3);
            display: inline-block;
        }
        
    </style>

    <script type="text/javascript"  >
        
        $(document).ready(function () {


            var TransactionRequiresAuthorization_MaxTellerPayable = false;
            var TransactionRequiresAuthorization_NonCustomerAccount = false;
            var TransactionRequiresAuthorization_OverLimit = false;
            var MaxTellerPayable_Authorization = {};
            var NonCustomerAccount_Authorization = {};
            var OverLimit_Authorization = {};

            var strAccountName = "";
            var strAccountCode = "";

            var EmpCode_BR = "";
            var PayrollNo_BR = "";
            var MemberNo_BR = "";
            var MemberNames_BR = "";

            var LastTellerTransactionResult = null;



            $("#txtLogDate").datepicker({ dateFormat: 'dd/mm/yy' });
            $("#txtLogDate").val(SaccoSettings.DefaultCurrDateInUserFormat);




            strAccountName = "";
            strAccountCode = "";

            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });

            $("#tblPettyCashDetails").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });

            $('#tblTellerSummary_CM').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $('#tblMPAItems_BR').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $('#tblMemberDetails_BR').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $('#tblAccountMembers').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $('#tblCharges').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $('#tblTellersList_CM').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });

            $('#tblTransactionsLog').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": true

                //bJQueryUI: true,
                //sPaginationType: "full_numbers",
                //paging: false,
                //sScorollX: "900px",
                //sScrollY: "900px",
                //bScrollInfinite: true, //this property disables pagination
                //"bDestroy": true
            });
            $("#btnPrintLastSlip").on('click', function () {
                if (LastTellerTransactionResult == null) return;
                if (!LastTellerTransactionResult) return;
                var last_slip_url = global_site_root + "/Bank/BankSystem/TellerCashSlipReport?DBName=" + LastTellerTransactionResult.DBName + "&DocNo=" + LastTellerTransactionResult.DocNo + "&PeriodCode=" + LastTellerTransactionResult.PeriodCode + "&TransType=" + LastTellerTransactionResult.TransType;
                $("#ifrPdfSlip").attr("src", last_slip_url);
            });
            $("#txtPettyCashDocNo").on('focusout', function () {
                $("#txtPTDocDate").val("");
                $("#txtPTStatus").val("");
                $("#txtPTPaidTo").val("");
                $("#txtPTIDNo").val("");
                $("#txtPTTotal").val("0.00");

                $("#tblPettyCashDetails > tbody:last").children().remove();
                var petty_cash_doc_no = $("#txtPettyCashDocNo").val();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                if (petty_cash_doc_no.trim().length == 0) { return; }
                var outData = {
                    'DBName': $("#cboYear").val(),
                    'PayMode': "TELLER",
                    'DocNo': petty_cash_doc_no
                }
                var total_amount = 0;
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetPettyCashDocDetails") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var tbl = "<tr>";
                        var row_datas = response;
                        var tbl_row = "";
                        var bolDataAvailable = false;
                        $.each(row_datas, function (index, row_data) {
                            bolDataAvailable = true;
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + (index + 1).toString() + ") " + row_data.Description + "</td>";
                            tbl_row += "<td>" + row_data.ExpenseAcc + "</td>";
                            tbl_row += "<td>" + row_data.ExpenseAccName + "</td>";
                            tbl_row += "<td class='td_amount_col'>" + row_data.Amount.formatMoney() + "</td>";
                            tbl_row += "</tr>";
                            total_amount += (+row_data.Amount);
                        });
                        $("#bdPettyCashDetails").append(tbl_row);
                        if (bolDataAvailable == true) {
                            $("#txtPTDocDate").val(row_datas[0].TransDate);
                            $("#txtPTStatus").val(row_datas[0].Status);
                            $("#txtPTPaidTo").val(row_datas[0].PaidTo);
                            $("#txtPTIDNo").val(row_datas[0].IDNumber);
                        }
                        $("#txtPTTotal").val(total_amount.formatMoney());

                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });
            $("#btnPostPettyCash").on('click', function () {
                var outData = {
                    'DocNo': $("#txtPettyCashDocNo").val(),
                    'DBName': $("#cboYear").val()
                }
                outData = JSON.stringify(outData);
                xDialogConfirm("Post Petty Cash Doc No" + $("#txtPettyCashDocNo").val() + " Payable to " + $("#txtPTPaidTo").val() + " of ID No " + $("#txtPTIDNo").val() + " . Total Amount = " + $("#txtPTTotal").val() + " ?", "Confirm").then(function () {
                    $("#btnPostPettyCash").attr('disabled', true);
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/PostTellerPettyCash") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            xDialogMessage("Petty Cash Payment posted successfully", "Posted").then(function () {
                                $("#txtPTStatus").val("Posted");
                                $("#btnPostPettyCash").attr('disabled', false);
                                $("#txtPettyCashDocNo").focus();
                            });
                        },
                        error: function (xhr, status, error) {
                            $("#btnPostPettyCash").attr('disabled', false);
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            });
            $("#btnPost_CM").on('click', function () {
                var selected_index = $("#cboTransactionType_CM option:selected").index();
                amount_cm = 0;
                var ContraTellerAccName = "";
                var ContraTellerAccNo = "";
                var ContraTellerNames = "";
                var ContraTellerUserName = "";
                var TransactionType_CM = $("#cboTransactionType_CM").val();

                if (selected_index == 0) {
                    alert("Select Transaction Type");
                    return;
                }

                if (selected_index == 1 || selected_index == 2) {
                    amount_cm = $("#txtAmount_CM").val();
                    if (!isNumber(amount_cm)) {
                        alert("Invalid Amount");
                        return;
                    }
                    if (+amount_cm < 0) {
                        alert("Amount should be more than zero");
                        return;
                    }
                }
                var valid_count = 0;
                var valid_amount = 0;
                if (selected_index == 3 || selected_index == 4) {
                    $("#tblTellersList_CM tbody").find('tr').each(function (i) {
                        var row = $(this); //store in variable for faster access
                        valid_amount = row.find('td:eq(4)').find('input:eq(0)').val();
                        if (isNumber(valid_amount)) {
                            if (+valid_amount > 0) {
                                ContraTellerAccNo = row.find('td:eq(2)').text();
                                ContraTellerAccName = row.find('td:eq(3)').text();
                                ContraTellerNames = row.find('td:eq(1)').text();
                                ContraTellerUserName = row.find('td:eq(0)').text();
                                amount_cm = valid_amount;
                                valid_count++;
                            }
                        } else {
                            alert("Invalid amount at " + ContraTellerAccNo);
                            return;
                        }
                    });
                    if (valid_count > 1) {
                        alert("You can only receive/issue to one teller");
                        return;
                    }
                }
                var outData = {};
                outData.TransactionType = $("#cboTransactionType_CM").val();
                outData.TransactionAmount = amount_cm;
                outData.DocumentNo = $("#txtDocNo_CM").val();

                outData.OtherTellerAccNo = "";
                outData.OtherTellerUserName = "";
                outData.OtherTellerUserPass = "";
                outData.OtherTellerSalt = "";

                outData.CashManagerUserName = "";
                outData.CashManagerUserPass = "";
                outData.CashManagerSalt = "";

                outData.TellerUserName = "";
                outData.TellerUserPass = "";
                outData.TellerSalt = "";

                xDialogConfirm("Transactions Type: " + $("#cboTransactionType_CM option:selected").text() + ", Amount = " + amount_cm + ((ContraTellerAccNo == "") ? "" : ", Teller Name = " + ContraTellerNames), "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (data) { //teller auth
                        var UserName = data.UserName;
                        var Password = data.UserPass;
                        var pwdslt = getRandomInt(1000, 30000);
                        pwdslt = pwdslt.toString();
                        var pwd = CryptoJS.MD5(Password).toString();
                        pwd = pwd + pwdslt;
                        var sltpwd = CryptoJS.MD5(pwd).toString();
                        outData.TellerUserName = UserName;
                        outData.TellerUserPass = sltpwd;
                        outData.TellerSalt = pwdslt;
                        if (selected_index == 1 || selected_index == 2) { //cash manager auth
                            xDialogGetOtherUserCredetials("Enter cash manager username/password", "").then(function (data) {
                                var UserName = data.UserName;
                                var Password = data.UserPass;
                                var pwdslt = getRandomInt(1000, 30000);
                                pwdslt = pwdslt.toString();
                                var pwd = CryptoJS.MD5(Password).toString();
                                pwd = pwd + pwdslt;
                                var sltpwd = CryptoJS.MD5(pwd).toString();
                                outData.CashManagerUserName = UserName;
                                outData.CashManagerUserPass = sltpwd;
                                outData.CashManagerSalt = pwdslt;
                                PostTellerCashManagement(outData);
                            });
                        }
                        else {//other teller auth
                            xDialogGetOtherUserCredetials("Confirmation required from " + ContraTellerNames, ContraTellerUserName).then(function (data) {
                                var UserName = data.UserName;
                                var Password = data.UserPass;
                                var pwdslt = getRandomInt(1000, 30000);
                                pwdslt = pwdslt.toString();
                                var pwd = CryptoJS.MD5(Password).toString();
                                pwd = pwd + pwdslt;
                                var sltpwd = CryptoJS.MD5(pwd).toString();
                                outData.OtherTellerUserName = UserName;
                                outData.OtherTellerUserPass = sltpwd;
                                outData.OtherTellerSalt = pwdslt;
                                outData.OtherTellerAccNo = ContraTellerAccNo;
                                PostTellerCashManagement(outData);
                            });
                        }
                    });
                });
            });

            $("#cboTransactionType_CM").on('change', function () {
                var selected_index = $("#cboTransactionType_CM option:selected").index();
                $("#txtAmount_CM").val("N/A");
                $("#txtAmount_CM").attr('disabled', true);
                $('#divTellersList').find('input, textarea, button, select').attr('disabled', 'disabled');
                $("#tblTellersList_CM tbody").find('tr').each(function (i) {
                    var row = $(this); //store in variable for faster access
                    var txtAmt = row.find('td:eq(4)').find('input:eq(0)');
                    txtAmt.val("N/A");
                });
                if (selected_index == 3 || selected_index == 4) {
                    $('#divTellersList').find('input, textarea, button, select').attr('disabled', 'disabled').removeAttr('disabled');
                    $("#tblTellersList_CM tbody").find('tr').each(function (i) {
                        var row = $(this); //store in variable for faster access
                        var txtAmt = row.find('td:eq(4)').find('input:eq(0)');
                        txtAmt.val("0.00");
                    });
                } else if (selected_index == 1 || selected_index == 2) {
                    $("#txtAmount_CM").val("0.00");
                    $("#txtAmount_CM").attr('disabled', false);
                }
            });
            $("#txtAmount").on('focusout', function (e) {
                LoadTransactionCharges();
            });
            $("#cboTransactionType").on('change', function (e) {
                $("#tblCharges > tbody:last").children().remove();
                if (!isNumber($("#txtAmount").val())) {
                    return;
                }
                var amt = $("#txtAmount").val();
                if (+amt <= 0) {
                    return;
                }
                LoadTransactionCharges();
            });

            $("#txtSearchValue").val("");

            $("#cboSearchBy").on('change', function () {
                $('#divSearchDisplay').empty();
                $('#divSearchDisplay').append('Enter ' + $("#cboSearchBy option:selected").text());
                if (AccountMask != "") {
                    if ($("#cboSearchBy").val() == "accountno") {
                        $("#txtSearchValue").mask(AccountMask);
                    } else {
                        $("#txtSearchValue").unmask();
                    }
                }
            });
            $("#cboSearchBy").prop('selectedIndex', 0);
            $("#cboSearchBy").trigger('change');


            $("#txtSearchValue").on('focusout', function () {
                LoadCustomerAccounts();
            });
            $("#txtSearchValue").keypress(function (ev) {
                if (ev.keyCode == 13 || ev.which == 13) {
                    LoadCustomerAccounts();
                    ev.preventDefault();
                    return false;
                }
            });
            //$("#cboAccount").on('change click', function () {
            $("#cboAccount").on('change', function () {
                ClearAll();
                DisplayAccountDetails();
            });

            $("#btnGetAccounts").on('click', function () {
                LoadCustomerAccounts();
            });
            $("#btnRefreshLog").on('click', function () {
                DispTransactionsLog();
            });
            $('#tabs').on('tabsactivate', function (event, ui) {
                var newIndex = ui.newTab.index();
                if (newIndex == 4) {
                    DispTransactionsLog();
                }
                if (newIndex == 5) {
                    GetTellersSummary();
                    GetTellersInTellerGroup();
                    $("#cboTransactionType_CM").trigger('change');
                }
            });

            $("#cboYear").on('change', function () {
                var url = "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>"
                LoadFinancialPeriods($("#cboPeriod"), $(this).val(), url);
            });
            $("#cboSearchBy_BR").on('change', function () {
                $("#divSearchBy_BR").html($("#cboSearchBy_BR option:selected").text());
            });
            $("#btn_AddAcc_BR").on('click', function () {
                xDialogSelectGLAccount("ALL").then(function (data) {
                    var addedAccCode = data;
                    GetAccountName(addedAccCode).then(function (data) {
                        var bal_row = "<tr>" +
                                          "<td>O</td>" +
                                          "<td>" + addedAccCode + "</td>" +
                                          "<td>" + data + "</td>" +
                                          "<td style='text-align:right'>0.00</td>" +
                                          "<td style='text-align:right'><input type='text' id='Amount[]' value='0.00' style='text-align:right'/></td>" +
                                          "</tr>";

                        $("#bdMPAItems_BR").append(bal_row);
                    })
                });

            });
            $("#btnPost_BR").on('click', function () {
                if (EmpCode_BR == "" || PayrollNo_BR == "") {
                    alert("Invalid member record");
                    return;
                }
                var validCount = 0;
                var MPAItemsList = new Array();
                var dblTotalAmount = 0;
                $("#tblMPAItems_BR tbody").find('tr').each(function (i) {
                    var MPAItemEntry = {};
                    var row = $(this); //store in variable for faster access
                    MPAItemEntry.BalType = row.find('td:eq(0)').text();
                    MPAItemEntry.BalCode = row.find('td:eq(1)').text();
                    MPAItemEntry.BalName = row.find('td:eq(2)').text();
                    MPAItemEntry.BalAmount = row.find('td:eq(3)').text();
                    var txtAmt = row.find('td:eq(4)').find('input:eq(0)');
                    if (!isNumber(txtAmt.val())) {
                        alert("Invalid amount at row " + i);
                        return;
                    }
                    var line_amount = txtAmt.val();
                    line_amount = +line_amount;
                    if (line_amount < 0) {
                        alert("Amount " + line_amount + " should be more than or equal to Zero. At row " + i);
                        return;
                    }
                    if (line_amount > 0) {

                        dblTotalAmount = dblTotalAmount + line_amount;
                        MPAItemEntry.TransAmount = line_amount;
                        MPAItemsList[validCount] = MPAItemEntry;
                        validCount++;
                    }
                });
                if (dblTotalAmount <= 0) {
                    alert("Nothing to post");
                    return;
                }
                var outData = {
                    'EmpCode': EmpCode_BR,
                    'PayrollNo': PayrollNo_BR,
                    'PostEntries': MPAItemsList
                }
                outData = JSON.stringify(outData);
                //alert(outData);
                xDialogConfirm("Confirm Bosa Receipt. Total Amount = " + dblTotalAmount + ", Member Name = " + MemberNames_BR + ", PayrollNo = " + PayrollNo_BR + ", MemberNo = " + MemberNo_BR + "?", "Confirm").then(function () {
                    $("#btnPost_BR").attr('disabled', true);
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/PostTellerMPADepositTransaction") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            EmpCode_BR = "";
                            PayrollNo_BR = "";
                            MemberNames_BR = "";
                            MemberNo_BR = "";
                            xDialogMessage("Bosa Receipt posted successfully", "Posted").then(function () {
                                $("#cboSearchBy_BR").prop('selectedIndex', 0);
                                $("#txtSearchValue_BR").val("");
                                $("#tblMPAItems_BR > tbody:last").children().remove();
                                $("#tblMemberDetails_BR > tbody:last").children().remove();
                                $("#btnPost_BR").attr('disabled', false);
                                $("#cboSearchBy_BR").focus();
                                //DisplayTellerWithdrawalSlip($("#divTransactionSlip"), response, true);
                            });
                        },
                        error: function (xhr, status, error) {
                            $("#btnPost_BR").attr('disabled', false);
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            });

            $("#txtSearchValue_BR").on('focusout', function () {
                $("#tblMemberDetails_BR > tbody:last").children().remove();
                $("#tblMPAItems_BR > tbody:last").children().remove();
                EmpCode_BR = "";
                PayrollNo_BR = "";
                MemberNo_BR = "";
                MemberNames_BR = "";
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/TellerMemberBalancesSummaryReceipt") %>",
                    data: "{'SearchBy' : '" + $("#cboSearchBy_BR").val() + "','SearchValue' : '" + $("#txtSearchValue_BR").val() + "','EmpCode' : '" + $("#cboEmployer_BR").val() + "','IncludeNegativeLoans' : 'F'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var mpa_balances = response.MemberBals;
                        var mem_details = response.MemberDetails;
                        EmpCode_BR = mem_details.EmployerCode;
                        PayrollNo_BR = mem_details.PayrollNo;
                        MemberNo_BR = mem_details.MemberNo;
                        MemberNames_BR = mem_details.FullNames;
                        var tblMemDetails = "<tr><td>" + mem_details.MemberNo + "</td><td>" + mem_details.EmployerCode + "</td><td>" + mem_details.PayrollNo + "</td><td>" + mem_details.FullNames + "</td><td>" + mem_details.IDNumber + "</td></tr>";
                        $("#bdMemberDetails_BR").append(tblMemDetails);

                        var bal_row = "";
                        $.each(mpa_balances, function (index, mpa_balance) {
                            if (mpa_balance.BalType.substring(0, 1) != "F") { //no need to test for 'F' coz its filter at SQL level
                                bal_row += "<tr>" +
                                          "<td>" + mpa_balance.BalType + "</td>" +
                                          "<td>" + mpa_balance.BalCode + "</td>" +
                                          "<td>" + mpa_balance.BalName + "</td>" +
                                          "<td style='text-align:right'>" + mpa_balance.BalAmount.formatMoney() + "</td>" +
                                          "<td style='text-align:right'><input type='text' id='Amount[]' value='0.00' style='text-align:right'/></td>" +
                                          "</tr>";
                            }

                        });
                        if (bal_row != "") {
                            $("#bdMPAItems_BR").append(bal_row);
                        }
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });
            $(function () {
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetYears") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var years = response;
                        var obj = document.getElementById("cboYear");
                        $.each(years, function (index, yrs) {
                            var opt = document.createElement("option");
                            opt.value = yrs.DBName;
                            opt.text = yrs.UserDefinedYearName;
                            opt.selected = true;
                            obj.appendChild(opt);
                        });
                        $("#cboYear").get(0).selectedIndex = 0;
                        $("#cboYear").trigger('change');
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });


            $("#btnAddCharges").on('click', function () {
                var charge_acc_code = "";
                var charge_acc_name = "";
                xDialogSelectGLAccount("ALL").then(function (data) {
                    charge_acc_code = data;
                    GetAccountName(charge_acc_code).then(function (data) {
                        charge_acc_name = data;
                        var row = "<tr>";
                        row += "<td>" + charge_acc_code + "</td>";
                        row += "<td>" + charge_acc_name + "</td>";
                        row += "<td><input type='text' id='description[]' value=''/></td>";
                        row += "<td><input type='text' id='charges[]' value=''/></td>";
                        row += "</tr>";
                        $("#bdCharges").append(row);
                    })
                });
            });

            $("#btnPost").on('click', function () {
                if (strAccountCode == "") {
                    alert("Invalid Account");
                    return;
                }
                if ($("#cboTransactionType option:selected").index() == 0) {
                    alert("Select transaction type");
                    return;
                }
                var trans_amount = $("#txtAmount").val();
                if (!isNumber(trans_amount)) {
                    alert("Invalid Transaction amount");
                    return;
                }
                trans_amount = +trans_amount;
                if (trans_amount <= 0) {
                    alert("Invalid Transaction amount");
                    return;
                }
                var ChargesList = new Array();
                var dblTotalCharges = 0;
                $("#tblCharges tbody").find('tr').each(function (i) {
                    var ChargeEntry = {};
                    var row = $(this); //store in variable for faster access
                    ChargeEntry.AccountNo = row.find('td:eq(0)').text();
                    ChargeEntry.AccountName = row.find('td:eq(1)').text();
                    ChargeEntry.Description = row.find('td:eq(2)').find('input:eq(0)').val();
                    var txtAmt = row.find('td:eq(3)').find('input:eq(0)');
                    if (!isNumber(txtAmt.val())) {
                        //$(txtAmt).css('backgroundColor', 'red');
                        //txtAmt.css('backgroundColor', 'red');
                        //use either of above to get input box reference and change css using .cc or .addClass then remove on focus
                        alert("Invalid Charge amount at row " + i);
                        return;
                    }
                    var line_amount = txtAmt.val();
                    line_amount = +line_amount;
                    if (line_amount < 0) {
                        alert("Charge Amount " + line_amount + " should be more than or equal to Zero. At row " + i);
                        return;
                    }
                    dblTotalCharges = dblTotalCharges + line_amount;
                    ChargeEntry.Amount = line_amount;
                    ChargesList[i] = ChargeEntry;
                });
                var outData = {
                    'TransactionType': $("#cboTransactionType").val(),
                    'TransactionAmount': $("#txtAmount").val(),
                    'ATPNo': $("#txtATPNo").val(),
                    'Description': $("#txtDescription").val(),
                    'AccountNo': $("#cboAccount").val(),
                    'ChargesList': ChargesList
                }
                outData = JSON.stringify(outData);
                xDialogConfirm("Transactions Type: " + $("#cboTransactionType option:selected").text() + ", Account = " + $("#cboAccount").val() + ", Account Name = " + strAccountName + ", Amount = " + $("#txtAmount").val() + ", Charges = " + dblTotalCharges + "?", "Confirm").then(function () {
                    $("#btnPost").attr('disabled', true);
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/PostTellerTransactions") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            strAccountName = "";
                            strAccountCode = "";
                            LastTellerTransactionResult = response;
                            //var last_slip_url = global_site_root + "/Bank/BankSystem/TellerCashSlipReport?DBName=" + LastTellerTransactionResult.DBName + "&DocNo=" + LastTellerTransactionResult.DocNo + "&PeriodCode=" + LastTellerTransactionResult.PeriodCode + "&TransType=" + LastTellerTransactionResult.TransType;
                            var last_slip_url = global_site_root + "/Bank/BankSystem/TellerCashSlipReport?DBName=" + LastTellerTransactionResult.DBName + "&DocNo=" + LastTellerTransactionResult.DocNo + "&PeriodCode=" + LastTellerTransactionResult.PeriodCode + "&TransType=" + LastTellerTransactionResult.TransType;
                            $("#ifrPdfSlip").attr("src", last_slip_url);

                            xDialogMessage($("#cboTransactionType option:selected").text() + " posted successfully", "Posted").then(function () {
                                $("#txtAmount").val(0);
                                $("#cboSearchBy").prop('selectedIndex', 0);
                                $("#cboTransactionType").prop('selectedIndex', 0);
                                $("#cboAccount").empty().append("<SELECT ACCOUNT>").prop('selectedIndex', 0);
                                $("#txtDescription").val("");
                                $("#txtSearchBy").val("");
                                $("#txtSearchValue").val("");
                                $("#cboSearchBy").focus();
                                $("#tblAccountMembers > tbody:last").children().remove();
                                $("#tblCharges > tbody:last").children().remove();
                                $("#divMemberPhoto").html("");
                                $("#divMemberSignature").html("");
                                $("#btnPost").attr('disabled', false);
                                $("#cboSearchBy").focus();

                                TransactionRequiresAuthorization_MaxTellerPayable = false;
                                TransactionRequiresAuthorization_NonCustomerAccount = false;
                                TransactionRequiresAuthorization_OverLimit = false;
                                MaxTellerPayable_Authorization = {};
                                NonCustomerAccount_Authorization = {};
                                OverLimit_Authorization = {};





                                //DisplayTellerWithdrawalSlip($("#divTransactionSlip"),response,true);

                            });
                        },
                        error: function (xhr, status, error) {
                            $("#btnPost").attr('disabled', false);
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            });

            $("#btnModifyCharges").on('click', function () {
                xDialogGetAuthorizer("Enter username and password to modify charges").then(function (data) {
                    var UserName = data.UserName;
                    var Password = data.UserPass;
                    var pwdslt = getRandomInt(1000, 30000);
                    pwdslt = pwdslt.toString();
                    var pwd = CryptoJS.MD5(Password).toString();
                    pwd = pwd + pwdslt;
                    var sltpwd = CryptoJS.MD5(pwd).toString();

                    var outData = {
                        'UserID': UserName,
                        'Password': sltpwd,
                        'Salt': pwdslt,
                        'Privilege': "ModifyTellerCharges"
                    }
                    outData = JSON.stringify(outData);
                    var url = "<%: Url.Content("~/api/BankSystemApi/ValidateWebUserPrivilege") %>";
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: url,
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $('#divCharges').find('input, textarea, button, select').attr('disabled', 'disabled').removeAttr('disabled');;
                            $("#btnAddCharges").attr('disabled', 'disabled').removeAttr('disabled');
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            });

            $('#tblTransactionsLog tbody').on('click', 'tr', function () {
                //$('#tblTransactionsLog tbody tr').removeClass('row_selected');
                //$(this).addClass('row_selected');
                var DocNo = $(this).find('td').eq(2).text();
                var TransType = $(this).find('td').eq(3).text();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellerTransactionSlip") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'PeriodCode': $("#cboPeriod").val(), 'DocNo': DocNo, 'TransactionType': TransType }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        DisplayTellerWithdrawalSlip($("#divTransactionSlip"), response);
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });

            function PrintPdf2() {
                //http://stackoverflow.com/questions/472951/how-do-i-print-an-iframe-from-javascript-in-safari-chrome
                //http://stackoverflow.com/questions/24673024/unable-to-print-iframe-content-from-parent-page-in-ie-11
                //var browserName = navigator.userAgent.toLowerCase();
                //if (browserName.indexOf("msie") != -1) {
                //    window.document.getElementById('pdfFrame').print();
                //} else if (browserName.indexOf("trident") != -1) { //IE 11
                //    window.document.getElementById('pdfFrame').contentWindow.document.execCommand('print', false, null);
                //}
                //window.frames["ifrPdfSlip"].focus();
                ////window.frames["ifrPdfSlip"].contentWindow.print();
                //window.frames["ifrPdfSlip"].print();

                var iframe = document.frames ? document.frames["ifrPdfSlip"] : document.getElementById("ifrPdfSlip");
                var ifWin = iframe.contentWindow || iframe;
                iframe.focus();
                //ifWin.printPage();
                ifWin.print();
                return false;
            }
            $("#ifrPdfSlip").on('load', function () {
                // please note, that IE11 now returns undefined again for window.chrome
                //Google chrome  does not support automatice printing of pdf so...
                var isChromium = window.chrome,
                    vendorName = window.navigator.vendor;
                if (isChromium !== null && isChromium !== undefined && vendorName === "Google Inc.") {
                    setTimeout(PrintPdf2, 1000);
                }
                /*https://stackoverflow.com/questions/28016647/javascript-printing-the-contents-of-iframe-on-page-load-not-working
                 * setTimeout(function () {
                    $("#ifrPdfSlip").get(0).contentWindow.print();
                 }, 1000);
                 */ 
            });
            $("#btnTestSlip").on('click', function () {
                //$("#ifrPdfSlip").css("visibility", "hidden");
                var test_url = "http://localhost:37200/Bank/BankSystem/TellerCashSlipReport?DBName=BOSA000005&DocNo=0711-46-697-0002&PeriodCode=07&TransType=Cash%20Withdrawal";
                test_url = "http://localhost:37200/Bank/BankSystem/BOSAStatementReport?DBName=BOSA000005&EmpCode=001&PayrollNo=20000852&EndPeriod=07&StatementFormat=standard";
                $("#ifrPdfSlip").attr("src", test_url);
            });


            $("#btnPrint").click(function () {
                //$("#mySelector").printThis({
                //debug: false,              * show the iframe for debugging
                //importCSS: true,           * import page CSS
                //printContainer: true,      * grab outer container as well as the contents of the selector
                //loadCSS: "path/to/my.css", * path to additional css file
                //pageTitle: "",             * add title to print page
                //removeInline: false        * remove all inline styles from print elements

                var rptHeader = "";
                $("#divTransactionSlip").printThis({
                    debug: false,
                    pageTitle: "Transaction Slip",
                    removeInline: false,
                    printContainer: true,
                    importCSS: true,
                    header: rptHeader
                });
            });

            $(function () {
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAllEmployer") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var employers = response;
                        var obj = document.getElementById("cboEmployer");
                        $.each(employers, function (index, empl) {
                            $("#cboEmployer").append("<option value='" + empl.EmployerCode + "'>" + empl.EmployerName + "</option'>");
                            $("#cboEmployer_BR").append("<option value='" + empl.EmployerCode + "'>" + empl.EmployerName + "</option'>");
                        });
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            });
            function GetTellersInTellerGroup() {
                $("#tblTellersList_CM > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellersInTellerGroup") %>",
                    data: '{}',
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $.each(response, function (index, teller_detail) {
                            var tbl_row = "<tr><td>" + teller_detail.TellerName + "</td><td>" + teller_detail.UserFullNames + "</td><td>" + teller_detail.AccountCode + "</td><td>" + teller_detail.AccountName + "</td><td class='td_amount_col'><input type='text' id='txtTransferAmount[]' value='0' style='text-align:right'/></td></tr>";
                            $("#bdTellersList_CM").append(tbl_row);

                        });
                        $("#cboTransactionType_CM").trigger('change');

                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }
            function GetTellersSummary() {
                $("#tblTellerSummary_CM > tbody:last").children().remove();
                $("#divTellerBalance").html("<b>Your Balance is:</b>");
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellerSummary") %>",
                    data: '{}',
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $.each(response, function (index, teller_summary) {
                            $("#divTellerBalance").html("<b>Your Balance is: <u>" + teller_summary.CurrencySymbol + " " + teller_summary.Balance.formatMoney() + "</u></b>");
                            $("#bdTellerSummary_CM").append("<tr><td>Teller A/C</td><td>" + teller_summary.AccountCode + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><td>A/C Name</td><td>" + teller_summary.TellerAccountName + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><td>Balance</td><td>" + teller_summary.CurrencySymbol + " " + teller_summary.Balance.formatMoney() + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><td>Max Payable</td><td>" + teller_summary.MaxAmtPayable.formatMoney() + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><td>Max Float</td><td>" + teller_summary.MaxFloat.formatMoney() + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><td>Replenishing Level</td><td>" + teller_summary.ReplenishingLevel.formatMoney() + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><td>Shortage A/C</td><td>" + teller_summary.ShortageAccount + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><td>Surplus A/C</td><td>" + teller_summary.SurplusAccount + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><td>Treasury A/C</td><td>" + teller_summary.TreasuryAccount + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><td>Treasury A/C Name</td><td>" + teller_summary.TreasuryAccountName + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><td>RefID</td><td>" + teller_summary.RecID + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><td>Module</td><td>" + teller_summary.ModuleName + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><td>DocLastValue</td><td>" + teller_summary.DocLastValue + "</td></tr>");
                        });
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }
            function DispTransactionsLog() {
                $("#tblTransactionsLog > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellersTransactionLog") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'PeriodCode': $("#cboPeriod").val(), 'TransDate': $("#txtLogDate").val(), 'TellerAccount': '', 'TellerOnly': 'Y' }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var row = "";
                        $.each(response, function (index, teller_log) {


                            row = "<tr>";
                            row += "<td>" + teller_log.TransDate + "</td>";
                            row += "<td>" + teller_log.TransTime + "</td>";
                            row += "<td>" + teller_log.DocNo + "</td>";
                            row += "<td>" + teller_log.TransName + "</td>";
                            row += "<td class='td_amount_col'  style='padding-right:7px'>" + teller_log.Amount.formatMoney(); + "</td>";
                            row += "<td>" + teller_log.ContraAcc + "</td>";
                            row += "<td>" + teller_log.ContraAccName + "</td>";

                            var pdf_url = "<a href='" + global_site_root + "/Bank/BankSystem/TellerCashSlipReport?DBName=" + $("#cboYear").val() + "&DocNo=" + teller_log.DocNo + "&PeriodCode=" + $("#cboPeriod").val() + "&TransType=" + teller_log.TransName + "'>View Slip</a>";

                            row += "<td>" + pdf_url + "</td>";

                            row += "</tr>";
                            $("#bdTransactionsLog").append(row);
                        });
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }

            function ClearAll() {
                $("#tblAccountMembers > tbody:last").children().remove();
                $("#divAccountDetails").html("");
                $("#divMemberPhoto").html("");
                $("#divMemberSignature").html("");
            }
            function LoadImageFromUrl(path, width, height, target) {
                //add code to clear target first!!!
                $('<img src="' + path + '">')
                .load(function () {
                    $(this).width(width).height(height).appendTo(target);
                }).error(function () {
                    //display error somewhere
                });
            }
            function PostTellerCashManagement(outData) {

                outData = JSON.stringify(outData);

                $("#btnPost_CM").attr('disabled', true);
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/PostTellerCashManagement") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        GetTellersSummary();
                        xDialogMessage($("#cboTransactionType_CM option:selected").text() + " posted successfully", "Posted").then(function () {
                            $("#cboTransactionType_CM").prop('selectedIndex', 0);
                            $("#btnPost_CM").attr('disabled', false);
                        });
                    },
                    error: function (xhr, status, error) {
                        $("#btnPost_CM").attr('disabled', false);
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
alert('Error - ' + errorMessage);
                    }
                });

            }
            function DisplayAccountDetails() {
                ClearAll();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellerTransactingAccountDetails") %>",
                    data: JSON.stringify({ 'TransactingAccount': $("#cboAccount").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        if (response.IsCustomerAccount == true) {
                            var MemAcc = response.detailedCustomerAccount.MemberAcc;
                            strAccountName = MemAcc.AccountName;
                            strAccountCode = MemAcc.AccountNo;
                            var strAccDetails = "<table>";
                            strAccDetails += "<tr><td>Account Name</td><td>" + MemAcc.AccountName + "</td></tr>";
                            strAccDetails += "<tr><td>Account No</td><td>" + MemAcc.AccountNo + "</td></tr>";
                            strAccDetails += "<tr><td>Acc Type</td><td>" + MemAcc.AccountType + "</td></tr>";
                            strAccDetails += "<tr><td>Available Balance</td><td>" + response.detailedCustomerAccount.AvailableBalance + "</td></tr>";
                            strAccDetails += "<tr><td>Actual Balance</td><td>" + response.detailedCustomerAccount.LedgerBalance + "</td></tr>";
                            strAccDetails += "<tr><td>Type Name</td><td>" + MemAcc.AccountTypeName + "</td></tr>";
                            strAccDetails += "<tr><td>File No</td><td>" + MemAcc.FileNo + "</td></tr>";
                            strAccDetails += "<tr><td>Last Deposit Date</td><td>" + MemAcc.DateOfLastDeposit + "</td></tr>";
                            strAccDetails += "<tr><td>Last Withdrawal Date</td><td>" + MemAcc.DateOfLastWithdrawal + "</td></tr>";
                            strAccDetails += "<tr><td>Date Openned</td><td>" + MemAcc.OpenningDate + "</td></tr>";
                            strAccDetails += "<tr><td>Branch</td><td>" + MemAcc.BranchName + "</td></tr>";
                            strAccDetails += "<tr><td>Status</td><td>" + MemAcc.Status + "</td></tr>";
                            strAccDetails += "<tr><td>Instructions</td><td>" + MemAcc.Instructions + "</td></tr>";
                            strAccDetails += "</table>";

                            $("#divAccountDetails").html(strAccDetails);
                            var acc_members = response.detailedCustomerAccount.AccountMembers;
                            var row = "";
                            $.each(acc_members, function (index, acc_member) {
                                row = "<tr>";
                                row += "<td>" + acc_member.EmployerCode + "</td>";
                                row += "<td>" + acc_member.PayrollNo + "</td>";
                                row += "<td>" + acc_member.MemberNo + "</td>";
                                row += "<td>" + acc_member.IDNumber + "</td>";
                                row += "<td>" + acc_member.FullNames + "</td>";
                                row += "</tr>";
                                $("#bdAccountMembers").append(row);
                            });
                            LoadImageFromUrl(response.detailedCustomerAccount.PhotoPath, 180, 180, $("#divMemberPhoto"));
                            LoadImageFromUrl(response.detailedCustomerAccount.SignaturePath, 180, 180, $("#divMemberSignature"));
                        } else {
                            strAccountName = response.otherAccountDetails.AccountName;
                            strAccountCode = response.otherAccountDetails.UserCode;
                            var strAccDetails = "Account Name : " + response.otherAccountDetails.AccountName + "</br>";
                            strAccDetails += "Account No : " + response.otherAccountDetails.UserCode + "</br>";
                            strAccDetails += "Acc Type : " + "Non-Customer Account" + "</br>";
                            $("#divAccountDetails").html(strAccDetails);
                        }
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
alert('Error - ' + errorMessage);
                    }
                });
            }

            function LoadTransactionCharges() {
                $("#tblCharges > tbody:last").children().remove();
                if (!isNumber($("#txtAmount").val())) {
                    alert("Invalid Amount");
                    return;
                }
                var amt = $("#txtAmount").val();
                if (+amt <= 0) {
                    alert("Invalid Amount");
                    return;
                }

                $("#tblCharges > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellerTransactionCharges") %>",
                    data: JSON.stringify({ 'CustomerAccount': $("#cboAccount").val(), 'TransactionType': $("#cboTransactionType").val(), 'TransactionAmount': $("#txtAmount").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var trans_charges = response.ChargeDetails;
                        var row = "";
                        $.each(trans_charges, function (index, trans_charge) {
                            row = "<tr>";
                            row += "<td>" + trans_charge.AccountNo + "</td>";
                            row += "<td>" + trans_charge.AccountName + "</td>";
                            row += "<td><input type='text' id='description[]' value='" + trans_charge.Description + "'/></td>";
                            row += "<td><input type='text' id='charges[]' value='" + trans_charge.Amount + "'/></td>";
                            row += "</tr>";
                            $("#bdCharges").append(row);
                        });
                        $('#divCharges').find('input, textarea, button, select a').attr('disabled', 'disabled');
                        $("#btnAddCharges").attr('disabled', 'disabled');
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
alert('Error - ' + errorMessage);
                    }
                });

            }


            function LoadCustomerAccounts() {
                $("#cboAccount").empty();
                $("#cboAccount").append('<option selected>NO ACCOUNT</option>');
                if ($("#txtSearchValue").val().trim() == "") { return; }
                if ($("#txtSearchValue").val().trim() == AccountMask) { return; }

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetBankStatementAccounts") %>",
                    data: JSON.stringify({ 'SearchBy': $("#cboSearchBy").val(), 'SearchValue': $("#txtSearchValue").val(), 'EmpCode': $("#cboEmployer").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var customerAccounts = response;
                        var obj = document.getElementById("cboAccount");
                        $("#cboAccount").empty();
                        $.each(customerAccounts, function (index, customerAccount) {
                            var opt = document.createElement("option");
                            opt.value = customerAccount.UserCode;
                            opt.text = "A/C: " + customerAccount.UserCode + " A/C Name: " + customerAccount.AccountName;
                            obj.appendChild(opt);
                        });
                        DisplayAccountDetails();
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }
            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion();
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">

    <p>Teller Cash Transactions</p>

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div id="tabs" style="font-size:12px">
      <ul>
        <li><a href="#tabs-1">Cash Transactions</a></li>
        <li><a href="#tabs-2">BOSA Receipts</a></li>
        <li><a href="#tabs-3">Petty Cash</a></li>
        <li><a href="#tabs-4">Non-Customer Chq. Sales</a></li>
        <li><a href="#tabs-5">Transaction Log</a></li>
        <li><a href="#tabs-6">Cash Management</a></li>
      </ul>
    <form id="frmMain" name="frmMain" >
        <div id="tabs-1" >
    <%= Html.AntiForgeryToken() %>
    <table border="1" style="padding: 1px; margin: 1px; font-size:12px">
        <tr><td></td><td></td><td></td><td></td><td></td></tr>
        <tr><td></td><td></td>
            <td rowspan="9">
                Account Details:<br />
                <div id="divAccountDetails" ></div>
            </td>
            <td rowspan="9">
                Member Photo:<br />
                <div id="divMemberPhoto"></div>
            </td>
            <td rowspan="9">
                Member Signature:<br />
                <div id="divMemberSignature"></div>
            </td>
        </tr>
        <tr><td>Search By:</td><td><select id="cboSearchBy">
                                        <option value="accountno" selected>AccountNo</option>
                                        <option value="memberno">MemberNo</option>
                                        <option value="idnumber">IDNo</option>
                                        <option value="payrollno">PayrollNo</option>
                                   </select>
            </td>
            </tr>
        <tr>
            <td>Employer:</td><td><select id="cboEmployer">
                                        <option value="selectemployer" selected>SELECT EMPLOYER</option>
                                   </select>
            </td>
        </tr>
        <tr>
            <td><div id="divSearchDisplay">Search Value</div></td><td><input type="text" id="txtSearchValue" /></td>
        </tr>
        
        <tr><td>Select Account</td><td><select id="cboAccount"><option>SELECT ACCOUNT</option></select></td></tr>
        <tr><td>Transaction Type</td><td><select id="cboTransactionType"><option selected value="">SELECT TRANSACTION</option>
                                                                         <option value="cash withdrawal">CASH WITHDRAWAL</option>
                                                                         <option value="cash deposit">CASH DEPOSIT</option>

                                         </select></td></tr>
        <tr><td>Amount</td><td><input type="text" id="txtAmount"/></td></tr>
        <tr><td>ATP No.</td><td><input type="text" id="txtATPNo"/></td></tr>
        <tr><td>Description</td><td><input type="text" id="txtDescription"/></td></tr>
        <tr><td>Account Members</td><td colspan ="4"><hr style="color:red" /></td></tr>
        <tr><td colspan="5">
               <div style="height:100px;overflow:auto;width:auto;">
                 <table id='tblAccountMembers' class='display'>
                    <thead>
                        <tr>
                        <th style="text-align: left"><b>EmpCode</b></th>
                        <th style="text-align: left"><b>PayrollNo</b></th>
                        <th style="text-align: left"><b>MemberNo</b></th>
                        <th style="text-align: left"><b>IDNo</b></th>
                        <th style="text-align: left"><b>Names</b></th>
                        </tr>
                    </thead>
                    <tbody id='bdAccountMembers'>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
           </td>
        </tr>
        <tr><td>Transaction Charges</td><td colspan ="4"><hr style="color:red" /></td></tr>
        <tr><td colspan="5">
               <div id="divCharges" style="height:100px;overflow:auto;width:auto;">
                 <table id='tblCharges' class='display'>
                    <thead>
                        <tr>
                        <th style="text-align: left"><b>Account No</b></th>
                        <th style="text-align: left"><b>Acc/ Name</b></th>
                        <th style="text-align: left"><b>Description</b></th>
                        <th style="text-align: right"><b>Amount</b></th>
                        </tr>
                    </thead>
                    <tbody id='bdCharges'>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
           </td>
        </tr>
        <tr><td><input type="button" id="btnPrintLastSlip" value="Print Last Slip"/></td><td><input type="button" id="btnModifyCharges" value="Modify Charges"/></td><td><input type="button" id="btnAddCharges" value="Add Charge"/></td><td><input type="button" id="btnPost" value="Post"/></td><td></td></tr>
    </table>
    </div>
        <div id="tabs-2">  <%--BOSA Receipts--%>
            <table>
                <tr>
                    <td>Search By:</td><td><select id="cboSearchBy_BR">
                                            <option value="memberno">MemberNo</option>
                                            <option value="idnumber">IDNo</option>
                                            <option value="payrollno">PayrollNo</option>
                                           </select></td>
                    <td>Employer:</td><td><select id="cboEmployer_BR">
                                        <option value="selectemployer" selected>SELECT EMPLOYER</option>
                                   </select>
                    </td><td><div id="divSearchBy_BR">Search Value:</div></td><td><input type="text" id="txtSearchValue_BR" /></td>
                </tr>
                <tr>
                    <td colspan="6">
                        Member Details:<hr />
                    </td>
                </tr>
                <tr>
                    <td colspan="6">
                        <div id="divMemberDetails_BR" style="height:auto;overflow:auto;width:auto;">
                            <table id='tblMemberDetails_BR' class="display">
                            <thead>
                                <tr>
                                <th><b>MemberNo</b></th>
                                <th><b>EmpCode</b></th>
                                <th><b>PayrollNo</b></th>
                                <th><b>Names</b></th>
                                <th><b>IDNo</b></th>
                                </tr>
                            </thead>
                            <tbody id='bdMemberDetails_BR'>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td></td><td></td><td></td><td></td><td></td>
                                </tr>
                            </tfoot>
                            </table>  
                        </div>
                    </td>
                </tr>
                <tr>
                    <td colspan="6" style="height:100px;overflow:auto;width:auto;">
                        MPA Items:<hr />
                    </td>
                </tr>
                <tr>
                    <td colspan="6">
                        <div id="divMPAItems_BR" style="height:200px;overflow:auto;width:auto;">
                            <table id='tblMPAItems_BR' class="display">
                            <thead>
                                <tr>
                                <th><b>Type</b></th>
                                <th><b>Code</b></th>
                                <th><b>Name</b></th>
                                <th style="text-align:right"><b>Balance</b></th>
                                <th style="text-align:right"><b>Amount</b></th>
                                </tr>
                            </thead>
                            <tbody id='bdMPAItems_BR'>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td></td><td></td><td></td><td></td><td></td>
                                </tr>
                            </tfoot>
                            </table> 
                        </div>
                    </td>
                </tr>
                <tr>
                    <td><input type="button" id="btn_AddAcc_BR" value="Add A/C" /></td>
                    <td colspan="4">
                        <input type="button" id="btnPost_BR" value="Post" />
                    </td>
                </tr>
            </table>
        </div>
        <div id="tabs-3">
            <table>
                <tr>
                    <td>Petty Cash Doc No:</td>
                    <td><input type="text" id="txtPettyCashDocNo"/></td>
                    <td>Doc Date:</td>
                    <td><input type="text" id="txtPTDocDate" readonly="true"/></td>
                    <td>Status:</td>
                    <td><input type="text" id="txtPTStatus" readonly="true"/></td>
                </tr>
                <tr>
                    <td>Paid To:</td>
                    <td><input type="text" id="txtPTPaidTo"  readonly="true"/></td>
                    <td>ID Number:</td>
                    <td><input type="text" id="txtPTIDNo"  readonly="true"/></td>
                    <td>Total:</td>
                    <td><input type="text" id="txtPTTotal"  readonly="true"/></td>
                </tr>
            </table>
            <div id="divPettyCashDetails" style="height:200px;overflow:auto;width:auto;">
                <table id='tblPettyCashDetails' class="display"  style="width:100%">
                        <thead>
                            <tr>
                            <th>Narration</th>
                            <th>Account</th>
                            <th>Acc Name</th>
                            <th class="td_amount_col">Amount</th>
                            <th></th>
                            </tr>
                        </thead>
                        <tbody id='bdPettyCashDetails'>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td></td><td></td><td></td><td></td><td></td>
                            </tr>
                        </tfoot>
                </table>
            </div>
            <table>
                <tr>
                    <td></td><td><input type="button" id="btnPostPettyCash" value="Post Petty Cash"/></td>
                </tr>
            </table>
        </div>
        <div id="tabs-4">

        </div>
        <div id="tabs-5">
            <table>
                <tr><td>Year</td><td><select id="cboYear"></select></td><td>Month</td><td><select id="cboPeriod"></select></td><td>Date</td><td><input type="text" id="txtLogDate"/></td></tr>
                <tr><td><input type="button" id="btnRefreshLog" value="Refresh Log"/></td></tr>
            </table>
            <div id="divTransactionsLog" style="font-size:9px; height:400px;overflow:auto;width:auto;" class="table table-responsive">
                 <table id='tblTransactionsLog' class="table table-responsive table-striped">
                            <thead>
                                <tr>
                                <th><b>Date</b></th>
                                <th><b>Time</b></th>
                                <th><b>Doc No</b></th>
                                <th><b>Type</b></th>
                                <th class='td_amount_col' style="padding-right:7px"><b>Amount</b></th>
                                <th><b>AccountNo</b></th>
                                <th><b>AccountName</b></th>
                                <th><b>View Slip</b></th>
                                </tr>
                            </thead>
                            <tbody id='bdTransactionsLog'>
                            </tbody>
                        <tfoot>
                            <tr>
                                <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                            </tr>
                        </tfoot>
                    </table>     
            </div>
            
        </div>
        <div id="tabs-6">
            <div id="divCashManagement">
                <div id="divTellerBalance"></div>
                <hr />
                Teller Summary:<hr />
                <div id="divTellersummary" style="height:100px;overflow:auto;width:auto;">
                    <table id='tblTellerSummary_CM' class="display">
                        <thead>
                            <tr>
                            <th style="padding-right:7px"><b>Description</b></th>
                            <th style="padding-right:7px"><b>Value</b></th>
                            </tr>
                        </thead>
                        <tbody id='bdTellerSummary_CM'>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td></td><td></td>
                            </tr>
                        </tfoot>
                        </table> 
                </div>
                <hr />
                Cash Management:<hr />
                <div>
                        <table>
                                <tr>
                                <td>
                                    Select Transaction Type:
                                </td>
                                <td>
                                <select id="cboTransactionType_CM">
                                    <option selected value="">(SELECT TRANSACTION)</option>
                                    <option value="receive from treasury">Receive From Treasury</option>
                                    <option value="return to treasury">Return To Treasury</option>
                                    <option value="Issue to teller">Issue To Teller</option>
                                    <option value="receive from teller">Receive From Teller</option>
                                </select>
                                </td>
                                <td>Amount</td>
                                <td><input type="text" id="txtAmount_CM"/></td>
                                <td>Doc. No</td>
                                <td><input type="text" id="txtDocNo_CM"/></td>
                                </tr>
                            <tr>
                            <td colspan="6">
                                <div id="divTellersList" style="height:200px;overflow:auto;width:auto;">
                                    <table id='tblTellersList_CM' class="display">
                                        <thead>
                                            <tr>
                                            <th><b>Login</b></th>
                                            <th><b>Names</b></th>
                                            <th><b>Teller A/C</b></th>
                                            <th><b>A/C Name</b></th>
                                            <th class='td_amount_col' style="padding-right:7px"><b>Amount</b></th>
                                            </tr>
                                        </thead>
                                        <tbody id='bdTellersList_CM'>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td></td><td></td><td></td><td></td><td></td>
                                            </tr>
                                        </tfoot>
                                        </table> 
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
                <table>
                    <tr><td><input type="button" id="btnPost_CM" value="Post"/></td></tr>
                </table>
            </div>
        </div>
        
        <iframe id="ifrPdfSlip" name="ifrPdfSlip"  width="300" height="400" style="visibility:hidden">
                        
        </iframe>
    </form>

 </div>



    

</asp:Content>


