﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Salaries And Other Credits
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .auto-style1 {
            width: 153px;
        }
        .colamount {
            text-align:right;
         }
        .alert {
            font-size: 1.3em;
            padding: 1em;
            text-align: center;
            white-space: nowrap;
            width: auto;
            word-wrap: normal;
        }
        .tblDRCRDetails {
            margin: 1px;
            border: 1em;
            padding-left: 1em;
            padding-top: 1em;
            border-collapse: separate;
        }

        tr.row_selected td {
            background-color: lawngreen;
        }
    </style>


    <!--Reference the SignalR library. -->
    <script src="/Scripts/jquery.signalR-2.2.0.js"></script>
    <!--Reference the autogenerated SignalR hub script. -->
    <!-- <script src="/signalr/hubs"></script> -->
    
    <!-- try Url.Content("~/signalr/hubs") -->
    <script src='<%: ResolveClientUrl("~/signalr/hubs") %>'></script> <!-- dynamically generated hub do not use <script src="/signalr/hubs"></script> cause its only working locally. fails on deployemt to IIS -->

    <!--Add script to update the page and send messages.-->
    <script type="text/javascript">
        $(document).ready(function () {
            var SaccoSettings = null;
            var IsValidMemberAccount = false;
            var SuccessFileName = "";
            // Declare a proxy to reference the hub. 
            var progresProxy = $.connection.progressHub; //note name of class starts with lower case (SignalRChart.SignalRChat.progressHub)
            progresProxy.client.processingProgress = function (progressMessage, progressPercentage) {
                $("#txtProgress").val(progressMessage);
                $("#prgProgress").css("width", progressPercentage + "%").text(progressMessage).attr('aria-valuenow', progressPercentage);
            };

            
            progresProxy.client.processingProgressMessage = function (data) {
                $("#divUploadNotes").append(data + "<br\>");
            };
            progresProxy.client.processingStarting = function (data) {
                $("#prgProgress").css("width", 0 + "%").text("").attr('aria-valuenow', 0);
                $("#txtProgress").val("");
            };
            
            progresProxy.client.processingComplete = function (data) {

                $("#prgProgress").css("width", 0 + "%").text("").attr('aria-valuenow', 0);
                $("#txtProgress").val("");

                alert("Processing Complete");
                try {
                    if (data.IsFileProcessingResult) {
                        SuccessFileName = data.SuccessFileName;
                        $("#divProcessingResult").append("Success Count " + data.SuccessCount + "<br\>");
                        $("#divProcessingResult").append("Failure Count " + data.FailCount + "<br\>");
                        $("#divProcessingResult").append("<a id='linkSuccessFile' href='" + appBaseFullUrl + data.SuccessFilePathUrl + "'>View Success File</a><br\>");
                        $("#divProcessingResult").append("<a href='" + appBaseFullUrl + data.FailureFilePathUrl + "'>View Failure File</a><br\>");
                        $('#btnSaveFileImport').attr("disabled", false);

                    }
                    if (data.IsSalaryPostingResult) {
                        SuccessFileName = "";
                        $("#divProcessingResult").append("Posted Success Count " + data.SuccessCount + "<br\>");
                        $("#divProcessingResult").append("Posted Failure Count " + data.FailCount + "<br\>");
                        $("#divProcessingResult").append("<a id='linkSuccessFile' href='" + appBaseFullUrl + data.SuccessFilePathUrl + "'>View Success File</a><br\>");
                        $("#divProcessingResult").append("<a href='" + appBaseFullUrl + data.FailureFilePathUrl + "'>View Failure File</a><br\>");

                        $('#btnSaveFileImport').attr("disabled", true);
                        DispBatchesSummary();

                    }
                
                }catch(err){
                    alert("Error: " + err.message);
                }
            };
            $.connection.hub.start().done(function () {
                var connectionId = $.connection.hub.id;
                $("#divUploadNotes").append('SignalR Info: Connected. id is ' + connectionId +  ' <br\>');
            });


            $.connection.hub.error(function (error) {
                //console.log('SignalR error: ' + error)
                $("#divUploadNotes").append('SignalR ERROR: ' + error +"<br\>");
                
            });

            

            $("#btnRefresh").on('click', function () {
                DispBatchesSummary();
            });
            $("#btnSaveFileImport").on('click', function () {
                $.connection.hub.start().done(function () {
                    var connectionId = $.connection.hub.id;

                    var worksheetName = $("#cboPeriod").val() + "_" + $("#cboPaymentType option:selected").text();
                    worksheetName = worksheetName.replace(/\s+/g, '_'); //replace space with underscore like vb
                    var msg = "Ensure WorkBook has worksheet named " + worksheetName + " . Proceed saving file in batch?";

                    xDialogConfirm(msg, "Confirm").then(function () {
                        xDialogGetUserCredetials().then(function (credentials) {
                            var UserName = credentials.UserName;
                            var Password = credentials.UserPass;
                            var pwdslt = getRandomInt(1000, 30000);
                            pwdslt = pwdslt.toString();
                            var pwd = CryptoJS.MD5(Password).toString();
                            pwd = pwd + pwdslt;
                            var sltpwd = CryptoJS.MD5(pwd).toString();

                            var outData = {
                                'DBName': $("#cboYear").val(),
                                'PeriodCode': $("#cboPeriod").val(),
                                'BatchNo': $("#txtBatchNo").val(),
                                'CreditType': $("#cboPaymentType").val(),
                                'SignalR_ID': connectionId,
                                'Salt': pwdslt,
                                'Password': sltpwd,
                                'WorkSheetName': worksheetName,
                                'SalaryFileType': $("#cboSalaryFileType").val(),
                                'SalaryFileName': SuccessFileName,
                            };

                            outData = JSON.stringify(outData);
                            //alert(outData);


                            var csrfToken = $("input[name='__RequestVerificationToken']").val();

                            $("#divProcessingResult").html("");
                            $("#divUploadNotes").html("");
                            

                            $("#prgProgress").css("width", 0 + "%").text("").attr('aria-valuenow', 0);
                            $("#txtProgress").val("");
                            //Content(" + path1 + ") %>"';
                            $.ajax({
                                headers: { __RequestVerificationToken: csrfToken },
                                type: "POST",
                                url: "<%: Url.Content("~/api/BankSystemApi/SaveSalaryFile") %>",
                                contentType: "application/json; charset=utf-8",
                                data: outData,
                                dataType: "json",
                                success: function (messages) {
                                    $("#divUploadNotes").append(messages + "<br/>");

                                    //$('#btnSaveFileImport').attr("disabled", true);
                                    //SuccessFileName = "";
                                },
                                error: function (xhr, status, error) {
                                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                                    alert('Error - ' + errorMessage);
                                }
                            });
                        });
                    });
                });
            });
            

            $("#btnUploadSalaryFile").on('click', function (e) {
                
                //TODO: Add code to resize image here or in Action before saving
                var SalaryFiles = $("#flSalary").get(0).files;
                if (SalaryFiles.length > 1) { alert("select only one Salary File"); return;}
                if (SalaryFiles.length == 0) { alert("select Salary File"); return;}
                var postdata = new FormData();
                for (i = 0; i < SalaryFiles.length; i++) {
                var filename = SalaryFiles[i].name.toString()
                        
                        var ext = filename.substring(filename.lastIndexOf('.') + 1).toLowerCase();
                    postdata.append("SalaryFile", SalaryFiles[i]);
                        
                }
                $.connection.hub.start().done(function () {
                    var connectionId = $.connection.hub.id;

                    

                    if (document.getElementById("cboSalaryFileType").selectedIndex == 0) {
                        alert("Select File Type");
                        return;
                    }
                    var worksheetName = $("#cboPeriod").val() + "_" + $("#cboPaymentType option:selected").text(); //like vb
                    worksheetName = worksheetName.replace(/\s+/g, '_'); //replace space with underscore like vb
                    var msg = "Ensure WorkBook has worksheet named " + worksheetName + " . Proceed?";
                    
                    xDialogConfirm(msg, "Confirm").then(function () {
                        xDialogGetUserCredetials().then(function (credentials) {
                            var UserName = credentials.UserName;
                            var Password = credentials.UserPass;
                            var pwdslt = getRandomInt(1000, 30000);
                            pwdslt = pwdslt.toString();
                            var pwd = CryptoJS.MD5(Password).toString();
                            pwd = pwd + pwdslt;
                            var sltpwd = CryptoJS.MD5(pwd).toString();

                            postdata.append("DBName", $("#cboYear").val());
                            postdata.append("PeriodCode", $("#cboPeriod").val());
                            postdata.append("BatchNo", $("#txtBatchNo").val());
                            postdata.append("CreditType", $("#cboPaymentType").val());
                            postdata.append("SignalR_ID", connectionId);
                            postdata.append("Salt", pwdslt);
                            postdata.append("Password", sltpwd);
                            postdata.append("WorkSheetName", worksheetName);
                            postdata.append("SalaryFileType", $("#cboSalaryFileType").val());


                            var csrfToken = $("input[name='__RequestVerificationToken']").val();

                            
                            $('#btnSaveFileImport').attr("disabled", true);
                            $("#divProcessingResult").html("");
                            $("#divUploadNotes").html("");
                            SuccessFileName = "";

                            $("#prgProgress").css("width", 0 + "%").text("").attr('aria-valuenow', 0);
                            $("#txtProgress").val("");

                            $.ajax({
                                headers: { __RequestVerificationToken: csrfToken },
                                type: "POST",
                                url: "<%: Url.Content("~/api/BankSystemApi/UploadSalaryFile") %>",
                                contentType: false,
                                data: postdata,
                                processData: false,
                                success: function (messages) {
                                    $("#divUploadNotes").append(messages + "<br/>");
                                },
                                error: function (xhr, status, error) {
                                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                                    alert('Error - ' + errorMessage);
                                }
                            });
                        });
                    });
                });
            });
            DisableBatchHeader();
            DisableDataEntry();

            $("#txtDate").datepicker({ dateFormat: 'dd/mm/yy' });
            $("#txtBatchDate").datepicker({ dateFormat: 'dd/mm/yy' });

            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });

            $("#cboYear").on('change', function () {
                LoadFinancialPeriods();
            });
            $("#cboPeriod").on('change', function () {
                $("#tblMemAccDetails > tbody:last").children().remove();
                $("#tblBatchContents > tbody:last").children().remove();
                $("#txtBatchNo").val("");
                $("#txtChequeNo").val("");
                $("#txtBatchDate").val("");
                $("#cboPaymentType").get(0).selectedIndex = 0;
                $("#btnEditTransactions").prop('disabled', false);
                DispBatchesSummary();
            });

            $("#cboFilterPostedStatus").on('click', function () {
                DispBatchesSummary();
            });
            $("#cboSearchBy").on("change", function (e) {
                $("#divSearchByValue").html("Enter " + $("#cboSearchBy option:selected").text());
                if (AccountMask != "") {
                    if ($("#cboSearchBy").val() == "accountno") {
                        $("#txtSearchValue").mask(AccountMask);
                    } else {
                        $("#txtSearchValue").unmask();
                    }
                }
            });
            $("#txtSearchValue").on('focusout', function () {
                GetMemberSalaryAccount();
            });
            $("#txtSearchValue").on('change paste keyup', function () {
                //alert("Clearing");
                $("#tblMemAccDetails > tbody:last").children().remove();
                $("#txtFoundAccNo").val("");
                $("#txtFoundAccName").val("");
            });
            $("#txtSearchValue").keypress(function (ev) {
                if (ev.keyCode == 13 || ev.which == 13) {
                    GetMemberSalaryAccount();
                    ev.preventDefault();
                    return false;
                }
            });

            $("#btnNewBatch").on('click', function () {
                $("#tblMemAccDetails > tbody:last").children().remove();
                $("#tblBatchContents > tbody:last").children().remove();
                $("#txtBatchNo").val("");
                $("#txtChequeNo").val("");
                $("#txtBatchDate").val("");
                $("#cboPaymentType").get(0).selectedIndex = 0;
                $("#btnEditTransactions").prop('disabled', false);
                EnableBatchHeader();
                DisableDataEntry();

            });

           
            

            $('#tabs').on('tabsactivate', function (event, ui) {
                var newIndex = ui.newTab.index();
                if (newIndex == 1) {
                    DispBatchesSummary();
                    EnableBatchHeader();
                    DisableDataEntry();
                } else if (newIndex == 0) {
                    DisableBatchHeader();
                }
            });

            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetSalariesModulesConfig") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response.Years;
                    var employers = response.Employers;
                    var creditTypes = response.CreditTypes;
                    SaccoSettings = response.SaccoSettings;

                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    var obj = document.getElementById("cboEmployer");
                    $.each(employers, function (index, empl) {
                        var opt = document.createElement("option");
                        opt.value = empl.EmployerCode;
                        opt.text = empl.EmployerName;
                        obj.appendChild(opt);
                    });

                    var obj = document.getElementById("cboSearchEmployer");
                    $.each(employers, function (index, empl) {
                        var opt = document.createElement("option");
                        opt.value = empl.EmployerCode;
                        opt.text = empl.EmployerName;
                        obj.appendChild(opt);
                    });

                    var obj = document.getElementById("cboPaymentType");
                    $.each(creditTypes, function (index, creditType) {
                        var opt = document.createElement("option");
                        opt.value = creditType.CreditName;
                        opt.text = creditType.CreditName;
                        obj.appendChild(opt);
                    });
                    
                    $("#cboSearchBy").trigger("change");

                    LoadFinancialPeriods();

                },
                error: function (xhr, status, error) {

                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });

            function GetMemberSalaryAccount() {
                IsValidMemberAccount = false;
                $("#tblMemAccDetails > tbody:last").children().remove();
                $("#txtFoundAccNo").val("");
                $("#txtFoundAccName").val("");
                if ($("#txtSearchValue").val().trim() == "") { return; }
                if ($("#txtSearchValue").val().trim() == AccountMask) { return; }

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetMemberSalaryAccount") %>",
                    data: JSON.stringify({ 'SearchBy': $("#cboSearchBy").val(), 'SearchValue': $("#txtSearchValue").val(), 'EmpCode': $("#cboSearchEmployer").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var MemAcc = response;
                        
                        var tbl_row = "<tr><td>Account Name</td><td>" + MemAcc.AccountName + "</td></tr>";
                        tbl_row += "<tr><td>Account No</td><td>" + MemAcc.AccountNo + "</td></tr>";
                        tbl_row += "<tr><td>Acc Type</td><td>" + MemAcc.AccountType + "</td></tr>";
                        tbl_row += "<tr><td>Type Name</td><td>" + MemAcc.AccountTypeName + "</td></tr>";
                        tbl_row += "<tr><td>Date Openned</td><td>" + MemAcc.OpenningDate + "</td></tr>";
                        tbl_row += "<tr><td>Branch</td><td>" + MemAcc.BranchName + "</td></tr>";
                        tbl_row += "<tr><td>Status</td><td>" + MemAcc.Status + "</td></tr>";
                        tbl_row += "<tr><td>Instructions</td><td>" + MemAcc.Instructions + "</td></tr>";
                        
                        $("#bdMemAccDetails").append(tbl_row);

                        $("#txtFoundAccNo").val(MemAcc.AccountNo);
                        $("#txtFoundAccName").val(MemAcc.AccountName);
                        IsValidMemberAccount = true;
                        
                        
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

            }

            function LoadFinancialPeriods() {
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }
                $("#cboStartMonth").empty();
                $("#cboEndMonth").empty();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var fmonths = response;
                        var objPeriod = document.getElementById("cboPeriod");


                        $("#cboPeriod").empty();
                        $.each(fmonths, function (index, fmonth) {
                            var optn = "<option value='" + fmonth.MonthID + "'>" + fmonth.MonthName + "</option>";
                            $("#cboPeriod").append(optn);

                            if (fmonth.Status == "OPENED") {
                                objPeriod.selectedIndex = index
                            }
                        });
                        DispBatchesSummary();
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

            }

            $("#btnAdd").on('click', function () {
                if ($("#txtFoundAccNo").val() == "") {
                    alert("Invalid Account No");
                    return;
                }
                if ($("#txtAmount").val().toString().indexOf("e") > 0) {
                    alert("Invalid Amount");
                    return;
                }
                if ($("#txtAmount").val().toString().indexOf("F") > 0) {
                    alert("Invalid Amount");
                    return;
                }
                if ($("#txtAmount").val().toString().indexOf("f") > 0) {
                    alert("Invalid Amount");
                    return;
                }
                if (!isNumber($("#txtAmount").val())) {
                    alert("Invalid Amount");
                    return;
                }
                var outData = {
                    'PeriodCode': $("#cboPeriod").val(),
                    'DBName': $("#cboYear").val(),
                    'Amount': $("#txtAmount").val(),
                    'CreditType': $("#cboPaymentType").val(),
                    'BatchNo': $("#txtBatchNo").val(),
                    'AccountNo': $("#txtFoundAccNo").val()
                };

                outData = JSON.stringify(outData);

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/SaveSalaryEntry") %>",
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {

                                

                                var tbl_row = "";
                               
                                tbl_row += "<tr>"
                                tbl_row += "<td>" + response.AccountNo + "</td>";
                                tbl_row += "<td>" + response.AccountName + "</td>";
                                tbl_row += "<td>" + response.EmployerCode + "</td>";
                                tbl_row += "<td>" + response.PayrollNo + "</td>";
                                tbl_row += "<td class='colamount'>" + parseFloat($("#txtAmount").val()).formatMoney() + "</td>";
                                tbl_row += "<td>N</td>";
                                tbl_row += "<td>" + "User" + "</td>";
                                tbl_row += "<td>" + "Date" + "</td>";
                                tbl_row += "<td></td>";
                                tbl_row += "<td></td>";
                                tbl_row += "<td><a href='#'>Remove<a/></td>";
                                tbl_row += "</tr>";
                                

                                $("#bdBatchContents").append(tbl_row);

                                $("#tblMemAccDetails > tbody:last").children().remove();
                                $("#txtSearchValue").val("");
                                $("#txtAmount").val("0.00");
                                $("#txtSearchValue").focus();



                            },
                            error: function (xhr, status, error) {

                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
            });

            function DisableDataEntry() {
                $("#txtAmount").prop('disabled', true);
                $("#txtSearchValue").prop('disabled', true);
                $("#btnAdd").prop('disabled', true);
                $("#btnUploadSalaryFile").prop('disabled', true);
                $("#btnCancelEditTransactions").prop('disabled', false);
            }
            function EnableDataEntry() {
                $("#txtAmount").prop('disabled', false);
                $("#txtSearchValue").prop('disabled', false);
                $("#cboSearchBy").prop('disabled', false);
                $("#btnAdd").prop('disabled', false);
                $("#btnUploadSalaryFile").prop('disabled', false);
                $("#btnCancelEditTransactions").prop('disabled', false);
            }
            function DisableBatchHeader() {
                $("#txtChequeNo").prop('disabled', true);
                $("#txtBatchDate").prop('disabled', true);
                $("#txtBatchNo").prop('disabled', true);
                $("#cboPaymentType").prop('disabled', true);
                $("#btnSaveNewBatch").prop('disabled', true);
                $("#cboYear").prop('disabled', true);
                $("#cboPeriod").prop('disabled', true);
            }
            function EnableBatchHeader() {
                $("#txtChequeNo").prop('disabled', false);
                $("#txtBatchDate").prop('disabled', false);
                $("#txtBatchNo").prop('disabled', false);
                $("#cboPaymentType").prop('disabled', false);
                $("#cboYear").prop('disabled', false);
                $("#cboPeriod").prop('disabled', false);
                $("#btnSaveNewBatch").prop('disabled', false);
            }


            $("#btnSaveNewBatch").on('click', function () {
                
                if (!IsValidDate($("#txtBatchDate").val())) {
                    alert("Invalid Date");
                    return;
                }

                if ($("#txtChequeNo").val().toString().trim() == "") {
                    alert("Enter Cheque No");
                    return;
                }
                if (document.getElementById("cboPaymentType").selectedIndex == 0) {
                    alert("Select Payment Type");
                    return;
                }
                
                var msg = "Payment Type: " + $("#cboPaymentType option:selected").text() + ", Period " + $("#cboPeriod option:selected").text() + ", Batch Date = " + $("#txtBatchDate").val() + " Cheque No.: = " + $("#txtChequeNo").val() + " ?";
                
                xDialogConfirm(msg, "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (credentials) {
                        var UserName = credentials.UserName;
                        var Password = credentials.UserPass;
                        var pwdslt = getRandomInt(1000, 30000);
                        pwdslt = pwdslt.toString();
                        var pwd = CryptoJS.MD5(Password).toString();
                        pwd = pwd + pwdslt;
                        var sltpwd = CryptoJS.MD5(pwd).toString();

                        var outData = {
                            'PeriodCode': $("#cboPeriod").val(),
                            'DBName': $("#cboYear").val(),
                            'UserName': UserName,
                            'Password': sltpwd,
                            'Salt': pwdslt,
                            'CreditType': $("#cboPaymentType").val(),
                            'BatchDate': $("#txtBatchDate").val(),
                            'ChequeNo': $("#txtChequeNo").val()
                        };
                        
                        outData = JSON.stringify(outData);

                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: "<%: Url.Content("~/api/BankSystemApi/CreateSalaryNewBatch") %>",
                            data: outData ,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) { //Boolean response
                                $("#txtBatchNo").val(response);
                                EnableDataEntry();
                                DisableBatchHeader();
                                $("#cboSearchBy").focus();
                                $("#btnUploadSalaryFile").prop('disabled', false); //only time when import button is activated or while creating new batch
                                
                            },
                            error: function (xhr, status, error) {

                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });


                    });
                });

                
            
			});


            $("#btnCancelEditTransactions").on('click', function () {
                DisableDataEntry();
                DisableBatchHeader(); //correct. require user to click new again or edit
                DispBatchTransactions();
            });
            
            $("#btnEditTransactions").on('click', function () {
                xDialogGetUserCredetials().then(function (credentials) {
                    var UserName = credentials.UserName;
                    var Password = credentials.UserPass;
                    var pwdslt = getRandomInt(1000, 30000);
                    pwdslt = pwdslt.toString();
                    var pwd = CryptoJS.MD5(Password).toString();
                    pwd = pwd + pwdslt;
                    var sltpwd = CryptoJS.MD5(pwd).toString();

                    //ensure batch exists
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/SalaryBatchNoExists") %>",
                        data: JSON.stringify({
                            'DBName': $("#cboYear").val(),
                            'PeriodCode': $("#cboPeriod").val(),
                            'CreditType': $("#cboPaymentType").val(),
                            'BatchNo': $("#txtBatchNo").val(),
                            'UserName': UserName,
                            'Password': sltpwd,
                            'Salt': pwdslt,
                        }),
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) { //Boolean response
                            if (response) {
                                EnableDataEntry();
                                DisableBatchHeader();
                                $("#cboSearchBy").focus();
                                $("#btnUploadSalaryFile").prop('disabled', false); //only time when import button is activated or while creating new batch
                            } else {
                                alert("Invalid Batch");
                            }

                        },
                        error: function (xhr, status, error) {

                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            });
            function DispBatchTransactions() {
                $("#tblBatchContents > tbody:last").children().remove();
                $("#btnEditTransactions").prop('disabled', false);
                

                if ($("#cboPeriod").val().trim() == "") { return; }
                if ($("#cboYear").val().trim() == "") { return; }
                if ($("#txtBatchNo").val().trim() == "") { return; }

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetSalaryBatchTransactions") %>",
                    data: JSON.stringify({
                        'DBName': $("#cboYear").val(), 'PeriodCode': $("#cboPeriod").val(), 'BatchNo': $("#txtBatchNo").val(), 'CreditType': $("#cboPaymentType").val(), 'PostedStatus': "", 'BranchCode': ""
                    }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var transactions = response.SalariesBatchTransactions;
                        var TransTotals = response.TransTotals;
                        var TransCount = response.TransCount
                        var tbl_row = "";
                        $.each(transactions, function (index, trans) {
                            tbl_row += "<tr>"
                            tbl_row += "<td>" + trans.AccountNo + "</td>";
                            tbl_row += "<td>" + trans.AccountName + "</td>";
                            tbl_row += "<td>" + trans.EmployerCode + "</td>";
                            tbl_row += "<td>" + trans.PayrollNo + "</td>";
                            tbl_row += "<td class='colamount'>" + trans.Amount.formatMoney() + "</td>";
                            tbl_row += "<td>" + trans.Posted + "</td>";
                            tbl_row += "<td>" + trans.CaptureUser + "</td>";
                            tbl_row += "<td>" + trans.CaptureDate + "</td>";
                            tbl_row += "<td>" + trans.PostUser + "</td>";
                            tbl_row += "<td>" + trans.PostDate + "</td>";
                            tbl_row += "<td><a href='#'>Remove<a/></td>";
                            tbl_row += "</tr>";
                        });

                        $("#bdBatchContents").append(tbl_row);
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
                
            }
            function DispBatchesSummary() {
                
                $("#tblBatchesSummary > tbody:last").children().remove();
                $("#tblMemAccDetails > tbody:last").children().remove();
                $("#tblBatchContents > tbody:last").children().remove();

                if ($("#cboPeriod").val().trim() == "") { return; }
                if ($("#cboYear").val().trim() == "") { return; }

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetSalaryBatchesSummary") %>",
                    data: JSON.stringify({
                        'DBName': $("#cboYear").val(),
                        'PeriodCode': $("#cboPeriod").val(),
                        'PostedStatus': $("#cboFilterPostedStatus").val(),
                        'BranchCode': "", 'CreditType': ""
                    }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var batches = response.SalariesBatchesSummary;
                        var batchNumbers = response.SalariesDistinctBatchNumbers;
                        var tbl_row = "";
                        $.each(batches, function (index, batch) {
                            tbl_row += "<tr>"
                            tbl_row += "<td><input type='checkbox' id='chkB" + index + "'/></td>";
                            tbl_row += "<td>" + batch.BatchNo + "</td>";
                            tbl_row += "<td>" + batch.BatchDate + "</td>";
                            tbl_row += "<td>" + batch.CreditType + "</td>";
                            tbl_row += "<td>" + batch.Posted + "</td>";
                            tbl_row += "<td class='colamount'>" + batch.TransCount + "</td>";
                            tbl_row += "<td class='colamount'>" + batch.Totals.formatMoney() + "</td>";
                            tbl_row += "<td>" + batch.ChequeNo + "</td>";
                            tbl_row += "<td>" + batch.EmpCode + "</td>";
                            tbl_row += "<td>" + batch.Category + "</td>";
                            tbl_row += "<td>" + batch.BranchCode + "</td>";
                            tbl_row += "<td>" + batch.BranchName + "</td>";
                            tbl_row += "<td><a href='#'>Details<a/></td>";
                            tbl_row += "</tr>";
                        });

                        $("#bdBatchesSummary").append(tbl_row);
                        IsValidMemberAccount = false;


                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }
            $('#bdBatchesSummary').on('click', 'a', function (event) {
                event.preventDefault();

                var sel_row = $(this).closest('tr');
                var batchNo = sel_row.find('td').eq(1).text();
                var batchDate = sel_row.find('td').eq(2).text();
                var payType = sel_row.find('td').eq(3).text();
                var chequeNo = sel_row.find('td').eq(7).text();

                //alert(batchNo + " Date: " + batchDate + " Type: " + payType + " ChqNo: " + chequeNo)
                $("#txtBatchNo").val(batchNo);
                $("#txtBatchDate").val(batchDate);
                $("#cboPaymentType").val(payType);
                $("#txtChequeNo").val(chequeNo);
                $("#tabs").tabs("option", "active", 0);
                DispBatchTransactions();
                
            });
            $('#btnBatchTransactionsReport').on('click', function (event) {
                event.preventDefault();
                
                if ($("#cboPeriod").val().trim() == "") { return; }
                if ($("#cboYear").val().trim() == "") { return; }
                if ($("#txtBatchNo").val().trim() == "") { return; }

                //alert(batchNo + " Date: " + batchDate + " Type: " + payType + " ChqNo: " + chequeNo)
                var batchNo = $("#txtBatchNo").val();
                if (batchNo.toString().trim() == "") { return; }
                var payType = $("#cboPaymentType").val();
                if (payType.toString().trim() == "") { return; }

                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var report_url = global_site_root + "/Bank/BankSystem/GetSalaryBatchTransactionsReport?DBName=" + $("#cboYear").val() + "&PeriodCode=" + $("#cboPeriod").val() + "&BatchNo=" + $("#txtBatchNo").val() + "&CreditType=" + $("#cboPaymentType").val();
                $("#ifrReport").attr("src", report_url);


            });
            $('#bdBatchContents').on('click', 'a', function (event) {
                event.preventDefault();

                var sel_row = $(this).closest('tr');
                var accNo = sel_row.find('td').eq(0).text();
                var empCode = sel_row.find('td').eq(2).text();
                var payrollNo = sel_row.find('td').eq(3).text();
                var amount = sel_row.find('td').eq(4).text();
                var posted = sel_row.find('td').eq(5).text();

                //alert(accNo + " Date: " + empCode + " Type: " + payrollNo + " ChqNo: " + amount + " " + posted);
                var msg = "Please confirm deleting AccNo" + accNo + " Amount " + amount + " from Batch " + $("#txtBatchNo").val() + " , Payment type is " + $("#cboPaymentType").val();
                xDialogConfirm(msg, "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (credentials) {
                        var UserName = credentials.UserName;
                        var Password = credentials.UserPass;
                        var pwdslt = getRandomInt(1000, 30000);
                        pwdslt = pwdslt.toString();
                        var pwd = CryptoJS.MD5(Password).toString();
                        pwd = pwd + pwdslt;
                        var sltpwd = CryptoJS.MD5(pwd).toString();

                        var outData = {
                            'PeriodCode': $("#cboPeriod").val(),
                            'DBName': $("#cboYear").val(),
                            'UserName': UserName,
                            'Password': sltpwd,
                            'Salt': pwdslt,
                            'CreditType': $("#cboPaymentType").val(),
                            'BatchNo': $("#txtBatchNo").val(),
                            'AccountNo': accNo
                        };

                        outData = JSON.stringify(outData);

                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: "<%: Url.Content("~/api/BankSystemApi/DeleteSalaryEntry") %>",
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) { //Boolean response
                                sel_row.remove();
                            },
                            error: function (xhr, status, error) {

                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });


                    });
                });
                

            });
            
            $("#btnPost").on('click', function () {
                $.connection.hub.start().done(function () {
                    var connectionId = $.connection.hub.id;
                    $("#divUploadNotes").append('SignalR Info: Connected On Post Request. id is ' + connectionId + ' <br\>');
                    xDialogConfirm("Post Selectd Batches?", "Confirm").then(function () {
                        xDialogGetUserCredetials().then(function (data) {
                        var UserName = data.UserName;
                        var Password = data.UserPass;
                        var csrfToken = $("input[name='__RequestVerificationToken']").val();

                        var pwdslt = getRandomInt(1000, 30000);
                        pwdslt = pwdslt.toString();
                        var pwd = CryptoJS.MD5(Password).toString();
                        pwd = pwd + pwdslt;
                        var sltpwd = CryptoJS.MD5(pwd).toString();

                        var table = document.getElementById('tblBatchesSummary');
                        var rowCount = table.rows.length;
                        if (rowCount == 0) { alert("Nothing to post"); return; }

                        var BatchesCount = 0;
                        var BatchesList = new Array();
                
                
                
                        for (var i = 0; i < rowCount; i++) {
                            var row = table.rows[i];
                            var chkbox = row.cells[0].childNodes[0];
                            if (null != chkbox && true == chkbox.checked) {
                                var BatchEntry = {};
                                //var DocNo = row.cells[0].textContent;
                                BatchEntry.BatchNo = row.cells[1].textContent;
                                BatchEntry.Period = $("#cboPeriod").val();
                                BatchEntry.EmployerCode = row.cells[8].textContent;
                                BatchEntry.CategoryCode = row.cells[9].textContent;
                                BatchEntry.PaymentType = row.cells[3].textContent;
                        
                                BatchesList[BatchesCount] = BatchEntry;
                                BatchesCount++;
                            }
                        }
                

                        if (BatchesCount == 0) {
                            alert("Select Batches to post");
                            return;
                        }
                        var outData = {
                            'PeriodCode': $("#cboPeriod").val(),
                            'DBName': $("#cboYear").val(),
                            'UserName': UserName,
                            'Password': sltpwd,
                            'Salt': pwdslt,
                            'BatchesList': BatchesList,
                            'SignalR_ID': connectionId,
                            };
                        outData = JSON.stringify(outData);
                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: "<%: Url.Content("~/api/BankSystemApi/PostSalaryBatches") %>",
                                    data: outData,
                                    contentType: "application/json; charset=utf-8",
                                    dataType: "json",
                                    success: function (response) { 

                                        //alert(response);
                                        //console.log("posting Batches");

                                    },
                                    error: function (xhr, status, error) {

                                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                                        alert('Error - ' + errorMessage);
                                    }
                                });
                
                        });
                    });
                });
            });

            $('#btnDeleteBatch').on('click', function (event) {
                event.preventDefault();

                var msg = "Please confirm deleting Batch " + $("#txtBatchNo").val() + " Payment type is " + $("#cboPaymentType").val();
                xDialogConfirm(msg, "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (credentials) {
                        var UserName = credentials.UserName;
                        var Password = credentials.UserPass;
                        var pwdslt = getRandomInt(1000, 30000);
                        pwdslt = pwdslt.toString();
                        var pwd = CryptoJS.MD5(Password).toString();
                        pwd = pwd + pwdslt;
                        var sltpwd = CryptoJS.MD5(pwd).toString();

                        var outData = {
                            'PeriodCode': $("#cboPeriod").val(),
                            'DBName': $("#cboYear").val(),
                            'UserName': UserName,
                            'Password': sltpwd,
                            'Salt': pwdslt,
                            'CreditType': $("#cboPaymentType").val(),
                            'BatchNo': $("#txtBatchNo").val()
                        };

                        outData = JSON.stringify(outData);

                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: "<%: Url.Content("~/api/BankSystemApi/DeleteSalaryBatch") %>",
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) { //Boolean response
                                
                                $("#tblMemAccDetails > tbody:last").children().remove();
                                $("#tblBatchContents > tbody:last").children().remove();
                                $("#txtBatchNo").val("");
                                $("#txtChequeNo").val("");
                                $("#txtBatchDate").val("");
                                $("#cboPaymentType").get(0).selectedIndex = 0;
                                $("#btnEditTransactions").prop('disabled', false);
                                EnableBatchHeader();
                                DisableDataEntry();
                                
                                DispBatchesSummary()
                                
                            },
                            error: function (xhr, status, error) {

                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });


                    });
                });


            });

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                    ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
        });
    </script>


</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
    <h3>Salaries And Other Credits</h3>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="container-fluid">

        <div class="row">
            <div class="col-md-4">
                <label id="lblYear" for="cboYear">Year:</label>
                <select id="cboYear">
                    <option value="">SELECT YEAR</option>
                </select>
            </div>
            <div class="col-md-4">
                <label id="lblPeriod" for="cboPeriod">Period:</label>
                <select id="cboPeriod">
                    <option value="" selected>(SELECT PERIOD)</option>
                </select>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div id="tabs">
                    <ul>
                        <li><a href="#tabs-1">Batch Management</a></li>
                        <li><a href="#tabs-2">View Batches</a></li>
                        <li><a href="#tabs-3">Import File</a></li>
                    </ul>



                    <form name="frmMain" id="frmMain">
                    <%= Html.AntiForgeryToken() %>
                    <div id="tabs-1" >
                        <div class="panel-group">
                            <div id="panelBatchDetails" class="panel panel-default">
                                <div class="panel-heading">Batch Details</div>
                                <div class="panel-body">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <table class="table table-responsive">
                                                    <tr>
                                                        <td>Batch No</td>
                                                        <td>
                                                            <input type="text" id="txtBatchNo" value="" readonly />
                                                        </td>
                                                     </tr>
                                                     <tr>
                                                         <td>Batch Date:</td>
                                                         <td><input type="text" id="txtBatchDate" /></td>
                                                     </tr>
                                                </table>

                                                <br />

                                                <input type="button" id="btnNewBatch" value="New Batch" style="margin:4px" />
                                                <input type="button" id="btnSaveNewBatch" value="Save New Batch"  style="margin:4px"  />
                                                <input type="button" id="btnEditTransactions" value="Edit Entries"  style="margin:4px"  />
                                                <input type="button" id="btnBatchTransactionsReport" value="Report"  style="margin:4px"  />
                                                <input type="button" id="btnCancelEditTransactions" value="Cancel Edit Entries"  style="margin:4px"  />
                                                <input type="button" id="btnDeleteBatch" value="Delete Batch"  style="margin:4px"  />
                                                
                        
                                            </div>
                                            <div class="col-md-6">
                                                <table class="table table-responsive">
                                                    <tr><td>Payment Type:</td><td><select id="cboPaymentType">
                                                    <option value="">(SELECT PAYMENT TYPE)</option>
                                                </select></td></tr>
                                                    <tr><td>Cheque No</td><td><input type="text" id="txtChequeNo" /></td></tr>

                                                </table>

                                            </div>

                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                            <div id="panelBatchTransactions" class="panel panel-default">
                                <div class="panel-heading">Batch Transactions</div>
                                <div class="panel-body">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <table class="table table-responsive">
                                                    <caption>Search Account</caption>
                                                    <tr><td>Search By:</td><td>
                                                        <select id="cboSearchBy">
                                                        <option value="accountno" selected>AccountNo</option>
                                                        <option value="payrollno">PayrollNo</option>
                                                        <option value="idnumber">IDNumber</option>
                                                        <option value="memberno">MemberNo</option>
                                                        </select></td></tr>
                                                    <tr><td>Employer</td><td>
                                                        <select id="cboSearchEmployer">
                                                        <option value="">(SELECT)</option>
                                                        </select></td></tr>
                                                    <tr><td><div id="divSearchByValue"> SearchByValue</div></td><td><input type="text" id="txtSearchValue"/></td></tr>
                                                    <tr><td><input type="text" id="txtFoundAccNo" value="" readonly disabled></td><td><input type="text" id="txtFoundAccName" value="" readonly disabled></td></tr>
                                                    <tr><td><div id="lblAmount"> Amount:</div></td><td><input type="number" id="txtAmount"/></td></tr>
                                                    <tr><td></td><td><input type="button" id="btnAdd" value="Add"  style="margin:4px"/></td></tr>
                                                </table>
                                            </div>
                                            <div class="col-md-6">
                                                <table id='tblMemAccDetails' class="table table-responsive">
                                                    <caption>Account Details</caption>
                                                    <thead>
                                                        <tr>
                                                        <th>Property</th>
                                                        <th>Value</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id='bdMemAccDetails'>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="container-fluid">
                        <div class="row">
                                <div class="col=md-12 table table-responsive" style="width:auto;font:12px">
                                    <table  class="table table-responsive" id="tblBatchContents">
                                        <caption>Transaction Listing</caption>
                                        <thead>
                                            <tr>
                                                <th>AccNo</th>
                                                <th>AccName</th>
                                                <th>EmpCode</th>
                                                <th>PayrollNo</th>
                                                <th class="colamount">Amount</th>
                                                <th>Posted</th>
                                                <th>CaptureUser</th>
                                                <th>CaptureDate</th>
                                                <th>PostUser</th>
                                                <th>PostDate</th>
                                                <th>Remove</th>
                                            </tr>
                                        </thead>
                                        <tbody id='bdBatchContents'>

                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                        </tfoot>
                                    </table>

                                </div>
                            </div>
                        </div>

                    </div>
                    
                    <div id="tabs-2">
                        <table id="tblListing" border="1" class="table table-responsive">
                            <tr>
                                <td>Posted</td>
                                <td>
                                    <select id="cboFilterPostedStatus">
                                        <option value="N" selected>UNPOSTED</option>
                                        <option value="Y">POSTED</option>
                                        <option value="">ALL</option>
                                    </select>
                                </td>
                                <td>Branch</td>
                                <td>
                                    <select id="cboFilterBranches">
                                        <option value="" selected>(ALL)</option>
                                    </select>
                                </td>
                            </tr>

                        </table>
                        <div id="divBatchesSummary" style="height: 200px; overflow: auto; width: auto;">
                            <table id='tblBatchesSummary' class="table table-responsive table-striped">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>BatchNo</th>
                                        <th>BatchDate</th>
                                        <th>Type</th>
                                        <th>Posted</th>
                                        <th class="colamount">TransCount</th>
                                        <th class="colamount">Totals</th>
                                        <th>ChequeNo</th>
                                        <th>EmpCode</th>
                                        <th>Category</th>
                                        <th>Branch</th>
                                        <th>BranchName</th>
                                        <th>Details</th>
                                    </tr>
                                </thead>
                                <tbody id='bdBatchesSummary'>
                                </tbody>
                                
                            </table>
                        </div>
                        <br />

                        <input type="button" id="btnRefresh" value="Refresh List" style="margin:4px" />
                        <input type="button" id="btnPost" value="Post Selected Batches"  style="margin:4px"  />
                        <input type="button" id="btnDeleteDoc" value="Delete Selected Batch"  style="margin:4px"  />

                        
                    </div>

                        <div id="tabs-3">
                            Employer : <select id="cboEmployer">
                                        <option value="" selected>(SELECT)</option>
                                    </select>
                            <br />
                            <br />
                            <label>Select File</label><input id="flSalary" type="file" name="flSalary" accept=".xlsx,.txt" /> <!--No Support for xls coz of ClosedXML library-->
                            <br />
                            <br />
                            <label>File Type:</label>
                            <select id="cboSalaryFileType">
                                <option value="" selected>(SELECT)</option>
                                <option value="ExcelFile_UsingAccountNumbers" >EXCEL FILE USING ACCOUNT NUMBERS</option>
                                <option value="ExcelFile_UsingIDNumbers" >EXCEL FILE USING ID NUMBERS</option>
                                <option value="ExcelFile_UsingPayrollNoAndEmployerCode" >EXCEL FILE USING PAYROLL NUMBERS AND EMPCODE</option>
                                <option value="ExcelFile_UsingPayrollNoWithoutEmployerCode" >EXCEL FILE USING PAYROLL NUMBERS</option>
                            </select>
                            <br />
                            <br />
                            <input type="button" id="btnUploadSalaryFile" value="Upload File"  style="margin:4px"  />
                             <br />
                            <br />
                            <div><input type="button" id="btnSaveFileImport" value="Save Batch" disabled /><div id="divProcessingResult"></div></div>
                            <div id="divUploadNotes"></div>
                        </div>

                    </form>
                    <div class="container">
                        <br />
                        <br />
                        
                        <input type="text" id="txtProgress" readonly style="width:100%"/>
                        <br />
                        <br />
                        <div class="progress">
                            <div id="prgProgress" class="progress-bar  progress-bar-striped" role="progressbar" aria-valuenow="0"
                                aria-valuemin="0" aria-valuemax="100" style="min-width: 1px">
                            </div>
                        </div>
                        <br />
                        <br />
                    </div>
                </div>
            </div>
        </div>
    </div>
    <hr />

    <iframe id="ifrReport" name="ifrReport"  width="300" height="400" style="visibility:hidden">
                        
    </iframe>
   
</asp:Content>


