﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Receipts And Payments
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
     <style type="text/css">
         .tblDRCRDetails {
             margin: 1px;
             border: 1em;
             padding-left:1em;
             padding-top:1em;
             border-collapse:separate;
         }
         
         /*use this for to calculate totals*/  
         .colamount {
            text-align:right;
         }
         tr.row_selected td{background-color:lawngreen;}
         td, th {
          border: 2px solid #999;
          padding: 0.5rem;
        }
        
    </style>

    
    <script type="text/javascript"  >

        

        $(document).ready(function () {

            var cashaccounts = null;
            var bankaccounts = null;

            ClearAll();
            DisableDataEntry();

            $("#txtDate").datepicker({ dateFormat: 'dd/mm/yy' });

            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });


           

            $('#tabs').on('tabsactivate', function (event, ui) {
                var newIndex = ui.newTab.index();
                if (newIndex == 1) {
                    DispTransactionsListSummary();
                }
            });

            $('#tblTransactionDetails').on('input', '[type=text]', function () { //calc totals
                CalcTotals();
            });

            $("#btnRefresh").on('click', function () {
                DispTransactionsListSummary();
            });
            $("#cboTransType").on('change', function () {
                DispTransactionsListSummary();
            });

            $("#cboYear").on('change', function () {
                LoadFinancialPeriods();
            });
            $("#cboPeriod").on('change', function () {
                DispTransactionsListSummary();
            });
            $("#cboFilterPostedStatus").on('change', function () {
                DispTransactionsListSummary();
            });
            $("#cboFilterBranches").on('change', function () {
                DispTransactionsListSummary();
            });


            $('#tblTransListSummary tbody').on('click', 'tr', function () {
                $('#tblTransListSummary tbody tr').removeClass('row_selected');
                $(this).addClass('row_selected');
                var DocNo = $(this).find('td').eq(0).text();
                DispTransactionsListDetails(DocNo);
            });

            $("#tblTransListSummary").keydown(function (evt) {
                if (evt.keyCode == 38) { // up
                    $('tbody tr:not(:first).selected').removeClass('row_selected').prev().addClass('row_selected');
                }
                if (evt.keyCode == 40) { // down
                    $('tbody tr:not(:last).selected').removeClass('row_selected').next().addClass('row_selected');
                }
            });


            $("#btnPost").on('click', function () {
                xDialogConfirm("Post Document?", "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        PostTransactions(data);
                    });
                });
            });

            //end important



            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetAccountsModulesConfig") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response.Years;
                    var employers = response.Employers;
                    cashaccounts = response.CashAccounts;
                    bankaccounts = response.BankAccounts;
                    SaccoSettings = response.SaccoSettings;

                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });

                    $("#cboYear").get(0).selectedIndex = 0;
                    LoadFinancialPeriods();
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });

            $("#btnNew").on('click', function () {
                $("#txtContraAccNo").mask(AccountMask);
                var selectedtransindex = document.getElementById("cboTransType").selectedIndex;
                var Priv = "";
                if (selectedtransindex == 0) {
                    alert("Select Transaction Type");
                    return;
                } else if (selectedtransindex == 1) {
                    Priv = "CreatePayments";
                } else if (selectedtransindex == 2) {
                    Priv = "CreateReceipts";
                }
                xDialogConfirm("Start a new " + $("#cboTransType option:selected").text() + " batch?").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        var UserName = data.UserName;
                        var Password = data.UserPass;
                        var pwdslt = getRandomInt(1000, 30000);
                        pwdslt = pwdslt.toString();
                        var pwd = CryptoJS.MD5(Password).toString();
                        pwd = pwd + pwdslt;
                        var sltpwd = CryptoJS.MD5(pwd).toString();



                        var outData = {
                            'UserID': UserName,
                            'Password': sltpwd,
                            'Salt': pwdslt,
                            'Privilege': Priv
                        }
                        outData = JSON.stringify(outData);
                        var url = "<%: Url.Content("~/api/BankSystemApi/ValidateWebUserPrivilege") %>";
                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: url,
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                ClearAll();
                                EnableDataEntry();
                                LoadAccounts();
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
                    })
                });
            });

            $("#btnSave").on('click', function () {
                SaveTransactions();
            });
            $("#btnContraAccNo").on('click', function (e) {
                e.preventDefault();
                xDialogSelectGLAccount("ALL").then(function (data) {
                    var acccode = data;
                    $("#txtContraAccNo").val(acccode);
                    GetAccountName(acccode).then(function (accname) {
                        $("#divContraAccName").html(accname);
                    });
                });
            });
            $("#txtContraAccNo").on('focusout', function () {
                GetAccountName($("#txtContraAccNo").val()).then(function (accname) {
                    $("#divContraAccName").html(accname);
                });
            });

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion();
            });

            $("#btnCancel").on('click', function () {
                xDialogConfirm("Cancel current batch?", "Confirm").then(function () {
                    ClearAll();
                    DisableDataEntry();
                });
            });

            $("#cboTransMode").on('change', function () {
                LoadAccounts();
            });



            $("#txtAmount").on('change keyup paste mouseup', function () {
                $("#divAmountInWords").html("");
                try {
                    $("#divAmountInWords").html(toWords($("#txtAmount").val()));
                } catch (err) {

                }
            });
            $("#btnRemoveLineItem").click(function () {

                xDialogConfirm("Delete selected rows?", "Confirm Delete").then(function () {
                    try {
                        var table = document.getElementById('tblTransactionDetails');
                        var rowCount = table.rows.length;

                        for (var i = 0; i < rowCount; i++) {
                            var row = table.rows[i];
                            var chkbox = row.cells[0].childNodes[0];
                            if (null != chkbox && true == chkbox.checked) {
                                table.deleteRow(i);
                                rowCount--;
                                i--;
                            }
                            //calcrownumbers();
                            CalcTotals();
                        }
                    } catch (err) {
                        alert(err);
                    }
                });
            });
            $("#btnAddToList").on('click', function () {

                if ($("#cboTransType option:selected").index() == 0) {
                    alert("Select Transaction Type");
                    return;
                }
                if (!isNumber($("#txtAmount").val())) {
                    alert("Invalid Amount");
                    return;
                }
                if (!IsValidDate($("#txtDate").val())) {
                    alert("Invalid Date");
                    return;
                }
                if ($("#cboAccount option:selected").index() == 0) {
                    alert("Select Account");
                    return;
                }
                if ($("#divContraAccName").html() == "") {
                    alert("Invalid Contra Account");
                    return;
                }
                if ($("#txtDescription").val() == "") {
                    alert("Enter Description");
                    return;
                }
                if (parseFloat($("#txtAmount").val()) <= 0) {
                    alert("Invalid Amount");
                    return;
                }
                var tmp = "(" + $("#cboAccount").val() + ")";
                var tbl_row = "<tr>";
                tbl_row += "<td><input type='checkbox' id='chk[]'/></td>";
                tbl_row += "<td>" + $("#cboAccount").val() + "</td>";
                tbl_row += "<td>" + $("#cboAccount option:selected").text().replace(tmp, "") + "</td>";
                tbl_row += "<td>" + $("#txtContraAccNo").val() + "</td>";
                tbl_row += "<td>" + $("#divContraAccName").html() + "</td>";
                tbl_row += "<td class='colamount'>" + parseFloat($("#txtAmount").val()).toFixed(2) + "</td>";
                tbl_row += "<td class='td_amount_col'>" + $("#txtDate").val() + "</td>";
                tbl_row += "<td class='td_amount_col'>" + $("#txtDocNo").val() + "</td>";
                tbl_row += "<td class='td_amount_col'>" + $("#txtChequeNo").val() + "</td>";
                tbl_row += "<td>" + $("#txtDescription").val() + "</td>";
                tbl_row += "</tr>";



                $("#txtContraAccNo").val("");
                $("#divContraAccName").html("");
                $("#txtAmount").val("0.00");
                $("#divAmountInWords").html("");

                $("#bdTransactionItems").append(tbl_row);


                CalcTotals();
                $("#txtChequeNo").focus();

            });



            function LoadAccounts() {
                $("#cboAccount").empty();
                $("#cboAccount").append("<option selected value='selectaccount' >(SELECT ACCOUNT)</option'>");
                var TransMode = $("#cboTransMode").val().toString().toLowerCase();
                if (TransMode == "CASH".toLowerCase()) {
                    $.each(cashaccounts, function (index, cashaccount) {
                        $("#cboAccount").append("<option value='" + cashaccount.UserCode + "'>" + cashaccount.AccountName + "(" + cashaccount.UserCode + ")" + "</option'>");
                    });
                }
                else {
                    $.each(bankaccounts, function (index, bankaccount) {
                        $("#cboAccount").append("<option value='" + bankaccount.UserCode + "'>" + bankaccount.AccountName + "(" + bankaccount.UserCode + ")" + "</option'>");
                    });
                }
            }



            function ClearAll() {

                $("#txtChequeNo").val("");
                $("#txtTotals").val("0.00");
                $("#cboAccount").empty();
                $("#cboAccount").append("<option value='selectaccount' selected>(SELECT ACCOUNT)</option>");
                $("#txtDate").val("");
                $("#txtContraAccNo").val("");
                $("#txtDocNo").val("");
                $("#txtAmount").val("0.00");
                $("#divAmountInWords").html("");
                $("#txtDescription").val("");

                ClearTransTableRows();

            }
            function EnableDataEntry() {
                $("#cboTransType").prop('disabled', true);
                $("#cboYear").prop('disabled', true);
                $("#cboPeriod").prop('disabled', true);
                $("#btnSave").prop('disabled', false);
                $("#btnContraAccNo").prop('disabled', false);
                $("#btnCancel").prop('disabled', false);
                $("#btnNew").prop('disabled', true);
                $("#btnAddToList").prop('disabled', false);
                $("#btnRemoveLineItem").prop('disabled', false);

                $("#txtDate").prop('disabled', false);
                $("#cboTransMode").prop('disabled', false);
                $("#txtChequeNo").prop('disabled', false);
                $("#cboAccount").prop('disabled', false);
                $("#txtContraAccNo").prop('disabled', false);
                $("#txtDocNo").prop('disabled', false);
                $("#txtAmount").prop('disabled', false);
                $("#txtDescription").prop('disabled', false);

                ClearTransTableRows();

                $("#cboTransMode").focus();
            }
            function DisableDataEntry() {
                document.getElementById("cboTransType").selectedIndex = 0;

                $("#cboTransType").prop('disabled', false);
                $("#cboYear").prop('disabled', false);
                $("#cboPeriod").prop('disabled', false);
                $("#btnSave").prop('disabled', true);
                $("#btnContraAccNo").prop('disabled', true);
                $("#btnCancel").prop('disabled', true);
                $("#btnNew").prop('disabled', false);
                $("#btnAddToList").prop('disabled', true);
                $("#btnRemoveLineItem").prop('disabled', true);

                $("#txtDate").prop('disabled', true);
                $("#cboTransMode").prop('disabled', true);
                $("#txtChequeNo").prop('disabled', true);
                $("#cboAccount").prop('disabled', true);
                $("#txtContraAccNo").prop('disabled', true);
                $("#txtDocNo").prop('disabled', true);
                $("#txtAmount").prop('disabled', true);
                $("#txtDescription").prop('disabled', true);

                ClearTransTableRows();

            }
            function ClearTransTableRows() {
                $("#tblTransactionDetails > tbody:last").children().remove();
            }
            function CalcTotals() {
                var totals = 0;
                $("#bdTransactionItems").find(".colamount").each(function () {
                    if (isNumber($(this).text())) { //use .text coz td doesnt have .val
                        totals += parseFloat($(this).text());
                    }
                });
                $("#txtTotals").val(totals.toFixed(2));
            }
            function LoadFinancialPeriods() {
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }
                $("#cboStartMonth").empty();
                $("#cboEndMonth").empty();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var fmonths = response;
                        var objPeriod = document.getElementById("cboPeriod");
                        $("#cboPeriod").empty();
                        $.each(fmonths, function (index, fmonth) {
                            var optn = "<option value='" + fmonth.MonthID + "'>" + fmonth.MonthName + "</option>";
                            $("#cboPeriod").append(optn);

                            if (fmonth.Status.toLowerCase() == "OPENED".toLowerCase()) {
                                objPeriod.selectedIndex = index
                            }
                        });
                        DispTransactionsListSummary();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

            }
            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }



            function SaveTransactions() {

                CalcTotals();
                var totals = $("#txtTotals").val();

                if (!isNumber(totals)) {
                    alert("Invalid Totals");
                    return;
                }

                if (+totals <= 0) {
                    alert("Invalid totals");
                    return;
                }




                var PostEntries = new Array();
                var tbody = document.getElementById('bdTransactionItems');
                var tableRows = tbody.getElementsByTagName('tr');
                var rowCount = tableRows.length;
                var Entries = 0;
                var TotalAmount = 0;
                var UserName = "";
                var Password = "";
                var RowsWithMoreThanZero = 0;
                var UserName = getCookie("StaffLoginName");
                var url = "<%: Url.Content("~/api/BankSystemApi/SaveReceiptsAndPayments") %>";



                for (var x = 0; x < rowCount; x++) {
                    var PostEntry = {};
                    var lineamount = 0;
                    var myrow = tbody.getElementsByTagName("tr")[x];
                    //var mycel = myrow.getElementsByTagName("td")[5];
                    //lineamount = mycel.childNodes.item(0).value;
                    lineamount = myrow.getElementsByTagName("td")[5].innerHTML;

                    if (!isNumber(lineamount)) {
                        alert("Invalid Line Amount " + lineamount + " at row " + x);
                        return;
                    }
                    lineamount = +lineamount;
                    if (lineamount < 0) {
                        alert(" Amount " + lineamount + " should be more than or equal to Zero. At row " + x);
                        return;
                    }

                    PostEntry.RefID = x;
                    PostEntry.BranchCode = getCookie("BranchCode");
                    PostEntry.ClassCode = "BOSA";
                    PostEntry.PeriodCode = $("#cboPeriod").val();
                    PostEntry.DateIn = "";
                    PostEntry.Amount = lineamount;
                    PostEntry.DocumentType = $("#cboTransType option:selected").text();
                    PostEntry.DocumentNo = "";
                    PostEntry.DrTransType = "O";
                    PostEntry.CrTransType = "O";

                    PostEntry.DrSchemeCode = "";
                    PostEntry.CrSchemeCode = "";
                    PostEntry.DrLoanTypeCode = "";
                    PostEntry.CrLoanTypeCode = "";
                    PostEntry.DrLoanSerialNumber = "";
                    PostEntry.CrLoanSerialNumber = "";
                    PostEntry.DrEmpCode = "";
                    PostEntry.DrPayrollNo = "";
                    PostEntry.CrEmpCode = "";
                    PostEntry.CrPayrollNo = "";
                    PostEntry.AppraisalUser = UserName;
                    PostEntry.ApprovalUser = UserName;
                    PostEntry.PostUser = "";
                    PostEntry.AppraisalDate = "";
                    PostEntry.ApprovalDate = "";
                    PostEntry.PostDate = "";
                    PostEntry.Status = "Approved";
                    PostEntry.Posted = "N";
                    PostEntry.DocumentDate = myrow.getElementsByTagName("td")[6].innerHTML;
                    PostEntry.Description = myrow.getElementsByTagName("td")[9].innerHTML;
                    PostEntry.ChequeNo = myrow.getElementsByTagName("td")[8].innerHTML;
                    PostEntry.UserDocNo = myrow.getElementsByTagName("td")[7].innerHTML;

                    if (document.getElementById("cboTransType").selectedIndex == 1) {  //PAYMENTS
                        PostEntry.DrAccount = myrow.getElementsByTagName("td")[3].innerHTML;
                        PostEntry.CrAccount = myrow.getElementsByTagName("td")[1].innerHTML;
                    } else if (document.getElementById("cboTransType").selectedIndex == 2) { //RECEIPTS
                        PostEntry.DrAccount = myrow.getElementsByTagName("td")[1].innerHTML;
                        PostEntry.CrAccount = myrow.getElementsByTagName("td")[3].innerHTML;
                    } else {
                        alert("Invalid Trans type");
                        return;
                    }

                    if (lineamount > 0) {
                        TotalAmount = TotalAmount + +PostEntry.Amount;
                        PostEntries[Entries] = PostEntry;
                        Entries++;
                    }

                }
                if (Entries == 0) {
                    alert("Nothing to save");
                    return;
                }
                var outData = {
                    'DBName': $("#cboYear").val(),
                    'PeriodCode': $("#cboPeriod").val(),
                    'PostEntries': PostEntries
                }

                outData = JSON.stringify(outData);
                xDialogConfirm("Transactions Type: " + $("#cboTransType option:selected").text() + ", Total Amount = " + $("#txtTotals").val() + "?", "Confirm").then(function () {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: url,
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            ClearAll();
                            xDialogMessage("Document Saved successfully", "Document Saved").then(function () {
                                $("#cboTransType").focus();
                            });
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            }

            function DispTransactionsListSummary() {
                $("#tblTransListSummary > tbody:last").children().remove();
                $("#tblTransListDetails > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetGeneralTransactionsSummary") %>",
                    data: "{'DBName' : '" + $("#cboYear").val() + "','PeriodCode' : '" + $("#cboPeriod").val() + "','DocumentType' : '" + $("#cboTransType").val() + "','PostedStatus' : '" + $("#cboFilterPostedStatus").val() + "','BranchCode' : '" + $("#cboFilterBranches").val() + "'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var row_datas = response;

                        $.each(row_datas, function (index, row_data) {
                            var tbl_row = "<tr>";
                            tbl_row += "<td id='tdDocno[]'><input type='checkbox' id=chk1[]/>" + row_data.DocumentNo + "</td>";
                            tbl_row += "<td>" + row_data.TransCount + "</td>";
                            tbl_row += "<td>" + row_data.DateIn + "</td>";
                            tbl_row += "<td>" + row_data.AppraisalUser + "</td>";
                            tbl_row += "<td>" + row_data.Amount + "</td>";
                            tbl_row += "<td>" + row_data.Status + "</td>";
                            tbl_row += "<td>" + row_data.BranchCode + "</td>";
                            tbl_row += "<td>" + row_data.BranchName + "</td>";
                            tbl_row += "<td>" + row_data.PostUser + "</td>";
                            tbl_row += "<td>" + row_data.PostDate + "</td>";
                            tbl_row += "</tr>";
                            $("#tblTransListSummary").append(tbl_row);
                        });
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });


            }

            function DispTransactionsListDetails(DocNo) {
                $("#tblTransListDetails > tbody:last").children().remove();
                $("#pDocDetails").html("Document No : " + DocNo + " Details");
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetGeneralTransactionsDetails") %>",
                    data: "{'DBName' : '" + $("#cboYear").val() + "','PeriodCode' : '" + $("#cboPeriod").val() + "','DocumentType' : '" + $("#cboTransType").val() + "','DocumentNo' : '" + DocNo + "'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var row_datas = response;

                        $.each(row_datas, function (index, row_data) {
                            var tbl_row = "<tr>";
                            tbl_row += "<td><input type='checkbox' id=chkDetails[]/>" + row_data.RefID + "</td>";
                            tbl_row += "<td>" + row_data.DrTransType + "</td>";
                            tbl_row += "<td>" + row_data.DrAccount + "</td>";
                            tbl_row += "<td>" + row_data.DrAccName + "</td>";
                            tbl_row += "<td>" + row_data.DrMemberNo + "</td>";
                            tbl_row += "<td>" + row_data.DrMemberNames + "</td>";

                            tbl_row += "<td>" + row_data.CrTransType + "</td>";
                            tbl_row += "<td>" + row_data.CrAccount + "</td>";
                            tbl_row += "<td>" + row_data.CrAccName + "</td>";
                            tbl_row += "<td>" + row_data.CrMemberNo + "</td>";
                            tbl_row += "<td>" + row_data.CrMemberNames + "</td>";

                            tbl_row += "<td>" + row_data.Description + "</td>";
                            tbl_row += "<td>" + row_data.DocumentDate + "</td>";
                            tbl_row += "<td>" + row_data.Amount + "</td>";
                            tbl_row += "</tr>";
                            $("#tblTransListDetails").append(tbl_row);
                        });
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            }

            function PostTransactions(data) {
                var UserName = data.UserName;
                var Password = data.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var table = document.getElementById('tblTransListSummary');
                var rowCount = table.rows.length;
                if (rowCount == 0) { alert("Nothing to post"); return; }

                for (var i = 0; i < rowCount; i++) {
                    var row = table.rows[i];
                    var chkbox = row.cells[0].childNodes[0];
                    if (null != chkbox && true == chkbox.checked) {
                        var DocNo = row.cells[0].textContent;
                        var outData = {
                            'DBName': $("#cboYear").val(),
                            'PeriodCode': $("#cboPeriod").val(),
                            'DocumentType': $("#cboTransType").val(),
                            'DocumentNo': DocNo,
                            'Password': sltpwd,
                            'Salt': pwdslt
                        }
                        outData = JSON.stringify(outData);
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: "<%: Url.Content("~/api/BankSystemApi/PostGeneralTransactions") %>",
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                var docno = response;
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }

                        });

                    }
                }
            }
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">

    <h3>Receipts And Payments</h3>

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <table>
        <tr>
            <td>
                Year:
            </td>
            <td>
                <select id="cboYear"><option value="selectyear">SELECT YEAR</option></select>
            </td>
            <td>
                Month:
            </td>
            <td> 
                <select id="cboPeriod"><option value="selectstartperiod" selected>(SELECT PERIOD)</option></select>
            </td>
            <td>Type:</td>
            <td><select id="cboTransType">
                        <option value="selecttype" selected>(SELECT TYPE)</option>
                        <option value="PAYMENT">PAYMENT</option>
                        <option value="RECEIPT">RECEIPT</option>
                        </select>
                    </td>
        </tr>
    </table>
    <hr />
    <div id="tabs">
      <ul>
        <li><a href="#tabs-1">Capture Transactions</a></li>
        <li><a href="#tabs-2">Transactions Listing</a></li>
      </ul>
    <form name="frmMain" id="frmMain">
        <%= Html.AntiForgeryToken() %>
        
        <div id="tabs-1">
        <table id="tblDetails" border="1">
            
            <tr>
                    
                    <td>Mode</td>
                    <td>
                        <select id="cboTransMode">
                            <option value="" selected>(SELECT)</option>
                            <option value="cash">CASH</option>
                            <option value="bank">BANK</option>
                            <option value="sto">STO</option>
                            <option value="eft">EFT</option>
                            <option value="rtgs">RTGS</option>
                        </select></td>
                    <td>Account</td><td colspan="4"><select id="cboAccount"><option value="selectaccount">(SELECT ACCOUNT)</option></select></td>
                    
                    
                </tr>
                <tr>
                    <td>Doc. Date</td>
                    <td><input type="text" id="txtDate"/></td>
                    <td>Cheque No</td>
                    <td><input type="text" id="txtChequeNo"/></td>
                    <td>Doc No</td>
                    <td><input type="text" id="txtDocNo"/></td>
                </tr>
                
                
                <tr>
                    <td><input type="button" value="Contra A/C" id="btnContraAccNo" /></td>
                    <td><input type="text" id="txtContraAccNo" /></td>
                    <td>Account Name : </td>
                    <td><div id="divContraAccName"></div></td>
                </tr>
                <tr>
                    <td>Description</td>
                    <td><input type="text" id="txtDescription"/></td>
                    <td>Amount</td>
                    <td><input type="text" id="txtAmount"/></td>
                    <td>&nbsp;&nbsp;</td><td><input id="btnAddToList" type="button" value="Add" /></td>
                </tr>
                <tr>
                    <td>Amt. In Words:</td>
                    <td colspan="3"><div id="divAmountInWords"></div></td>
                </tr>
            </table>
            <hr />
            <div id="divTransactionItemList" style="height:200px;overflow:auto;width:auto;">
               
            <table id='tblTransactionDetails' class="table table-striped tblTransactionDetails" style="width:100%">
                    <thead>
                        <tr>
                        <th><b>Row_No</b></th>
                        <th><b>Bank/Cash A/C</b></th>
                        <th><b>Acc Name</b></th>
                        <th><b>Contra Acc</b></th>
                        <th><b>Contra Acc Name</b></th>
                        <th class="td_amount_col"><b>Amount</b></th>
                        <th><b>Date</b></th>
                        <th><b>DocNo</b></th>
                        <th><b>Cheque No</b></th>
                        <th><b>Description</b></th>
                        </tr>
                    </thead>
                    <tbody id='bdTransactionItems'>
                    </tbody>
            </table>
                
            </div>
            <hr />      
             <table>
                    <tr>
                        <td><input type="button" value="New Batch" id="btnNew" /></td>
                        <td><input type="button" value="Cancel Batch" id="btnCancel" /></td>
                        <td><input type="button" value="Remove Line Item" id="btnRemoveLineItem" /></td>
                        <td><input type="button" value="Save Batch" id="btnSave" />&nbsp;&nbsp;TOTALS:&nbsp;&nbsp;<input type="text" id="txtTotals"  class="numbertext" readonly="true"/></td>
                    </tr>
                </table>

            
        </div>
        <div id="tabs-2">
        <table id="tblListing" border="1">
            <tr>
                <td>Posted</td>
                <td>
                    <select id="cboFilterPostedStatus">
                    <option value="UNPOSTED" selected>UNPOSTED</option>
                    <option value="POSTED" >POSTED</option>
                    <option value="" >ALL</option>
                    </select>
                </td>
                <td>Branch</td>
                <td>
                    <select id="cboFilterBranches">
                    <option value="" selected>(ALL)</option>
                    </select>
                </td>
            </tr>
            
        </table>
             <div id="divTransListSummary" style="height:200px;overflow:auto;width:auto;">
                <table id='tblTransListSummary'class="table table-striped"  style="width:100%">
                        <thead>
                            <tr>
                            <th><b>Document No</b></th>
                            <th><b>Transactions</b></th>
                            <th><b>Doc Date</b></th>
                            <th><b>Appraisal User</b></th>
                            <th><b>Amount</b></th>
                            <th><b>Status</b></th>
                            <th><b>Branch</b></th>
                            <th><b>Branch Name</b></th>
                            <th><b>Post User</b></th>
                            <th><b>Post Date</b></th>
                                
                            </tr>
                        </thead>
                        <tbody id='bdTransListSummary'>
                        </tbody>
                </table>
            </div>
            <table>
                <tr>
                    <td><input type="button" id="btnRefresh" value="Refresh List" /></td>
                    <td><input type="button" id="btnPost" value="Post Selected Documents" /></td>
                    <td><input type="button" id="btnDeleteDoc" value="Delete Selected Documents" /></td>
                </tr>
            </table>
            <hr />
            <p id="pDocDetails">Document Details</p>
            <hr />
            <div id="divTransListDetails" style="height:150px;overflow:auto;width:auto;">
                <table id='tblTransListDetails' class="table table-striped"  style="width:100%; font-size:80%">
                        <thead>
                            <tr>
                            <th><b>Ref_No</b></th>
                            <th><b>DR_Type</b></th>
                            <th><b>DR_Acc</b></th>
                            <th><b>DR_Acc_Name</b></th>
                            <th><b>DR_MemberNo</b></th>
                            <th><b>DR_Member_Names</b></th>
                            <th><b>CR_Type</b></th>
                            <th><b>CR_Acc</b></th>
                            <th><b>CR_Acc_Name</b></th>
                            <th><b>CR_Member_No</b></th>
                            <th><b>CR_Member_Names</b></th>
                            <th><b>Description</b></th>
                            <th><b>Date</b></th>
                            <th><b>Amount</b></th>
                            </tr>
                        </thead>
                        <tbody id='bddivTransListDetails'>
                        </tbody>
                    
                </table>
                
            </div>
            <table>
                <tr>
                    <td>
                        <input type="button" id="btnDeleteSelected" value="Delete Selected Line items" />
                    </td>
                </tr>
            </table>
            <hr />  
        </div>
    </form>
</div>

</asp:Content>


