﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loan Appraisal
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
     <style type="text/css"></style>

    <script type="text/javascript"  >

        
        $(document).ready(function () {
            
            
            var EmpCode = "";
            var PayrollNo = "";
            var SalaryAccount = "";
            var BoolEditingLoan = eval(<%= ViewBag.BoolEditingLoan ? "true" : "false" %>);
            var EditMemberLoanApplicationNo = null;
            var EditMemberLoanNo = null;
            var EditMemberLoanApplicationDetails = Object(<% = Json.Encode(ViewBag.EditMemberLoanApplicationDetails as XtremeERP.Common.Data.MemberLoanApplicationDetails) %>);
            var EditLoanDetails = Object(<% = Json.Encode(ViewBag.EditLoanDetails as XtremeERP.Common.Data.LoanDetails) %>);
            var EditDB = "";

            
                $('#frmLoanAppraisal').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    e.preventDefault();
                });
                $('#frmLoanAppraisal').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    $(this).select();
                });
                $('#frmLoanAppraisal').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    $(this).addClass("textfocused");
                });
                $('#frmLoanAppraisal').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    $(this).removeClass("textfocused");
                });
                
                $("#tblGuarantors").dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                $("#tblOffsets").dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                $("#tblBalances").dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                $('#tabs').on('tabsactivate', function (event, ui) {
                    var newIndex = ui.newTab.index();
                    if (newIndex == 7) {
                        SendAppraisalData("processappraisal");
                    }
                });
                ClearAppraisalData();
                ClearAppraisalReport();

                $("#txtLoanDate").datepicker({ dateFormat: 'dd/mm/yy' });
                $("#cboGuarantorSearchBy").on('change', function () {
                    ShowGuarantorSearchParams();
                });
                $("#cboGuarantorSearchBy").trigger('onchange');
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetLoanAppraisalConfig") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var mList = response.EmployerList;
                        var obj = document.getElementById("cboEmployer");
                        $.each(mList, function (index, mListItem) {
                            var opt = document.createElement("option");
                            opt.value = mListItem.EmployerCode;
                            opt.text = mListItem.EmployerName;
                            obj.appendChild(opt);
                        });
                        var mList = response.EmployerList;
                        var obj = document.getElementById("cboGuarantorEmpCode");
                        $.each(mList, function (index, mListItem) {
                            var opt = document.createElement("option");
                            opt.value = mListItem.EmployerCode;
                            opt.text = mListItem.EmployerName;
                            obj.appendChild(opt);
                        });
                        var mList = response.LoanTypesList;
                        var obj = document.getElementById("cboLoanType");
                        $.each(mList, function (index, mListItem) {
                            var opt = document.createElement("option");
                            opt.value = mListItem.LoanTypeCode + "^" + mListItem.LoanMaxDuration + "^" + mListItem.LoanSerialIdentifier ;
                            opt.text = mListItem.LoanTypeName + "(" + mListItem.LoanSerialIdentifier + ")";
                            obj.appendChild(opt);
                        });
                        var mList = response.PayslipEarningsList;

                        var tbl = "<table class='table table-bordered' id='tblEarnings'><tbody id='bdTblIncomes'><tr><td><b>Earning Code</b></td><td><b>Earning Name</b></td><td><b>Amount</b></td></tr>"
                        $.each(mList, function (index, mListItem) {
                            tbl += "<tr><td>" + mListItem.EarningCode + "</td><td>" + mListItem.EarningName + "</td><td><input type='text' value=0 /></td></tr>"
                        });
                        tbl += "</tbody></table>";
                        $("#divSalaryIncomes").html(tbl);
                        var mList = response.PayslipDeductionsList;
                        var tbl = "<table class='table table-bordered' id='tblDeductions'><tbody id='bdTblDeductions'><tr><td><b>Deduction Code</b></td><td><b>Deduction Name</b></td><td><b>Amount</b></td></tr>"
                        $.each(mList, function (index, mListItem) {
                            tbl += "<tr><td>" + mListItem.DeductionCode + "</td><td>" + mListItem.DeductionName + "</td><td><input type='text' value=0 /></td></tr>"
                        });
                        tbl += "</tbody></table>";
                        $("#divSalaryDeductions").html(tbl);

                        DisplayLoanAppraisalDetails();
                        DisplayMemberApplicationDetails();

                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
                $("#btnDeleteGuarantor").click(function () {
                    try {
                        var table = document.getElementById('tblGuarantors');
                        var rowCount = table.rows.length;
                        for (var i = 0; i < rowCount; i++) {
                            var row = table.rows[i];
                            var chkbox = row.cells[0].childNodes[0];
                            if (null != chkbox && true == chkbox.checked) {
                                table.deleteRow(i);
                                rowCount--;
                                i--;
                            }
                        }
                    } catch (err) {
                        alert(err);
                    }
                });
                $("#btnDelOffset").click(function () {
                    try {
                        var table = document.getElementById('tblOffset');
                        var rowCount = table.rows.length;
                        for (var i = 0; i < rowCount; i++) {
                            var row = table.rows[i];
                            var chkbox = row.cells[0].childNodes[0];
                            if (null != chkbox && true == chkbox.checked) {
                                table.deleteRow(i);
                                rowCount--;
                                i--;
                            }
                        }
                    } catch (err) {
                        alert(err);
                    }
                });
                $("#txtGuaranteedAmount").on('focusout', function () {
                    //$("#btnAddGuarantor").trigger('click'); causes guarantor to be added twice
                });
                $("#btnAddGuarantor").on('click',function () {
                    if (!isNumber($('#txtGuaranteedAmount').val())) {
                        alert("Invalid guarantor Amount");
                        return;
                    }
                    var row = 0;
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/GetMemberRecord") %>",
                        data: "{'SearchBy' : '" + $("#cboGuarantorSearchBy").val() + "','SearchValue' : '" + $("#txtGuarantorSearchValue").val() + "','EmpCode' : '" + $("#cboGuarantorEmpCode").val() + "'}",
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            var tblrow  = "<tr>";
                            tblrow += "<td><input type='checkbox'/>" + response.FullNames + "</td>";
                            tblrow += "<td>" + response.EmployerCode + "</td>";
                            tblrow += "<td>" + response.PayrollNo + "</td>";
                            tblrow += "<td>" + response.MemberNo + "</td>";
                            tblrow += "<td>" + 0 + "</td>";
                            tblrow += "<td><input type='text' value='" + $('#txtGuaranteedAmount').val() + "' /></td>";
                            tblrow += "</tr>";
                            $('#bdGuarantors').append(tblrow);
                            $('#txtGuaranteedAmount').val("");
                            $('#txtGuarantorSearchValue').val("");
                            $('#txtGuarantorSearchValue').focus();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
                $("#btnProcessAppraisal").click(function () {
                    SendAppraisalData("processappraisal");
                });
                $("#txtSearchValue").on('focusout', function () {
                    GetMemberDetails();
                });
                $('#txtSearchValue').keypress(function (e) {
                    var kcode = (e.keyCode ? e.keyCode : e.which);
                    if (kcode == $.ui.keyCode.ENTER) {
                        GetMemberDetails();
                    }
                });
                $("#btnGetMember").click(function () {
                    GetMemberDetails();
                });


                $("#btnProcessAppraisal").click(function () {
                    SendAppraisalData("processappraisal");
                });
                $("#btnSaveAppraisal").on('click', function () {
                    if (!IsValidDate($("#txtLoanDate").val())) {
                        alert("Invalid Date");
                        return;
                    }
                    xDialogConfirm("Save Loan Appraisal?", "Confirm").then(function () {
                        xDialogGetUserCredetials().then(function (data) {
                            SaveAppraisal(data);
                        });
                    });
                });
             function DisplayMemberInfo(mem_details) {

                EmpCode = mem_details.EmployerCode;
                PayrollNo = mem_details.PayrollNo;
                SalaryAccount = mem_details.SalaryAccount;

                var tbl = "<table class='table table-bordered'><tr><td><b>EmpCode</b></td><td><b>PayrollNo</b></td><td><b>MemberNo</b></td><td><b>Names</b></td><td><b>Details</b></td></tr>"
                tbl += "<tr><td>" + mem_details.EmployerCode + "</td><td>" + mem_details.PayrollNo + "</td><td>" + mem_details.MemberNo + "</td><td>" + mem_details.FullNames + "</td><td><a href='" + global_site_root + "/Bank/BankSystem/MembersMasterFile?EditMode=true&EmpCode=" + mem_details.EmployerCode + "&PayrollNo=" + mem_details.PayrollNo + "'>View Details</a></td></tr>"
                $('#divAccountInfo').html(tbl);
            }

            function DisplayMemberBalances(MemberBalances) {
                $("#tblOffsets > tbody:last").children().remove();
                $("#tblBalances > tbody:last").children().remove();
                var tbl_row = "";
                $.each(MemberBalances, function (index, MemberBalance) {
                    if (MemberBalance.BalType != "F") {
                        tbl_row += "<tr><td>" + MemberBalance.BalType + "</td><td>" + MemberBalance.BalCode + "</td><td>" + MemberBalance.BalName + "</td><td>" + (+MemberBalance.BalAmount).formatMoney() + "</td><td><input type='text' value='0.00' /></td></tr>"
                    }
                });
                $("#bdOffsets").append(tbl_row);
                var tbl_row = "";
                $.each(MemberBalances, function (index, MemberBalance) {
                    tbl_row += "<tr><td>" + MemberBalance.BalType + "</td><td>" + MemberBalance.BalCode + "</td><td>" + MemberBalance.BalName + "</td><td>" + (+MemberBalance.BalAmount).formatMoney() + "</td></tr>"
                });
                $("#bdBalances").append(tbl_row);

            }

            function DisplayMemberApplicationDetails()
            {
                //alert(typeof EditMemberLoanApplicationDetails);
                if (!EditMemberLoanApplicationDetails) { return; }
                if (EditMemberLoanApplicationDetails.saccoMember != null) {
                    DisplayMemberInfo(EditMemberLoanApplicationDetails.saccoMember);
                }
                if (EditMemberLoanApplicationDetails.memberBalancesSummary != null) {
                    if (EditMemberLoanApplicationDetails.memberBalancesSummary.MemberBals != null) {
                        DisplayMemberBalances(EditMemberLoanApplicationDetails.memberBalancesSummary.MemberBals);
                    }
                }
                if (EditMemberLoanApplicationDetails.CreditAccounts != null) {
                    DisplayCreditAccounts(EditMemberLoanApplicationDetails.CreditAccounts);
                }
                if (EditMemberLoanApplicationDetails.memberLoanApplication != null) {
                    document.getElementById("cboSearchBy").selectedIndex = 1;

                    EditMemberLoanApplicationNo = EditMemberLoanApplicationDetails.memberLoanApplication.LoanRefNo;

                    $("#cboEmployer").prop("disabled", true); //we are displaying existing records cannot be modified
                    $("#cboSearchBy").prop("disabled", true); //we are displaying existing records cannot be modified
                    $("#txtSearchValue").val(EditMemberLoanApplicationDetails.memberLoanApplication.MemberNo);
                    $("#txtSearchValue").prop("disabled", true); //we are displaying existing records cannot be modified

                    $("#divLoanSerialNumber").html("");
                    $("#divLoanStatus").html("");
                    $("#txtLoanDate").val(EditMemberLoanApplicationDetails.memberLoanApplication.LoanDate);
                    $("#txtLoanAmount").val(EditMemberLoanApplicationDetails.memberLoanApplication.RequestedAmount);
                    $("#txtLoanPurpose").val(EditMemberLoanApplicationDetails.memberLoanApplication.LoanPurpose);
                    $("#txtRepaymentPeriod").val(EditMemberLoanApplicationDetails.memberLoanApplication.RepaymentPeriod);
                    $("#txtInstructions").val(EditMemberLoanApplicationDetails.memberLoanApplication.Instructions);
                    var tmpArr = $("#cboLoanType").val();
                    tmpArr = tmpArr.split("^");
                    $('#cboLoanType').find('option').each(function (index, element) {
                        var tmpArr = element.value.split("^");
                        if (tmpArr[0].toString().toLowerCase() == EditMemberLoanApplicationDetails.memberLoanApplication.LoanTypeCode.toString().toLowerCase()) {
                            document.getElementById("cboLoanType").selectedIndex = index;
                            
                        }
                    });
                    $("#cboLoanType").prop("disabled", true); //cannot change what was applied for
                    $("#txtLoanAmount").prop("disabled", true); //cannot change what was applied for
                    $("#txtLoanPurpose").prop("disabled", true); //cannot change what was applied for

                    if (EditMemberLoanApplicationDetails.memberLoanApplicationGuarantor != null) {
                        var tbl_row = "";
                        $.each(EditMemberLoanApplicationDetails.memberLoanApplicationGuarantor, function (index, AppraisalGuarantor) {
                            var tblrow = "<tr>";
                            tblrow += "<td><input type='checkbox'/>" + AppraisalGuarantor.GuarantorName + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.GuarantorEmployerCode + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.GuarantorPayrollNo + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.GuarantorMemberNo + "</td>";
                            tblrow += "<td>" + 0 + "</td>";
                            tblrow += "<td><input type='text' value='" + AppraisalGuarantor.AcceptedAmount + "' /></td>";
                            tblrow += "</tr>";
                            $('#bdGuarantors').append(tblrow);
                        });
                    }

                    if (EditMemberLoanApplicationDetails.memberLoanApplicationOffset != null) {
                        $.each(EditMemberLoanApplicationDetails.memberLoanApplicationOffset, function (index, lnOffsets) {
                            $("#tblOffsets tbody").find('tr').each(function (i) {
                                var row = $(this);
                                var txtAmt = row.find('td:eq(4)').find('input:eq(0)');
                                if ((lnOffsets.OffsetType == row.find('td:eq(0)').text()) && (lnOffsets.SchemeCode == row.find('td:eq(1)').text())) {
                                    txtAmt.val(lnOffsets.Amount);
                                } else if ((lnOffsets.OffsetType == row.find('td:eq(0)').text()) && (lnOffsets.LoanSerialNo == row.find('td:eq(1)').text())) {
                                    txtAmt.val(lnOffsets.Amount);
                                } else if ((lnOffsets.OffsetType == row.find('td:eq(0)').text()) && (lnOffsets.LoanSerialNo == row.find('td:eq(1)').text())) {
                                    txtAmt.val(lnOffsets.Amount);
                                }
                            });
                        });
                    }

                }
            }
        
            function DisplayLoanAppraisalDetails() {
                //alert(typeof EditLoanDetails);
                if (!EditLoanDetails) { return; }
                if (EditLoanDetails.saccoMember != null) {
                    DisplayMemberInfo(EditLoanDetails.saccoMember);
                }
                if (EditLoanDetails.memberBalancesSummary != null) {
                    if (EditLoanDetails.memberBalancesSummary.MemberBals != null) {
                        DisplayMemberBalances(EditLoanDetails.memberBalancesSummary.MemberBals);
                    }
                }
                if (EditLoanDetails.CreditAccounts != null) {
                    DisplayCreditAccounts(EditLoanDetails.CreditAccounts);
                }
                if (EditLoanDetails.mLoanAppraisals != null) {
                    document.getElementById("cboSearchBy").selectedIndex = 1;
                    EditMemberLoanNo = EditLoanDetails.mLoanAppraisals.LoanSerialNumber;
                    $("#txtSearchValue").val(EditLoanDetails.mLoanAppraisals.MemberNumber);
                    $("#divLoanSerialNumber").html(EditLoanDetails.mLoanAppraisals.LoanSerialNumber);
                    $("#divLoanStatus").html(EditLoanDetails.mLoanAppraisals.LoanStatus);
                    $("#txtLoanDate").val(EditLoanDetails.mLoanAppraisals.LoanDate);
                    $("#txtLoanAmount").val(EditLoanDetails.mLoanAppraisals.RequestedAmount);
                    $("#txtLoanPurpose").val(EditLoanDetails.mLoanAppraisals.PurposeForLoan);


                
                    $("#cboEmployer").prop("disabled", true); //we are displaying existing records cannot be modified
                    $("#cboSearchBy").prop("disabled", true); 
                    $("#txtSearchValue").prop("disabled", true); 

                    var tmpArr = $("#cboLoanType").val();
                    tmpArr = tmpArr.split("^");
                    $('#cboLoanType').find('option').each(function (index, element) {
                        var tmpArr = element.value.split("^");
                        if (tmpArr[2] == EditLoanDetails.mLoanAppraisals.LoanType) {
                            document.getElementById("cboLoanType").selectedIndex = index
                        }
                    });
                    if (EditLoanDetails.mAppraisalReport != null) {
                        $("#txtRepaymentPeriod").val(EditLoanDetails.mAppraisalReport.RepaymentPeriod);
                        $("#txtRecomendedRepaymentPeriod").val(EditLoanDetails.mAppraisalReport.RepaymentPeriod);
                        $("#txtReasons").val(EditLoanDetails.mAppraisalReport.Reasons);
                        $("#txtStartYear").val(EditLoanDetails.mAppraisalReport.StartYear);
                        $("#txtStartMonth").val(EditLoanDetails.mAppraisalReport.StartMonthName);
                        $("#txtStartPeriod").val(EditLoanDetails.mAppraisalReport.StartPeriod);
                        $("#txtRecomendedAmount").val(EditLoanDetails.mAppraisalReport.RecommendedAmount);
                        $("#txtRecomendedInstallmentAmount").val(EditLoanDetails.mAppraisalReport.InstallmentAmount);
                        $("#txtDepositsMultiplied").val(EditLoanDetails.mAppraisalReport.SharesMultiplied);
                        $("#txtSchemeBalance").val(EditLoanDetails.mAppraisalReport.TotalShares);
                        $("#txtIncomeFractionized").val(EditLoanDetails.mAppraisalReport.IncomeFractionised);
                        $("#txtSalaryEligibility").val(EditLoanDetails.mAppraisalReport.SalaryEligibiliy);
                        $("#txtSharesEligibility").val(EditLoanDetails.mAppraisalReport.SharesEligibiliy);
                        $("#txtGuarantorsEligibility").val(EditLoanDetails.mAppraisalReport.GrantsEligibiliy);
                    }
                    if (EditLoanDetails.mAppraisalGuarantors != null)
                    {
                        var tbl_row = "";
                        $.each(EditLoanDetails.mAppraisalGuarantors, function (index, AppraisalGuarantor) {
                            var tblrow = "<tr>";
                            tblrow += "<td><input type='checkbox'/>" + AppraisalGuarantor.FullNames + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.EmployerCode + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.PayrollNo + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.MemberNumber + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.AvailableShares + "</td>";
                            tblrow += "<td><input type='text' value='" + AppraisalGuarantor.SharesToCommit + "' /></td>";
                            tblrow += "</tr>";
                            $('#bdGuarantors').append(tblrow);
                        });
                    }
                
                    if (EditLoanDetails.mAppraisalEarnings != null) {
                        $.each(EditLoanDetails.mAppraisalEarnings, function (index, AppraisalEarning) {
                        
                            $("#tblEarnings tbody").find('tr').each(function (i) {
                                var row = $(this);
                            
                                if (AppraisalEarning.EarningCode == row.find('td:eq(0)').text()) {
                                    var txtAmt = row.find('td:eq(2)').find('input:eq(0)');
                                    txtAmt.val(AppraisalEarning.EarningAmount);
                                }
                            });
                        });
                    }
                    if (EditLoanDetails.mAppraisalDeductions != null) {
                        $.each(EditLoanDetails.mAppraisalDeductions, function (index, AppraisalDeduction) {
                            $("#tblDeductions tbody").find('tr').each(function (i) {
                                var row = $(this);
                                if (AppraisalDeduction.DeductionCode == row.find('td:eq(0)').text()) {
                                    var txtAmt = row.find('td:eq(2)').find('input:eq(0)');
                                    txtAmt.val(AppraisalDeduction.DeductionAmount);
                                }
                            });
                        });
                    }
                    if (EditLoanDetails.mAutoLnDistribution != null) {
                        $.each(EditLoanDetails.mAutoLnDistribution, function (index, lnOffsets) {
                            $("#tblOffsets tbody").find('tr').each(function (i) {
                                var row = $(this);
                                var txtAmt = row.find('td:eq(4)').find('input:eq(0)');
                                if ((lnOffsets.TransType == row.find('td:eq(0)').text()) && (lnOffsets.Scheme == row.find('td:eq(1)').text())) {
                                    txtAmt.val(lnOffsets.AutoAmt);
                                }else if ((lnOffsets.TransType == row.find('td:eq(0)').text()) && (lnOffsets.ClearLoanCode == row.find('td:eq(1)').text())) {
                                    txtAmt.val(lnOffsets.AutoAmt);
                                }else if ((lnOffsets.TransType == row.find('td:eq(0)').text()) && (lnOffsets.OffsetInt == row.find('td:eq(1)').text())) {
                                    txtAmt.val(lnOffsets.AutoAmt);
                                }
                            });
                        });
                    }

                }
            }

            function AutoProcessAppraisal() {
                SendAppraisalData("processappraisal",null);
            }
            function SaveAppraisal(UserCredentials) {
                SendAppraisalData("savenewappraisal", UserCredentials);
            }
            function ClearAppraisalData() {

                $("#txtSearchValue").val("");
                $("#txtRepaymentPeriod").val("");
                $("#txtLoanPurpose").val("");
                $("#txtLoanAmount").val("0");
                $("#RepaymentPeriod").val(1);
                $("#txtLoanDate").val("");
                $("#cboCreditAccount").empty();
                $("#cboGuarantorSearchBy").trigger('onchange');
                $("#txtGuarantorSearchValue").val("");
                $("#cboGuarantorEmpCode").val("");
                $("#txtGuaranteedAmount").val("");
            
                $("#tblBalances > tbody:last").children().remove();
                $("#tblOffsets > tbody:last").children().remove();
                $("#tblGuarantors > tbody:last").children().remove();
                $('#divAccountInfo').empty();

            
            }
            function ClearAppraisalReport() {
                $("#txtRecomendedAmount").val("0");
                $("#txtRecomendedRepaymentPeriod").val("1");
                $("#txtRecomendedInstallmentAmount").val("0");
                $("#txtIncomeFractionized").val("0");
                $("#txtPayslipDeductions").val("0");
                $("#txtDepositsMultiplied").val("0");
                $("#txtSharesEligibility").val("0");
                $("#txtSalaryEligibility").val("0");
                $("#txtGuarantorsEligibility").val("0");
                $("#txtSchemeBalance").val("0");
                $("#txtStartYear").val("0");
                $("#txtStartMonth").val("0");
                $("#txtStartPeriod").val("0");
                $("#txtReasons").val("");
            }
            $("#btnNewAppraisal").on('click',function(){
                ClearAll();
            });
        function ClearAll() {
            if (BoolEditingLoan == true) {
                //ensure you reset entire window on new appraisal or make sure you reset public vars
                document.location = "/Bank/BankSystem/LoanAppraisal";
            }
            EditMemberLoanApplicationNo = null;
            EditMemberLoanApplicationDetails = null;
            EditMemberLoanNo = null;
            EditLoanDetails = null;

            ClearAppraisalData();
            ClearAppraisalReport();
        }
        
        $("#cboLoanType").on('change', function () {
            DisplayMaxRepayment();
        });

        function DisplayMaxRepayment() {
            var tmpArr = $("#cboLoanType").val();
            var tmpArr = tmpArr.split("^");
            $("#txtRepaymentPeriod").val(tmpArr[1]);
        }

        

        

        function setCookie(c_name, value, expiredays) {
            var exdate = new Date();
            exdate.setDate(exdate.getDate() + expiredays);
            document.

                e = c_name + "=" + escape(value) +
            ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
        }
        function getCookie(c_name) {
            if (document.cookie.length > 0) {
                c_start = document.cookie.indexOf(c_name + "=");
                if (c_start != -1) {
                    c_start = c_start + c_name.length + 1;
                    c_end = document.cookie.indexOf(";", c_start);
                    if (c_end == -1) c_end = document.cookie.length;
                    return unescape(document.cookie.substring(c_start, c_end));
                }
            }
            return "";
        }
        function LoadCreditAccounts() {
            $('#cboCreditAccount').empty();
            var EmpCode = "";
            var PayrollNo = "";
            var elt = document.getElementById("cboEmployer");
            var elt2 = document.getElementById("cboSearchBy");
            if (elt2.selectedIndex == 3) {
                if (elt.selectedIndex = 0) {
                    alert("Select Employer");
                    return false;
                }
            }
            if ($('#txtSearch').val() == '') {
                alert('Enter Search Critria');
                return false;
            }
           

            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetLoanAppraisalAccounts") %>",
                    data: "{'SearchBy' : '" + $("#cboSearchBy").val() + "','SearchValue' : '" + $("#txtSearchValue").val() + "','EmpCode' : '" + $("#cboEmployer").val() + "'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        DisplayCreditAccounts(response)
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
            });

        }

        function DisplayCreditAccounts(mList) {
            $('#cboCreditAccount').empty();
            var obj = document.getElementById("cboCreditAccount");
            var opt = document.createElement("option");
            opt.value = "";
            opt.text = "(SELECT CREDIT ACCOUNT)";
            obj.appendChild(opt);
            $.each(mList, function (index, mListItem) {
                var opt = document.createElement("option");
                opt.value = mListItem.UserCode;
                opt.text = mListItem.AccountName + "(" + mListItem.UserCode + ")";
                obj.appendChild(opt);

                if (SalaryAccount) {
                    if (SalaryAccount.toLowerCase() == mListItem.UserCode.toLowerCase()) {
                        obj.selectedIndex = index + 1;
                    }
                }
            });
        }

        function GetMemberDetails(){
            
            $("#tblOffsets > tbody:last").children().remove();
            $("#tblBalances > tbody:last").children().remove();
            var SalaryAccount = "";
            var EmpCode = "";
            var PayrollNo = "";
            var elt = document.getElementById("cboEmployer");
            var elt2 = document.getElementById("cboSearchBy");
            if (elt2.selectedIndex == 3) {
                if (elt.selectedIndex = 0) {
                    alert("Select Employer");
                    return false;
                }
            }
            if ($('#txtSearch').val() == '') {
                alert('Enter Search Critria');
                return false;
            }

            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetMemberBalancesSummary") %>",
                    data: "{'SearchBy' : '" + $("#cboSearchBy").val() + "','SearchValue' : '" + $("#txtSearchValue").val() + "','EmpCode' : '" + $("#cboEmployer").val() + "','IncludeNegativeLoans' : 'F'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        DisplayMemberInfo(response.MemberDetails);
                        DisplayMemberBalances(response.MemberBals);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                }).done(function(){
                    LoadCreditAccounts()
                });
        }

        

        function SendAppraisalData(AppraisalAction, UserCredentials) {
            if ($("#divLoanStatus").html() == "In-Service") { alert("Loan is in service"); return; }
            var UserName = null;
            var Password = null;
            if (UserCredentials == null) { }
            else {
                UserName = UserCredentials.UserName;
                Password = UserCredentials.UserPass;
                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();
            }
            var Guarantors = new Array();
            var Offsets = new Array();
            var PayslipEarnings = new Array();
            var PayslipDeductions = new Array();
            var tbody = document.getElementById('bdTblIncomes');
            var tableRows = tbody.getElementsByTagName('tr');
            var rowCount = tableRows.length;
            var Entries = 0;
            var AppraisedReport = {
                RecommendedAmount:$("#txtRecomendedAmount").val(),
                RepaymentPeriod:$("#txtRecomendedRepaymentPeriod").val(),
                InstallmentAmount:$("#txtRecomendedInstallmentAmount").val(),
                IncomeFractionised:$("#txtIncomeFractionized").val(),
                TotalDeductionsFromIncome:$("#txtPayslipDeductions").val(),
                SharesMultiplied:$("#txtDepositsMultiplied").val(),
                SharesEligibiliy:$("#txtSharesEligibility").val(),
                SalaryEligibiliy:$("#txtSalaryEligibility").val(),
                GrantsEligibiliy:$("#txtGuarantorsEligibility").val(),
                TotalShares:$("#txtSchemeBalance").val(),
                StartYear:$("#txtStartYear").val(),
                StartPeriod: $("#txtStartPeriod").val(),
                StartMonthName: $("#txtStartMonth").val(),
                Reasons:$("#txtReasons").val()
            }
            for (var x = rowCount - 1; x > 0; x--) {
                var Earning = {};
                var lineamount = 0;
                var myrow = tbody.getElementsByTagName("tr")[x];
                var mycel = myrow.getElementsByTagName("td")[2];
                lineamount = mycel.childNodes.item(0).value;

                if (!isNumber(lineamount)) {
                    alert("Invalid earning Amount " + lineamount + " at row " + x);
                    return;
                }
                if (lineamount < 0) {
                    alert("Earning Amount " + lineamount + " should be more than or equal to Zero. At row " + x);
                    return;
                }

                Earning.LoanSerialNumber = "";
                Earning.EarningName = "";
                Earning.ComputationalPercentage = 100;
                var mycel = myrow.getElementsByTagName("td")[0];
                Earning.EarningCode = mycel.innerHTML;
                var mycel = myrow.getElementsByTagName("td")[2];
                Earning.EarningAmount = lineamount

                PayslipEarnings[Entries] = Earning;
                Entries++;
            }

            var tbody = document.getElementById('bdTblDeductions');
            var tableRows = tbody.getElementsByTagName('tr');
            var rowCount = tableRows.length;
            var Entries = 0;
            for (var x = rowCount - 1; x > 0; x--) {
                var Deduction = {};
                var lineamount = 0;
                var myrow = tbody.getElementsByTagName("tr")[x];
                var mycel = myrow.getElementsByTagName("td")[2];
                lineamount = mycel.childNodes.item(0).value;

                if (!isNumber(lineamount)) {
                    alert("Invalid deduction Amount " + lineamount + " at row " + x);
                    return;
                }
                if (lineamount < 0) {
                    alert("Deduction Amount " + lineamount + " should be more than or equal to Zero. At row " + x);
                    return;
                }

                Deduction.LoanSerialNumber = "";
                Deduction.DeductionName = "";
                var mycel = myrow.getElementsByTagName("td")[0];
                Deduction.DeductionCode = mycel.innerHTML;
                var mycel = myrow.getElementsByTagName("td")[2];
                Deduction.DeductionAmount = lineamount
                Deduction.IsStatutory = "N";
                PayslipDeductions[Entries] = Deduction;
                Entries++;
            }
            

            //********************************************************
            var validCount = 0;
            var dblTotalAmount = 0;
            $("#tblGuarantors tbody").find('tr').each(function (i) {
                var Guarantor = {};
                var row = $(this); //store in variable for faster access
                var txtAmt = row.find('td:eq(5)').find('input:eq(0)');
                if (!isNumber(txtAmt.val())) {
                    alert("Invalid guarantor amount at row " + i);
                    return;
                }
                var line_amount = txtAmt.val();
                line_amount = +line_amount;
                if (line_amount < 0) {
                    alert("Guarantor Amount  " + line_amount + " should be more than or equal to Zero. At row " + i);
                    return;
                }
                if (line_amount > 0) {
                    Guarantor.LoanSerialNumber = "";
                    Guarantor.AvailableLoanBal = 0;
                    Guarantor.GuarantorMemberNumber = row.find('td:eq(3)').text();
                    Guarantor.AvailableShares = row.find('td:eq(4)').text();
                    Guarantor.SharesToCommit = line_amount;
                    Guarantors[validCount] = Guarantor;
                    validCount++;
                }
            });

            //********************************************************

            //********************************************************
            var validCount = 0;
            var OffSetsList = new Array();
            var dblTotalAmount = 0;
            $("#tblOffsets tbody").find('tr').each(function (i) {
                var OffSetEntry = {};
                var row = $(this); //store in variable for faster access
                OffSetEntry.TransType = row.find('td:eq(0)').text();
                OffSetEntry.BalCode = row.find('td:eq(1)').text();
                OffSetEntry.BalName = row.find('td:eq(2)').text();
                OffSetEntry.BalAmount = row.find('td:eq(3)').text();

                if ((OffSetEntry.TransType) == "S") {
                    OffSetEntry.Scheme = OffSetEntry.BalCode;
                    OffSetEntry.ClearLoanCode = "";
                    OffSetEntry.OffsetInt = "";
                }
                if ((OffSetEntry.TransType) == "L") {
                    OffSetEntry.Scheme = "";
                    OffSetEntry.ClearLoanCode = OffSetEntry.BalCode;
                    OffSetEntry.OffsetInt = "";
                }
                if ((OffSetEntry.TransType) == "I") {
                    OffSetEntry.Scheme = "";
                    OffSetEntry.ClearLoanCode = "";
                    OffSetEntry.OffsetInt = OffSetEntry.BalCode;
                }
                
                var txtAmt = row.find('td:eq(4)').find('input:eq(0)');
                if (!isNumber(txtAmt.val())) {
                    alert("Invalid offset amount at row " + i);
                    return;
                }
                var line_amount = txtAmt.val();
                line_amount = +line_amount;
                if (line_amount < 0) {
                    alert("Offset Amount  " + line_amount + " should be more than or equal to Zero. At row " + i);
                    return;
                }
                if (line_amount > 0) {
                    OffSetEntry.LoanSerialNumber = "";
                    OffSetEntry.AccCr = "";
                    OffSetEntry.AutoAmt = line_amount;
                    OffSetEntry.OtherNarration = "";
                    OffSetEntry.Posted = "N";
                    OffSetsList[validCount] = OffSetEntry;
                    validCount++;
                }
            });

            //********************************************************

            
            var tmpArr = $("#cboLoanType").val();
            var tmpArr = tmpArr.split("^");
            
            var outData = {
                'EmpCode': $("#cboEmployer").val(),
                'SearchBy': $("#cboSearchBy").val(),
                'SearchValue': $("#txtSearchValue").val(),
                'LoanTypeCode': tmpArr[0],
                'LoanAmount': $("#txtLoanAmount").val(),
                'RepaymentPeriod': $("#txtRepaymentPeriod").val(),
                'LoanPurpose': $("#txtLoanPurpose").val(),
                'LoanDate': $("#txtLoanDate").val(),
                'CreditAccount': $("#cboCreditAccount").val(),
                'AppraisalAction': AppraisalAction,
                'Guarantors': Guarantors,
                'Offsets': OffSetsList,
                'PayslipEarnings': PayslipEarnings,
                'PayslipDeductions': PayslipDeductions,
                'AppraisedReport': AppraisedReport,
                'UserName': UserName,
                'Password': sltpwd,
                'Salt': pwdslt,
                'EditMemberLoanApplicationNo': EditMemberLoanApplicationNo,
                'EditMemberLoanNo': EditMemberLoanNo,
                'EditDB': EditDB
        
            }
            
            outData = JSON.stringify(outData);
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/ProcessLoanAppraisal") %>",
                data: outData,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if(AppraisalAction=="processappraisal"){
                        $("#txtRecomendedAmount").val(response.RecommendedAmount);
                        $("#txtRecomendedRepaymentPeriod").val(response.RepaymentPeriod);
                        $("#txtRecomendedInstallmentAmount").val(response.InstallmentAmount);
                        $("#txtIncomeFractionized").val(response.IncomeFractionised);
                        $("#txtPayslipDeductions").val(response.TotalDeductionsFromIncome);
                        $("#txtDepositsMultiplied").val(response.SharesMultiplied);
                        $("#txtSharesEligibility").val(response.SharesEligibiliy);
                        $("#txtSalaryEligibility").val(response.SalaryEligibiliy);
                        $("#txtGuarantorsEligibility").val(response.GrantsEligibiliy);
                        $("#txtSchemeBalance").val(response.TotalShares);
                        $("#txtStartYear").val(response.StartYear);
                        $("#txtStartMonth").val(response.StartMonthName);
                        $("#txtStartPeriod").val(response.StartPeriod);
                        $("#txtReasons").val(response.Reasons);
                    } else if (AppraisalAction == "savenewappraisal") {
                        alert(response);
                    }
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });
        }

        
        

        //$(function () {
        //    $("#tabs").tabs();
            
        //});

        $('#tabs').responsiveTabs({
            // Start with the panels collapsed if the view is currently accordion based
            startCollapsed: 'accordion',
            // Tabs can be collapsed
            collapsible: true,
            // Tabs auto rotate
            rotate: false
        });
        $(function () {
            $("#accordion").accordion();
        });
        function ShowSearchParams() {
            $('#divSearchDisplay').empty();
            $('#divSearchDisplay').append('Enter ' + $("#cboSearchBy option:selected").text());
        }
        function ShowGuarantorSearchParams() {
            $('#divGuarantorSearchBy').empty();
            $('#divGuarantorSearchBy').append('Enter ' + $("#cboGuarantorSearchBy option:selected").text());
        }
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">

    <h3>Loan Appraisal</h3>

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div id="tabs">
      <ul>
        <li><a href="#tabs-1">Loan Details</a></li>
        <li><a href="#tabs-2">Payslip Capture</a></li>
        <li><a href="#tabs-3">Guarantors</a></li>
        <li><a href="#tabs-4">FOSA Guarantors</a></li>
        <li><a href="#tabs-5">Other Securities</a></li>
        <li><a href="#tabs-6">Offsets & Topup</a></li>
        <li><a href="#tabs-7">Balances</a></li>
        <li><a href="#tabs-8">Report</a></li>
        
        
      </ul>
    <form name="frmLoanAppraisal" id="frmLoanAppraisal">
        <%= Html.AntiForgeryToken() %>
        <div id="tabs-1">
            <table class="table table-bordered table-condensed">
            <tr>
                <td colspan="4"><b>Loan Details</b></td>
            </tr>
             <tr>
                <td>
                    Employer:</td><td colspan="3"><select id="cboEmployer"><option value="" selected>(SELECT EMPLOYER)</option></select>
                </td>
             <tr>
                <td>Search By:</td><td><select id="cboSearchBy" onchange="ShowSearchParams()" onclick="ShowSearchParams()">
                                            <option value="fosaaccount">AccountNo</option>
                                            <option value="memberno" selected>MemberNo</option>
                                            <option value="idnumber">IDNo</option>
                                            <option value="payrollno">PayrollNo</option>
                                       </select>
                </td>
            </tr>
            <tr>
                <td><div id="divSearchDisplay">Search Value</div></td><td><input type="text" id="txtSearchValue" /></td>
                <td>&nbsp;</td><td><input type="button" id="btnGetMember"  value="Get Member"/></td>
            </tr>
            
            
            <tr><td colspan="4"><b>Account Info</b></td></tr>
            <tr><td colspan="4"><div id="divAccountInfo"></div></td></tr>
            
            <tr>
                <td>
                    Loan Serial No:
                </td>
                <td colspan="3">
                    <div id="divLoanSerialNumber"></div>
                </td>
            </tr>
            <tr>
                <td>
                    Loan Status:
                </td>
                <td colspan="3">
                    <div id="divLoanStatus"></div>
                </td>
            </tr>
            <tr>
                <td>
                    Loan Type
                </td>
                <td colspan="3">
                    <select id="cboLoanType" name="cboLoanType"><option value="">(SELECT LOAN TYPE)</option></select>
                </td>
            </tr>
            <tr>
                <td>
                    Loan Amount
                </td>
                <td>
                    <input type="text" id="txtLoanAmount" name="txtLoanAmount" />
                </td>
                <td>
                    Repayment Period
                </td>
                <td>
                    <input type="text" id="txtRepaymentPeriod" name="txtRepaymentPeriod" />
                </td>
            </tr>
            <tr>
                <td>
                    Credit Account
                </td>
                <td colspan="3">
                    <select id="cboCreditAccount" name="cboCreditAccount"><option value="">(SELECT CREDIT A/C)</option></select>
                </td>
            </tr>
            <tr>
                <td>
                    Purpose for Loan
                </td>
                <td>
                    <textarea id="txtLoanPurpose" name="txtLoanPurpose" ></textarea>
                </td>
                <td>
                    Appraisal Date
                </td>
                <td>
                    <input type="text" id="txtLoanDate" name="txtLoanDate"  />
                </td>
            </tr>
            <tr>
                <td>
                    Instructions
                </td>
                <td>
                    <textarea id="txtInstructions" name="txtInstructions" ></textarea>
                </td>
                <td>
                    
                </td>
                <td>
                    
                </td>
            </tr>
            </table>
        </div>
        <div id="tabs-2">
                <%--<p><b>Capture Incomes</b></p>
                <div id="divSalaryIncomes"></div>
                <p><b>Capture Deductions</b></p>
                <div id="divSalaryDeductions"></div>--%>
            <table class="table table-bordered">
                <tr><td colspan="3"><b>Capture Incomes</b></td><td colspan="3"><b>Capture Deductions</b></td></tr>
                <tr><td colspan="3"><div id="divSalaryIncomes"  style="height:250px;overflow:auto;width:auto"></div></td><td colspan="3"><div id="divSalaryDeductions"  style="height:250px;overflow:auto;width:auto;"></div></td></tr>
            </table>
        </div>
        <div id="tabs-3">
            <table class="table table-bordered">
            <tr>
                <td colspan="4"><b>Capture Guarantors</b></td>
            </tr>
            <tr>
                <td>Employer:</td><td colspan="3">
                    <select id="cboGuarantorEmpCode">
                        <option value="" selected>(SELECT EMPLOYER)</option>
                    </select>
                </td>
            </tr>
            <tr><td>Search By:</td><td><select id="cboGuarantorSearchBy">
                                            <option value="fosaaccountno">AccountNo</option>
                                            <option value="memberno" selected>MemberNo</option>
                                            <option value="idnumber">IDNo</option>
                                            <option value="payrollno">PayrollNo</option>
                                       </select>
                </td>
                
            </tr>
            <tr>
                <td><div id="divGuarantorSearchBy">Search Value</div></td><td><input type="text" id="txtGuarantorSearchValue" /></td>
            </tr>
             <tr>
                <td>Amount Guaranteed<td><input type="text" id="txtGuaranteedAmount" /></td>
            </tr>
            <tr><td>&nbsp;</td><td><input type="button" name="btnAddGuarantor" id="btnAddGuarantor" value="Add Guarantor"/></td><td>&nbsp;</td><td><input type="button" name="btnDeleteGuarantor" id="btnDeleteGuarantor" value="Delete Guarantor"/></td></tr>
           </table>
            <div id="div1" style="height:250px;overflow:auto;width:1200px;">
                Guarantors
                <table id='tblGuarantors'  class="table table-bordered">
                        <thead>
                            <tr>
                                <th><b>G.Names</b></th>
                                <th><b>G.EmpCode</b></th>
                                <th><b>G.PayrollNo</b></th>
                                <th><b>G.MemberNo</b></th>
                                <th><b>G.Deposits</b></th>
                                <th><b>G.Amount</b></th>
                            </tr>
                        </thead>
                        <tbody id='bdGuarantors'>
                        </tbody>
                    <tfoot>
                        <tr>
                            <td></td><td></td><td></td><td></td><td></td><td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
        <div id="tabs-4">
                
        </div>
        <div id="tabs-5">
                
        </div>
        <div id="tabs-6">
            
            <div id="divOffsets" style="height:250px;overflow:auto;width:1200px;">
                Offsets
                <table id='tblOffsets'  class="table table-bordered">
                        <thead>
                            <tr>
                                <th><b>Type</b></th>
                                <th><b>Code</b></th>
                                <th><b>Name</b></th>
                                <th><b>Balance</b></th>
                                <th><b>Offset</b></th>
                            </tr>
                        </thead>
                        <tbody id='bdOffsets'>
                        </tbody>
                    <tfoot>
                        <tr>
                            <td></td><td></td><td></td><td></td><td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
                
        </div>
        <div id="tabs-7">
            <div id="divBalances" style="height:250px;overflow:auto;width:1200px;">
                Member Balances
                <table id='tblBalances'  class="table table-bordered">
                        <thead>
                            <tr>
                                <th><b>Type</b></th>
                                <th><b>Code</b></th>
                                <th><b>Name</b></th>
                                <th><b>Balance</b></th>
                                
                            </tr>
                        </thead>
                        <tbody id='bdBalances'>
                        </tbody>
                    <tfoot>
                        <tr>
                            <td></td><td></td><td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
                
        </div>
        <div id="tabs-8">
            <p><b>Process Loan</b></p>
                <div id="divProcessLoan"></div>
            <table class="table table-bordered">
                <tbody>
                    <tr>
                        <td>
                            Recomended Amount
                        </td>
                        <td>
                            <input type="text" id="txtRecomendedAmount" readonly="readonly" />
                        </td>
                        <td>
                            Repayment Period
                        </td>
                        <td>
                            <input type="text" id="txtRecomendedRepaymentPeriod" readonly="readonly" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Installment Amount
                        </td>
                        <td>
                            <input type="text" id="txtRecomendedInstallmentAmount" readonly="readonly" />
                        </td>
                        <td>
                            Income Fractionized
                        </td>
                        <td>
                            <input type="text" id="txtIncomeFractionized" readonly="readonly" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Payslip Deductions
                        </td>
                        <td>
                            <input type="text" id="txtPayslipDeductions" readonly="readonly" />
                        </td>
                        <td>
                            Deposits Multiplied
                        </td>
                        <td>
                            <input type="text" id="txtDepositsMultiplied" readonly="readonly" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Shares Eligibility
                        </td>
                        <td>
                            <input type="text" id="txtSharesEligibility" readonly="readonly" />
                        </td>
                        <td>
                            Salary Eligibility
                        </td>
                        <td>
                            <input type="text" id="txtSalaryEligibility" readonly="readonly" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Guarantors Eligibility
                        </td>
                        <td>
                            <input type="text" id="txtGuarantorsEligibility" readonly="readonly" />
                        </td>
                        <td>
                            Scheme Balance
                        </td>
                        <td>
                            <input type="text" id="txtSchemeBalance" readonly="readonly" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Start Year
                        </td>
                        <td>
                            <input type="text" id="txtStartYear" readonly="readonly" />
                        </td>
                        <td>
                            Start Month
                        </td>
                        <td>
                            <input type="text" id="txtStartMonth" readonly="readonly" /><input type="text" id="txtStartPeriod" readonly="readonly" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Reasons
                        </td>
                        <td colspan="3">
                            <%--<textarea id="txtReasons" readonly="readonly" />--%>
                            <textarea id="txtReasons" readonly="readonly" ></textarea>
                        </td>
                        
                    </tr>
                    <tr>
                        <td colspan="4">
                            <input type="button" id="btnSaveAppraisal" name="btnSaveAppraisal" value="Save Appraisal" class="btn btn-success"/>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        
    </form>
        <input type="button" id="btnNewAppraisal" name="btnNewAppraisal" value="New Appraisal"/>
        <input type="button" id="btnCancelAppraisal" name="btnCancelAppraisal" value="Cancel Appraisal" />
        <input type="button" id="btnProcessAppraisal" name="btnProcessAppraisal" value="Process Appraisal" />
        
    </div>
    
</asp:Content>


