﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<XtremeERP.Common.Data.GeneralReportsParams>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    General Reports
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
    <h3>General Reports</h3>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
<style  type="text/css">
  input {
  width: 100%;
  padding: 1px 1px;
  margin: 1px 0;
  box-sizing: border-box;
}
  * {
  box-sizing: border-box;
}
  body {
  font-family: Arial, sans-serif;
  font-size:12px;
}
</style>
    <div id="tabs">
        <ul>
            <li><a href="#tabs-1">Report Selection</a></li>
        </ul>
        <form class="form-inline" id="frmGeneralReports" method="post" action="<%: Url.Content("~/BankSystem/GetGeneralReport") %>">

            <%= Html.AntiForgeryToken() %>

            <h3>Select Report</h3>
            <hr style="color: green" />

            <div class="form-row">
                <div class="form-group">
                    <label for="ReportType">Report Type:</label>
                    <%:  Html.DropDownListFor(model => model.ReportType, ViewBag.select_report_type as List<SelectListItem>, new { id = "ReportType", name = "ReportType", @class="form-control  input-sm" }) %>
                </div>
                <div class="form-group">
                    <label for="ReportFormat">Report Format:</label>
                    <%:  Html.DropDownListFor(model => model.ReportFormat, ViewBag.select_report_format as List<SelectListItem>, new { id = "ReportFormat", name = "ReportFormat", @class="form-control  input-sm" }) %>
                </div>
                <div class="form-group">
                    <label for="ReportYear">Year:</label>
                    <%:  Html.DropDownListFor(model => model.FinancialYear, ViewBag.select_financialyears_Items as SelectList, new { id = "FinancialYear", name = "FinancialYear", @class="form-control  input-sm" }) %>
                </div>
                <div class="form-group">
                    <label for="ReportPeriod">Period:</label>
                    <%:  Html.DropDownListFor(model => model.FinancialPeriod, ViewBag.select_financialperiods_Items as SelectList, new { id = "FinancialPeriod", name = "FinancialPeriod", @class="form-control  input-sm" }) %>
                </div>
            </div>
            <br />
            <br />
            <div class="form-row">
                <div class="form-group">
                    <label for="Employer">Employer:</label>
                    <%:  Html.DropDownListFor(model => model.Employer, ViewBag.select_employers_Items as SelectList, new { id = "Employer", name = "Employer"  , @class="form-control  input-sm"}) %>
                </div>
                <div class="form-group">
                    <label for="Branch">Branch:</label>
                    <%:  Html.DropDownListFor(model => model.Branch, ViewBag.select_branches_Items as SelectList, new { id = "Branch", name = "Branch"  , @class="form-control  input-sm"}) %>
                </div>
                <div class="form-group">
                    <label for="LoanType">Loan Type:</label>
                    <%:  Html.DropDownListFor(model => model.LoanType, ViewBag.select_loantypes_Items as SelectList, new { id = "LoanType", name = "LoanType"  , @class="form-control  input-sm"}) %>
                </div>
                <div class="form-group">
                    <label for="SchemeType">Scheme Type:</label>
                    <%:  Html.DropDownListFor(model => model.SchemeType, ViewBag.select_schemes_Items as SelectList, new { id = "SchemeType", name = "SchemeType" , @class="form-control  input-sm"}) %>
                </div>
                
            </div>
            <br />
            <br />
            <div class="form-row">
                <div class="form-group">
                    <label for="FosaAccountType">A/C Type:</label>
                    <%:  Html.DropDownListFor(model => model.FosaAccountType, ViewBag.select_typesofmembersaccounts_Items as SelectList, new { id = "FosaAccountType", name = "FosaAccountType"  , @class="form-control  input-sm"}) %>
                </div>
                <div class="form-group">
                    <label for="MemberType">Member Type:</label>
                    <%:  Html.DropDownListFor(model => model.MemberType, ViewBag.select_membertypes_Items as SelectList, new { id = "MemberType", name = "MemberType"  , @class="form-control  input-sm"}) %>
                </div>
                <div class="form-group">
                    <label for="MemberStatus">Member Status:</label>
                    <%:  Html.DropDownListFor(model => model.MemberStatus, ViewBag.select_memberstatus_Items as SelectList, new { id = "MemberStatus", name = "MemberStatus"  , @class="form-control  input-sm"}) %>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="BalCriteria">Balance:</label>
                    <select id="BalCriteria" class="form-control">
                        <option value='all' selected>All</option>
                        <option value="lessthan">Less Than</option>
                        <option value="morethan">More Than</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="txtBalCriteria">Balance:</label>
                    <input type="number" id="txtBalCriteria" class="form-control"/>
                </div>
                <div class="form-group">
                    <label for="SortBy">Sort By:</label>
                    <%:  Html.DropDownListFor(model => model.SortBy, ViewBag.select_report_sort  as List<SelectListItem>, new { id = "SortBy", name = "SortBy" ,  @class="form-control  input-sm"}) %>
                </div>
                <div class="form-group">
                    <label for="GroupLoansBy">Group Loans By:</label>
                    <%:  Html.DropDownListFor(model => model.GroupLoansBy, ViewBag.select_report_grouploansby  as List<SelectListItem>, new { id = "GroupLoansBy", name = "GroupLoansBy" , @class="form-control  input-sm"}) %>
                </div>

            </div>
            <br />
            <div class="form-row">
                <div class="form-group">
                    <input type="submit" value="Get Report" id="btnGetReport" name="btnGetReport" class="btn btn-success" />
                </div>
            </div>


        </form>
    </div>
</asp:Content>



<asp:Content ID="Content4" ContentPlaceHolderID="ScriptsSection" runat="server">
    <script type="text/javascript">
        $(document).ready(function () {
            $("#FinancialPeriod").addClass("form-control");
            $("#FinancialYear").addClass("form-control");
            $("#ReportType").addClass("form-control");
            $("#ReportFormat").addClass("form-control");
            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
</asp:Content>

