﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<!DOCTYPE html>

<html>
    <head runat="server">
    <meta name="viewport" content="width=device-width" />
    <title>View/Edit GL Account</title>
        <%: Scripts.Render("~/bundles/jquery") %>
        <%: Scripts.Render("~/bundles/jqueryui") %>
        <%: Scripts.Render("~/bundles/modernizr") %>
        <%: Scripts.Render("~/bundles/CryptoJS") %>
        <%: Scripts.Render("~/bundles/form2js") %>
        <%: Scripts.Render("~/bundles/printThis") %>
        <%: Scripts.Render("~/bundles/jquerymaskedinput") %>
        <%: Scripts.Render("~/bundles/jquery_dataTables") %>
        <%: Scripts.Render("~/bundles/Q") %>
        <%: Scripts.Render("~/bundles/CustomUtils") %>
        <%: Scripts.Render("~/bundles/toWords") %>

        <%: Styles.Render("~/Content/site") %>
        <%: Styles.Render("~/Content/style") %>
        <%: Styles.Render("~/Content/jquery_dataTables_min") %>
        <%: Styles.Render("~/Content/smoothness") %>
        <%: Styles.Render("~/Content/jqrejectcss") %>
        <%: Styles.Render("~/Content/jquery_dataTables_themeroller_min") %>
        <%: Styles.Render("~/Content/themes/base/css") %>
        

</head>
    <body>
    <h3>View/Edit GL Account</h3>
    <div>
        <form id="frmMain" name="frmMain">
            <%= Html.AntiForgeryToken() %>
            <table>
                <tr>
                    <td>Account No:</td>
                    <td>
                        <input type="text" id="txtAccountNo" disabled/>
                    </td>
                    <td>Account Name:</td>
                    <td>
                        <input type="text" id="txtAccountName" disabled />
                    </td>
                    <td>Mem Effect:</td>
                    <td>
                        <input type="text" id="txtMemEffect" disabled/>
                    </td>
                </tr>
                <tr>
                    <td>Active:</td>
                    <td>
                        <input type="text" id="txtActive" disabled/>
                    </td>
                    <td>Transacting:</td>
                    <td>
                        <input type="text" id="txtTransacting" disabled />
                    </td>
                    <td>Short Code:</td>
                    <td>
                        <input type="text" id="txtAccountCode" disabled/>
                    </td>
                </tr>
                <tr>
                    <td>Created By:</td>
                    <td>
                        <input type="text" id="txtCreatedBy" disabled/>
                    </td>
                    <td>Date Created:</td>
                    <td>
                        <input type="text" id="txtDateCreated" disabled />
                    </td>
                    <td>Activity:</td>
                    <td>
                        
                    </td>
                </tr>
            </table>
            <br />
            <br />
            <table id="tblNewAccDetails" class="table table-responsive">
                <caption>Enter New Account Details</caption>
                <tr>
                    <td>Account No:</td>
                    <td>
                        <input type="text" id="txtNewAccountNo" />
                    </td>
                    <td>Account Name:</td>
                    <td>
                        <input type="text" id="txtNewAccountName"  />
                    </td>
                    <td>Mem Effect:</td>
                    <td>
                        <select id="cboNewMemEffect">
                            <option value="NON" selected>(NON)</option>
                            <option value="SHARES">SHARES</option>
                            <option value="LOANS">LOANS</option>
                            <option value="INTEREST">INTEREST</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>Active:</td>
                    <td>
                        <select id="cboActive">
                            <option selected value="YES">YES</option>
                            <option value="NO">NO</option>
                        </select>
                    </td>
                    <td>Transacting:</td>
                    <td>
                        <select id="cboTransacting">
                            <option selected value="YES">YES</option>
                            <option value="NO">NO</option>
                        </select>
                    </td>
                    <td>Short Code:</td>
                    <td>
                        <input type="text" id="txtNewAccountCode"/>
                    </td>
                    
                </tr>
                <tr>
                    <td></td>
                    <td>
                        <input type="button" id="btnSave" value="Save Changes" />
                    </td>
                    <td></td>
                    <td>
                    </td>
                    <td></td>
                    <td>
                        <input type="button" id="btnClose" value="Close" />
                    </td>
                    
                </tr>
            </table>
            
        </form>
    </div>
</body>
<script type="text/javascript">

    $(document).ready(function () {
        var EditAccountNo = "<% =ViewData["AccountNo"] %>";
            var EditAccountDetails = Object(<% = Json.Encode(ViewData["AccountDetails"] as XtremeERP.Common.Data.Account) %>);
            var SaccoSettings = Object(<% = Json.Encode(ViewData["SaccoSettings"] as XtremeERP.Common.Data.SaccoSettings) %>);
        $("#txtAccountNo").mask(SaccoSettings.AccountFormat);
        $("#txtNewAccountNo").mask(SaccoSettings.AccountFormat);

        DispAccDetails(EditAccountDetails);

        function DispAccDetails(data) {
            $("#txtAccountNo").val(data.UserCode);
            $("#txtAccountName").val(data.AccountName);
            $("#txtMemEffect").val(data.MemEffect);

            $("#txtActive").val(data.Active);
            $("#txtTransacting").val(data.Transacting);
            $("#txtAccountCode").val(data.AccountShortCode);

            $("#txtCreatedBy").val(data.Clerk);
            $("#txtDateCreated").val(data.CreationDate);
            
            $("#txtNewAccountNo").val(data.UserCode);
            $("#txtNewAccountName").val(data.AccountName);
            $("#cboNewMemEffect").val(EditAccountDetails.MemEffect);

            $("#cboActive").prop('selectedIndex', 0);
            $("#cboTransacting").prop('selectedIndex', 0);
            if (!data.Active) {
                $("#cboActive").prop('selectedIndex', 1);
            }
            if (!data.Transacting) {
                $("#cboTransacting").prop('selectedIndex', 1);
            }

            $("#txtNewAccountCode").val(data.AccountShortCode);

        }

            $("#btnClose").on('click', function (e) {
                //window.parent.CloseDialog();
                //$('.ui-widget-overlay , .ui-dialog', window.parent.document).remove();
                window.parent.$('#divEdit').dialog('close');
            });

            $("#btnSave").on('click', function (e) {
                //xDialogGetUserCredetials().then(function (data) { //not loading corectly, maybe coz of iframe
                xDialogMemberCredetials().then(function (data) {
                    //var UserName = data.UserName;
                    var Password = data.UserPass;
                    var pwdslt = getRandomInt(1000, 30000);
                    pwdslt = pwdslt.toString();
                    var pwd = CryptoJS.MD5(Password).toString();
                    pwd = pwd + pwdslt;
                    var sltpwd = CryptoJS.MD5(pwd).toString();

                    var outData = {
                        'EditAccountNo': $("#txtAccountNo").val(),
                        'NewAccountNo': $("#txtNewAccountNo").val(),
                        'NewAccountName': $("#txtNewAccountName").val(),
                        'NewAccountCode': $("#txtNewAccountCode").val(),
                        'NewTransacting': $("#cboTransacting").val(),
                        'NewActive': $("#cboActive").val(),
                        'NewMemEffect': $("#cboNewMemEffect").val(),
                        //'UserName': UserName,
                        'UserPass': sltpwd,
                        'Salt': pwdslt,
                    }
                    outData = JSON.stringify(outData);
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/EditGlAccount") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            alert("Changes Updated");
                            DispAccDetails(response);
                            
                            /*
                             * uncomment this to send data back to parent window
                            $("#txtReceived", parent.document.body).val(response.UserCode);
                            */
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            });

        });
</script>
</html>
