﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Cheque Deposits
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .tblDRCRDetails {
             margin: 1px;
             border: 1em;
             padding-left:1em;
             padding-top:1em;
             border-collapse:separate;
         }
         
         /*use this for to calculate totals*/  
         .colamount {
            text-align:right;
         }
         tr.row_selected td{background-color:lawngreen;}
   </style>

    
    <script type="text/javascript"  >
        $(document).ready(function () {
                ClearInputs();
                $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    e.preventDefault();
                });
                $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    $(this).select();
                });
                $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    $(this).addClass("textfocused");
                });
                $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    $(this).removeClass("textfocused");
                });

                $("#txtAmount").on('change keyup paste mouseup', function () {
                    $("#divAmountInWords").html("");
                    try {
                        $("#divAmountInWords").html(toWords($("#txtAmount").val()));
                    } catch (err) {

                    }
                });
                $("#txtAccountNo").on('focusout', function () {
                    strAccountName = "";
                    strAccountCode = "";
                    $("#divAccountDetails").empty();
                    $("#divAccName").empty();
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/GetTellerTransactingAccountDetails") %>",
                            data: JSON.stringify({ 'TransactingAccount': $("#txtAccountNo").val() }),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                if (response.IsCustomerAccount == true) {
                                    var MemAcc = response.detailedCustomerAccount.MemberAcc;
                                    strAccountName = MemAcc.AccountName;
                                    strAccountCode = MemAcc.AccountNo;
                                    var strAccDetails = "<table>";
                                    strAccDetails += "<tr><td>Account Name</td><td>" + MemAcc.AccountName + "</td></tr>";
                                    strAccDetails += "<tr><td>Account No</td><td>" + MemAcc.AccountNo + "</td></tr>";
                                    strAccDetails += "<tr><td>Acc Type</td><td>" + MemAcc.AccountType + "</td></tr>";
                                    strAccDetails += "<tr><td>Available Balance</td><td>" + response.detailedCustomerAccount.AvailableBalance.formatMoney() + "</td></tr>";
                                    strAccDetails += "<tr><td>Actual Balance</td><td>" + response.detailedCustomerAccount.LedgerBalance.formatMoney() + "</td></tr>";
                                    strAccDetails += "<tr><td>Type Name</td><td>" + MemAcc.AccountTypeName + "</td></tr>";
                                    strAccDetails += "<tr><td>File No</td><td>" + MemAcc.FileNo + "</td></tr>";
                                    strAccDetails += "<tr><td>Last Deposit Date</td><td>" + MemAcc.DateOfLastDeposit + "</td></tr>";
                                    strAccDetails += "<tr><td>Last Withdrawal Date</td><td>" + MemAcc.DateOfLastWithdrawal + "</td></tr>";
                                    strAccDetails += "<tr><td>Date Openned</td><td>" + MemAcc.OpenningDate + "</td></tr>";
                                    strAccDetails += "<tr><td>Branch</td><td>" + MemAcc.BranchName + "</td></tr>";
                                    strAccDetails += "<tr><td>Status</td><td>" + MemAcc.Status + "</td></tr>";
                                    strAccDetails += "<tr><td>Instructions</td><td>" + MemAcc.Instructions + "</td></tr>";

                                    var acc_members = response.detailedCustomerAccount.AccountMembers;
                                    $.each(acc_members, function (index, acc_member) {
                                        strAccDetails += "<tr><td>EmpCode</td><td>" + acc_member.EmployerCode + "</td></tr>";
                                        strAccDetails += "<tr><td>PayrollNo</td><td>" + acc_member.PayrollNo + "</td></tr>";
                                        strAccDetails += "<tr><td>MemberNo</td><td>" + acc_member.MemberNo + "</td></tr>";
                                        strAccDetails += "<tr><td>IDNumber</td><td>" + acc_member.IDNumber + "</td></tr>";
                                        strAccDetails += "<tr><td>FullNames</td><td>" + acc_member.FullNames + "</td></tr>";
                                    });
                                    strAccDetails += "</table>";

                                    $("#divAccountDetails").html(strAccDetails);

                                    //LoadImageFromUrl(response.detailedCustomerAccount.PhotoPath, 180, 180, $("#divMemberPhoto"));
                                    //LoadImageFromUrl(response.detailedCustomerAccount.SignaturePath, 180, 180, $("#divMemberSignature"));
                                } else {
                                    strAccountName = response.otherAccountDetails.AccountName;
                                    strAccountCode = response.otherAccountDetails.UserCode;
                                    var strAccDetails = "Account Name : " + response.otherAccountDetails.AccountName + "</br>";
                                    strAccDetails += "Account No : " + response.otherAccountDetails.UserCode + "</br>";
                                    strAccDetails += "Acc Type : " + "Non-Customer Account" + "</br>";
                                    $("#divAccountDetails").html(strAccDetails);
                                }
                                $("#divAccName").append("<b>" + strAccountName + "</b>");
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
                });

                $("#cboYear").empty();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetChequeDepositsModuleConfig") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var years = response.Years;
                        var chequedeposittypes = response.ChequeDepositsTypes;
                        var saccobranches = response.Branches;
                        var banks = response.Banks;
                        var clearingbanks = response.ClearingBanks

                        SaccoSettings = response.SaccoSettings;
                        var obj = document.getElementById("cboYear");
                        $.each(years, function (index, yrs) {
                            var opt = document.createElement("option");
                            opt.value = yrs.DBName;
                            opt.text = yrs.UserDefinedYearName;
                            opt.selected = true;
                            obj.appendChild(opt);
                        });
                        $("#cboYear").get(0).selectedIndex = 0;
                        var obj = document.getElementById("cboBank");
                        var opt = document.createElement("option");
                        opt.value = "";
                        opt.text = "(SELECT)";
                        obj.appendChild(opt);
                        $.each(banks, function (index, bank) {
                            var opt = document.createElement("option");
                            opt.value = bank.MainBankCode;
                            opt.text = bank.MainBankName;
                            obj.appendChild(opt);
                        });
                        var obj = document.getElementById("cboClearingBankAcc");
                        var opt = document.createElement("option");
                        opt.value = "";
                        opt.text = "(SELECT)";
                        obj.appendChild(opt);
                        $.each(clearingbanks, function (index, clearingbank) {
                            var opt = document.createElement("option");
                            opt.value = clearingbank.UserCode;
                            opt.text = clearingbank.AccountName;
                            obj.appendChild(opt);
                        });
                        var obj = document.getElementById("cboBranch");
                        $.each(saccobranches, function (index, saccobranch) {
                            var opt = document.createElement("option");
                            opt.value = saccobranch.BranchCode;
                            opt.text = saccobranch.BranchName + "(" + saccobranch.BranchCode + ")";
                            obj.appendChild(opt);
                        });
                        var obj = document.getElementById("cboChequeDepositType");
                        var opt = document.createElement("option");
                        opt.value = "";
                        opt.text = "(SELECT TYPE)";
                        obj.appendChild(opt);
                        $.each(chequedeposittypes, function (index, chequedeposittype) {
                            var opt = document.createElement("option");
                            opt.value = chequedeposittype.ChequeCode;
                            opt.text = chequedeposittype.ChequeName;
                            obj.appendChild(opt);
                        });
                        LoadFinancialPeriods();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

                $('#tabs').on('tabsactivate', function (event, ui) {
                    var newIndex = ui.newTab.index();
                    if (newIndex == 1) {
                        GetCustomerChequeDepositsReport();
                    }
                });

                
                $("#btnPrint").on('click', function () {
                    var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "Customer Cheque Deposits Report";
                    $("#divChequeDepositsList").printThis({
                        debug: false,
                        pageTitle: "Report",
                        removeInline: true,
                        printContainer: true,
                        importCSS: true,
                        header: rptHeader
                    });

                });

                /*
                $("#tblChequeDepositsList").dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                */

                $("#cboYear").on('change', function () {
                    LoadFinancialPeriods()
                });
                $("#cboPeriod").on('change', function () {
                    GetCustomerChequeDepositsReport();
                });
                $("#cboChequeStatus").on('change', function () {
                    GetCustomerChequeDepositsReport();
                });
                $("#cboBranch").on('change', function () {
                    GetCustomerChequeDepositsReport();
                });
                $("#btnRefresh").on('click', function () {
                    GetCustomerChequeDepositsReport();
                });
                $("#btnClearEntries").on('click', function () {
                    ClearInputs();
                });
                $("#cboChequeDepositType").on('change', function () {
                    ProcessChequeClearanceDate();
                });
                $("#btnReValue").on('click', function () {
                    var selected_count = 0;
                    var ReValueEntry = {};
                    $("#bdChequeDepositsList").find('tr').each(function (i) {
                        var row = $(this); //store in variable for faster access
                        var chkbox = row.find('td:eq(0)').find('input:eq(0)');
                        var chequeno = row.find('td:eq(3)').text();
                        var transnum = row.find('td:eq(4)').text();
                        var accno = row.find('td:eq(5)').text();
                        
                        if ($(chkbox).prop("checked")) {
                            ReValueEntry.ChequeNum = chequeno;
                            ReValueEntry.AccountNumber = accno;
                            ReValueEntry.TransactionNum = transnum;
                            selected_count++;
                        }
                    });
                    if (selected_count == 0) { alert("Select Cheque to Revalue"); return; }
                    if (selected_count > 1) { alert("Select only one Cheque to Revalue"); return; }
                    var tbl_revalue = "<table><tr><td>Cheque No:</td><td>" + ReValueEntry.ChequeNum + "</td></tr><tr><td>Account No:</td><td>" + ReValueEntry.AccountNumber + "</td></tr><tr><td>Trans No:</td><td>" + ReValueEntry.TransactionNum + "</td></tr><tr><td>New Value Date:</td><td><input type='text' id='txtRevalueDate' /></td></tr><tr><td>Revaluation Reason:</td><td><input type='text' id='txtRevalueReason' /></td></tr></table>";
                    $('<div title="Revalue Cheque">Revalue Cheque</div>').dialog({
                        modal: true,
                        height: 300,
                        width: 400,
                        autoOpen: true,
                        show: {
                            effect: "drop",
                            direction: "up",
                            duration: 500
                        },
                        buttons: [{
                            text: "Revalue",
                            click: function () {
                                ReValueEntry.ValDate = $(this).find("#txtRevalueDate").val();
                                ReValueEntry.ReValueReason = $(this).find("#txtRevalueReason").val();
                                $(this).dialog("close");
                                RevalueChequeDate(ReValueEntry);
                            }
                        }, {
                            text: "Cancel",
                            click: function () {
                                $(this).dialog("close");
                            }
                        }],
                        close: function (event, ui) {
                            // Destroy the jQuery UI dialog and remove it from the DOM
                            $(this).dialog("destroy").remove();
                        }
                    }).append(tbl_revalue).find("#txtRevalueDate").datepicker({ dateFormat: 'dd/mm/yy' });
                });
                $("#btnClearCheque").on('click', function () {
                    xDialogConfirm("Clear Selected Cheques?", "Confirm").then(function () {
                        xDialogGetUserCredetials().then(function (data) {
                            ProcessCheques(data, "CLEAR");
                        });
                    });
                });
                $("#btnCancelCheque").on('click', function () {
                    xDialogConfirm("Cancel Selected Cheques?", "Confirm").then(function () {
                        xDialogGetUserCredetials().then(function (data) {
                            ProcessCheques(data, "CANCEL");
                        });
                    });
                });
                $("#btnBounceCheque").on('click', function () {
                    xDialogConfirm("Bounce Selected Cheques?", "Confirm").then(function () {
                        xDialogGetUserCredetials().then(function (data) {
                            ProcessCheques(data,"BOUNCE");
                        });
                    });
                });
                $("#txtAccountNo").mask(AccountMask);

                $("#btnSaveChequeDeposit").on('click', function () {
                    if (document.getElementById("cboChequeDepositType").selectedIndex == 0) {
                        alert("Select Cheque Type");
                        return;
                    }
                    if (document.getElementById("cboClearingBankAcc").selectedIndex == 0) {
                        alert("Select Clearing Bank");
                        return;
                    }
                    if (document.getElementById("cboBank").selectedIndex == 0) {
                        alert("Select Drawer Bank");
                        return;
                    }
                    if (strAccountCode == "") {
                        alert("Invalid Account");
                        return;
                    }
                    if (!isNumber($("#txtAmount").val())) {
                        alert("Invalid Amount");
                        return;
                    }
                    xDialogConfirm("Cheque Deposit Amount=" + $("#txtAmount").val() + "<br/>Account No " + $("#txtAccountNo").val() + "<br/>Post Cheque Deposit?", "Confirm").then(function () {
                        xDialogGetUserCredetials().then(function (data) {
                            SaveCustomerChequeDeposit(data);
                        });
                    });
                });

        function RevalueChequeDate(chequedetails) {
            xDialogGetUserCredetials().then(function (credentials) {
                var UserName = credentials.UserName;
                var Password = credentials.UserPass;
                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var outData = {
                    'PeriodCode': $("#cboPeriod").val(),
                    'DBName': $("#cboYear").val(),
                    'UserName': UserName,
                    'Password': sltpwd,
                    'Salt': pwdslt,
                    'ChequeDetails': chequedetails
                }
                outData = JSON.stringify(outData);
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/RevalueChequeDate") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        //alert(response);
                        GetCustomerChequeDepositsReport();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });
        }
        function ProcessChequeClearanceDate() {
            $("#divValueDate").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            var outData = {
                'ChequeTypeCode': $("#cboChequeDepositType").val()
            }
            
            outData = JSON.stringify(outData);
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/ProcessChequeClearanceDate") %>",
                data: outData,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    $("#divValueDate").html(response);
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }

            });
        }
        function ProcessCheques(credentials,action_type) {
            var PostEntries = new Array();
            var selected_count = 0;
            $("#bdChequeDepositsList").find('tr').each(function (i) {
                var PostEntry = {};
                
                var row = $(this); //store in variable for faster access
                var chkbox = row.find('td:eq(0)').find('input:eq(0)');
                var chequeno = row.find('td:eq(3)').text();
                var transnum = row.find('td:eq(4)').text();
                var accno = row.find('td:eq(5)').text();
                //if (chkbox.checked)
                //if ($(chkbox).prop("checked"))
                //if ($(chkbox).is(":checked"))
                if ($(chkbox).prop("checked")) {
                    PostEntry.ChequeNum = chequeno;
                    PostEntry.AccountNumber = accno;
                    PostEntry.TransactionNum = transnum;
                    PostEntries[selected_count] = PostEntry;
                    selected_count++;
                }
            });
                var UserName = credentials.UserName;
                var Password = credentials.UserPass;
                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var outData = {
                    'PeriodCode': $("#cboPeriod").val(),
                    'DBName': $("#cboYear").val(),
                    'UserName': UserName,
                    'Password': sltpwd,
                    'Salt': pwdslt,
                    'ChequeList': PostEntries,
                    'ActionType': action_type
                }
                outData = JSON.stringify(outData);
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/ProcessChequeDeposits") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        alert("Operation completed successfuly. Cheque Action: " + action_type);
                        GetCustomerChequeDepositsReport();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
        }
        function GetCustomerChequeDepositsReport() {
            $("#tblChequeDepositsList > tbody:last").children().remove();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            var outData = {
                'DBName': $("#cboYear").val(),
                'PeriodCode': $("#cboPeriod").val(),
                'BranchCode': $("#cboBranch").val(),
                'ChequeStatus': $("#cboChequeStatus").val()
            }
            outData = JSON.stringify(outData);
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetCustomerChequeDepositsReport") %>",
                data: outData,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    $("#tblChequeDepositsList > tbody:last").children().remove();
                    var row_datas = response;
                    var tbl_row = "";
                    $.each(row_datas, function (index, row_data) {
                        tbl_row += "<tr>";
                        tbl_row += "<td><input type='checkbox'/></td>";
                        tbl_row += "<td>" + row_data.ChequeStatusType + "</td>";
                        tbl_row += "<td>" + row_data.BatchDate + "</td>";
                        tbl_row += "<td>" + row_data.ChequeNum + "</td>";
                        tbl_row += "<td>" + row_data.TransactionNum + "</td>";
                        tbl_row += "<td>" + row_data.AccountNumber + "</td>";
                        tbl_row += "<td>" + row_data.CreditAccountName + "</td>";
                        tbl_row += "<td>" + row_data.Amount.formatMoney() + "</td>";
                        tbl_row += "<td>" + row_data.ValDate + "</td>";
                        tbl_row += "<td>" + row_data.MainBankName + "</td>";
                        tbl_row += "<td>" + row_data.DocNumber + "</td>";
                        tbl_row += "<td>" + row_data.TellerName + "</td>";
                        if (row_data.IsMatured==true) {
                            tbl_row += "<td>YES</td>";
                        } else {
                            tbl_row += "<td>NO</td>";
                        }
                        tbl_row += "</tr>";

                    });
                    $("#tblChequeDepositsList").append(tbl_row);
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }

            });
        }


        function SaveCustomerChequeDeposit(credetials) {

            var UserName = credetials.UserName;
            var Password = credetials.UserPass;
            var csrfToken = $("input[name='__RequestVerificationToken']").val();

            var pwdslt = getRandomInt(1000, 30000);
            pwdslt = pwdslt.toString();
            var pwd = CryptoJS.MD5(Password).toString();
            pwd = pwd + pwdslt;
            var sltpwd = CryptoJS.MD5(pwd).toString();
            

            var outData = {
                'AccountNo': $("#txtAccountNo").val(),
                'Amount': $("#txtAmount").val(),
                'ChequeCode': $("#cboChequeDepositType").val(),
                'ClearingBankAcc': $("#cboClearingBankAcc").val(),
                'BankCode': $("#cboBank").val(),
                'ChequeNo': $("#txtChequeNo").val(),
                'DocNo': $("#txtDocNo").val(),
                'Details': $("#txtDetails").val(),
                'UserName': UserName,
                'Password': sltpwd,
                'Salt': pwdslt
            }
            outData = JSON.stringify(outData);
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/SaveCustomerChequeDeposit") %>",
                data: outData,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    alert("Customer Cheque Deposit Saved");
                    ClearInputs();
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }

            });

        }

        function ClearInputs() {
            strAccountCode = "";
            strAccountName = "";
            $("#txtAccountNo").val("");
            $("#txtAmount").val("0.00");
            $("#txtChequeNo").val("");
            $("#divAccName").empty();
            $("#txtDocNo").val("");
            $("#txtDetails").val("");
            $("#divAmountInWords").empty();
            $("#divValueDate").empty();
            $("#divAccountDetails").empty();
            document.getElementById("cboBank").selectedIndex = 0;
            document.getElementById("cboChequeDepositType").selectedIndex = 0;
            document.getElementById("cboClearingBankAcc").selectedIndex = 0;
            
        }



        function LoadFinancialPeriods() {
            var dbname = $("#cboYear").val();
            if (dbname == null) { return; }


            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>",
                data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var fmonths = response;
                    var objPeriod = document.getElementById("cboPeriod");
                    $("#cboPeriod").empty();
                    $.each(fmonths, function (index, fmonth) {
                        var optn = "<option value='" + fmonth.MonthID + "'>" + fmonth.MonthName + "</option>";
                        $("#cboPeriod").append(optn);
                        if (fmonth.Status == "OPENED") {
                            objPeriod.selectedIndex = index
                        }

                    });
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });
        }
        $(function () {
            $("#tabs").tabs();
        });
        $(function () {
            $("#accordion").accordion({
                heightStyle: "content"
            });
        });
    });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
<h3>Cheque Deposits</h3>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <div id="tabs">
      <ul>
        <li><a href="#tabs-1">Cheque Deposits</a></li>
        <li><a href="#tabs-2">Reports</a></li>
      </ul>
        <form id="frmMain" name="frmMain">
            <%= Html.AntiForgeryToken() %>
            <div id="tabs-1">
                <table>
                    <tr>
                        <td>
                            Deposit Type:
                        </td>
                        <td>
                            <select id="cboDepositTransactionType" disabled><option selected>Customer Acc</option><option>Non-Customer Acc</option></select>
                        </td>
                        <td rowspan="7">
                            <div id="divAccountDetails" style="height:300px;overflow:auto;width:auto;">
                                Account Details
                                <hr />
                            </div>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            Cheque Type:
                        </td>
                        <td>
                            <select id="cboChequeDepositType"></select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Value Date:
                        </td>
                        <td>
                            <div id="divValueDate"></div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Account
                        </td>
                        <td><input type="text" id="txtAccountNo"/></td>
                    </tr>
                    <tr>
                        <td>
                            Account Name:
                        </td>
                        <td>
                            <div id="divAccName"></div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                        Cheque Amount:
                        </td>
                        <td>
                        <input type="text" id="txtAmount" />
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <div id="divAmountInWords"></div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                        Cheque Number:
                        </td>
                        <td>
                        <input type="text" id="txtChequeNo" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                        Drawer Bank:
                        </td>
                        <td>
                        <select id="cboBank"></select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                        Document Number:
                        </td>
                        <td>
                        <input type="text" id="txtDocNo" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                        Details:
                        </td>
                        <td>
                        <input type="text" id="txtDetails" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Clearing Bank A/C:
                        </td>
                        <td> 
                            <select id="cboClearingBankAcc">
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                        <input type="button" value="Clear Entries" id="btnClearEntries" />
                        </td>
                        <td>
                        <input type="button" value="Save Chq Deposit" id="btnSaveChequeDeposit" />
                        </td>
                    </tr>
                </table>
            </div>
            <div id="tabs-2">
                <table border="1" style="padding: 1px; margin: 1px;" id="tblPeriod">
                    <tr>
                        <td>Financial Year:</td><td><select id="cboYear"><option value="selectyear">SELECT YEAR</option></select></td>
                        <td>
                            Period:
                        </td>
                        <td> 
                            <select id="cboPeriod"><option value="selectperiod" selected>(SELECT PERIOD)</option></select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Branch:
                        </td>
                        <td> 
                            <select id="cboBranch"><option value="" selected>(ALL BRANCHES)</option></select>
                        </td>
                        <td>
                            Cheque Status:
                        </td>
                        <td> 
                            <select id="cboChequeStatus">
                                <option value="">(ALL CHEQUES)</option>
                                <option value="uncleared" selected>UNCLEARED</option>
                                <option value="cleared">CLEARED</option>
                                <option value="bounced">BOUNCED</option>
                                <option value="cancelled">CANCELLED</option>
                            </select>
                        </td>
                    </tr>
                </table>
                <table>
                    <tr>
                        <td><input type="button" id="btnRefresh" value="Refresh"/></td>
                        <td><input type="button" id="btnClearCheque" value="Clear Chq"/></td>
                        <td><input type="button" id="btnReValue" value="Re-Value"/></td>
                        <td><input type="button" id="btnPrintDoc" value="Print Doc"/></td>
                        <td><input type="button" id="btnPrintList" value="Print List"/></td>
                        <td><input type="button" id="btnBounceCheque" value="Bounce Chq"/></td>
                        <td><input type="button" id="btnCancelCheque" value="Cancel Chq"/></td>
                        
                        
                    </tr>
                </table>
                <div id="divChequeDepositsList" style="height:300px;overflow:auto;width:auto;">
                <table id='tblChequeDepositsList'   class="table table-striped">
                        <thead>
                            <tr>
                            <th><b>X</b></th>
                            <th><b>Status</b></th>
                            <th><b>Date</b></th>
                            <th><b>ChequeNo</b></th>
                            <th><b>TransNo</b></th>
                            <th><b>AccountNo</b></th>
                            <th><b>A/C Name</b></th>
                            <th><b>Amount</b></th>
                            <th><b>Value Date</b></th>
                            <th><b>Bank Name</b></th>
                            <th><b>DocNo</b></th>
                            <th><b>User</b></th>
                            <th><b>Matured</b></th>
                            </tr>
                        </thead>
                        <tbody id='bdChequeDepositsList'>
                        </tbody>
                    <tfoot>
                        <tr>
                            <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            </div>
        </form>
    </div>
    
    
</asp:Content>


