﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Chart Of Accounts
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        
 #myIframe{
  height: 1080px;
  width:1000px;
}
table, th, td {
    border: 2px solid black;
    text-align:left;
    padding-bottom:0.5em;
    padding-top:0.5em;
    padding-left:0.5em;
    padding-right:0.5em;
}
.tableControls {
    border: 0px solid black;
}
.balancecolumn {
    text-align:right;
}
   </style>

    
    <script type="text/javascript"  >
        
        $(document).ready(function () {
            LoadCOA();
            var editurl = "";
            
            $("#tbCOA").on("click", "a", function (e) {
                e.preventDefault();
                var row = $(this).closest("tr");
                var col = $(this).closest("td");
                var col_index = col.index();
                //alert(col_index);
                //alert(col.text());
                var firstCellValue = row.find("td").first().text();
                //alert(firstCellValue);
                //console.log(firstCellValue);
                if (col_index == 0) //edit acc
                {
                    editurl = $(this).attr("href");
                    $('#divEdit').dialog('open');
                    return false;
                } else { //Create sub acc

                }
            });
            /*
            $('#divCOA').on('click', 'a', function (event) {
                event.preventDefault();
                editurl = $(this).attr("href");
                $('#divEdit').dialog('open');
                return false;
            });
            */
            
            $("#divEdit").dialog({
                autoOpen: false,
                show: "fade",
                hide: "fade",
                modal: true,
                open: function (ev, ui) {
                    $('#EditFrame').attr('src', editurl);
                },
                height: 'auto',
                width: 'auto',
                resizable: true,
                title: 'Accounts Management',
                buttons: {
                    "Close": function () {
                        $(this).dialog("close");
                    }
                },
                close: function () {
                    $('#EditFrame').attr("src", "");
                    $(this).dialog("close");
                    LoadCOA();
                }
            });

            $("#btnPrint").click(function () {

                var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "Chart Of Accounts" + "</b>";
                $("#divCOA").printThis({
                    debug: false,
                    pageTitle: "ChartOfAccounts",
                    removeInline: true,
                    printContainer: true,
                    importCSS: true,
                    header: rptHeader
                });

            });
            $("#btnRefresh").click(function () {
                LoadCOA();
            });




            function LoadCOA() {
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $("#bdAccounts").html("");
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetChartOfAccounts") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var accounts = response;
                        var AccSpace = "";
                        var AccName = "";
                        var tbl_row = "";
                        
                        $.each(accounts, function (index, acc) {
                            AccSpace = "";
                            for (var i = 0; i < acc.DashCount; i++) {
                                AccSpace += "&nbsp;&nbsp;&nbsp;&nbsp;";
                            }
                            if (acc.AccIsTitle == "Y") {
                                AccName = "<b>" + acc.AccountName + "</b>";
                            } else {
                                AccName = acc.AccountName;
                            }
                            tbl_row += "<tr><td><a id='editAcc' href='" + global_site_root + "/Bank/BankSystem/GLAccountsManager?AccountNo=" + acc.UserCode + "'>" + acc.UserCode + "</a></td><td>" + acc.AccountCode + "</td><td>" + AccSpace + AccName + "</td><td class='balancecolumn'>" + acc.Balance + "</td><td><a id='newSub' href='' id='link_new_acc'>New Sub Acc</a></td></tr>"
                        });
                        $("#bdAccounts").append(tbl_row);

                    },
                    error: function (xhr, status, error) {
                        console.log(xhr);
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            }

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
<h3>Chart Of Accounts</h3>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <form id="frmMain" name="frmMain">
        <%= Html.AntiForgeryToken() %>
    <table class="tableControls">
        <tr class="tableControls">
            <td  class="tableControls">
                <input type="button" value="Refresh" id="btnRefresh" name="btnRefresh" style="margin:10px" /><input type="button" id="btnPrint" value="Print" style="margin:10px"/>
            </td>
            
        </tr>
    </table>
        <div id="divCOA"  style="height:auto;overflow:auto;width:auto;">
            <table id="tbCOA" class="table-responsive" style="width:100%" >
                <thead>
                    <tr>
                        <th><b>Account No</b></th>  
                        <th><b>Short Code</b></th>  
                        <th><b>Account Name</b></th>  
                        <th class='balancecolumn'><b>Balance</b></th>  
                        <th><b>New Sub Acc</b></th>  
                    </tr>
                </thead>
                <tbody id='bdAccounts'>
                </tbody>
                <tfoot>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </form>
    
    <div id="divEdit"><iframe id="EditFrame" width="900" height="500"></iframe></div>
</asp:Content>


