﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<!DOCTYPE html>

<html>
    <head runat="server">
    <meta name="viewport" content="width=device-width" />
      <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.5/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-SgOJa3DmI69IUzQ2PVdRZhwQ+dy64/BUtbMJw1MZ8t5HZApcHrRKUc4W0kG879m7" crossorigin="anonymous">
    <title>BOSA Statement</title>
        <%: Scripts.Render("~/bundles/jquery") %>
        <%: Scripts.Render("~/bundles/jqueryui") %>
        <%: Scripts.Render("~/bundles/modernizr") %>
        <%: Scripts.Render("~/bundles/CryptoJS") %>
        <%: Scripts.Render("~/bundles/form2js") %>
        <%: Scripts.Render("~/bundles/printThis") %>
        <%: Scripts.Render("~/bundles/jquerymaskedinput") %>
        <%: Scripts.Render("~/bundles/jquery_dataTables") %>
        <%: Scripts.Render("~/bundles/Q") %>
        <%: Scripts.Render("~/bundles/CustomUtils") %>
        <%: Scripts.Render("~/bundles/toWords") %>

        <%: Styles.Render("~/Content/site") %>
        <%: Styles.Render("~/Content/style") %>
        <%: Styles.Render("~/Content/jquery_dataTables_min") %>
        <%: Styles.Render("~/Content/smoothness") %>
        <%: Styles.Render("~/Content/jqrejectcss") %>
        <%: Styles.Render("~/Content/jquery_dataTables_themeroller_min") %>
        <%: Styles.Render("~/Content/themes/base/css") %>

         
</head>
    <body>
        <div >
        <form id="frmBOSAStatement" name="frmBOSAStatement">
        <%= Html.AntiForgeryToken() %>
       <div class="row g-3 mb-1">
                        <div class="col-md-3">
                            <label class="form-label">Financial Period</label>
                            <select id="cboYear" class="form-select">
                                <option value="selectyear">SELECT YEAR</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Period</label>
                            <select id="cboEndMonth" class="form-select">
                                <option value="selectEndperiod">Select End Period</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Format</label>
                            <select id="cboFormat" class="form-select">
                                <option value="standard">Standard</option>
                                <option value="groupbyloantype" selected>Group By Loan Type</option>
                            </select>
                        </div>
                    </div>
                    <div class="row g-3 mb-1">
                        <div class="col-md-3">
                            <label class="form-label">Search By</label>
                            <select id="cboSearchBy" class="form-select">
                                <option value="memberno">MemberNo</option>
                                <option value="idnumber">IDNo</option>
                                <option value="payrollno">PayrollNo</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label" id="divSearchDisplay">Search value</label>
                            <input type="text" id="txtSearchValue" class="form-control"/>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Employer</label>
                            <select id="cboEmployer" class="form-select">
                                <option value="selectemployer">SELECT EMPLOYER</option>
                            </select>
                        </div>
                    </div>
                    <div class="row g-3 mt-1">
                        <div class="col-md-3">
                            <input type="button" id="btnGetStatement" value="Get Statement" class="btn btn-primary"/>
                        </div>
                        <div class="col-md-3">
                            <input type="button" id="btnPrint" value="Print Statement" class="btn btn-info"/>
                        </div>
                        <div class="col-md-3" >
                            <input type="button" value="test report" id="btnTestReport" hidden="hidden" />
                            <input type="button" value="test print report" id="btnTestPrintReport" hidden="hidden" />
                            <span id="divPDF" class="btn btn-secondary">PDF Report</span>
                        </div>
                    </div>

                    <div class="card mt-2">
                        <div class="card-body">
                            <h4>Member Information</h4>
                            <div class="row g-3 mt-1">
                                <div id="divAccountInfo"></div>
                            </div>
                        </div>
                    </div>
    
        <div class="card mt-2" id="divStatement" style="padding-left: 10px;padding-right: 10px;padding-bottom: 10px;">
                        <div class="table-responsive mt-4 mb30" >
                            <table class="table table-bordered" id='tblStatement'>
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Description</th>
                                        <th>Doc No</th>
                                        <th>Debit</th>
                                        <th>Credit</th>
                                        <th>Balance</th>
                                        <th>Int. Debit</th>
                                        <th>Int. Credit</th>
                                        <th>Balance</th>
                                    </tr>
                                </thead>
                                <tbody id='bdStatement'>
                                </tbody>
                            </table>
                        </div>
                    </div>
    </form>
    </div>
   

</body>
    <script>
        
        $(document).ready(function () {
            var SaccoSettings = Object(<%= Json.Encode(ViewBag.SaccoSettings) %>);
            var UserDetails = Object(<%= Json.Encode(ViewBag.UserDetails) %>);
            var strLoginUserName = UserDetails.UserName;
            var AccountMask = SaccoSettings.AccountFormat;
            var CompanyName = SaccoSettings.CompanyName;
            var CompanyAddress = SaccoSettings.CompanyAddress;
            var FinYears = Object(<%= Json.Encode(ViewBag.FinYears as List<XtremeERP.Common.Data.FinancialYear>) %>);
            //self init coz is not part of StaffMaster

            //global_site_root defined in CustomUtils.js
            //global_site_root =String(<% =Url.Content("~/") %>);

            global_site_root = "<% =MvcHtmlString.Create(Url.Content("~/")) %>"; //is for creating safe html strings
            if (global_site_root.endsWith("/")) global_site_root = global_site_root.substring(0, global_site_root.length - 1);;//remove ending slash

            /*
            NOTE: if app is published in iis under Default Web Site global_site_root will be eg / SaccoSystem / else it will return / if it is published directly as a web app under Sites (which is the recommended way to avoid problems with urls ie publish directly under Sites not underanother website)
            In View/Controller/WebApi use
            httpContext.Request.ApplicationPath or
            var httpRequest = HttpContext.Current.Request;
            var appPathUrl = httpRequest.ApplicationPath.ToString();
            see also var rootUrl = getRootUrl(); in CustomUtils to get app main url
            https://www.codeproject.com/Articles/142013/There-is-something-about-Paths-for-Asp-net-beginne
            https://www.cambiaresearch.com/articles/35/how-do-i-get-the-application-path-in-an-aspnet-application
            */


                $("#btnGetStatement").on('click', function (ev) {
                    ev.preventDefault();
                    LoadBOSAStatement();
                    return false;
                });
                $('#txtSearchValue').focus();
                $('#txtSearchValue').on('focusout', function () {
                    LoadBOSAStatement();
                });
                $('#cboYear').on('change', function () {
                    LoadBOSAStatement();
                });
                $('#txtSearchValue').keypress(function (ev) {
                    if (ev.keyCode == 13 || ev.which == 13) {
                        $("#btnGetStatement").focus();
                        return false;
                    }
                });
                $("#btnSearchMember").on('click', function (e) {
                    xDialogSearchMemberRecord(AccountMask).then(function (data) {
                        var selected_idx = $("#cboSearchBy option:selected").index();
                        if (selected_idx == 0) { //member no
                            $("#txtSearchValue").val(data.MemberNo)
                        } else if (selected_idx == 1) { //idnumber
                            $("#txtSearchValue").val(data.IDNumber)
                        } else if (selected_idx == 2) {  //payrollno
                            $("#txtSearchValue").val(data.PayrollNo)
                            $("#cboEmployer").val(data.EmployerCode)
                        }
                        $("#txtSearchValue").focus();
                    });
                });
                $("#btnPrint").click(function () {
                    //$("#mySelector").printThis({
                    //debug: false,              * show the iframe for debugging
                    //importCSS: true,           * import page CSS
                    //printContainer: true,      * grab outer container as well as the contents of the selector
                    //loadCSS: "path/to/my.css", * path to additional css file
                    //pageTitle: "",             * add title to print page
                    //removeInline: false        * remove all inline styles from print elements

                    var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "BOSA Statement" + "</b>" + $("#divAccountInfo").html();
                    $("#divStatement").printThis({
                        debug: false,
                        pageTitle: "Report",
                        removeInline: true,
                        printContainer: true,
                        importCSS: true,
                        header: rptHeader
                    });

                });
                $("#cboSearchBy").on('change', function () {
                    $('#divSearchDisplay').html('Enter ' + $("#cboSearchBy option:selected").text());
                });

                $("#cboYear").on("change", function () {
                    LoadFinancialPeriods();
                });
                /*
                $('#tblStatement').dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                */
                $("#btnGetStatement").on('click', function () {
                    LoadBOSAStatement();
                });
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAllEmployer") %>",
                         data: "{}",
                         contentType: "application/json; charset=utf-8",
                         dataType: "json",
                         success: function (response) {
                             var employers = response;
                             var obj = document.getElementById("cboEmployer");
                             $.each(employers, function (index, empl) {
                                 var opt = document.createElement("option");
                                 opt.value = empl.EmployerCode;
                                 opt.text = empl.EmployerName;
                                 obj.appendChild(opt);
                             });
                         },
                         error: function (xhr, status, error) {
                             var errorMessage = xhr.status + ': ' + xhr.responseText;
                             alert('Error - ' + errorMessage);
                         }

                     });
            $("#cboYear").empty();
            $.each(FinYears, function (index, FinYr) {
                $("#cboYear").append("<option value='" + FinYr.DBName + "'>" + FinYr.UserDefinedYearName + "</option>");
            });
            $("#cboYear").get(0).selectedIndex = 0;
            LoadFinancialPeriods();
            
        function LoadFinancialPeriods() {
            var dbname = $("#cboYear").val();
            if (dbname == null) { return; }
            $("#cboStartMonth").empty();
            $("#cboEndMonth").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>",
                data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var fmonths = response;
                    var objEnd = document.getElementById("cboEndMonth");

                    $("#cboStartMonth").empty();
                    $("#cboEndMonth").empty();
                    $.each(fmonths, function (index, fmonth) {
                        var opt = document.createElement("option");
                        opt.value = fmonth.MonthID;
                        opt.text = fmonth.MonthName;
                        objEnd.appendChild(opt);
                        if (fmonth.Status == "OPENED") {
                            objEnd.selectedIndex = index
                        }

                    });
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });
        }



        function LoadBOSAStatement() {
            row = 1;
            $('#divAccountInfo').html("");
            $("#tblStatement > tbody:last").children().remove();
            $("#divPDF").html("PDF Report");
            if ($("#txtSearchValue").val().trim() == "") { return; }
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetBOSAStatement") %>",
                data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'StatementFormat': $("#cboFormat").val(), 'EndPeriod': $("#cboEndMonth").val(), 'SearchBy': $("#cboSearchBy").val(), 'SearchValue': $("#txtSearchValue").val(), 'EmpCode': $("#cboEmployer").val() }),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    row = 1;
                    $('#divAccountInfo').empty();
                    $("#tblStatement > tbody:last").children().remove();
                    if (response.StatementMember != null) {
                        $('#divAccountInfo').append('<p><strong>MemberName: ' + response.StatementMember.FullNames + '<br>'
                                                            + 'MemberNo: ' + response.StatementMember.MemberNo + '<br>'
                                                            + 'PayrollNo: ' + response.StatementMember.PayrollNo + '<br>'
                                                        + 'IDNo: ' + response.StatementMember.IDNumber + '<br>'
                                                         + '</strong></p>');
                    }

                    var lineitems = response.StatementItems;
                    var statref = "";
                    var total = 0;
                    var inttotal = 0;
                    var tbl_row = "";

                    var pdf_url = "<b><a href='" + global_site_root + "/Bank/BankSystem/BOSAStatementReport?DBName=" + $("#cboYear").val() + "&EmpCode=" + response.StatementMember.EmployerCode + "&PayrollNo=" + response.StatementMember.PayrollNo + "&EndPeriod=" + $("#cboEndMonth").val() + "&StatementFormat=" + $("#cboFormat").val() + "'>PDF Report</a></b>";
                    $("#divPDF").html(pdf_url);

                    $.each(lineitems, function (index, lineitem) {
                        row = row + index;
                        if (statref != lineitem.StatRef) {
                            total = 0;
                            inttotal = 0;
                            statref = lineitem.StatRef;

                            if (index != 0) {
                                tbl_row = "<tr>";
                                tbl_row += "<td colspan=8><hr/></td>";
                                tbl_row += "</tr>";
                            }

                            tbl_row = "<tr>";
                            tbl_row += "<td style='text-align: left;padding:7px'><b>" + lineitem.RefCode + "</b></td>";
                            tbl_row += "<td style='text-align: left;padding:7px'><b>" + lineitem.RefName + "</b></td>";
                            tbl_row += "<td style='text-align: left;padding:7px'><b>Doc. No.</b></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Debit</b></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Credit</b></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Balance</b></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Int. Debit</b></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Int. Credit</b></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Balance</b></td>";
                            tbl_row += "</tr>";
                            $("#bdStatement").append(tbl_row);
                        }

                        if (statref.substring(0, 1) == "S") {
                            total = +total - +lineitem.Debit + +lineitem.Credit;
                            inttotal = 0; //+inttotal + +lineitem.IntDebit + +lineitem.IntCredit;
                        } else {
                            total = +total + +lineitem.Debit - +lineitem.Credit;
                            inttotal = +inttotal + +lineitem.IntDebit - +lineitem.IntCredit;
                        }

                        if (statref.substring(0, 1) == "S") {
                            tbl_row = "<tr>";
                            tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.DocDate + "</td>";
                            tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.Description + "</td>";
                            tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.DocNo + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.Debit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.Credit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + total.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'></td>";
                            tbl_row += "</tr>";
                        } else {
                            tbl_row = "<tr>";
                            tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.DocDate + "</td>";
                            tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.Description + "</td>";
                            tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.DocNo + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.Debit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.Credit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + total.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.IntDebit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.IntCredit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + inttotal.formatMoney() + "</td>";
                            tbl_row += "</tr>";
                        }

                        $("#bdStatement").append(tbl_row);

                    });


                    tbl_row = "<tr>";
                    tbl_row += "<td colspan=9><i>**************End of Statement***********</i></td>";
                    tbl_row += "</tr>";
                    $("#bdStatement").append(tbl_row);
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });


        }

        function setCookie(c_name, value, expiredays) {
            var exdate = new Date();
            exdate.setDate(exdate.getDate() + expiredays);
            document.

                e = c_name + "=" + escape(value) +
            ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
        }
        function getCookie(c_name) {
            if (document.cookie.length > 0) {
                c_start = document.cookie.indexOf(c_name + "=");
                if (c_start != -1) {
                    c_start = c_start + c_name.length + 1;
                    c_end = document.cookie.indexOf(";", c_start);
                    if (c_end == -1) c_end = document.cookie.length;
                    return unescape(document.cookie.substring(c_start, c_end));
                }
            }
            return "";
        }

        $(function () {
            $("#tabs").tabs();
        });
        $(function () {
            $("#accordion").accordion({
                heightStyle: "content"
            });
        });
      });
    </script>
</html>
