﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master"
    Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

    <asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
        Member Summary
    </asp:Content>
    <asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
        <style type="text/css">
            .td_amount_col {
                text-align: right;
            }
        </style>


        <script type="text/javascript" >
            $(document).ready(function () {


            var saccoSettings = <%= Json.Encode(((XtremeERP.Common.Data.SaccoSettings)ViewBag.SaccoSettings)) %>;
            var portalSettings = <%= Json.Encode(((XtremeERP.Common.Data.MemberPortalSettings)ViewBag.PortalSettings)) %>;

            var bolIsSaccoBalozi = <%= (XtremeERP.Common.Utilities.Utils.bolIsSaccoBalozi ? "true" : "false") %>;

            var bolLoansAndInterestCombined = <%= Json.Encode((((XtremeERP.Common.Data.MemberPortalSettings)ViewBag.PortalSettings)).LoansAndInterestAreCombinedInSystem) %>;

            var bolIsDebug =<%= (XtremeERP.Common.Utilities.Utils.IsDebugMode() ? "true" : "false") %>;



            InitSummary();



            function LoadImageFromUrl(path, width, height, target) {
                //add code to clear target first!!!
                var path = global_site_root + path;
                //alert(path);
                $('<img src=' + path + '>')
                    .load(function () {
                        $(this).width(width).height(height).appendTo(target).addClass("img-responsive").addClass("img-rounded");
                    }).error(function () {
                        //display error somewhere
                    });
            }

            function InitSummary() {

                $("#tblMemberDetails > tbody:last").children().remove();
                $("#tblBalances > tbody:last").children().remove();
                $("#tblLoansGuaranteedToMe > tbody:last").children().remove();
                $("#tblLoansGuaranteedByMe > tbody:last").children().remove();
                $("#tblLoansDetails > tbody:last").children().remove();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/MembersSystemApi/GetMemberSummary") %>',
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var MemberDetails = response.GeneralSummary.MemberDetails;
                        var MemberBalances = response.GeneralSummary.MemberBals;
                        //console.log(MemberBalances);
                        var PhotoPath = response.PhotoPath;

                        //var SignaturePath = response.SignaturePath;
                        if (+response.pendingWitnessRequestCount > 0) {
                            //oncontextmenu="return false" to disable right click so counts get refreshed when user loads home again
                            $("#divPendingWitnessRequests").html('<a oncontextmenu="return false"' + 'href=' + "/Members/MembersSystem/WitnessRequest" + '>NB: You have ' + (+response.pendingWitnessRequestCount) + ' pending Witness(es) Requests</a>');
                        }
                        if (+response.pendingGuarantorshipRequestCount > 0) {
                            //oncontextmenu="return false" to disable right click so counts get refreshed when user loads home again
                            $("#divPendingGuarantorshipRequests").html('<a oncontextmenu="return false"' + 'href=' + "/Members/MembersSystem/GuarantorsRequest" + '>NB: You have ' + (+response.pendingGuarantorshipRequestCount) + ' pending Guarantorship Requests</a>');
                        }


                        var LoansGuaranteedByMe = response.LoansGuaranteedByMe;
                        var LoansGuaranteedToMe = response.LoansGuaranteedToMe;
                        var LoansInService = response.LoansInService;
                        TotalDeposits = response.GeneralSummary.TotalDeposits;
                        TotalGuaranteedToOthers = response.GeneralSummary.TotalGuaranteedToOthers;


                        ///LoadImageFromUrl(PhotoPath, 270, 270, $("#divMemberPhoto"));
                        if (PhotoPath != "") {

                            $("#divMemberPhoto").attr("src", PhotoPath).attr("width", 170).attr("height", 170);
                        } else {
                            $("#divMemberPhoto").attr("src", "/Content/images/placeholder.png").attr("width", 170).attr("height", 170);
                        }

                        //LoadImageFromUrl(SignaturePath, 270, 270, $("#divMemberSignature"));

                        $("#lblSurname").text(MemberDetails.Surname);
                        if (bolIsSaccoBalozi) {
                            $("#lblOtherNames").text(MemberDetails.FirstName + " " + MemberDetails.OtherNames);
                            $("#divEmail2").show();
                            $("#lblEmail2").text(MemberDetails.Email2);
                            $("#divBank").show();
                            $("#lblMainBankName").text(MemberDetails.MainBankName);
                            $("#divBankBranch").show();
                            $("#lblBankBranchName").text(MemberDetails.BankBranchName);
                            $("#divAccountNo").show();
                            $("#lblAccountNo").text(MemberDetails.AccountNo);
                            $("#divLandLine").show();
                            $("#lblLandLine").text(MemberDetails.LandLine);
                            $("#divLandLine1").show();
                            $("#lblLandLine1").text(MemberDetails.LandLine1);
                            $("#divLandLine2").show();
                            $("#lblLandLine2").text(MemberDetails.LandLine2);
                        } else {
                            $("#lblOtherNames").text(MemberDetails.OtherNames);
                            $("#divEmail2").hide();
                            $("#divBank").hide();
                            $("#divBankBranch").hide();
                            $("#divAccountNo").hide();
                            $("#divLandLine").hide();
                            $("#divLandLine1").hide();
                            $("#divLandLine2").hide();
                        }
                        $("#lblMemberNo").text(MemberDetails.MemberNo);
                        $("#lblPayrollNo").text(MemberDetails.PayrollNo);
                        $("#lblIDNumber").text(MemberDetails.IDNumber);
                        $("#lblEmployerName").text(MemberDetails.EmployerName);
                        $("#lblDOB").text(MemberDetails.DOB);
                        $("#lblAge").text(MemberDetails.Age);
                        $("#lblSalaryAccount").text(MemberDetails.SalaryAccount);
                        $("#lblPhoneNo").text(MemberDetails.PhoneNo);
                        $("#lblCellPhone").text(MemberDetails.CellPhone);
                        $("#lblEMailAddress").text(MemberDetails.EMailAddress);
                        $("#lblPresentAddress").text(MemberDetails.PresentAddress);
                        $("#lblHomeAddress").text(MemberDetails.HomeAddress);
                        $("#lblTotalLoanBalance").text((+response.GeneralSummary.TotalLoanBalance).formatMoney());
                        $("#lblTotalDeposits").text((+TotalDeposits).formatMoney());
                        $("#lblTotalGuaranteedToOthers").text((+TotalGuaranteedToOthers).formatMoney());


                        $("#lblDepositsMultiplied").text((+0).formatMoney());
                        $("#lblDepositsBalance").text((+TotalDeposits).formatMoney());
                        $("#lblAmountGuaranteedOthers").text((+TotalGuaranteedToOthers).formatMoney());
                        $("#lblAmountYouCanGuaranteedOthers").text((+0).formatMoney());
                        $("#lblMultiplier").text((+0).formatMoney());
                        LoanTypeList = response.LoansForCalc;
                        $("#cboLoanType").empty();
                        $("#cboLoanType").append('<option selected>(SELECT LOAN)</option>');
                        $.each(LoanTypeList, function (index, LoanType) {
                            $("#cboLoanType").append("<option value='" + LoanType.LoanTypeCode + "'>" + LoanType.LoanTypeName + "</option'>");
                        });

                        var tbl_row = "";





                        $("#bdMemberDetails").append(tbl_row);

                        $("#lblDepositsMultiplied").text((+0).formatMoney());
                        $("#lblDepositsBalance").text((+TotalDeposits).formatMoney());
                        $("#lblAmountGuaranteedOthers").text((+TotalGuaranteedToOthers).formatMoney());
                        $("#lblAmountYouCanGuaranteedOthers").text((+0).formatMoney());
                        $("#lblMultiplier").text((+0).formatMoney());


                        tbl_row = "";

                        $.each(MemberBalances, function (index, MemberBalance) {
                            //if ((+MemberBalance.BalAmount) != 0) {

                            //  tbl_row += "<tr><td>" + MemberBalance.AccountTypeName + "</td><td class='td_amount_col'>KES " + (+MemberBalance.BalAmount).formatMoney() + "</td></tr>";
                            //}

                            if ((MemberBalance.AccountTypeName).toUpperCase() == "") {
                                tbl_row += "<tr><td>" + MemberBalance.Description + "</td><td class='td_amount_col'>KES " + (+MemberBalance.BalAmount).formatMoney() + "</td></tr>";
                            } else {
                                tbl_row += "<tr><td>" + MemberBalance.AccountTypeName + "</td><td class='td_amount_col'>KES " + (+MemberBalance.BalAmount).formatMoney() + "</td></tr>";
                            }
                        });
                        // tbl_row += "<tr><td>TOTAL DEPOSITS</td><td class='td_amount_col'>" + (+TotalDeposits).formatMoney() + "</td></tr>";

                        $("#totalDeposits").text((+TotalDeposits).formatMoney());
                        //<!-- tbl_row += "<tr><td>TOTAL LOANS</td><td class='td_amount_col'>" + + "</td></tr>"; -->
                        $("#totalLoans").text((+response.GeneralSummary.TotalLoanBalance).formatMoney())

                        if (bolLoansAndInterestCombined) {
                            //hide column with BalType
                            $('#tblBalances tr').find('td:eq(0),th:eq(0)').hide();
                            //hide column with BalCode
                            $('#tblBalances tr').find('td:eq(1),th:eq(1)').hide();
                        } else {
                            //tbl_row = "<tr><td>TOTAL INTEREST</td><td class='td_amount_col'>" + + "</td></tr>";
                            $("#totalInterest").text((+response.TotalInterestBal).formatMoney())
                            $("#bdBalances").append(tbl_row);
                        }
                        tbl_row = "";
                        $.each(LoansInService, function (index, lnInService) {

                            tbl_row += "<tr><td>" + lnInService.LoanSerialNumber + "</td><td>" + lnInService.LoanTypeName + "</td><td>" + lnInService.IssueDate + "</td><td>" + lnInService.ExpectedEndDate + "</td><td class='td_amount_col'>KES " + (+lnInService.LoanAmount).formatMoney() + "</td><td class='td_amount_col'>KES " + (+lnInService.LoanBalance).formatMoney() + "</td><td class='td_amount_col'>KES " + (+lnInService.InstallmentAmount).formatMoney() + "</td><td class='td_amount_col'>" + (+lnInService.RepaymentPeriod) + "</td><td class='td_amount_col'>KES " + (+lnInService.Interest).formatMoney() + "</td><td class='td_amount_col'>KES " + (+lnInService.DefaultedAmount).formatMoney() + "</td></tr>";

                        });

                        $("#bdLoansDetails").append(tbl_row);
                        if (!portalSettings.ShowDefaultedAmtInLoanSummary) {
                            $('#tblLoansDetails tr').find('td:eq(9),th:eq(9)').hide();
                        }
                        tbl_row = "";
                        var lnSn = "";
                        var totalPledgedAmount = 0;
                        var totalCommittedAmount = 0;


                        $("#bdLoansGuaranteedToMe").append(tbl_row);

                        tbl_row = "";
                        $.each(LoansGuaranteedByMe, function (index, LoanGuaranteedByMe) {
                            tbl_row += "<tr><td>" + LoanGuaranteedByMe.LoanSerialNumber + "</td><td>" + LoanGuaranteedByMe.LoanTypeName + "</td><td>" + LoanGuaranteedByMe.LoaneeMemberNo + "</td><td>" + LoanGuaranteedByMe.LoaneeName + "</td><td>" + LoanGuaranteedByMe.LoaneePhoneNo + "</td><td class='td_amount_col'>" + (+LoanGuaranteedByMe.PledgedAmt).formatMoney() + "</td><td class='td_amount_col'>" + (+LoanGuaranteedByMe.CommittedAmount).formatMoney() + "</td><td class='td_amount_col'>" + (+LoanGuaranteedByMe.LoanBalance).formatMoney() + "</td><td>" + LoanGuaranteedByMe.ExpectedEndDate + "</td></tr>";
                        });
                        $("#bdLoansGuaranteedByMe").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = "";
                        try {
                            var jError = JSON.parse(xhr.responseText); //assuming object was sent as error
                            errorMessage = jError.StatusCode + ': ' + jError.Message;
                        } catch (e) {
                            errorMessage = xhr.status + ': ' + xhr.responseText;
                        }
                        alert('Error - ' + errorMessage);
                        //var errorMessage = jError.ErrorCode + ': ' + jError.Message;
                        //alert('Error - ' + errorMessage);

                        //alert(error);

                        //var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                    }
                });

            }

            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });

        });
        </script>
    </asp:Content>
    <asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
        <div class="p-0">
            <%= Html.AntiForgeryToken() %>
                <% XtremeERP.Common.Data.SaccoSettings saccoSettings=ViewBag.saccoSettings as
                    XtremeERP.Common.Data.SaccoSettings; %>
                    <% XtremeERP.Common.Data.SaccoMember saccoMember=ViewBag.SaccoMember as
                        XtremeERP.Common.Data.SaccoMember; %>
                        <% XtremeERP.Common.Data.MemberPortalSettings portalSettings=ViewBag.PortalSettings as
                            XtremeERP.Common.Data.MemberPortalSettings; %>



                            <div class="row p-3">
                                <div class="col-md-12">
                                    <!-- <p class="m-0">Welcome to your members portal.</p>
                                    <p class="m-0">Contact us <%= Html.ActionLink("here", "MemberChats", "MembersSystem", new { Area = "Members" }, new{}) %></p> -->

                                    <div id="divPendingGuarantorshipRequests"></div>
                                    <div id="divPendingWitnessRequests"></div>
                                </div>
                            </div>

                            <div class="px-3 cards-home">
                                <div
                                    class="d-flex gap-5 p-lg-4 p-3 justify-content-center align-items-center flex-column card">
                                    <div class="align-items-center d-flex flex-column justify-content-center">
                                        <img src="" id="divMemberPhoto" class="border rounded-circle"
                                            style="width:127px;height:127px;object-fit:cover;" alt="Member photo" />
                                        <!-- <div class="swap-item">
                                <img src="https://avatar.iran.liara.run/public/15" id="divMemberSignature" class="img-responsive img-rounded" style="width:127px;height:127px;" alt="Member signature" />
                            </div> -->
                                        <div class="mt-2">
                                            <span id="lblSurname" class="text-capitalized fw-bold fs-6"></span>
                                            <span id="lblOtherNames" class="fw-bold fs-6"></span>
                                        </div>

                                        <div class="d-flex gap-3 mt-2">
                                            <div class="d-flex flex-column align-items-center">
                                                <span class="fw-bold">Member No</span>
                                                <span id="lblMemberNo"></span>
                                            </div>
                                            <div class="d-flex flex-column align-items-center">
                                                <span class="fw-bold">Payroll No</span>
                                                <span id="lblPayrollNo"></span>
                                            </div>
                                            <div class="d-flex flex-column align-items-center">
                                                <span class="fw-bold">ID Number</span>
                                                <span id="lblIDNumber"></span>
                                            </div>


                                        </div>
                                    </div>
                                </div>
                                <div class="card d-flex flex-row gap-5 p-4" id="MemberDetails">
                                    <div id="divMemberDetails">
                                        <span class="fw-bold fs-6 text-center">Account Details</span>
                                        <div id='tblMemberDetails'>
                                            <div> <span class="fw-bold">Employer Name:</span> <span
                                                    id="lblEmployerName"></span></div>
                                            <div> <span class="fw-bold">Date of Birth:</span> <span id="lblDOB"></span>
                                            </div>
                                            <div> <span class="fw-bold">Age:</span> <span id="lblAge"></span></div>
                                            <div> <span class="fw-bold">Salary Account:</span> <span
                                                    id="lblSalaryAccount"></span></div>
                                            <div> <span class="fw-bold">Phone No:</span> <span id="lblPhoneNo"></span>
                                            </div>
                                            <div> <span class="fw-bold">Cell Phone:</span> <span
                                                    id="lblCellPhone"></span></div>
                                            <div> <span class="fw-bold">Email Address:</span> <span
                                                    id="lblEMailAddress"></span></div>
                                            <div> <span class="fw-bold">Present Address:</span> <span
                                                    id="lblPresentAddress"></span></div>
                                            <div> <span class="fw-bold">Home Address:</span> <span
                                                    id="lblHomeAddress"></span></div>
                                            <div id="divEmail2"> <span class="fw-bold">Alternate Email:</span> <span
                                                    id="lblEmail2"></span></div>
                                            <div id="divBank"> <span class="fw-bold">Main Bank:</span> <span
                                                    id="lblMainBankName"></span></div>
                                            <div id="divBankBranch"> <span class="fw-bold">Bank Branch:</span> <span
                                                    id="lblBankBranchName"></span></div>
                                            <div id="divAccountNo"> <span class="fw-bold">Account No:</span> <span
                                                    id="lblAccountNo"></span></div>
                                            <div id="divLandLine"> <span class="fw-bold">Land Line:</span> <span
                                                    id="lblLandLine"></span></div>
                                            <div id="divLandLine1"> <span class="fw-bold">Land Line 1:</span> <span
                                                    id="lblLandLine1"></span></div>
                                            <div id="divLandLine2"> <span class="fw-bold">Land Line 2:</span> <span
                                                    id="lblLandLine2"></span></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex gap-2 p-2 little-cards-home justify-content-between">
                                    <div class="card d-flex flex-row justify-content-between p-3"
                                        style="color: rgb(6, 199, 6); border-color: rgb(6, 199, 6);">
                                        <div class="d-flex flex-column">
                                            <span>Total Deposits</span>
                                            <span style="font-weight: 600;">KES <span id="totalDeposits"></span></span>
                                        </div>
                                        <i class="fa-solid fa-money-bill-trend-up fs-5"></i>
                                    </div>
                                    <div class="card d-flex flex-row justify-content-between p-3"
                                        style="color: rgba(249, 32, 32, 1); border-color: rgba(249, 32, 32, 1);">
                                        <div class="d-flex flex-column">
                                            <span>Total Loans</span>
                                            <span style="font-weight: 600;">KES <span id="totalLoans"></span></span>
                                        </div>
                                        <i class="fa-solid fa-landmark fs-5"></i>
                                    </div>
                                    <div class="card d-flex flex-row justify-content-between p-3"
                                        style="color: rgb(255, 157, 0); border-color: rgb(255, 157, 0);">
                                        <div class="d-flex flex-column">
                                            <span>Interest Charged</span>
                                            <span style="font-weight: 600;">KES <span id="totalInterest"></span></span>
                                        </div>
                                        <i class="fa-solid fa-money-bill-transfer fs-5"></i>
                                    </div>
                                </div>
                            </div>




                            <div class="tables-home">
                                <div class="row p-3 ">
                                    <div class="col-md-12 table-responsive card ">
                                        <span class="fw-bold my-2 text-center">Balances Summary</span>
                                        <table id='tblBalances' class="table table-striped table-borderless table-sm">
                                            <thead class="thead-dark">
                                                <tr>
                                                    <th>Description</th>
                                                    <th class="td_amount_col">Balance</th>
                                                </tr>
                                            </thead>
                                            <tbody id='bdBalances'>
                                            </tbody>

                                        </table>
                                    </div>
                                </div>

                                <div class="row p-3 ">
                                    <div id="divLoanDetails">
                                        <div class="card p-3">
                                            <span class="fw-bold text-center">Outstanding Loans Details</span>
                                            <table id="tblLoansDetails" class="table-responsive"
                                                style="white-space:nowrap;">
                                                <thead class="thead-dark">
                                                    <tr>
                                                        <th>LoanNo</th>
                                                        <th>Loan Name</th>
                                                        <th>Issue Date</th>
                                                        <th>End Date</th>
                                                        <th>Amount</th>
                                                        <th>Balance</th>
                                                        <th>Repayment</th>
                                                        <th>Months</th>
                                                        <th>Int (%)</th>
                                                        <th>Defaulted</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="bdLoansDetails">
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

        </div>

        <div id="loading" style="display:none"><img src="<%: Url.Content(" ~/Content/images/ajax-loader.gif") %>"
            alt="Ajax Loader" />Contacting server....</div>
        <div id="divStatementDlg" style="display:none"><iframe id="ifStatementDlg"
                style="height:640px;width:1140px"></iframe></div>

    </asp:Content>