﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Guarantorship Calculator
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        
        .td_amount_col {
            text-align: right;
        }
        
    </style>

    
    <script type="text/javascript"  >
        $(document).ready(function () {
            var LoanTypeList = null;
            var TotalDeposits = 0;
            var TotalGuaranteedToOthers = 0;
            
            //note no quotes to avoid 'true' and 'false' strings which will both evaluate to true on if (NoSalaryMazematics) {
            var bolIsSaccoBalozi =<%= (XtremeERP.Common.Utilities.Utils.bolIsSaccoBalozi ? "true" : "false") %>;

            InitSummary();

            function InitSummary() {

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberSummary") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var MemberDetails = response.GeneralSummary.MemberDetails;
                        var MemberBalances = response.GeneralSummary.MemberBals;
                        
                        var LoansGuaranteedByMe = response.LoansGuaranteedByMe;
                        var LoansGuaranteedToMe = response.LoansGuaranteedToMe;
                        var LoansInService = response.LoansInService;
                        

                        LoanTypeList = response.LoansForCalc;
                        $("#cboLoanType").empty();
                        $("#cboLoanType").append('<option selected>(SELECT LOAN)</option>');
                        $.each(LoanTypeList, function (index, LoanType) {
                            $("#cboLoanType").append("<option value='" + LoanType.LoanTypeCode + "'>" + LoanType.LoanTypeName + "</option'>");
                        });

                        

                        TotalDeposits = response.GeneralSummary.TotalDeposits;
                        TotalGuaranteedToOthers = response.GeneralSummary.TotalGuaranteedToOthers;

                        

                        $("#lblDepositsMultiplied").val((+0).formatMoney());
                        $("#lblDepositsBalance").val((+TotalDeposits).formatMoney());
                        $("#lblAmountGuaranteedOthers").val((+TotalGuaranteedToOthers).formatMoney());
                        $("#lblAmountYouCanGuaranteedOthers").val((+0).formatMoney());
                        $("#lblMultiplier").val((+0).formatMoney());


                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

            }
            
            $("#cboLoanType").on('change', function () {
                var LoanType = LoanTypeList.filter(function (lnType) {
                    return lnType.LoanTypeCode == $("#cboLoanType").val();
                });
                
                $("#lblDepositsMultiplied").val((+0).formatMoney());
                $("#lblDepositsBalance").val((+TotalDeposits).formatMoney());
                $("#lblAmountGuaranteedOthers").val((+TotalGuaranteedToOthers).formatMoney());
                $("#lblAmountYouCanGuaranteedOthers").val((+0).formatMoney());
                $("#lblMultiplier").val((+0).formatMoney());
                
                if (LoanType.length > 0) {

                    var SharesMultiplier = LoanType[0].LoanNumOfTimesShares;

                    var AmountThatCanGuaranteeOthers = 0;
                    var SharesMultiplied = (+SharesMultiplier) * (+TotalDeposits);
                    AmountThatCanGuaranteeOthers = (+SharesMultiplied) - (+TotalGuaranteedToOthers);
                    if (+AmountThatCanGuaranteeOthers < 0) {
                        AmountThatCanGuaranteeOthers = 0;
                    }
                    $("#lblMultiplier").val(SharesMultiplier);
                    $("#lblDepositsMultiplied").val((+SharesMultiplied).formatMoney());
                    $("#lblAmountYouCanGuaranteedOthers").val((+AmountThatCanGuaranteeOthers).formatMoney());
                    
                }
            });

            

            



            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });

        });
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    
        <%= Html.AntiForgeryToken() %> 
        <% XtremeERP.Common.Data.SaccoSettings saccoSettings = ViewBag.saccoSettings as XtremeERP.Common.Data.SaccoSettings; %>
        <% XtremeERP.Common.Data.SaccoMember saccoMember = ViewBag.SaccoMember as XtremeERP.Common.Data.SaccoMember; %>
        <% XtremeERP.Common.Data.MemberPortalSettings portalSettings = ViewBag.PortalSettings as XtremeERP.Common.Data.MemberPortalSettings; %>
        
        <div >
            <div class="card p-0" id="divGuarantorshipCalculator"> 
                <h4 class="fs-5 p-3">Guarantorship Calculator</h4>  
                <hr class="m-0 p-0"/>    
                <div class="row p-3">
                     <div class='col-md-4'>
                        <label class='form-label'>Loan Type</label>
                        <select class="form-select" id="cboLoanType"></select>
                        </div>
                     <div class='col-md-4'>
                        <label class='form-label'>Multiplier</label>
                        <input class="form-control" id="lblMultiplier" disabled/>
                        </div>
                     <div class='col-md-4'>
                        <label class='form-label'>Deposits</label>
                        <input class="form-control" id="lblDepositsBalance" disabled/>
                        </div>
                     <div class='col-md-4'>
                        <label class='form-label'>Deposits Multiplied</label>
                        <input class="form-control" id="lblDepositsMultiplied" disabled />
                        </div>
                     <div class='col-md-4'>
                        <label class='form-label'>Amount Already Committed</label>
                        <input class="form-control" id="lblAmountGuaranteedOthers" disabled/>
                        </div>
                    <div class='col-md-4'>
                        <label class='form-label'>Amount You Can Guarantee</label>
                        <input class="form-control" id="lblAmountYouCanGuaranteedOthers" disabled/>
                        </div>
                </div>
            </div>
        </div>
        
        
         
      
    <div id="loading" style="display:none"><img src="<%: Url.Content("~/Content/images/ajax-loader.gif") %>"  alt="Ajax Loader" />Contacting server....</div>
    <div id="divStatementDlg" style="display:none" ><iframe id="ifStatementDlg" style="height:640px;width:1140px"></iframe></div>
    
</asp:Content>
