﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/ExternalUsers/Views/Shared/ExternalUsers.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loan Disbusment Approval
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        tr.row_selected td{background-color:lawngreen;}
    </style>
    <script type="text/javascript"  >
        'use strict';
        
        $(document).ready(function () {

            ShowSearchParams();


            $("#cboEmployer").empty();
            $("#cboLoanType").empty();
            $("#cboYear").empty();

            $('#tbLoansList').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });


            $("#cboBranch").on('change', function () {
                LoadLoansListing();
            });
            $("#cboLoanType").on('change', function () {
                LoadLoansListing();
            });
            $("#cboYear").on('change', function () {
                LoadLoansListing();
            });

            $("#btnListLoans").on('click', function () {
                LoadLoansListing();
            });
            $("btnPrint").on('click', function () {
                PrintList("divLoansList");
            });
            $("cboSearchBy").on('change', function () {
                ShowSearchParams();
            });

            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/ExternalUsersSystemApi/GetLoansListingConfig") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var employers = response.EmployerList;
                    var obj = document.getElementById("cboEmployer");
                    var opt = document.createElement("option");
                    opt.value = "";
                    opt.text = "(ANY)";
                    obj.appendChild(opt);
                    $.each(employers, function (index, empl) {
                        var opt = document.createElement("option");
                        opt.value = empl.EmployerCode;
                        opt.text = empl.EmployerName;
                        obj.appendChild(opt);
                    });

                    var loans = response.LoansList;
                    var obj = document.getElementById("cboLoanType");
                    var opt = document.createElement("option");
                    opt.value = "";
                    opt.text = "(ANY)";
                    obj.appendChild(opt);
                    $.each(loans, function (index, loan) {
                        var opt = document.createElement("option");
                        opt.value = loan.LoanTypeCode;
                        opt.text = loan.LoanTypeName;
                        obj.appendChild(opt);
                    });
                    var years = response.YearsList;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        obj.appendChild(opt);
                    });

                    LoadLoansListing();

                },
                error: function (xhr, status, error) {

                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                }

            });




            function LoadLoansListing() {
                $("#tbLoansList > tbody:last").children().remove();
                if ($("#cboYear").val() == null) { return; }
                if ($("#cboYear").val() == "") { return; }



                var Criteria = {
                    "EmpCode": $("#cboEmpCode").val(),
                    "SearchBy": $("#cboSearchBy").val(),
                    "SearchValue": $("#txtSearchValue").val(),
                    "LoanTypeCode": $("#cboLoanType").val(),
                    "DBName": $("#cboYear").val(),
                }

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/ExternalUsersSystemApi/GetCreditCommitteeLoanListing") %>",
                    data: JSON.stringify(Criteria),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var tbl = "";
                        var loanlist = response;
                        var HRLinkText = "";
                        $.each(loanlist, function (index, loan) {
                            HRLinkText = "Approve";
                            tbl += "<tr><td>" + loan.LoanSerialNumber + "</td><td>" + loan.LoanTypeName + "</td><td>" + loan.MemberNo + "</td><td>" + loan.PayrollNo + "</td><td>" + loan.MemNames + "</td><td>" + (+loan.RequestedAmount).formatMoney() + "</td><td>" + (+loan.ApprovedAmount).formatMoney() + "</td><td>" + (+loan.InstallmentAmount).formatMoney() + "</td><td>" + loan.RepaymentPeriod + "</td><td>" + loan.ApprovalCount + "</td><td><a href='" + loan.LoanSerialNumber + "' class='approveLink'>" + HRLinkText + "</a></td></tr>"
                        });
                        $('#bdLoansList').append(tbl);
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }


            function ProcessLoanDisbursmentApproval(LoanToApprove) {
                $('<div id="divCCApproveLoanDialog"></div>').dialog({
                    modal: true,
                    title: "Approve Loan Disbursment",
                    height: 700,
                    width: 900,
                    autoOpen: true,
                    show: {
                        effect: "drop",
                        direction: "up",
                        duration: 500
                    },

                    buttons: {
                        'Approve': {
                            'text': 'Approve',
                            'id': 'btnApprove',
                            'click': function () {

                                var ConfirmMessage = "";
                                var approved_amount = LoanToApprove.mApprovedLoans.ApprovedAmount;
                                if (document.getElementById("cboCommitteeResponse").selectedIndex == 1) {
                                    ConfirmMessage = "Confirm Loan disbursment approval of " + (+approved_amount).formatMoney() + " ?";
                                } else if (document.getElementById("cboCommitteeResponse").selectedIndex == 2) {
                                    ConfirmMessage = "Confirm Loan disbursment rejection of " + (+approved_amount).formatMoney() + " ?";
                                } else if (document.getElementById("cboCommitteeResponse").selectedIndex == 0) {
                                    alert("Select Response");
                                    return;
                                }

                                xDialogConfirm(ConfirmMessage, "Confirm").then(function () {
                                    //xDialogMemberCredetials().then(function (data) { //call without password to speed up process but check for privilege
                                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                                    //var Password = data.UserPass;
                                    //var pwdslt = getRandomInt(1000, 30000);
                                    //pwdslt = pwdslt.toString();
                                    //var pwd = CryptoJS.MD5(Password).toString();
                                    //pwd = pwd + pwdslt;
                                    //var sltpwd = CryptoJS.MD5(pwd).toString();

                                    var outData = {
                                        'DBName': LoanToApprove.DBName,
                                        'MemberNo': LoanToApprove.mLoanAppraisals.MemberNumber,
                                        'LoanSerialNumber': LoanToApprove.LoanSerialNumber,
                                        'CommitteeResponse': $("#cboCommitteeResponse").val(),
                                        'Comments': $("#txtComments").val()
                                    }
                                    outData = JSON.stringify(outData);
                                    $.ajax({
                                        headers: { __RequestVerificationToken: csrfToken },
                                        type: "POST",
                                        url: "<%: Url.Content("~/api/ExternalUsersSystemApi/ApproveLoanDisbursment") %>",
                                        data: outData,
                                        contentType: "application/json; charset=utf-8",
                                        dataType: "json",
                                        success: function (response) {
                                            $("#tbLoansList tr").each(function (i) {
                                                var row = $(this);
                                                if (row.find('td:eq(0)').text() == LoanToApprove.LoanSerialNumber) {
                                                    $(row).remove();
                                                }
                                            });
                                            alert("Loan disbursment successfully updated");
                                            $("#divCCApproveLoanDialog").dialog("close");

                                        },
                                        error: function (xhr, status, error) {
                                            var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                                        }
                                    });
                                    //});
                                });
                            }
                        },
                        Cancel: function () {
                            $(this).dialog("close");
                        }
                    },
                    open: function () {
                        var ExtUserID = "";
                        var ExtUserNames = "";
                        var ExtRespDate = "";
                        var ExtRespStatus = "";

                        if (LoanToApprove.memberLoanApplicationDetails != null) {
                            ExtRespStatus = LoanToApprove.memberLoanApplicationDetails.memberLoanApplication.ManagerApprovalStatus;
                            ExtRespDate = LoanToApprove.memberLoanApplicationDetails.memberLoanApplication.ManagerApprovalDate;
                            ExtUserID = LoanToApprove.memberLoanApplicationDetails.memberLoanApplication.ExternalUserID;
                            ExtUserNames = LoanToApprove.memberLoanApplicationDetails.memberLoanApplication.ExternalUserFullNames;
                        }
                        var tbl = "";
                        tbl += "<div id='tabsDialog'>";
                        tbl += "<ul>";
                        tbl += "<li><a href='#tabs-1'>Loan Details</a></li>";
                        tbl += "<li><a href='#tabs-2'>Guarantors</a></li>";
                        tbl += "<li><a href='#tabs-3'>Offsets</a></li>";
                        tbl += "<li><a href='#tabs-4'>Member Balances</a></li>";
                        tbl += "<li><a href='#tabs-5'>Approvals</a></li>";
                        tbl += "</ul>";
                        tbl += "<form id='frmApprvDialog' name='frmApprvDialog'>";
                        tbl += "<div id='tabs-1'>";
                        tbl += "<table id='tblLoanDetails'  class='display' cellspacing='0' width='100%'>";
                        tbl += "<tbody>";
                        tbl += "<tr><td><b>Loan Serial Number:</b></td><td><input type='text' id='txtLoanSerialNumber' value='" + LoanToApprove.LoanSerialNumber + "' disabled /></td><td><b>Loanee:</b></td><td><input type='text' id='txtLoaneeName' value='" + LoanToApprove.saccoMember.FullNames + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>MemberNo:</b></td><td><input type='text' id='txtLoaneeMemberNo' value='" + LoanToApprove.saccoMember.MemberNo + "' disabled /></td><td><b>PayrollNo:</b></td><td><input type='text' id='txtLoaneePayrollNo' value='" + LoanToApprove.saccoMember.PayrollNo + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loan Type:</b></td><td><input type='text' id='txtLoanType' value='" + LoanToApprove.mLoanType.LoanTypeName + "' disabled /></td><td><b>Requested Amount:</b></td><td><input type='text' id='txtRequestedAmount' value='" + (+LoanToApprove.mLoanAppraisals.RequestedAmount).formatMoney() + "' disabled /></td></tr>";

                        tbl += "<tr><td><b>HOD Status</b></td><td><input type='text' value='" + ExtRespStatus + "' disabled /></td><td><b>HOD Date</b></td><td><input type='text' value='" + ExtRespDate + "' disabled /></td></tr>";

                        tbl += "<tr><td><b>HOD PF</b></td><td><input type='text' value='" + ExtUserID + "' disabled /></td><td><b>HOD Name</b></td><td><input type='text' value='" + ExtUserNames + "' disabled /></td></tr>";

                        tbl += "<tr><td><b>Recommended Amount</b></td><td><input type='text' id='txtRecommendedAmount' value='" + (+LoanToApprove.mAppraisalReport.RecommendedAmount).formatMoney() + "' disabled /></td><td><b>Loan Date:</b></td><td><input type='text' id='txtLoanDate' value='" + LoanToApprove.mLoanAppraisals.LoanDate + "' disabled /></td></tr>";

                        tbl += "<tr><td><b>HR Approved:</b></td><td><input type='text' value='" + LoanToApprove.mLoanAppraisals.HRResponse + "' disabled /></td><td><b>HR Response Date</b></td><td><input type='text' value='" + LoanToApprove.mLoanAppraisals.HRResponseDate + "' disabled /></td></tr>";

                        tbl += "<tr><td><b>HR Approved By:</b></td><td><input type='text' value='" + LoanToApprove.mLoanAppraisals.HRUserID + "' disabled /></td><td><b>HR Name:</b></td><td><input type='text'  value='" + LoanToApprove.mLoanAppraisals.HRFullName + "' disabled /></td></tr>";

                        tbl += "<tr><td><b>HR Ability:</b></td><td><input type='text' id='txtHRAbility' value='" + (+LoanToApprove.mLoanAppraisals.HRRepayAmt).formatMoney() + "' disabled  /></td><td><b>Loan Status:</b></td><td><input type='text'  value='" + LoanToApprove.mLoanAppraisals.LoanStatus + "' disabled /></td></tr>";
                        if (LoanToApprove.mApprovedLoans != null) {
                            tbl += "<tr><td><b>Approved Amt.:</b></td><td><input type='text' id='txtApprovedAmount' value='" + (+LoanToApprove.mApprovedLoans.ApprovedAmount).formatMoney() + "' disabled  /></td><td><b>Repayment Period.:</b></td><td><input type='text' id='txtRepaymentPeriod' value='" + LoanToApprove.mApprovedLoans.RepaymentPeriod + "' disabled  /></td></tr>";

                        }
                        else {
                            tbl += "<tr><td><b>Approved Amt.:</b></td><td><input type='text' id='txtApprovedAmount' value='0' disabled  /></td><td><b><b>Repayment Period.:</b></td><td><input type='text' id='txtRepaymentPeriod' value='N/A' disabled  /></td></tr>";
                        }
                        tbl += "<tr><td><b>Amt In Words:</b></td><td colspan='3'><div id='divApprovedAmountInWords'></td></tr>";
                        tbl += "<tr><td><b>Installment Amount</b></td><td><input type='text' id='txtInstallmentAmount' value='" + (+LoanToApprove.mAppraisalReport.InstallmentAmount).formatMoney() + "' disabled /></td><td><td></tr>";
                        tbl += "</tbody></table>";
                        tbl += "</div>";
                        tbl += "<div id='tabs-2'>";
                        tbl += "<table id='tblGuarantors' class='display' cellspacing='0' width='100%'>";
                        tbl += "<thead>";
                        tbl += "<tr>";
                        tbl += "	<th><b>MemberNo</b></th>";
                        tbl += "	<th><b>Name</b></th>";
                        tbl += "	<th class='td_amount_col'><b>Amount</b></th>";
                        tbl += "</tr>";
                        tbl += "</thead>";
                        tbl += "<tbody id='bdGuarantors'>";

                        if (LoanToApprove.mAutoLnDistribution != null) {
                            var loanGuarantors = LoanToApprove.mAppraisalGuarantors;
                            $.each(loanGuarantors, function (index, loanGuarantor) {
                                tbl += "<tr><td>" + loanGuarantor.GuarantorMemberNumber + "</td><td>" + loanGuarantor.FullNames + "</td><td class='td_amount_col'>" + (+loanGuarantor.SharesToCommit).formatMoney() + "</td></tr>"
                            });
                        }
                        tbl += "</tbody></table>";
                        tbl += "</div>";
                        tbl += "<div id='tabs-3'>";

                        tbl += "<table id='tblOffsets' class='display' cellspacing='0' width='100%'>";
                        tbl += "<thead>";
                        tbl += "<tr>";
                        tbl += "	<th><b>Type</b></th>";
                        tbl += "	<th><b>Reference</b></th>";
                        tbl += "	<th><b>Description</b></th>";
                        tbl += "	<th class='td_amount_col'><b>Offset Amount</b></th>";
                        tbl += "</tr>";
                        tbl += "</thead>";
                        tbl += "<tbody id='bdOffsets'>";

                        if (LoanToApprove.mLoanOffsetDetails != null) {
                            var loanOffsets = LoanToApprove.mLoanOffsetDetails;
                            $.each(loanOffsets, function (index, loanOff) {
                                tbl += "<tr><td>" + loanOff.TransType + "</td><td>" + loanOff.OffsetRefCode + "</td><td>" + loanOff.OffsetRefName + "</td><td class='td_amount_col'>" + (+loanOff.Amount).formatMoney() + "</td></tr>"
                            });
                        }
                        tbl += "</tbody></table>";
                        tbl += "</div>";
                        tbl += "<div id='tabs-4'>"

                        tbl += "<table id='tblMemberBalances' class='display' cellspacing='0' width='100%'>";
                        tbl += "<thead>";
                        tbl += "<tr>";
                        tbl += "	<th><b>Type</b></th>";
                        tbl += "	<th><b>Code</b></th>";
                        tbl += "	<th><b>Type</b></th>";
                        tbl += "	<th class='td_amount_col'><b>Balance</b></th>";
                        tbl += "</tr>";
                        tbl += "</thead>";
                        tbl += "<tbody id='bdMemberBalances'>";

                        if (LoanToApprove.memberBalancesSummary != null) {
                            if (LoanToApprove.memberBalancesSummary.MemberBals != null) {
                                var memberBalances = LoanToApprove.memberBalancesSummary.MemberBals;
                                $.each(memberBalances, function (index, memberBalance) {
                                    tbl += "<tr><td>" + memberBalance.BalType + "</td><td>" + memberBalance.BalCode + "</td><td>" + memberBalance.BalName + "</td><td class='td_amount_col'>" + (+memberBalance.BalAmount).formatMoney() + "</td></tr>"
                                });
                            }
                        }
                        tbl += "</tbody></table>";
                        tbl += "</div>";
                        tbl += "<div id='tabs-5'>"
                        tbl += "<table id='tblApprovals' class='display' cellspacing='0' width='100%'>";
                        tbl += "<thead>";
                        tbl += "<tr>";
                        tbl += "	<th><b>PF No</b></th>";
                        tbl += "	<th><b>Name</b></th>";
                        tbl += "	<th><b>Response</b></th>";
                        tbl += "	<th><b>Date</b></th>";
                        tbl += "	<th><b>Comments</b></th>";
                        tbl += "</tr>";
                        tbl += "</thead>";
                        tbl += "<tbody id='bdApprovals'>";

                        if (LoanToApprove.mLoanCommitteeApproval != null) {
                            var ccApprovals = LoanToApprove.mLoanCommitteeApproval;
                            $.each(ccApprovals, function (index, ccApproval) {
                                tbl += "<tr><td>" + ccApproval.CommitteeUserID + "</td><td>" + ccApproval.CommitteeUserFullNames + "</td><td>" + ccApproval.CommitteeResponse + "</td><td>" + ccApproval.CommitteeResponseDate + "</td><td>" + ccApproval.CommitteeComments + "</td></tr>"
                            });
                        }
                        tbl += "</tbody></table>";
                        tbl += "<table>";
                        tbl += "<tr>";
                        tbl += "<td>Response:</td><td><select id='cboCommitteeResponse' name='cboCommitteeResponse'><option value='' selected>(SELECT)</option><option value='Approved'>Approved</option><option value='Rejected'>Reject</option></select></td>";
                        tbl += "<td>Comments:</td><td><textarea id='txtComments' name='txtComments'></textarea></td>";
                        tbl += "</tr>";
                        tbl += "</table>";
                        tbl += "</div>";
                        tbl += "</form>";
                        tbl += "</div>";




                        $(this).html(tbl);

                        $('#tblOffsets').dataTable({
                            "paging": false,
                            "ordering": false,
                            "info": false,
                            "searching": false
                        });
                        $('#tblGuarantors').dataTable({
                            "paging": false,
                            "ordering": false,
                            "info": false,
                            "searching": false
                        });
                        $('#tblMemberBalances').dataTable({
                            "paging": false,
                            "ordering": false,
                            "info": false,
                            "searching": false
                        });
                        ShowAmtInWords();
                        $("#tabsDialog").tabs();


                    },
                    close: function (event, ui) {
                        $(this).dialog("destroy").remove();
                    }
                });

                function ShowAmtInWords() {
                    $("#divApprovedAmountInWords").html("");
                    try {
                        $("#divApprovedAmountInWords").html(toWords($("#txtApprovedAmount").val()));
                    } catch (err) {

                    }
                }


            }
            $('body').on('click', '.approveLink', function (e) {
                ApproveLoanDisbursment(this);
                e.preventDefault();
                return false;
            });
            function ApproveLoanDisbursment(hrapprovelink) {

                var ApproveLoanSerialNumber = hrapprovelink.getAttribute("href");
                var Criteria = {
                    "LoanSerialNumber": ApproveLoanSerialNumber,
                    "DBName": $("#cboYear").val()
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/ExternalUsersSystemApi/GetLoanDetails") %>",
                    data: JSON.stringify(Criteria),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        ProcessLoanDisbursmentApproval(response);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });

            }


            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion();
            });
            function ShowSearchParams() {
                $('#divSearchDisplay').empty();
                $('#divSearchDisplay').append('Enter ' + $("#cboSearchBy option:selected").text());
            }


            function PrintList(el) {
                var restorepage = document.body.innerHTML;
                var printcontent = document.getElementById(el).innerHTML;
                document.body.innerHTML = printcontent;
                window.print();
                document.body.innerHTML = restorepage;
            }
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
<h3>Loan Disbusment Approval</h3>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <form id="frmSearch" name="frmSearch" action="#">
        <%= Html.AntiForgeryToken() %>
    <table >
        <tr>
            <td colspan="4"><b>Filter Loan Listing</b></td>
        </tr>
        <tr>
            <td>Financial Year:</td><td><select id="cboYear"><option value="selectyear">SELECT YEAR</option></select></td>
            <td>
                Loan Type:
            </td>
            <td>
                <select id="cboLoanType"><option value="">(ANY)</option></select>
            </td>
            <td>Employer:</td><td><select id="cboEmployer">
                                        <option value="">SELECT EMPLOYER</option>
                                   </select>
            </td>
        </tr>
        <tr>
            <td>Search By:</td><td><select id="cboSearchBy">
                                        <option value="memberno" selected>MemberNo</option>
                                        <option value="idnumber">IDNo</option>
                                        <option value="payrollno">PayrollNo</option>
                                   </select>
            </td>
            <td><div id="divSearchDisplay">Search Value</div></td><td><input type="text" id="txtSearchValue"/></td>
            <td>
                <input type="button" id="btnListLoans" value="List Loans" />
                
            </td>
        </tr>
        
        <tr>
            <td></td>
            
        </tr>
        
        </table>
        
    </form>
    
    
    <div ><label id="ListingType">Loans List</label>
        <div id="divLoansList" style="height:200px;overflow:auto;width:auto">
            <table id='tbLoansList' class='display' style="width:100%">
                <thead>
                    <tr>
            	        <th><b>Loan Serial No</b></th>
            	        <th><b>Type</b></th>
            	        <th><b>Member No:</b></th>
            	        <th><b>Payroll No</b></th>
            	        <th><b>Names</b></th>
            	        <th><b>Requested</b></th>
            	        <th><b>Approved Amt</b></th>
            	        <th><b>Installemt Amt</b></th>
                        <th><b>Months</b></th>
            	        <th><b>Appr. Count</b></th>
                        <th><b>Approve</b></th>
                    </tr>
                </thead>
                <tbody id='bdLoansList'>
                </tbody>
                    <tfoot>
                        <tr>
                            <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                        </tr>
                </tfoot>    
            </table>
            </div>
        <br />
        Loan info<hr style="color:red" />
        <div id="divLoanInfo"></div>
    </div>
    
</asp:Content>

