﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/LoginMaster.Master" Inherits="System.Web.Mvc.ViewPage<XtremeERP.WEB.MemberCredentials>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Xtreme-ERP.Net - Verification
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .login-form{
           
        }
        #txtVerificationCode{text-transform: uppercase;}

        /* use css to ensure text is in uppercase. Not mandatory*/
    </style>



    <script type="text/javascript">
        var SaccoMember = Object(<%= Json.Encode(ViewBag.SaccoMember) %>);
        
        $(document).ready(function () {
            // Remove elements with "noscript" class - <noscript> is not allowed in XHTML
            var noscripts = document.getElementsByClassName("noscript");
            for (var i = 0; i < noscripts.length; i++) {
                noscripts[i].parentNode.removeChild(noscripts[i]);
            }
           
            $('#ReturnURL').val(getUrlParameter("ReturnUrl"));
            
            $('#txtVerificationCode').keypress(function (e) {
                if (e.keyCode == 13 || e.which == 13) {
                    e.preventDefault();
                    $('#frmLogin').submit();
                }
                
            });
            
            

        });
           

        function SubmitForm() {
            
            if ($('#txtVerificationCode').val().trim() == '') {
                ShowMessage("Enter UserName");
                $('#txtVerificationCode').focus();
                return false;
            } else if ($('#txtVerificationCode').val().trim().length < 4) {
                ShowMessage("Enter Password (Min 4 Characters)");
                $('#txtVerificationCode').focus();
                return false;
            } else {
                
                $("#lblMessage").html("<b>Verifying...Please wait</b>");
                return true;
            }
        }
        function ShowMessage(strMsg) {
            $("#lblMessage").html("<b>" + strMsg + "</b >");
        }
        function getUrlParameter(paramName) {
            var searchString = window.location.search.substring(1),
                i, val, params = searchString.split("&");

            for (i = 0; i < params.length; i++) {
                val = params[i].split("=");
                if (val[0] == paramName) {
                    return unescape(val[1]);
                }
            }
            return null;
        }
    </script>
</asp:Content>



<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
        <% XtremeERP.Common.Data.SaccoMember saccoMember = ViewBag.SaccoMember as XtremeERP.Common.Data.SaccoMember; %>
        <div class="row"  style="margin-left:10px">
            <div class="col-md-4 col-md-offset-3" >
                <h3 class="text-center">Member Login Verification</h3>
                <form class="login-form" id="frmLogin" method="post" autocomplete="off" action="<%: Url.Content("~/Login/MemberLoginVerification") %>" onsubmit="return SubmitForm()">
                    <%--DO NOT USE FORM TAG COZ OF PASSWORD CACHING COZ OF AUTO COMPLETE IN MOST BROWSERS WITHOUT SOLUTION--%>
                    <%--see argument for auto fill not being honoured at: https://stackoverflow.com/questions/22661977/disabling-safari-autofill-on-usernames-and-passwords--%>
                    <%--https://security.stackexchange.com/questions/49326/should-websites-be-allowed-to-disable-autocomplete-on-forms-or-fields--%>


                    <div id="divLg">
                        <%= Html.AntiForgeryToken() %>
                        <div class="form-group">
                            <label for="txtVerificationCode">Verification Code:</label>
                            <input class="form-control" type="text" name="txtVerificationCode" id="txtVerificationCode" placeholder="Enter Verification Code" autocomplete="off" />
                        </div>

                        <p>Dear <%: saccoMember.FullNames.ToUpper() %> ,<br />Please enter the code sent to your phone via SMS or via your EMail Address.</p>
                        <% if (!String.IsNullOrWhiteSpace(ViewBag.Message))
                            { %>
                        <div id="divError">
                            <p id="lblMessage" style="color: #ff0000; text-align: center"><b><%: ViewBag.Message %></b></p>
                        </div>
                        <% } %>

                        <div class="form-group">
                            <input type="submit" value="Verify" id="btnVerify" class="btn btn-success form-control" />
                        </div>
                        <div>
                        <%= Html.ActionLink("Back to Login", "Member", "Login", new { Area = ""}, new{id="linkBacktoMemberLogin"}) %>
                    </div>
                    </div>
                </form>
            </div>
        </div>
        
</asp:Content>

