$(document).ready(function() {
    // Custom tabs widget inspired by jQuery UI
    $.fn.customTabs = function(options) {
        var settings = $.extend({
            active: 0,
            event: "click",
            animate: true,
            duration: 300,
            beforeActivate: null,
            activate: null
        }, options);
        
        return this.each(function() {
            var $container = $(this);
            var $tabs = $container.find('.custom-tab-label');
            var $glider = $container.find('.custom-glider');
            var $panels = $('.tab-content-panel');
            
            // Initialize
            function init() {
                $tabs.each(function(index) {
                    $(this).data('index', index);
                });
                
                // Calculate and set glider width
                updateGliderSize();
                
                // Set initial active tab
                activateTab(settings.active);
            }
            
            // Update glider size based on active tab
            function updateGliderSize() {
                var $activeTab = $tabs.filter('.active');
                if ($activeTab.length) {
                    var tabWidth = $activeTab.outerWidth();
                    $glider.css('width', tabWidth + 'px');
                }
            }
            
            // Activate tab function
            function activateTab(index) {
                var $activeTab = $tabs.eq(index);
                var tabId = $activeTab.data('tab');
                
                // Call beforeActivate callback
                if (settings.beforeActivate && typeof settings.beforeActivate === 'function') {
                    var continueActivation = settings.beforeActivate.call($activeTab[0], {
                        newTab: $activeTab,
                        oldTab: $tabs.filter('.active'),
                        newPanel: $('#' + tabId),
                        oldPanel: $panels.filter('.active')
                    });
                    
                    if (continueActivation === false) {
                        return;
                    }
                }
                
                // Remove active class from all tabs and panels
                $tabs.removeClass('active');
                $panels.removeClass('active');
                
                // Add active class to selected tab and panel
                $activeTab.addClass('active');
                $('#' + tabId).addClass('active');
                
                // Update glider size and position
                updateGliderSize();
                var tabOffset = $activeTab.position().left;
                $glider.css('transform', 'translateX(' + tabOffset + 'px)');
                
                // Call activate callback
                if (settings.activate && typeof settings.activate === 'function') {
                    settings.activate.call($activeTab[0], {
                        newTab: $activeTab,
                        newPanel: $('#' + tabId)
                    });
                }
            }
            
            // Bind click events
            $tabs.on(settings.event, function(e) {
                e.preventDefault();
                var index = $(this).data('index');
                activateTab(index);
            });
            
            // Public methods
            $container.data('customTabs', {
                activate: function(index) {
                    activateTab(index);
                },
                getActive: function() {
                    return $tabs.filter('.active').data('index');
                },
                disable: function(index) {
                    $tabs.eq(index).addClass('disabled').off(settings.event);
                },
                enable: function(index) {
                    $tabs.eq(index).removeClass('disabled').on(settings.event, function(e) {
                        e.preventDefault();
                        activateTab($(this).data('index'));
                    });
                }
            });
            
            // Initialize the tabs
            init();
        });
    };
    
    // Initialize custom tabs
    $('#customTabs').customTabs({
        active: 0,
        beforeActivate: function(event) {
            console.log('Before activating tab:', event.newTab.data('tab'));
            return true; // Return false to prevent activation
        },
        activate: function(event) {
            console.log('Tab activated:', event.newTab.data('tab'));
        }
    });
    
    // Example of programmatic tab switching
    // $('#customTabs').data('customTabs').activate(1); // Activate second tab
});