﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Payroll/Views/Shared/PayrollMaster.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    NSSF Statement
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        /*
        .tblDRCRDetails {
             margin: 1px;
             border: 1em;
             padding-left:1em;
             padding-top:1em;
             border-collapse:separate;
         }
         */
         /*use this for to calculate totals*/  
         /*
         .colamount {
            text-align:right;
         }
         tr.row_selected td{background-color:lawngreen;}
             */

         table {
    font-family: arial, sans-serif;
    border-collapse: collapse;
    width: 100%;
}

td, th {
    border: 1px solid #dddddd;
    text-align: left;
    padding: 8px;
}

tr:nth-child(even) {
    background-color: #dddddd;
}

   </style>

    
    <script type="text/javascript"  >
        $(document).ready(function () {
            var strAccountName = "";
            var strAccountCode = "";
            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });


            $("#cboYear").empty();
            $.each(PayrollYears, function (index, payrollYear) {
                $("#cboYear").append("<option value='" + payrollYear.YearNo + "'>" + payrollYear.YearNo + "</option'>");
            });

            $("#cboYear").on("change", function () {
                $("#btnGetReport").trigger('click');
            });

            $('#tabs').on('tabsactivate', function (event, ui) {
                
            });
            //$('#tblPensiont').dataTable({
            //    "paging": false,
            //    "ordering": false,
            //    "info": false,
            //    "searching": false
            //});

            $("#txtPayrollNo").on('change', function () {
                $("#tblPensionList > tbody:last").children().remove();
                $("#divPDF").html("");
                $("#divEmployeeDetails").html("");
                $("#divPrintReport").html("");
            });

            $("#btnGetReport").on("click", function () {
                $("#tblPensionList > tbody:last").children().remove();

                $("#divPDF").html("");
                $("#divEmployeeDetails").html("");
                $("#divPrintReport").html("");

                if ($("#txtPayrollNo").val().toString() == "") { return; }

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'YearNo': $("#cboYear").val(),
                    'PayrollNo': $("#txtPayrollNo").val(),
                }
                outData = JSON.stringify(outData);
                var runBal = 0.0;
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/PayrollSystemApi/GetPayrollPensionReport") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#tblPensionList > tbody:last").children().remove();
                        var row_datas = response;
                        var tbl_row = "";
                        var ReportItems = row_datas.ReportItems;
                        var EmpRec = row_datas.EmpRec;
                        $.each(ReportItems, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.Description + "</td>";
                            tbl_row += "<td>" + row_data.YearNo + "</td>";
                            tbl_row += "<td>" + row_data.PeriodCode + "</td>";
                            tbl_row += "<td>" + row_data.PensionSelf.formatMoney() + "</td>";
                            tbl_row += "<td>" + row_data.PensionCompany.formatMoney() + "</td>";
                            tbl_row += "<td>" + row_data.PensionTotal.formatMoney() + "</td>";
                            runBal = runBal + row_data.PensionTotal;
                            tbl_row += "<td>" + runBal.formatMoney() + "</td>";
                            tbl_row += "</tr>";

                        });
                        $("#tblPensionList").append(tbl_row);
                        var pdf_url = "<b><a href='" + global_site_root + "/Payroll/PayrollSystem/GetPayrollPensionReport?YearNo=" + $("#cboYear").val() + "&PayrollNo=" + $("#txtPayrollNo").val() + "'>Print Report</a></b>";
                        $("#divPDF").html(pdf_url);
                        $("#divEmployeeDetails").html("Names: " + EmpRec.FullNames + "<br/>ID Number : " + EmpRec.IDNo + "<br/>Payroll No : " + EmpRec.PayrollNo + "<br/>Member No : " + EmpRec.CoopNo);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }

                });
            });
            
            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
<h3>Pension Statement</h3>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <div id="tabs">
      <ul>
        <li><a href="#tabs-1">Pension Report</a></li>
        <li><a href="#tabs-2">Provident Report</a></li>
      </ul>
        <form id="frmMain" name="frmMain" method="post">
            <%= Html.AntiForgeryToken() %>
            <div id="tabs-1">
                <table>
                    <tr>
                       <td>
                           Year
                       </td>
                        <td>
                            <select id="cboYear"></select>
                        </td>
                        <td> 
                            Payroll No:
                        </td>
                        <td>
                            <input type="text" id="txtPayrollNo" placeholder="PayrollNo"/>
                        </td>
                        <td>
                            <input type="button" id="btnGetReport" value="Get Report"/>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="5"> 
                            <div id="divEmployeeDetails"></div>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="5"> 
                            <div id="divPDF"></div>
                        </td>
                    </tr>
                </table>
                <div id="divPensionList" style="height:200px;overflow:auto;width:auto;">
                    <table id='tblPensionList'>
                            <thead>
                                <tr>
                                <th><b>Description</b></th>
                                <th><b>Year</b></th>
                                <th><b>Period</b></th>
                                <th><b>Self</b></th>
                                <th><b>Company</b></th>
                                <th><b>Total</b></th>
                                <th><b>Balance</b></th>
                                </tr>
                            </thead>
                            <tbody id='bdPensionList'>
                            </tbody>
                        <tfoot>
                            <tr>
                                <td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            
        </form>
    </div>
    
    
</asp:Content>



