﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loan Witness Requests
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css"></style>
    <script type="text/javascript"  >
        $(document).ready(function () {
            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: '<%: Url.Content("~/api/MembersSystemApi/GetYears") %>',
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    LoadWitnessesRequests();
                },
                error: function (xhr, status, error) {

                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });

            $("#cboYear").on("change", function () {
                LoadWitnessesRequests();
            });
            $("#cboLnApplicationStatus").on("change", function () {
                LoadWitnessesRequests();
            });
            $('#tblWitnessesRequests').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $('#bdWitnessRequests').on('click', 'a', function (event) {
                event.preventDefault();
                var ln_ref_no = $(this).closest('tr').find('td').eq(1).text();
                var ln_mem_no = $(this).closest('tr').find('td').eq(2).text();
                var ln_requested_loanee_name = $(this).closest('tr').find('td').eq(3).text();
                var ln_requested_loan_type = $(this).closest('tr').find('td').eq(4).text();
                var ln_loan_amt = $(this).closest('tr').find('td').eq(5).text();
                var ln_requested_amt = $(this).closest('tr').find('td').eq(6).text();
                $('<div id="divWitnessRequestDialog"></div>').dialog({
                    modal: true,
                    title: "Respond to Witness Request",
                    height: 520,
                    width: 500,
                    autoOpen: true,
                    responsive:true,
                    show: {
                        effect: "drop",
                        direction: "up",
                        duration: 500
                    },

                    buttons: {
                        'OK': {
                            'text': 'OK',
                            'id': 'btnOK',
                            'click': function () {
                                var accepted_amount = $("#txtAcceptedAmt").val();
                                var ConfirmMessage = "";
                                if (document.getElementById("cboWitnesssResponse").selectedIndex == 1) {
                                    
                                    ConfirmMessage = "Confirm Acceptance of Loan Application Witness?";
                                } else if (document.getElementById("cboWitnesssResponse").selectedIndex == 2) {
                                    ConfirmMessage = "Confirm Rejection of Loan Application Request?";
                                } else if (document.getElementById("cboWitnesssResponse").selectedIndex == 0) {
                                    alert("Select Response");
                                    return;
                                }
                                xDialogConfirm(ConfirmMessage, "Confirm").then(function () {
                                    xDialogMemberCredetials().then(function (data) {
                                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                                        var Password = data.UserPass;
                                        var pwdslt = getRandomInt(1000, 30000);
                                        pwdslt = pwdslt.toString();
                                        var pwd = CryptoJS.MD5(Password).toString();
                                        pwd = pwd + pwdslt;
                                        var sltpwd = CryptoJS.MD5(pwd).toString();
                                        var outData = {
                                            'DBName': $("#cboYear").val(),
                                            'LoanRefNo': $("#txtRequestLoanRefNo").val(),
                                            'Response': $("#cboWitnesssResponse").val(),
                                            'Notes': $("#txtResponseReason").val(),
                                            'Password': sltpwd,
                                            'Salt': pwdslt
                                        }
                                        outData = JSON.stringify(outData);
                                        $.ajax({
                                            headers: { __RequestVerificationToken: csrfToken },
                                            type: "POST",
                                            url: '<%: Url.Content("~/api/MembersSystemApi/ProcessMemberLoanApplicationWitnessResponse") %>',
                                            data: outData,
                                            contentType: "application/json; charset=utf-8",
                                            dataType: "json",
                                            success: function (response) {
                                                alert(response);
                                                $("#divWitnessRequestDialog").dialog("close");
                                                LoadWitnessesRequests();
                                            },
                                            error: function (xhr, status, error) {
                                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                                alert('Error - ' + errorMessage);
                                            }
                                        });
                                    });
                                });
                            }
                        },
                        Cancel: function () {
                            $(this).dialog("close");
                        }
                    },
                    open: function () {
                        var tbl = "<table id='tblRespondWitnessRequest' border=1>";
                        tbl += "<tbody>";
                        tbl += "<tr><td>Loan Ref. No:</td><td><input type='text' id='txtRequestLoanRefNo' value='" + ln_ref_no + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loanee:</td><td><input type='text' id='txtRequestLoaneeName' value='" + ln_requested_loanee_name + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loane MemberNo:</td><td><input type='text' id='txtRequestLoaneeMemberNo' value='" + ln_mem_no + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loan Type:</td><td><input type='text' id='txtRequestLoanType' value='" + ln_requested_loan_type + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loan Amount:</td><td><input type='text' id='txtRequestLoanAmount' value='" + ln_loan_amt + "' disabled /></td></tr>";
                        tbl += "<tr><td>Reponse:</td><td><select id='cboWitnesssResponse'><option value='' selected>(SELECT)</option><option value='accepted'>Accept</option><option value='rejected'>Reject</option></select></td></tr>";
                        tbl += "<tr><td>Notes/Reason:</td><td><textarea id='txtResponseReason' disabled/></textarea></td></tr>";
                        tbl += "</tbody></table>";
                        $(this).html(tbl);
                        $("#cboWitnesssResponse").focus;
                    },
                    close: function (event, ui) {
                        $(this).dialog("destroy").remove();
                    }
                });
                $("#txtPassword").on("keyup", function (e) {
                    var kcode = (e.keyCode ? e.keyCode : e.which);
                    if (kcode == $.ui.keyCode.ENTER) {
                        $("#btnOK").trigger("click");
                    }
                    e.stopPropagation();
                });

                $("#cboWitnesssResponse").on('change', function () {
                    $("#txtResponseReason").attr("disabled", true);
                    $("#txtResponseReason").val("");

                    if ($("#cboWitnesssResponse option:selected").index() == 1) {
                        $("#txtResponseReason").attr("disabled", false);
                    }
                    else if ($("#cboWitnesssResponse option:selected").index() == 2) {
                        //$("#txtResponseReason").attr("disabled", true);
                        $("#txtResponseReason").attr("disabled", false);
                    }
                });
            });

            function LoadWitnessesRequests() {
                $("#tblWitnessesRequests > tbody:last").children().remove();
                
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/MembersSystemApi/GetMemberWitnessRequests") %>',
                    data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'LoanStatus': $("#cboLnApplicationStatus").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var WitnessRequests = response;
                        var tbl_row = "";
                        
                        $.each(WitnessRequests, function (index, WitnessRequest) {
                           
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + WitnessRequest.LoanDate + "</td>";
                            tbl_row += "<td>" + WitnessRequest.LoanRefNo + "</td>";
                            tbl_row += "<td>" + WitnessRequest.LoaneeMemberNo + "</td>";
                            tbl_row += "<td>" + WitnessRequest.LoaneeNames + "</td>";
                            tbl_row += "<td>" + WitnessRequest.LoanTypeName + "</td>";
                            tbl_row += "<td>" + (+WitnessRequest.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + WitnessRequest.WitnessResponse + "</td>";
                            tbl_row += "<td><a href=''>Respond</td>";
                            tbl_row += "<td>" + WitnessRequest.LoanProcessStatus + "</td>";  
                            tbl_row += "</tr>";
                        });
                        if (tbl_row != "") { $("#bdWitnessRequests").append(tbl_row); }

                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div>
        <div class="card bg-white">
        <h3 class="p-3 fs-5">Loan Witnesses Requests</h3>
        <hr class="m-0 p-0"/>
        <div class="row p-3">
            <div id="div1" class="col-md-4">
                <form id="frmMain" name="frmMain">
                    <%= Html.AntiForgeryToken() %>
                    <div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="txtYear" class="form-label">Financial Year:</label>
                                <select id="cboYear" class="form-select">
                                    <option value="selectyear">SELECT YEAR</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="txtLoanApplicationstatus" class="form-label">Loan Application Status:</label>
                                <select id="cboLnApplicationStatus" class="form-select">
                                    <option value="pending" selected>ACTIVE</option>
                                    <option value="">ANY</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div id="divWitnessesRequests" class="table-responsive">
                        <table id='tblWitnessesRequests' class='table table-bordered table-responsive text-nowrap'>
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Ref.No</th>
                                    <th>MemberNo</th>
                                    <th>Names</th>
                                    <th>Loan Type</th>
                                    <th>Loan Amount</th>
                                    <th>Status</th>
                                    <th>Respond</th>
                                    <th>Loan Request Status</th>
                                </tr>
                            </thead>
                            <tbody id='bdWitnessRequests'>
                            </tbody>
                           
                        </table>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
</asp:Content>


