﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loan Application
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .tblDRCRDetails {
             margin: 1px;
             border: 1em;
             padding-left:1em;
             padding-top:1em;
             border-collapse:separate;
         }
         
         /*use this for to calculate totals*/  
         .colamount {
            text-align:right;
         }
         tr.row_selected td{background-color:lawngreen;}
   </style>

    
    <script type="text/javascript"  >
        
        var hod_managers_list = null; 
        $(document).ready(function () {
            var loan_saving_scheme = "";
            var ln_app_to_edit = null;
            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });

            $("#txtLoanAmount").on('change keyup paste mouseup', function () {
                $("#divAmountInWords").html("");
                try {
                    $("#divAmountInWords").html(toWords($("#txtLoanAmount").val()));
                    CalcRepayAmount();
                } catch (err) {

                }
            });
            $("#txtRepaymentPeriod").on('change keyup paste mouseup', function () {
                CalcRepayAmount();
            });


            $("#tblLoanProperties").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $("#tblOffsets").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $("#tblGuarantors").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $("#tblLoanApplicationList").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });

            $("#tblLoanProgress").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });


            $("#tblSavedLoanGuarantors").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $("#tblOtherLoanProperties").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });


            $('#bdGuarantors').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Guarantor Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    $(rm_row).remove();
                });
                return false;
            });

            $('#bdLoanApplicationList').on('click', 'tr', function (event) {
                var sel_row = $(this)
                $("#lblLoanRefNo").html("");
                var loan_ref_no = sel_row.find('td').eq(0).text();
                $("#lblLoanRefNo").html("<b>Loan Details for Ref No.: " + loan_ref_no + "</b><br/>");
                ln_app_to_edit = null;
                
                $('#bdLoanApplicationList tr').removeClass('row_selected');
                $(this).addClass('row_selected');

                $("#tblSavedLoanGuarantors > tbody:last").children().remove();
                $("#tblOtherLoanProperties > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboYear").val(),
                    'LoanRefNo': loan_ref_no
                }
                outData = JSON.stringify(outData);

                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanApplicationDetails") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#tblOtherLoanProperties > tbody:last").children().remove();
                        $("#tblLoanProperties > tbody:last").children().remove();
                        ln_app_to_edit = response;
                        var row_datas = response.memberLoanApplicationGuarantor;
                        var tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.GuarantorMemberNo + "</td>";
                            tbl_row += "<td>" + row_data.GuarantorName + "</td>";
                            tbl_row += "<td>" + (+row_data.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.AcceptedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + row_data.GuarantorResponse + "</td>";
                            tbl_row += "<td>" + row_data.GuarantorNotes + "</td>";
                            tbl_row += "<td><a href=''>Remove</a></td>";

                            tbl_row += "</tr>";
                        });
                        $("#bdSavedLoanGuarantors").append(tbl_row);
                        row_datas = response.memberLoanApplication;

                        tbl_row = "<tr>";
                        tbl_row += "<td>Manager Comments</td>";
                        tbl_row += "<td>" + row_datas.ManagerComments + "</td>";
                        tbl_row += "</tr>";

                        tbl_row += "<tr>";
                        tbl_row += "<td>Manager Response Date</td>";
                        tbl_row += "<td>" + row_datas.ManagerApprovalDate + "</td>";
                        tbl_row += "</tr>";

                        $("#bdOtherLoanProperties").append(tbl_row);


                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

                return false;
            });

            $('#bdSavedLoanGuarantors').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Guarantor Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    var outData = {
                        'DBName': $("#cboYear").val(),
                        'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                        'GuarantorMemberNo': rm_memno
                    }
                    outData = JSON.stringify(outData);
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/MembersSystemApi/RemoveGuarantorFromMemberLoanApplication") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $(rm_row).remove();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
                return false;
            });

            InitForm();
            $("#btnListManagers").on('click', function () {
                xDialogSelectManager(hod_managers_list).then(function (data) {
                    $("#txtNormnieeUserID").val(data);
                    $("#txtNormnieeUserID").trigger('focusout');
                    $("#txtNormnieeUserID").focus();
                });
            });
            $("#txtNormnieeUserID").on("focusout", function () {
                $("#divNormineeName").html("");
                if ($("#txtNormnieeUserID").val().trim() != "") {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/MembersSystemApi/GetExternalUserName") %>",
                        data: JSON.stringify({ 'UserID': $("#txtNormnieeUserID").val() }),
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $("#divNormineeName").html(response);
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                }
            });

            $("#cboLoanType").on('change', function () {
                $("#tblLoanProperties > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanTypeDetails") %>",
                    data: JSON.stringify({ 'LoanTypeCode': $("#cboLoanType").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#txtRepaymentPeriod").val(response.LoanMaxDuration);
                        var tbl_row = "";
                        loan_saving_scheme = response.SchemeUsed;
                        tbl_row += "<tr><td>Max Amount</td><td>" + (+response.LoanMaxAmount).formatMoney() + "</td></tr>";
                        tbl_row += "<tr><td>Repayment Period</td><td>" + response.LoanMaxDuration + "</td></tr>";
                        tbl_row += "<tr><td>Interest Rate</td><td>" + response.Percentage + " %</td></tr>";
                        $("#bdLoanProperties").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });
            $('#tabs').on('tabsactivate', function (event, ui) {
                var newIndex = ui.newTab.index();
                if (newIndex == 1) {
                    GetMemberLoanApplicationsListing();
                } else if (newIndex == 2) {
                    GetMemberLoansInProgress();
                }
            });






            $("#cboYear").on('change', function () {
                GetMemberLoanApplicationsListing();
            });
            $("#cboProgressYear").on('change', function () {
                GetMemberLoansInProgress();
            });
            $("#cboLoanProgressStatus").on('change', function () {
                GetMemberLoansInProgress();
            });
            $("#btnProgressRefresh").on('click', function () {
                GetMemberLoansInProgress();
            });




            $("#btnRefresh").on('click', function () {
                GetMemberLoanApplicationsListing();
            });
            $("#btnCancel").on('click', function () {
                InitForm();
            });
            $("#btnAddGuarantor").on('click', function () {
                xDialogMemberAddGuarantor(loan_saving_scheme, null, null).then(function (data) {
                    var tbl_row = "<tr><td>" + data.GuarantorMemberNo + "</td><td>" + data.GuarantorNames + "</td><td>" + (+data.GuarantorAmount).formatMoney() + "</td><td><a href=''>Remove</a></td></tr>";
                    $("#bdGuarantors").append(tbl_row);
                });
            });
            $("#btnAddMoreGuarantor").on('click', function () {
                if (ln_app_to_edit == null) return;
                xDialogMemberAddGuarantor(ln_app_to_edit.LoanType.SchemeUsed, $("#cboYear").val(), ln_app_to_edit.LoanRefNo).then(function (data) {
                    var tbl_row = "<tr>";
                    tbl_row += "<td>" + data.GuarantorMemberNo + "</td>";
                    tbl_row += "<td>" + data.GuarantorNames + "</td>";
                    tbl_row += "<td>" + (+data.GuarantorAmount).formatMoney() + "</td>";
                    tbl_row += "<td>0.00</td>";
                    tbl_row += "<td>Pending</td>";
                    tbl_row += "<td></td>";
                    tbl_row += "<td><a href=''>Remove</a></td>";
                    tbl_row += "</tr>";
                    $("#bdSavedLoanGuarantors").append(tbl_row);
                });

            });
            $("#btnCancelApplication").on('click', function () {
                if (ln_app_to_edit == null) {
                    alert("Select Loan to cancel");
                    return;
                }
                xDialogConfirm("Are you sure you want to Cancel the selected loan application?<br/>Loan No=" + ln_app_to_edit.LoanRefNo + "<br/>Loan Type=" + ln_app_to_edit.LoanType.LoanTypeName + "<br/>Applied Amount " + (ln_app_to_edit.memberLoanApplication.RequestedAmount).formatMoney() + " ?", "Confirm").then(function () {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    var outData = {
                        'DBName': $("#cboYear").val(),
                        'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                    }
                    outData = JSON.stringify(outData);
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/MembersSystemApi/CancelMemberLoanApplication") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            GetMemberLoanApplicationsListing();
                            alert("Loan application  number " + ln_app_to_edit.LoanRefNo + " successfully cancelled");
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            });

            $("#btnSubmitLoanApplication").on('click', function () {
                if (ln_app_to_edit == null) {
                    alert("Select Loan to Submit");
                    return;
                }

                xDialogConfirm("Are you sure you want to Submit the selected loan application for processing?<br/>Loan No=" + ln_app_to_edit.LoanRefNo + "<br/>Loan Type=" + ln_app_to_edit.LoanType.LoanTypeName + "<br/>Applied Amount " + (ln_app_to_edit.memberLoanApplication.RequestedAmount).formatMoney() + " ?", "Confirm").then(function () {

                    xDialogMemberCredetials().then(function (data) {
                        SubmitLoanApplication(data);
                    });

                });
            });
            $("#btnSave").on('click', function () {
                if (document.getElementById("cboLoanType").selectedIndex == 0) {
                    alert("Select Loan Type");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtLoanAmount").val()))) {
                    alert("Invalid Amount");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRepaymentAmount").val()))) {
                    alert("Invalid Repayment Amount");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRepaymentPeriod").val()))) {
                    alert("Invalid Repayment Period");
                    return;
                }

                xDialogConfirm("Confirm Loan Application<br/>Loan Type=" + $("#cboLoanType option:selected").text() + "<br/>Amount " + (ConvertMoneyToDouble($("#txtLoanAmount").val())).formatMoney() + " ?", "Confirm").then(function () {
                    xDialogMemberCredetials().then(function (data) {
                        SaveMemberLoanApplication(data);
                    });
                });
            });

            function SubmitLoanApplication(credentials) {
                if (ln_app_to_edit == null)
                {
                    alert("Select Loan to Submit");
                    return;
                }
                var Password = credentials.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();

                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();
                

                var outData = {
                    'DBName': $("#cboYear").val(),
                    'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                    'Password': sltpwd,
                    'Salt': pwdslt
                }

                outData = JSON.stringify(outData);
                
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/SubmitMemberLoanApplication") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            GetMemberLoanApplicationsListing();
                            alert("Loan application  number " + ln_app_to_edit.LoanRefNo + " successfully submitted for processing");
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });

            }
            
            function CalcRepayAmount() {
                try {
                    var LoanAmount = $("#txtLoanAmount").val();
                    var RepayPeriod = $("#txtRepaymentPeriod").val();
                    var RepayAmt = LoanAmount / RepayPeriod
                    $("#txtRepaymentAmount").val(RepayAmt.formatMoney());
                } catch (err) {

                }
            }
            function GetMemberLoanApplicationsListing() {
                
                
                $("#lblLoanRefNo").html("");
                $("#tblLoanApplicationList > tbody:last").children().remove();
                $("#tblSavedLoanGuarantors > tbody:last").children().remove();
                $("#tblOtherLoanProperties > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboYear").val(),
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanApplicationsListing") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#tblLoanApplicationList > tbody:last").children().remove();
                        var row_datas = response;
                        var tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.LoanRefNo + "</td>";
                            tbl_row += "<td>" + row_data.LoanDate + "</td>";
                            tbl_row += "<td>" + row_data.LoanTypeName + "</td>";
                            tbl_row += "<td>" + (+row_data.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + row_data.ProcessStatus + "</td>";
                            tbl_row += "<td>" + row_data.ManagerApprovalStatus + "</td>";
                            tbl_row += "</tr>";
                        });
                        $("#bdLoanApplicationList").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }

                });
            }
            function GetMemberLoansInProgress() {
                $("#tblLoanProgress > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboProgressYear").val(),
                    'LoanStatus': $("#cboLoanProgressStatus").val()
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoansInProgress") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#tblLoanProgress > tbody:last").children().remove();
                        var row_datas = response;
                        var tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.LoanSerialNumber + "</td>";
                            tbl_row += "<td>" + row_data.OnlineApplicationNo + "</td>";
                            tbl_row += "<td>" + row_data.LoanDate + "</td>";
                            tbl_row += "<td>" + row_data.LoanTypeName + "</td>";
                            tbl_row += "<td>" + row_data.LoanStatus + "</td>";
                            tbl_row += "<td>" + (+row_data.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.RecommendedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.ApprovedAmount).formatMoney() + "</td>";
                            tbl_row += "<td><a href='" + row_data.LoanSerialNumber + "' class='approveLink'>" + row_data.MemberAcceptance + "</a></td>";
                            if (row_data.LoanStatus.toString().toLowerCase() == "approved".toLowerCase()) {
                                tbl_row += "<td><a href='/Members/MembersSystem/OfferLetter?DBName=" + $("#cboProgressYear").val() + "&LoanSerialNumber=" + row_data.LoanSerialNumber + "'>Offer Letter</a></td>";
                            } else {
                                tbl_row += "<td>N/A</td>";
                            }
                            tbl_row += "</tr>";
                        });
                        $("#bdLoanProgress").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }

                });
            }
            
            $('body').on('click', '.approveLink', function (e) {
                MemberAcceptRejectLoan(this);
                e.preventDefault();
                return false;
            });
            function MemberAcceptRejectLoan(approvelink) {

                var ApproveLoanSerialNumber = approvelink.getAttribute("href");
                var Criteria = {
                    "LoanSerialNumber": ApproveLoanSerialNumber,
                    "DBName": $("#cboProgressYear").val()
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetLoanDetails") %>",
                    data: JSON.stringify(Criteria),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        ProcessMemberLoanAcceptance(response);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }
            function ProcessMemberLoanAcceptance(LoanToApprove) {
                $('<div id="divApproveLoanDialog"></div>').dialog({
                    modal: true,
                    title: "Accept/Reject Loan",
                    height: 700,
                    width: 500,
                    autoOpen: true,
                    show: {
                        effect: "drop",
                        direction: "up",
                        duration: 500
                    },

                    buttons: {
                        'OK': {
                            'text': 'OK',
                            'id': 'btnOK',
                            'click': function () {
                                var ConfirmMessage = "";
                                if (document.getElementById("cboMemberResponse").selectedIndex == 0) {
                                    alert("Select Response");
                                    return;
                                }
                                ConfirmMessage = "Please confirm you want to " + $("#cboMemberResponse option:selected").text() + " this loan?";

                                xDialogConfirm(ConfirmMessage, "Confirm").then(function () {
                                    xDialogMemberCredetials().then(function (data) {
                                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                                        var Password = data.UserPass;
                                        var pwdslt = getRandomInt(1000, 30000);
                                        pwdslt = pwdslt.toString();
                                        var pwd = CryptoJS.MD5(Password).toString();
                                        pwd = pwd + pwdslt;
                                        var sltpwd = CryptoJS.MD5(pwd).toString();

                                        var outData = {
                                            'DBName': LoanToApprove.DBName,
                                            'MemberNo': LoanToApprove.mLoanAppraisals.MemberNumber,
                                            'LoanSerialNumber': LoanToApprove.LoanSerialNumber,
                                            'Response': $("#cboMemberResponse").val(),
                                            'Salt': pwdslt,
                                            'Password': sltpwd
                                        }
                                        outData = JSON.stringify(outData);
                                        $.ajax({
                                            headers: { __RequestVerificationToken: csrfToken },
                                            type: "POST",
                                            url: "<%: Url.Content("~/api/MembersSystemApi/ProcessMemberLoanResponse") %>",
                                            data: outData,
                                            contentType: "application/json; charset=utf-8",
                                            dataType: "json",
                                            success: function (response) {
                                                $("#tblLoanProgress tr").each(function (i) {
                                                    var row = $(this);
                                                    if (row.find('td:eq(1)').text() == LoanToApprove.LoanSerialNumber) {
                                                        row.find('td:eq(8)').html("<a href='" + LoanToApprove.LoanSerialNumber + "' class='approveLink'>" + $("#cboMemberResponse").val() + "</a>");

                                                    }
                                                });
                                                alert("Response successfully updated");
                                                $("#divApproveLoanDialog").dialog("close");

                                            },
                                            error: function (xhr, status, error) {
                                                var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                                            }
                                        });
                                    });
                                });
                            }
                        },
                        Cancel: function () {
                            $(this).dialog("close");
                        }
                    },
                    open: function () {
                        var approved_amount = 0;
                        var recommended_amount = 0;
                        var repay_period = 1;

                        if (LoanToApprove.mAppraisalReport) {
                            recommended_amount = LoanToApprove.mAppraisalReport.RecommendedAmount;
                            repay_period = LoanToApprove.mAppraisalReport.RepaymentPeriod;
                        }
                        if (LoanToApprove.mApprovedLoans) {
                            approved_amount = LoanToApprove.mApprovedLoans.ApprovedAmount;
                            repay_period = LoanToApprove.mApprovedLoans.RepaymentPeriod;
                        }
                        var tbl = "<table id='tblApproveLoan' border=1>";
                        tbl += "<tbody>";
                        tbl += "<tr><td><b>Loan Serial Number:</b></td><td><input type='text' id='txtLoanSerialNumber' value='" + LoanToApprove.LoanSerialNumber + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loanee:</b></td><td><input type='text' id='txtLoaneeName' value='" + LoanToApprove.saccoMember.FullNames + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>MemberNo:</b></td><td><input type='text' id='txtLoaneeMemberNo' value='" + LoanToApprove.saccoMember.MemberNo + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>PayrollNo:</b></td><td><input type='text' id='txtLoaneePayrollNo' value='" + LoanToApprove.saccoMember.PayrollNo + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loan Type:</b></td><td><input type='text' id='txtLoanType' value='" + LoanToApprove.mLoanType.LoanTypeName + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Requested Amount:</b></td><td><input type='text' id='txtRequestedAmount' value='" + (+LoanToApprove.mLoanAppraisals.RequestedAmount).formatMoney() + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loan Status:</b></td><td><input type='text' id='txtLoanStatus' value='" + LoanToApprove.mLoanAppraisals.LoanStatus + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Recommended Amount</b></td><td><input type='text' id='txtRecommendedAmount' value='" + (+recommended_amount).formatMoney() + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Approved Amount</b></td><td><input type='text' id='txtApprovedAmount' value='" + (+approved_amount).formatMoney() + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Amt In Words:</b></td><td><div id='divAmountInWords' /></td></tr>";
                        tbl += "<tr><td><b>HR Ability:</b></td><td><input type='text' id='txtHRRepayAmt' value='" + LoanToApprove.mLoanAppraisals.HRRepayAmt + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>HR Approved:</b></td><td><input type='text' id='txtHRAbility' value='" + LoanToApprove.mLoanAppraisals.HRApproved + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Repayment Period:</b></td><td><input type='text' id='txtRepaymentPeriod' value='" + repay_period + "' /></td></tr>";
                        tbl += "<tr><td><b>Reponse:</b></td><td><select id='cboMemberResponse'><option value='' selected>(SELECT)</option><option value='accepted'>Accept</option><option value='rejected'>Reject</option></select></td></tr>";
                        tbl += "<tr><td><b>Notes/Reason:</b></td><td><textarea id='txtResponseReason' value='" + LoanToApprove.mLoanAppraisals.MemberAcceptanceComments + "' /></textarea></td></tr>";

                        tbl += "</tbody></table>";
                        $(this).html(tbl);
                        ShowAmtInWords();
                        $("#cboMemberResponse").focus;

                        function ShowAmtInWords() {
                            $("#divAmountInWords").html("");
                            try {
                                $("#divAmountInWords").html(toWords($("#txtApprovedAmount").val()));
                            } catch (err) {

                            }
                        }
                    },
                    close: function (event, ui) {
                        $(this).dialog("destroy").remove();
                    }
                });
            }

            function SaveMemberLoanApplication(credetials) {
                var LoanApplicationValid = true;
                var validCount = 0;
                var OffSetsList = new Array();
                var dblTotalAmount = 0;
                $("#tblOffsets tbody").find('tr').each(function (i) {
                    var OffSetEntry = {};
                    var row = $(this); //store in variable for faster access

                    OffSetEntry.BalType = row.find('td:eq(1)').text();
                    OffSetEntry.BalCode = row.find('td:eq(2)').text();
                    OffSetEntry.BalName = row.find('td:eq(3)').text();
                    OffSetEntry.BalAmount = row.find('td:eq(4)').text();
                    var txtAmt = row.find('td:eq(5)').find('input:eq(0)');


                    if (!isNumber(txtAmt.val())) {
                        LoanApplicationValid = false;
                        alert("Invalid offset amount at row " + i);
                        return;
                    }
                    var line_amount = txtAmt.val();
                    line_amount = +line_amount;
                    if (line_amount < 0) {
                        LoanApplicationValid = false;
                        alert("Offset Amount  " + line_amount + " should be more than or equal to Zero. At row " + i);
                        return;
                    }
                    if (row.find('input[type="checkbox"]').is(':checked')) {
                        if (line_amount > 0) {
                            dblTotalAmount = dblTotalAmount + line_amount;
                            OffSetEntry.TransAmount = line_amount;
                            OffSetsList[validCount] = OffSetEntry;
                            validCount++;
                        }
                    }
                });



                var GuarantorsList = new Array();
                var dblTotalAmount = 0;

                $("#tblGuarantors tbody").find('tr').each(function (i) {
                    var GuarantorEntry = {};
                    var row = $(this); //store in variable for faster access
                    GuarantorEntry.LoanSerialNumber = "";
                    GuarantorEntry.GuarantorMemberNumber = row.find('td:eq(0)').text();

                    var GuarantorAmt = row.find('td:eq(2)').text();
                    
                    if (!isNumber(GuarantorAmt)) { //contains commas at this point
                        LoanApplicationValid = false;
                        alert("Invalid Guarantor amount " + GuarantorAmt + " at row " + i);
                        return;
                    }
                    GuarantorAmt = ConvertMoneyToDouble(GuarantorAmt);
                    var line_amount = GuarantorAmt;
                    line_amount = +line_amount;
                    if (line_amount <= 0) {
                        LoanApplicationValid = false;
                        alert("Guarantor's Amount " + line_amount + " should be more than Zero. At row " + i);
                        return;
                    }


                    GuarantorEntry.SharesToCommit = line_amount;
                    GuarantorsList[i] = GuarantorEntry;


                });

                if (LoanApplicationValid == false) {
                    return;
                }
                var Password = credetials.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var outData = {
                    'Guarantors': GuarantorsList,
                    'OffSets': OffSetsList,
                    'LoanTypeCode': $("#cboLoanType").val(),
                    'LoanAmount': $("#txtLoanAmount").val(),
                    'RepaymentPeriod': $("#txtRepaymentPeriod").val(),
                    'LoanPurpose': $("#txtLoanPurpose").val(),
                    'Instructions': $("#txtInstructions").val(),
                    'NormineeUserID': $("#txtNormnieeUserID").val(),
                    'Password': sltpwd,
                    'Salt': pwdslt
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/SaveMemberLoanApplication") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        alert("Loan Application Saved");
                        InitForm();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });

            }

            function InitForm() {

                $("#cboLoanType").empty();
                $("#txtLoanAmount").val(0.00);
                $("#txtRepaymentPeriod").val(0.00);
                $("#txtRepaymentAmount").val(0.00);
                $("#txtInstructions").val("");
                $("#txtLoanPurpose").val("");
                $("#txtNormnieeUserID").val("");
                $("#cboYear").empty();
                $("#cboProgressYear").empty();
                $("#tblLoanProperties > tbody:last").children().remove();
                $("#tblOffsets > tbody:last").children().remove();
                $("#tblGuarantors > tbody:last").children().remove();
                $("#tblLoanApplicationList > tbody:last").children().remove();
                $("#tblSavedLoanGuarantors > tbody:last").children().remove();

                $("#divAmountInWords").empty();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanApplicationConfig") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var MemberDetails = response.MemberDetails;
                        var LoanTypeList = response.LoanTypes;
                        var MemberBalances = response.MemberBalances.MemberBals;
                        var Years = response.Years;
                        hod_managers_list = response.Managers;
                        $("#cboLoanType").empty();
                        $("#cboYear").empty();
                        $("#tblMemberBalances > tbody:last").children().remove();
                        $("#cboLoanType").append('<option selected>(SELECT LOAN)</option>');
                        $.each(LoanTypeList, function (index, LoanType) {
                            $("#cboLoanType").append("<option value='" + LoanType.LoanTypeCode + "'>" + LoanType.LoanTypeName + "</option'>");
                        });
                        var tbl_row = "";
                        $.each(MemberBalances, function (index, MemberBalance) {
                            if (MemberBalance.BalType.toString().toUpperCase() == "L".toUpperCase() || MemberBalance.BalType.toString().toUpperCase() == "I".toUpperCase()) {
                                tbl_row += "<tr><td><input type='checkbox' /></td><td>" + MemberBalance.BalType + "</td><td>" + MemberBalance.BalCode + "</td><td>" + MemberBalance.BalName + "</td><td>" + (+MemberBalance.BalAmount).formatMoney() + "</td><td><input type='text' value='" + MemberBalance.BalAmount + "' disabled /></td></tr>"
                            }
                        });
                        $("#bdOffsets").append(tbl_row);

                        $.each(Years, function (index, yr) {
                            $("#cboYear").append("<option value='" + yr.DBName + "' selected>" + yr.UserDefinedYearName + "</option'>");
                        });
                        $("#cboYear").get(0).selectedIndex = 0;
                        $.each(Years, function (index, yr) {
                            $("#cboProgressYear").append("<option value='" + yr.DBName + "' selected>" + yr.UserDefinedYearName + "</option'>");
                        });
                        $("#cboProgressYear").get(0).selectedIndex = 0;
                        $("#cboProgressYear").get(0).selectedIndex = 0; //first $("#cboProgressYear").get(0).selectedIndex = 0; not working
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }




            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
</asp:Content>




<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="container" style="padding-top: 2px">
        <h3>Loan Application</h3>
        <div class="row">
            <div id="div1" class="col-md-12 table-responsive">
                <div id="tabs">
                    <ul>
                        <li><a href="#tabs-1">Loan Application</a></li>
                        <li><a href="#tabs-2">Loan Application Status</a></li>
                        <li><a href="#tabs-3">Loan Progress</a></li>
                    </ul>
                    <form id="frmMain" name="frmMain">
                        <%= Html.AntiForgeryToken() %>
                        <div id="tabs-1" class="table-responsive" >
                            <table class="table">
                                <tr>
                                    <td>Loan Type:
                                    </td>
                                    <td>
                                        <select id="cboLoanType" />
                                    </td>
                                    <td rowspan="6">
                                        <div id="divLoanProperties" style="height: 300px; width: 500px;">
                                            Loan Properties
                                <table id='tblLoanProperties' class="table-bordered table-sm">
                                    <thead>
                                        <tr>
                                            <th><b>Property</b></th>
                                            <th><b>Value</b></th>
                                        </tr>
                                    </thead>
                                    <tbody id='bdLoanProperties'>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                    </tfoot>
                                </table>
                                            <hr />
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Loan Amount:
                                    </td>
                                    <td>
                                        <input type="text" id="txtLoanAmount" />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <%--style="height:200px;overflow:auto;width:auto;"--%>
                                        <div id="divAmountInWords"></div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Repay Period
                                    </td>
                                    <td>
                                        <input type="text" id="txtRepaymentPeriod" /></td>
                                </tr>
                                <tr>
                                    <td>Repayment Amount:
                                    </td>
                                    <td>
                                        <input type="text" id="txtRepaymentAmount" readonly="true" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>Purpose for Loan:
                                    </td>
                                    <td>
                                        <textarea id="txtLoanPurpose"></textarea>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Any Instructions:
                                    </td>
                                    <td>
                                        <textarea id="txtInstructions"></textarea>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Send Approval Request to PF. No:
                                    </td>
                                    <td>
                                        <input type="text" id="txtNormnieeUserID" /><input type="button" id="btnListManagers" value="Find" />
                                    </td>

                                </tr>
                                <tr>
                                    <td>Normiee Names:</td>
                                    <td>
                                        <div id="divNormineeName"></div>
                                    </td>
                                </tr>
                            </table>
                            <br />
                            <table style="width: auto" class="table">
                                <tr>
                                    <td colspan="5">
                                        <div id="divGuarantors" style="height: 200px; overflow: auto; width: 900px" class="table-responsive">
                                            <u>Guarantors</u>
                                            <table id='tblGuarantors' class="table">
                                                <thead>
                                                    <tr>
                                                        <th><b>MemberNo</b></th>
                                                        <th><b>Member Names</b></th>
                                                        <th><b>Pledged Amt.</b></th>
                                                        <th><b>Option</b></th>
                                                    </tr>
                                                </thead>
                                                <tbody id='bdGuarantors'>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <input type="button" id="btnAddGuarantor" value="Add Guarantor" />
                                    </td>

                                </tr>
                            </table>
                            <table style="width: auto" class="table">
                                <tr>
                                    <td colspan="5">
                                        <div id="divOffsets" style="height: 200px; overflow: auto; width: 1200px;">
                                            <u>Offsets</u>
                                            <table id='tblOffsets' class='display'>
                                                <thead>
                                                    <tr>
                                                        <th><b>X</b></th>
                                                        <th><b>Type</b></th>
                                                        <th><b>Code</b></th>
                                                        <th><b>Name</b></th>
                                                        <th><b>Amount</b></th>
                                                        <th><b>Offset</b></th>
                                                    </tr>
                                                </thead>
                                                <tbody id='bdOffsets'>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                            <table>
                                <tr>
                                    <td colspan="2"><input type="checkbox" id="chkLoanTOC" /> I have read, understood and accepted the <a href="~/LoansTOC.pdf">term and conditions </a></td>
                                    <td>
                                        <input type="button" value="Cancel Application" id="btnCancel" class="btn btn-danger" /></td>
                                    <td>
                                        <input type="button" value="Save Application" id="btnSave" class="btn btn-primary" disabled /></td>
                                </tr>
                            </table>
                        </div>
                        <div id="tabs-2">
                            <table border="1" style="padding: 1px; margin: 1px;" id="tblPeriod">
                                <tr>
                                    <td>Financial Year:</td>
                                    <td>
                                        <select id="cboYear">
                                            <option value="selectyear">SELECT YEAR</option>
                                        </select></td>
                                    <td>
                                        <input type="button" id="btnRefresh" value="Refresh" /></td>
                                    <td>
                                        <input type="button" id="btnAddMoreGuarantor" value="Add Guarantor" /></td>
                                    <td>
                                        <input type="button" id="btnCancelApplication" value="Cancel Application" /></td>
                                    <td>
                                        <input type="button" id="btnSubmitLoanApplication" value="Submit Application" /></td>
                                </tr>
                            </table>
                            <div id="divLoanApplicationList" style="height: 200px; overflow: auto; width: auto;">
                                <br />
                                <b>Loan Application List</b>
                                <br />
                                <br />
                                <table id='tblLoanApplicationList' class='display'>
                                    <thead>
                                        <tr>
                                            <th><b>RefNo</b></th>
                                            <th><b>Date</b></th>
                                            <th><b>Loan Type</b></th>
                                            <th><b>Amount</b></th>
                                            <th><b>Loan Status</b></th>
                                            <th><b>Manager Status</b></th>
                                        </tr>
                                    </thead>
                                    <tbody id='bdLoanApplicationList'>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <div id="lblLoanRefNo"></div>
                            <div id="divSavedLoanGuarantors" style="height: 200px; overflow: auto; width: auto;">
                                <b>Guarantors</b><hr style="color: red" />
                                <table id='tblSavedLoanGuarantors' class='display'>
                                    <thead>
                                        <tr>
                                            <th><b>Guarantor No</b></th>
                                            <th><b>Guarantor Name</b></th>
                                            <th><b>Requested Amt</b></th>
                                            <th><b>Accepted Amt</b></th>
                                            <th><b>Status</b></th>
                                            <th><b>Notes</b></th>
                                            <th><b>Remove</b></th>
                                        </tr>
                                    </thead>
                                    <tbody id='bdSavedLoanGuarantors'>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                    </tfoot>
                                </table>

                            </div>
                            <br />
                            <div id="divOtherLoanProperties" style="height: 150px; overflow: auto; width: auto;">
                                Other Loan Properties<hr style="color: red" />
                                <table id='tblOtherLoanProperties' class='display'>
                                    <thead>
                                        <tr>
                                            <th><b>Property</b></th>
                                            <th><b>Value</b></th>

                                        </tr>
                                    </thead>
                                    <tbody id='bdOtherLoanProperties'>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        <div id="tabs-3">
                            <table border="1" style="padding: 1px; margin: 1px;" id="tblProgressPeriod">
                                <tr>
                                    <td>Financial Year:</td>
                                    <td>
                                        <select id="cboProgressYear">
                                            <option value="">SELECT YEAR</option>
                                        </select></td>
                                    <td>Loan Status</td>
                                    <td>
                                        <select id="cboLoanProgressStatus">
                                            <option value="" selected>(ALL)</option>
                                            <option value="In-Service">Active</option>
                                            <option value="appraised">Appraised</option>
                                            <option value="approved">Approved</option>
                                            <option value="rejected">Rejected</option>
                                        </select></td>
                                    <td>
                                        <input type="button" id="btnProgressRefresh" value="Refresh" /></td>
                                </tr>
                            </table>
                            <div id="divLoanProgress" style="height: 400px; overflow: auto; width: auto;">
                                <table id='tblLoanProgress' class='display'>
                                    <thead>
                                        <tr>
                                            <th><b>Loan Number</b></th>
                                            <th><b>App.No</b></th>
                                            <th><b>Date</b></th>
                                            <th><b>Loan Type</b></th>
                                            <th><b>Status</b></th>
                                            <th><b>Requested</b></th>
                                            <th><b>Recommended</b></th>
                                            <th><b>Approved</b></th>
                                            <th><b>Acceptance</b></th>
                                            <th><b>Offer Letter</b></th>
                                        </tr>
                                    </thead>
                                    <tbody id='bdLoanProgress'>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <div id="divLoanDetails" style="height: 100px; overflow: auto; width: auto;">
                                <%--Place holder for Appraisal Report--%>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</asp:Content>


