﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Dividends Report
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .td_amount_col {
            text-align: right;
        }
        
    </style>
    <script type="text/javascript"  >
        $(document).ready(function () {
            $("#btnPrint").click(function () {
                //$("#mySelector").printThis({
                //debug: false,              * show the iframe for debugging
                //importCSS: true,           * import page CSS
                //printContainer: true,      * grab outer container as well as the contents of the selector
                //loadCSS: "path/to/my.css", * path to additional css file
                //pageTitle: "",             * add title to print page
                //removeInline: false        * remove all inline styles from print elements

                var rptHeader = "" + CompanyName + "<br>" + CompanyAddress + "</br>" + "Dividends Report: " + $("#cboYear option:selected").text() + "" + $("#divAccountInfo").html();
                $("#divDividends").printThis({
                    debug: false,
                    pageTitle: "Report",
                    removeInline: true,
                    printContainer: true,
                    importCSS: true,
                    header: rptHeader
                });

            });
            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: '<%: Url.Content("~/api/MembersSystemApi/GetYears") %>',
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    DispDividends();
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                }
            });

            $("#cboYear").on("change", function () {
                DispDividends();
            });
            

            

            function DispDividends() {
                row = 1;
                $('#divAccountInfo').html("");
                $("#tblDividends > tbody:last").children().remove();
                

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url:'<%: Url.Content("~/api/MembersSystemApi/GetMemberDividendsDetails") %>',
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        row = 1;
                        $('#divAccountInfo').empty();
                        $("#tblDividends > tbody:last").children().remove();
                        if (response.MemberDetails != null) {
                            $("#memName").text(response.MemberDetails.FullNames);
                            $("#memNo").text(response.MemberDetails.MemberNo);
                            $("#payrollNo").text(response.MemberDetails.PayrollNo);
                            $("#idNo").text(response.MemberDetails.IDNumber);
                           
                        }

                        var lineitems = response.DividendsItems;
                        var statref = "";
                        var total = 0;
                        var inttotal = 0;
                        var tbl_row = "";

                        

                        $.each(lineitems, function (index, lineitem) {
                            row = row + index;
                            /*
                            if (statref != lineitem.StatRef) {
                                total = 0;
                                inttotal = 0;
                                statref = lineitem.StatRef;

                                if (index != 0) {
                                    tbl_row = "<tr>";
                                    tbl_row += "<td colspan=8><hr/></td>";
                                    tbl_row += "</tr>";
                                }

                                tbl_row = "<tr>";
                                tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.RefCode + "</td>";
                                tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.RefName + "</td>";
                                tbl_row += "<td style='text-align: left;padding:7px'>Doc. No.</td>";
                                tbl_row += "<td class='td_amount_col' style='padding:7px'>Debit</td>";
                                tbl_row += "<td class='td_amount_col' style='padding:7px'>Credit</td>";
                                tbl_row += "<td class='td_amount_col' style='padding:7px'>Balance</td>";
                                tbl_row += "<td class='td_amount_col' style='padding:7px'>Int. Debit</td>";
                                tbl_row += "<td class='td_amount_col' style='padding:7px'>Int. Credit</td>";
                                tbl_row += "<td class='td_amount_col' style='padding:7px'>Balance</td>";
                                tbl_row += "</tr>";
                                $("#bdDividends").append(tbl_row);
                            }

                            if (statref.substring(0, 1) == "S") {
                                total = +total + +lineitem.Debit + +lineitem.Credit;
                                inttotal = +inttotal + +lineitem.IntDebit + +lineitem.IntCredit;
                            } else {
                                total = +total + +lineitem.Debit - +lineitem.Credit;
                                inttotal = +inttotal + +lineitem.IntDebit - +lineitem.IntCredit;
                            }
                            */

                            tbl_row += "<tr>";
                            tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.SchemeCode + "</td>";
                            tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.SchemeName + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.TotalDeposits.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.Rate.formatMoney() + "</td>";
                            tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.MethodUsed + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.GrossAmount.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.TotalTaxCharged.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.ProcessingFees.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.NetAmount.formatMoney() + "</td>";
                            tbl_row += "</tr>";
                            
                            

                        });


                        tbl_row += "<tr>";
                        tbl_row += "<td colspan=9><i>**************End of Report***********</i></td>";
                        tbl_row += "</tr>";
                        $("#bdDividends").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });


            }

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
            
        });
    </script>
</asp:Content>




<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    
<div class="card p-0 m-4">
    <h5 class="p-3 fs-5">Dividends Report</h5>
      
    <hr class="m-0 p-0">
    <div class="p-3">
    <div class="row">

            <div id="div1" class="col-md-12 table-responsive ">
                <form id="frmDividends" name="frmDividends">
                <%= Html.AntiForgeryToken() %>
                    
                        
                            <h4 class="fs-6 text-decoration-underline">Financial Period</h4>
                     <div class="row">
                            <div class="col-md mt-1">
                                <label for=" Financial Year" class="form-label" > Financial Year</label>
        
                            <select id="cboYear" class="form-select"><option value="selectyear">SELECT YEAR</option></select>
                            </div>
                            <div class="col-md mt-1">
                                <div class="col-md">
                                    <label for="" class="form-label">Print Report</label>
                           
                                </div>

                                <div class="col-md">
                                    <input type="button" id="btnPrint" value="Print Report" class="btn btn-success"/>
                           
                        
                                </div>

                                 
                        
                        
                        </div>
                     </div>


                        
                                 <div class="row mt-4">
                            <div class="col-md-4 mt-1">
                                <label for="Member Info" class="form-label" >Member Info</label>
        
              
                            <div id="divAccountInfo">
                                
                            </div>
                            </div>
                            </div>
                   
                </form>
            </div>
        </div>
       <br />
        <div class="row">
            <div class="col-md-12 table-responsive" id="divDividends">
                <table id='tblDividends' class="table table-striped table-bordered table-sm row-fluid text-nowrap">
                        <thead>
                            <tr>
                            <th style="text-align: left;padding:7px">Code</th>
                            <th style="text-align: left;padding:7px">Type</th>
                            <th style="text-align: right;padding:7px">Amount Used</th>
                            <th style="text-align: right;padding:7px">Rate</th>
                            <th style="text-align: left;padding:7px">Method</th>
                            <th style="text-align: right;padding:7px">Gross</th>
                            <th style="text-align: right;padding:7px">Tax</th>
                            <th style="text-align: right;padding:7px">Fees</th>
                            <th style="text-align: right;padding:7px">Net</th>
                            </tr>
                        </thead>
                        <tbody id='bdDividends'>
                        </tbody>
                    
                </table>
            </div>
        </div>
    
    </div>
</div>


</asp:Content>


