﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Payments And Cash Transfers
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
         
        .td_amount_col {
            text-align: right;
        }
        
    </style>

    
    <script type="text/javascript"  >
        $(document).ready(function () {
            var AllBalancesList = null;
            var MemberData = null;

            var bolIsSaccoBalozi =<%= (XtremeERP.Common.Utilities.Utils.bolIsSaccoBalozi ? "true" : "false") %>;
            

            $("#panelLoanDetails").hide();
            $("#panelSchemeDetails").hide();
            $("#panelDestinationAccDetails").hide();
            $("#panelOtherMemberDetails").hide();
            $("#panelExternalBankDetails").hide();
            $("#panelMobileMoney").hide();
            $("#panelUtilityPayment").hide();

            InitSummary();
            ResetControls();

            $("#cboTransactionType").on('change click', function (event) {
                event.preventDefault();
                $("#panelLoanDetails").hide();
                $("#panelSchemeDetails").hide();
                $("#panelDestinationAccDetails").hide();
                $("#panelOtherMemberDetails").hide();
                $("#panelExternalBankDetails").hide();
                $("#panelMobileMoney").hide();
                $("#panelUtilityPayment").hide();
               
                var selectedIndex = $("#cboTransactionType option:selected").index();

                $("#txtMobileMoneyPhoneNo").prop('disabled', true); //we can allow user input if sacco allows transfer to other numbers -TODO: parameterize
                if (MemberData != null) {
                    $("#txtMobileMoneyPhoneNo").val(MemberData.GeneralSummary.MemberDetails.PhoneNo);

                } 


                if (selectedIndex == 1) { //own transfer
                    $("#panelDestinationAccDetails").show();
                } else if (selectedIndex == 2) { //pay loan
                    $("#panelLoanDetails").show();
                } else if (selectedIndex == 3) { //pay shares
                    $("#panelSchemeDetails").show();
                } else if (selectedIndex == 4) { //pay other member
                    $("#panelOtherMemberDetails").show();
                } else if (selectedIndex == 5) { //transfer to other banks
                    $("#panelExternalBankDetails").show();
                } else if (selectedIndex == 6) { //transfer to Mobile Money
                    $("#panelMobileMoney").show();
                } else if (selectedIndex == 7) { //Utility Payments
                    $("#panelUtilityPayment").show();
                }

            });


            function ResetControls() {
                $("#cboTransactionType").prop('selectedIndex', 0);
                $("#cboUtilityPaymentType").prop('selectedIndex', 0);
                $("#cboMobileProvider").prop('selectedIndex', 0);
                $("#cboOtherBanks").prop('selectedIndex', 0);

                $("#cboOwnSchemes").prop('selectedIndex', 0);
                $("#cboPayLoanSerialNo").prop('selectedIndex', 0);
                $("#cboSourceAccount").prop('selectedIndex', 0);

                $("#spnOtherAccNo").text("");
                $("#spnOtherAccDetails").text("");
                $("#txtOtherDestinationAccount").val("");
                $("#txtAmount").val("0.00");
                $("#txtBeneficiaryName").val("");
                $("#txtNotes").val("");
                $("#txtUtilityPaymentAcc").val("");
                $("#txtBeneficiaryNo").val("");
                $("#txtMobileMoneyPhoneNo").val("");
                $("#txtExternalAccountNo").val("");

                $("#lblSchemeAccDetails").text("");
                $("#lblLoanDetails").text("");
                $("#lblSourceAccDetails").text("");
                $("#lblOwnDestinationAccountDetails").text("");



                

            }

            $("#cboSourceAccount").on('change click', function (e) {
                $("#lblSourceAccDetails").text("");
                if (AllBalancesList != null)
                {
                    var FosaAccDetails = AllBalancesList.filter(function (BalType) {
                        return (BalType.BalType == "F") && (BalType.BalCode == $("#cboSourceAccount").val());
                    });
                    if (FosaAccDetails != null) {
                        if (FosaAccDetails.length > 0) {
                            $("#lblSourceAccDetails").text("Account Balance: " + FosaAccDetails[0].BalAmount.formatMoney());
                        }
                    }
                }
            });
            $("#cboOwnDestinationAccount").on('change click', function (e) {
                $("#lblOwnDestinationAccountDetails").text("");
                var FosaAccDetails = AllBalancesList.filter(function (BalType) {
                    return (BalType.BalType == "F") && (BalType.BalCode == $("#cboOwnDestinationAccount").val());
                });
                if (FosaAccDetails != null) {
                    if (FosaAccDetails.length > 0) {
                        $("#lblOwnDestinationAccountDetails").text("Account Balance: " + FosaAccDetails[0].BalAmount.formatMoney());
                    }
                }
            });
            $("#cboOwnSchemes").on('change click', function (e) {
                $("#lblSchemeAccDetails").text("");
                var SchemeAccDetails = AllBalancesList.filter(function (BalType) {
                    return (BalType.BalType == "S") && (BalType.BalCode == $("#cboOwnSchemes").val());
                });
                if (SchemeAccDetails != null) {
                    if (SchemeAccDetails.length > 0) {
                        $("#lblSchemeAccDetails").text("Account Balance: " + SchemeAccDetails[0].BalAmount.formatMoney());
                    }
                }
            });

            $("#cboPayLoanSerialNo").on('change click', function (e) {
                $("#lblLoanDetails").text("");
                var LoanDetails = AllBalancesList.filter(function (BalType) {
                    return (BalType.BalType == "L") && (BalType.BalCode == $("#cboPayLoanSerialNo").val());
                });
                if (LoanDetails != null) {
                    if (LoanDetails.length > 0) {
                        $("#lblLoanDetails").text("Loan Balance: " + LoanDetails[0].BalAmount.formatMoney() + "     Interest Balance: " + LoanDetails[0].InterestBalance.formatMoney());
                    }
                }
            });
            $("#btnPost").on('click', function (e) {
                e.preventDefault();
                var CashTransferDetails = {};
                var TransTypeSelectedIndex = $("#cboTransactionType option:selected").index();
                if (TransTypeSelectedIndex == 0) {
                    alert("Select Transaction Type");
                    return;
                }
                var ConfirmMessage = "";
                ConfirmMessage = "Transaction Type: " + $("#cboTransactionType  option:selected").text() + "<br/>";

                CashTransferDetails.TransType = $("#cboTransactionType").val();
                CashTransferDetails.TransTypeDesc = $("#cboTransactionType  option:selected").text();

                var selectedIndex = $("#cboSourceAccount option:selected").index();
                if (selectedIndex == 0) {
                    alert("Select Source Account");
                    return;
                }
                ConfirmMessage += "Source Account: " + $("#cboSourceAccount").val() + "<br/>";

                CashTransferDetails.SourceAccount = $("#cboSourceAccount").val();

                if (!isNumber(ConvertMoneyToDouble($("#txtAmount").val()))) {
                    alert("Invalid Paymet Amount");
                    return;
                }
                if (ConvertMoneyToDouble($("#txtAmount").val())<0.00) {
                    alert("Invalid Paymet Amount");
                    return;
                }

                CashTransferDetails.Amount = ConvertMoneyToDouble($("#txtAmount").val());

                if (TransTypeSelectedIndex == 1) { //own transfer
                    var selectedIndex = $("#cboOwnDestinationAccount option:selected").index();
                    if (selectedIndex == 0) {
                        alert("Select Destination Account");
                        return;
                    }
                    if ($("#cboOwnDestinationAccount").val() == $("#cboSourceAccount").val()) {
                        alert("Source Account should not be the same to Destination Account");
                        return;
                    }
                    ConfirmMessage += "Destination Account: " + $("#cboOwnDestinationAccount").val() + "<br/>";

                    CashTransferDetails.DestinationAccount = $("#cboOwnDestinationAccount").val();
                } else if (TransTypeSelectedIndex == 2) { //pay loan
                    var selectedIndex = $("#cboPayLoanSerialNo option:selected").index();
                    if (selectedIndex == 0) {
                        alert("Select Loan Account");
                        return;
                    }
                    ConfirmMessage += "Loan Account: " + $("#cboPayLoanSerialNo option:selected").text() + "<br/>";

                    CashTransferDetails.PayLoanIdentifier = $("#cboPayLoanSerialNo").val();


                } else if (TransTypeSelectedIndex == 3) { //pay shares
                    var selectedIndex = $("#cboOwnSchemes option:selected").index();
                    if (selectedIndex == 0) {
                        alert("Select Shares Account");
                        return;
                    }
                    ConfirmMessage += "Shares/Deposits Account: " + $("#cboOwnSchemes option:selected").text() + "<br/>";
                    CashTransferDetails.PaySchemeCode = $("#cboOwnSchemes").val();

                } else if (TransTypeSelectedIndex == 4) { //pay other member
                    if ($("#txtOtherDestinationAccount").val().trim() == "") {
                        alert("Enter Account No To Pay");
                        return;
                    }

                    ConfirmMessage += "Account To Pay: " + $("#spnOtherAccNo").text().trim(); + "<br/>";
                    ConfirmMessage += "Account Name: " + $("#spnOtherAccDetails").text().trim() + "<br/>";
                    CashTransferDetails.DestinationAccount = $("#spnOtherAccNo").text().trim();
                } else if (TransTypeSelectedIndex == 5) { //transfer to other banks
                    var selectedIndex = $("#cboOtherBanks option:selected").index();
                    if (selectedIndex == 0) {
                        alert("Select Bank To Pay");
                        return;
                    }
                    $("#txtExternalAccountNo").val($("#txtExternalAccountNo").val().trim())  ;
                    if ($("#txtExternalAccountNo").val() == "") {
                        alert("Privde a valid bank account");
                        return;
                    }
                    ConfirmMessage += "Pay Other Bank: " + $("#cboOtherBanks option:selected").text() + "<br/>";
                    ConfirmMessage += "Bank Account No: " + $("#txtExternalAccountNo").val() + "<br/>";

                    CashTransferDetails.BankCode = $("#cboOtherBank").val();
                    CashTransferDetails.BankName = $("#cboOtherBanks option:selected").text();
                    CashTransferDetails.BankAccountNo = $("#txtExternalAccountNo").val();

                } else if (TransTypeSelectedIndex == 6) { //transfer to Mobile Money
                    var selectedIndex = $("#cboMobileProvider option:selected").index();
                    if (selectedIndex == 0) {
                        alert("Select Bank To Pay");
                        return;
                    }
                    $("#txtMobileMoneyPhoneNo").val($("#txtMobileMoneyPhoneNo").val().trim())  ;
                    if ($("#txtMobileMoneyPhoneNo").val() == "") {
                        alert("Provide a valid Mobile Payment Phone No");
                        return;
                    }
                    ConfirmMessage += "Send To Mobile: " + $("#cboMobileProvider option:selected").text() + "<br/>";
                    ConfirmMessage += "Mobile No: " + $("#txtMobileMoneyPhoneNo").val() + "<br/>";

                    CashTransferDetails.MobileMoneyProvider = $("#cboMobileProvider").val();
                    CashTransferDetails.MobileMoneyPhoneNo = $("#txtMobileMoneyPhoneNo").val();

                } else if (TransTypeSelectedIndex == 7) { //Utility Payments
                    var selectedIndex = $("#cboUtilityPaymentType option:selected").index();
                    if (selectedIndex == 0) {
                        alert("Select Utility Payment Type");
                        return;
                    }
                    $("#txtUtilityPaymentAcc").val($("#txtUtilityPaymentAcc").val().trim()) ;
                    if ($("#txtUtilityPaymentAcc").val() == "") {
                        alert("Provide a valid Utility Payment Account");
                        return;
                    }
                    ConfirmMessage += "Utility Payment: " + $("#cboUtilityPaymentType option:selected").text() + "<br/>";
                    ConfirmMessage += "Utility Payment Account No: " + $("#txtUtilityPaymentAcc").val() + "<br/>";

                    CashTransferDetails.UtilityPaymentType = $("#cboUtilityPaymentType").val();
                    CashTransferDetails.UtilityPaymentAcc = $("#txtUtilityPaymentAcc").val();
                } else {
                    alert ("UnKnown Action");
                }

                $("#txtNotes").val($("#txtNotes").val().trim()) ;
                $("#txtBeneficiaryNo").val($("#txtBeneficiaryNo").val().trim()) ;
                $("#txtBeneficiaryName").val($("#txtBeneficiaryName").val().trim()) ;

                CashTransferDetails.Notes = $("#txtNotes").val();
                CashTransferDetails.BeneficiaryNo = $("#txtBeneficiaryNo").val();
                CashTransferDetails.BeneficiaryName = $("#txtBeneficiaryName").val();

                ConfirmMessage += "Transfer Amount: " + ConvertMoneyToDouble($("#txtAmount").val()).formatMoney() + "<br/>";

                xDialogConfirm(ConfirmMessage, "Confirm").then(function () {
                    xDialogMemberCredetials().then(function (data) {

                        var Password = data.UserPass;
                        var pwdslt = getRandomInt(1000, 30000);
                        pwdslt = pwdslt.toString();
                        var pwd = CryptoJS.MD5(Password).toString();
                        pwd = pwd + pwdslt;
                        var sltpwd = CryptoJS.MD5(pwd).toString();
                        
                        CashTransferDetails.Salt = pwdslt;
                        CashTransferDetails.Password = sltpwd;

                        CashTransferDetails.TransOTPCode = "";

                        var TransTypeIndex = $("#cboTransactionType option:selected").index();

                        /*Require authorization on all transactions coz funds are leaving from account
                        if (TransTypeIndex > 3) { //any transaction that does not credit member require additional OTP Code
                            xDialogGetMemberAuthorizationCode().then(function (data) {
                                var userOTPCode = data.AuthCode.toString();
                                CashTransferDetails.TransOTPCode = userOTPCode;
                                DoSaveCustomerTransfer(CashTransferDetails);
                            });
                        } else {
                            DoSaveCustomerTransfer(CashTransferDetails);
                        }
                        */

                        xDialogGetMemberAuthorizationCode().then(function (data) {
                            var userOTPCode = data.AuthCode.toString();
                            CashTransferDetails.TransOTPCode = userOTPCode;
                            DoSaveCustomerTransfer(CashTransferDetails);
                        });
                        
                    });
                });
            });


            function DoSaveCustomerTransfer(cashTransferDetails) {
                var TransferDetails = JSON.stringify(cashTransferDetails);
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/PostCustomerCashTransfer") %>",
                    data: TransferDetails,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        alert(response.UserMessage);
                        LoadControls(response.MemberSummary)
                        ResetControls();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }


            $("#btnSearchOtherAcc").on('click', function (e) {
                e.preventDefault();
                    DispOtherOccountDetails();
                });

                $("#txtOtherDestinationAccount").on('focusout', function () {
                    DispOtherOccountDetails();
                 });

                $("#txtOtherDestinationAccount").on('change keypress keyup', function () {
                    $("#spnOtherAccNo").text("");
                    $("#spnOtherAccDetails").text("");
                });

            function DispOtherOccountDetails() {
                if ($("#txtOtherDestinationAccount").val().trim() == "") {
                    //alert("Enter Account No");
                    return;
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var outData = {
                    'SearchValue': $("#txtOtherDestinationAccount").val()
                }
                outData = JSON.stringify(outData);

                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/SearchCustomerAccountByAccountNo") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        if (response == null) {
                            alert("Account Not found");
                        } else { 
                            //alert(JSON.stringify(response));
                            $("#spnOtherAccNo").text(response.AccountNo);
                            $("#spnOtherAccDetails").text(response.AccountName);

                        }
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }

            
        
            function InitSummary() {

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberSummary") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        
                        LoadControls(response);
                        
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

            }

            function LoadControls(data) {
                MemberData = data;
                AllBalancesList = data.GeneralSummary.MemberBals;
                var FosaAccounts = AllBalancesList.filter(function (BalType) {
                    return (BalType.BalType == "F") && (BalType.AccountType == "Savings Accounts") && (BalType.AccountStatus == "ACTIVE");
                });
                //alert(JSON.stringify(data.GeneralSummary.MemberBals));

                $("#cboSourceAccount").empty();
                $("#cboSourceAccount").append('<option selected>(SELECT ACOUNT)</option>');
                $.each(FosaAccounts, function (index, fosaAcc) {
                    $("#cboSourceAccount").append("<option value='" + fosaAcc.BalCode + "'>" + fosaAcc.Description + "</option>");
                });

                $("#cboOwnDestinationAccount").empty();
                $("#cboOwnDestinationAccount").append('<option selected>(SELECT ACOUNT)</option>');
                $.each(FosaAccounts, function (index, fosaAcc) {
                    $("#cboOwnDestinationAccount").append("<option value='" + fosaAcc.BalCode + "'>" + fosaAcc.Description + "</option>");
                });

                var LoanAccounts = AllBalancesList.filter(function (BalType) {
                    return (BalType.BalType == "L");
                });

                $("#cboPayLoanSerialNo").empty();
                $("#cboPayLoanSerialNo").append('<option selected>(SELECT LOAN)</option>');
                $.each(LoanAccounts, function (index, loanAcc) {
                    $("#cboPayLoanSerialNo").append("<option value='" + loanAcc.BalCode + "'>" + loanAcc.BalName + "(" + loanAcc.BalCode + ")</option>");
                });

                var SavingSchemeAccounts = AllBalancesList.filter(function (BalType) {
                    return (BalType.BalType == "S");
                });

                $("#cboOwnSchemes").empty();
                $("#cboOwnSchemes").append('<option selected>(SELECT SCHEME)</option>');
                $.each(SavingSchemeAccounts, function (index, schemeAcc) {
                    $("#cboOwnSchemes").append("<option value='" + schemeAcc.BalCode + "'>" + schemeAcc.BalName + "(" + schemeAcc.BalCode + ")</option>");
                });


            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });

        });
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    
        <%= Html.AntiForgeryToken() %> 
        <% XtremeERP.Common.Data.SaccoSettings saccoSettings = ViewBag.saccoSettings as XtremeERP.Common.Data.SaccoSettings; %>
        <% XtremeERP.Common.Data.SaccoMember saccoMember = ViewBag.SaccoMember as XtremeERP.Common.Data.SaccoMember; %>
        <% XtremeERP.Common.Data.MemberPortalSettings portalSettings = ViewBag.PortalSettings as XtremeERP.Common.Data.MemberPortalSettings; %>




    <div class="row">

        <div class="col-md-8 col-md-offset-2">
            <br />
            <h4><u>Payments And Cash Transfers</u></h4>
            <br />
            
            <form class="form-horizontal">
	                        <div class="form-group">
                                <label class="control-label col-sm-2" for="cboTransactionType">Select Transaction Type:</label>
		                        <div class="col-sm-10">
                                    <select id="cboTransactionType" class="form-control" >
                                        <option value="" selected>(SELECT)</option>
                                        <option value="transfer_to_own_account">Transfer to Own FOSA Accounts</option>
                                        <option value="pay_loan">Pay Loan</option>
                                        <option value="pay_shares">Pay Shares</option>
                                        <option value="transfer_to_other_internal_fosa_accounts">Transfer to Other FOSA Accounts</option>
                                        <option value="transfer_to_other_bank_accounts">Transfer to Other Bank Accounts</option>
                                        <option value="transfer_to_mobile">Transfer to Mobile</option>
                                        <option value="utility_payment">Utility Payments</option>
                                    </select>
		                        </div>
	                        </div>
                         </form>

            <br />
            <br />
            <div class="panel-group">
                <div id="panelSourceAccDetails" class="panel panel-default">
                    <div class="panel-heading">Source Account Details</div>
                    <div class="panel-body">
                        <form class="form-horizontal">
	                        <div class="form-group">
		                        <label class="control-label col-sm-2" for="cboSourceAccount">Select Source Acc :</label>
		                        <div class="col-sm-10">
                                    <select id="cboSourceAccount"  class="form-control" >
                                        <option selected>(SELECT)</option>
                                    </select>
		                        </div>
	                        </div>
                            <div class="form-group">
		                        <label class="control-label col-sm-2">Account Details:</label>
		                        <div class="col-sm-10">
                                    <label class="control-label col-sm-10" id="lblSourceAccDetails"></label>
		                        </div>
	                        </div>
                         </form>
                    </div>
                </div>
                <div id="panelLoanDetails" class="panel panel-default">
                    <div class="panel-heading">Select Loan</div>
                    <div class="panel-body">
                        <form class="form-horizontal">
	                        <div class="form-group">
		                        <label class="control-label col-sm-2" for="cboPayLoanSerialNo">Select Loan Acc:</label>
		                        <div class="col-sm-10">
                                    <select id="cboPayLoanSerialNo"  class="form-control" >
                                        <option selected>(SELECT)</option>
                                    </select>
		                        </div>
	                        </div>
                            <div class="form-group">
		                        <label class="control-label col-sm-2">Loan Details:</label>
		                        <div class="col-sm-10">
                                    <label class="control-label col-sm-10" id="lblLoanDetails"></label>
		                        </div>
	                        </div>
                         </form>
                    </div>
                </div>
                <div id="panelSchemeDetails" class="panel panel-default">
                    <div class="panel-heading">Select Scheme</div>
                    <div class="panel-body">
                        
                        <form class="form-horizontal">
	                        <div class="form-group">
		                        <label class="control-label col-sm-2" for="cboOwnSchemes">Select Scheme Acc:</label>
		                        <div class="col-sm-10">
                                    <select id="cboOwnSchemes"  class="form-control" >
                                        <option selected>(SELECT)</option>
                                    </select>
		                        </div>
	                        </div>
                            <div class="form-group">
		                        <label class="control-label col-sm-2">Scheme Details:</label>
		                        <div class="col-sm-10">
                                    <label class="control-label col-sm-10" id="lblSchemeAccDetails"></label>
		                        </div>
	                        </div>
                         </form>
                    </div>
                </div>
            </div>
            <div id="panelDestinationAccDetails" class="panel panel-default">
                <div class="panel-heading">Select Destinantion Account</div>
                <div class="panel-body">
                    <div class="panel-body">
                        <form class="form-horizontal">
	                        <div class="form-group">
		                        <label class="control-label col-sm-2" for="cboOwnDestinationAccount">Select Destination Acc :</label>
		                        <div class="col-sm-10">
                                    <select id="cboOwnDestinationAccount"  class="form-control" >
                                        <option selected>(SELECT)</option>
                                    </select>
		                        </div>
                                <div class="form-group">
		                        <label class="control-label col-sm-2">Account Details:</label>
		                        <div class="col-sm-10">
                                    <label class="control-label col-sm-10" id="lblOwnDestinationAccountDetails"></label>
		                        </div>
	                        </div>
	                        </div>
                         </form>
                    </div>
                </div>
            </div>
            <div id="panelOtherMemberDetails" class="panel panel-default">
                <div class="panel-heading">Transfer to FOSA Account</div>
                <div class="panel-body">
                    <form class="form-horizontal">
	                        <div class="form-group">
		                        <label class="control-label col-sm-2" for="txtOtherDestinationAccount">Enter FOSA Acc:</label>
		                        <div class="col-sm-8">
                                    <input type="text" class="form-control"  id="txtOtherDestinationAccount" placeholder="Recipient Account No." />
		                        </div>
                                <div class="col-sm-2">
                                    <button id="btnSearchOtherAcc" class="form-control">Search Account</button>
		                        </div>
	                        </div>
                            <div class="form-group">
		                        <label class="control-label col-sm-2" >Account No:</label>
		                        <div class="col-sm-8">
                                    <span id="spnOtherAccNo">
                                    </span>
		                        </div>
	                        </div>
                        <div class="form-group">
		                        <label class="control-label col-sm-2" >Account Name:</label>
		                        <div class="col-sm-8">
                                    <span id="spnOtherAccDetails">
                                    </span>
		                        </div>
	                        </div>

                         </form>
                </div>
            </div>
            <div id="panelExternalBankDetails" class="panel panel-default">
                <div class="panel-heading">Bank Details</div>
                <div class="panel-body">
                    <form class="form-horizontal">
                        <div class="form-group">
		                        <label class="control-label col-sm-2" for="cboOtherBanks">Select Recipient Bank:</label>
		                        <div class="col-sm-10">
                                    <select id="cboOtherBanks"   class="form-control" >
                                        <option value="" selected>(SELECT)</option>
                                        <option value="kcb">KCB</option>
                                        <option value="coopbank">CO-OP BANK</option>
                                        <option value="equitybank">EQUITY BANK</option>
                                    </select>
		                        </div>
	                        </div>
	                        <div class="form-group">
		                        <label class="control-label col-sm-2" for="txtExternalAccountNo">Bank Account No:</label>
		                        <div class="col-sm-10" >
                                    <input type="text"   class="form-control" id="txtExternalAccountNo" placeholder="Enter Bank Account No" >
		                        </div>
	                        </div>
                        
                         </form>
                </div>
            </div>
            <div id="panelMobileMoney" class="panel panel-default">
                <div class="panel-heading">Mobile Money Transfer</div>
                <div class="panel-body">
                    <form class="form-horizontal">
                        <div class="form-group">
		                        <label class="control-label col-sm-2" for="cboMobileProvider">Select Mobile Provider:</label>
		                        <div class="col-sm-10">
                                    <select id="cboMobileProvider"   class="form-control" >
                                        <option value="" selected>(SELECT)</option>
                                        <option value="mpesa">MPESA</option>
                                        <option value="airtelmoney">AIRTEL MONEY</option>
                                    </select>
		                        </div>
	                        </div>
	                        <div class="form-group">
		                        <label class="control-label col-sm-2" for="txtMobileMoneyPhoneNo">Recipient Phone No:</label>
		                        <div class="col-sm-10" >
                                    <input type="text"   class="form-control" id="txtMobileMoneyPhoneNo" >
		                        </div>
	                        </div>
                        
                         </form>
                </div>
            </div>
            <div id="panelUtilityPayment" class="panel panel-default">
                <div class="panel-heading">Utility Payments</div>
                <div class="panel-body">
                    <form class="form-horizontal">
                        <div class="form-group">
		                        <label class="control-label col-sm-2" for="cboUtilityPaymentType">Select Utility Payment Type:</label>
		                        <div class="col-sm-10">
                                    <select id="cboUtilityPaymentType"   class="form-control" >
                                        <option value="" selected>(SELECT)</option>
                                        <option value="kplc_prepaid">KPLC Prepaid</option>
                                        <option value="kplc_postpaid">KPLC Post-Paid</option>
                                        <option value="dstv">DSTV</option>
                                        <option value="gotv">GoTV</option>
                                        <option value="zukutv">ZUKU TV</option>
                                    </select>
		                        </div>
	                        </div>
	                        <div class="form-group">
		                        <label class="control-label col-sm-2" for="txtUtilityPaymentAcc">Utility Payment Acc:</label>
		                        <div class="col-sm-10" >
                                    <input type="text"   class="form-control" id="txtUtilityPaymentAcc" >
		                        </div>
	                        </div>
                        
                         </form>
                </div>
            </div>
            <div id="panelPaymentDetails" class="panel panel-default">
                <div class="panel-heading">Payment Details</div>
                <div class="panel-body">
                    <form class="form-horizontal">
                        <div class="form-group">
                            <label class="control-label col-sm-2" for="txtNotes">Notes/Description :</label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control" id="txtNotes" placeholder="Enter Transaction Description">
                            </div>
                        </div>



                        <div class="form-group">
                            <label class="control-label col-sm-2" for="txtBeneficiaryNo">Beneficiary No :</label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control" id="txtBeneficiaryNo" placeholder="Enter Beneficiary No">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-2" for="txtBeneficiaryName">Beneficiary Name :</label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control" id="txtBeneficiaryName" placeholder="Enter Beneficiary Name">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-2" for="txtAmount">Payment Amount :</label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control" id="txtAmount" placeholder="Enter Amount">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-offset-2 col-sm-10">
                                <button type="button" class="btn btn-primary" id="btnPost">Post</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>

    <br>



    <div id="loading" style="display:none"><img src="<%: Url.Content("~/Content/images/ajax-loader.gif") %>"  alt="Ajax Loader" />Contacting server....</div>
    <div id="divStatementDlg" style="display:none" ><iframe id="ifStatementDlg" style="height:640px;width:1140px"></iframe></div>
    
</asp:Content>
