﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loan Repayment Calculator
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        
        .td_amount_col {
            text-align: right;
        }
        
    </style>

    
    <script type="text/javascript"  >
        $(document).ready(function () {
            var LoanTypeList = null;
            var currLoanType = null;
            //note no quotes to avoid 'true' and 'false' strings which will both evaluate to true on if (NoSalaryMazematics) {
            //var NoSalaryMazematics ='<%= ((XtremeERP.Common.Data.MemberPortalSettings)ViewBag.PortalSettings).LoanCalcNoSalaryComputations ? "true" : "false" %>';


            var bolIsSaccoBalozi =<%= (XtremeERP.Common.Utilities.Utils.bolIsSaccoBalozi ? "true" : "false") %>;

            InitSummary();


            $('#btnCalculate').on('click', function (event) {
                event.preventDefault();
                if (document.getElementById("cboLoanType").selectedIndex == 0) {
                    alert("Select Loan Type");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRequestedAmount").val()))) {
                    alert("Invalid Loan Amount");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRepaymentPeriod").val()))) {
                    alert("Invalid Repayment Period");
                    return;
                }
                if (+($("#txtRepaymentPeriod").val()) < 1) {
                    alert("Invalid Repayment Period");
                    return;
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();


                var outData = {
                    'LoanAmount': $("#txtRequestedAmount").val(),
                    'RepaymentPeriod': $("#txtRepaymentPeriod").val(),
                    'LoanTypeCode': $("#cboLoanType").val(),
                    'Frequency': $("#cboRepaymentFrequency").val()
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/CalculatorProcessLoanRepayment") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {

                        $("#lblRepaymentAmount").val((+response.RepaymentAmount).formatMoney());

                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            });

            $("#txtRepaymentPeriod").on('change keypress keyup', function () {
                $("#lblRepaymentAmount").text("");
            });
            $("#txtRequestedAmount").on('change keypress keyup', function () {
                $("#lblRepaymentAmount").text("");
            });
        
            $("#cboLoanType").on('change', function () {
                var LoanTypes = LoanTypeList.filter(function (lnType) {
                    return lnType.LoanTypeCode == $("#cboLoanType").val();
                });
                currLoanType = null;
                $("#lblMaxAmount").text("");
                $("#lblRepaymentPeriod").text("");
                $("#txtRepaymentPeriod").val("");
                $("#lblRepaymentAmount").val("");
                $("#lblInterestRate").text("");
                $("#pInfo").text("");
                

                

                if (LoanTypes.length > 0) {
                    currLoanType = LoanTypes[0];

                    $("#lblInterestRate").val(currLoanType.Percentage);
                    
                    $("#lblMaxAmount").val((+currLoanType.LoanMaxAmount).formatMoney());
                    $("#lblRepaymentPeriod").val(+currLoanType.LoanMaxDuration);
                    $("#txtRepaymentPeriod").val(+currLoanType.LoanMaxDuration);
                    $("#lblInterestRate").val(+currLoanType.Percentage);
                    
                    
                }
            });

            

            function InitSummary() {


                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanCalculatorLoanTypes") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        
                        LoanTypeList = response;
                        $("#cboLoanType").empty();
                        $("#cboLoanType").append('<option selected>(SELECT LOAN)</option>');
                        $.each(LoanTypeList, function (index, LoanType) {
                            $("#cboLoanType").append("<option value='" + LoanType.LoanTypeCode + "'>" + LoanType.LoanTypeName + "</option'>");
                        });
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

            }



            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });

        });
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    
        <%= Html.AntiForgeryToken() %> 
        <% XtremeERP.Common.Data.SaccoSettings saccoSettings = ViewBag.saccoSettings as XtremeERP.Common.Data.SaccoSettings; %>
        <% XtremeERP.Common.Data.SaccoMember saccoMember = ViewBag.SaccoMember as XtremeERP.Common.Data.SaccoMember; %>
        <% XtremeERP.Common.Data.MemberPortalSettings portalSettings = ViewBag.PortalSettings as XtremeERP.Common.Data.MemberPortalSettings; %>
        
        
       
              
              <div > 
                <div >  
                    <div class="card p-0" id="divCalculator">
                        <div id='tblCalculator'>
                            <h5 class="fs-5 p-3">Loan Repayment Repayment Calculator</h5>
                            <hr class="p-0 m-0"/>
                                
                            <div id='bdCalculator' class="row p-3">
                                <div class="col-md-3 mt-2">
                                    <label class="form-label">Loan Type</label>
                                    <select id="cboLoanType" class="form-select"></select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label class="form-label">Max. Loan Amount</label>
                                    <input id="lblMaxAmount" class="form-control" disabled/>
                                </div>
                               <div class="col-md-3 mt-2">
                                    <label class="form-label">Max. Repayment Period (Months)</label>
                                    <input id="lblRepaymentPeriod" class="form-control" disabled/>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label class="form-label">Monthly Interest Rate (%)</label>
                                    <input id="lblInterestRate" class="form-control" disabled/>
                                </div>
                                
                                <div class="col-md-3 mt-2">
                                    <label class="form-label">Amount To Borrow</label>
                                    <input type="number" id="txtRequestedAmount" class="form-control" />
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label class="form-label">Repayment Period</label>
                                    <input class="form-control" type="number" id="txtRepaymentPeriod" />
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label class="form-label">Repayment Frequency</label>
                                        <select id="cboRepaymentFrequency" class="form-select">
                                            <option value="Monthly" selected>Monthly</option>
                                            <option value="Twice Per month">Twice per Month</option>
                                        </select>
                                   
                                </div>
                                
                               <div class="col-md-3 mt-2">
                                    <label class="form-label">Monthly Repayment</label>
                                    <input id="lblRepaymentAmount" class="form-control" disabled/>
                                </div>
                            </div>
                                <div class="col-md-3 mt-2 mt-2 p-3">
                                    <label class="form-label"></label>
                                    <input type="button" id="btnCalculate" value="Calculate" class="btn btn-success"/></td>
                                </div>
                        </div>
                        <p id="pInfo"></p>
                    </div>
                    
                </div> 
                </div> 
          
        <br />
        
         
      
    <div id="loading" style="display:none"><img src="<%: Url.Content("~/Content/images/ajax-loader.gif") %>"  alt="Ajax Loader" />Contacting server....</div>
    <div id="divStatementDlg" style="display:none" ><iframe id="ifStatementDlg" style="height:640px;width:1140px"></iframe></div>
    
</asp:Content>

