﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/ExternalUsers/Views/Shared/ExternalUsers.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    HR Loans Approval
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css"></style>
    <script type="text/javascript"  >
        'use strict';
        var AccountMask = ""; var CompanyName = ""; var CompanyAddress = "";
        var SaccoSettings;
        $(document).ready(function () {
            ShowSearchParams();
            $("#cboEmployer").empty();
            $("#cboBranch").empty();
            $("#cboLoan").empty();
            $("#cboYear").empty();


            $("#cboLoanStatus").on('change', function () {
                LoadLoansListing();
            });
            $("#cboHRStatus").on('change', function () {
                LoadLoansListing();
            });
            $("#cboBranch").on('change', function () {
                LoadLoansListing();
            });
            $("#cboLoanType").on('change', function () {
                LoadLoansListing();
            });
            $("#cboYear").on('change', function () {
                LoadLoansListing();
            });
            $("#cboPeriod").on('change', function () {
                LoadLoansListing();
            });
            $("#btnListLoans").on('click', function () {
                LoadLoansListing();
            });
            $("btnPrint").on('click', function () {
                PrintList("divLoansList");
            });
            $("cboSearchBy").on('change', function () {
                ShowSearchParams();
            });

            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/ExternalUsersSystemApi/GetLoansListingConfig") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var employers = response.EmployerList;
                    var obj = document.getElementById("cboEmployer");
                    var opt = document.createElement("option");
                    opt.value = "";
                    opt.text = "(ANY)";
                    obj.appendChild(opt);
                    $.each(employers, function (index, empl) {
                        var opt = document.createElement("option");
                        opt.value = empl.EmployerCode;
                        opt.text = empl.EmployerName;
                        obj.appendChild(opt);
                    });
                    var branches = response.BranchesList;
                    var obj = document.getElementById("cboBranch");
                    var opt = document.createElement("option");
                    opt.value = "";
                    opt.text = "(ANY)";
                    obj.appendChild(opt);
                    $.each(branches, function (index, branch) {
                        var opt = document.createElement("option");
                        opt.value = branch.BranchCode;
                        opt.text = branch.BranchName;
                        obj.appendChild(opt);
                    });
                    var loans = response.LoansList;
                    var obj = document.getElementById("cboLoan");
                    var opt = document.createElement("option");
                    opt.value = "";
                    opt.text = "(ANY)";
                    obj.appendChild(opt);
                    $.each(loans, function (index, loan) {
                        var opt = document.createElement("option");
                        opt.value = loan.LoanTypeCode;
                        opt.text = loan.LoanTypeName;
                        obj.appendChild(opt);
                    });
                    var years = response.YearsList;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });

                    LoadFinancialPeriods();

                },
                error: function (xhr, status, error) {

                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                }

            });


            function LoadFinancialPeriods() {
                $("#cboPeriod").empty();
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/ExternalUsersSystemApi/GetAllBOSAFinancialMonths") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var fmonths = response;
                        var objEnd = document.getElementById("cboPeriod");
                        $.each(fmonths, function (index, fmonth) {
                            var opt = document.createElement("option");
                            opt.value = fmonth.MonthID;
                            opt.text = fmonth.MonthName;
                            objEnd.appendChild(opt);
                            if (fmonth.Status == "OPENED") {
                                objEnd.selectedIndex = index
                            }

                        });
                        LoadLoansListing();
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }



            function LoadLoansListing() {

                $("#divLoansList").empty();
                $("#ListingType").html("<b>" + $("#cboLoanStatus option:selected").text() + "</b>");

                if ($("#cboPeriod").val() == null) { return; }
                if ($("#cboYear").val() == null) { return; }
                if ($("#cboPeriod").val() == "") { return; }
                if ($("#cboYear").val() == "") { return; }
                if ($("#cboLoanStatus").val() == "") { return; }
                if ($("#cboLoanStatus").val() == null) { return; }


                var Criteria = {
                    "EmpCode": $("#cboEmpCode").val(),
                    "SearchBy": $("#cboSearchBy").val(),
                    "SearchValue": $("#txtSearchValue").val(),
                    "LoanTypeCode": $("#cboLoan").val(),
                    "BranchCode": $("#cboBranch").val(),
                    "DBName": $("#cboYear").val(),
                    "LoanPeriod": $("#cboPeriod").val(),
                    "LoanStatus": $("#cboLoanStatus").val(),
                    "HRApprovedStatus": $("#cboHRStatus").val(),
                    "AppraisalUser": "",
                    "LoanDate": ""
                }

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/ExternalUsersSystemApi/GetHRLoanListing") %>",
                    data: JSON.stringify(Criteria),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $('#divLoansList').empty();
                        DisplayAppraisedLoans(response);

                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }

            function DisplayAppraisedLoans(loanlist) {
                var HRLinkText = "Approve";
                var tbl = "<table id='tbLoansList' class='display' cellspacing='0' width='100%'>";
                tbl += "<thead>";
                tbl += "<tr>";
                tbl += "	<th><b>Loan Serial No</b></th>";
                tbl += "	<th><b>Loan Date</b></th>";
                tbl += "	<th><b>Member No</b></th>";
                tbl += "	<th><b>PayrollNo</b></th>";
                tbl += "	<th><b>Names</b></th>";
                tbl += "	<th><b>Loan Type</b></th>";
                tbl += "	<th><b>Requested Amt</b></th>";
                tbl += "	<th><b>Recommended Amt</b></th>";
                tbl += "	<th><b>HR Ability</b></th>";
                tbl += "	<th><b>HR Approval</b></th>";
                tbl += "</tr>";
                tbl += "</thead>";
                tbl += "<tbody id='bdLoansList'>";
                $.each(loanlist, function (index, loan) {
                    if (loan.HRApproved.toUpperCase() == "Y") { HRLinkText = "Approved"; } else { HRLinkText = "HR Approve"; }
                    tbl += "<tr><td>" + loan.LoanSerialNumber + "</td><td>" + loan.LoanDate + "</td><td>" + loan.MemberNo + "</td><td>" + loan.PayrollNo + "</td><td>" + loan.MemNames + "</td><td>" + loan.LoanTypeName + "</td><td>" + loan.RequestedAmount.formatMoney() + "</td><td>" + loan.RecommendedAmount.formatMoney() + "</td><td>" + loan.HRRepayAmt.formatMoney() + "</td><td><a href='" + loan.LoanSerialNumber + "' class='approveLink'>" + HRLinkText + "</a></td></tr>"
                });
                tbl += "</tbody></table>";
                $('#divLoansList').html(tbl);
                $('#tbLoansList').dataTable();
            }


            function ProcessHRLoanApproval(LoanToApprove) {
                $('<div id="divHRApproveLoanDialog"></div>').dialog({
                    modal: true,
                    title: "HR Approve Loan",
                    height: 700,
                    width: 900,
                    autoOpen: true,
                    show: {
                        effect: "drop",
                        direction: "up",
                        duration: 500
                    },

                    buttons: {
                        'OK': {
                            'text': 'OK',
                            'id': 'btnOK',
                            'click': function () {
                                var hr_ability_amount = $("#txtHRAbility").val();
                                var ConfirmMessage = "";
                                if (!isNumber(hr_ability_amount)) {
                                    alert("Invalid Ability Amount");
                                    return;
                                }
                                else if (+hr_ability_amount < 0) {
                                    alert("Ability Amount should be more than/equal to zero");
                                    return;
                                }
                                ConfirmMessage = "Confirm Repayment ability of " + (+hr_ability_amount).formatMoney() + " ?";

                                xDialogConfirm(ConfirmMessage, "Confirm").then(function () {
                                    //xDialogMemberCredetials().then(function (data) { //call without password to speed up process but check for privilege
                                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                                    //var Password = data.UserPass;
                                    //var pwdslt = getRandomInt(1000, 30000);
                                    //pwdslt = pwdslt.toString();
                                    //var pwd = CryptoJS.MD5(Password).toString();
                                    //pwd = pwd + pwdslt;
                                    //var sltpwd = CryptoJS.MD5(pwd).toString();

                                    var outData = {
                                        'DBName': LoanToApprove.DBName,
                                        'MemberNo': LoanToApprove.mLoanAppraisals.MemberNumber,
                                        'LoanSerialNumber': LoanToApprove.LoanSerialNumber,
                                        'HRAbilityAmount': $("#txtHRAbility").val(),
                                        'HRRepayPeriod': $("#txtRepaymentPeriod").val(),
                                        'HRResponse': $("#cboHRResponse").val(),
                                        'HRComments': $("#txtHRComments").val(),

                                    }
                                    outData = JSON.stringify(outData);
                                    $.ajax({
                                        headers: { __RequestVerificationToken: csrfToken },
                                        type: "POST",
                                        url: "<%: Url.Content("~/api/ExternalUsersSystemApi/HRApproveAbility") %>",
                                        data: outData,
                                        contentType: "application/json; charset=utf-8",
                                        dataType: "json",
                                        success: function (response) {
                                            $("#tbLoansList tr").each(function (i) {
                                                var row = $(this);
                                                if (row.find('td:eq(0)').text() == LoanToApprove.LoanSerialNumber) {
                                                    row.find('td:eq(7)').html((+response).formatMoney());
                                                    row.find('td:eq(8)').html(hr_ability_amount.toString());
                                                    row.find('td:eq(9)').html("<a href='" + LoanToApprove.LoanSerialNumber + "' class='approveLink'>Approved</a>");
                                                }
                                            });
                                            alert("HR Ability successfully updated");
                                            $("#divHRApproveLoanDialog").dialog("close");

                                        },
                                        error: function (xhr, status, error) {
                                            var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                                        }
                                    });
                                    //});
                                });
                            }
                        },
                        Cancel: function () {
                            $(this).dialog("close");
                        }
                    },
                    open: function () {
                        var ExtUserID = "";
                        var ExtUserNames = "";
                        var ExtRespDate = "";
                        var ExtRespStatus = "";

                        if (LoanToApprove.memberLoanApplicationDetails != null) {
                            ExtRespStatus = LoanToApprove.memberLoanApplicationDetails.memberLoanApplication.ManagerApprovalStatus;
                            ExtRespDate = LoanToApprove.memberLoanApplicationDetails.memberLoanApplication.ManagerApprovalDate;
                            ExtUserID = LoanToApprove.memberLoanApplicationDetails.memberLoanApplication.ExternalUserID;
                            ExtUserNames = LoanToApprove.memberLoanApplicationDetails.memberLoanApplication.ExternalUserFullNames;
                        }
                        var tbl = "<table id='tblApproveLoan'  class='display' cellspacing='0' width='100%'>";
                        tbl += "<tbody>";
                        tbl += "<tr><td><b>Loan Serial Number:</b></td><td><input type='text' id='txtLoanSerialNumber' value='" + LoanToApprove.LoanSerialNumber + "' disabled /></td><td><b>Loanee:</b></td><td><input type='text' id='txtLoaneeName' value='" + LoanToApprove.saccoMember.FullNames + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>MemberNo:</b></td><td><input type='text' id='txtLoaneeMemberNo' value='" + LoanToApprove.saccoMember.MemberNo + "' disabled /></td><td><b>PayrollNo:</b></td><td><input type='text' id='txtLoaneePayrollNo' value='" + LoanToApprove.saccoMember.PayrollNo + "' disabled /></td></tr>";
                        tbl += "<tr><td><b>Loan Type:</b></td><td><input type='text' id='txtLoanType' value='" + LoanToApprove.mLoanType.LoanTypeName + "' disabled /></td><td><b>Requested Amount:</b></td><td><input type='text' id='txtRequestedAmount' value='" + (+LoanToApprove.mLoanAppraisals.RequestedAmount).formatMoney() + "' disabled /></td></tr>";

                        tbl += "<tr><td><b>Approved Status</b></td><td><input type='text' value='" + ExtRespStatus + "' disabled /></td><td><b>Approved By Name</b></td><td><input type='text' value='" + ExtRespDate + "' disabled /></td></tr>";

                        tbl += "<tr><td><b>Approved By PF</b></td><td><input type='text' value='" + ExtUserID + "' disabled /></td><td><b>Approved By Name</b></td><td><input type='text' value='" + ExtUserNames + "' disabled /></td></tr>";

                        tbl += "<tr><td><b>Recommended Amount</b></td><td><input type='text' id='txtRecommendedAmount' value='" + (+LoanToApprove.mAppraisalReport.RecommendedAmount).formatMoney() + "' disabled /></td><td><b>Installment Amount</b></td><td><input type='text' id='txtInstallmentAmount' value='" + (+LoanToApprove.mAppraisalReport.InstallmentAmount).formatMoney() + "' disabled /></td></tr>";

                        tbl += "<tr><td><b>HR Approved:</b></td><td><input type='text' value='" + LoanToApprove.mLoanAppraisals.HRApproved + "' disabled /></td><td><b>HR Response Date</b></td><td><input type='text' value='" + LoanToApprove.mLoanAppraisals.HRResponseDate + "' disabled /></td></tr>";

                        tbl += "<tr><td><b>HR Approved By:</b></td><td><input type='text' value='" + LoanToApprove.mLoanAppraisals.HRUserID + "' disabled /></td><td><b>HR Name:</b></td><td><input type='text'  value='" + LoanToApprove.mLoanAppraisals.HRFullName + "' disabled /></td></tr>";


                        tbl += "<tr><td><b>HR Ability*:</b></td><td><input type='text' id='txtHRAbility' value='' /></td><td><b>Repayment Period:</b></td><td><input type='text' id='txtRepaymentPeriod' disabled value='" + LoanToApprove.mAppraisalReport.RepaymentPeriod + "' /></td></tr>";


                        if (LoanToApprove.mLoanAppraisals.HRResponse.toString().toLowerCase() == "approved".toLowerCase()) {
                            tbl += "<tr><td><b>HR Response*:</b></td><td><select id='cboHRResponse'><option value=''>(SELECT)</option><option value='approved' selected>Approved</option><option value='Rejected'>Rejected</option></select></td><td><b>Comments:</b></td><td><input type='text' id='txtHRComments' value='" + LoanToApprove.mLoanAppraisals.HRComments + "' /></td></tr>";
                        } else if (LoanToApprove.mLoanAppraisals.HRResponse.toString().toLowerCase() == "rejected".toLowerCase()) {
                            tbl += "<tr><td><b>HR Response*:</b></td><td><select id='cboHRResponse'><option value=''>(SELECT)</option><option value='approved'>Approved</option><option value='Rejected' selected>Rejected</option></select></td><td><b>Comments:</b></td><td><input type='text' id='txtHRComments' value='" + LoanToApprove.mLoanAppraisals.HRComments + "' /></td></tr>";
                        } else {
                            tbl += "<tr><td><b>HR Response*:</b></td><td><select id='cboHRResponse'><option value='' selected>(SELECT)</option><option value='approved'>Approved</option><option value='Rejected'>Rejected</option></select></td><td><b>Comments:</b></td><td><input type='text' id='txtHRComments' value='" + LoanToApprove.mLoanAppraisals.HRComments + "' /></td></tr>";
                        }
                        tbl += "<tr><td><b>Amt In Words:</b></td><td colspan='3'><div id='divHRAbilityInWords'></td></tr>";
                        tbl += "<tr><td><b>Qualifying Amount.:</b></td><td><input type='text' id='txtQualifyingAmount' value='0.00' disabled /></td></tr>";
                        tbl += "</tbody></table>";

                        tbl += "<hr style='color:red' />";

                        tbl += "<table id='tblLoanOffset' class='display' cellspacing='0' width='100%'>";
                        tbl += "<thead>";
                        tbl += "<tr>";
                        tbl += "	<th><b>Loan Serial No</b></th>";
                        tbl += "	<th><b>Loan Name</b></th>";
                        tbl += "	<th><b>Loan Date</b></th>";
                        tbl += "	<th><b>Loan Amount</b></th>";
                        tbl += "	<th><b>Balance</b></th>";
                        tbl += "	<th><b>Apprv. Status</b></th>";
                        tbl += "	<th><b>Apprv. By</b></th>";
                        tbl += "	<th><b>Apprv Name</b></th>";
                        tbl += "	<th><b>Type</b></th>";
                        tbl += "</tr>";
                        tbl += "</thead>";
                        tbl += "<tbody id='bdLoansOffset'>";

                        if (LoanToApprove.memberLoanApplicationDetails != null) {
                            if (LoanToApprove.memberLoanApplicationDetails.memberLoanApplicationOffset != null) {
                                var loanOffsets = LoanToApprove.memberLoanApplicationDetails.memberLoanApplicationOffset;
                                $.each(loanOffsets, function (index, loanOff) {
                                    tbl += "<tr><td>" + loanOff.LoanSerialNo + "</td><td>" + loanOff.LN_LoanTypeName + "</td><td>" + loanOff.LN_IssueDate + "</td><td>" + loanOff.LN_LoanAmount + "</td><td>" + loanOff.LN_LoanBalance + "</td><td>" + loanOff.ApprovalStatus + "</td><td>" + loanOff.ApproverUserID + "</td><td>" + loanOff.ApproverNames + "</td><td>" + loanOff.OffsetType + "</td></tr>"
                                });
                            }
                        }
                        tbl += "</tbody></table>";
                        $(this).html(tbl);
                        $('#tblLoansOffset').dataTable();
                        ShowAmtInWords();
                        $("#txtHRAbility").focus;

                    },
                    close: function (event, ui) {
                        $(this).dialog("destroy").remove();
                    }
                });

                $('body').on('click', '.approveLink', function (e) {
                    HRApproveLoan(this);
                    e.preventDefault();
                    return false;
                });

                $("#txtHRAbility").on('change keyup paste mouseup', function () {
                    ShowAmtInWords();
                    CalcQualifyingAmount();
                });
                $("#txtRepaymentPeriod").on('change keyup paste mouseup', function () {
                    CalcQualifyingAmount();
                });
                function ShowAmtInWords() {
                    $("#divHRAbilityInWords").html("");
                    try {
                        $("#divHRAbilityInWords").html(toWords($("#txtHRAbility").val()));
                    } catch (err) {

                    }
                }
                function CalcQualifyingAmount() {
                    try {
                        var QualifyingAmount = $("#txtHRAbility").val() * $("#txtRepaymentPeriod").val();
                        $("#txtQualifyingAmount").val((+QualifyingAmount).formatMoney());
                    } catch (err) {

                    }
                }

            }

            function HRApproveLoan(hrapprovelink) {

                var ApproveLoanSerialNumber = hrapprovelink.getAttribute("href");
                var Criteria = {
                    "LoanSerialNumber": ApproveLoanSerialNumber,
                    "DBName": $("#cboYear").val()
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/ExternalUsersSystemApi/GetLoanDetails") %>",
                    data: JSON.stringify(Criteria),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        ProcessHRLoanApproval(response);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }


            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion();
            });
            function ShowSearchParams() {
                $('#divSearchDisplay').empty();
                $('#divSearchDisplay').append('Enter ' + $("#cboSearchBy option:selected").text());
            }


            function PrintList(el) {
                var restorepage = document.body.innerHTML;
                var printcontent = document.getElementById(el).innerHTML;
                //document.body.innerHTML = "<html><body>" + printcontent + "</body></html>";
                document.body.innerHTML = printcontent;
                window.print();
                document.body.innerHTML = restorepage;
            }
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
<h3>HR Loans Approval</h3>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <form id="frmSearch" name="frmSearch" action="#">
        <%= Html.AntiForgeryToken() %>
    <table >
        <tr>
            <td colspan="4"><b>Filter Loan Listing</b></td>
        </tr>
        <tr>
            <td>Financial Year:</td><td><select id="cboYear" onchange="javascript:LoadFinancialPeriods(); LoadLoansListing();return false;"><option value="selectyear">SELECT YEAR</option></select></td>
            <td>Period:</td><td> <select id="cboPeriod" onchange="javascript:LoadLoansListing();return false;"><option value="" >Select Period</option></select></td>
        </tr>
        <tr><td>Employer:</td><td><select id="cboEmployer">
                                        <option value="">SELECT EMPLOYER</option>
                                   </select>
            </td>
            <td>
                Loan Type:
            </td>
            <td>
                <select id="cboLoan" onchange="javascript:LoadLoansListing();return false;"><option value="">(ANY)</option></select>
            </td>
        </tr>
        <tr>
            <td></td><td></td>
            <td>HR Status:</td><td> <select id="cboHRStatus" >
                                        <option value="" selected>(ANY)</option>
                                        <option value="N">Pending</option>
                                        <option value="Y">Approved</option>
                                      </select>
            </td>
        </tr>
        <tr>
            <td>Search By:</td><td><select id="cboSearchBy">
                                        <option value="memberno" selected>MemberNo</option>
                                        <option value="idnumber">IDNo</option>
                                        <option value="payrollno">PayrollNo</option>
                                   </select>
            </td>
            <td>
                Branch:
            </td>
            <td>
                <select id="cboBranch" ><option value="">(ANY)</option></select>
            </td>
        </tr>
        <tr>
            <td><div id="divSearchDisplay">Search Value</div></td><td><input type="text" id="txtSearchValue"/></td>
            <td>Loan Status:</td><td><select id="cboLoanStatus">
                                        <option value="appraisedloans" selected>Appraised</option>
                                        <%--only show appraised loans do not change logic--%>
                                   </select>
            </td>
        </tr>
        
        <tr>
            <td></td>
            <td>
                <input type="button" id="btnListLoans" value="List Loans" />
                <input type="button" id="btnPrint" value="Print" />

            </td>
        </tr>
        </table>
    </form>
    
    <div ><label id="ListingType">Loans List</label>
        <div id="divLoansList"><table id= "tbLoansList"><tr><td></td></tr></table>No loans in view</div>
    </div>
    
</asp:Content>

