﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Tellers End Of Day
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
        <style type="text/css">
        
    </style>

    <script type="text/javascript"  >
        
        $(document).ready(function () {
            $("#txtTransDate").datepicker({ dateFormat: 'dd/mm/yy' });
            $("#txtTransDate").val(SaccoSettings.DefaultCurrDateInUserFormat);


            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });

            $("#txtTransDate").on('focusout', function () {
                DispEODList();
            })
            $("#cboStatus").on('change', function () {
                DispEODList();
            });
            $("#cboPeriod").on('change', function () {
                DispEODList();
            });
            $("#btnRefresh").on('click', function () {
                DispEODList();
            });

            $('#tblDenomination').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $('#tblEODList').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false

                //bJQueryUI: true,
                //sPaginationType: "full_numbers",
                //paging: false,
                //sScorollX: "900px",
                //sScrollY: "900px",
                //bScrollInfinite: true, //this property disables pagination
                //"bDestroy": true
            });

            $('#tblDenomination').on('input', '[type=text]', function () { //calc totals
                CalculateTotals();
            });
            $("#btnPost").on('click', function () {

                var DenominationList = new Array();
                var DenominationAmount = 0;
                var DenominationValue = 0;
                var DenominationCount = 0;
                var EntriesValid = true;
                $("#bdDenomination").find('tr').each(function (i) {
                    var DenominationEntry = {};
                    var row = $(this); //store in variable for faster access
                    DenominationAmount = ConvertMoneyToDouble(row.find('td:eq(0)').text());
                    DenominationCount = ConvertMoneyToDouble(row.find('td:eq(1)').find('input:eq(0)').val());
                    DenominationValue = ConvertMoneyToDouble(row.find('td:eq(2)').find('input:eq(0)').val());
                    if (!isNumber(DenominationValue)) {
                        alert("Invalid DenominationValue at row " + i + " Value =" + DenominationValue);
                        EntriesValid = false;
                        return;
                    }
                    if (!isNumber(DenominationCount)) {
                        alert("Invalid DenominationCount at row " + i + " Amount= " + DenominationCount);
                        EntriesValid = false;
                        return;
                    }
                    if (+DenominationValue < 0) {
                        alert("Invalid DenominationValue at row " + i + " Value =" + DenominationValue);
                        EntriesValid = false;
                        return;
                    }
                    if (+DenominationCount < 0) {
                        alert("Invalid DenominationAmount at row " + i + " Count= " + DenominationCount);
                        EntriesValid = false;
                        return;
                    }
                    DenominationEntry.DenominationAmount = DenominationAmount;
                    DenominationEntry.DenominationValue = DenominationValue;
                    DenominationEntry.DenominationCount = DenominationCount;
                    DenominationList[i] = DenominationEntry;
                });

                if (EntriesValid == true) {
                    xDialogConfirm("Confirm posting End of Day for teller " + $("#txtTellerName").val() + " for " + $("#txtEODDate").val(), "Confirm").then(function () {
                        xDialogGetUserCredetials().then(function (data) {
                            var UserName = data.UserName;
                            var Password = data.UserPass;
                            var pwdslt = getRandomInt(1000, 30000);
                            pwdslt = pwdslt.toString();
                            var pwd = CryptoJS.MD5(Password).toString();
                            pwd = pwd + pwdslt;
                            var sltpwd = CryptoJS.MD5(pwd).toString();

                            var outData = {
                                'TellerAccount': $("#txtTellerAccount").val(),
                                'TellerName': $("#txtTellerName").val(),
                                'EODDate': $("#txtEODDate").val(),
                                'PeriodCode': $("#cboPeriod").val(),
                                'DBName': $("#cboYear").val(),
                                'UserName': UserName,
                                'UserPass': sltpwd,
                                'Salt': pwdslt,
                                'Coinage': DenominationList,
                            }
                            outData = JSON.stringify(outData);
                            var csrfToken = $("input[name='__RequestVerificationToken']").val();
                            $.ajax({
                                headers: { __RequestVerificationToken: csrfToken },
                                type: "POST",
                                url: "<%: Url.Content("~/api/BankSystemApi/PostTellerEOD") %>",
                                data: outData,
                                contentType: "application/json; charset=utf-8",
                                dataType: "json",
                                success: function (response) {
                                    alert("End of Day posted");
                                    $("#txtEODStatus").val("YES");
                                },
                                error: function (xhr, status, error) {
                                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                                }
                            });
                        });
                    });
                }
            });
            $('#tabs').on('tabsactivate', function (event, ui) {
                var newIndex = ui.newTab.index();

                if (newIndex == 0) {
                    DispEODList();
                }
                if (newIndex == 1) {

                }
                if (newIndex == 6) {

                }
            });

            $('#cboYear').on('change', function () {
                var url = "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>"
                LoadFinancialPeriods($("#cboPeriod"), $(this).val(), url);
            });
            $(function () {
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetYears") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var years = response;
                        var obj = document.getElementById("cboYear");
                        $.each(years, function (index, yrs) {
                            var opt = document.createElement("option");
                            opt.value = yrs.DBName;
                            opt.text = yrs.UserDefinedYearName;
                            opt.selected = true;
                            obj.appendChild(opt);
                        });
                        $("#cboYear").trigger('change');
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            });

            $("#tblDenomination > tbody:last").children().remove();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetDenominationList") %>",
                data: JSON.stringify({}),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var row = "";
                    $.each(response, function (index, denomination_item) {
                        row += "<tr>";
                        row += "<td>" + (+denomination_item.DenominationAmount).formatMoney() + "</td>";
                        row += "<td class='td_amount_col'><input type='text' value='0.00' id='txtDeno[]' class='td_amount_col form-control' /></td>";
                        row += "<td class='td_amount_col'><input type='text' value='0.00' id='txtValue[]' class='td_amount_col form-control' disabled /></td>";
                        row += "</tr>";
                    });
                    $("#bdDenomination").append(row);
                },
                error: function (xhr, status, error) {

                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                }
            });

            $('#tblEODList tbody').on('click', 'tr', function () {
                $("#txtTellerName").val("");
                $("#txtTellerAccount").val("");
                $("#txtEODDate").val("");
                //$(this).removeClass('row_selected');
                //$(this).addClass('row_selected');

                $("#btnPost").attr("readonly", false);

                $("#bdDenomination").find('tr').each(function (i) {
                    var row = $(this); //store in variable for faster access
                    row.find('td:eq(1)').find('input:eq(0)').val(0.00);
                    row.find('td:eq(2)').find('input:eq(0)').val(0.00);
                });
                $("#txtDifference").val(0.00);
                $("#txtDenominationTotals").val(0.00);
                $("#txtSystemBalance").val(0.00);




                var TransDate = $(this).find('td').eq(0).text();
                var TellerAccount = $(this).find('td').eq(1).text();
                var TellerName = $(this).find('td').eq(3).text();
                var PostedStatus = $(this).find('td').eq(4).text();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellerEODDetails") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'PeriodCode': $("#cboPeriod").val(), 'PostedStatus': PostedStatus, 'TransDate': TransDate, 'TellerAccount': TellerAccount, 'TellerName': TellerName }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#txtTellerName").val(response.EODSummary.TellerName);
                        $("#txtTellerAccount").val(response.EODSummary.TellerAccount);
                        $("#txtEODDate").val(response.EODSummary.EOD_Date);
                        $("#txtSystemBalance").val(response.ClosingBalance.formatMoney());
                        if (response.EODSummary.Posted.toLowerCase() == "yes") {
                            $("#txtSystemBalance").val(response.EODSummary.SystemCIH.formatMoney());
                        }
                        $("#txtEODStatus").val(response.EODSummary.Posted);
                        if (response.EODSummary.Posted.toLowerCase() == "yes") {
                            $("#btnPost").attr("readonly", true);
                        }
                        if (response.EODCoinage) {
                            $.each(response.EODCoinage, function (index, eodCoinage) {
                                $("#bdDenomination").find('tr').each(function (i) {
                                    var row = $(this); //store in variable for faster access
                                    var deno_amt = ConvertMoneyToDouble(row.find('td:eq(0)').text());
                                    var txt_deno_count = row.find('td:eq(1)').find('input:eq(0)');
                                    console.log("Response " + eodCoinage.Denomination.toString() + " Compare to " + (+deno_amt).toString() + " Results = " + (eodCoinage.Denomination == +deno_amt).toString());
                                    if (response.EODSummary.Posted.toLowerCase() == "yes") {
                                        txt_deno_count.attr("readonly", "readonly");
                                    }
                                    if (eodCoinage.Denomination == +deno_amt) {
                                        txt_deno_count.val(eodCoinage.DenominationCount);
                                    }
                                });
                            });
                        }
                        CalculateTotals();

                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });

            });

            $("#btnPrint").click(function () {
                //$("#mySelector").printThis({
                //debug: false,              * show the iframe for debugging
                //importCSS: true,           * import page CSS
                //printContainer: true,      * grab outer container as well as the contents of the selector
                //loadCSS: "path/to/my.css", * path to additional css file
                //pageTitle: "",             * add title to print page
                //removeInline: false        * remove all inline styles from print elements

                var rptHeader = "";
                $("#divEODReport").printThis({
                    debug: false,
                    pageTitle: "Teller's EOD Report",
                    removeInline: false,
                    printContainer: true,
                    importCSS: true,
                    header: rptHeader
                });

            });
            DispEODList();


            function CalculateTotals() {
                var total_amount = 0;
                var line_total = 0;
                var denomination_amount = 0;
                $("#txtDenominationTotals").val(total_amount.formatMoney());
                $("#bdDenomination").find('tr').each(function (i) {
                    var row = $(this); //store in variable for faster access
                    var valid_amount = row.find('td:eq(1)').find('input:eq(0)').val();
                    denomination_amount = row.find('td:eq(0)').text();
                    row.find('td:eq(2)').find('input:eq(0)').val(0);
                    if (valid_amount) {
                        if (denomination_amount) {
                            denomination_amount = ConvertMoneyToDouble(denomination_amount);
                            if (isNumber(valid_amount)) {
                                line_total = +valid_amount * +denomination_amount;
                                total_amount += +line_total;
                                row.find('td:eq(2)').find('input:eq(0)').val(line_total.formatMoney());
                            } else {
                                return;
                            }
                        }
                    }
                });
                $("#txtDenominationTotals").val(total_amount.formatMoney());
                var sysbal = ConvertMoneyToDouble($("#txtSystemBalance").val());
                sysbal = +sysbal;
                $("#txtDifference").val(sysbal - total_amount);
            }

            function DispEODList() {
                if ($("#cboYear").val() == null) return;
                if ($("#cboYear").val() == "") return;
                $("#tblEODList > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellerEODList") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'PeriodCode': $("#cboPeriod").val(), 'TransDate': $("#txtTransDate").val(), 'PostedStatus': $("#cboStatus").val(), 'TellerAccount': '' }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var row = "";
                        $.each(response, function (index, eod_item) {


                            row += "<tr>";
                            row += "<td>" + eod_item.EOD_Date + "</td>";
                            row += "<td>" + eod_item.TellerAccount + "</td>";
                            row += "<td>" + eod_item.TellerAccountName + "</td>";
                            row += "<td>" + eod_item.TellerName + "</td>";
                            row += "<td>" + eod_item.Posted + "</td>";
                            row += "</tr>";

                        });
                        $("#bdEODList").append(row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }



            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            //$(function () {
             //   $("#tabs").tabs();
            //});
            $(function () {
                $("#accordion").accordion();
            });
        });
    </script>
    
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">


</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
            <div class="my-4 mx-auto d-flex justify-content-center col-12 col-md-8 ">
                <div id="customTabs" class="custom-tabs  position-relative" style="z-index: 0;">
                    <ul class="custom-tabs-nav mb-0 d-flex list-unstyled">
                        <li><a href="#tab1" data-tab="tab1" class="custom-tab-label active">EOD Listing</a></li>
                        <li><a href="#tab2" data-tab="tab2" class="custom-tab-label">End Day/Report</a></li>
                    </ul>
                    <span class="custom-glider position-absolute d-flex" style="transform: translateX(0);"></span>
                </div>
            </div>
<div class="card bg-white">
    <h3 class="p-3 fs-5">Tellers End Of Day</h3>
     <hr class='m-0 p-0'/>
        <div id="tabs">
     <form id="frmMain" name="frmMain">
        <div id="tab1" class="tab-content-panel active">
            <%= Html.AntiForgeryToken() %>
            <div>
                <div class="p-3">
                        <div class="row">

                        <div class="col-auto">
                            <label for="Year" class="form-label">Year</label>
                                <select  class="form-select" id="cboYear"></select>
                        </div>



                            <div class="col-auto">
                                <label for="Month" class="form-label">Month</label>
                                <select id="cboPeriod" class="form-select"></select>
                        </div>
                            <div class="col-auto">
                                <label for="Date" class="form-label">Date</label>
                                <input type="text" id="txtTransDate" class="form-control"/>
                            </div>

                            <div class="col-auto">
                                <label for="Status" class="form-label">Status</label>
                                <select class="form-select" id="cboStatus"><option value="">ALL</option><option value="posted">POSTED</option><option selected value="unposted">UNPOSTED</option>
                                </select>
                            </div>

                            <div>
                                <input type="button" id="btnRefresh" class="my-4 btn btn-success" value="Refresh"/>
                            </div>
                        <hr/>
                        <div >
                            <div>
                            <div id="divEODList">
                                <table id='tblEODList' class=" table table-bordered table-responsive">
                                <thead>
                                    <tr>
                                    <th>Date</th>
                                    <th>Teller A/C</th>
                                    <th>A/C Name</th>
                                    <th>Teller Name</th>
                                    <th>Posted</th>
                                    </tr>
                                </thead>
                                <tbody id='bdEODList'>
                                </tbody>
                                
                                </table>  
                            </div>
                        </div>
                        </div>
                </table>
            </div>
        </div>
        </div>
 </div>
            <div id="tab2" class="tab-content-panel p-3"> 

                <div id="divEndDay" >
                    
                    <div >
                        <div class="row">
                            <div class="col-auto">
                            <label for="Teller Name" class="form-label">Teller Name:</label>   
                    
                                <input placeholder="Teller Name" class="form-control" type="text" id="txtTellerName" readonly="true"/>
                            </div>
                            
                            <div class="col-auto">
                                <label for=" Teller A/C" class="form-label"> Teller A/C: </label>  
                    
                            <input type="text" class="form-control" placeholder="Teller A/C" id="txtTellerAccount" readonly="true"/>
                        </div>

                            <div class="col-auto">
                                <label for=" EOD Date" class="form-label">  EOD Date:  </label>  
                            
                            <input type="text" class="form-control " placeholder="EOD Date" id="txtEODDate" readonly="true"/>
                            </div>
                        


                            <div class="col-auto">
                                <label for=" System Balance" class="form-label">  System Balance: </label>
                            <input class="form-control " placeholder="Balance" type="text" id="txtSystemBalance" readonly="true"/>
                            </div>
                            <div class="col-auto">
                                <label for="  Denomination Totals" class="form-label">  Denomination Totals: </label>
                        <input type="text" placeholder="Totals" class="form-control " id="txtDenominationTotals" readonly="true"/>
                        
                            </div>

                            <div class="col-auto">
                                <label for="  Difference" class="form-label">   Difference: </label>
                        <input type="text" placeholder="Difference" class="form-control " id="txtDifference" readonly="true"/>
                            </div>
                    
</div>


<hr/>

                        <div class="mt-5 ">
                        
                            <div id="div1" >

                                <table id='tblDenomination' class="table table-bordered table-responsive">
                                <thead>
                                    <tr>
                                    <th >Denomination</th>
                                    <th class='td_amount_col'>Count</th>
                                    <th class='td_amount_col'>Value</th>
                                    </tr>
                                </thead>
                                <tbody id='bdDenomination'>
                                </tbody>
                                
                                </table>  

                        
                            </div>
                        
                        </div>




                        <div class="row mt-5">
                            <div class="col-auto mb-3">
                                <label for="EOD Posted" class="form-label">EOD Posted</label>
                                <input type="text" class=" form-control" value="" readonly="true" id="txtEODStatus" />
                            </div>
                            <div>
                                <input class="btn btn-success" type="button" id="btnPost" value="Post EOD" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        </div>
</div>
</asp:Content>


