﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Teller Cash Transactions
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
     <style type="text/css">

         .td_amount_col{
             text-align:right;
         }
         div#loading, div#finished {
             position: absolute;
             width: 100%;
             height: 25px;
             background-color: #000;
             color: #FFF;
             text-align: center;
             padding-top: 5px;
         }
        #divMemberPhoto {
            width: 400px;
            height: 340px;
            background-position: center center;
            background-size: cover;
            -webkit-box-shadow: 0 0 1px 1px rgba(0, 0, 0, .3);
            display: inline-block;
        }
        #divMemberSignature {
             width: 400px;
            height: 340px;
            background-position: center center;
            background-size: cover;
            -webkit-box-shadow: 0 0 1px 1px rgba(0, 0, 0, .3);
            display: inline-block;
        }
        #divAccountDetails {
            width: 400px;
            height: 340px;
            /*height:100px;*/
            overflow:auto;
            /*width:auto;*/
            background-position: center center;
            background-size: cover;
            -webkit-box-shadow: 0 0 1px 1px rgba(0, 0, 0, .3);
            display: inline-block;
            padding:10px ;
        }
        
    </style>

    <script type="text/javascript"  >
        
        $(document).ready(function () {


            var TransactionRequiresAuthorization_MaxTellerPayable = false;
            var TransactionRequiresAuthorization_NonCustomerAccount = false;
            var TransactionRequiresAuthorization_OverLimit = false;
            var MaxTellerPayable_Authorization = {};
            var NonCustomerAccount_Authorization = {};
            var OverLimit_Authorization = {};

            var strAccountName = "";
            var strAccountCode = "";

            var EmpCode_BR = "";
            var PayrollNo_BR = "";
            var MemberNo_BR = "";
            var MemberNames_BR = "";

            var LastTellerTransactionResult = null;



            $("#txtLogDate").datepicker({ dateFormat: 'dd/mm/yy' });
            $("#txtLogDate").val(SaccoSettings.DefaultCurrDateInUserFormat);




            strAccountName = "";
            strAccountCode = "";

            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });

            $("#tblPettyCashDetails").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });

            $('#tblTellerSummary_CM').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $('#tblMPAItems_BR').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $('#tblMemberDetails_BR').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $('#tblAccountMembers').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $('#tblCharges').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $('#tblTellersList_CM').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });

            $('#tblTransactionsLog').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": true

                //bJQueryUI: true,
                //sPaginationType: "full_numbers",
                //paging: false,
                //sScorollX: "900px",
                //sScrollY: "900px",
                //bScrollInfinite: true, //this property disables pagination
                //"bDestroy": true
            });
            $("#btnPrintLastSlip").on('click', function () {
                if (LastTellerTransactionResult == null) return;
                if (!LastTellerTransactionResult) return;
                var last_slip_url = global_site_root + "/Bank/BankSystem/TellerCashSlipReport?DBName=" + LastTellerTransactionResult.DBName + "&DocNo=" + LastTellerTransactionResult.DocNo + "&PeriodCode=" + LastTellerTransactionResult.PeriodCode + "&TransType=" + LastTellerTransactionResult.TransType;
                $("#ifrPdfSlip").attr("src", last_slip_url);
            });
            $("#txtPettyCashDocNo").on('focusout', function () {
                $("#txtPTDocDate").val("");
                $("#txtPTStatus").val("");
                $("#txtPTPaidTo").val("");
                $("#txtPTIDNo").val("");
                $("#txtPTTotal").val("0.00");

                $("#tblPettyCashDetails > tbody:last").children().remove();
                var petty_cash_doc_no = $("#txtPettyCashDocNo").val();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                if (petty_cash_doc_no.trim().length == 0) { return; }
                var outData = {
                    'DBName': $("#cboYear").val(),
                    'PayMode': "TELLER",
                    'DocNo': petty_cash_doc_no
                }
                var total_amount = 0;
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetPettyCashDocDetails") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var tbl = "<tr>";
                        var row_datas = response;
                        var tbl_row = "";
                        var bolDataAvailable = false;
                        $.each(row_datas, function (index, row_data) {
                            bolDataAvailable = true;
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + (index + 1).toString() + ") " + row_data.Description + "</td>";
                            tbl_row += "<td>" + row_data.ExpenseAcc + "</td>";
                            tbl_row += "<td>" + row_data.ExpenseAccName + "</td>";
                            tbl_row += "<td class='td_amount_col'>" + row_data.Amount.formatMoney() + "</td>";
                            tbl_row += "</tr>";
                            total_amount += (+row_data.Amount);
                        });
                        $("#bdPettyCashDetails").append(tbl_row);
                        if (bolDataAvailable == true) {
                            $("#txtPTDocDate").val(row_datas[0].TransDate);
                            $("#txtPTStatus").val(row_datas[0].Status);
                            $("#txtPTPaidTo").val(row_datas[0].PaidTo);
                            $("#txtPTIDNo").val(row_datas[0].IDNumber);
                        }
                        $("#txtPTTotal").val(total_amount.formatMoney());

                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });
            $("#btnPostPettyCash").on('click', function () {
                var outData = {
                    'DocNo': $("#txtPettyCashDocNo").val(),
                    'DBName': $("#cboYear").val()
                }
                outData = JSON.stringify(outData);
                xDialogConfirm("Post Petty Cash Doc No" + $("#txtPettyCashDocNo").val() + " Payable to " + $("#txtPTPaidTo").val() + " of ID No " + $("#txtPTIDNo").val() + " . Total Amount = " + $("#txtPTTotal").val() + " ?", "Confirm").then(function () {
                    $("#btnPostPettyCash").attr('disabled', true);
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/PostTellerPettyCash") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            xDialogMessage("Petty Cash Payment posted successfully", "Posted").then(function () {
                                $("#txtPTStatus").val("Posted");
                                $("#btnPostPettyCash").attr('disabled', false);
                                $("#txtPettyCashDocNo").focus();
                            });
                        },
                        error: function (xhr, status, error) {
                            $("#btnPostPettyCash").attr('disabled', false);
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            });
            $("#btnPost_CM").on('click', function () {
                var selected_index = $("#cboTransactionType_CM option:selected").index();
                amount_cm = 0;
                var ContraTellerAccName = "";
                var ContraTellerAccNo = "";
                var ContraTellerNames = "";
                var ContraTellerUserName = "";
                var TransactionType_CM = $("#cboTransactionType_CM").val();

                if (selected_index == 0) {
                    alert("Select Transaction Type");
                    return;
                }

                if (selected_index == 1 || selected_index == 2) {
                    amount_cm = $("#txtAmount_CM").val();
                    if (!isNumber(amount_cm)) {
                        alert("Invalid Amount");
                        return;
                    }
                    if (+amount_cm < 0) {
                        alert("Amount should be more than zero");
                        return;
                    }
                }
                var valid_count = 0;
                var valid_amount = 0;
                if (selected_index == 3 || selected_index == 4) {
                    $("#tblTellersList_CM tbody").find('tr').each(function (i) {
                        var row = $(this); //store in variable for faster access
                        valid_amount = row.find('td:eq(4)').find('input:eq(0)').val();
                        if (isNumber(valid_amount)) {
                            if (+valid_amount > 0) {
                                ContraTellerAccNo = row.find('td:eq(2)').text();
                                ContraTellerAccName = row.find('td:eq(3)').text();
                                ContraTellerNames = row.find('td:eq(1)').text();
                                ContraTellerUserName = row.find('td:eq(0)').text();
                                amount_cm = valid_amount;
                                valid_count++;
                            }
                        } else {
                            alert("Invalid amount at " + ContraTellerAccNo);
                            return;
                        }
                    });
                    if (valid_count > 1) {
                        alert("You can only receive/issue to one teller");
                        return;
                    }
                }
                var outData = {};
                outData.TransactionType = $("#cboTransactionType_CM").val();
                outData.TransactionAmount = amount_cm;
                outData.DocumentNo = $("#txtDocNo_CM").val();

                outData.OtherTellerAccNo = "";
                outData.OtherTellerUserName = "";
                outData.OtherTellerUserPass = "";
                outData.OtherTellerSalt = "";

                outData.CashManagerUserName = "";
                outData.CashManagerUserPass = "";
                outData.CashManagerSalt = "";

                outData.TellerUserName = "";
                outData.TellerUserPass = "";
                outData.TellerSalt = "";

                xDialogConfirm("Transactions Type: " + $("#cboTransactionType_CM option:selected").text() + ", Amount = " + amount_cm + ((ContraTellerAccNo == "") ? "" : ", Teller Name = " + ContraTellerNames), "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (data) { //teller auth
                        var UserName = data.UserName;
                        var Password = data.UserPass;
                        var pwdslt = getRandomInt(1000, 30000);
                        pwdslt = pwdslt.toString();
                        var pwd = CryptoJS.MD5(Password).toString();
                        pwd = pwd + pwdslt;
                        var sltpwd = CryptoJS.MD5(pwd).toString();
                        outData.TellerUserName = UserName;
                        outData.TellerUserPass = sltpwd;
                        outData.TellerSalt = pwdslt;
                        if (selected_index == 1 || selected_index == 2) { //cash manager auth
                            xDialogGetOtherUserCredetials("Enter cash manager username/password", "").then(function (data) {
                                var UserName = data.UserName;
                                var Password = data.UserPass;
                                var pwdslt = getRandomInt(1000, 30000);
                                pwdslt = pwdslt.toString();
                                var pwd = CryptoJS.MD5(Password).toString();
                                pwd = pwd + pwdslt;
                                var sltpwd = CryptoJS.MD5(pwd).toString();
                                outData.CashManagerUserName = UserName;
                                outData.CashManagerUserPass = sltpwd;
                                outData.CashManagerSalt = pwdslt;
                                PostTellerCashManagement(outData);
                            });
                        }
                        else {//other teller auth
                            xDialogGetOtherUserCredetials("Confirmation required from " + ContraTellerNames, ContraTellerUserName).then(function (data) {
                                var UserName = data.UserName;
                                var Password = data.UserPass;
                                var pwdslt = getRandomInt(1000, 30000);
                                pwdslt = pwdslt.toString();
                                var pwd = CryptoJS.MD5(Password).toString();
                                pwd = pwd + pwdslt;
                                var sltpwd = CryptoJS.MD5(pwd).toString();
                                outData.OtherTellerUserName = UserName;
                                outData.OtherTellerUserPass = sltpwd;
                                outData.OtherTellerSalt = pwdslt;
                                outData.OtherTellerAccNo = ContraTellerAccNo;
                                PostTellerCashManagement(outData);
                            });
                        }
                    });
                });
            });

            $("#cboTransactionType_CM").on('change', function () {
                var selected_index = $("#cboTransactionType_CM option:selected").index();
                $("#txtAmount_CM").val("N/A");
                $("#txtAmount_CM").attr('disabled', true);
                $('#divTellersList').find('input, textarea, button, select').attr('disabled', 'disabled');
                $("#tblTellersList_CM tbody").find('tr').each(function (i) {
                    var row = $(this); //store in variable for faster access
                    var txtAmt = row.find('td:eq(4)').find('input:eq(0)');
                    txtAmt.val("N/A");
                });
                if (selected_index == 3 || selected_index == 4) {
                    $('#divTellersList').find('input, textarea, button, select').attr('disabled', 'disabled').removeAttr('disabled');
                    $("#tblTellersList_CM tbody").find('tr').each(function (i) {
                        var row = $(this); //store in variable for faster access
                        var txtAmt = row.find('td:eq(4)').find('input:eq(0)');
                        txtAmt.val("0.00");
                    });
                } else if (selected_index == 1 || selected_index == 2) {
                    $("#txtAmount_CM").val("0.00");
                    $("#txtAmount_CM").attr('disabled', false);
                }
            });
            $("#txtAmount").on('focusout', function (e) {
                LoadTransactionCharges();
            });
            $("#cboTransactionType").on('change', function (e) {
                $("#tblCharges > tbody:last").children().remove();
                if (!isNumber($("#txtAmount").val())) {
                    return;
                }
                var amt = $("#txtAmount").val();
                if (+amt <= 0) {
                    return;
                }
                LoadTransactionCharges();
            });

            $("#txtSearchValue").val("");

            $("#cboSearchBy").on('change', function () {
                $('#divSearchDisplay').empty();
                $('#divSearchDisplay').append('Enter ' + $("#cboSearchBy option:selected").text());
                if (AccountMask != "") {
                    if ($("#cboSearchBy").val() == "accountno") {
                        $("#txtSearchValue").mask(AccountMask);
                    } else {
                        $("#txtSearchValue").unmask();
                    }
                }
            });
            $("#cboSearchBy").prop('selectedIndex', 0);
            $("#cboSearchBy").trigger('change');


            $("#txtSearchValue").on('focusout', function () {
                LoadCustomerAccounts();
            });
            $("#txtSearchValue").keypress(function (ev) {
                if (ev.keyCode == 13 || ev.which == 13) {
                    LoadCustomerAccounts();
                    ev.preventDefault();
                    return false;
                }
            });
            //$("#cboAccount").on('change click', function () {
            $("#cboAccount").on('change', function () {
                ClearAll();
                DisplayAccountDetails();
            });

            $("#btnGetAccounts").on('click', function () {
                LoadCustomerAccounts();
            });
            $("#btnRefreshLog").on('click', function () {
                DispTransactionsLog();
            });
            $('#tabs').on('tabsactivate', function (event, ui) {
                var newIndex = ui.newTab.index();
                if (newIndex == 4) {
                    DispTransactionsLog();
                }
                if (newIndex == 5) {
                    GetTellersSummary();
                    GetTellersInTellerGroup();
                    $("#cboTransactionType_CM").trigger('change');
                }
            });

            $("#cboYear").on('change', function () {
                var url = "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>"
                LoadFinancialPeriods($("#cboPeriod"), $(this).val(), url);
            });
            $("#cboSearchBy_BR").on('change', function () {
                $("#divSearchBy_BR").html($("#cboSearchBy_BR option:selected").text());
            });
            $("#btn_AddAcc_BR").on('click', function () {
                xDialogSelectGLAccount("ALL").then(function (data) {
                    var addedAccCode = data;
                    GetAccountName(addedAccCode).then(function (data) {
                        var bal_row = "<tr>" +
                                          "<td>O</td>" +
                                          "<td>" + addedAccCode + "</td>" +
                                          "<td>" + data + "</td>" +
                                          "<td style='text-align:right'>0.00</td>" +
                                          "<td style='text-align:right'><input type='text' id='Amount[]' value='0.00' style='text-align:right'/></td>" +
                                          "</tr>";

                        $("#bdMPAItems_BR").append(bal_row);
                    })
                });

            });
            $("#btnPost_BR").on('click', function () {
                if (EmpCode_BR == "" || PayrollNo_BR == "") {
                    alert("Invalid member record");
                    return;
                }
                var validCount = 0;
                var MPAItemsList = new Array();
                var dblTotalAmount = 0;
                $("#tblMPAItems_BR tbody").find('tr').each(function (i) {
                    var MPAItemEntry = {};
                    var row = $(this); //store in variable for faster access
                    MPAItemEntry.BalType = row.find('td:eq(0)').text();
                    MPAItemEntry.BalCode = row.find('td:eq(1)').text();
                    MPAItemEntry.BalName = row.find('td:eq(2)').text();
                    MPAItemEntry.BalAmount = row.find('td:eq(3)').text();
                    var txtAmt = row.find('td:eq(4)').find('input:eq(0)');
                    if (!isNumber(txtAmt.val())) {
                        alert("Invalid amount at row " + i);
                        return;
                    }
                    var line_amount = txtAmt.val();
                    line_amount = +line_amount;
                    if (line_amount < 0) {
                        alert("Amount " + line_amount + " should be more than or equal to Zero. At row " + i);
                        return;
                    }
                    if (line_amount > 0) {

                        dblTotalAmount = dblTotalAmount + line_amount;
                        MPAItemEntry.TransAmount = line_amount;
                        MPAItemsList[validCount] = MPAItemEntry;
                        validCount++;
                    }
                });
                if (dblTotalAmount <= 0) {
                    alert("Nothing to post");
                    return;
                }
                var outData = {
                    'EmpCode': EmpCode_BR,
                    'PayrollNo': PayrollNo_BR,
                    'PostEntries': MPAItemsList
                }
                outData = JSON.stringify(outData);
                //alert(outData);
                xDialogConfirm("Confirm Bosa Receipt. Total Amount = " + dblTotalAmount + ", Member Name = " + MemberNames_BR + ", PayrollNo = " + PayrollNo_BR + ", MemberNo = " + MemberNo_BR + "?", "Confirm").then(function () {
                    $("#btnPost_BR").attr('disabled', true);
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/PostTellerMPADepositTransaction") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            EmpCode_BR = "";
                            PayrollNo_BR = "";
                            MemberNames_BR = "";
                            MemberNo_BR = "";
                            xDialogMessage("Bosa Receipt posted successfully", "Posted").then(function () {
                                $("#cboSearchBy_BR").prop('selectedIndex', 0);
                                $("#txtSearchValue_BR").val("");
                                $("#tblMPAItems_BR > tbody:last").children().remove();
                                $("#tblMemberDetails_BR > tbody:last").children().remove();
                                $("#btnPost_BR").attr('disabled', false);
                                $("#cboSearchBy_BR").focus();
                                //DisplayTellerWithdrawalSlip($("#divTransactionSlip"), response, true);
                            });
                        },
                        error: function (xhr, status, error) {
                            $("#btnPost_BR").attr('disabled', false);
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            });

            $("#txtSearchValue_BR").on('focusout', function () {
                $("#tblMemberDetails_BR > tbody:last").children().remove();
                $("#tblMPAItems_BR > tbody:last").children().remove();
                EmpCode_BR = "";
                PayrollNo_BR = "";
                MemberNo_BR = "";
                MemberNames_BR = "";
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/TellerMemberBalancesSummaryReceipt") %>",
                    data: "{'SearchBy' : '" + $("#cboSearchBy_BR").val() + "','SearchValue' : '" + $("#txtSearchValue_BR").val() + "','EmpCode' : '" + $("#cboEmployer_BR").val() + "','IncludeNegativeLoans' : 'F'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var mpa_balances = response.MemberBals;
                        var mem_details = response.MemberDetails;
                        EmpCode_BR = mem_details.EmployerCode;
                        PayrollNo_BR = mem_details.PayrollNo;
                        MemberNo_BR = mem_details.MemberNo;
                        MemberNames_BR = mem_details.FullNames;
                        var tblMemDetails = "<tr><td>" + mem_details.MemberNo + "</td><td>" + mem_details.EmployerCode + "</td><td>" + mem_details.PayrollNo + "</td><td>" + mem_details.FullNames + "</td><td>" + mem_details.IDNumber + "</td></tr>";
                        $("#bdMemberDetails_BR").append(tblMemDetails);

                        var bal_row = "";
                        $.each(mpa_balances, function (index, mpa_balance) {
                            if (mpa_balance.BalType.substring(0, 1) != "F") { //no need to test for 'F' coz its filter at SQL level
                                bal_row += "<tr>" +
                                          "<td>" + mpa_balance.BalType + "</td>" +
                                          "<td>" + mpa_balance.BalCode + "</td>" +
                                          "<td>" + mpa_balance.BalName + "</td>" +
                                          "<td style='text-align:right'>" + mpa_balance.BalAmount.formatMoney() + "</td>" +
                                          "<td style='text-align:right'><input type='text' id='Amount[]' value='0.00' style='text-align:right'/></td>" +
                                          "</tr>";
                            }

                        });
                        if (bal_row != "") {
                            $("#bdMPAItems_BR").append(bal_row);
                        }
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });
            $(function () {
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetYears") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var years = response;
                        var obj = document.getElementById("cboYear");
                        $.each(years, function (index, yrs) {
                            var opt = document.createElement("option");
                            opt.value = yrs.DBName;
                            opt.text = yrs.UserDefinedYearName;
                            opt.selected = true;
                            obj.appendChild(opt);
                        });
                        $("#cboYear").get(0).selectedIndex = 0;
                        $("#cboYear").trigger('change');
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });


            $("#btnAddCharges").on('click', function () {
                var charge_acc_code = "";
                var charge_acc_name = "";
                xDialogSelectGLAccount("ALL").then(function (data) {
                    charge_acc_code = data;
                    GetAccountName(charge_acc_code).then(function (data) {
                        charge_acc_name = data;
                        var row = "<tr>";
                        row += "<td>" + charge_acc_code + "</td>";
                        row += "<td>" + charge_acc_name + "</td>";
                        row += "<td><input type='text' id='description[]' value=''/></td>";
                        row += "<td><input type='text' id='charges[]' value=''/></td>";
                        row += "</tr>";
                        $("#bdCharges").append(row);
                    })
                });
            });

            $("#btnPost").on('click', function () {
                if (strAccountCode == "") {
                    alert("Invalid Account");
                    return;
                }
                if ($("#cboTransactionType option:selected").index() == 0) {
                    alert("Select transaction type");
                    return;
                }
                var trans_amount = $("#txtAmount").val();
                if (!isNumber(trans_amount)) {
                    alert("Invalid Transaction amount");
                    return;
                }
                trans_amount = +trans_amount;
                if (trans_amount <= 0) {
                    alert("Invalid Transaction amount");
                    return;
                }
                var ChargesList = new Array();
                var dblTotalCharges = 0;
                $("#tblCharges tbody").find('tr').each(function (i) {
                    var ChargeEntry = {};
                    var row = $(this); //store in variable for faster access
                    ChargeEntry.AccountNo = row.find('td:eq(0)').text();
                    ChargeEntry.AccountName = row.find('td:eq(1)').text();
                    ChargeEntry.Description = row.find('td:eq(2)').find('input:eq(0)').val();
                    var txtAmt = row.find('td:eq(3)').find('input:eq(0)');
                    if (!isNumber(txtAmt.val())) {
                        //$(txtAmt).css('backgroundColor', 'red');
                        //txtAmt.css('backgroundColor', 'red');
                        //use either of above to get input box reference and change css using .cc or .addClass then remove on focus
                        alert("Invalid Charge amount at row " + i);
                        return;
                    }
                    var line_amount = txtAmt.val();
                    line_amount = +line_amount;
                    if (line_amount < 0) {
                        alert("Charge Amount " + line_amount + " should be more than or equal to Zero. At row " + i);
                        return;
                    }
                    dblTotalCharges = dblTotalCharges + line_amount;
                    ChargeEntry.Amount = line_amount;
                    ChargesList[i] = ChargeEntry;
                });
                var outData = {
                    'TransactionType': $("#cboTransactionType").val(),
                    'TransactionAmount': $("#txtAmount").val(),
                    'ATPNo': $("#txtATPNo").val(),
                    'Description': $("#txtDescription").val(),
                    'AccountNo': $("#cboAccount").val(),
                    'ChargesList': ChargesList
                }
                outData = JSON.stringify(outData);
                xDialogConfirm("Transactions Type: " + $("#cboTransactionType option:selected").text() + ", Account = " + $("#cboAccount").val() + ", Account Name = " + strAccountName + ", Amount = " + $("#txtAmount").val() + ", Charges = " + dblTotalCharges + "?", "Confirm").then(function () {
                    $("#btnPost").attr('disabled', true);
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/PostTellerTransactions") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            strAccountName = "";
                            strAccountCode = "";
                            LastTellerTransactionResult = response;
                            //var last_slip_url = global_site_root + "/Bank/BankSystem/TellerCashSlipReport?DBName=" + LastTellerTransactionResult.DBName + "&DocNo=" + LastTellerTransactionResult.DocNo + "&PeriodCode=" + LastTellerTransactionResult.PeriodCode + "&TransType=" + LastTellerTransactionResult.TransType;
                            var last_slip_url = global_site_root + "/Bank/BankSystem/TellerCashSlipReport?DBName=" + LastTellerTransactionResult.DBName + "&DocNo=" + LastTellerTransactionResult.DocNo + "&PeriodCode=" + LastTellerTransactionResult.PeriodCode + "&TransType=" + LastTellerTransactionResult.TransType;
                            $("#ifrPdfSlip").attr("src", last_slip_url);

                            xDialogMessage($("#cboTransactionType option:selected").text() + " posted successfully", "Posted").then(function () {
                                $("#txtAmount").val(0);
                                $("#cboSearchBy").prop('selectedIndex', 0);
                                $("#cboTransactionType").prop('selectedIndex', 0);
                                $("#cboAccount").empty().append("<SELECT ACCOUNT>").prop('selectedIndex', 0);
                                $("#txtDescription").val("");
                                $("#txtSearchBy").val("");
                                $("#txtSearchValue").val("");
                                $("#cboSearchBy").focus();
                                $("#tblAccountMembers > tbody:last").children().remove();
                                $("#tblCharges > tbody:last").children().remove();
                                $("#divMemberPhoto").html("");
                                $("#divMemberSignature").html("");
                                $("#btnPost").attr('disabled', false);
                                $("#cboSearchBy").focus();

                                TransactionRequiresAuthorization_MaxTellerPayable = false;
                                TransactionRequiresAuthorization_NonCustomerAccount = false;
                                TransactionRequiresAuthorization_OverLimit = false;
                                MaxTellerPayable_Authorization = {};
                                NonCustomerAccount_Authorization = {};
                                OverLimit_Authorization = {};





                                //DisplayTellerWithdrawalSlip($("#divTransactionSlip"),response,true);

                            });
                        },
                        error: function (xhr, status, error) {
                            $("#btnPost").attr('disabled', false);
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            });

            $("#btnModifyCharges").on('click', function () {
                xDialogGetAuthorizer("Enter username and password to modify charges").then(function (data) {
                    var UserName = data.UserName;
                    var Password = data.UserPass;
                    var pwdslt = getRandomInt(1000, 30000);
                    pwdslt = pwdslt.toString();
                    var pwd = CryptoJS.MD5(Password).toString();
                    pwd = pwd + pwdslt;
                    var sltpwd = CryptoJS.MD5(pwd).toString();

                    var outData = {
                        'UserID': UserName,
                        'Password': sltpwd,
                        'Salt': pwdslt,
                        'Privilege': "ModifyTellerCharges"
                    }
                    outData = JSON.stringify(outData);
                    var url = "<%: Url.Content("~/api/BankSystemApi/ValidateWebUserPrivilege") %>";
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: url,
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $('#divCharges').find('input, textarea, button, select').attr('disabled', 'disabled').removeAttr('disabled');;
                            $("#btnAddCharges").attr('disabled', 'disabled').removeAttr('disabled');
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            });

            $('#tblTransactionsLog tbody').on('click', 'tr', function () {
                //$('#tblTransactionsLog tbody tr').removeClass('row_selected');
                //$(this).addClass('row_selected');
                var DocNo = $(this).find('td').eq(2).text();
                var TransType = $(this).find('td').eq(3).text();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellerTransactionSlip") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'PeriodCode': $("#cboPeriod").val(), 'DocNo': DocNo, 'TransactionType': TransType }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        DisplayTellerWithdrawalSlip($("#divTransactionSlip"), response);
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });

            function PrintPdf2() {
                //http://stackoverflow.com/questions/472951/how-do-i-print-an-iframe-from-javascript-in-safari-chrome
                //http://stackoverflow.com/questions/24673024/unable-to-print-iframe-content-from-parent-page-in-ie-11
                //var browserName = navigator.userAgent.toLowerCase();
                //if (browserName.indexOf("msie") != -1) {
                //    window.document.getElementById('pdfFrame').print();
                //} else if (browserName.indexOf("trident") != -1) { //IE 11
                //    window.document.getElementById('pdfFrame').contentWindow.document.execCommand('print', false, null);
                //}
                //window.frames["ifrPdfSlip"].focus();
                ////window.frames["ifrPdfSlip"].contentWindow.print();
                //window.frames["ifrPdfSlip"].print();

                var iframe = document.frames ? document.frames["ifrPdfSlip"] : document.getElementById("ifrPdfSlip");
                var ifWin = iframe.contentWindow || iframe;
                iframe.focus();
                //ifWin.printPage();
                ifWin.print();
                return false;
            }
            $("#ifrPdfSlip").on('load', function () {
                // please note, that IE11 now returns undefined again for window.chrome
                //Google chrome  does not support automatice printing of pdf so...
                var isChromium = window.chrome,
                    vendorName = window.navigator.vendor;
                if (isChromium !== null && isChromium !== undefined && vendorName === "Google Inc.") {
                    setTimeout(PrintPdf2, 1000);
                }
                /*https://stackoverflow.com/questions/28016647/javascript-printing-the-contents-of-iframe-on-page-load-not-working
                 * setTimeout(function () {
                    $("#ifrPdfSlip").get(0).contentWindow.print();
                 }, 1000);
                 */ 
            });
            $("#btnTestSlip").on('click', function () {
                //$("#ifrPdfSlip").css("visibility", "hidden");
                var test_url = "http://localhost:37200/Bank/BankSystem/TellerCashSlipReport?DBName=BOSA000005&DocNo=0711-46-697-0002&PeriodCode=07&TransType=Cash%20Withdrawal";
                test_url = "http://localhost:37200/Bank/BankSystem/BOSAStatementReport?DBName=BOSA000005&EmpCode=001&PayrollNo=20000852&EndPeriod=07&StatementFormat=standard";
                $("#ifrPdfSlip").attr("src", test_url);
            });


            $("#btnPrint").click(function () {
                //$("#mySelector").printThis({
                //debug: false,              * show the iframe for debugging
                //importCSS: true,           * import page CSS
                //printContainer: true,      * grab outer container as well as the contents of the selector
                //loadCSS: "path/to/my.css", * path to additional css file
                //pageTitle: "",             * add title to print page
                //removeInline: false        * remove all inline styles from print elements

                var rptHeader = "";
                $("#divTransactionSlip").printThis({
                    debug: false,
                    pageTitle: "Transaction Slip",
                    removeInline: false,
                    printContainer: true,
                    importCSS: true,
                    header: rptHeader
                });
            });

            $(function () {
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAllEmployer") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var employers = response;
                        var obj = document.getElementById("cboEmployer");
                        $.each(employers, function (index, empl) {
                            $("#cboEmployer").append("<option value='" + empl.EmployerCode + "'>" + empl.EmployerName + "</option'>");
                            $("#cboEmployer_BR").append("<option value='" + empl.EmployerCode + "'>" + empl.EmployerName + "</option'>");
                        });
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            });
            function GetTellersInTellerGroup() {
                $("#tblTellersList_CM > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellersInTellerGroup") %>",
                    data: '{}',
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $.each(response, function (index, teller_detail) {
                            var tbl_row = "<tr><td>" + teller_detail.TellerName + "</td><td>" + teller_detail.UserFullNames + "</td><td>" + teller_detail.AccountCode + "</td><td>" + teller_detail.AccountName + "</td><td class='td_amount_col'><input type='text' id='txtTransferAmount[]' value='0' style='text-align:right' class='form-control'/></td></tr>";
                            $("#bdTellersList_CM").append(tbl_row);

                        });
                        $("#cboTransactionType_CM").trigger('change');

                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }
            function GetTellersSummary() {
                $("#tblTellerSummary_CM > tbody:last").children().remove();
                $("#divTellerBalance").html("<h5>Your Balance is:</h5>");
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellerSummary") %>",
                    data: '{}',
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $.each(response, function (index, teller_summary) {
                            $("#divTellerBalance").html("<h5>Your Balance is: <span class='text-decoration-underline'>" + teller_summary.CurrencySymbol + " " + teller_summary.Balance.formatMoney() + "</span></h5>");
                            $("#bdTellerSummary_CM").append("<tr><th>Teller A/C</th><td>" + teller_summary.AccountCode + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><th>A/C Name</th><td>" + teller_summary.TellerAccountName + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><th>Balance</th><td>" + teller_summary.CurrencySymbol + " " + teller_summary.Balance.formatMoney() + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><th>Max Payable</th><td>" + teller_summary.MaxAmtPayable.formatMoney() + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><th>Max Float</th><td>" + teller_summary.MaxFloat.formatMoney() + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><th>Replenishing Level</th><td>" + teller_summary.ReplenishingLevel.formatMoney() + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><th>Shortage A/C</th><td>" + teller_summary.ShortageAccount + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><th>Surplus A/C</th><td>" + teller_summary.SurplusAccount + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><th>Treasury A/C</th><td>" + teller_summary.TreasuryAccount + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><th>Treasury A/C Name</th><td>" + teller_summary.TreasuryAccountName + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><th>RefID</th><td>" + teller_summary.RecID + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><th>Module</th><td>" + teller_summary.ModuleName + "</td></tr>");
                            $("#bdTellerSummary_CM").append("<tr><th>DocLastValue</th><td>" + teller_summary.DocLastValue + "</td></tr>");
                        });
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }
            function DispTransactionsLog() {
                $("#tblTransactionsLog > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellersTransactionLog") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'PeriodCode': $("#cboPeriod").val(), 'TransDate': $("#txtLogDate").val(), 'TellerAccount': '', 'TellerOnly': 'Y' }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var row = "";
                        $.each(response, function (index, teller_log) {


                            row = "<tr>";
                            row += "<td>" + teller_log.TransDate + "</td>";
                            row += "<td>" + teller_log.TransTime + "</td>";
                            row += "<td>" + teller_log.DocNo + "</td>";
                            row += "<td>" + teller_log.TransName + "</td>";
                            row += "<td class='td_amount_col'  style='padding-right:7px'>" + teller_log.Amount.formatMoney(); + "</td>";
                            row += "<td>" + teller_log.ContraAcc + "</td>";
                            row += "<td>" + teller_log.ContraAccName + "</td>";

                            var pdf_url = "<a href='" + global_site_root + "/Bank/BankSystem/TellerCashSlipReport?DBName=" + $("#cboYear").val() + "&DocNo=" + teller_log.DocNo + "&PeriodCode=" + $("#cboPeriod").val() + "&TransType=" + teller_log.TransName + "'>View Slip</a>";

                            row += "<td>" + pdf_url + "</td>";

                            row += "</tr>";
                            $("#bdTransactionsLog").append(row);
                        });
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }

            function ClearAll() {
                $("#tblAccountMembers > tbody:last").children().remove();
                $("#divAccountDetails").html("");
                $("#divMemberPhoto").html("");
                $("#divMemberSignature").html("");
            }
            function LoadImageFromUrl(path, width, height, target) {
                //add code to clear target first!!!
                $('<img src="' + path + '">')
                .load(function () {
                    $(this).width(width).height(height).appendTo(target);
                }).error(function () {
                    //display error somewhere
                });
            }
            function PostTellerCashManagement(outData) {

                outData = JSON.stringify(outData);

                $("#btnPost_CM").attr('disabled', true);
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/PostTellerCashManagement") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        GetTellersSummary();
                        xDialogMessage($("#cboTransactionType_CM option:selected").text() + " posted successfully", "Posted").then(function () {
                            $("#cboTransactionType_CM").prop('selectedIndex', 0);
                            $("#btnPost_CM").attr('disabled', false);
                        });
                    },
                    error: function (xhr, status, error) {
                        $("#btnPost_CM").attr('disabled', false);
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
alert('Error - ' + errorMessage);
                    }
                });

            }
            function DisplayAccountDetails() {
                ClearAll();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellerTransactingAccountDetails") %>",
                    data: JSON.stringify({ 'TransactingAccount': $("#cboAccount").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        if (response.IsCustomerAccount == true) {
                            var MemAcc = response.detailedCustomerAccount.MemberAcc;
                            strAccountName = MemAcc.AccountName;
                            strAccountCode = MemAcc.AccountNo;
                            var strAccDetails = "<table class='table'>";
                            strAccDetails += "<tr><th>Account Name</th><td>" + MemAcc.AccountName + "</td></tr>";
                            strAccDetails += "<tr><th>Account No</th><td>" + MemAcc.AccountNo + "</td></tr>";
                            strAccDetails += "<tr><th>Acc Type</th><td>" + MemAcc.AccountType + "</td></tr>";
                            strAccDetails += "<tr><th>Available Balance</th><td>" + response.detailedCustomerAccount.AvailableBalance + "</td></tr>";
                            strAccDetails += "<tr><th>Actual Balance</th><td>" + response.detailedCustomerAccount.LedgerBalance + "</td></tr>";
                            strAccDetails += "<tr><th>Type Name</th><td>" + MemAcc.AccountTypeName + "</td></tr>";
                            strAccDetails += "<tr><th>File No</th><td>" + MemAcc.FileNo + "</td></tr>";
                            strAccDetails += "<tr><th>Last Deposit Date</th><td>" + MemAcc.DateOfLastDeposit + "</td></tr>";
                            strAccDetails += "<tr><th>Last Withdrawal Date</th><td>" + MemAcc.DateOfLastWithdrawal + "</td></tr>";
                            strAccDetails += "<tr><th>Date Openned</th><td>" + MemAcc.OpenningDate + "</td></tr>";
                            strAccDetails += "<tr><th>Branch</td><th>" + MemAcc.BranchName + "</td></tr>";
                            strAccDetails += "<tr><th>Status</td><th>" + MemAcc.Status + "</td></tr>";
                            strAccDetails += "<tr><th>Instructions</th><td>" + MemAcc.Instructions + "</td></tr>";
                            strAccDetails += "</table>";

                            $("#divAccountDetails").html(strAccDetails);
                            var acc_members = response.detailedCustomerAccount.AccountMembers;
                            var row = "";
                            $.each(acc_members, function (index, acc_member) {
                                row = "<tr>";
                                row += "<td>" + acc_member.EmployerCode + "</td>";
                                row += "<td>" + acc_member.PayrollNo + "</td>";
                                row += "<td>" + acc_member.MemberNo + "</td>";
                                row += "<td>" + acc_member.IDNumber + "</td>";
                                row += "<td>" + acc_member.FullNames + "</td>";
                                row += "</tr>";
                                $("#bdAccountMembers").append(row);
                            });
                            LoadImageFromUrl(response.detailedCustomerAccount.PhotoPath, 400, 340, $("#divMemberPhoto"));
                            LoadImageFromUrl(response.detailedCustomerAccount.SignaturePath, 400, 340, $("#divMemberSignature"));
                        } else {
                            strAccountName = response.otherAccountDetails.AccountName;
                            strAccountCode = response.otherAccountDetails.UserCode;
                            var strAccDetails = "Account Name : " + response.otherAccountDetails.AccountName + "</br>";
                            strAccDetails += "Account No : " + response.otherAccountDetails.UserCode + "</br>";
                            strAccDetails += "Acc Type : " + "Non-Customer Account" + "</br>";
                            $("#divAccountDetails").html(strAccDetails);
                        }
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }

            function LoadTransactionCharges() {
                $("#tblCharges > tbody:last").children().remove();
                if (!isNumber($("#txtAmount").val())) {
                    alert("Invalid Amount");
                    return;
                }
                var amt = $("#txtAmount").val();
                if (+amt <= 0) {
                    alert("Invalid Amount");
                    return;
                }

                $("#tblCharges > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellerTransactionCharges") %>",
                    data: JSON.stringify({ 'CustomerAccount': $("#cboAccount").val(), 'TransactionType': $("#cboTransactionType").val(), 'TransactionAmount': $("#txtAmount").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var trans_charges = response.ChargeDetails;
                        var row = "";
                        $.each(trans_charges, function (index, trans_charge) {
                            row = "<tr>";
                            row += "<td>" + trans_charge.AccountNo + "</td>";
                            row += "<td>" + trans_charge.AccountName + "</td>";
                            row += "<td><input type='text' id='description[]' value='" + trans_charge.Description + "'/></td>";
                            row += "<td><input type='text' id='charges[]' value='" + trans_charge.Amount + "'/></td>";
                            row += "</tr>";
                            $("#bdCharges").append(row);
                        });
                        $('#divCharges').find('input, textarea, button, select a').attr('disabled', 'disabled');
                        $("#btnAddCharges").attr('disabled', 'disabled');
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
alert('Error - ' + errorMessage);
                    }
                });

            }


            function LoadCustomerAccounts() {
                $("#cboAccount").empty();
                $("#cboAccount").append('<option selected>NO ACCOUNT</option>');
                if ($("#txtSearchValue").val().trim() == "") { return; }
                if ($("#txtSearchValue").val().trim() == AccountMask) { return; }

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetBankStatementAccounts") %>",
                    data: JSON.stringify({ 'SearchBy': $("#cboSearchBy").val(), 'SearchValue': $("#txtSearchValue").val(), 'EmpCode': $("#cboEmployer").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var customerAccounts = response;
                        var obj = document.getElementById("cboAccount");
                        $("#cboAccount").empty();
                        $.each(customerAccounts, function (index, customerAccount) {
                            var opt = document.createElement("option");
                            opt.value = customerAccount.UserCode;
                            opt.text = "A/C: " + customerAccount.UserCode + " A/C Name: " + customerAccount.AccountName;
                            obj.appendChild(opt);
                        });
                        DisplayAccountDetails();
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }
            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            //$(function () {
            //    $("#tabs").tabs();
            //});
            $(function () {
                $("#accordion").accordion();
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">


</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <h3>Teller Cash Transactions</h3>
    <div id="tabs" class="card">
        <div class="mb-4 mx-auto d-flex justify-content-center col-12 col-md-8 ">
             <div id="customTabs" class="custom-tabs  position-relative">
      <ul class="custom-tabs-nav mb-0 d-flex list-unstyled">
        <li><a href="#tab1" data-tab="tab1" class="custom-tab-label active">Cash Transactions</a></li>
        <li><a href="#tab2" data-tab="tab2" class="custom-tab-label">BOSA Receipts</a></li>
        <li><a href="#tab3" data-tab="tab3" class="custom-tab-label">Petty Cash</a></li>
        <li><a href="#tab4" data-tab="tab4" class="custom-tab-label">Non-Customer Chq. Sales</a></li>
        <li><a href="#tab5" data-tab="tab5" class="custom-tab-label">Transaction Log</a></li>
        <li><a href="#tab6" data-tab="tab6" class="custom-tab-label">Cash Management</a></li>
      </ul>
      <span class="custom-glider position-absolute d-flex" style="transform: translateX(0);"></span>
      </div>
      </div>
    <form id="frmMain" name="frmMain" >
    <%= Html.AntiForgeryToken() %>
        <div id="tab1" class="tab-content-panel active" >
    
                    <div class="row mb-4">
                            <div class="col-md-4">
                                <label class="form-label">Search By</label>
                                    <select id="cboSearchBy" class="form-select">
                                        <option value="accountno" selected>AccountNo</option>
                                        <option value="memberno">MemberNo</option>
                                        <option value="idnumber">IDNo</option>
                                        <option value="payrollno">PayrollNo</option>
                                    </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Employer</label>
                                <select id="cboEmployer" class="form-select">
                                    <option value="selectemployer" selected>SELECT EMPLOYER</option>
                                </select>
                            </div>
                
                
                            <div class="col-md-4">
                                <label id="divSearchDisplay">Search Value</label>
                                <input type="text" id="txtSearchValue" class="form-control"/>
                            </div>
                        
                            <div class="col-md-4">
                                <label class="form-label">Select Account</label>
                                <select id="cboAccount" class="form-select">
                                    <option>SELECT ACCOUNT</option>
                                </select>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Transaction Type</label>
                                <select id="cboTransactionType" class="form-select">
                                    <option selected value="">SELECT TRANSACTION</option>
                                    <option value="cash withdrawal">CASH WITHDRAWAL</option>
                                    <option value="cash deposit">CASH DEPOSIT</option>
                                </select>
                            </div>
                
                            <div class="col-md-4">
                                <label class="form-label">Amount</label>
                                <input type="text" id="txtAmount" class="form-control"/>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">ATP No.</label>
                                <input type="text" id="txtATPNo" class="form-control"/>
                            </div>
                        <div class="col-md-4">
                            <label class="form-label">Description</label>
                            <input type="text" id="txtDescription" class="form-control"/>
                        </div>
                
                    </div>
                
                    <div class="d-flex flex-wrap justify-content-between justify-content-sm-center gap-sm-3" style=" border-top: 1px dashed; border-radius: 0px; padding-top: 10px;">
                            <div class="d-flex flex-column">
                                <label class="form-label">Account Details:</label>
                                <div id="divAccountDetails" class="card"></div>
                            </div>
                        <div class="d-flex flex-column">
                            <label class="form-label">Member Photo:</label>
                            <div id="divMemberPhoto" ></div>
                        </div>
                        <div class="d-flex flex-column">
                            <label class="form-label">Member Signature:</label>
                            <div id="divMemberSignature" ></div>
                        </div>
                    </div>

                <div class="mb-5 mt-5" style=" border-top: 1px dashed; border-radius: 0px; padding-top: 10px;">
                    <div style="height:100px;overflow:auto;width:auto;">
                    <h5>Account Members</h5>
                        <table id='tblAccountMembers' class='table table-responsive'>
                            <thead>
                                <tr>
                                    <th style="text-align: left">EmpCode</th>
                                    <th style="text-align: left">PayrollNo</th>
                                    <th style="text-align: left">MemberNo</th>
                                    <th style="text-align: left">IDNo</th>
                                    <th style="text-align: left">Names</th>
                                </tr>
                            </thead>
                            <tbody id='bdAccountMembers' >
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div class="mb-5 mt-5" style=" border-top: 1px dashed; border-radius: 0px; padding-top: 10px;">
                    <div id="divCharges" >
                        <h5>Transaction Charges</h5>
                        <table id='tblCharges' class='table'>
                            <thead>
                                <tr>
                                <th style="text-align: left"><b>Account No</b></th>
                                <th style="text-align: left"><b>Acc/ Name</b></th>
                                <th style="text-align: left"><b>Description</b></th>
                                <th style="text-align: right"><b>Amount</b></th>
                                </tr>
                            </thead>
                            <tbody id='bdCharges'>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>

                    <div class="d-flex gap-4">
                        <input type="button" id="btnPrintLastSlip" class="btn btn-success" value="Print Last Slip"/>
                        <input type="button" id="btnAddCharges" value="Add Charge" class="btn btn-primary"/>
                        <input type="button" id="btnPost" value="Post" class="btn btn-secondary"/>
                    </div>
    
        </div>
   
        <div id="tab2" class="tab-content-panel">  
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="cboSearchBy" class="form-label">Search by:</label>
                            <select id="cboSearchBy_BR" class="form-select">
                                <option value="memberno">MemberNo</option>
                                <option value="idnumber">IDNo</option>
                                <option value="payrollno">PayrollNo</option>
                               </select>
                        </div>
                        <div class="col-md-4">
                            <label for="cboEmployer" class="form-label">Employer</label>
                            <select id="cboEmployer_BR" class="form-select">
                                <option value="selectemployer" selected>SELECT EMPLOYER</option>
                           </select>
                        </div>
                        <div class="col-md-4" id="divSearchBy_BR">
                            <label for="txtSearchValue" class="form-label">Search Value</label>
                            <input type="text" id="txtSearchValue_BR" class="form-control"/>
                        </div>
                    </div>
                    <div class="mt-5 mb-5">
                        <div id="divMemberDetails_BR" style="height:auto;overflow:auto;width:auto;">
                        <h5>Member Details</h5>
                            <table id='tblMemberDetails_BR' class="table">
                            <thead>
                                <tr>
                                <th>MemberNo</th>
                                <th>EmpCode</th>
                                <th>PayrollNo</th>
                                <th>Names</th>
                                <th>IDNo</th>
                                </tr>
                            </thead>
                            <tbody id='bdMemberDetails_BR'>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td></td><td></td><td></td><td></td><td></td>
                                </tr>
                            </tfoot>
                            </table>  
                        </div>
                    </div>
                
                    <div class="mb-5 mt-5">
                        <div id="divMPAItems_BR" style="height:200px;overflow:auto;width:auto;">
                    <h5> MPA Items</h5>
                            <table id='tblMPAItems_BR' class="table table-responsive">
                            <thead>
                                <tr>
                                <th>Type</th>
                                <th>Code</th>
                                <th>Name</th>
                                <th style="text-align:right">Balance</th>
                                <th style="text-align:right">Amount</th>
                                </tr>
                            </thead>
                            <tbody id='bdMPAItems_BR'>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td></td><td></td><td></td><td></td><td></td>
                                </tr>
                            </tfoot>
                            </table> 
                        </div>
                </div>
                
                    <div class="d-flex gap-5">
                        <input type="button" class="btn btn-success" id="btn_AddAcc_BR" value="Add A/C" /></td>
                        <input type="button" class="btn btn-primary" id="btnPost_BR" value="Post" />
                </div>
        </div>
        <div id="tab3" class="tab-content-panel">
            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="txtPettyCashDocNo" class="form-label">Petty Cash Doc No:</label>
                    <input type="text" id="txtPettyCashDocNo" class="form-control"/>
                </div>
                <div class="col-md-4">
                    <label for="txtPTDocDate" class="form-label">Doc Date</label>
                    <input type="text" id="txtPTDocDate" readonly="true" class="form-control"/>
                </div>
                <div class="col-md-4">
                    <label for="txtPTStatus" class="form-label">Status</label>
                    <input type="text" id="txtPTStatus" readonly="true" class="form-control"/>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="txtPTPaidTo" class="form-label">Paid To:</label>
                    <input type="text" id="txtPTPaidTo"  readonly="true" class="form-control"/>
                </div>
                <div class="col-md-4">
                    <label for="txtPTIDNo" class="form-label">ID Number:</label>
                    <input type="text" id="txtPTIDNo"  readonly="true" class="form-control"/>
                </div>
                <div class="col-md-4">
                    <label for="txtPTTotal" class="form-label">Total</label>
                    <input type="text" id="txtPTTotal"  readonly="true" class="form-control"/>
                </div>
            </div>
    
            <div id="divPettyCashDetails" style="height:200px;overflow:auto;width:auto;">
                <table id='tblPettyCashDetails' class="display"  style="width:100%">
                        <thead>
                            <tr>
                            <th>Narration</th>
                            <th>Account</th>
                            <th>Acc Name</th>
                            <th class="td_amount_col">Amount</th>
                            <th></th>
                            </tr>
                        </thead>
                        <tbody id='bdPettyCashDetails'>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td></td><td></td><td></td><td></td><td></td>
                            </tr>
                        </tfoot>
                </table>
            </div>
            <div>
                    <input type="button" id="btnPostPettyCash" value="Post Petty Cash" class="btn btn-success"/>
            </div>
        </div>
        <div id="tab4" class="tab-content-panel">

        </div>
        <div id="tab5" class="tab-content-panel">
            <div class="row md-3">
                <div class="col-md-3">
                    <label for="cboYear" class="form-label">Year</label>
                    <select id="cboYear" class="form-select"></select>
                </div>
                <div class="col-md-4">
                    <label for="cboPeriod" class="form-label">Month</label>
                    <select id="cboPeriod" class="form-select"></select>
                </div>
                <div class="col-md-4">
                    <label for="txtLogDate" class="form-label">Date</label>
                    <input type="text" id="txtLogDate" class="form-control"/>
                </div>
            </div>
            <div class="mt-3"> 
                <button type="button" id="btnRefreshLog" class="btn btn-secondary">Refresh Log</button>
              </div>
            
            <div id="divTransactionsLog" style="height:400px;overflow:auto;width:auto;" class="table table-responsive">
                 <table id='tblTransactionsLog' class="table table-responsive table-striped">
                            <thead>
                                <tr>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Doc No</th>
                                <th>Type</th>
                                <th class='td_amount_col' style="padding-right:7px">Amount</th>
                                <th>AccountNo</th>
                                <th>AccountName</th>
                                <th>View Slip</th>
                                </tr>
                            </thead>
                            <tbody id='bdTransactionsLog'>
                            </tbody>
                       
                    </table>     
            </div>
            
        </div>
        <div id="tab6" class="tab-content-panel">
            <div id="divCashManagement">
                <div id="divTellerBalance"></div>
                <div id="divTellersummary" class="mt-4">
                <h5 class="text-decoration-underline">Teller Summary</h5>
                    <table id='tblTellerSummary_CM' class="table">
                        <thead>
                            <tr>
                            <th style="padding-right:7px">Description</th>
                            <th style="padding-right:7px">Value</th>
                            </tr>
                        </thead>
                        <tbody id='bdTellerSummary_CM'>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td></td><td></td>
                            </tr>
                        </tfoot>
                        </table> 
                </div>
              
                <div class="mt-3">
                    <h5 class="text-decoration-underline">Cash Management</h5>
                        <div class="row">
                                <div class="col-md-4">
                                <label class="form-label">
                                    Select Transaction Type:
                                </label>
                                <select id="cboTransactionType_CM" class="form-select">
                                    <option selected value="">(SELECT TRANSACTION)</option>
                                    <option value="receive from treasury">Receive From Treasury</option>
                                    <option value="return to treasury">Return To Treasury</option>
                                    <option value="Issue to teller">Issue To Teller</option>
                                    <option value="receive from teller">Receive From Teller</option>
                                </select>
                                </div>

                                <div class="col-md-4">
                                    <label class="form-label">Amount</label>
                                    <input type="text" id="txtAmount_CM" class="form-control"/>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Doc. No</label>
                                    <input type="text" id="txtDocNo_CM" class="form-control"/>
                                </div>
                                
                                <div id="divTellersList" class="mt-5">
                                    <table id='tblTellersList_CM' class="table table-responsive">
                                        <thead>
                                            <tr>
                                            <th>Login</th>
                                            <th>Names</th>
                                            <th>Teller A/C</th>
                                            <th>A/C Name</th>
                                            <th class='td_amount_col' style="padding-right:7px">Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody id='bdTellersList_CM'>
                                        </tbody>
                                    </table> 
                                </div>
                                <div class="mt-3">
                                    <input type="button" id="btnPost_CM" value="Post" class="btn btn-success"/>
                                </div>
                </div>
        </div>
        
        <iframe id="ifrPdfSlip" name="ifrPdfSlip"  width="300" height="400" style="visibility:hidden">
                        
        </iframe>
    </form>

 </div>



    

</asp:Content>


