﻿<%@ Page Title="Members Master File" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Members Master File
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        #divMemberPhoto {
            width: 350px;
            height: 350px;
            background-position: center center;
            background-size: cover;
           border: 1px solid #dbdade;
            display: inline-block;
        }

        #divMemberSignature {
            width: 350px;
            height: 350px;
            background-position: center center;
            background-size: cover;
           border: 1px solid #dbdade;
            display: inline-block;
        }

		h6{
			margin-top: 10px;
		}

        .dataTables_wrapper{
            overflow: auto !important;
        }

        .dataTables_scrollHeadInner{
            width:auto !important;
        }

       
        .nav-pills{
            color: black !important;
        }
      
        
    </style>
    <script type="text/javascript"  >

        $(document).ready(function () {
            <%=""%> //The name '__o' does not exist in the current context, https://stackoverflow.com/questions/31886413/the-name-o-does-not-exist-in-the-current-context
            var editEmpCode = "";
            var editPayrollNo = "";
            var editMode = false;
            var MembersDesignationList = null;

            
                
            <% if (ViewBag.EditEmpCode!=null)
                { %>
                editEmpCode = "<%: ViewBag.EditEmpCode %>";
                editPayrollNo = "<%: ViewBag.EditPayNo %>";
            <% }
            %>
           
            

            $("#txtEmployDate").datepicker({ dateFormat: 'dd/mm/yy' });
            $("#txtJoinDate").datepicker({ dateFormat: 'dd/mm/yy' });
            $("#txtDOB").datepicker({ dateFormat: 'dd/mm/yy' });
            $("#txtCompanyRegDate").datepicker({ dateFormat: 'dd/mm/yy' });
            $("#txtTaxExemptedStartDate").datepicker({ dateFormat: 'dd/mm/yy' });
            $("#txtTaxExemptEndDate").datepicker({ dateFormat: 'dd/mm/yy' });
            

            $('#frmMMF').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMMF').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMMF').on('focus', 'select,[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMMF').on('focusout', 'select,[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });
            $("#txtAccountNo").on('focus', function () {
                if (AccountMask != "") {
                    $("#txtAccountNo").mask(AccountMask);
                }
            });
            // $('#tblMemberAccounts').dataTable({
            //     "paging": false,
            //     "ordering": false,
            //     "info": false,
            //     "searching": false
            // });
            // $("#tblDirectors").dataTable({
            //     "paging": false,
            //     "ordering": false,
            //     "info": false,
            //     "searching": false
            // });
            //$('#divPics :input').prop('disabled', true);
            //try $('#divPics *').prop('disabled',true); to disable everything in div
            document.getElementById('cboOpenAccount').selectedIndex = 0;


            $("#cboAccountType").on('change', function () {
                $("#txtAccountNo").val("");
            });
            $("#btnBOSAStatement").on('click', function () {
                ShowBOSAStatement();
            });
            $("#btnFOSAStatement").on('click', function () {
                ShowBankStatement();
            });
            $("#cboEntityType").on('change', function () {
                $("#liPersonal").hide();
                $("#div1-subtab1").hide();
                $("#liCompany").hide();
                $("#div1-subtab2").hide();
                if ($("#cboEntityType option:selected").index() == 1) { //INDIVIDUAL
                    $("#liPersonal").show();
                    $("#div1-subtab1").show();
                } else if ($("#cboEntityType option:selected").index() == 2) { //COMPANY
                    $("#liCompany").show();
                    $("#div1-subtab2").show();
                }

            });
            $("#btnGenerateAccNo").on('click', function () {
                var header_acc = $("#cboAccountType").val();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GenerateMemberAccount") %>",
                    data: JSON.stringify({ 'HeaderAccount': header_acc }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#txtAccountNo").val(response);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        alert(errorMessage, "Error!");
                    }
                });
            });
            $("#btnGeneratePayrollNo").on('click', function () {
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GeneratePayrollNo") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#txtPayrollNo").val(response);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });
            $("#btnGenerateMemberNo").on('click', function () {
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GenerateMemberNo") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#txtMemberNo").val(response);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        alert(errorMessage, "Error!");
                    }
                });
            });

            $(function () {
                $("#imageMemberPhoto").on("change", function () {
                    var files = !!this.files ? this.files : [];
                    if (!files.length || !window.FileReader) return; // no file selected, or no FileReader support
                    if (/^image/.test(files[0].type)) { // only image file
                        var reader = new FileReader(); // instance of the FileReader
                        reader.readAsDataURL(files[0]); // read the local file

                        reader.onloadend = function () { // set image data as background of div
                            $("#divMemberPhoto").css("background-image", "url(" + this.result + ")");
                        }
                    }
                });
            });

            $(function () {
                $("#imageMemberSignature").on("change", function () {
                    var files = !!this.files ? this.files : [];
                    if (!files.length || !window.FileReader) return; // no file selected, or no FileReader support
                    if (/^image/.test(files[0].type)) { // only image file
                        var reader = new FileReader(); // instance of the FileReader
                        reader.readAsDataURL(files[0]); // read the local file
                        reader.onloadend = function () { // set image data as background of div
                            $("#divMemberSignature").css("background-image", "url(" + this.result + ")");
                        }
                    }
                });
            });


            $(function () {
                $("#btnSavePics").on("click", function () {
                    //for testing only. Use save member function to go through authorization process
                    //UploadFiles();
                });
            });


            

            $("#EditEmpCode").val("");
            $("#EditPayrollNo").val("");

            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetMasterFileConfig") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var mList = response.EmployerList;
                    var obj = document.getElementById("cboEmployer");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.EmployerCode;
                        opt.text = mListItem.EmployerName;
                        obj.appendChild(opt);
                    });
                    var mList = response.MainBanksList;
                    var obj = document.getElementById("cboMainBank");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.MainBankCode;
                        opt.text = mListItem.MainBankName;
                        obj.appendChild(opt);
                    });
                    var mList = response.DistrictList;
                    var obj = document.getElementById("cboHomeDistrict");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.DistrictsCode;
                        opt.text = mListItem.DistrictsName;
                        obj.appendChild(opt);
                    });
                    var mList = response.DistrictList;
                    var obj = document.getElementById("cboPresentDistrict");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.DistrictsCode;
                        opt.text = mListItem.DistrictsName;
                        obj.appendChild(opt);
                    });
                    var mList = response.DesignationList;
                    MembersDesignationList = response.DesignationList;
                    var obj = document.getElementById("cboDesignation");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.DesgCode;
                        opt.text = mListItem.DesgName;
                        obj.appendChild(opt);
                    });
                    var mList = response.TermsOfServList;
                    var obj = document.getElementById("cboTermsOfService");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.TermsCode;
                        opt.text = mListItem.TermsName;
                        obj.appendChild(opt);
                    });
                    var mList = response.BranchesList;
                    var obj = document.getElementById("cboBranch");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.BranchCode;
                        opt.text = mListItem.BranchName;
                        obj.appendChild(opt);
                    });
                    var mList = response.StatusList;
                    var obj = document.getElementById("cboStatus");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.StatusCode;
                        opt.text = mListItem.StatusName;
                        obj.appendChild(opt);
                    });
                    var mList = response.TitleList;
                    var obj = document.getElementById("cboTitle");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.TitleCode;
                        opt.text = mListItem.TitleName;
                        obj.appendChild(opt);
                    });
                    var mList = response.MemberTypesList;
                    var obj = document.getElementById("cboMemberType");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.TypeCode;
                        opt.text = mListItem.TypeName;
                        obj.appendChild(opt);
                    });
                    var mList = response.CategoryList;
                    var obj = document.getElementById("cboCategory");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.CategoryCode;
                        opt.text = mListItem.CategoryName;
                        obj.appendChild(opt);
                    });
                    var mList = response.GenderList;
                    var obj = document.getElementById("cboGender");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.GenderType;
                        opt.text = mListItem.GenderType;
                        obj.appendChild(opt);
                    });
                    var mList = response.CompanyTypes;
                    var obj = document.getElementById("cboCompanyType");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.MMFCompanyType;
                        opt.text = mListItem.MMFCompanyType;
                        obj.appendChild(opt);
                    });
                    var mList = response.WorkStationsList;
                    var obj = document.getElementById("cboWorkStation");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.WorkStationCode;
                        opt.text = mListItem.WorkStationName;
                        obj.appendChild(opt);
                    });
                    var mList = response.BankBranchList;
                    var obj = document.getElementById("cboBankBranch");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.BranchCode;
                        opt.text = mListItem.BranchName;
                        obj.appendChild(opt);
                    });
                    var mList = response.MemberAccTypes;
                    var obj = document.getElementById("cboAccountType");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.AccountCode;
                        opt.text = mListItem.AccountName + "(" + mListItem.AccountCode + ")";
                        obj.appendChild(opt);
                    });
                    if (AccountMask != "") {
                        $("#txtAccountNo").mask(AccountMask);
                    }
                    DispMember();
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    //alert('Error - ' + errorMessage);
                    alert(errorMessage, "Error!");

                }
            });

            $("#btnAddMember").click(function () {
                
                document.location = strMembersMasterFilePath; //TODO: make sure to clear all lists etc instead of a new http request

                $("#cboDefaultAccount").empty();
                $("#cboDefaultAccount").append("<option value=''>NONE</option>");

                $("#EditEmpCode").val("");
                $("#EditPayrollNo").val("");
                $("#txtMemberNo").val("");
                $("#txtPayrollNo").val("");
                $("#txtIDNumber").val("");
                $("#txtSurname").val("");
                $("#txtOtherNames").val("");
                $("#txtDOB").val("");
                $("#txtEmployDate").val("");
                $("#txtJoinDate").val("");
                $("#txtRetirementAge").val("");
                $("#txtRecruitedBy").val("");
                $("#txtIntroducedBy").val("");
                $("#txtPresentPostCode").val("");
                $("#txtPresentAddress").val("");
                $("#txtPresentTown").val("");
                $("#txtHomePostCode").val("");
                $("#txtHomeAddress").val("");
                $("#txtHomeTown").val("");
                $("#txtPhoneNo").val("");
                $("#txtFax").val("");
                $("#txtEMail").val("");
                $("#txtLandLine").val("");
                $("#txtBankAccountNo").val("");
                $("#txtAccountNo").val("");

                resetCombo(document.getElementById('cboDefaultAccount'));
                resetCombo(document.getElementById('cboMemberType'));
                resetCombo(document.getElementById('cboTitle'));
                resetCombo(document.getElementById('cboGender'));
                resetCombo(document.getElementById('cboEmployer'));
                resetCombo(document.getElementById('cboCategory'));
                resetCombo(document.getElementById('cboWorkStation'));
                resetCombo(document.getElementById('cboDesignation'));
                resetCombo(document.getElementById('cboStatus'));
                resetCombo(document.getElementById('cboBranch'));
                resetCombo(document.getElementById('cboTermsOfService'));
                resetCombo(document.getElementById('cboPresentDistrict'));
                resetCombo(document.getElementById('cboHomeDistrict'));
                resetCombo(document.getElementById('cboMainBank'));
                resetCombo(document.getElementById('cboBankBranch'));
                resetCombo(document.getElementById('cboAccountType'));

            });

            $("#btnSearchMember").on('click', function (e) {
                xDialogSearchMemberRecord(AccountMask).then(function (data) {
                    editEmpCode = data.EmployerCode;
                    editPayrollNo = data.PayrollNo;
                    DispMember();
                });
            });

            $("#btnSaveMember").click(function () {
                SaveMember();
            });
            $("#btnAddDirector").click(function () {
                AddDirectorDialog();
            });
            
            $('#bdDirectors').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_director_name = $(this).closest('tr').find('td').eq(0).text();
                var rm_director_id = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Director from List? IDNo: = " + rm_director_id + " Name : " + rm_director_name + "?", "Confirm").then(function () {
                    $(rm_row).remove();
                });
                return false;
            });
            function AddDirectorDialog() {
                    $('<div id="divAddDirectorDialog" class="bg-white"></div>').dialog({
                        modal: true,
                        title: "Add Director/Member",
                        height: 600,
                        autoOpen: true,
                        class:"bg-dark",
                        show: {
                            effect: "blind",
                            direction: "up",
                            duration: 100
                        },

                        buttons: {
                            'OK': {
                                'text': 'OK',
                                'id': 'btnOK',
                                'class':'btn btn-success',
                                'click': function () {
                                    if ($("#txtDirectorName").val().trim().length ="" ) { alert("Invalid Director Name"); return false; }
                                    if ($("#txtDirectorAddress").val().trim() == "") { alert("Invalid Director Address"); return false; }
                                    if ($("#txtDirectorIDNo").val().trim() == "") { alert("Invalid Director IDNo"); return false; }
                                    if ($("#txtDirectorPhoneNo").val().trim() == "") { alert("Invalid Director Phone No"); return false; }
                                    if ($("#txtDirectorDOB").val().trim() == "") { alert("Invalid Director Date of Birth (DOB)"); return false; }

                                    if ($("#cboDirectorDesignation option:selected").index() == 0) { alert("Invalid Director Designation"); return false; }

                                    var tbl_row = "<tr>";
                                    tbl_row += "<td>" + $("#txtDirectorName").val().trim() + "</td>";
                                    tbl_row += "<td>" + $("#txtDirectorIDNo").val().trim() + "</td>";
                                    tbl_row += "<td>" + $("#txtDirectorPinNo").val().trim() + "</td>";
                                    tbl_row += "<td>" + $("#txtDirectorAddress").val().trim() + "</td>";
                                    tbl_row += "<td>" + $("#txtDirectorPhoneNo").val().trim() + "</td>";
                                    tbl_row += "<td>" + $("#txtDirectorDOB").val().trim() + "</td>";
                                    tbl_row += "<td>" + $("#txtDirectorEMail").val().trim() + "</td>";
                                    tbl_row += "<td>" + $("#cboDirectorDesignation").val().trim() + "</td>";
                                    tbl_row += "<td>Y</td>";
                                    tbl_row += "<td><a href='#'>Remove<a/></td>";
                                    tbl_row += "</tr>";
                                    
                                    $("#bdDirectors").append(tbl_row);

                                    $("#divAddDirectorDialog").dialog("close");
                            }
                        },

                        'Cancel': {
                            'text':'Cancel',
                            'class':'btn btn-warning',
                            'click':function () {
                            $(this).dialog("close");
                        }}
                    },
                    open: function () {
                        var tbl = "<div id='tblAddDirectorDialog' class='director_card'>";
                        tbl += "<div class='col'>";
                        tbl += "<div class='col-auto'><label class='form-label'>Name:</label><input class='form-control' type='text' id='txtDirectorName' value='' /></div>";
                        tbl += "<div class='col-auto'><label class='form-label'>IDNo:</label><input class='form-control' type='text' id='txtDirectorIDNo' value='' /></div>";
                        tbl += "<div class='col-auto'><label class='form-label'>PinNo:</label><input class='form-control' type='text' id='txtDirectorPinNo' value='' /></div>";
                        tbl += "<div class='col-auto'><label class='form-label'>Addresss:</label><textarea class='form-control' id='txtDirectorAddress'/></textarea></div>";
                        tbl += "<div class='col-auto'><label class='form-label'>EMail:</label><input class='form-control' type='text' id='txtDirectorEMail' value='' /></div>";
                        tbl += "<div class='col-auto'><label class='form-label'>PhoneNo:</label><input class='form-control' type='text' id='txtDirectorPhoneNo' value='' /></div>";
                        tbl += "<div class='col-auto'><label class='form-label'>DOB:</label><input class='form-control' type='date' id='txtDirectorDOB' value=''  /></div>";
                        tbl += "<div class='col-auto'><label class='form-label'>Designation</label><select class='form-select' id='cboDirectorDesignation'><option value=''>SELECT</option></select></div>";
                        tbl += "</div></div>";
                        $(this).html(tbl);
                        
                        $("#txtDirectorName").focus;
                        var obj = document.getElementById("cboDirectorDesignation");
                        $.each(MembersDesignationList, function (index, mListItem) {
                            var opt = document.createElement("option");
                            opt.value = mListItem.DesgCode;
                            opt.text = mListItem.DesgName;
                            obj.appendChild(opt);
                        });
                        $("#txtDirectorDOB").datepicker({ dateFormat: 'dd/mm/yy' });
                    },
                    close: function (event, ui) {
                        $(this).dialog("destroy").remove();
                    }
                });
            }

            function SaveMember() {
                //var validator = form.validate(),
                //alert($('#frmMMF').serializeArray());
                //var input = $('#frmMMF').serializeArray();
                //var p=form2js(rootNode, delimiter, skipEmpty, nodeCallback, useIdIfEmptyName)
                //if (!validator.valid()) { return; }
                // turn the array of form properties into a regular JavaScript object
                //for (var i = 0; i < serialized.length; i++) {
                //    data[serialized[i].name] = serialized[i].value;
                //}

                if (!MMFDataValid()) {
                    return;
                }
                xDialogConfirm("Save Record?", "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        try {

                            var prms = {
                                rootNode: 'frmMMF'
                            };

                            //*****DIRECTORS LIST********

                            var DirectorsCount = 0;
                            var DirectorsList = new Array();
                            
                            $("#tblDirectors tbody").find('tr').each(function (i) {
                                var DirectorEntry = {};
                                var row = $(this); //store in variable for faster access
                                DirectorEntry.MemberName = row.find('td:eq(0)').text();
                                DirectorEntry.IDNumber = row.find('td:eq(1)').text();
                                DirectorEntry.PinNo = row.find('td:eq(2)').text();
                                DirectorEntry.Address = row.find('td:eq(3)').text();
                                DirectorEntry.PhoneNo = row.find('td:eq(4)').text();
                                DirectorEntry.DOB = row.find('td:eq(5)').text();
                                DirectorEntry.EMail = row.find('td:eq(6)').text();
                                DirectorEntry.DesignationCode = row.find('td:eq(7)').text();
                                DirectorEntry.IsSignatory = row.find('td:eq(8)').text();
                                DirectorsList[DirectorsCount] = DirectorEntry;
                                DirectorsCount++;
                            });
                            //*************
                            if ($("#cboEntityType option:selected").index() == 2) { //COMPANY
                                if (DirectorsCount ==0) {
                                    //alert("");
                                    alert("Enter at least 1 director(s)/member(s).")
                                    return;
                                }
                            }

                            var formdata = form2js(prms);

                            var UserName = data.UserName;
                            var Password = data.UserPass;
                            var pwdslt = getRandomInt(1000, 30000);
                            pwdslt = pwdslt.toString();
                            var pwd = CryptoJS.MD5(Password).toString();
                            pwd = pwd + pwdslt;
                            var sltpwd = CryptoJS.MD5(pwd).toString();

                            var jdata = ({ 'FormData': formdata, 'DirectorsList': DirectorsList, 'EditEmpCode': $('#EditEmpCode').val(), 'EditPayrollNo': $('#EditPayrollNo').val(), 'UserName': UserName, 'UserPass': sltpwd, 'Salt': pwdslt });

                            var csrfToken = $("input[name='__RequestVerificationToken']").val();
                            $.ajax({
                                headers: { __RequestVerificationToken: csrfToken },
                                type: 'POST', // Update Action
                                dataType: 'JSON',
                                url: "<%: Url.Content("~/api/BankSystemApi/SaveMember") %>",
                                data: jdata,
                                success: function (data) {
                                    //alert('Record Saved.');
                                    alert("Record Saved");
                                    editEmpCode = data.EmployerCode;
                                    editPayrollNo = data.PayrollNo;
                                    DispMember();
                                },
                                error: function (xhr, status, error) {
                                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                                    //alert('Error - ' + errorMessage);
                                    alert(errorMessage, "Error!");
                                }
                            }).done(function () {
                                UploadFiles();
                            });
                        } catch (era) {
                            //alert(era.toString());
                            alert(era.toString());
                            
                        }
                    });
                });

            }
            function IsValidImageFile(filename) {


                if (filename.length < 1) {
                    //alert("File Name Can not be empty");
                     alert("File Name Can not be empty");
                    
                     return false;
                }


                var validExtensions = new Array();
                var ext = filename.substring(filename.lastIndexOf('.') + 1).toLowerCase();

                validExtensions[0] = 'jpg';
                validExtensions[1] = 'jpeg';
                validExtensions[2] = 'bmp';
                validExtensions[3] = 'png';
                validExtensions[4] = 'gif';


                for (var i = 0; i < validExtensions.length; i++) {
                    if (ext == validExtensions[i]) return true;
                }

                //alert('The file extension ' + ext.toUpperCase() + ' is not allowed!');
                 alert('The file extension ', ext.toUpperCase(),' is not allowed!');
                return false;
            }
            function UploadFiles() {
                //TODO: Add code to resize image here or in Action before saving
                var Photofiles = $("#imageMemberPhoto").get(0).files;
                 console.log(Photofiles)
                if (Photofiles.length > 1) { alert("select only one Member Photo"); }
                var postdata = new FormData();
                var validMemberPhoto = false;
                var validMemberSignature = false;
                for (i = 0; i < Photofiles.length; i++) {
                    var filename = Photofiles[i].name.toString()
                    if (IsValidImageFile(filename)) {
                        var ext = filename.substring(filename.lastIndexOf('.') + 1).toLowerCase();
                        postdata.append("MemberPhoto" + i, Photofiles[i], "PHOTO." + ext);
                        validMemberPhoto = true;
                    }
                }
                var Signaturefiles = $("#imageMemberSignature").get(0).files;
                console.log(Signaturefiles)
                if (Signaturefiles.length > 1) { alert("select only one Signature image"); }
                for (i = 0; i < Signaturefiles.length; i++) {
                    var filename = Signaturefiles[i].name.toString()
                    if (IsValidImageFile(filename)) {
                        var ext = filename.substring(filename.lastIndexOf('.') + 1).toLowerCase();
                        postdata.append("SignaturePhoto" + i, Signaturefiles[i], "SIGNATURE." + ext);
                        validMemberSignature = true;
                    }
                }
                if (!validMemberPhoto && !validMemberSignature) {
                    return; // no files to upload
                }
                postdata.append("FileEmployerCode", $("#cboEmployer").val());
                postdata.append("FilePayrollNo", $("#txtPayrollNo").val());
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/BankSystemApi/UploadFile") %>',
                    contentType: false,
                    data: postdata,
                    processData: false,
                    success: function (messages) {
                        alert("Member Photo / Signature Updated");
                        DispMember();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                         alert(errorMessage, "Error!");
                    }
                });
            }
            function extractErrors(jqXhr, validator) {

                var data = JSON.parse(jqXhr.responseText), // parse the response into a JavaScript object
                error = {};

                for (var i = 0; i < data.length; i++) { // add each error to the errors object
                    errors[data[i].key] = data[i].value;
                }
                //alert(errors);
                 alert(errors, "Error!");
                //validator.showErrors(errors); // show the errors using the validator object
            }



            function getUrlParameter(paramName) {
                var searchString = window.location.search.substring(1),
                    i, val, params = searchString.split("&");
                
                for (i = 0; i < params.length; i++) {
                    val = params[i].split("=");
                    if (val[0] == paramName) {
                        return unescape(val[1]);
                    }
                }
                return null;
            }


            function DispMember() {
                
                $("#divMemberPhoto").html("");
                $("#divMemberSignature").html("");
                $("#divMemberPhoto").html("");
                $("#divMemberSignature").html("");

                $("#bdMemberAccounts").html("");
                $("#bdDirectors").html("");
                if ((editPayrollNo) && (editEmpCode)) {
                    $("#EditEmpCode").val(editEmpCode);
                    $("#EditPayrollNo").val(editPayrollNo);

                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/GetMemberRecordWithAccounts") %>",
                        data: "{'SearchBy' : '" + "payrollno" + "','SearchValue' : '" + editPayrollNo + "','EmpCode' : '" + editEmpCode + "'}",
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            var MemberDetails = response.MemberDetails;
                            var MemberAccounts = response.MemberAccounts;
                            var CompanyDirectors = response.CompanyMembers;
                            
                            $("#cboEntityType").val(MemberDetails.EntityType);
                            $("#cboEntityType").trigger('change');
                            $("#txtMemberNo").val(MemberDetails.MemberNo);
                            $("#txtPayrollNo").val(MemberDetails.PayrollNo);
                            $("#txtIDNumber").val(MemberDetails.IDNumber);
                            $("#txtSurname").val(MemberDetails.Surname);
                            $("#txtOtherNames").val(MemberDetails.OtherNames);
                            $("#txtDOB").val(MemberDetails.DOB);
                            $("#txtPinNo").val(MemberDetails.PinNo);
                            //document.getElementById("txtDOB").valueAsDate = MemberDetails.DOB;
                            //document.getElementById("txtJoinDate").valueAsDate = MemberDetails.JoinDate;
                            $("#txtEmployDate").val(MemberDetails.EmployDate);
                            $("#txtJoinDate").val(MemberDetails.JoinDate);
                            $("#txtRetirementAge").val(MemberDetails.RetirementAge);
                            $("#txtRecruitedBy").val(MemberDetails.RecruitedBy);
                            $("#txtIntroducedBy").val(MemberDetails.IntroducedBy);
                            $("#txtPresentPostCode").val(MemberDetails.PresentPostCode);
                            $("#txtPresentAddress").val(MemberDetails.PresentAddress);
                            $("#txtPresentTown").val(MemberDetails.PresentTown);
                            $("#txtHomePostCode").val(MemberDetails.HomePostCode);
                            $("#txtHomeAddress").val(MemberDetails.HomeAddress);
                            $("#txtHomeTown").val(MemberDetails.HomeTown);

                            $("#txtPhoneNo").val(MemberDetails.PhoneNo);
                            $("#txtFax").val(MemberDetails.Fax);
                            $("#txtEMail").val(MemberDetails.EMailAddress);
                            $("#txtLandLine").val(MemberDetails.PhoneNo);
                            $("#txtBankAccountNo").val(MemberDetails.AccountNo);
                            $("#cboMemberType").val(MemberDetails.MemberTypeCode);
                            $("#cboTitle").val(MemberDetails.TitleCode);
                            $("#cboGender").val(MemberDetails.MemberGender);
                            $("#cboEmployer").val(MemberDetails.EmployerCode);
                            $("#cboCategory").val(MemberDetails.CategoryCode);
                            $("#cboWorkStation").val(MemberDetails.WorkStationCode);
                            $("#cboDesignation").val(MemberDetails.DesignationCode);
                            $("#cboStatus").val(MemberDetails.BOSAStatusCode);
                            $("#cboBranch").val(MemberDetails.BranchCode);
                            $("#cboTermsOfService").val(MemberDetails.TermsOfServCode);
                            $("#cboPresentDistrict").val(MemberDetails.PresentDistrictCode);
                            $("#cboHomeDistrict").val(MemberDetails.HomeDistrictCode);
                            $("#cboMainBank").val(MemberDetails.MainBankCode);
                            $("#cboBankBranch").val(MemberDetails.BankBranchCode);

                            $("#txtCompanyName").val(MemberDetails.CompanyName);
                            $("#txtCompanyRegNo").val(MemberDetails.RegNo);
                            $("#txtCompanyVATNo").val(MemberDetails.VatNo);
                            $("#cboCompanyType").val(MemberDetails.CompanyType);
                            $("#txtCompanyRegDate").val(MemberDetails.CompanyRegDate);
                            $("#txtCompanyDescription").val(MemberDetails.BusinessDescription);
                            if (MemberDetails.TaxExempt == true) {
                                $("#cboTaxExempted").prop("selectedIndex", 1);
                            } else {
                                $("#cboTaxExempted").prop("selectedIndex", 0);
                            }
                            
                            $("#txtTaxExemptedStartDate").val(MemberDetails.TaxExemptStartDate);
                            $("#txtTaxExemptMonths").val(MemberDetails.TaxExemptMonths);
                            $("#txtTaxExemptEndDate").val(MemberDetails.TaxExemptEndDate);
                            $("#txtTaxExemptCertNo").val(MemberDetails.TaxExemptCertNo);
                            $("#txtTaxExemptReason").val(MemberDetails.TaxExemptReason);


                            //$("#divMemberPhoto").css("background-image", "url(" + response.MemberPhotoUrl + ")");
                            //$("#divMemberSignature").attr("src") = response.MemberPhotoUrl;

                            var PhotoPath = response.PhotoPath;
                            var SignaturePath = response.SignaturePath;
                 

                            PhotoPath = '<%: Url.Content("~/TempPhotosAndSignatures/") %>' + response.MemberPhotoUrl;
                            SignaturePath = '<%: Url.Content("~/TempPhotosAndSignatures/") %>' + response.MemberSignatureUrl;

                            
                            PhotoPath = response.MemberPhotoUrl;
                            SignaturePath =  response.MemberSignatureUrl;

                            
                            LoadImageFromUrl(PhotoPath, 350, 350, $("#divMemberPhoto"));
                            LoadImageFromUrl(SignaturePath, 350, 350, $("#divMemberSignature"));

                            

                            $("#cboDefaultAccount").empty();
                            $("#cboDefaultAccount").append("<option value=''>NONE</option>");
                            var row = "";
                            $.each(MemberAccounts, function (index, memAcc) {
                                row += "<tr>";
                                row += "<td>" + memAcc.AccountNo + "</td>";
                                row += "<td>" + memAcc.AccountName + "</td>";
                                row += "<td>" + memAcc.OpenningDate + "</td>";
                                row += "<td>" + memAcc.CreatedBy + "</td>";
                                row += "<td>" + memAcc.BranchCode + "</td>";
                                row += "<td>" + memAcc.AccType + "</td>";
                                row += "<td>" + memAcc.AccTypeName + "</td>";
                                row += "</tr>";
                                $("#cboDefaultAccount").append("<option value='" + memAcc.AccountNo + "'>" + memAcc.AccountNo + "(" + memAcc.AccountName + ")</option>");
                            });
                            $("#tblMemberAccounts").append(row);
                            $("#cboDefaultAccount").val(MemberDetails.SalaryAccount);

                            //***************
                            var row = "";
                            $.each(CompanyDirectors, function (index, CompanyDirector) {
                                row += "<tr>";
                                row += "<td>" + CompanyDirector.MemberName + "</td>";
                                row += "<td>" + CompanyDirector.IDNumber + "</td>";
                                row += "<td>" + CompanyDirector.PinNo + "</td>";
                                row += "<td>" + CompanyDirector.Address + "</td>";
                                row += "<td>" + CompanyDirector.PhoneNo + "</td>";
                                row += "<td>" + CompanyDirector.DOB + "</td>";
                                row += "<td>" + CompanyDirector.EMail + "</td>";
                                row += "<td>" + CompanyDirector.DesignationCode + "</td>";
                                row += "<td>" + CompanyDirector.IsSignatory + "</td>";
                                row += "<td><a href='#'>Remove<a/></td>";
                                row += "</tr>";
                                
                            });
                            $("#tblDirectors").append(row);
                            //***************

                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            //alert('Error - ' + errorMessage);
                             alert(errorMessage, "Error!");
                        }
                    });
                }
            }

            function LoadImageFromUrl(path, width, height, target) {
                
                    //add code to clear target first!!!
                    console.log(path);
                    $('<img src="' + path + '">')
                        .load(function () {
                            $(this).width(width).height(height).appendTo(target);
                        }).error(function () {
                            //display error somewhere
                        });
                
            }
            function resetCombo(cboItem) {
                cboItem.selectedIndex = 0;
            }

            function LoadComboDisplayText(cboItem, itemvalue) {
                for (var i = 0; i < cboItem.options.length; ++i) {
                    if (cboItem.options[i].value == itemvalue) {
                        cboItem.selectedIndex = i;
                    }
                }
            }


            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.
                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }
            $(function () {
               $("#tabs").tabs();
            });
            $(function () {
               $("#subtabs1").responsiveTabs();
            });

             $(function () {
               $("#subtabs2").tabs();
            });


            $('#tabs').responsiveTabs();

            // $('#subtabs1').responsiveTabs({
            //     Start with the panels collapsed if the view is currently accordion based
            //     startCollapsed: 'accordion',
            //     Tabs can be collapsed
            //     collapsible: true,
            //     Tabs auto rotate
            //     rotate: false
            // });

            $(function () {
                $("#accordion").accordion();
            });
            $(function () {
                $("#cboEntityType").trigger('change');
            });
            function MMFDataValid() {
                //we can remove some of this validation but make sure to validate on the server side!!
                if ($("#cboEntityType option:selected").index() == 0) { alert("Select Entity Type"); return false; }
                if ($("#cboEntityType option:selected").index() == 1) { //INDIVIDUAL
                    if ($("#txtIDNumber").val().trim() == "") { alert("Invalid ID Number"); return false; }
                    if ($("#txtRetirementAge").val().trim() == "") { alert("Invalid Retirement Age"); return false; }
                    if ($("#cboDesignation option:selected").index() == 0) { alert("Invalid Designation"); return false; }
                    if ($("#cboTitle option:selected").index() == 0) { alert("Invalid Title"); return false; }
                    if ($("#cboTermsOfService option:selected").index() == 0) { alert("Invalid Terms Of Service"); return false; }
                    if ($("#cboEmployer option:selected").index() == 0) { alert("Invalid Employer"); return false; }
                    if ($("#cboCategory option:selected").index() == 0) { alert("Invalid Category"); return false; }
                    if ($("#cboWorkStation option:selected").index() == 0) { alert("Invalid WorkStation"); return false; }
                    if ($("#cboGender option:selected").index() == 0) { alert("Invalid Gender"); return false; }
                }
                if ($("#cboEntityType option:selected").index() == 2) { //COMPANY
                    if (!IsValidDate($("#txtCompanyRegDate").val())) {
                        alert("Invalid Registration Date");
                        return false;
                    }
                    if ($("#txtCompanyName").val().trim() == "") { alert("Invalid Company Name"); return false; }
                    if (!IsValidDate($("#txtCompanyRegDate").val())) {
                        alert("Invalid Company Reg Date");
                        return false;
                    }
                    $("#txtSurname").val($("#txtCompanyName").val()) ;
                    $("#txtOtherNames").val($("#txtCompanyName").val());
                    $("#txtPayrollNo").val($("#txtCompanyRegNo").val()) ;
                    $("#txtDOB").val($("#txtCompanyRegDate").val());
                    $("#txtJoinDate").val($("#txtCompanyRegDate").val());
                    $("#txtEmployDate").val($("#txtCompanyRegDate").val());
                    $("#cboEmployer").val("000");
                    $("#cboCategory").val("000");
                    $("#cboDesignation").val("000");
                    $("#cboTermOfService").val("000");
                    $("#cboTitle").val("000");
                    $("#cboWorkStation").val("000");
                    $("#cboGender").val("OTHER");
                }
                if ($("#txtMemberNo").val().trim() == "") { alert("Invalid Member No"); return false; }
                if ($("#txtPayrollNo").val().trim() == "") { alert("Invalid Payroll No"); return false; }
                if ($("#txtSurname").val().trim() == "") { alert("Invalid Surname"); return false; }
                if ($("#txtOtherNames").val().trim() == "") { alert("Invalid Other Names"); return false; }
                
                if ($("#txtPresentAddress").val().trim() == "") { alert("Invalid Present Address"); return false; }
                if ($("#txtHomeAddress").val().trim() == "") { alert("Invalid Home Address"); return false; }
                if ($("#txtPresentTown").val().trim() == "") { alert("Invalid Present Town"); return false; }
                if ($("#txtHomeTown").val().trim() == "") { alert("Invalid Home Town"); return false; }
                

                
                if ($("#cboMemberType option:selected").index() == 0) { alert("Invalid MemberType"); return false; }
                
                
                
                if ($("#cboStatus option:selected").index() == 0) { alert("Invalid Member Status"); return false; }
                
                if ($("#cboBranch option:selected").index() == 0) { alert("Invalid Branch"); return false; }
                
                if ($("#cboPresentDistrict option:selected").index() == 0) { alert("Invalid Present District"); return false; }
                if ($("#cboHomeDistrict option:selected").index() == 0) { alert("Invalid Home District"); return false; }

                if ($("#cboOpenAccount option:selected").index() == 0) {
                    if ($("#cboAccountType option:selected").index() == 0) {
                        alert("Select Account Type To Create");
                        return false;
                    } else if ($("#txtAccountNo").val() == "") {
                        alert("Enter account number To Create");
                        return false;
                    }
                }
                if (!IsValidDate($("#txtDOB").val())) {
                    alert("Invalid Date Of Birth");
                    return false;
                }
                if (!IsValidDate($("#txtJoinDate").val())) {
                    alert("Invalid Join Date");
                    return false;
                }
                if (!IsValidDate($("#txtEmployDate").val())) {
                    alert("Invalid Employ Date");
                    return false;
                }
                return true;
            }
        });

		  prefixMask = document.querySelector('.prefix-mask');
		if (prefixMask) {
		new Cleave(prefixMask, {
		prefix: '+254',
		blocks: [3, 3, 3, 3],
		uppercase: true
		});
  }
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FeaturedContent" runat="server">

    
    
                <div class="my-4 mx-auto d-flex justify-content-center col-12 col-md-8 ">
                    <div id="customTabs" class="custom-tabs  position-relative">
                        <ul class="custom-tabs-nav mb-0 d-flex list-unstyled">
                            <li><a href="#tab1" data-tab="tab1" class="custom-tab-label active">General</a></li>
                            <li><a href="#tab2" data-tab="tab2" class="custom-tab-label">Directors/Members</a></li>
                            <li><a href="#tab3" data-tab="tab3" class="custom-tab-label">Photos & Signature</a></li>
                            <li><a href="#tab4" data-tab="tab4" class="custom-tab-label">Contacts</a></li>
                            <li><a href="#tab5" data-tab="tab5" class="custom-tab-label">Financials</a></li>
                            <li><a href="#tab6" data-tab="tab6" class="custom-tab-label">Accounts</a></li>
                        </ul>
                        <span class="custom-glider position-absolute d-flex" style="transform: translateX(0);"></span>
                    </div>
                </div>



</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">
    <div class="card bg-white">
        <h5 class="p-3 fs-5">Members Master File</h5>
        <hr class='m-0 p-0'/>
        <form name="frmMMF" id="frmMMF" method="post" enctype="multipart/form-data" >
            <%= Html.AntiForgeryToken() %>
       
            
        <div class="col-auto p-3">
        <label class="form-label">Entity Type:</label>
            <select id="cboEntityType" name="cboEntityType" class="form-select">
                <option value="SELECT">SELECT</option>
                <option value="INDIVIDUAL">INDIVIDUAL</option>
                <option value="COMPANY">COMPANY</option>
                
            </select>
            </div>
            <br style="color:black"/>
                    <div id="tab1" class="tab-content-panel active p-3">
                        <div id="subtabs1" class="border-0">
                            <table id="tblGeneralInfo" style="padding: 5px;">
                                <div class="row g-3 mb-1">
                                    <div class="col-md-4">
                                    <label class="form-label">
                                        MemberNo:
                                    </label>
                                        <input type="text" id="txtMemberNo" name="txtMemberNo" placeholder="023456" class="form-control"/>
                                </div>
                                        <div class="col-md-4">
                                    <label class="form-label"></label>
                                        <input  type="Button" id="btnGenerateMemberNo" name="btnGenerateMemberNo" value="Generate Member No" class="btn btn-dark waves-effect waves-light form-control mt-2"/>
                            </div>
                                <div class="col-md-4">
                                <label class="form-label">
                                        Member Type:
                                    </label>
                                        <select id="cboMemberType" name="cboMemberType" class="form-select"><option value="" selected>Select Member Type</option></select>
                                    </div>
                                    <div class="col-md-4">
                                <label class="form-label">
                                        Member Status:
                                    </label>
                                            <select id="cboStatus" name="cboStatus" class="form-select"><option value="" selected>Select Status</option></select>
                                    </div>
                                
                                    <div class="col-md-4">
                                <label class="form-label">
                                        Branch:
                                    </label>
                                            <select id="cboBranch" name="cboBranch" class="form-select"><option value="" selected>Select Branch</option></select>
                                    
                                    </div>
                                    <div class="col-md-4">
                                <label class="form-label">
                                        MFI GROUP:
                                    </label>
                                        <select id="cboMFIGroupCode" name="cboMFIGroupCode" class="form-select"><option value="" selected>Select Group Code</option></select>
                                    </div>
                                
                                <div class="col-md-4">
                                <label class="form-label">Join Date:</label>
                                    <input type="text" id="txtJoinDate" placeholder="17/09/2024" name="txtJoinDate" class="form-control"/>
                                    </div>
                                    <div class="col-md-4">
                                <label class="form-label">Pin No(KRA):</label>
                                    <input type="text" id="txtPinNo" name="txtPinNo" placeholder="A17092034524U" class="form-control"/>
                                    </div>
                                
                            
                            </table>
                        <ul style="margin: 1rem;" class="p-2 position-relative list-unstyled d-flex justify-content-center">
                                <li id="liPersonal"><a id="linkPersonal" href="#div1-subtab1" class="custom-tab-label active custom-tabs  ">Personal</a></li>
                                <li id="liCompany"><a id="linkCompany" href="#div1-subtab2" class="custom-tab-label active custom-tabs ">Company Details</a></li>
                        </ul>
                            <div id="div1-subtab1">
                                <table id="tblPersonal">
                            <div class="row g-3 mb-1">
                                    <div class="col-md-4">
                                        <label class="form-label">
                                        PayrollNo:
                                        </label>
                                            <input type="text" id="txtPayrollNo" name="txtPayrollNo" placeholder="23566" class="form-control"/>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label" style="margin-bottom: 1.15rem !important;"></label>
                                            <input type="Button" id="btnGeneratePayrollNo" name="btnGeneratePayrollNo" value="Generate Payroll No" class="btn btn-dark waves-effect waves-light form-control mt-2"/>
                                        </div>
                                    <div class="col-md-4">
                                        <label class="form-label">
                                            ID Number:
                                        </label>
                                            <input type="text" id="txtIDNumber" name="txtIDNumber" placeholder="12345678" class="form-control"/>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">
                                            Surname:
                                        </label>
                                                <input type="text" id="txtSurname" name="txtSurname" placeholder="John" class="form-control"/>
                                        </div>
                                        <div class="col-md-4">
                                        <label class="form-label">
                                            Other Names:
                                        </label>
                                                <input type="text" id="txtOtherNames" name="txtOtherNames" placeholder="Doe" class="form-control"/>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">
                                            Title:
                                        </label>
                                            <select id="cboTitle" name="cboTitle"  class="form-select"><option value="" selected>Select Title</option></select>
                                        </div>
                                        <div class="col-md-4">
                                        <label class="form-label">
                                            Gender:
                                        </label>
                                            <select id="cboGender" name="cboGender" class="form-select"><option value="" selected >Select Gender</option></select>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">
                                            Employer:
                                        </label>
                                            <select id="cboEmployer" name="cboEmployer" class="form-select"><option value="" selected>Select Employer</option></select>
                                        </div>
                                        <div class="col-md-4">
                                        <label class="form-label">
                                            Category:
                                        </label>
                                            <select id="cboCategory" name="cboCategory" class="form-select"><option value="" selected>Select Category</option></select>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">
                                            Designation:
                                        </label>
                                            <select id="cboDesignation" name="cboDesignation" class="form-select"><option value="" selected>Select Designation</option></select>
                                        </div>
                                        <div class="col-md-4">
                                        <label class="form-label">
                                            Terms Of Service:
                                        </label>
                                                <select id="cboTermsOfService" name="cboTermsOfService" class="form-select"><option value="" selected>Select ToS</option></select>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">
                                            Date of Birth:
                                        </label>
                                            <input type="text" id="txtDOB" placeholder="17/09/2024" name="txtDOB" class="form-control"/>
                                    
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">
                                            Retirement Age:
                                        </label>
                                                <input type="text" id="txtRetirementAge" name="txtRetirementAge" placeholder="65" class="form-control"/>
                                        </div>
                                        <div class="col-md-4">
                                        <label class="form-label">
                                            Date Employed:
                                        </label>
                                                <input type="text" id="txtEmployDate" placeholder="17/09/2024" name="txtEmployDate" class="form-control"/>
                                    </div>
                                </div>
                                </table>
                            </div>
                            <div id="div1-subtab2">
                                <table id="tblCompany">
                                <div class="row g-3 mt-1">
                                    <div class="col-md-4">
                                        <label class="form-label">Name:</label>
                                        <input class="form-control" type="text" id="txtCompanyName" placeholder="John's" name="txtCompanyName"/>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Reg No:</label>
                                        <input type="text" id="txtCompanyRegNo" name="txtCompanyRegNo" placeholder="56903221" class="form-control"/>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">VAT No:</label>
                                        <input type="text" id="txtCompanyVATNo" name="txtCompanyVATNo" placeholder="1234" class="form-control"/>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Type:</label>
                                            <select id="cboCompanyType" name="cboCompanyType" class="form-select">
                                                <option value="" selected>Select Company Type</option>
                                            </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Reg Date:</label>
                                        <input type="text" id="txtCompanyRegDate" name="txtCompanyRegDate" placeholder="17/09/2024" class="form-control"/>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Description:</label>
                                        <textarea id="txtCompanyDescription" name="txtCompanyDescription" placeholder="Description Here....." class="form-control"></textarea>
                                    </div>
                                    </div>
                                </table>
                            </div>
                    </div>
                    </div>
                    <div id="tab2" class="table-responsive tab-content-panel p-3">
                        <div class="mt-2 table-responsive" id="divDirectors">
                        <div class="card-datatable table-responsive">
                            <table id='tblDirectors' class="table-responsive dt-fixedcolumns table table-bordered p-3" style="width: 100%">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>IDNo</th>
                                        <th>PinNo</th>
                                        <th>Address</th>
                                        <th>PhoneNo</th>
                                        <th>DOB</th>
                                        <th>EMail</th>
                                        <th>Designation</th>
                                        <th>IsSignatory</th>
                                        <th>Remove</th>
                                    </tr>
                                </thead>
                                <tbody id='bdDirectors'>
                                </tbody>
                                
                            </table>
                            </div>
                            <div class="mt-2">
                                <input type="button" id="btnAddDirector" name="btnAddDirector" value="Add Director/Member" class="btn btn-dark waves-effect waves-light"/>
                            </div>
                        </div>
                    </div>
                    <div id="tab3" class="tab-content-panel p-3">
                        <div id="divPics"  >
                            <div id="tblPics" class="d-flex col gap-5">
                                <div class="row mb-1">
                                    <label class="form-label">Member Photo</label>
                                    <div>
                                        <div id="divMemberPhoto"></div>
                                    </div>
                                    <div>
                                        <input id="imageMemberPhoto" type="file" name="imageMemberPhoto" class="img input-group mt-3 form-control" />
                                    </div>
                                </div>

                                <div class="row mb-1">
                                    <label class="form-label">Member Signature</label>
                                    <div>
                                        <div id="divMemberSignature"></div>
                                    </div>
                                    <div>
                                    <input id="imageMemberSignature" type="file" name="imageMemberSignature" class="img input-group mt-3 form-control"  />
                                    </div>
                                </div>
                            </div>
                            </br>
                            <input type="button" id="btnChangePics" value ="Change Picture/Signature" class="btn btn-dark waves-effect waves-light"/>
                            <input type="button" id="btnSavePics" value ="Save Image" class="btn btn-dark waves-effect waves-light"/>
                        </div>
                    
                    </div>
                    <div id="tab4" class="tab-content-panel p-3">
                        <table id="tblContacts">
                        <div class="row g-3 mb-1">
                            <div class="col-md-4">
                                <label class="form-label">
                                    WorkStation:
                                </label>
                                
                                    <select id="cboWorkStation" name="cboWorkStation" class="form-select">
                                        <option value="" selected>Select Work Station</option>
                                    </select>
                            </div>
                            </div>
                            <div>
                                <h6>Present Address</h6>
                                <div class="row g-3 mb-1">
                                    <div class="col-md-4">
                                    <label class="form-label">
                                            Address:
                                        </label>
                                            <input type="text" id="txtPresentAddress" name="txtPresentAddress" placeholder="5670-20100" class="form-control" />
                                        </div>
                                        <div class="col-md-4">
                                    <label class="form-label">
                                            District:
                                        </label>
                                            <select id="cboPresentDistrict" name="cboPresentDistrict" class="form-select">
                                                <option value="" selected>Current District</option>
                                            </select>
                                    </div>

                                    <div class="col-md-4">
                                    <label class="form-label">
                                            Town:
                                        </label>
                                        
                                            <input type="text" id="txtPresentTown" name="txtPresentTown" placeholder="Nakuru" class="form-control" />
                                    </div>
                                    <div class="col-md-4">
                                    <label class="form-label">
                                            Post Code:
                                        </label>
                                            <input type="text" id="txtPresentPostCode" name="txtPresentPostCode" placeholder="00100" class="form-control" />
                                    </div>
                                </div>
                            </div>

                            <div>
                                <h6>Home Address</h6>
                            <div class="row g-3 mb-1">
                                <div class="col-md-4">
                                    <label class="form-label">
                                        Address:
                                    </label>
                                        <input type="text" id="txtHomeAddress" name="txtHomeAddress" placeholder="5670-20100" class="form-control" />
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">
                                        District:
                                    </label>
                                        <select id="cboHomeDistrict" name="cboHomeDistrict" class="form-select">
                                            <option value="" selected>Home District</option>
                                        </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">
                                        Town:
                                    </label>
                                        <input type="text" id="txtHomeTown" name="txtHomeTown" placeholder="Nakuru West" class="form-control" />
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">
                                        Post Code:
                                    </label>
                                        <input type="text" id="txtHomePostCode" name="txtHomePostCode" placeholder="00100" class="form-control" />
                                </div>
                            </div>

                                <h6>Other Contacts</h6>
                                <div class="row g-3 mb-1">
                                    <div class="col-md-4">
                                        <label class="form-label">
                                            Cellular/Phone No:
                                        </label>
                                            <input type="text" id="txtPhoneNo" name="txtPhoneNo" placeholder="07123456789" class="form-control" />
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">
                                            Fax:
                                        </label>
                                            <input type="text" id="txtFax" name="txtFax" placeholder="1234567890" class="form-control" />
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">
                                            EMail:
                                        </label>
                                            <input type="text" id="txtEMail" name="txtEMail" placeholder="example@gmail.com" class="form-control" />
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">
                                            Landline:
                                        </label>
                                            <input type="text" id="txtLandLine" name="txtLandLine" placeholder="08001340890" class="form-control" />
                                    </div>
                                </div>
                            </div>
                            <div>
                                <h6>KYC</h6>
                                <div class="row g-3">
                                    <div class="col-md-4">
                                        <label class="form-label">
                                            Introduced By:
                                        </label>
                                            <input type="text" id="txtIntroducedBy" name="txtIntroducedBy" placeholder="Jane Mary" class="form-control" />
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">
                                            Recruited By:
                                        </label>
                                            <input type="text" id="txtRecruitedBy" name="txtRecruitedBy" placeholder="John Doe" class="form-control" />
                                    </div>
                                </div>

                        </div>
                        </table>
                    </div>
                    <div id="tab5" class="tab-content-panel p-3">
                    <div id="tblFinancials" >
                        <h6>Bank Details</h6>
                        <div class="row g-3 mb-1">
                        <div class="col-md-4">
                        <label class="form-label">
                                Bank Name:
                            </label>
                                <select id="cboMainBank" name="cboMainBank" class="form-select"><option value="" selected>Select Main Bank </option></select>
                            </div>
                            <div class="col-md-4">
                        <label class="form-label">
                                Bank Branch:
                            </label>
                                <select id="cboBankBranch"  name="cboBankBranch" class="form-select"><option value="" selected>Select Branch</option></select>
                        </div>
                        <div class="col-md-4">
                        <label class="form-label">
                                AccountNo:
                            </label>
                                <input type="text" id="txtBankAccountNo" name="txtBankAccountNo" placeholder="90123569024849" class="form-control"/>
                        </div>
                        
                    </div>
                    </div>
                        <div id="btlTaxDetails" class="mt-4">
                            <h6>Tax Exemption Details</h6>
                            <div class="row g-3 mb-1">
                                <div class="col-md-4">
                                <label class="form-label">
                                        Tax Exempted:
                                    </label>
                                        <select id="cboTaxExempted" name="cboTaxExempted" class="form-select"><option selected value="N">NO</option><option value="Y">YES</option></select>
                                    </div>
                                    <div class="col-md-4">
                                <label class="form-label">
                                        Since:
                                    </label>
                                        <input type="text" id="txtTaxExemptedStartDate" name="txtTaxExemptedStartDate" placeholder="17/09/2024" class="form-control"/>
                                </div>
                                <div class="col-md-4">
                                <label class="form-label">
                                        No of Months:
                                    </label>
                                        <input type="text" id="txtTaxExemptMonths" name="txtTaxExemptMonths" class="form-control"/>
                                    </div>
                                    <div class="col-md-4">
                                <label class="form-label">
                                        End Date:
                                    </label>
                                        <input type="text" id="txtTaxExemptEndDate" name="txtTaxExemptReason"  placeholder="17/09/2024" class="form-control"/>
                                </div>
                                <div class="col-md-4">
                                <label class="form-label">
                                        Cert. No:
                                    </label>
                                        <input type="text" id="txtTaxExemptCertNo" name="txtTaxExemptReason"  placeholder="172024" class="form-control"/>
                                </div>
                                <div class="col-md-4">
                                <label class="form-label">
                                        Reason:
                                    </label>
                                        <input type="text" id="txtTaxExemptReason" name="txtTaxExemptReason"  placeholder="Give reason....." class="form-control"/>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="tab6" class="tab-content-panel p-3">
                        <div class="table-responsive">
                                <h6>Member FOSA Accounts</h6>
                                    <div id="divMemberAccounts" class="card-datatable text-nowrap">
                                        <table id='tblMemberAccounts' class="dt-fixedcolumns table table-bordered">
                                                <thead>
                                                    <tr>
                                                    <th>Account No</th>
                                                    <th>Account Name</th>
                                                    <th>Date Created</th>
                                                    <th>Created By</th>
                                                    <th>Branch</th>
                                                    <th>A/C Type</th>
                                                    <th>A/C Category</th>
                                                    </tr>
                                                </thead>
                                                <tbody id='bdMemberAccounts'>
                                                </tbody>
                                                <tfoot>
                                                        <tr>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                        </tr>
                                                    </tfoot>
                                        </table>
                                    </div>
                        </div>
                        <div class="row g-3 mt-5">
                            <div class="col-md-4">
                                <label>
                                    Default Account
                                </label>
                                    <select id="cboDefaultAccount" name="cboDefaultAccount" placeholder="90123569024849" class="form-select"></select>
                            </div>
                            <div class="col-md-4">
                                <label>
                                    Open New Account
                                </label>
                                    <select id="cboOpenAccount" name="cboOpenAccount" class="form-select"><option selected value="Y">YES</option><option value="N">NO</option></select>
                            </div>
                            <div class="col-md-4">
                                <label>Account Type:</label>
                                <select id="cboAccountType" name="cboAccountType" class="form-select"><option selected value="">(SELECT ACC TYPE)</option></select>
                            </div>
                            <div class="col-md-4">
                                <label>Default FOSA A/C:</label>
                                    <select id="cboIsDefaultAccount" name="cboIsDefaultAccount" class="form-select"><option selected value="Y">YES</option><option value="N">NO</option></select>
                            </div>
                            <div class="col-md-4">
                                <label>Account No:</label>
                                <input type="text" id ="txtAccountNo" name ="txtAccountNo" placeholder="90123569024849" class="form-control"/>
                            </div>
                            <div class="col-md-4">
                            <label class="form-label"></label>
                                <input type="button" id="btnGenerateAccNo" name="btnGenerateAccNo" value="Generate A/C No" class="btn btn-dark waves-effect waves-light form-control"/>
                            </div>
                        </div>
                    </div>
                    <div>
                    <hr class='m-0 p-0'/>
                    <div class="nav nav-pills r-tabs-nav d-flex justify-content-center" style="gap: 10px;margin-left: 17px;margin-block: 15px;">
                            <%--<input type="button" id="btnAddMember" name="btnAddMember" value="New Member" class="btn btn-success"/>--%>
                            <button type='reset' class="btn btn-success "><span>New Memeber</span></button>
                            <input type="button" id="btnSearchMember" name="btnSearchMember" value="Search Member" class="btn btn-success"/>
                            <input type="button" id="btnEdit" name="btnEdit" value="Edit Member" class="btn btn-success"/>
                            <input type="button" id="btnSaveMember" name="btnSaveMember" value="Save Member" class="btn btn-success"/>
                            <input type="button" id="btnBOSAStatement" name="btnBOSAStatement" value="BOSA Statement" class="btn btn-success"/>
                            <input type="button" id="btnFOSAStatement" name="btnFOSAStatement" value="FOSA Statement" class="btn btn-success"/>
                    </div>
            </div>
        
            <%-- Modal for director member --%>
            <div class="modal fade" id="directorMemberModal"  role="dialog">
            <div class="modal-dialog">
                <!-- Modal content-->
                <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Add Director/Member</h4>
                </div>
                <div class="modal-body">
                    <form action="">
                    <div class="form-group">
                        <div class="row">
                        <div class="col-md-4">
                            <label>Name:</label>
                        </div>
                        <div class="col-md-9">
                            <input type="text"id="txtDirectorName" class="form-control textfocused">
                            <span class="text-danger" id="txtDirectorNameError"></span>
                        </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row">
                        <div class="col-md-4">
                            <label>IDNo:</label>
                        </div>
                        <div class="col-md-9">
                            <input type="text" id="txtDirectorIDNo" class="form-control">
                            <span class="text-danger" id="txtDirectorIDNoError"></span>
                        </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row">
                        <div class="col-md-4">
                            <label>PINNo:</label>
                        </div>
                        <div class="col-md-9">
                            <input type="text" id="txtDirectorPinNo" class="form-control">
                            <span class="text-danger" id="txtDirectorPinNoError"></span>
                        </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row">
                        <div class="col-md-4">
                            <label>Addresses:</label>
                        </div>
                        <div class="col-md-9">
                            <textarea type="text" id="txtDirectorAddress" class="form-control" row="1"></textarea>
                            <span class="text-danger" id="txtDirectorAddressError"></span>
                        </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row">
                        <div class="col-md-4">
                            <label>Email:</label>
                        </div>
                        <div class="col-md-9">
                            <input type="text" id="txtDirectorEMail" class="form-control">
                            <span class="text-danger" id="txtDirectorEMailError"></span>
                        </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row">
                        <div class="col-md-4">
                            <label>PhoneNo:</label>
                        </div>
                        <div class="col-md-9">
                            <input type="text" id="txtDirectorPhoneNo" class="form-control">
                            <span class="text-danger" id="txtDirectorPhoneNoError"></span>
                        </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row">
                        <div class="col-md-4">
                            <label>DOB:</label>
                        </div>
                        <div class="col-md-9">
                            <input type="date" id="txtDirectorDOB" class="form-control">
                            <span class="text-danger" id="txtDirectorDOBError"></span>
                        </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row">
                        <div class="col-md-4">
                            <label>Designation:</label>
                        </div>
                        <div class="col-md-9">
                            <select id="cboDirectorDesignation" class="form-control">
                            <option value="">(SELECT)</option>
                            </select>
                        </div>
                        </div>
                    </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="submit" id="btnOK" class="btn btn-primary">Add Director</button>
                    <button type="button" class="btn btn-outline-primary "
                            data-dismiss="modal">Close</button>
                </div>
                </div>
            </div>
            </div>
            <%-- end modal for director member --%>
            <input type="hidden" id="EditEmpCode" name="EditEmpCode" />
            <input type="hidden" id="EditPayrollNo" name="EditPayrollNo" />
        </form>
    </div>
</asp:Content>

