﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loan Appraisal
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
     <style type="text/css"></style>

    <script type="text/javascript"  >

        
        $(document).ready(function () {
            
            
            var EmpCode = "";
            var PayrollNo = "";
            var SalaryAccount = "";
            var BoolEditingLoan = eval(<%= ViewBag.BoolEditingLoan ? "true" : "false" %>);
            var EditMemberLoanApplicationNo = null;
            var EditMemberLoanNo = null;
            var EditMemberLoanApplicationDetails = Object(<% = Json.Encode(ViewBag.EditMemberLoanApplicationDetails as XtremeERP.Common.Data.MemberLoanApplicationDetails) %>);
            var EditLoanDetails = Object(<% = Json.Encode(ViewBag.EditLoanDetails as XtremeERP.Common.Data.LoanDetails) %>);
            var EditDB = "";

            
                $('#frmLoanAppraisal').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    e.preventDefault();
                });
                $('#frmLoanAppraisal').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    $(this).select();
                });
                $('#frmLoanAppraisal').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    $(this).addClass("textfocused");
                });
                $('#frmLoanAppraisal').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    $(this).removeClass("textfocused");
                });
                
                $("#tblGuarantors").dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                $("#tblOffsets").dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                $("#tblBalances").dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                $('#tabs').on('tabsactivate', function (event, ui) {
                    var newIndex = ui.newTab.index();
                    if (newIndex == 7) {
                        SendAppraisalData("processappraisal");
                    }
                });
                ClearAppraisalData();
                ClearAppraisalReport();

                $("#txtLoanDate").datepicker({ dateFormat: 'dd/mm/yy' });
                $("#cboGuarantorSearchBy").on('change', function () {
                    ShowGuarantorSearchParams();
                });
                $("#cboGuarantorSearchBy").trigger('onchange');
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetLoanAppraisalConfig") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var mList = response.EmployerList;
                        var obj = document.getElementById("cboEmployer");
                        $.each(mList, function (index, mListItem) {
                            var opt = document.createElement("option");
                            opt.value = mListItem.EmployerCode;
                            opt.text = mListItem.EmployerName;
                            obj.appendChild(opt);
                        });
                        var mList = response.EmployerList;
                        var obj = document.getElementById("cboGuarantorEmpCode");
                        $.each(mList, function (index, mListItem) {
                            var opt = document.createElement("option");
                            opt.value = mListItem.EmployerCode;
                            opt.text = mListItem.EmployerName;
                            obj.appendChild(opt);
                        });
                        var mList = response.LoanTypesList;
                        var obj = document.getElementById("cboLoanType");
                        $.each(mList, function (index, mListItem) {
                            var opt = document.createElement("option");
                            opt.value = mListItem.LoanTypeCode + "^" + mListItem.LoanMaxDuration + "^" + mListItem.LoanSerialIdentifier ;
                            opt.text = mListItem.LoanTypeName + "(" + mListItem.LoanSerialIdentifier + ")";
                            obj.appendChild(opt);
                        });
                        var mList = response.PayslipEarningsList;

                        var tbl = "<table class='table table-bordered' id='tblEarnings'><tbody id='bdTblIncomes'><tr><td>Earning Code</td><td>Earning Name</td><td>Amount</td></tr>"
                        $.each(mList, function (index, mListItem) {
                            tbl += "<tr><td>" + mListItem.EarningCode + "</td><td>" + mListItem.EarningName + "</td><td><input type='text' value=0 class='form-control'/></td></tr>"
                        });
                        tbl += "</tbody></table>";
                        $("#divSalaryIncomes").html(tbl);
                        var mList = response.PayslipDeductionsList;
                        var tbl = "<table class='table table-bordered' id='tblDeductions'><tbody id='bdTblDeductions'><tr><td>Deduction Code</td><td>Deduction Name</td><td>Amount</td></tr>"
                        $.each(mList, function (index, mListItem) {
                            tbl += "<tr><td>" + mListItem.DeductionCode + "</td><td>" + mListItem.DeductionName + "</td><td><input type='text' value=0 class='form-control'/></td></tr>"
                        });
                        tbl += "</tbody></table>";
                        $("#divSalaryDeductions").html(tbl);

                        DisplayLoanAppraisalDetails();
                        DisplayMemberApplicationDetails();

                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
                $("#btnDeleteGuarantor").click(function () {
                    try {
                        var table = document.getElementById('tblGuarantors');
                        var rowCount = table.rows.length;
                        for (var i = 0; i < rowCount; i++) {
                            var row = table.rows[i];
                            var chkbox = row.cells[0].childNodes[0];
                            if (null != chkbox && true == chkbox.checked) {
                                table.deleteRow(i);
                                rowCount--;
                                i--;
                            }
                        }
                    } catch (err) {
                        alert(err);
                    }
                });
                $("#btnDelOffset").click(function () {
                    try {
                        var table = document.getElementById('tblOffset');
                        var rowCount = table.rows.length;
                        for (var i = 0; i < rowCount; i++) {
                            var row = table.rows[i];
                            var chkbox = row.cells[0].childNodes[0];
                            if (null != chkbox && true == chkbox.checked) {
                                table.deleteRow(i);
                                rowCount--;
                                i--;
                            }
                        }
                    } catch (err) {
                        alert(err);
                    }
                });
                $("#txtGuaranteedAmount").on('focusout', function () {
                    //$("#btnAddGuarantor").trigger('click'); causes guarantor to be added twice
                });
                $("#btnAddGuarantor").on('click',function () {
                    if (!isNumber($('#txtGuaranteedAmount').val())) {
                        alert("Invalid guarantor Amount");
                        return;
                    }
                    var row = 0;
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: '<%: Url.Content("~/api/BankSystemApi/GetMemberRecord") %>',
                        data: "{'SearchBy' : '" + $("#cboGuarantorSearchBy").val() + "','SearchValue' : '" + $("#txtGuarantorSearchValue").val() + "','EmpCode' : '" + $("#cboGuarantorEmpCode").val() + "'}",
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            var tblrow  = "<tr>";
                            tblrow += "<td><input type='checkbox'/>" + response.FullNames + "</td>";
                            tblrow += "<td>" + response.EmployerCode + "</td>";
                            tblrow += "<td>" + response.PayrollNo + "</td>";
                            tblrow += "<td>" + response.MemberNo + "</td>";
                            tblrow += "<td>" + 0 + "</td>";
                            tblrow += "<td><input type='text' class='form-control' value='" + $('#txtGuaranteedAmount').val() + "' /></td>";
                            tblrow += "</tr>";
                            $('#bdGuarantors').append(tblrow);
                            $('#txtGuaranteedAmount').val("");
                            $('#txtGuarantorSearchValue').val("");
                            $('#txtGuarantorSearchValue').focus();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
                $("#btnProcessAppraisal").click(function () {
                    SendAppraisalData("processappraisal");
                });
                $("#txtSearchValue").on('focusout', function () {
                    GetMemberDetails();
                });
                $('#txtSearchValue').keypress(function (e) {
                    var kcode = (e.keyCode ? e.keyCode : e.which);
                    if (kcode == $.ui.keyCode.ENTER) {
                        GetMemberDetails();
                    }
                });
                $("#btnGetMember").click(function () {
                    GetMemberDetails();
                });


                $("#btnProcessAppraisal").click(function () {
                    SendAppraisalData("processappraisal");
                });
                $("#btnSaveAppraisal").on('click', function () {
                    if (!IsValidDate($("#txtLoanDate").val())) {
                        alert("Invalid Date");
                        return;
                    }
                    xDialogConfirm("Save Loan Appraisal?", "Confirm").then(function () {
                        xDialogGetUserCredetials().then(function (data) {
                            SaveAppraisal(data);
                        });
                    });
                });
             function DisplayMemberInfo(mem_details) {

                EmpCode = mem_details.EmployerCode;
                PayrollNo = mem_details.PayrollNo;
                SalaryAccount = mem_details.SalaryAccount;

                var tbl = "<table class='table table-bordered'><tr><td>EmpCode</td><td>PayrollNo</td><td>MemberNo</td><td>Names</td><td>Details</td></tr>"
                tbl += "<tr><td>" + mem_details.EmployerCode + "</td><td>" + mem_details.PayrollNo + "</td><td>" + mem_details.MemberNo + "</td><td>" + mem_details.FullNames + "</td><td><a href='" + global_site_root + "/Bank/BankSystem/MembersMasterFile?EditMode=true&EmpCode=" + mem_details.EmployerCode + "&PayrollNo=" + mem_details.PayrollNo + "'>View Details</a></td></tr>"
                $('#divAccountInfo').html(tbl);
            }

            function DisplayMemberBalances(MemberBalances) {
                $("#tblOffsets > tbody:last").children().remove();
                $("#tblBalances > tbody:last").children().remove();
                var tbl_row = "";
                $.each(MemberBalances, function (index, MemberBalance) {
                    if (MemberBalance.BalType != "F") {
                        tbl_row += "<tr><td>" + MemberBalance.BalType + "</td><td>" + MemberBalance.BalCode + "</td><td>" + MemberBalance.BalName + "</td><td>" + (+MemberBalance.BalAmount).formatMoney() + "</td><td><input type='text' value='0.00' /></td></tr>"
                    }
                });
                $("#bdOffsets").append(tbl_row);
                var tbl_row = "";
                $.each(MemberBalances, function (index, MemberBalance) {
                    tbl_row += "<tr><td>" + MemberBalance.BalType + "</td><td>" + MemberBalance.BalCode + "</td><td>" + MemberBalance.BalName + "</td><td>" + (+MemberBalance.BalAmount).formatMoney() + "</td></tr>"
                });
                $("#bdBalances").append(tbl_row);

            }

            function DisplayMemberApplicationDetails()
            {
                //alert(typeof EditMemberLoanApplicationDetails);
                if (!EditMemberLoanApplicationDetails) { return; }
                if (EditMemberLoanApplicationDetails.saccoMember != null) {
                    DisplayMemberInfo(EditMemberLoanApplicationDetails.saccoMember);
                }
                if (EditMemberLoanApplicationDetails.memberBalancesSummary != null) {
                    if (EditMemberLoanApplicationDetails.memberBalancesSummary.MemberBals != null) {
                        DisplayMemberBalances(EditMemberLoanApplicationDetails.memberBalancesSummary.MemberBals);
                    }
                }
                if (EditMemberLoanApplicationDetails.CreditAccounts != null) {
                    DisplayCreditAccounts(EditMemberLoanApplicationDetails.CreditAccounts);
                }
                if (EditMemberLoanApplicationDetails.memberLoanApplication != null) {
                    document.getElementById("cboSearchBy").selectedIndex = 1;

                    EditMemberLoanApplicationNo = EditMemberLoanApplicationDetails.memberLoanApplication.LoanRefNo;

                    $("#cboEmployer").prop("disabled", true); //we are displaying existing records cannot be modified
                    $("#cboSearchBy").prop("disabled", true); //we are displaying existing records cannot be modified
                    $("#txtSearchValue").val(EditMemberLoanApplicationDetails.memberLoanApplication.MemberNo);
                    $("#txtSearchValue").prop("disabled", true); //we are displaying existing records cannot be modified

                    $("#divLoanSerialNumber").html("");
                    $("#divLoanStatus").html("");
                    $("#txtLoanDate").val(EditMemberLoanApplicationDetails.memberLoanApplication.LoanDate);
                    $("#txtLoanAmount").val(EditMemberLoanApplicationDetails.memberLoanApplication.RequestedAmount);
                    $("#txtLoanPurpose").val(EditMemberLoanApplicationDetails.memberLoanApplication.LoanPurpose);
                    $("#txtRepaymentPeriod").val(EditMemberLoanApplicationDetails.memberLoanApplication.RepaymentPeriod);
                    $("#txtInstructions").val(EditMemberLoanApplicationDetails.memberLoanApplication.Instructions);
                    var tmpArr = $("#cboLoanType").val();
                    tmpArr = tmpArr.split("^");
                    $('#cboLoanType').find('option').each(function (index, element) {
                        var tmpArr = element.value.split("^");
                        if (tmpArr[0].toString().toLowerCase() == EditMemberLoanApplicationDetails.memberLoanApplication.LoanTypeCode.toString().toLowerCase()) {
                            document.getElementById("cboLoanType").selectedIndex = index;
                            
                        }
                    });
                    $("#cboLoanType").prop("disabled", true); //cannot change what was applied for
                    $("#txtLoanAmount").prop("disabled", true); //cannot change what was applied for
                    $("#txtLoanPurpose").prop("disabled", true); //cannot change what was applied for

                    if (EditMemberLoanApplicationDetails.memberLoanApplicationGuarantor != null) {
                        var tbl_row = "";
                        $.each(EditMemberLoanApplicationDetails.memberLoanApplicationGuarantor, function (index, AppraisalGuarantor) {
                            var tblrow = "<tr>";
                            tblrow += "<td><input type='checkbox'/>" + AppraisalGuarantor.GuarantorName + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.GuarantorEmployerCode + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.GuarantorPayrollNo + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.GuarantorMemberNo + "</td>";
                            tblrow += "<td>" + 0 + "</td>";
                            tblrow += "<td><input type='text' class='form-control' value='" + AppraisalGuarantor.AcceptedAmount + "' /></td>";
                            tblrow += "</tr>";
                            $('#bdGuarantors').append(tblrow);
                        });
                    }

                    if (EditMemberLoanApplicationDetails.memberLoanApplicationOffset != null) {
                        $.each(EditMemberLoanApplicationDetails.memberLoanApplicationOffset, function (index, lnOffsets) {
                            $("#tblOffsets tbody").find('tr').each(function (i) {
                                var row = $(this);
                                var txtAmt = row.find('td:eq(4)').find('input:eq(0)');
                                if ((lnOffsets.OffsetType == row.find('td:eq(0)').text()) && (lnOffsets.SchemeCode == row.find('td:eq(1)').text())) {
                                    txtAmt.val(lnOffsets.Amount);
                                } else if ((lnOffsets.OffsetType == row.find('td:eq(0)').text()) && (lnOffsets.LoanSerialNo == row.find('td:eq(1)').text())) {
                                    txtAmt.val(lnOffsets.Amount);
                                } else if ((lnOffsets.OffsetType == row.find('td:eq(0)').text()) && (lnOffsets.LoanSerialNo == row.find('td:eq(1)').text())) {
                                    txtAmt.val(lnOffsets.Amount);
                                }
                            });
                        });
                    }

                }
            }
        
            function DisplayLoanAppraisalDetails() {
                //alert(typeof EditLoanDetails);
                if (!EditLoanDetails) { return; }
                if (EditLoanDetails.saccoMember != null) {
                    DisplayMemberInfo(EditLoanDetails.saccoMember);
                }
                if (EditLoanDetails.memberBalancesSummary != null) {
                    if (EditLoanDetails.memberBalancesSummary.MemberBals != null) {
                        DisplayMemberBalances(EditLoanDetails.memberBalancesSummary.MemberBals);
                    }
                }
                if (EditLoanDetails.CreditAccounts != null) {
                    DisplayCreditAccounts(EditLoanDetails.CreditAccounts);
                }
                if (EditLoanDetails.mLoanAppraisals != null) {
                    document.getElementById("cboSearchBy").selectedIndex = 1;
                    EditMemberLoanNo = EditLoanDetails.mLoanAppraisals.LoanSerialNumber;
                    $("#txtSearchValue").val(EditLoanDetails.mLoanAppraisals.MemberNumber);
                    $("#divLoanSerialNumber").html(EditLoanDetails.mLoanAppraisals.LoanSerialNumber);
                    $("#divLoanStatus").html(EditLoanDetails.mLoanAppraisals.LoanStatus);
                    $("#txtLoanDate").val(EditLoanDetails.mLoanAppraisals.LoanDate);
                    $("#txtLoanAmount").val(EditLoanDetails.mLoanAppraisals.RequestedAmount);
                    $("#txtLoanPurpose").val(EditLoanDetails.mLoanAppraisals.PurposeForLoan);


                
                    $("#cboEmployer").prop("disabled", true); //we are displaying existing records cannot be modified
                    $("#cboSearchBy").prop("disabled", true); 
                    $("#txtSearchValue").prop("disabled", true); 

                    var tmpArr = $("#cboLoanType").val();
                    tmpArr = tmpArr.split("^");
                    $('#cboLoanType').find('option').each(function (index, element) {
                        var tmpArr = element.value.split("^");
                        if (tmpArr[2] == EditLoanDetails.mLoanAppraisals.LoanType) {
                            document.getElementById("cboLoanType").selectedIndex = index
                        }
                    });
                    if (EditLoanDetails.mAppraisalReport != null) {
                        $("#txtRepaymentPeriod").val(EditLoanDetails.mAppraisalReport.RepaymentPeriod);
                        $("#txtRecomendedRepaymentPeriod").val(EditLoanDetails.mAppraisalReport.RepaymentPeriod);
                        $("#txtReasons").val(EditLoanDetails.mAppraisalReport.Reasons);
                        $("#txtStartYear").val(EditLoanDetails.mAppraisalReport.StartYear);
                        $("#txtStartMonth").val(EditLoanDetails.mAppraisalReport.StartMonthName);
                        $("#txtStartPeriod").val(EditLoanDetails.mAppraisalReport.StartPeriod);
                        $("#txtRecomendedAmount").val(EditLoanDetails.mAppraisalReport.RecommendedAmount);
                        $("#txtRecomendedInstallmentAmount").val(EditLoanDetails.mAppraisalReport.InstallmentAmount);
                        $("#txtDepositsMultiplied").val(EditLoanDetails.mAppraisalReport.SharesMultiplied);
                        $("#txtSchemeBalance").val(EditLoanDetails.mAppraisalReport.TotalShares);
                        $("#txtIncomeFractionized").val(EditLoanDetails.mAppraisalReport.IncomeFractionised);
                        $("#txtSalaryEligibility").val(EditLoanDetails.mAppraisalReport.SalaryEligibiliy);
                        $("#txtSharesEligibility").val(EditLoanDetails.mAppraisalReport.SharesEligibiliy);
                        $("#txtGuarantorsEligibility").val(EditLoanDetails.mAppraisalReport.GrantsEligibiliy);
                    }
                    if (EditLoanDetails.mAppraisalGuarantors != null)
                    {
                        var tbl_row = "";
                        $.each(EditLoanDetails.mAppraisalGuarantors, function (index, AppraisalGuarantor) {
                            var tblrow = "<tr>";
                            tblrow += "<td><input type='checkbox' />" + AppraisalGuarantor.FullNames + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.EmployerCode + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.PayrollNo + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.MemberNumber + "</td>";
                            tblrow += "<td>" + AppraisalGuarantor.AvailableShares + "</td>";
                            tblrow += "<td><input type='text' class='form-control' value='" + AppraisalGuarantor.SharesToCommit + "' /></td>";
                            tblrow += "</tr>";
                            $('#bdGuarantors').append(tblrow);
                        });
                    }
                
                    if (EditLoanDetails.mAppraisalEarnings != null) {
                        $.each(EditLoanDetails.mAppraisalEarnings, function (index, AppraisalEarning) {
                        
                            $("#tblEarnings tbody").find('tr').each(function (i) {
                                var row = $(this);
                            
                                if (AppraisalEarning.EarningCode == row.find('td:eq(0)').text()) {
                                    var txtAmt = row.find('td:eq(2)').find('input:eq(0)');
                                    txtAmt.val(AppraisalEarning.EarningAmount);
                                }
                            });
                        });
                    }
                    if (EditLoanDetails.mAppraisalDeductions != null) {
                        $.each(EditLoanDetails.mAppraisalDeductions, function (index, AppraisalDeduction) {
                            $("#tblDeductions tbody").find('tr').each(function (i) {
                                var row = $(this);
                                if (AppraisalDeduction.DeductionCode == row.find('td:eq(0)').text()) {
                                    var txtAmt = row.find('td:eq(2)').find('input:eq(0)');
                                    txtAmt.val(AppraisalDeduction.DeductionAmount);
                                }
                            });
                        });
                    }
                    if (EditLoanDetails.mAutoLnDistribution != null) {
                        $.each(EditLoanDetails.mAutoLnDistribution, function (index, lnOffsets) {
                            $("#tblOffsets tbody").find('tr').each(function (i) {
                                var row = $(this);
                                var txtAmt = row.find('td:eq(4)').find('input:eq(0)');
                                if ((lnOffsets.TransType == row.find('td:eq(0)').text()) && (lnOffsets.Scheme == row.find('td:eq(1)').text())) {
                                    txtAmt.val(lnOffsets.AutoAmt);
                                }else if ((lnOffsets.TransType == row.find('td:eq(0)').text()) && (lnOffsets.ClearLoanCode == row.find('td:eq(1)').text())) {
                                    txtAmt.val(lnOffsets.AutoAmt);
                                }else if ((lnOffsets.TransType == row.find('td:eq(0)').text()) && (lnOffsets.OffsetInt == row.find('td:eq(1)').text())) {
                                    txtAmt.val(lnOffsets.AutoAmt);
                                }
                            });
                        });
                    }

                }
            }

            function AutoProcessAppraisal() {
                SendAppraisalData("processappraisal",null);
            }
            function SaveAppraisal(UserCredentials) {
                SendAppraisalData("savenewappraisal", UserCredentials);
            }
            function ClearAppraisalData() {

                $("#txtSearchValue").val("");
                $("#txtRepaymentPeriod").val("");
                $("#txtLoanPurpose").val("");
                $("#txtLoanAmount").val("0");
                $("#RepaymentPeriod").val(1);
                $("#txtLoanDate").val("");
                $("#cboCreditAccount").empty();
                $("#cboGuarantorSearchBy").trigger('onchange');
                $("#txtGuarantorSearchValue").val("");
                $("#cboGuarantorEmpCode").val("");
                $("#txtGuaranteedAmount").val("");
            
                $("#tblBalances > tbody:last").children().remove();
                $("#tblOffsets > tbody:last").children().remove();
                $("#tblGuarantors > tbody:last").children().remove();
                $('#divAccountInfo').empty();

            
            }
            function ClearAppraisalReport() {
                $("#txtRecomendedAmount").val("0");
                $("#txtRecomendedRepaymentPeriod").val("1");
                $("#txtRecomendedInstallmentAmount").val("0");
                $("#txtIncomeFractionized").val("0");
                $("#txtPayslipDeductions").val("0");
                $("#txtDepositsMultiplied").val("0");
                $("#txtSharesEligibility").val("0");
                $("#txtSalaryEligibility").val("0");
                $("#txtGuarantorsEligibility").val("0");
                $("#txtSchemeBalance").val("0");
                $("#txtStartYear").val("0");
                $("#txtStartMonth").val("0");
                $("#txtStartPeriod").val("0");
                $("#txtReasons").val("");
            }
            $("#btnNewAppraisal").on('click',function(){
                ClearAll();
            });
        function ClearAll() {
            if (BoolEditingLoan == true) {
                //ensure you reset entire window on new appraisal or make sure you reset public vars
                document.location = "/Bank/BankSystem/LoanAppraisal";
            }
            EditMemberLoanApplicationNo = null;
            EditMemberLoanApplicationDetails = null;
            EditMemberLoanNo = null;
            EditLoanDetails = null;

            ClearAppraisalData();
            ClearAppraisalReport();
        }
        
        $("#cboLoanType").on('change', function () {
            DisplayMaxRepayment();
        });

        function DisplayMaxRepayment() {
            var tmpArr = $("#cboLoanType").val();
            var tmpArr = tmpArr.split("^");
            $("#txtRepaymentPeriod").val(tmpArr[1]);
        }

        

        

        function setCookie(c_name, value, expiredays) {
            var exdate = new Date();
            exdate.setDate(exdate.getDate() + expiredays);
            document.

                e = c_name + "=" + escape(value) +
            ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
        }
        function getCookie(c_name) {
            if (document.cookie.length > 0) {
                c_start = document.cookie.indexOf(c_name + "=");
                if (c_start != -1) {
                    c_start = c_start + c_name.length + 1;
                    c_end = document.cookie.indexOf(";", c_start);
                    if (c_end == -1) c_end = document.cookie.length;
                    return unescape(document.cookie.substring(c_start, c_end));
                }
            }
            return "";
        }
        function LoadCreditAccounts() {
            $('#cboCreditAccount').empty();
            var EmpCode = "";
            var PayrollNo = "";
            var elt = document.getElementById("cboEmployer");
            var elt2 = document.getElementById("cboSearchBy");
            if (elt2.selectedIndex == 3) {
                if (elt.selectedIndex = 0) {
                    alert("Select Employer");
                    return false;
                }
            }
            if ($('#txtSearch').val() == '') {
                alert('Enter Search Critria');
                return false;
            }
           

            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetLoanAppraisalAccounts") %>",
                    data: "{'SearchBy' : '" + $("#cboSearchBy").val() + "','SearchValue' : '" + $("#txtSearchValue").val() + "','EmpCode' : '" + $("#cboEmployer").val() + "'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        DisplayCreditAccounts(response)
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
            });

        }

        function DisplayCreditAccounts(mList) {
            $('#cboCreditAccount').empty();
            var obj = document.getElementById("cboCreditAccount");
            var opt = document.createElement("option");
            opt.value = "";
            opt.text = "(SELECT CREDIT ACCOUNT)";
            obj.appendChild(opt);
            $.each(mList, function (index, mListItem) {
                var opt = document.createElement("option");
                opt.value = mListItem.UserCode;
                opt.text = mListItem.AccountName + "(" + mListItem.UserCode + ")";
                obj.appendChild(opt);

                if (SalaryAccount) {
                    if (SalaryAccount.toLowerCase() == mListItem.UserCode.toLowerCase()) {
                        obj.selectedIndex = index + 1;
                    }
                }
            });
        }

        function GetMemberDetails(){
            
            $("#tblOffsets > tbody:last").children().remove();
            $("#tblBalances > tbody:last").children().remove();
            var SalaryAccount = "";
            var EmpCode = "";
            var PayrollNo = "";
            var elt = document.getElementById("cboEmployer");
            var elt2 = document.getElementById("cboSearchBy");
            if (elt2.selectedIndex == 3) {
                if (elt.selectedIndex = 0) {
                    alert("Select Employer");
                    return false;
                }
            }
            if ($('#txtSearch').val() == '') {
                alert('Enter Search Critria');
                return false;
            }

            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetMemberBalancesSummary") %>",
                    data: "{'SearchBy' : '" + $("#cboSearchBy").val() + "','SearchValue' : '" + $("#txtSearchValue").val() + "','EmpCode' : '" + $("#cboEmployer").val() + "','IncludeNegativeLoans' : 'F'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        DisplayMemberInfo(response.MemberDetails);
                        DisplayMemberBalances(response.MemberBals);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                }).done(function(){
                    LoadCreditAccounts()
                });
        }

        

        function SendAppraisalData(AppraisalAction, UserCredentials) {
            if ($("#divLoanStatus").html() == "In-Service") { alert("Loan is in service"); return; }
            var UserName = null;
            var Password = null;
            if (UserCredentials == null) { }
            else {
                UserName = UserCredentials.UserName;
                Password = UserCredentials.UserPass;
                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();
            }
            var Guarantors = new Array();
            var Offsets = new Array();
            var PayslipEarnings = new Array();
            var PayslipDeductions = new Array();
            var tbody = document.getElementById('bdTblIncomes');
            var tableRows = tbody.getElementsByTagName('tr');
            var rowCount = tableRows.length;
            var Entries = 0;
            var AppraisedReport = {
                RecommendedAmount:$("#txtRecomendedAmount").val(),
                RepaymentPeriod:$("#txtRecomendedRepaymentPeriod").val(),
                InstallmentAmount:$("#txtRecomendedInstallmentAmount").val(),
                IncomeFractionised:$("#txtIncomeFractionized").val(),
                TotalDeductionsFromIncome:$("#txtPayslipDeductions").val(),
                SharesMultiplied:$("#txtDepositsMultiplied").val(),
                SharesEligibiliy:$("#txtSharesEligibility").val(),
                SalaryEligibiliy:$("#txtSalaryEligibility").val(),
                GrantsEligibiliy:$("#txtGuarantorsEligibility").val(),
                TotalShares:$("#txtSchemeBalance").val(),
                StartYear:$("#txtStartYear").val(),
                StartPeriod: $("#txtStartPeriod").val(),
                StartMonthName: $("#txtStartMonth").val(),
                Reasons:$("#txtReasons").val()
            }
            for (var x = rowCount - 1; x > 0; x--) {
                var Earning = {};
                var lineamount = 0;
                var myrow = tbody.getElementsByTagName("tr")[x];
                var mycel = myrow.getElementsByTagName("td")[2];
                lineamount = mycel.childNodes.item(0).value;

                if (!isNumber(lineamount)) {
                    alert("Invalid earning Amount " + lineamount + " at row " + x);
                    return;
                }
                if (lineamount < 0) {
                    alert("Earning Amount " + lineamount + " should be more than or equal to Zero. At row " + x);
                    return;
                }

                Earning.LoanSerialNumber = "";
                Earning.EarningName = "";
                Earning.ComputationalPercentage = 100;
                var mycel = myrow.getElementsByTagName("td")[0];
                Earning.EarningCode = mycel.innerHTML;
                var mycel = myrow.getElementsByTagName("td")[2];
                Earning.EarningAmount = lineamount

                PayslipEarnings[Entries] = Earning;
                Entries++;
            }

            var tbody = document.getElementById('bdTblDeductions');
            var tableRows = tbody.getElementsByTagName('tr');
            var rowCount = tableRows.length;
            var Entries = 0;
            for (var x = rowCount - 1; x > 0; x--) {
                var Deduction = {};
                var lineamount = 0;
                var myrow = tbody.getElementsByTagName("tr")[x];
                var mycel = myrow.getElementsByTagName("td")[2];
                lineamount = mycel.childNodes.item(0).value;

                if (!isNumber(lineamount)) {
                    alert("Invalid deduction Amount " + lineamount + " at row " + x);
                    return;
                }
                if (lineamount < 0) {
                    alert("Deduction Amount " + lineamount + " should be more than or equal to Zero. At row " + x);
                    return;
                }

                Deduction.LoanSerialNumber = "";
                Deduction.DeductionName = "";
                var mycel = myrow.getElementsByTagName("td")[0];
                Deduction.DeductionCode = mycel.innerHTML;
                var mycel = myrow.getElementsByTagName("td")[2];
                Deduction.DeductionAmount = lineamount
                Deduction.IsStatutory = "N";
                PayslipDeductions[Entries] = Deduction;
                Entries++;
            }
            

            //********************************************************
            var validCount = 0;
            var dblTotalAmount = 0;
            $("#tblGuarantors tbody").find('tr').each(function (i) {
                var Guarantor = {};
                var row = $(this); //store in variable for faster access
                var txtAmt = row.find('td:eq(5)').find('input:eq(0)');
                if (!isNumber(txtAmt.val())) {
                    alert("Invalid guarantor amount at row " + i);
                    return;
                }
                var line_amount = txtAmt.val();
                line_amount = +line_amount;
                if (line_amount < 0) {
                    alert("Guarantor Amount  " + line_amount + " should be more than or equal to Zero. At row " + i);
                    return;
                }
                if (line_amount > 0) {
                    Guarantor.LoanSerialNumber = "";
                    Guarantor.AvailableLoanBal = 0;
                    Guarantor.GuarantorMemberNumber = row.find('td:eq(3)').text();
                    Guarantor.AvailableShares = row.find('td:eq(4)').text();
                    Guarantor.SharesToCommit = line_amount;
                    Guarantors[validCount] = Guarantor;
                    validCount++;
                }
            });

            //********************************************************

            //********************************************************
            var validCount = 0;
            var OffSetsList = new Array();
            var dblTotalAmount = 0;
            $("#tblOffsets tbody").find('tr').each(function (i) {
                var OffSetEntry = {};
                var row = $(this); //store in variable for faster access
                OffSetEntry.TransType = row.find('td:eq(0)').text();
                OffSetEntry.BalCode = row.find('td:eq(1)').text();
                OffSetEntry.BalName = row.find('td:eq(2)').text();
                OffSetEntry.BalAmount = row.find('td:eq(3)').text();

                if ((OffSetEntry.TransType) == "S") {
                    OffSetEntry.Scheme = OffSetEntry.BalCode;
                    OffSetEntry.ClearLoanCode = "";
                    OffSetEntry.OffsetInt = "";
                }
                if ((OffSetEntry.TransType) == "L") {
                    OffSetEntry.Scheme = "";
                    OffSetEntry.ClearLoanCode = OffSetEntry.BalCode;
                    OffSetEntry.OffsetInt = "";
                }
                if ((OffSetEntry.TransType) == "I") {
                    OffSetEntry.Scheme = "";
                    OffSetEntry.ClearLoanCode = "";
                    OffSetEntry.OffsetInt = OffSetEntry.BalCode;
                }
                
                var txtAmt = row.find('td:eq(4)').find('input:eq(0)');
                if (!isNumber(txtAmt.val())) {
                    alert("Invalid offset amount at row " + i);
                    return;
                }
                var line_amount = txtAmt.val();
                line_amount = +line_amount;
                if (line_amount < 0) {
                    alert("Offset Amount  " + line_amount + " should be more than or equal to Zero. At row " + i);
                    return;
                }
                if (line_amount > 0) {
                    OffSetEntry.LoanSerialNumber = "";
                    OffSetEntry.AccCr = "";
                    OffSetEntry.AutoAmt = line_amount;
                    OffSetEntry.OtherNarration = "";
                    OffSetEntry.Posted = "N";
                    OffSetsList[validCount] = OffSetEntry;
                    validCount++;
                }
            });

            //********************************************************

            
            var tmpArr = $("#cboLoanType").val();
            var tmpArr = tmpArr.split("^");
            
            var outData = {
                'EmpCode': $("#cboEmployer").val(),
                'SearchBy': $("#cboSearchBy").val(),
                'SearchValue': $("#txtSearchValue").val(),
                'LoanTypeCode': tmpArr[0],
                'LoanAmount': $("#txtLoanAmount").val(),
                'RepaymentPeriod': $("#txtRepaymentPeriod").val(),
                'LoanPurpose': $("#txtLoanPurpose").val(),
                'LoanDate': $("#txtLoanDate").val(),
                'CreditAccount': $("#cboCreditAccount").val(),
                'AppraisalAction': AppraisalAction,
                'Guarantors': Guarantors,
                'Offsets': OffSetsList,
                'PayslipEarnings': PayslipEarnings,
                'PayslipDeductions': PayslipDeductions,
                'AppraisedReport': AppraisedReport,
                'UserName': UserName,
                'Password': sltpwd,
                'Salt': pwdslt,
                'EditMemberLoanApplicationNo': EditMemberLoanApplicationNo,
                'EditMemberLoanNo': EditMemberLoanNo,
                'EditDB': EditDB
        
            }
            
            outData = JSON.stringify(outData);
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/ProcessLoanAppraisal") %>",
                data: outData,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if(AppraisalAction=="processappraisal"){
                        $("#txtRecomendedAmount").val(response.RecommendedAmount);
                        $("#txtRecomendedRepaymentPeriod").val(response.RepaymentPeriod);
                        $("#txtRecomendedInstallmentAmount").val(response.InstallmentAmount);
                        $("#txtIncomeFractionized").val(response.IncomeFractionised);
                        $("#txtPayslipDeductions").val(response.TotalDeductionsFromIncome);
                        $("#txtDepositsMultiplied").val(response.SharesMultiplied);
                        $("#txtSharesEligibility").val(response.SharesEligibiliy);
                        $("#txtSalaryEligibility").val(response.SalaryEligibiliy);
                        $("#txtGuarantorsEligibility").val(response.GrantsEligibiliy);
                        $("#txtSchemeBalance").val(response.TotalShares);
                        $("#txtStartYear").val(response.StartYear);
                        $("#txtStartMonth").val(response.StartMonthName);
                        $("#txtStartPeriod").val(response.StartPeriod);
                        $("#txtReasons").val(response.Reasons);
                    } else if (AppraisalAction == "savenewappraisal") {
                        alert(response);
                    }
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });
        }

        
        

       // $(function () {
         //  $("#tabs").tabs();
            
        //});

        $('#tabs').responsiveTabs({
            // Start with the panels collapsed if the view is currently accordion based
            startCollapsed: 'accordion',
            // Tabs can be collapsed
            collapsible: true,
            // Tabs auto rotate
            rotate: false
        });
        $(function () {
            $("#accordion").accordion();
        });
        function ShowSearchParams() {
            $('#divSearchDisplay').empty();
            $('#divSearchDisplay').append('Enter ' + $("#cboSearchBy option:selected").text());
        }
        function ShowGuarantorSearchParams() {
            $('#divGuarantorSearchBy').empty();
            $('#divGuarantorSearchBy').append('Enter ' + $("#cboGuarantorSearchBy option:selected").text());
        }
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
    <div id="tabs" class="mb-5">
        <div class="my-4 mx-auto d-flex justify-content-center col-12 col-md-8 ">
            <div id="customTabs" class="custom-tabs  position-relative">
      <ul class="custom-tabs-nav mb-0 d-flex list-unstyled">
        <li><a href="#tab1" data-tab="tab1" class="custom-tab-label active">Loan Details</a></li>
        <li><a href="#tab2" data-tab="tab2" class="custom-tab-label">Payslip Capture</a></li>
        <li><a href="#tab3" data-tab="tab3" class="custom-tab-label">Guarantors</a></li>
        <li><a href="#tab4" data-tab="tab4" class="custom-tab-label">FOSA Guarantors</a></li>
        <li><a href="#tab5" data-tab="tab5" class="custom-tab-label">Other Securities</a></li>
        <li><a href="#tab6" data-tab="tab6" class="custom-tab-label">Offsets & Topup</a></li>
        <li><a href="#tab7" data-tab="tab7" class="custom-tab-label">Balances</a></li>
        <li><a href="#tab8" data-tab="tab8" class="custom-tab-label">Report</a></li> 
      </ul>
      <span class="custom-glider position-absolute d-flex" style="transform: translateX(0);"></span>
      </div>
      </div>

   

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="card bg-white">
        <h3 class="p-3 fs-5">Loan Appraisal</h3>
        <hr class="m-0 p-0" />
    
    <form name="frmLoanAppraisal" id="frmLoanAppraisal" >
        <%= Html.AntiForgeryToken() %>

        
        <div id="tab1" class="tab-content-panel active">



            <div >
        <div class="p-3">

           <div>
                <h5 class="fs-6 text-decoration-underline">Loan Details</h5>
           </div>

             <div class="row mt-4">
                <div class="col-auto">
              <label for=" Employer" class="form-label"> Employer:</label>
              <select id="cboEmployer"  class="form-select"><option value="" selected>(SELECT EMPLOYER)</option></select>
                
             </div> 

           
             <div class="col-auto">
                    <label for=" Search By:" class="form-label"> Search By:</label>
                    <select id="cboSearchBy" class="form-select" onchange="ShowSearchParams()" onclick="ShowSearchParams()">
                                            <option value="fosaaccount">AccountNo</option>
                                            <option value="memberno" selected>MemberNo</option>
                                            <option value="idnumber">IDNo</option>
                                            <option value="payrollno">PayrollNo</option>
                                       </select>
                 </div>
         
         




                <div class="col-md-2">
                    <div class="form-label" id="divSearchDisplay">Search Value</div>
                    <input type="text" class="form-control" placeholder="search" id="txtSearchValue" />
                </div>

                
                <div class="col-md-3" style="margin-top: 20px;">
                 <div class="form-label fs-1"> </div>
                    <input type="button" id="btnGetMember" class="btn btn-primary form-control"  value="Get Member"/>
                </div>
            

            
            
            <div class="mt-2">
                <h5 class="fs-6 text-decoration-underline">Account Info</h5>
                <div  id="divAccountInfo"></div>
            </div>
            
            <div class="row">
                <div class="col-auto">
                 <label for="Loan Serial No" class="form-label">Loan Serial No:</label>   
                    <div id="divLoanSerialNumber"></div>
                </div>
                <div class="col-auto">
                    <label for="Loan Status" class="form-label">Loan Status:</label>
                    <div id="divLoanStatus"></div>
                </div>
            </div>


            <div class="row">
                <div class="col-md-4 mt-1">
                 <label for="Loan Type" class="form-label">Loan Type</label>   
                <select id="cboLoanType" class="form-select" name="cboLoanType"><option value="">(SELECT LOAN TYPE)</option></select>
                </div>


                <div class="col-md-4 mt-1">
                    <label for="Loan Amount" class="form-label">Loan Amount</label> 
                    <input type="text" class="form-control" id="txtLoanAmount" name="txtLoanAmount" />
                </div>

                <div class="col-md-4 mt-1">
                    <label for="Repayment Period" class="form-label">Repayment Period</label> 
                    <input type="text" id="txtRepaymentPeriod" placeholder="Repayment Period" class="form-control" name="txtRepaymentPeriod" />
                </div>

                <div class="col-md-4 mt-1">
                   <label for="Credit Account" class="form-label">Credit Account</label> 
                    <select id="cboCreditAccount" class="form-select" name="cboCreditAccount"><option value="">(SELECT CREDIT A/C)</option></select>
                </div>
                <div class="col-md-4 mt-1">
                    <label for="Appraisal Date" class="form-label">Appraisal Date</label> 
                    
             
                    <input type="text" id="txtLoanDate"  class="form-control" name="txtLoanDate"  />
                </div>

                    <div class="col-md-4 mt-1">
                        <label for="Purpose for Loan" class="form-label">Purpose for Loan</label> 
                        <textarea id="txtLoanPurpose" class="form-control" name="txtLoanPurpose" placeholder="Purpose for Loan"></textarea>
                    </div>

              

               
                <div class="col-md-4 mt-1">
                        <label for="Instructions" class="form-label">Instructions</label> 
                        <textarea class="form-control" id="txtInstructions" placeholder="Instructions" name="txtInstructions" ></textarea>
                </div>
        </div>
    </div>
</div>

</div>
</div>








        <div id="tab2" class="tab-content-panel">
           <div>
                    <div class="p-3" >
                        <div class="row">
                             <div class="col-auto">
                                <h4 class="fs-6">Capture Incomes</h4>
                                <div id="divSalaryIncomes"  style="overflow:auto;width:auto"></div>
                            </div>
                             <div class="col-auto">
                
                                <h4 class="fs-6">Capture Deductions</h4>
                                <div id="divSalaryDeductions"  style="overflow:auto;width:auto;"></div>
                  
                             </div>
                     
                     
                        </div>


            
            </div>

        </div>
        </div>










        <div id="tab3" class="tab-content-panel">
            <div>
                <div class="p-3">
               <h5 class="fs-6 text-decoration-underline">Capture Guarantors</h5>
              <div class="row mt-2">
               <div class="col-auto">
                <label class="form-label">Employer:</label>
                    <select id="cboGuarantorEmpCode" class="form-select">
                        <option value="" selected>(SELECT EMPLOYER)</option>
                    </select>
            </div>
            <div class="col-auto">
                <label for="Search By:" class="form-label">Search By:</label>
                <select id="cboGuarantorSearchBy" class="form-select">
                    <option value="fosaaccountno">AccountNo</option>
                    <option value="memberno" selected>MemberNo</option>
                    <option value="idnumber">IDNo</option>
                    <option value="payrollno">PayrollNo</option>
                </select>
           </div>
            <div class="col-md-3">
             <div id="divGuarantorSearchBy" class="form-label">Search Value</div>
            <input type="text" id="txtGuarantorSearchValue" placeholder="search value" class="form-control" />
            </div>
            <div class="col-md-3">
                <label for="Amount Guaranteed" class="form-label">Amount Guaranteed</label>
                    
                    <input type="text" id="txtGuaranteedAmount" placeholder="amount guaranteed" class="form-control" />
              
            </div>
        </div>

        <div class="mt-4">
                <input type="button" name="btnAddGuarantor" class="btn-primary btn" id="btnAddGuarantor" value="Add Guarantor"/>
                <input type="button" name="btnDeleteGuarantor" class="btn-danger btn" id="btnDeleteGuarantor" value="Delete Guarantor"/>
        </div>
 
    </div>
<hr/>
            <div id="div1" class="mt-5 p-3" style="overflow:auto;">
               <h4 class="fs-6 text-decoration-underline">Guarantors</h4>
                <table id='tblGuarantors' class="table table-bordered">
                        <thead>
                            <tr>
                                <th>G.Names</th>
                                <th>G.EmpCode</th>
                                <th>G.PayrollNo</th>
                                <th>G.MemberNo</th>
                                <th>G.Deposits</th>
                                <th>G.Amount</th>
                            </tr>
                        </thead>
                        <tbody id='bdGuarantors'>
                        </tbody>
                    
                </table>
            </div>
        </div>
        </div>

        <div id="tab4" class="tab-content-panel">
        </div>
        <div id="tab5" class="tab-content-panel">
        </div>

        <div id="tab6" class="tab-content-panel p-3">
            
            <div id="divOffsets"  style="overflow:auto;">
                <h5 class="text-decoration-underline fs-6"> Offsets </h5> 
                <table id='tblOffsets'  class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Type</th>
                                <th>Code</th>
                                <th>Name</th>
                                <th>Balance</th>
                                <th>Offset</th>
                            </tr>
                        </thead>
                        <tbody id='bdOffsets'>
                        </tbody>
                </table>
            </div>
                
        </div>




        
        <div id="tab7" class="tab-content-panel p-3">
            <div>

            <div id="divBalances"  style="overflow:auto;">
              <h5 class="fs-6 text-decoration-underline">Member Balances </h5>  
                <table id='tblBalances'  class="table table-bordered ">
                        <thead>
                            <tr>
                                <th>Type</th>
                                <th>Code</th>
                                <th>Name</th>
                                <th>Balance</th>
                                
                            </tr>
                        </thead>
                        <tbody id='bdBalances'>
                        </tbody>
                </table>
            </div>
        </div>  
        </div>





        <div id="tab8" class="tab-content-panel p-3">

            <div>

            <p class="text-decoration-underline fs-6">Process Loan</p>
            <div id="divProcessLoan"></div>

            <div >


             
                    <div class="row">
                        <div class="col-auto">
                            <label for="Recomended Amount" class="form-label">Recomended Amount</label>
                        
                            <input type="text" id="txtRecomendedAmount" class="form-control" readonly="readonly" />
                        </div>
                        <div class="col-auto">
                            
                            <label for="Repayment Period" class="form-label">Repayment Periodt</label>
       
                            <input type="text" id="txtRecomendedRepaymentPeriod" class="form-control" readonly="readonly" />
                        </div>
                        <div class="col-auto">
                            <label for="Installment Amount" class="form-label">Installment Amount</label>
                    
                            <input type="text" class="form-control" id="txtRecomendedInstallmentAmount" readonly="readonly" />
                        </div>
                            <div class="col-auto">
                                <label for=" Income Fractionized" class="form-label"> Income Fractionized</label>
                        
                        
                            <input type="text" id="txtIncomeFractionized" class="form-control" readonly="readonly" />
                            </div>




                        <div class="col-auto">
                            <label for="Payslip Deductions" class="form-label">Payslip Deductions</label>
                     
                            <input type="text" class="form-control" id="txtPayslipDeductions" readonly="readonly" />
                        </div>
                        <div class="col-auto">
                            <label for=" Deposits Multiplied" class="form-label"> Deposits Multiplied</label>
                      
                            <input type="text" class="form-control" id="txtDepositsMultiplied" readonly="readonly" />
                        </div>


                        <div class="col-auto">
                            <label for=" Shares Eligibility" class="form-label"> Shares Eligibility</label>
                     
                      
                            <input type="text" class="form-control" id="txtSharesEligibility" readonly="readonly" />
                        </div>
                        <div class="col-auto">
                            <label for="Salary Eligibility" class="form-label">Salary Eligibility</label>
                     
                    
                            <input type="text" class="form-control" id="txtSalaryEligibility" readonly="readonly" />
                        </div>


                        <div class="col-auto">
                            <label for="Guarantors Eligibility" class="form-label">Guarantors Eligibility</label>
                     
                      
                            <input type="text" class="form-control" id="txtGuarantorsEligibility" readonly="readonly" />
                        </div>
                        <div class="col-auto">
                            <label for="Scheme Balance" class="form-label">Scheme Balance</label>
                     
                            <input type="text" class="form-control" id="txtSchemeBalance" readonly="readonly" />
                        </div>



                        <div class="col-auto">
                            <label for="Start Year" class="form-label">Start Year</label>
                     
                            <input type="text" class="form-control" id="txtStartYear" readonly="readonly" />
                        </div>
                        <div class="col-auto">
                            <label for="Start Month" class="form-label">Start Month</label>
                     
                            <input type="text" id="txtStartMonth" class=" form-control" readonly="readonly" />
                          
                             </div>


                        <div class="col-auto">
                            <label for="StartPeriod" class="form-label">Start Period</label>
                     
                            <input type="text" id="txtStartPeriod"  class=" form-control" readonly="readonly" />
   
                        </div>

                       
                        
                        <div class="col-auto">
                            <label for="Reasons" class="form-label">Reasons</label>
                                    <textarea id="txtReasons" class="form-control" readonly="readonly"  placeholder="Reasons"></textarea>
                       
                            </div>


                    </div>
                        <div class=" mt-4">
                            <input type="button"  id="btnSaveAppraisal" name="btnSaveAppraisal" value="Save Appraisal" class="btn btn-success"/>
                        </div>
            </div>
        </div>
        </div>
    <div class="d-grid gap-3 d-md-block text-end m-4 g-3">
        <input type="button" class="btn btn-primary"  id="btnNewAppraisal" name="btnNewAppraisal" value="New Appraisal"/>
        <input type="button" class="btn btn-danger " id="btnCancelAppraisal" name="btnCancelAppraisal" value="Cancel Appraisal" />
        <input type="button" class="btn btn-success " id="btnProcessAppraisal" name="btnProcessAppraisal" value="Process Appraisal" />
    </div>
</form>
</div>
</div>
    
</asp:Content>


