﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<XtremeERP.Common.Data.GeneralReportsParams>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    General Reports
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
    <div id="tabs">
        <div class="my-4 mx-auto d-flex justify-content-center col-12 col-md-8 ">
            <div id="customTabs" class="custom-tabs  position-relative">
                <ul class="custom-tabs-nav mb-0 d-flex list-unstyled">
                    <li><a href="#tab1" data-tab="tab1" class="custom-tab-label active">Report Selection</a></li>
                </ul>
                <span class="custom-glider position-absolute d-flex" style="transform: translate(0);"></span>
        </div>
        </div>
    </div>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="card bg-white p-3">
        <h3 class="p-3 fs-5">General Reports</h3>
        <hr class="m-0 p-0"/>

        <form class="form-inline" id="frmGeneralReports" method="post" action="<%: Url.Content("~/BankSystem/GetGeneralReport") %>">

            <%= Html.AntiForgeryToken() %>

                        <div class="row">
                            <div class="col-md-4">
                                <label class="form-label" for="ReportType">Report Type</label>
                                <%:  Html.DropDownListFor(model => model.ReportType, ViewBag.select_report_type as List<SelectListItem>, new { id = "ReportType", name = "ReportType", @class="form-select  " }) %>
                            </div>
                            <div class="col-md-4">
                                    <label for="ReportFormat" class="form-label">Report Format:</label>
                                    <%:  Html.DropDownListFor(model => model.ReportFormat, ViewBag.select_report_format as List<SelectListItem>, new { id = "ReportFormat", name = "ReportFormat", @class="form-select  " }) %>
                            </div>
                <div class="col-md-4">
                        <label for="ReportYear" class="form-label">Year</label>
                        <%:  Html.DropDownListFor(model => model.FinancialYear, ViewBag.select_financialyears_Items as SelectList, new { id = "FinancialYear", name = "FinancialYear", @class="form-select  " }) %>
                </div>

                <div class="col-md-4">
                    <label for="ReportPeriod" class="form-label">Period:</label>
                    <%:  Html.DropDownListFor(model => model.FinancialPeriod, ViewBag.select_financialperiods_Items as SelectList, new { id = "FinancialPeriod", name = "FinancialPeriod", @class="form-select " }) %>
                </div>

                <div class="col-md-4">
                    <label for="Employer" class="form-label">Employer:</label>
                    <%:  Html.DropDownListFor(model => model.Employer, ViewBag.select_employers_Items as SelectList, new { id = "Employer", name = "Employer"  , @class="form-select  "}) %>
                </div>

                <div class="col-md-4">
                    <label for="Branch" class="form-label">Branch:</label>
                    <%:  Html.DropDownListFor(model => model.Branch, ViewBag.select_branches_Items as SelectList, new { id = "Branch", name = "Branch"  , @class="form-select  "}) %>
                </div>
          
              <div class="col-md-4">
                <div class="form-group">
                    <label for="LoanType" class="form-label">Loan Type:</label>
                    <%:  Html.DropDownListFor(model => model.LoanType, ViewBag.select_loantypes_Items as SelectList, new { id = "LoanType", name = "LoanType"  , @class="form-select  "}) %>
                </div>
              </div>

                <div class="col-md-4">
                    <label for="SchemeType" class="form-label">Scheme Type:</label>
                    <%:  Html.DropDownListFor(model => model.SchemeType, ViewBag.select_schemes_Items as SelectList, new { id = "SchemeType", name = "SchemeType" , @class="form-select  "}) %>
                </div> 
                
           
                <div class="col-md-4">
                    <label for="FosaAccountType">A/C Type:</label>
                    <%:  Html.DropDownListFor(model => model.FosaAccountType, ViewBag.select_typesofmembersaccounts_Items as SelectList, new { id = "FosaAccountType", name = "FosaAccountType"  , @class="form-select  "}) %>
                </div>

                    <div class="col-md-4">
                        <label for="MemberType" class="form-label">Member Type:</label>
                        <%:  Html.DropDownListFor(model => model.MemberType, ViewBag.select_membertypes_Items as SelectList, new { id = "MemberType", name = "MemberType"  , @class="form-select  "}) %>
                </div>

                    <div class="col-md-4">
                        <label for="MemberStatus" class="form-label">Member Status:</label>
                        <%:  Html.DropDownListFor(model => model.MemberStatus, ViewBag.select_memberstatus_Items as SelectList, new { id = "MemberStatus", name = "MemberStatus"  , @class="form-select  "}) %>
                    </div>
        
                    <div class="col-md-4">
                    <label for="BalCriteria" class="form-label">Balance:</label>
                    <select id="BalCriteria" class="form-select">
                        <option value='all' selected>All</option>
                        <option value="lessthan">Less Than</option>
                        <option value="morethan">More Than</option>
                    </select>
                </div>

                    
                <div class="col-md-4">
                    <label for="txtBalCriteria " class="form-label">Balance:</label>
                    <input type="number" id="txtBalCriteria" class="form-control"/>
                </div>

                    <div class="col-md-4">
                    <label for="SortBy" class="form-label">Sort By:</label>
                    <%:  Html.DropDownListFor(model => model.SortBy, ViewBag.select_report_sort  as List<SelectListItem>, new { id = "SortBy", name = "SortBy" ,  @class="form-select  "}) %>
                </div>
                <div class="col-md-4">
                    <label for="GroupLoansBy" class="form-label">Group Loans By:</label>
                    <%:  Html.DropDownListFor(model => model.GroupLoansBy, ViewBag.select_report_grouploansby  as List<SelectListItem>, new { id = "GroupLoansBy", name = "GroupLoansBy" , @class="form-select  "}) %>
                </div>

            
                <div class="col-md-4 mt-3">
                    <input type="submit" value="Get Report" id="btnGetReport" name="btnGetReport" class="btn btn-success" />
                </div>
        </form>
    </div>
</asp:Content>



<asp:Content ID="Content4" ContentPlaceHolderID="ScriptsSection" runat="server">
    <script type="text/javascript">
        $(document).ready(function () {
            $("#FinancialPeriod").addClass("form-control");
            $("#FinancialYear").addClass("form-control");
            $("#ReportType").addClass("form-control");
            $("#ReportFormat").addClass("form-control");
           // $(function () {
             //   $("#tabs").tabs();
            //});
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
    </div>
</asp:Content>

