﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<!DOCTYPE html>

<html>
    <head runat="server">
    <meta name="viewport" content="width=device-width" />
    <title>View/Edit GL Account</title>
        <%: Scripts.Render("~/bundles/jquery") %>
        <%: Scripts.Render("~/bundles/jqueryui") %>
        <%: Scripts.Render("~/bundles/modernizr") %>
        <%: Scripts.Render("~/bundles/CryptoJS") %>
        <%: Scripts.Render("~/bundles/form2js") %>
        <%: Scripts.Render("~/bundles/printThis") %>
        <%: Scripts.Render("~/bundles/jquerymaskedinput") %>
        <%: Scripts.Render("~/bundles/jquery_dataTables") %>
        <%: Scripts.Render("~/bundles/Q") %>
        <%: Scripts.Render("~/bundles/CustomUtils") %>
        <%: Scripts.Render("~/bundles/toWords") %>
        <%: Scripts.Render("~/bundles/bootstrap") %>

        <%: Styles.Render("~/Content/site") %>
        <%: Styles.Render("~/Content/style") %>
        <%: Styles.Render("~/Content/jquery_dataTables_min") %>
        <%: Styles.Render("~/Content/smoothness") %>
        <%: Styles.Render("~/Content/jqrejectcss") %>
        <%: Styles.Render("~/Content/jquery_dataTables_themeroller_min") %>
        <%: Styles.Render("~/Content/themes/base/css") %>
        <%: Styles.Render("~/Content/bootstrap") %>
        

</head>
    <body>
    <h3 class="fs-6 text-decoration-underline">View/Edit GL Account</h3>
    <div>
        <form id="frmMain" name="frmMain">
            <%= Html.AntiForgeryToken() %>
            <div class="row">
                <div class="col-md-4">
                    <label for="accountno" class="form-label">Account No</label>
                        <input type="text" class="form-control" id="txtAccountNo" disabled/>
                </div>
            

                <div class="col-md-4">
                    <label for="accountname" class="form-lable">Account Name</label>
                        <input type="text" class="form-control" id="txtAccountName" disabled />
                </div>

                    <div class="col-md-4">
                    <label for="memffect" class="form-lable">Mem Effect</label>
                        <input type="text" class="form-control" id="txtMemEffect" disabled/>
                    </div>

                    <div class="col-md-4">
                    <label for="active" class="form-lable">Active</label>
                        <input type="text" class="form-control" id="txtActive" disabled/>
                    </div>

                    <div class="col-md-4">
                    <label for="transacting" class="form-lable">Transacting</label>
                        <input type="text" class="form-control" id="txtTransacting" disabled />
                    </div>

                    <div class="col-md-4">
                    <label for="accountcode" class="form-lable">Account Code</label>
                        <input type="text" class="form-control" id="txtAccountCode" disabled/>
                    </div>

                    <div class="col-md-4">
                    <label for="createdby" class="form-lable">Create By</label>
                        <input type="text" class="form-control" id="txtCreatedBy" disabled/>
                </div>

                    <div class="col-md-4">
                        <label for="datecreated" class="form-lable">Date Created</label>
                        <input type="text" class="form-control" id="txtDateCreated" disabled />
                    </div>

                    <div class="col-md-4">
                    <label for="activity" class="form-lable">Activity</label>
                    <input type="text" class="form-control" id="TxtActivity" disabled />
                    </div>
                         </div>
</div>

            
                         <h4 class="fs-6 mt-3 text-decoration-underline">Enter New Account Details</h4>
                         <div>
            <form id="tblNewAccDetails">
                
                <div class="row">
                    <div class="col-md-4">
                    <label for="accountno" class="form-lable">Account No</label>
                        <input type="text" class="form-control" id="txtNewAccountNo" />
                    </div>
              

                <div class="col-md-4">
                    <label for="accountname" class="form-lable">Account Name</label>
                        <input type="text" class="form-control" id="txtNewAccountName"  />
                </div>
            
                <div class="col-md-4">
                    <label for="memffect" class="form-lable">Mem Control</label>
                        <select id="cboNewMemEffect" class="form-select">
                            <option value="NON" selected>(NON)</option>
                            <option value="SHARES">SHARES</option>
                            <option value="LOANS">LOANS</option>
                            <option value="INTEREST">INTEREST</option>
                        </select>
                    </div>
                
                    <div class="col-md-4">
                        <label for="active" class="form-lable">Active</label>
                        <select id="cboActive" class="form-select">
                            <option selected value="YES">YES</option>
                            <option value="NO">NO</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label for="transacting" class="form-lable">Transacting</label>
                        <select id="cboTransacting" class="form-select">
                            <option selected value="YES">YES</option>
                            <option value="NO">NO</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label for="shortcode" class="form-lable">Short Code</label>
                        <input type="text" class="form-control" id="txtNewAccountCode"/>
                    </div>


                </div> 
            </form>
                    
            <div class="d-flex mt-4 gap-3">
                        <input type="button" class="btn btn-success" id="btnSave" value="Save Changes" />
                        <input type="button" class="btn btn-danger" id="btnClose" value="Close" />
            </div>
                    
            
        </form>
    </div>
</body>
<script type="text/javascript">

    $(document).ready(function () {
        var EditAccountNo = "<% =ViewData["AccountNo"] %>";
            var EditAccountDetails = Object(<% = Json.Encode(ViewData["AccountDetails"] as XtremeERP.Common.Data.Account) %>);
            var SaccoSettings = Object(<% = Json.Encode(ViewData["SaccoSettings"] as XtremeERP.Common.Data.SaccoSettings) %>);
        $("#txtAccountNo").mask(SaccoSettings.AccountFormat);
        $("#txtNewAccountNo").mask(SaccoSettings.AccountFormat);

        DispAccDetails(EditAccountDetails);

        function DispAccDetails(data) {
            $("#txtAccountNo").val(data.UserCode);
            $("#txtAccountName").val(data.AccountName);
            $("#txtMemEffect").val(data.MemEffect);

            $("#txtActive").val(data.Active);
            $("#txtTransacting").val(data.Transacting);
            $("#txtAccountCode").val(data.AccountShortCode);

            $("#txtCreatedBy").val(data.Clerk);
            $("#txtDateCreated").val(data.CreationDate);
            
            $("#txtNewAccountNo").val(data.UserCode);
            $("#txtNewAccountName").val(data.AccountName);
            $("#cboNewMemEffect").val(EditAccountDetails.MemEffect);

            $("#cboActive").prop('selectedIndex', 0);
            $("#cboTransacting").prop('selectedIndex', 0);
            if (!data.Active) {
                $("#cboActive").prop('selectedIndex', 1);
            }
            if (!data.Transacting) {
                $("#cboTransacting").prop('selectedIndex', 1);
            }

            $("#txtNewAccountCode").val(data.AccountShortCode);

        }

            $("#btnClose").on('click', function (e) {
                //window.parent.CloseDialog();
                //$('.ui-widget-overlay , .ui-dialog', window.parent.document).remove();
                window.parent.$('#divEdit').dialog('close');
            });

            $("#btnSave").on('click', function (e) {
                //xDialogGetUserCredetials().then(function (data) { //not loading corectly, maybe coz of iframe
                xDialogMemberCredetials().then(function (data) {
                    //var UserName = data.UserName;
                    var Password = data.UserPass;
                    var pwdslt = getRandomInt(1000, 30000);
                    pwdslt = pwdslt.toString();
                    var pwd = CryptoJS.MD5(Password).toString();
                    pwd = pwd + pwdslt;
                    var sltpwd = CryptoJS.MD5(pwd).toString();

                    var outData = {
                        'EditAccountNo': $("#txtAccountNo").val(),
                        'NewAccountNo': $("#txtNewAccountNo").val(),
                        'NewAccountName': $("#txtNewAccountName").val(),
                        'NewAccountCode': $("#txtNewAccountCode").val(),
                        'NewTransacting': $("#cboTransacting").val(),
                        'NewActive': $("#cboActive").val(),
                        'NewMemEffect': $("#cboNewMemEffect").val(),
                        //'UserName': UserName,
                        'UserPass': sltpwd,
                        'Salt': pwdslt,
                    }
                    outData = JSON.stringify(outData);
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/EditGlAccount") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            alert("Changes Updated");
                            DispAccDetails(response);
                            
                            /*
                             * uncomment this to send data back to parent window
                            $("#txtReceived", parent.document.body).val(response.UserCode);
                            */
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            });

        });
</script>
</html>
