﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Chart Of Accounts
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        
 #myIframe{
  height: 1080px;
  width:1000px;
}

.balancecolumn {
    text-align:right;
}
   </style>

    
    <script type="text/javascript"  >
        
        $(document).ready(function () {
            LoadCOA();
            var editurl = "";
            
            $("#tbCOA").on("click", "a", function (e) {
                e.preventDefault();
                var row = $(this).closest("tr");
                var col = $(this).closest("td");
                var col_index = col.index();
                //alert(col_index);
                //alert(col.text());
                var firstCellValue = row.find("td").first().text();
                //alert(firstCellValue);
                //console.log(firstCellValue);
                if (col_index == 0) //edit acc
                {
                    editurl = $(this).attr("href");
                    $('#divEdit').dialog('open');
                    return false;
                } else { //Create sub acc

                }
            });
            /*
            $('#divCOA').on('click', 'a', function (event) {
                event.preventDefault();
                editurl = $(this).attr("href");
                $('#divEdit').dialog('open');
                return false;
            });
            */
            
            $("#divEdit").dialog({
                autoOpen: false,
                show: "fade",
                hide: "fade",
                modal: true,
                open: function (ev, ui) {
                    $('#EditFrame').attr('src', editurl);
                },
                height: 'auto',
                width: 970,
                resizable: true,
                title: 'Accounts Management',
                buttons: {
                    "Close":{
                        'text':'Close',
                        'class':'btn btn-danger',
                        'click':function () {
                        $(this).dialog("close");
                    }
                    } 
                },
                close: function () {
                    $('#EditFrame').attr("src", "");
                    $(this).dialog("close");
                    LoadCOA();
                }
            });

            $("#btnPrint").click(function () {

                var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "Chart Of Accounts" + "</b>";
                $("#divCOA").printThis({
                    debug: false,
                    pageTitle: "ChartOfAccounts",
                    removeInline: true,
                    printContainer: true,
                    importCSS: true,
                    header: rptHeader
                });

            });
            $("#btnRefresh").click(function () {
                LoadCOA();
            });




            function LoadCOA() {
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $("#bdAccounts").html("");
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetChartOfAccounts") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var accounts = response;
                        var AccSpace = "";
                        var AccName = "";
                        var tbl_row = "";
                        
                        $.each(accounts, function (index, acc) {
                            AccSpace = "";
                            for (var i = 0; i < acc.DashCount; i++) {
                                AccSpace += "&nbsp;&nbsp;&nbsp;&nbsp;";
                            }
                            if (acc.AccIsTitle == "Y") {
                                AccName = "<b>" + acc.AccountName + "</b>";
                            } else {
                                AccName = acc.AccountName;
                            }
                            tbl_row += "<tr><td><a id='editAcc' href='" + global_site_root + "/Bank/BankSystem/GLAccountsManager?AccountNo=" + acc.UserCode + "'>" + acc.UserCode + "</a></td><td>" + acc.AccountCode + "</td><td>" + AccSpace + AccName + "</td><td class='balancecolumn'>" + acc.Balance + "</td><td><a id='newSub' href='' id='link_new_acc'>New Sub Acc</a></td></tr>"
                        });
                        $("#bdAccounts").append(tbl_row);

                    },
                    error: function (xhr, status, error) {
                        console.log(xhr);
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            }

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <form id="frmMain" name="frmMain" class="card p-0">
<h3 class="fs-5 p-3">Chart Of Accounts</h3>
<hr class="m-0 p-0"/>
        <%= Html.AntiForgeryToken() %>
    <div class="p-3">
                <input type="button" id="btnPrint" value="Print" class="btn btn-success" style="margin:10px"/>
                <input type="button" value="Refresh" id="btnRefresh" name="btnRefresh" class="btn btn-info" style="margin:10px" />
            
    </div>
        <div id="divCOA" class="p-3" style="height:auto;overflow:auto;width:auto;">
            <table id="tbCOA" class="table-responsive table-bordered table" style="width:100%" >
                <thead>
                    <tr>
                        <th>Account No</th>  
                        <th>Short Code</th>  
                        <th>Account Name</th>  
                        <th class='balancecolumn'>Balance</th>  
                        <th>New Sub Acc</th>  
                    </tr>
                </thead>
                <tbody id='bdAccounts'>
                </tbody>
                
            </table>
        </div>
    </form>
    
    <div id="divEdit"><iframe id="EditFrame" width="900" height="500"></iframe></div>
</asp:Content>


