﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Bank Statement
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
     <style type="text/css"></style>

    <script type="text/javascript"  >
        

            $(document).ready(function () {
            var SaccoSettings = Object(<%= Json.Encode(ViewBag.SaccoSettings) %>);
            var UserDetails = Object(<%= Json.Encode(ViewBag.UserDetails) %>);
            var strLoginUserName = UserDetails.UserName;
            var AccountMask = SaccoSettings.AccountFormat;
            var CompanyName = SaccoSettings.CompanyName;
            var CompanyAddress = SaccoSettings.CompanyAddress;
            var FinYears = Object(<%= Json.Encode(ViewBag.FinYears as List<XtremeERP.Common.Data.FinancialYear>) %>);

            var BankStatementItems = null;
            $('#tblStatement tbody td:nth-child(1),th:nth-child(1)').hide();

            //self init coz is not part of StaffMaster

                //global_site_root defined in CustomUtils.js
            //global_site_root =String(<% =Url.Content("~/") %>);

                global_site_root = "<% =MvcHtmlString.Create(Url.Content("~/")) %>"; //is for creating safe html strings
                if (global_site_root.endsWith("/")) global_site_root = global_site_root.substring(0, global_site_root.length - 1);;//remove ending slash

                /*
                NOTE: if app is published in iis under Default Web Site global_site_root will be eg / SaccoSystem / else it will return / if it is published directly as a web app under Sites (which is the recommended way to avoid problems with urls ie publish directly under Sites not underanother website)
                In View/Controller/WebApi use
                httpContext.Request.ApplicationPath or
                var httpRequest = HttpContext.Current.Request;
                var appPathUrl = httpRequest.ApplicationPath.ToString();
                see also var rootUrl = getRootUrl(); in CustomUtils to get app main url
                https://www.codeproject.com/Articles/142013/There-is-something-about-Paths-for-Asp-net-beginne
                https://www.cambiaresearch.com/articles/35/how-do-i-get-the-application-path-in-an-aspnet-application
                */


                $("#cboYear").empty();
                $("#txtSearchValue").val("");
                $("#btnSelectAcc").on('click', function () {
                    $("#cboSearchBy").prop("selectedIndex", 0);
                    xDialogSelectGLAccount("ALL").then(function (data) {
                        $("#txtSearchValue").val(data);
                        $("#txtSearchValue").focus();
                    });
                });
                $('#tblStatement').dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                $('#tblTransactionDetails').dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });

                $("#cboSearchBy").on('click', function () {
                    $('#divSearchDisplay').empty();
                    $('#divSearchDisplay').append('Enter ' + $("#cboSearchBy option:selected").text());
                    if (AccountMask != "") {
                        if ($("#cboSearchBy").val() == "accountno") {
                            $("#txtSearchValue").mask(AccountMask);
                        } else {
                            $("#txtSearchValue").unmask();
                        }
                    }
                });
                $("#cboSearchBy").trigger('click');

                $("#txtSearchValue").on('focusout', function () {
                    LoadBankStatementAccounts();
                });
                $("#txtSearchValue").keypress(function (ev) {
                    if (ev.keyCode == 13 || ev.which == 13) {
                        $("#txtSearchValue").trigger('focusout');
                        ev.preventDefault();
                        return false;
                    }
                });
                $("#cboAccount").on('change', function () {
                    LoadBankStatement();
                });
                $('#tblStatement tbody').on('click', 'tr', function () {
                    var TrxID = $(this).find('td').eq(0).text();
                    DispTransactionsDetails(TrxID);
                });
                $("#btnGetAccounts").on('click', function () {
                    LoadBankStatementAccounts();
                });

                $("#cboYear").on('change', function () {
                    var dbname = $("#cboYear").val();
                    if (dbname == null) { return; }
                    $("#cboStartMonth").empty();
                    $("#cboEndMonth").empty();

                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>",
                        data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            var fmonths = response;
                            var objEnd = document.getElementById("cboEndMonth");
                            var objStart = document.getElementById("cboStartMonth");
                            $("#cboStartMonth").empty();
                            $("#cboEndMonth").empty();
                            $.each(fmonths, function (index, fmonth) {
                                var opt = document.createElement("option");
                                opt.value = fmonth.MonthID;
                                opt.text = fmonth.MonthName;
                                objEnd.appendChild(opt);
                                if (fmonth.Status == "OPENED") {
                                    objEnd.selectedIndex = index
                                }
                                opt = document.createElement("option");
                                opt.value = fmonth.MonthID;
                                opt.text = fmonth.MonthName;
                                objStart.appendChild(opt);
                                if (fmonth.MonthID == "01") {
                                    objStart.selectedIndex = index
                                }
                            });
                        },
                        error: function (xhr, status, error) {

                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage); 
                        }
                    });
                });
                $("#btnSearchAccount").on('click', function () {
                    xDialogSearchCustomerAccount().then(function (data) {
                        $("#cboSearchBy").prop('selectedIndex', 0);
                        $("#txtSearchValue").val(data.AccountNo);
                        $("#txtSearchValue").trigger('focusout');
                    });
                });
                //$("#tblStatement").on('keydown','tr',function (evt) {
                //    alert("not working!!");
                //    var TrxID = $(this).find('td').eq(0).text();
                //    DispTransactionsDetails(TrxID);
                //});
                $("#tblStatement").on('keyup',function (evt) {
                    alert("not working!!");
                    var TrxID = $(this).find('td').eq(0).text();
                    DispTransactionsDetails(TrxID);
                });
                $("#btnPrint").click(function () {
                    //$("#mySelector").printThis({
                    //debug: false,              * show the iframe for debugging
                    //importCSS: true,           * import page CSS
                    //printContainer: true,      * grab outer container as well as the contents of the selector
                    //loadCSS: "path/to/my.css", * path to additional css file
                    //pageTitle: "",             * add title to print page
                    //removeInline: false        * remove all inline styles from print elements

                    var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "Bank Statement" + "</b>";
                    $("#divStatement").printThis({
                        debug: false,
                        pageTitle: "Report",
                        removeInline: true,
                        printContainer: true,
                        importCSS: true,
                        header: rptHeader
                    });

                });

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAllEmployer") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var employers = response;
                        var obj = document.getElementById("cboEmployer");
                        $.each(employers, function (index, empl) {
                            var opt = document.createElement("option");
                            opt.value = empl.EmployerCode;
                            opt.text = empl.EmployerName;
                            obj.appendChild(opt);
                        });
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            $("#cboYear").empty();
            $.each(FinYears, function (index, FinYr) {
                $("#cboYear").append("<option value='" + FinYr.DBName + "'>" + FinYr.UserDefinedYearName + "</option>");
            });
            $("#cboYear").get(0).selectedIndex = 0;
            $("#cboYear").trigger('change');



                function DispTransactionsDetails(TrxID)
                {
                    
                    $("#tblTransactionDetails > tbody:last").children().remove();
                    if (BankStatementItems == null) return;
                    var TransDetails = $.grep(BankStatementItems, function (e) {
                        return e.Trx == TrxID.toString();
                    });
                    if (TransDetails[0] !== undefined) {
                        var tbl_row = "";
                        tbl_row += "<tr><td>User: </td><td>" + TransDetails[0].CLERK + "</td></tr>";
                        tbl_row += "<tr><td>Debit A/C: </td><td>" + TransDetails[0].DebitAccountCode + "</td></tr>";
                        tbl_row += "<tr><td>Dr A/c Name: </td><td>" + TransDetails[0].DebitAccountName + "</td></tr>";
                        tbl_row += "<tr><td>Credit A/C: </td><td>" + TransDetails[0].CreditAccountCode + "</td></tr>";
                        tbl_row += "<tr><td>Cr A/c Name: </td><td>" + TransDetails[0].CreditAccountName + "</td></tr>";
                        tbl_row += "<tr><td>Activity: </td><td>" + TransDetails[0].Activity + "</td></tr>";
                        tbl_row += "<tr><td>MemberNo: </td><td>" + TransDetails[0].MemberNo + "</td></tr>";
                        tbl_row += "<tr><td>MemberName: </td><td>" + TransDetails[0].MemberNames + "</td></tr>";
                        tbl_row += "<tr><td>BranchName: </td><td>" + TransDetails[0].BranchName + "</td></tr>";
                        tbl_row += "<tr><td>BranchCD: </td><td>" + TransDetails[0].BranchCD + "</td></tr>";
                        tbl_row += "<tr><td>Day: </td><td>" + TransDetails[0].TransDay + "</td></tr>";
                        tbl_row += "<tr><td>Time: </td><td>" + TransDetails[0].TransTime + "</td></tr>";
                        $("#tblTransactionDetails").append(tbl_row);
                    }
                    
                }



                function LoadBankStatement() {
                    BankStatementItems = null;
                    $('#divAccountInfo').html("");
                    $("#tblStatement > tbody:last").children().remove();
                    $("#tblTransactionDetails > tbody:last").children().remove();
                    $("#divPDF").html("PDF Report");
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/GetBankStatement") %>",
                        data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'StartPeriod': $("#cboStartMonth").val(), 'EndPeriod': $("#cboEndMonth").val(), 'AccountNo': $("#cboAccount").val() }),
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            BankStatementItems = response.StatementItems;
                            $('#divAccountInfo').html('<p><strong>Account Name: ' + response.StatementAccount.AccountName + '<br>'
                                                                + 'Account Code: ' + response.StatementAccount.UserCode + '<br>'
                                                                + 'Account Type: ' + response.StatementAccount.ParentAccName + '<br>'

                                                                 + '</strong></p>');
                            if (response.StatementAccount.MemberDetails != null) {
                                $('#divAccountInfo').append('<p><strong>MemberName: ' + response.StatementAccount.MemberDetails.FullNames + '<br>'
                                                                    + 'MemberNo: ' + response.StatementAccount.MemberDetails.MemberNo + '<br>'
                                                                    + 'PayrollNo: ' + response.StatementAccount.MemberDetails.PayrollNo + '<br>'
                                                                + 'IDNo: ' + response.StatementAccount.MemberDetails.IDNumber + '<br>'
                                                                 + '</strong></p>');
                            }

                            var lineitems = response.StatementItems;
                            var tbl_row = "";
                            var pdf_url = "<b><a href='" + global_site_root + "/Bank/BankSystem/GetBankStatementReport?DBName=" + $("#cboYear").val() + "&StartPeriod=" + $("#cboStartMonth").val() + "&EndPeriod=" + $("#cboEndMonth").val() + "&AccountNo=" + response.StatementAccount.UserCode + "'>PDF Report</a></b>";
                            $("#divPDF").html(pdf_url);
                            $.each(lineitems, function (index, lineitem) {
                                tbl_row += "<tr><td>" + lineitem.Trx + "</td><td>" + lineitem.Document_Date + "</td><td class='td_description'>" + lineitem.Description + "</td><td class='td_description'>" + lineitem.Document_no + "</td><td class='td_amount_col'>" + lineitem.Debit.formatMoney() + "</td><td class='td_amount_col'>" + lineitem.Credit.formatMoney() + "</td><td class='td_amount_col'>" + lineitem.RunBal.formatMoney() + "</td></tr>";
                            });

                            tbl_row += "<tr>";
                            tbl_row += "<td></td><td colspan=6><i>**************End of Statement***********</i></td>";
                            tbl_row += "</tr>";
                            $("#bdStatement").append(tbl_row);
                            $('#tblStatement tbody td:nth-child(1),th:nth-child(1)').hide();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                }
                function LoadBankStatementAccounts() {

                    $("#cboAccount").empty();
                    $("#cboAccount").append('<option selected>NO ACCOUNT</option>');

                    $('#divAccountInfo').html("");
                    $("#tblStatement > tbody:last").children().remove();
                    $("#tblTransactionDetails > tbody:last").children().remove();
                    $("#divPDF").html("PDF Report");
                    if ($("#txtSearchValue").val().trim() == "") { return; }
                    if ($("#txtSearchValue").val().trim() == AccountMask) { return; }

                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/GetBankStatementAccounts") %>",
                        data: JSON.stringify({'SearchBy': $("#cboSearchBy").val(), 'SearchValue': $("#txtSearchValue").val(), 'EmpCode': $("#cboEmployer").val() }),
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            var bankaccounts = response;
                            var obj = document.getElementById("cboAccount");
                            $("#cboAccount").empty();
                            $.each(bankaccounts, function (index, bankaccount) {
                                var opt = document.createElement("option");
                                opt.value = bankaccount.UserCode;
                                opt.text = "A/C: " + bankaccount.UserCode + " A/C Name: " + bankaccount.AccountName;
                                obj.appendChild(opt);
                            });
                            LoadBankStatement();
                        },
                        error: function (xhr, status, error) {

                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
            }

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                    ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                    c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                    $("#tabs").tabs();
            });
            $(function () {
                    $("#accordion").accordion();
            });
        });

    
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">

    <h3>Bank Statement</h3>

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <form id="frmBankStatement" name="frmBankStatement">
    <%= Html.AntiForgeryToken() %>
    <table border="1" style="padding: 1px; margin: 1px;">
        <tr>
            <td colspan="4"><b>Financial Period</b></td>
        </tr>
        <tr><td>Financial Year:</td><td colspan="3"><select id="cboYear"><option value="selectyear">SELECT YEAR</option></select></td></tr>
        <tr><td>Start Period:</td><td> <select id="cboStartMonth"><option value="selectstartperiod">Select Start Period</option></select></td><td>End Period:</td><td> <select id="cboEndMonth"><option value="selectEndperiod">Select End Period</option></select></td></tr>
        <tr><td>Search By:</td><td><select id="cboSearchBy">
                                        <option value="accountno" selected>AccountNo</option>
                                        <option value="memberno">MemberNo</option>
                                        <option value="idnumber">IDNo</option>
                                        <option value="payrollno">PayrollNo</option>
                                   </select>
            </td>
            <td>Employer:</td><td><select id="cboEmployer">
                                        <option value="selectemployer" selected>SELECT EMPLOYER</option>
                                   </select>
            </td>
        </tr>
        <tr>
            <td><div id="divSearchDisplay">Search Value</div></td><td><input type="text" id="txtSearchValue"" /></td>
            <td><input type="button" id="btnSelectAcc" value="Search"/>
        </tr>
        <tr><td></td><td><input type="button" id="btnGetAccounts" value="Get Statement"/><input type="button" id="btnPrint" value="Print Statement"/></td></tr>
        <tr><td>Select Account</td><td><select id="cboAccount"><option>SELECT ACCOUNT</option></select></td></tr>
        <tr><td><div id="divPDF">PDF Report</div></td></tr>
    </table>
    </form>
    
    <div id="divStatement">
        <div id="divAccountInfo"></div>
        <table id='tblStatement' class='display'>
                    <thead>
                        <tr>
                        <th style="text-align: left;padding:7px"><b>Date</b></th>
                        <th style="text-align: left;padding:7px"><b>Description</b></th>
                        <th style="text-align: left;padding:7px"><b>Doc No</b></th>
                        <th style="text-align: right;padding:7px"><b>Debit</b></th>
                        <th style="text-align: right;padding:7px"><b>Credit</b></th>
                        <th style="text-align: right;padding:7px"><b>Balance</b></th>
                        
                        </tr>
                    </thead>
                    <tbody id='bdStatement'>
                    </tbody>
                <tfoot>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
    </div>

    

</asp:Content>


