﻿var global_site_root = ""; //used to get refernce to virtual path app is running while in IIS. to be set on document ready of all masters


var AjaxGlobalHandler = {
    Initiate: function (options) {
        $.ajaxSetup({
            cache: false,
            error: function (xhr, status, err) {
                if (xhr.status == 401) {
                    alert("Session Expired. Redirecting to Login Page");
                    //window.location = '@(Html.Action("Login","Login",""))';
                    window.location = global_site_root + "/Login/Logout";
                }
            }
        });
        $(document).ajaxStart(
            function () {
                try {
                    $("#txtErrorMessage").val("");
                } catch (err) {

                }
                $("#loading").attr("style", "position:absolute; z-index: 1000; top: 0px; " +
                    "left:0px; text-align: center; display:none; background-color: #ddd; " +
                    "height: 100%; width: 100%; /* These three lines are for transparency " +
                    "in all browsers. */-ms-filter:\"progid:DXImageTransform.Microsoft.Alpha(Opacity=50)\";" +
                    " filter: alpha(opacity=50); opacity:.5;");
                $("#loading img").attr("style", "position:relative; top:40%; z-index:5;");
                $("#loading").show();
            }
        );
        $(document).ajaxComplete(function () {
            $("#loading").removeAttr("style");
            $("#loading img").removeAttr("style");
            $("#loading").hide();
        });
        $(document).ajaxStop(function () {
            $("#loading").removeAttr("style");
            $("#loading img").removeAttr("style");
            $("#loading").hide();
        });
    }
}
function getRootUrl() {
    //https://developer.mozilla.org/en-US/docs/Web/API/Location
    var rootUrl = window.location.origin ? window.location.origin + '/' : window.location.protocol + '/' + window.location.host + '/';
    //alert(rootUrl);
    return rootUrl;
}
function ConvertMoneyToDouble(moneyin) {
    //return parseFloat(moneyin.replace(",", "").replace(",", "").replace(",", "").replace(",", ""));
    //https://www.w3schools.com/jsref/jsref_replace.asp
    var moneyWithoutCommas = moneyin.replace(/,/g, ""); //global replace
    return parseFloat(moneyWithoutCommas);
}

function isNumber(n) {
    //return !isNaN(parseFloat(n)) && isFinite(n) && (n - parseFloat(n) >= 0);
    //var f = parseFloat("40 years") will return 40 as valid, var d = parseFloat("34 45 66") will return 34 as valid so check for spaces
    n = String(n);
    //n = parseFloat(n.replace(",", "").replace(",", "").replace(",", "").replace(",", ""))
    //https://www.w3schools.com/jsref/jsref_replace.asp
    n = n.replace(/,/g, "");//global replace
    n = String(n);
    if ((n.indexOf("e".toLowerCase()) < 0) && (n.indexOf("E".toUpperCase()) < 0) && (n.indexOf(" ") < 0)) { 
        return !isNaN(parseFloat(n, 10)) && isFinite(n) && (n - parseFloat(n) >= 0) && (n == (0 + (+n)));
    } else {
        return false;
    }

}


function getRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}
//Value parameter - required. All other parameters are optional.
function IsDate(value, sepVal, dayIdx, monthIdx, yearIdx) {
    try {
        //Change the below values to determine which format of date you wish to check. It is set to dd/mm/yyyy by default.
        var DayIndex = dayIdx !== undefined ? dayIdx : 0;
        var MonthIndex = monthIdx !== undefined ? monthIdx : 0;
        var YearIndex = yearIdx !== undefined ? yearIdx : 0;

        value = value.replace(/-/g, "/").replace(/\./g, "/");
        var SplitValue = value.split(sepVal || "/");
        var OK = true;
        if (!(SplitValue[DayIndex].length == 1 || SplitValue[DayIndex].length == 2)) {
            OK = false;
        }
        if (OK && !(SplitValue[MonthIndex].length == 1 || SplitValue[MonthIndex].length == 2)) {
            OK = false;
        }
        if (OK && SplitValue[YearIndex].length != 4) {
            OK = false;
        }
        if (OK) {
            var Day = parseInt(SplitValue[DayIndex], 10);
            var Month = parseInt(SplitValue[MonthIndex], 10);
            var Year = parseInt(SplitValue[YearIndex], 10);

            if (OK = ((Year > 1900) && (Year < new Date().getFullYear()))) {
                if (OK = (Month <= 12 && Month > 0)) {

                    var LeapYear = (((Year % 4) == 0) && ((Year % 100) != 0) || ((Year % 400) == 0));

                    if (OK = Day > 0) {
                        if (Month == 2) {
                            OK = LeapYear ? Day <= 29 : Day <= 28;
                        }
                        else {
                            if ((Month == 4) || (Month == 6) || (Month == 9) || (Month == 11)) {
                                OK = Day <= 30;
                            }
                            else {
                                OK = Day <= 31;
                            }
                        }
                    }
                }
            }
        }
        return OK;
    }
    catch (e) {
        return false;
    }
}
$(document).on('change', function () {
    $("#txtErrorMessage").val("");
    $('#txtErrorMessage').hide();
});
function DispUserError(strError) {
    //alert(strError);
    //see Ajx Global Setup on Start we're clearing existing error
    $("#txtErrorMessage").val("Last Error: " + strError);
    $("#txtErrorMessage").focus(); //move focues to view, but beware if user is typing and an error occurs and this function is called, user will not be able to type again coz focus will always be in this view
    if ($("#txtErrorMessage").val() != "") {
        setInterval(function () {
            $('#txtErrorMessage').fadeIn(300).fadeOut(500);
        }, 1000);
    }
}
// Original JavaScript code by Chirp Internet: www.chirp.com.au 
function IsValidDate(strDate) 
{ 
    var allowBlank = false; 
    var minYear = 1902; 
    var maxYear = (new Date()).getFullYear(); //NB: function will return false if year is more than current year. not good fo validating future dates. TODO: create a similar function IsValidFutureDate with custom maximum year value
    var errorMsg = ""; 
    // regular expression to match required date format 
    //re = /^(\d{1,2})\/(\d{1,2})\/(\d{4})$/;
    re = /^(\d{2})\/(\d{2})\/(\d{4})$/;
    if (strDate != '')
    {
        if (regs = strDate.match(re))
        {
            if (regs[1] < 1 || regs[1] > 31)
            {
                errorMsg = "Invalid value for day: " + regs[1];
            } else if (regs[2] < 1 || regs[2] > 12)
            {
                errorMsg = "Invalid value for month: " + regs[2];
            } else if (regs[3] < minYear || regs[3] > maxYear)
            {
                errorMsg = "Invalid value for year: " + regs[3] + " - must be between " + minYear + " and " + maxYear;
            }
        } else {
            errorMsg = "Invalid date format: " + strDate;
        }
    } else if (!allowBlank){
            errorMsg = "Empty date not allowed!";
    }
    if (errorMsg != "") {
        //alert(errorMsg);
        return false;
    }
    return true;
}

// Original JavaScript code by Chirp Internet: www.chirp.com.au 
function IsValidTime(field)
{ 
    var errorMsg = ""; 
    // regular expression to match required time format 
    re = /^(\d{1,2}):(\d{2})(:00)?([ap]m)?$/; 
    if(field.value != '')
    { 
        if(regs = field.value.match(re))
        { 
            if(regs[4])
            { 
                // 12-hour time format with am/pm 
                if(regs[1] < 1 || regs[1] > 12)
                { 
                    errorMsg = "Invalid value for hours: " + regs[1]; 
                } 
            } else { 
                // 24-hour time format if(regs[1] > 23) 
                { errorMsg = "Invalid value for hours: " + regs[1]; }
            } if (!errorMsg && regs[2] > 59) { errorMsg = "Invalid value for minutes: " + regs[2]; }
        } else { errorMsg = "Invalid time format: " + field.value; }
    } if (errorMsg != "") { alert(errorMsg); field.focus(); return false; } return true;
}

Number.prototype.formatMoney = function (decPlaces, thouSeparator, decSeparator) {
    var n = this,
        decPlaces = isNaN(decPlaces = Math.abs(decPlaces)) ? 2 : decPlaces,
        decSeparator = decSeparator == undefined ? "." : decSeparator,
        thouSeparator = thouSeparator == undefined ? "," : thouSeparator,
        sign = n < 0 ? "-" : "",
        i = parseInt(n = Math.abs(+n || 0).toFixed(decPlaces),10) + "",
        j = (j = i.length) > 3 ? j % 3 : 0;
    return sign + (j ? i.substr(0, j) + thouSeparator : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thouSeparator) + (decPlaces ? decSeparator + Math.abs(n - i).toFixed(decPlaces).slice(2) : "");
    //never change above parseInt to parseFloat, very wierd results will occur
};


function toTitleCase(str) { //convert str to camel case
    if (str == null) return "";
    str = str.toLowerCase();
    return str.replace(/(?:^|\s)\w/g, function (match) {
        return match.toUpperCase();
    });
}

function GetAmortizedLoanRepayment(LoanAmount,LoanInterestRatePerMonth,LoanRepaymentPeriodInMonths) {
    //to be called in try catch by called
    //https://www.oreilly.com/library/view/javascript-the-definitive/0596000480/ch01s08.html
    var rtnRepaymentAmount = 0;
    LoanInterestRatePerMonth = (LoanInterestRatePerMonth / 100);
    // Now compute the monthly payment figure, using esoteric math.
    var x = Math.pow(1 + LoanInterestRatePerMonth, LoanRepaymentPeriodInMonths);
    var monthly = (LoanAmount * x * LoanInterestRatePerMonth) / (x - 1);
    // Check that the result is a finite number. If so, display the results.
    if (!isNaN(monthly) &&
        (monthly != Number.POSITIVE_INFINITY) &&
        (monthly != Number.NEGATIVE_INFINITY)) {

        rtnRepaymentAmount = round(monthly);
         
        //TotalPayments = round(monthly * LoanRepaymentPeriodInMonths);
        //TotalInterest = round(TotalPayments - LoanAmount);

    }
    // Otherwise, the user's input was probably invalid
    return rtnRepaymentAmount;
}
function GetNonAmortizedLoanRepayment(LoanAmount, LoanInterestRatePerMonth, LoanRepaymentPeriodInMonths) {
    //to be called in try catch by called
    var rtnRepaymentAmount = 0;
    LoanInterestRatePerMonth = (LoanInterestRatePerMonth / 100);
    rtnRepaymentAmount = (LoanAmount / LoanRepaymentPeriodInMonths) + (LoanAmount * (LoanInterestRatePerMonth));
    rtnRepaymentAmount = round(rtnRepaymentAmount);
    return rtnRepaymentAmount; 
}

// This simple method rounds a number to two decimal places.
function round(x) {
    return Math.round(x * 100) / 100;
}
function DisplayTellerWithdrawalSlip(divtarget, slipdata, sendToPrinter) {
    try {
        //to add narration and ATP No
        var strReportSlip ="";
        strReportSlip +="<div class='table-responsive'><table id='tblWithdrawalSlip' class='table table-responsive'>";
        strReportSlip +="<tbody id='bdWithdrawalSlip'>";
        strReportSlip +="<tr>";
        strReportSlip += "<td colspan='2' style='text-align:center;font:  18px arial,Times New Roman'>" + slipdata.SlipSummary.CompanyName + "</td>";
        strReportSlip +="</tr>";
        strReportSlip +="<tr>";
        strReportSlip += "   <td colspan='2' style='text-align:center;font:  16px arial,Times New Roman'>" + slipdata.SlipSummary.CompanyAddress + "</td>";
        strReportSlip +="</tr>";
        strReportSlip +="<tr>";
        strReportSlip += "   <td colspan='2' style='text-align:center;font: bold 14px arial,Times New Roman'>" + slipdata.SlipSummary.ReportTitle + "</td>";
        strReportSlip +="</tr>";
        strReportSlip += "<tr><td colspan ='2'><hr style='color:black' /></td></tr>";
        strReportSlip += "<tr>";
        strReportSlip += "   <td>Doc. No: " + slipdata.SlipSummary.DocNo + "</td>";
        strReportSlip += "   <td></td>";
        strReportSlip += "</tr>";
        strReportSlip +="<tr>";
        strReportSlip += "   <td>Print Date: " + slipdata.SlipSummary.ReportDate + "</td>";
        strReportSlip += "   <td>Branch: " + slipdata.SlipSummary.BranchName + "(" + slipdata.SlipSummary.BranchCode + ")</td>";
        strReportSlip +="</tr>";
        strReportSlip +="<tr>";
        strReportSlip += "   <td>Transaction Date: " + slipdata.SlipSummary.DocDate + "</td><td>Transaction Time: " + slipdata.SlipSummary.DocTime + "</td>";
        strReportSlip +="</tr>";
        strReportSlip +="<tr>";
        strReportSlip += "    <td>Account No: " + slipdata.SlipSummary.AccountNo + "</td><td>Account Name: " + slipdata.SlipSummary.AccountName + "</td>";
        strReportSlip +="</tr>";
        strReportSlip +="<tr>";
        strReportSlip += "   <td>Member No: " + slipdata.SlipSummary.MemberNo + "</td><td>Name: " + slipdata.SlipSummary.MemberNames + "</td>";
        strReportSlip +="</tr>";
        strReportSlip +="<tr>";
        strReportSlip += "  <td>PayrollNo No: " + slipdata.SlipSummary.PayrollNo + "</td><td>ID Number: " + slipdata.SlipSummary.IDNumber + "</td>";
        strReportSlip +="</tr>";
        strReportSlip +="<tr>";
        strReportSlip +="   <td style='width:400px;padding-top:7px'><u>Description</u></td><td style='text-align:right;padding-top:7px'><u>Amount (Ksh)</u></td>";
        strReportSlip +="</tr>";
        strReportSlip += "<tr><td colspan ='2'><hr style='color:black' /></td></tr>";

        $.each(slipdata.TransactionChargeDetail, function (index, tDetails) {
            strReportSlip += "<tr>";
            strReportSlip += "   <td>" + tDetails.Description + "</td><td style='text-align:right;padding-right:7px'>" + tDetails.Amount.formatMoney(2, ',', '.') + "</td>";
            strReportSlip += "</tr>";
        });

        strReportSlip +="<tr><td colspan ='2'><hr style='color:black' /></td></tr>";
        strReportSlip +="<tr>";
        strReportSlip += "   <td>Totals</td><td style='text-align:right;padding-right:7px'>" + slipdata.SlipSummary.TotalAmount.formatMoney(2, ',', '.') + "</td>";
        strReportSlip +="</tr>";
        strReportSlip +="<tr><td colspan ='2'><hr style='color:black' /></td></tr>";
        strReportSlip +="<tr>";
        strReportSlip +="   <td style='padding-top:7px'>Customer Signature</td><td style='padding-top:7px'>......................................</td>";
        strReportSlip +="</tr>";
        strReportSlip +="<tr>";
        strReportSlip += "   <td style='padding-top:7px'>Served By Teller, " + slipdata.SlipSummary.TellerName + " (" + slipdata.SlipSummary.TellerAccount + ") Signature & Stamp</td><td style='padding-top:7px'>.......................................</td>";
        strReportSlip +="</tbody>";
        strReportSlip +="</table></div>";

        divtarget.html(strReportSlip);
        if (sendToPrinter) {
            $("#btnPrint").trigger('click');
        }
    }catch(disp_error){
        alert("An error has occured while generating withdrawal slip report(js). " + disp_error);
    }
}


function LoadFinancialPeriods(cboTarget,dbname,urlmonths) {//see usage in TellerCashTransactions
        if (!dbname) { return; }
        cboTarget.empty();
        var csrfToken = $("input[name='__RequestVerificationToken']").val();
        $.ajax({
            headers: { __RequestVerificationToken: csrfToken },
            type: "POST",
            url: urlmonths,
            data: JSON.stringify({ 'DBName': dbname }),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (response) {
                var fmonths = response;
                $.each(fmonths, function (index, fmonth) {
                    cboTarget.append("<option value='" + fmonth.MonthID + "'>" + fmonth.MonthName + "</option'>");
                    if (fmonth.Status == "OPENED") {
                        cboTarget.prop("selectedIndex", index);
                    }
                });
        },
        error: function (xhr, status, error) {
            var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
        }
    });
}
function LoadFinancialYears(cboTarget, url) {
    cboTarget.empty();
    var csrfToken = $("input[name='__RequestVerificationToken']").val();
    $.ajax({
        headers: { __RequestVerificationToken: csrfToken },
        type: "POST",
        url: url,
        data: '{}',
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
            $.each(response, function (index, yr) {
                cboTarget.append("<option value='" + yr.DBName + "'>" + yr.UserDefinedYearName + "</option'>");
                //cboTarget.prop("selectedIndex", index);
            });
        },
        error: function (xhr, status, error) {
            var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
        }
    });
}

function ShowBOSAStatement(strmem_id){
    var BOSAStatement_URL = global_site_root + "/Bank/BankSystem/BosaStatementDlg";
    if (strmem_id) {if(strmem_id!=""){ BOSAStatement_URL += "?MemID=" + strmem_id; }}
    $("#divStatementDlg").dialog({
        autoOpen: false,
        show: "fade",
        hide: "fade",
        modal: true,
        open: function (ev, ui) {
            $('#ifStatementDlg').attr('src', BOSAStatement_URL);
        },
        height: 700,
        width: 1200,
        resizable: true,
        title: 'BOSA Statement',
        close: function () {
            $('#ifStatementDlg').attr("src", "");
        }
    });
    $('#divStatementDlg').dialog('open');
}
function ShowBankStatement(str_statement_account_no) {
    var BankStatement_URL = global_site_root + "/Bank/BankSystem/BankStatementDlg";
    if (str_statement_account_no) { if (str_statement_account_no != "") { BankStatement_URL += "?AccountNo=" + str_statement_account_no; } }
    $("#divStatementDlg").dialog({
        autoOpen: false,
        show: "fade",
        hide: "fade",
        modal: true,
        open: function (ev, ui) {
            $('#ifStatementDlg').attr('src', BankStatement_URL);
        },
        height: 700,
        width: 1200,
        resizable: true,
        title: 'Bank Statement',
        close: function () {
            $('#ifStatementDlg').attr("src", "");
        }
    });
    $('#divStatementDlg').dialog('open');
}

function IsNumeric(value) {
    //https://stackoverflow.com/questions/20169217/how-to-write-isnumber-in-javascript
    return typeof value === 'number' && isFinite(value);
}
function xDialogConfirm(message, title, okButtonText, cancelButtonText) {
    okButtonText = okButtonText || "Yes";
    cancelButtonText = cancelButtonText || "No";
    title = title || "Confirm...";

    var deferred = Q.defer();  //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
    $('<div class="col-md-4" title="' + title + '">' + message + '</div>').dialog({
        modal: true,
        height: 242.4,
        width: Math.min(500, $(window).width() * .8), /*https://stackoverflow.com/questions/16471890/responsive-jquery-ui-dialog-and-a-fix-for-maxwidth-bug see answer - Not responsive in the sense that if the width is narrowed the dialog shrinks, but responsive in the sense that on a specific device, the dialog will not be too wide.*/
        buttons: {
            // The OK button
            'OK': {
                text: okButtonText,
                'class': 'btn btn-primary',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                click: function () {
                    // Resolve the promise as true indicating the user clicked "OK"
                    deferred.resolve(true);
                    $(this).dialog("close");
                }
            },
            // The Cancel button
            'Cancel': {
                text: cancelButtonText,
                'class': 'btn btn-danger',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                click: function () {
                    $(this).dialog("close");
                }
            }
            
        }            ,
        close: function (event, ui) {
            // Destroy the jQuery UI dialog and remove it from the DOM
            $(this).dialog("destroy").remove();

            // If the promise has not yet been resolved (eg the user clicked the close icon) 
            // then resolve the promise as false indicating the user did *not* click "OK"
            if (deferred.promise.isPending()) {
                deferred.reject();
            }
        }
    });

    return deferred.promise;
}
    function xDialogInput(message) {
        var deferred =  Q.defer(); //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
        var $input = $("<input type='text' />");
        $("<div />").text(message).append($input).dialog({
            buttons: {
                OK: function () {
                    deferred.resolve($input.val());
                    $(this).dialog("close");
                },
                Cancel: function () {
                    $(this).dialog("close");
                    deferred.reject();
                }
            },
            close: function (event, ui) {
                // Destroy the jQuery UI dialog and remove it from the DOM
                $(this).dialog("destroy").remove();

                // If the promise has not yet been resolved (eg the user clicked the close icon) 
                // then resolve the promise as false indicating the user did *not* click "OK"
                if (deferred.promise.isPending()) {
                    deferred.reject();
                }
            }
        });

        return deferred.promise;
    }
    function xDialogGetOtherUserCredetials(message,username) {
        var deferred = Q.defer(); //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
        $('<div></div>').dialog({
            modal: true,
            title: message,
            height: 270,
            width: 500,
            autoOpen: true,
            show: {
                effect: "drop",
                direction: "up",
                duration: 500
            },

            buttons: {
                'OK': {
                    'text': 'OK',
                    'id': 'btnOKPass',
                    'class': 'btn btn-primary',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                    'click': function () {
                        if ($("#txtPassword").val().trim() == "") {
                            alert("Enter Password", "Password Required");
                            return;
                        } else {
                            var UserCredetials = { 'UserName': $("#txtUserName").val(), 'UserPass': $("#txtPassword").val() };
                            deferred.resolve(UserCredetials);
                            $(this).dialog("close");
                        }
                    }
                },
                'Cancel': {
                    text: "Cancel",
                    'class': 'btn btn-danger',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                    click: function () {
                        $(this).dialog("close");
                        deferred.reject();
                    }
                }
                
            },
            open: function () {
                var tbl = "<div><class id='tblPassword'>";
                tbl += "<div class='col-md-4'>";
                tbl += "<label class='form-label'>User Name:</label>";
                if (username != "") {
                    tbl += "<input type='text' id='txtUserName' class='form-control' value='" + username + "' disabled />";
                } else {
                    tbl += "<input type='text' id='txtUserName' class='form-control' value='" + username + "'/>";
                }
                tbl += "</div>";
                tbl += "<div class='col-md-4'><label class='form-label'>Password:</label>";
                tbl += "<input id='txtPassword' type='password' class='form-control'/>";
                tbl += "</div>";
                tbl += "</div></div></div>";
                $(this).html(tbl);



                if (username = !"") { $("#txtUserName").focus; }
                else { $("#txtPassword").focus(); }
                setTimeout(function () {
                    $('#txtPassword').val('');
                }, 1000);
            },
            close: function (event, ui) {
                // Destroy the jQuery UI dialog and remove it from the DOM
                $(this).dialog("destroy").remove();

                // If the promise has not yet been resolved (eg the user clicked the close icon) 
                // then resolve the promise as false indicating the user did *not* click "OK"
                if (deferred.promise.isPending()) {
                    deferred.reject();
                }
            }
        });
        $("#txtPassword").on("keyup", function (e) {
            var kcode = (e.keyCode ? e.keyCode : e.which);
            if (kcode == $.ui.keyCode.ENTER) {
                $("#btnOKPass").trigger("click");
            }
            e.stopPropagation();
        });
        return deferred.promise;
    }

    

    function xDialogGetUserCredetials() {
        var deferred = Q.defer(); //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
        $('<div></div>').dialog({
            modal: true,
            title: "User Authentication",
            height: 270,
            width: 500,
            autoOpen: true,
            show: {
                effect: "drop",
                direction: "up",
                duration: 500
            },

            buttons: {
                'OK': {
                    'text': 'OK',
                    'id': 'btnOKPass',
                    'class': 'btn btn-primary',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                    'click': function () {
                        if ($("#txtPassword").val().trim() == "") {
                            alert("Enter Password", "Password Required");
                            return;
                        } else {
                            var UserCredetials = { 'UserName': $("#divUserName").html(), 'UserPass': $("#txtPassword").val() };
                            deferred.resolve(UserCredetials);
                            $(this).dialog("close");
                        }
                    }
                },
                'Cancel': {
                    'text': 'Cancel',
                    'id': 'btnCancelGetUserCredentials',
                    'class': 'btn btn-danger',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                    'click': function () {
                        $(this).dialog("close");
                        deferred.reject();
                    }
                }

            },
            open: function () {
                var tbl = "<div><div id='tblPassword' >";
                tbl += "";
                tbl += "<div class='col-md'><label class='form-label'>User Name:</label>";
                tbl += "<div id='divUserName' class='form-control'>" + strLoginUserName + "</div>";
                tbl += "</div>";
                tbl += "<div class='col-md'><label class='form-label'>Password:</label>";
                tbl += "<input id='txtPassword' type='password' autocomplete = 'off' , value = '  ' class='form-control'/></div>"; //TODO: most browsers auto complete regardless of instructions!!! get a worka round!!!
                tbl += "";
                tbl += "</div></div>";
                $(this).html(tbl);
                $("#txtPassword").focus();
                setTimeout(function () {
                    $('#txtPassword').val('');
                }, 1000);

            },
            close: function (event, ui) {
                // Destroy the jQuery UI dialog and remove it from the DOM
                $(this).dialog("destroy").remove();

                // If the promise has not yet been resolved (eg the user clicked the close icon) 
                // then resolve the promise as false indicating the user did *not* click "OK"
                if (deferred.promise.isPending()) {
                    deferred.reject();
                }
            }
        });
        $("#txtPassword").on("keyup", function (e) {
            var kcode = (e.keyCode ? e.keyCode : e.which);
            if (kcode == $.ui.keyCode.ENTER) {
                $("#btnOKPass").trigger("click");
            }
            e.stopPropagation();
        });
        return deferred.promise;
    }

    function xDialogMemberCredetials() {
        var deferred = Q.defer(); //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
        $('<div></div>').dialog({
            modal: true,
            title: "Enter Password",
            height: 270,
            width: 270,
            autoOpen: true,
            show: {
                effect: "drop",
                direction: "up",
                duration: 500
            },

            buttons: {
                'OK': {
                    'text': 'OK',
                    'id': 'btnOKPass',
                    'class':'btn btn-success',
                    'click': function () {
                        if ($("#txtPassword").val().trim() == "") {
                            alert("Enter Password", "Password Required");
                            return;
                        } else {
                            var UserCredetials = {'UserPass': $("#txtPassword").val() };
                            deferred.resolve(UserCredetials);
                            $(this).dialog("close");
                        }
                    }
                },
                'Cancel': {
                    'text':'Cancel',
                    'class':'btn btn-danger',
                    'click': function () {
                    $(this).dialog("close");
                    deferred.reject();
                }}

            },
            open: function () {
                var tbl = "<div><div id='tblPassword' class='row'>";
                tbl += "";
                
                tbl += "<div class='col-md'><label class='form-label'>Password:</label>";
                tbl += "<input id='txtPassword' type='password' class='form-control'/></div>";
                tbl += "";
                tbl += "</div></div>";
                $(this).html(tbl);
                $("#txtPassword").focus();

            },
            close: function (event, ui) {
                // Destroy the jQuery UI dialog and remove it from the DOM
                $(this).dialog("destroy").remove();

                // If the promise has not yet been resolved (eg the user clicked the close icon) 
                // then resolve the promise as false indicating the user did *not* click "OK"
                if (deferred.promise.isPending()) {
                    deferred.reject();
                }
            }
        });
        $("#txtPassword").on("keyup", function (e) {
            var kcode = (e.keyCode ? e.keyCode : e.which);
            if (kcode == $.ui.keyCode.ENTER) {
                $("#btnOKPass").trigger("click");
            }
            e.stopPropagation();
        });
        return deferred.promise;
    }

function xDialogGetMemberAuthorizationCode() {
    var deferred = Q.defer(); //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
    $('<div></div>').dialog({
        modal: true,
        title: "Enter Authorization Code(OTP)",
        height: 'auto',
        width: 'auto',
        autoOpen: true,
        show: {
            effect: "drop",
            direction: "up",
            duration: 500
        },

        buttons: {
            'OK': {
                'text': 'OK',
                'id': 'btnOKPass',
                'click': function () {
                    if ($("#txtAuthCode").val().trim() == "") {
                        alert("Enter Authorization Code", "Authorization Code Required");
                        return;
                    } else {
                        var UserCredetials = { 'AuthCode': $("#txtAuthCode").val() };
                        deferred.resolve(UserCredetials);
                        $(this).dialog("close");
                    }
                }
            },
            Cancel: function () {
                $(this).dialog("close");
                deferred.reject();
            }

        },
        open: function () {
            var tbl = "<p>Transaction authorization Code has been sent to your phone/email</p><br/><div><div id='tblPassword' class='row'>";
            tbl += "";
            tbl += "<div class='col-md-4'><label class='form-label'>Authorization Code:</label>";
            tbl += "<input id='txtAuthCode' type='password' class='form-control'/>";
            tbl += "";
            tbl += "</div></div>";
            $(this).html(tbl);
            $("#txtAuthCode").focus(); 


            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: global_site_root + '/api/MembersSystemApi/RequestTransactionAuthCode',
                data: JSON.stringify({ 'EmployerCode': "", 'PayrollNo': "" }),
                contentType: "application/json; charset=utf-8",
                dataType: "json"
            }).success(function (row_datas) {
                //alert("Auth Code request was successful")
            }).error(function (xhr, status, error) {
                var errorMessage = xhr.status + ': ' + xhr.responseText;
                alert('Error Failed to request Auth Code - ' + errorMessage);
            });

        },
        close: function (event, ui) {
            // Destroy the jQuery UI dialog and remove it from the DOM
            $(this).dialog("destroy").remove();

            // If the promise has not yet been resolved (eg the user clicked the close icon) 
            // then resolve the promise as false indicating the user did *not* click "OK"
            if (deferred.promise.isPending()) {
                deferred.reject();
            }
        }
    });
    $("#txtAuthCode").on("keyup", function (e) {
        var kcode = (e.keyCode ? e.keyCode : e.which);
        if (kcode == $.ui.keyCode.ENTER) {
            $("#btnOKAuth").trigger("click");
        }
        e.stopPropagation();
    });
    return deferred.promise;
}

//**********************SEARCH MEMBER RECORD ****************************

    function xDialogSearchMemberRecord(AccountSearchMask) {

        var deferred = Q.defer(); //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
        $('<div></div>').dialog({
            modal: true,
            title: "Search Member Record",
            height: 400,
            width: 1000,
            autoOpen: true,
            show: {
                effect: "drop",
                direction: "up",
                duration: 500
            },

            buttons: {
                'Cancel': {
                    'text': 'Cancel',
                    'id': 'btnCancelSearch',
                    'class': 'btn btn-danger',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                    'click' : function () {
                        $(this).dialog("close");
                        deferred.reject();
                    }
                },
                'Select': {
                    'text': 'Select',
                    'id': 'btnSelect',
                    'click': function () {
                        var search_selected_row = $("#tblSearchResults tr.selected");
                        if (search_selected_row.find('td:eq(0)').text().toString().trim() == "") {
                            alert("Nothing Selected");
                            return;
                        }
                        var SelectedMemberRecord =
                            {
                                'EmployerCode': search_selected_row.find('td:eq(0)').text(),
                                'PayrollNo': search_selected_row.find('td:eq(1)').text(),
                                'MemberNo': search_selected_row.find('td:eq(2)').text(),
                                'IDNumber': search_selected_row.find('td:eq(3)').text(),
                                'MemberNames': search_selected_row.find('td:eq(4)').text(),
                                'AccountNo': search_selected_row.find('td:eq(5)').text()
                            };
                        deferred.resolve(SelectedMemberRecord);
                        $(this).dialog("close");
                    }
                },
                'Search': {
                    'text': 'Search',
                    'id': 'btnSearchMemberRecord',
                    'click': function () {
                        DBSearchMemberRecord();
                    }
                }
            },
            open: function () {
                var tbl = "";
                tbl += "<div class='table-responsive'><table id='tblSearchCriteria' class='table table-responsive'>";
                tbl += "<tr><td>Search By:</td><td>";
                tbl += "<select id='cboMemberSearchBy'>"
                tbl += "<option value='membernames' >Member Name</option>";
                tbl += "<option value='accountno' >Account No</option>";
                tbl += "<option value='memberno' selected >Member No</option>";
                tbl += "<option value='payrollno' >Payroll No</option>";
                tbl += "<option value='idnumber' >ID Number</option>";
                tbl += "<option value='phoneno' >Phone No</option>";
                tbl += "</select>";
                tbl += "</td></tr>";
                tbl += "<tr><td><div id='divMemberSearchValue'>Member No:</div></td><td>";
                tbl += "<input type='text' id='txtMemberSearchValue' />"
                tbl += "</td></tr>";
                tbl += "</table></div>";
                tbl += "<hr/>";
                tbl += "<div class='table-responsive'><table id='tblSearchResults' border=1 class='table table-responsive'>";
                tbl += "<thead>";
                tbl += "<tr>"
                tbl += "<th>EmpCode</th>";
                tbl += "<th>PayrollNo</th>";
                tbl += "<th>MemberNo</th>";
                tbl += "<th>IDNo</th>";
                tbl += "<th>Names</th>";
                tbl += "<th>AccountNo</th>";
                tbl += "</tr>";
                tbl += "</thead>";
                tbl += "<tbody id='bdSearchResults'>";
                tbl += "</tbody>";
                tbl += "    <tfoot>";
                tbl += "        <tr>";
                tbl += "            <td></td>";
                tbl += "            <td></td>";
                tbl += "            <td></td>";
                tbl += "            <td></td>";
                tbl += "            <td></td>";
                tbl += "            <td></td>";
                tbl += "        </tr>";
                tbl += "    </tfoot>";
                tbl += "   </table></div>";
                $(this).html(tbl);

                $("#txtMemberSearchValue").focus();

                var tblAcc = $("#tblSearchResults").dataTable({
                    bJQueryUI: false,
                    sPaginationType: "full_numbers",
                    sScorollX: "900px",
                    sScrollY: "900px",
                    bScrollInfinite: true, //this property disables pagination
                    bDestroy: true,
                    paging: false,
                    ordering: false,
                    info: false,
                    searching: false
                });

                $("#txtMemberSearchValue").focus();
                $('#tblSearchResults tbody').on('click', 'tr', function () {
                    $('#tblSearchResults tbody tr').removeClass('selected');
                    $(this).addClass('selected');
                });

                $('#tblSearchResults tr').click(function () {
                    $(this).find('td input:radio').prop('checked', true);
                })

            },
            close: function (event, ui) {
                // Destroy the jQuery UI dialog and remove it from the DOM
                $(this).dialog("destroy").remove();
                // If the promise has not yet been resolved (eg the user clicked the close icon) 
                // then resolve the promise as false indicating the user did *not* click "OK"
                if (deferred.promise.isPending()) {
                    deferred.reject();
                }
            }
        });
        $("#cboMemberSearchBy").on("keyup", function (e) {
            var kcode = (e.keyCode ? e.keyCode : e.which);
            if (kcode == $.ui.keyCode.ENTER) {
                $("#txtMemberSearchValue").focus();
            }
            e.stopPropagation();
        });
        
        $("#cboMemberSearchBy").on("change", function (e) {
            $("#divMemberSearchValue").html($("#cboMemberSearchBy option:selected").text());
            $("#txtMemberSearchValue").unmask();
            if ($("#cboMemberSearchBy option:selected").index() == 1) {
                if (AccountSearchMask != null) {
                    $("#txtMemberSearchValue").mask(AccountSearchMask);
                }
            }

            e.stopPropagation();
        });
        $("#txtMemberSearchValue").on('focusout', function (e) {
            $("#tblSearchResults > tbody:last").children().remove();
            if ($("#txtMemberSearchValue").val().trim() != "") {
                DBSearchMemberRecord();
            }
            e.stopPropagation();
        })
        return deferred.promise;

        function DBSearchMemberRecord() {
            if ($("#txtMemberSearchValue").val().trim() == "") {
                return;
            }
            if ($("#txtMemberSearchValue").val().trim() == "") {
                return;
            }
            if ($("#cboMemberSearchBy option:selected").index() == 1) { //account no
                if ($("#txtMemberSearchValue").val().indexOf("_") > -1) { //reseaRch on jquery.maskedinput to test if user has entered some text
                    return;
                }
            }
            if ($("#txtMemberSearchValue").val().trim().length < 3) {
                return;
            }
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: global_site_root + '/api/BankSystemApi/SearchMemberRecord',
                data: JSON.stringify({ 'SearchBy': $("#cboMemberSearchBy").val(), 'SearchValue': $("#txtMemberSearchValue").val().toString() }),
                contentType: "application/json; charset=utf-8",
                dataType: "json"
            }).success(function (row_datas) {
                var tbl_row ="";
                $.each(row_datas, function (index, row_data) {
                    tbl_row += "<tr>";
                    tbl_row += "<td>" + row_data.EmployerCode + "</td>";
                    tbl_row += "<td>" + row_data.PayrollNo + "</td>";
                    tbl_row += "<td>" + row_data.MemberNo + "</td>";
                    tbl_row += "<td>" + row_data.IDNumber + "</td>";
                    tbl_row += "<td>" + row_data.MemberNames + "</td>";
                    tbl_row += "<td>" + row_data.AccountNo + "</td>";
                    tbl_row += "</tr>";
                    
                });
                $("#bdSearchResults").append(tbl_row);
            }).error(function (xhr, status, error) {
                var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
            });
        }
    }

//**********************END SEARCH MEMBER RECORD************************

    //**********************SEARCH CUSTOMER ACCOUNT****************************

    function xDialogSearchCustomerAccount(AccountSearchMask) {
        var deferred = Q.defer(); //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
        $('<div></div>').dialog({
            modal: true,
            title: "Search Customer A/C",
            height: 400,
            width: 1000,
            autoOpen: true,
            show: {
                effect: "drop",
                direction: "up",
                duration: 500
            },

            buttons: {
                'Cancel': {
                    'text': 'Cancel',
                    'id': 'btnCancelSearch',
                    'click': function () {
                        $(this).dialog("close");
                        deferred.reject();
                    }
                },
                'Select': {
                    'text': 'Select',
                    'id': 'btnSelect',
                    'click': function () {
                        var search_selected_row = $("#tblSearchResults tr.selected");
                        if (search_selected_row.find('td:eq(0)').text().toString().trim() == "") {
                            alert("Nothing Selected");
                            return;
                        }
                        var SelectedAccount =
                            {
                                'AccountNo': search_selected_row.find('td:eq(0)').text(),
                                'AccountName': search_selected_row.find('td:eq(1)').text(),
                                'IDNumber': search_selected_row.find('td:eq(2)').text(),
                                'MemberNo': search_selected_row.find('td:eq(3)').text(),
                                'EmployerCode': search_selected_row.find('td:eq(4)').text(),
                                'PayrollNo': search_selected_row.find('td:eq(5)').text()
                            };
                        deferred.resolve(SelectedAccount);
                        $(this).dialog("close");
                    }
                },
                'Search': {
                    'text': 'Search',
                    'id': 'btnSearchCustomerAcc',
                    'click': function () {
                        DBSearchCustomerAccount();
                    }
                }
            },
            open: function () {
                var tbl = "";
                tbl += "<div class='table-responsive'><table id='tblSearchCriteria' class='table table-responsive'>";
                tbl += "<tr><td>Search By:</td><td>";
                tbl += "<select id='cboCustSearchBy'>"
                tbl += "<option value='accountno' selected>Account No</option>";
                tbl += "<option value='memberno' >Member No</option>";
                tbl += "<option value='payrollno' >Payroll No</option>";
                tbl += "<option value='idnumber' >ID Number</option>";
                tbl += "<option value='accountname' >Account Name</option>";
                tbl += "<option value='atmcardno' >ATM Card No</option>";
                tbl += "<option value='phoneno' >Phone No</option>";
                tbl += "</select>";
                tbl += "</td></tr>";
                tbl += "<tr><td><div id='divCustSearchValue'>Account No:</div></td><td>";
                tbl += "<input type='text' id='txtCustSearchValue' autofocus />"
                tbl += "</td></tr>";
                tbl += "</table></div>";
                tbl += "<hr/>";
                tbl += "<div class='table-responsive'><table id='tblSearchResults' border=1 class='table table-responsive'>";
                tbl += "<thead>";
                tbl += "<tr>"
                tbl += "<th>A/C No</th>";
                tbl += "<th>A/C Name</th>";
                tbl += "<th>IDNo</th>";
                tbl += "<th>MemberNo</th>";
                tbl += "<th>EmpCode</th>";
                tbl += "<th>PayrollNo</th>";
                tbl += "</tr>";
                tbl += "</thead>";
                tbl += "<tbody id='bdSearchResults'>";
                tbl += "</tbody>";
                tbl += "    <tfoot>";
                tbl += "        <tr>";
                tbl += "            <td></td>";
                tbl += "            <td></td>";
                tbl += "            <td></td>";
                tbl += "            <td></td>";
                tbl += "            <td></td>";
                tbl += "            <td></td>";
                tbl += "        </tr>";
                tbl += "    </tfoot>";
                tbl += "   </table></div>";
                $(this).html(tbl);

                
                var tblAcc = $("#tblSearchResults").dataTable({
                    bJQueryUI: false,
                    sPaginationType: "full_numbers",
                    sScorollX: "900px",
                    sScrollY: "900px",
                    bScrollInfinite: true, //this property disables pagination
                    bDestroy: true,
                    paging: false,
                    ordering: false,
                    info: false,
                    searching: false
                });
                
                
                
                $('#tblSearchResults tbody').on('click', 'tr', function () {
                    $('#tblSearchResults tbody tr').removeClass('selected');
                    $(this).addClass('selected');
                });

                $('#tblSearchResults tr').click(function () {
                    $(this).find('td input:radio').prop('checked', true);
                })

            },
            close: function (event, ui) {
                // Destroy the jQuery UI dialog and remove it from the DOM
                $(this).dialog("destroy").remove();
                // If the promise has not yet been resolved (eg the user clicked the close icon) 
                // then resolve the promise as false indicating the user did *not* click "OK"
                if (deferred.promise.isPending()) {
                    deferred.reject();
                }
            }
        });
        
        $("#cboCustSearchBy").on("keyup", function (e) {
            var kcode = (e.keyCode ? e.keyCode : e.which);
            if (kcode == $.ui.keyCode.ENTER) {
                $("#txtCustSearchValue").focus();
            }
            e.stopPropagation();
        });

        $("#cboCustSearchBy").on("change", function (e) {
            $("#txtCustSearchValue").unmask();
            $("#divCustSearchValue").html($("#cboCustSearchBy option:selected").text());
            if ($("#cboCustSearchBy option:selected").index() == 0) {
                if (AccountSearchMask != null) {
                    $("#txtCustSearchValue").mask(AccountSearchMask);
                }
            }
            e.stopPropagation();
        });
        $("#txtCustSearchValue").focus();
        $("#cboCustSearchBy").trigger('change');

        $("#txtCustSearchValue").on('focusout', function (e) {
            $("#tblSearchResults > tbody:last").children().remove();
            if ($("#txtCustSearchValue").val().trim() != "") {
                DBSearchCustomerAccount();
            }
            e.stopPropagation();
        })
        return deferred.promise;

        function DBSearchCustomerAccount() {
            if ($("#txtCustSearchValue").val().trim() == "") {
                return;
            }
            if ($("#cboCustSearchBy option:selected").index() == 0) { //account no
                if ($("#txtCustSearchValue").val().indexOf("_") > -1) { //reseaRch on jquery.maskedinput to test if user has entered some text
                    return;
                }
            }
            if ($("#txtCustSearchValue").val().trim().length < 3) {
                return;
            }
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: global_site_root + '/api/BankSystemApi/SearchCustomerAccount',
                data: JSON.stringify({ 'SearchBy': $("#cboCustSearchBy").val(), 'SearchValue': $("#txtCustSearchValue").val().toString() }),
                contentType: "application/json; charset=utf-8",
                dataType: "json"
            }).success(function (row_datas) {
                var tbl_row = "";
                $.each(row_datas, function (index, row_data) {
                    tbl_row += "<tr>";
                    tbl_row += "<td>" + row_data.AccountNo + "</td>";
                    tbl_row += "<td>" + row_data.AccountName + "</td>";
                    tbl_row += "<td>" + row_data.IDNumber + "</td>";
                    tbl_row += "<td>" + row_data.MemberNo + "</td>";
                    tbl_row += "<td>" + row_data.EmployerCode + "</td>";
                    tbl_row += "<td>" + row_data.PayrollNo + "</td>";
                    tbl_row += "</tr>";

                });
                $("#bdSearchResults").append(tbl_row);
            }).error(function (xhr, status, error) {
                var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
            });
        }
    }

    //**********************END SEARCH CUSTOMER ACCOUNT ************************



//**********************SEARCH SASRA LOAN PURPOSE****************************

function xDialogSearchLoanPurpose(subSector2List) {
  var deferred = Q.defer();

  // Create container
  var $container = $('<div class="xdlg-dropdown" style="position:fixed;right:20px;top:80px;z-index:9999;width:360px;max-width:95%;background:#fff;border:1px solid #ccc;border-radius:6px;box-shadow:0 6px 24px rgba(0,0,0,.12);padding:12px;font-family:Arial,Helvetica,sans-serif;"></div>');
  // Header
  $container.append('<div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:8px;"><strong>Search Loan Reason</strong><button type="button" class="xdlg-close" style="background:transparent;border:none;font-size:16px;cursor:pointer;">✕</button></div>');

  // Search input
  var $input = $('<input id="txtSearchLoanReason" placeholder="Enter Loan Purpose" class="form-control" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:4px;margin-bottom:8px;">');
  $container.append($input);

  // List container
  var $listWrap = $('<div style="max-height:240px;overflow:auto;border:1px solid #f0f0f0;border-radius:4px;"></div>');
  var $table = $('<table id="tblSasraLoanSectors" style="width:100%;border-collapse:collapse;font-size:13px;"></table>');
  var $tbody = $('<tbody id="bdSasraLoanSectors"></tbody>');
  $table.append($tbody);
  $listWrap.append($table);
  $container.append($listWrap);

  // Footer buttons
  var $footer = $('<div style="display:flex;justify-content:flex-end;gap:8px;margin-top:10px;"></div>');
  var $btnCancel = $('<button id="btnCancelSearch" class="btn btn-danger" style="padding:6px 12px;border-radius:4px;background:#d9534f;border:none;color:#fff;cursor:pointer;">Cancel</button>');
  var $btnSelect = $('<button id="btnSelect" class="btn btn-primary" style="padding:6px 12px;border-radius:4px;background:#0275d8;border:none;color:#fff;cursor:pointer;">Select</button>');
  $footer.append($btnCancel).append($btnSelect);
  $container.append($footer);

  // Append to body
  $('body').append($container);

  // Populate rows
  function DispLoanSectors(loanSectors) {
    $tbody.empty();
    loanSectors.forEach(function (row_data) {
      var $tr = $(
        '<tr style="cursor:pointer;border-bottom:1px solid #f5f5f5;">' +
          '<td style="padding:8px 10px;white-space:nowrap;width:1%;">' + $('<div>').text(row_data.SubSector2Code).html() + '</td>' +
          '<td style="padding:8px 10px;">' + $('<div>').text(row_data.SubSector2Name).html() + '</td>' +
          '<td style="display:none">' + $('<div>').text(row_data.SubSector1Code).html() + '</td>' +
          '<td style="display:none">' + $('<div>').text(row_data.SubSector1Name).html() + '</td>' +
          '<td style="display:none">' + $('<div>').text(row_data.MainSectorCode).html() + '</td>' +
          '<td style="display:none">' + $('<div>').text(row_data.MainSectorName).html() + '</td>' +
        '</tr>'
      );
      $tbody.append($tr);
    });
  }

  DispLoanSectors(subSector2List);

  // Row selection logic (single select)
  $tbody.on('click', 'tr', function () {
    $tbody.find('tr').css({background:'', color:''});
    $(this).css({background:'#eef5ff', color:'#000'});
  });

  // Filter on input
  $input.on('input', function (e) {
    var filter = (this.value || '').toUpperCase();
    $tbody.find('tr').each(function () {
      var txt = ($(this).find('td').eq(1).text() || '').toUpperCase();
      $(this).toggle(txt.indexOf(filter) > -1);
    });
  });

  // Select button behavior
  $btnSelect.on('click', function () {
    var $selected = $tbody.find('tr').filter(function () { return $(this).css('background-color') !== 'rgba(0, 0, 0, 0)'; }).first();
    // fallback: check classless selection by inspecting background set above
    if ($selected.length === 0) {
      // try an alternative approach: find the first visible row with selected styles
      $selected = $tbody.find('tr').filter(function () {
        return $(this).css('background-color') === 'rgb(238, 245, 255)';
      }).first();
    }
    if ($selected.length === 0) {
      alert('Nothing Selected');
      return;
    }

    var SelectedPurpose = {
      'Reason2Code': $selected.find('td').eq(0).text().trim(),
      'Reason2Name': $selected.find('td').eq(1).text().trim(),
      'Reason1Code': $selected.find('td').eq(2).text().trim(),
      'Reason1Name': $selected.find('td').eq(3).text().trim(),
      'MainReasonCode': $selected.find('td').eq(4).text().trim(),
      'MainReason1Name': $selected.find('td').eq(5).text().trim()
    };

    cleanup();
    deferred.resolve(SelectedPurpose);
  });

  // Cancel / close handlers
  function cleanup() {
    $container.off().remove();
  }

  $btnCancel.on('click', function () {
    cleanup();
    deferred.reject();
  });

  $container.find('.xdlg-close').on('click', function () {
    cleanup();
    deferred.reject();
  });

  // Keyboard: Enter selects the first visible row; Esc cancels
  $input.on('keydown', function (e) {
    if (e.key === 'Enter') {
      e.preventDefault();
      $btnSelect.click();
    } else if (e.key === 'Escape') {
      e.preventDefault();
      $btnCancel.click();
    }
  });

  // Focus input
  setTimeout(function () { $input.focus(); }, 10);

  return deferred.promise;
}

    //**********************END SEARCH SASRA LOAN PURPOSE ************************

    //not in use any more //
    function xDialogMemberAddGuarantor(loan_saving_scheme_code,edit_ln_db,edit_ln_no) {
        var deferred = Q.defer(); //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
        $('<div id="divDialogAddGuarantor" class="table-responsive"></div>').dialog({
            modal: true,
            title: "Add Guarantor",
            height: 400,
            width: Math.min(500, $(window).width() * .8), /*https://stackoverflow.com/questions/16471890/responsive-jquery-ui-dialog-and-a-fix-for-maxwidth-bug see answer - Not responsive in the sense that if the width is narrowed the dialog shrinks, but responsive in the sense that on a specific device, the dialog will not be too wide.*/
            autoOpen: true,
            show: {
                effect: "drop",
                direction: "up",
                duration: 500
            },

            buttons: {
                'OK': {
                    'text': 'OK',
                    'class' : 'btn btn-primary',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                    'id': 'btnOKPass',
                    'click': function () {
                        if (!isNumber($("#txtGuarantorAmount").val())) {
                            alert("Invalid Amount");
                            return;
                        } 
                        if (ConvertMoneyToDouble($("#txtGuarantorAmount").val())<0) {
                            alert("Requested Amount must be more than zero");
                            return;
                        } 
                        if ($("#divGuarantorNames").html()=="") {
                            alert("Invalid Guarantor Names");
                            return;
                        }
                        var AddGuarantorDetails = { 'GuarantorMemberNo': $("#txtGuarantorMemberNo").val(), 'GuarantorNames': $("#divGuarantorNames").html(), 'GuarantorAmount': ConvertMoneyToDouble($("#txtGuarantorAmount").val()) };
                        if (edit_ln_db != null) {
                            //were editing an existing loan application
                            var csrfToken = $("input[name='__RequestVerificationToken']").val();
                            $.ajax({
                                headers: { __RequestVerificationToken: csrfToken },
                                type: "POST",
                                url: global_site_root + '/api/MembersSystemApi/AddGuarantorToMemberLoanApplication',
                                data: JSON.stringify({ 'DBName': edit_ln_db, 'LoanApplicationNo': edit_ln_no, "GuarantorMemberNo": $("#txtGuarantorMemberNo").val(), "RequestedAmount": $("#txtGuarantorAmount").val() }),
                                contentType: "application/json; charset=utf-8",
                                dataType: "json",
                                success: function (response) {
                                    deferred.resolve(AddGuarantorDetails);
                                    $("#divDialogAddGuarantor").dialog("close");

                                },
                                error: function (xhr, status, error) {
                                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                                    alert('Error - ' + errorMessage);
                                }
                            });
                        } else {
                            deferred.resolve(AddGuarantorDetails);
                            $("#divDialogAddGuarantor").dialog("close");
                        }
                        
                    }
                },
                'Cancel': {
                    'text': 'Cancel',
                    'class': 'btn btn-danger',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                    'id': 'btnCancel',
                    'click': function () {
                        $(this).dialog("close");
                        deferred.reject();
                    }
                }

            },
            open: function () {
                var tbl = "<div class='table-responsive' ><table id='tblAddGuarantor' class='table table-responsive table-striped'>";
                tbl += "<tbody>";
                tbl += "<tr><td><b>Member No:</b></td>";
                tbl += "<td><input id='txtGuarantorMemberNo' type='text'/></td>";
                tbl += "<tr><td><b>Guarantor Names:</b></td>";
                tbl += "<td><div id='divGuarantorNames'></div></td>";
                tbl += "</tr>";
                tbl += "<tr><td><b>Amount Guaranteed:</b></td>";
                //tbl += "<td><input id='txtGuarantorAmount' type='text' disabled /></td>";
                tbl += "<td><input id='txtGuarantorAmount' type='text' enabled /></td>";
                tbl += "</tr>";
                tbl += "</tbody></table></div><br/><p id='pghErrorAddGuarantor'></p>";
                $(this).html(tbl);
                $("#txtGuarantorMemberNo").focus();
                $("#txtGuarantorAmount").on('click focus', function () {
                   // $("#txtGuarantorAmount").select();
                    $(this).select();
                });
                
            },
            close: function (event, ui) {
                // Destroy the jQuery UI dialog and remove it from the DOM
                $(this).dialog("destroy").remove();
                
                // If the promise has not yet been resolved (eg the user clicked the close icon) 
                // then resolve the promise as false indicating the user did *not* click "OK"
                if (deferred.promise.isPending()) {
                    deferred.reject();
                }
            }
        });
        $("#txtGuarantorMemberNo").on("keyup", function (e) {
            var kcode = (e.keyCode ? e.keyCode : e.which);
            if (kcode == $.ui.keyCode.ENTER) {
                $("#txtGuarantorAmount").focus();
            }
            e.stopPropagation();
        });
        $("#txtGuarantorMemberNo").on('focusout', function (e) {
            $("#divGuarantorNames").empty();
            $("#pghErrorAddGuarantor").text("");
            if ($("#txtGuarantorMemberNo").val().trim() == "") {
                //alert("Enter Member No.", "Member No. Required");
                return;
            }
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: global_site_root + '/api/MembersSystemApi/GetMemberSchemeBalance',
                data: JSON.stringify({ 'MemberNo': $("#txtGuarantorMemberNo").val(), 'SchemeCode': loan_saving_scheme_code }),
                contentType: "application/json; charset=utf-8",
                dataType: "json"
            }).success(function (data) {
                $("#divGuarantorNames").html(data.saccoMember.FullNames);
                //alert((+data.Balance).formatMoney());
                //$("#txtGuarantorAmount").val((+data.Balance).formatMoney());
                //$("#txtGuarantorAmount").val("");
            }).error(function (xhr, status, error) {
                //alert("Invalid Member Number");
                var errorMessage = xhr.status + ': ' + xhr.responseText;
                $("#pghErrorAddGuarantor").text("Last Error: " + errorMessage);
            });
            e.stopPropagation();
        })
        return deferred.promise;
}
function xDialogMemberAddWitness(edit_ln_db, edit_ln_no) {
    var deferred = Q.defer(); //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
    $('<div id="divDialogAddWitness"></div>').dialog({
        modal: true,
        title: "Add Witness",
        height: 300,
        width: Math.min(500, $(window).width() * .8), /*https://stackoverflow.com/questions/16471890/responsive-jquery-ui-dialog-and-a-fix-for-maxwidth-bug see answer - Not responsive in the sense that if the width is narrowed the dialog shrinks, but responsive in the sense that on a specific device, the dialog will not be too wide.*/
        autoOpen: true,
        show: {
            effect: "drop",
            direction: "up",
            duration: 500
        },
        buttons: {
            'OK': {
                'text': 'OK',
                'id': 'btnOKPass',
                'class': 'btn btn-primary',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                'click': function () {
                    
                    if ($("#divWitnessNames").html() == "") {
                        alert("Invalid Witness Names");
                        return;
                    }
                    var AddWitnessDetails = { 'WitnessMemberNo': $("#txtWitnessMemberNo").val(), 'WitnessNames': $("#divWitnessNames").html()};
                    if (edit_ln_db != null) {
                        //were editing an existing loan application
                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: global_site_root + '/api/MembersSystemApi/AddWitnessToMemberLoanApplication',
                            data: JSON.stringify({ 'DBName': edit_ln_db, 'LoanApplicationNo': edit_ln_no, "WitnessMemberNo": $("#txtWitnessMemberNo").val() }),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                deferred.resolve(AddWitnessDetails);
                                $("#divDialogAddWitness").dialog("close");
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
                    } else {
                        deferred.resolve(AddWitnessDetails);
                        $("#divDialogAddWitness").dialog("close");
                    }
                    
                }
            },
            'Cancel': {
                'text': 'Cancel',
                'class': 'btn btn-danger',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                'id': 'btnCancel',
                'click': function () {
                    $(this).dialog("close");
                    deferred.reject();
                }
            }

        },
        open: function () {
            var tbl = "<div class='table-responsive'><table id='tblAddWitness' class='table table-responsive table-striped'>";
            tbl += "<tbody>";
            tbl += "<tr><td><b>Member No:</b></td>";
            tbl += "<td><input id='txtWitnessMemberNo' type='text'/></td>";
            tbl += "<tr><td><b>Witness Names:</b></td>";
            tbl += "<td><div id='divWitnessNames'></div></td>";
            tbl += "</tbody></table></div><p id='pghErrorAddWitness'></p>";
            $(this).html(tbl);
            $("#txtWitnessMemberNo").focus();

        },
        close: function (event, ui) {
            // Destroy the jQuery UI dialog and remove it from the DOM
            $(this).dialog("destroy").remove();

            // If the promise has not yet been resolved (eg the user clicked the close icon) 
            // then resolve the promise as false indicating the user did *not* click "OK"
            if (deferred.promise.isPending()) {
                deferred.reject();
            }
        }
    });
    
    $("#txtWitnessMemberNo").on('focusout', function (e) {
        $("#divWitnessNames").empty();
        $("#pghErrorAddWitness").text("");
        if ($("#txtWitnessMemberNo").val().trim() == "") {
            //alert("Enter Member No.", "Member No. Required");
            return;
        }
        var csrfToken = $("input[name='__RequestVerificationToken']").val();
        $.ajax({
            headers: { __RequestVerificationToken: csrfToken },
            type: "POST",
            url: global_site_root + '/api/MembersSystemApi/GetMemberName',
            data: JSON.stringify({ 'MemberNo': $("#txtWitnessMemberNo").val() }),
            contentType: "application/json; charset=utf-8",
            dataType: "json"
        }).success(function (data) {
            $("#divWitnessNames").html(data);
        }).error(function (xhr, status, error) {
            //alert("Invalid Member Number");
            var errorMessage = xhr.status + ': ' + xhr.responseText;
            $("#pghErrorAddWitness").text("Last Error: " + errorMessage);
        });
        e.stopPropagation();
    })
    return deferred.promise;
}
    function xDialogGetAuthorizer(message) {
        var deferred = Q.defer(); //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
        $('<div></div>').dialog({
            modal: true,
            title: "User Authorization",
            height: 270,
            width: Math.min(500, $(window).width() * .8), /*https://stackoverflow.com/questions/16471890/responsive-jquery-ui-dialog-and-a-fix-for-maxwidth-bug see answer - Not responsive in the sense that if the width is narrowed the dialog shrinks, but responsive in the sense that on a specific device, the dialog will not be too wide.*/
            autoOpen: true,
            show: {
                effect: "drop",
                direction: "up",
                duration: 500
            },

            buttons: {
                'OK': {
                    'text': 'OK',
                    'id': 'btnOKPass',
                    'class':'btn btn-success',
                    'click': function () {
                        if ($("#txtPassword").val().trim() == "") {
                            alert("Enter Password", "Password Required");
                            return;
                        } else {
                            var UserCredetials = { 'UserName': $("#txtUserName").val(), 'UserPass': $("#txtPassword").val() };
                            deferred.resolve(UserCredetials);
                            $(this).dialog("close");
                        }
                    }
                },
                'Cancel':{
                    'text':'Cancle',
                    'class':'btn btn-danger',
                    'click': function () {
                        $(this).dialog("close");
                        deferred.reject();
                    }
                }

            },
            open: function () {
                var tbl = "<div><div id='tblPassword' >";
                tbl += "";
                tbl += "<div class='row'><label class='form-label'>" + message + "</label>";
                tbl += "<div class='col-md-4'>><label class='form-label'>User Name:</label>";
                tbl += "<input id='txtUserName' class='form-control' type='text'/><";
                tbl += "</div>";
                tbl += "<div class='col-md-4'><label>Password:</label>";
                tbl += "<input id='txtPassword' class='form-control' type='password'/>";
                tbl += "";
                tbl += "</div></div></div>";
                $(this).html(tbl);
                $("#txtUserName").focus();

            },
            close: function (event, ui) {
                // Destroy the jQuery UI dialog and remove it from the DOM
                $(this).dialog("destroy").remove();

                // If the promise has not yet been resolved (eg the user clicked the close icon) 
                // then resolve the promise as false indicating the user did *not* click "OK"
                if (deferred.promise.isPending()) {
                    deferred.reject();
                }
            }
        });
        $("#txtPassword").on("keyup", function (e) {
            var kcode = (e.keyCode ? e.keyCode : e.which);
            if (kcode == $.ui.keyCode.ENTER) {
                $("#btnOKPass").trigger("click");
            }
            e.stopPropagation();
        });
        $("#txtUserName").on("keyup", function (e) {
            var kcode = (e.keyCode ? e.keyCode : e.which);
            if (kcode == $.ui.keyCode.ENTER) {
                $("#txtPassword").focus();
            }
            e.stopPropagation();
            e.preventDefault();
        });
        return deferred.promise;
    }
    window.alert = function (message, dialogtitle) {
        var caption = dialogtitle || "Alert";
        $("<div />").text(message).attr({ title: '" + caption + "', 'class': 'alert' }).dialog({
            modal: true,
            title: caption,
            height: '250',
            draggable: true,
            resizable: false,
            width: Math.min(500, $(window).width() * .8), /*https://stackoverflow.com/questions/16471890/responsive-jquery-ui-dialog-and-a-fix-for-maxwidth-bug see answer - Not responsive in the sense that if the width is narrowed the dialog shrinks, but responsive in the sense that on a specific device, the dialog will not be too wide.*/
            autoOpen: true,
            show: {
                effect: "drop",
                direction: "up",
                duration: 500
            },
            buttons: {
                'OK': {
                    'text': 'OK',
                    'id': 'btnOKDialog',
                    'class': 'btn btn-primary',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                    'click': function () {
                        $(this).dialog("close");
                    }
                }
            },
            close: function (event, ui) {
                $(this).dialog("destroy").remove();
            }
        });
    };

    function xDialogMessage(message, dialogtitle) {
        var deferred = Q.defer(); //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly

        var caption = dialogtitle || "Alert";
        $("<div />").text(message).attr({'class': 'alert' }).dialog({
            modal: true,
            title: caption,
            height: 200,
            draggable: true,
            resizable: false,
            width: 'auto',
            autoOpen: true,
        
            show: {
                effect: "drop",
                direction: "up",
                duration: 500
            },
            buttons: {
                OK: function () {
                    deferred.resolve();
                    $(this).dialog("close");
                }
            },
            close: function (event, ui) {
                // Destroy the jQuery UI dialog and remove it from the DOM
                $(this).dialog("destroy").remove();
                // If the promise has not yet been resolved (eg the user clicked the close icon) 
                // then resolve the promise as false indicating the user did *not* click "OK"
                if (deferred.promise.isPending()) {
                    deferred.resolve(); //always return ok
                }
            }
        });

        return deferred.promise;
    }

    var gl_accounts_list = null;
    var last_acctype = "ALL";
    function xDialogSelectGLAccount(acctype) {
        last_acctype = acctype;
        var deferred = Q.defer();  //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
        var csrfToken = $("input[name='__RequestVerificationToken']").val();

        if (gl_accounts_list != null) {
            DispAccounts();
        } else {
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: global_site_root + "/api/BankSystemApi/GetGLAccounts",
                data: JSON.stringify({ 'RequestAccType': last_acctype }),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    gl_accounts_list = response;
                    DispAccounts();
                },
                error: function (xhr, status, error) {
                    
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    deferred.reject();
                }
            });
        }
    
    
    
        function DispAccounts() {
            if (gl_accounts_list == null) {
                alert("No accountlist reference");
                deferred.reject();
            }
            $('<div></div>').dialog({
                modal: true,
                title: "Select Account",
                height: 600,
                width: 1200,
                autoOpen: true,
                open: function () {

                    var accounts = gl_accounts_list;
                    var tbl = "<div class='table-responsive'><table id='tblAccounts' class='table table-responsive'>";
                    tbl += "<thead>";
                    tbl += "<tr>";
                    tbl += "	<th>Select</th>";
                    tbl += "	<th>AccName</th>";
                    tbl += "</tr>";
                    tbl += "</thead>";
                    tbl += "<tbody>";
                    $.each(accounts, function (index, acc) {
                        tbl += "<tr>";
                        tbl += "<td><label for=" + 'rdopt' + index + "><input type='radio' id=" + 'rdopt' + index + " value='" + acc.UserCode + "' name='rdopt'" + index + "/>" + acc.UserCode + "</label></td>";
                        tbl += "<td>" + acc.AccountName + "</td>";
                        tbl += "</tr>";
                    });
                    tbl += "</tbody></table></div>";
                    $(this).html(tbl);
                    var tblAcc = $("#tblAccounts").dataTable({
                        bJQueryUI: true,
                        sPaginationType: "full_numbers",
                        paging: false,
                        sScorollX: "900px",
                        sScrollY: "900px",
                        bScrollInfinite: true, //this property disables pagination
                        "bDestroy": true
                        //oSearch: { "sSearch": "DefaultSearchValue", "bRegex": false, "bSmart": false }
                    });

                    $('#tblAccounts tbody').on('click', 'tr', function () {
                        if ($(this).hasClass('selected')) {
                            $(this).removeClass('selected');
                        }
                        else {
                            tblAcc.$('tr.selected').removeClass('selected');
                            $(this).addClass('selected');
                        }
                    });

                    $('#tblAccounts tr').click(function () {
                        $(this).find('td input:radio').prop('checked', true);
                    })
                    //or
                    //$('table tr').click(function () {
                    //    $(this).find('input[type=radio]').prop('checked', true);
                    //});
                    //or
                    //$('table tr').click(function () {
                    //    $(this).find('input[:radio]').prop('checked', true);
                    //});

                },
                buttons: {
                    Refresh: function () {
                        gl_accounts_list = null;
                        LoadRefreshGLAccounts();
                        $(this).dialog("close");
                    },
                    Select: function () {
                        var answer;
                        $("input").each(function () {
                            (this.checked == true) ? answer = $(this).val() : null;
                        });
                        if (answer) {
                            deferred.resolve(answer);
                            $(this).dialog("close");
                        } else {
                            alert("Select Account");
                            return;
                        }

                    },
                    Cancel: function () {
                        $(this).dialog("close");
                    }
                },
                close: function (event, ui) {
                    // Destroy the jQuery UI dialog and remove it from the DOM
                    $(this).dialog("destroy").remove();

                    // If the promise has not yet been resolved (eg the user clicked the close icon) 
                    // then resolve the promise as false indicating the user did *not* click "OK"
                    if (deferred.promise.isPending()) {
                        deferred.reject();
                    }
                }
            });
        }
        return deferred.promise;
}




    
    function GetAccountName(accountno) {
        var deferred = Q.defer();  //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
        var csrfToken = $("input[name='__RequestVerificationToken']").val();
        $.ajax({
            headers: { __RequestVerificationToken: csrfToken },
            type: "POST",
            url: global_site_root + '/api/BankSystemApi/GetGLAccountName',
            data: JSON.stringify({ 'RequestAccUserCode': accountno }),
            contentType: "application/json; charset=utf-8",
            dataType: "json"
        }).success(function (data) {
            deferred.resolve(data)
        }).error(function (xhr, status, error) {
            deferred.reject();
        }).always(function (data) {
            if (deferred.promise.isPending()) {
                deferred.reject();
            }
        });
        return deferred.promise;
    }

    function xDialogChangePassword(url_change_password) {
        var deferred = Q.defer();
        $('<div id="divDlgChangePass" ></div>').dialog({
            modal: true,
            title: "Change Password",
            height: 350,
            width: 350, /*https://stackoverflow.com/questions/16471890/responsive-jquery-ui-dialog-and-a-fix-for-maxwidth-bug see answer - Not responsive in the sense that if the width is narrowed the dialog shrinks, but responsive in the sense that on a specific device, the dialog will not be too wide.*/
            autoOpen: true,
            show: {
                effect: "drop",
                direction: "up",
                duration: 500
            },

            buttons: {
                'OK': {
                    'text': 'Change Password',
                    'id': 'btnChangePassword',
                    'class': 'btn btn-success',
                    'click': function () {
                        
                        $("#txtNewPassword").val($("#txtnewpwd").val());
                        $("#txtnewpwd").val("");
                        $("#txtnewpwd").trigger("change");
                        if ($("#txtOldPassword").val().trim().length<4) {
                            alert("Invalid Old Password ( Min 4 characters)");
                            return;
                        }
                        if ($("#txtNewPassword").val().trim().length < 4) {
                            alert("Invalid New Password ( Min 4 characters)");
                            return;
                        }
                        if ($("#txtNewPassword").val() != $("#txtConfirmPassword").val()) {
                            alert("Password confirmation failed");
                            return;
                        }
                        if ($("#txtNewPassword").val() == $("#txtOldPassword").val()) {
                            alert("New password should be different");
                            return;
                        }
                        
                        
                        var pwdslt = getRandomInt(1000, 30000);
                        pwdslt = pwdslt.toString();
                        var pwd = CryptoJS.MD5($("#txtOldPassword").val()).toString();
                        pwd = pwd + pwdslt;
                        var sltpwd = CryptoJS.MD5(pwd).toString();

                        
                        
                        
                        var newpasswd = CryptoJS.MD5($("#txtNewPassword").val()).toString();
                        var confirmpasswd = CryptoJS.MD5($("#txtConfirmPassword").val()).toString();
                        

                        var outData = {
                            'OldPassword': sltpwd,
                            'Salt': pwdslt,
                            'NewPassword': newpasswd,
                            'ConfirmPassword': confirmpasswd,
                        }
                        //try to prevent browser from offering to store password
                        //01April2022
                        $("#txtOldPassword").val("");
                        $("#txtNewPassword").val("");
                        $("#txtConfirmPassword").val("");
                        //end try to prevent browser from offering to store password
                        outData = JSON.stringify(outData);
                        var csrfToken = $("input[name='__RequestVerificationToken']").val();

                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: url_change_password,
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (data) {
                                xDialogMessage("Password Changed successfully", "Information").then(function () {
                                    var ChangePasswordResult = { 'Sucesss': true};
                                    deferred.resolve(ChangePasswordResult);
                                    $("#divDlgChangePass").dialog("destroy").remove();
                                });
                                //$(this).dialog("destroy").remove();
                            }
                            , error: function (xhr, status, error) {
                                if (deferred.promise.isPending()) {
                                    deferred.reject();
                                }
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
                    }
                },
                "Cancel":{
                    'text':"Cancel",
                    'class':'btn btn-danger',
                    'click':function () {
                        //$(this).dialog("close");
                        if (deferred.promise.isPending()) {
                            deferred.reject();
                        }
                        $(this).dialog("destroy").remove();
                    },

                } 
                
            },
            open: function () {
                //<%--02April2022 add password field before actual password field to prevent save password dialogue--%>
                var tbl = "";
                tbl += "<div><form>";
                tbl += "<div style = 'display: none;'><input type='text' value='' class='form-control'/><input type='' value='test' id='txtPW' class='form-control' /></div>";
                tbl += "<div><div id='tblChangePassword' class='col-md' > ";
                tbl += "";
                tbl += "<label class='form-label'>Old Password:</label>";
                tbl += "<input id='txtOldPassword' type='password' autocomplete='off' class='form-control' /></div>";
                tbl += "<div class='col-md'><label class='form-label'>New Password:</label>";
                tbl += "<input id='txtnewpwd2' type='hidden' class='form-control'/><input id='txtnewpwd' type='password' class='form-control'/><input id='txtNewPassword' class='form-control' type='hidden'/>";
                tbl += "</div>";
                tbl += "<div class='col-md'><label class='form-label'>Confirm Password:</label>";
                tbl += "<input id='txtConfirmPassword' type='password' class='form-control'/>";
                tbl += "</div>";
                tbl += "</div></form></div>";
                $(this).html(tbl);
                $("#txtOldPassword").focus();
                setTimeout(function () {
                    $("#txtOldPassword").val("");
                }, 1000);
                $("#txtOldPassword").val("");


            },
            close: function (event, ui) {
                // Destroy the jQuery UI dialog and remove it from the DOM
                if (deferred.promise.isPending()) {
                    deferred.reject();
                }
                $(this).dialog("destroy").remove();
            }
        });
        $("#txtOldPassword").on("keyup", function (e) {
            var kcode = (e.keyCode ? e.keyCode : e.which);
            if (kcode == $.ui.keyCode.ENTER) {
                $("#txtNewPassword").focus();
            }
            e.stopPropagation();
        });
        return deferred.promise;
    }

function xDialogSelectManager(managers_select_list) {
    var deferred = Q.defer();  //dont use jQuery's var deferred = new $.Deferred(); has a lot of negative reviews does not implement the specification correctly
    var csrfToken = $("input[name='__RequestVerificationToken']").val();
    if (managers_select_list == null) {
        alert("No Managers reference");
        deferred.reject();
    }
    $('<div></div>').dialog({
        modal: true,
        title: "Select Manager/HOD",
        height: 400,
        width: Math.min(800, $(window).width() * .8), /*https://stackoverflow.com/questions/16471890/responsive-jquery-ui-dialog-and-a-fix-for-maxwidth-bug see answer - Not responsive in the sense that if the width is narrowed the dialog shrinks, but responsive in the sense that on a specific device, the dialog will not be too wide.*/
        autoOpen: true,
        open: function () {
            var tbl = "<div class='table-responsive'><table id='tblManagers' class='table txble-responsive'>";
            tbl += "<thead>";
            tbl += "<tr>";
            tbl += "	<th>Select(PF No)</th>";
            tbl += "	<th>Name</th>";
            tbl += "</tr>";
            tbl += "</thead>";
            tbl += "<tbody>";
            $.each(managers_select_list, function (index, hod_manager) {
                tbl += "<tr>";
                tbl += "<td><label for=" + 'rdopt' + index + "><input type='radio' id=" + 'rdopt' + index + " value='" + hod_manager.UserID + "' name='rdopt'" + index + "/>" + hod_manager.UserID + "</label></td>";
                tbl += "<td>" + hod_manager.FullNames + "</td>";
                tbl += "</tr>";
            });
            tbl += "</tbody></table></div>";
            $(this).html(tbl);
            var tblMgrs = $("#tblManagers").dataTable({
                bJQueryUI: true,
                sPaginationType: "full_numbers",
                paging: false,
                sScorollX: "900px",
                sScrollY: "900px",
                bScrollInfinite: true, //this property disables pagination
                "bDestroy": true
                //oSearch: { "sSearch": "DefaultSearchValue", "bRegex": false, "bSmart": false }
            });

            $('#tblManagers tbody').on('click', 'tr', function () {
                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                }
                else {
                    tblMgrs.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

            $('#tblManagers tr').click(function () {
                $(this).find('td input:radio').prop('checked', true);
            })
            //or
            //$('table tr').click(function () {
            //    $(this).find('input[type=radio]').prop('checked', true);
            //});
            //or
            //$('table tr').click(function () {
            //    $(this).find('input[:radio]').prop('checked', true);
            //});

        },
        buttons: {
            Select: function () {
                var answer;
                $("input").each(function () {
                    (this.checked == true) ? answer = $(this).val() : null;
                });
                if (answer) {
                    deferred.resolve(answer);
                    $(this).dialog("close");
                } else {
                    alert("Select Manager");
                    return;
                }

            },
            Cancel: function () {
                $(this).dialog("close");
            }
        },
        close: function (event, ui) {
            // Destroy the jQuery UI dialog and remove it from the DOM
            $(this).dialog("destroy").remove();

            // If the promise has not yet been resolved (eg the user clicked the close icon) 
            // then resolve the promise as false indicating the user did *not* click "OK"
            if (deferred.promise.isPending()) {
                deferred.reject();
            }
        }
    });
    return deferred.promise;
}

function stringToBoolean(strVal) {
    console.log(strVal);
    //strVal = strVal.toLowerCase().trim();
    //switch (strVal) {
    //    case "true": case "yes": case "1": return true;
    //    case "false": case "no": case "0": case null: return false;
    //    default: return Boolean(strVal);
    //}
}