﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Cheque Sales
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .tblDRCRDetails {
             margin: 1px;
             border: 1em;
             padding-left:1em;
             padding-top:1em;
             border-collapse:separate;
         }
         
         /*use this for to calculate totals*/  
         .colamount {
            text-align:right;
         }
         tr.row_selected td{background-color:lawngreen;}
   </style>

    
    <script type="text/javascript"  >
        $(document).ready(function () {
            var strAccountName = "";
            var strAccountCode = "";
            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });

            $("#txtAmount").on('change keyup paste mouseup', function () {
                $("#divAmountInWords").html("");
                try {
                    $("#divAmountInWords").html(toWords($("#txtAmount").val()));
                } catch (err) {

                }
            });
            $("#txtAccountNo").on('focusout', function () {
                strAccountName = "";
                strAccountCode = "";
                $("#divAccountDetails").empty();
                $("#divAccName").empty();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetTellerTransactingAccountDetails") %>",
                    data: JSON.stringify({ 'TransactingAccount': $("#txtAccountNo").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        if (response.IsCustomerAccount == true) {
                            var MemAcc = response.detailedCustomerAccount.MemberAcc;
                            strAccountName = MemAcc.AccountName;
                            strAccountCode = MemAcc.AccountNo;
                            var strAccDetails = "<table>";
                            strAccDetails += "<tr><td>Account Name</td><td>" + MemAcc.AccountName + "</td></tr>";
                            strAccDetails += "<tr><td>Account No</td><td>" + MemAcc.AccountNo + "</td></tr>";
                            strAccDetails += "<tr><td>Acc Type</td><td>" + MemAcc.AccountType + "</td></tr>";
                            strAccDetails += "<tr><td>Available Balance</td><td>" + response.detailedCustomerAccount.AvailableBalance.formatMoney() + "</td></tr>";
                            strAccDetails += "<tr><td>Actual Balance</td><td>" + response.detailedCustomerAccount.LedgerBalance.formatMoney() + "</td></tr>";
                            strAccDetails += "<tr><td>Type Name</td><td>" + MemAcc.AccountTypeName + "</td></tr>";
                            strAccDetails += "<tr><td>File No</td><td>" + MemAcc.FileNo + "</td></tr>";
                            strAccDetails += "<tr><td>Last Deposit Date</td><td>" + MemAcc.DateOfLastDeposit + "</td></tr>";
                            strAccDetails += "<tr><td>Last Withdrawal Date</td><td>" + MemAcc.DateOfLastWithdrawal + "</td></tr>";
                            strAccDetails += "<tr><td>Date Openned</td><td>" + MemAcc.OpenningDate + "</td></tr>";
                            strAccDetails += "<tr><td>Branch</td><td>" + MemAcc.BranchName + "</td></tr>";
                            strAccDetails += "<tr><td>Status</td><td>" + MemAcc.Status + "</td></tr>";
                            strAccDetails += "<tr><td>Instructions</td><td>" + MemAcc.Instructions + "</td></tr>";

                            var acc_members = response.detailedCustomerAccount.AccountMembers;
                            $.each(acc_members, function (index, acc_member) {
                                strAccDetails += "<tr><td>EmpCode</td><td>" + acc_member.EmployerCode + "</td></tr>";
                                strAccDetails += "<tr><td>PayrollNo</td><td>" + acc_member.PayrollNo + "</td></tr>";
                                strAccDetails += "<tr><td>MemberNo</td><td>" + acc_member.MemberNo + "</td></tr>";
                                strAccDetails += "<tr><td>IDNumber</td><td>" + acc_member.IDNumber + "</td></tr>";
                                strAccDetails += "<tr><td>FullNames</td><td>" + acc_member.FullNames + "</td></tr>";
                            });
                            strAccDetails += "</table>";

                            $("#divAccountDetails").html(strAccDetails);

                            //LoadImageFromUrl(response.detailedCustomerAccount.PhotoPath, 180, 180, $("#divMemberPhoto"));
                            //LoadImageFromUrl(response.detailedCustomerAccount.SignaturePath, 180, 180, $("#divMemberSignature"));
                        } else {
                            strAccountName = response.otherAccountDetails.AccountName;
                            strAccountCode = response.otherAccountDetails.UserCode;
                            var strAccDetails = "Account Name : " + response.otherAccountDetails.AccountName + "</br>";
                            strAccDetails += "Account No : " + response.otherAccountDetails.UserCode + "</br>";
                            strAccDetails += "Acc Type : " + "Non-Customer Account" + "</br>";
                            $("#divAccountDetails").html(strAccDetails);
                        }
                        $("#divAccName").append("<b>" + strAccountName + "</b>");
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });

            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetChequeSalesModuleConfig") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response.Years;
                    var chequesaletypes = response.ChequeSaleTypes;
                    var saccobranches = response.Branches;
                    SaccoSettings = response.SaccoSettings;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    var obj = document.getElementById("cboBranch");
                    $.each(saccobranches, function (index, saccobranch) {
                        var opt = document.createElement("option");
                        opt.value = saccobranch.BranchCode;
                        opt.text = saccobranch.BranchName + "(" + saccobranch.BranchCode + ")";
                        obj.appendChild(opt);
                    });
                    var obj = document.getElementById("cboChequeSaleType");
                    var opt = document.createElement("option");
                    opt.value = "";
                    opt.text = "(SELECT)";
                    obj.appendChild(opt);
                    $.each(chequesaletypes, function (index, chequesaletype) {
                        var opt = document.createElement("option");
                        opt.value = chequesaletype.MyID;
                        opt.text = chequesaletype.ChequeSaleName;
                        obj.appendChild(opt);
                    });
                    LoadFinancialPeriods();
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });

            $('#tabs').on('tabsactivate', function (event, ui) {
                var newIndex = ui.newTab.index();
                if (newIndex == 1) {
                    GetCustomerChequeSalesReport();
                }
            });

            $("#btnRefresh").on('click', function () {
                GetCustomerChequeSalesReport();
            });
            $("#btnPrint").on('click', function () {
                var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "Customer Cheque Sales Report";
                $("#divChequeSalesList").printThis({
                    debug: false,
                    pageTitle: "Report",
                    removeInline: true,
                    printContainer: true,
                    importCSS: true,
                    header: rptHeader
                });

            });

            $("#tblChequeSalesList").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });

            $("#cboYear").on('change', function () {
                LoadFinancialPeriods()
            });
            $("#cboPeriod").on('change', function () {
                GetCustomerChequeSalesReport();
            });
            $("#cboBranch").on('change', function () {
                GetCustomerChequeSalesReport();
            });
            $("#btnRefresh").on('click', function () {
                GetCustomerChequeSalesReport();
            });
            $("#btnClear").on('click', function () {
                ClearInputs();
            });

            $("#txtAccountNo").mask(AccountMask);

            $("#btnPost").on('click', function () {
                if (document.getElementById("cboChequeSaleType").selectedIndex == 0) {
                    return;
                }
                if (strAccountCode == "") {
                    alert("Invalid Account");
                    return;
                }
                if (!isNumber($("#txtAmount").val())) {
                    alert("Invalid Amount");
                    return;
                }
                xDialogConfirm("Amount=" + $("#txtAmount").val() + "<br/>Account No " + $("#txtAccountNo").val() + "<br/>Post Cheque Sale?", "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        PostCustomerChequeSale(data);
                    });
                });
            });


            function GetCustomerChequeSalesReport() {
                $("#tblChequeSalesList > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboYear").val(),
                    'PeriodCode': $("#cboPeriod").val(),
                    'BranchCode': $("#cboBranch").val(),
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetCustomerChequeSalesReport") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#tblChequeSalesList > tbody:last").children().remove();
                        var row_datas = response;
                        var tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.BatchDate + "</td>";
                            tbl_row += "<td>" + row_data.ChequeNum + "</td>";
                            tbl_row += "<td>" + row_data.AccountNumber + "</td>";
                            tbl_row += "<td>" + row_data.AccountNumberName + "</td>";
                            tbl_row += "<td>" + row_data.Amount + "</td>";
                            tbl_row += "<td>" + row_data.TellerName + "</td>";
                            tbl_row += "<td>" + row_data.DebitAccount + "</td>";
                            tbl_row += "<td>" + row_data.DebitAccountName + "</td>";
                            tbl_row += "<td>" + row_data.BranchCode + "</td>";
                            tbl_row += "<td>" + row_data.Payee + "</td>";
                            tbl_row += "</tr>";

                        });
                        $("#tblChequeSalesList").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            }


            function PostCustomerChequeSale(credetials) {

                var UserName = credetials.UserName;
                var Password = credetials.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();



                var outData = {
                    'AccountNo': $("#txtAccountNo").val(),
                    'Amount': $("#txtAmount").val(),
                    'ChequeSaleType': $("#cboChequeSaleType").val(),
                    'DocumentNo': $("#txtDocNo").val(),
                    'ChequeNo': $("#txtChequeNo").val(),
                    'Payee': $("#txtPayee").val(),
                    'UserName': UserName,
                    'Password': sltpwd,
                    'Salt': pwdslt
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/PostCustomerChequeSale") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        alert("Customer Cheque Sale Posted");
                        ClearInputs();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });

            }

            function ClearInputs() {
                strAccountCode = "";
                strAccountName = "";
                $("#txtAccountNo").val("");
                $("#txtAmount").val("0.00");
                $("#txtChequeNo").val("");
                $("#divAccName").empty();
                $("#txtPayee").val("");
                $("#txtDocNo").val("");
                $("#divAmountInWords").empty();
                $("#divAccountDetails").empty();
            }



            function LoadFinancialPeriods() {
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }


                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var fmonths = response;
                        var objPeriod = document.getElementById("cboPeriod");
                        $("#cboPeriod").empty();
                        $.each(fmonths, function (index, fmonth) {
                            var optn = "<option value='" + fmonth.MonthID + "'>" + fmonth.MonthName + "</option>";
                            $("#cboPeriod").append(optn);
                            if (fmonth.Status == "OPENED") {
                                objPeriod.selectedIndex = index
                            }

                        });
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }
            //$(function () {
            //    $("#tabs").tabs();
            //});
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
        <div id="tabs" class="mb-5">
            <div class="my-4 mx-auto d-flex justify-content-center col-12 col-md-8 ">
                    <div id="customTabs" class="custom-tabs  position-relative">
                        <ul class="custom-tabs-nav mb-0 d-flex list-unstyled">
                            <li><a href="#tab1" data-tab="tab1" class="custom-tab-label active">Cheque Sales</a></li>
                            <li><a href="#tab2" data-tab="tab2" class="custom-tab-label">Reports</a></li>
                        </ul>
                <span class="custom-glider position-absolute d-flex" style="transform: translateX(0);"></span>
                </div>
            </div>
          </div>

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="card bg-white">
        <h3 class="p-3 fs-5">Cheque Sales</h3>
        <hr class="m-0 p-0"/>

        <form id="frmMain" name="frmMain" method="post">
            <%= Html.AntiForgeryToken() %>
            <div id="tab1" class="tab-content-panel active  p-3" >
                    <div  class="row"> 
                        <div class="col-md-4">
                            <label for="Sale Type:" class="form-label">Sale Type:</label>
                            <select class="form-select" id="cboSaleTransactionType" disabled><option selected>Customer Acc</option><option>Non-Customer Acc</option></select>
                        </div>
                        <div class="col-md-4">
                            <label for=" Cheque Type:" class="form-label">Cheque Type:</label>
                            <select class="form-select" id="cboChequeSaleType"></select>
                        </div>
                    
                        <div class="col-md-4">
                            <label for="Account" class="form-label">Account</label>
                            <input type="text" class="form-control text-center" placeholder="Account" id="txtAccountNo"/>
                        </div>
                        <div class="col-md-4">
                            <label for= "  Payee:" class="form-label">Payee:</label>
                        <input type="text" class="form-control" id="txtPayee" />
                        </div>


                   
                        <div class="col-md-4">
                           <label class="form-label">Account Name: </label> 
                            <div id="divAccName"></div>
                        </div>
              
                        <div class="col-md-4">
                            <label for="Cheque Amount" class="form-label">Cheque Amount:</label>
                        <input type="text" class="form-control" id="txtAmount" placeholder="Cheque Amount" />
                        </div>

                    
                        <div class="mt-3">
                            <div id="divAmountInWords"></div>
                        </div>
                    
                        <div class="col-md-4">
                            <label for= "Cheque Number" class="form-label">Cheque Number:</label>
                    
                            <input type="text" class="form-control" id="txtChequeNo" placeholder="Cheque Number" />
                        </div>
                        <div class="col-md-4">
                            <label for= "Document Number" class="form-label">Document Number:</label>
                    
                            <input type="text" class="form-control" id="txtDocNo" placeholder="Document Number" />
                        </div>

                  </div>
                    <div id="divAccountDetails" class="mt-4" style="overflow:auto;width:auto;">
                        <label class="form-label">Account Details</label>
                    </div>
                        <hr />

                    <div class="nav nav-pills r-tabs-nav d-flex justify-content-center" style="gap: 10px;margin-left: 17px;margin-block: 15px;">
                        <input type="button" class="btn btn-success" value="Post" id="btnPost" />
                        <input type="button" class="btn btn-danger" value="Clear" id="btnClear" />       
                    </div>



                </div>
           






            <div id="tab2" class="tab-content-panel p-3">
                <div  class="row" id="tblPeriod">
                        <div class='col-auto' >
                            <label for="Financial Year" class="form-label">Financial Year:</label>
                            
                            <select id="cboYear" class="form-select"><option value="selectyear">SELECT YEAR</option></select>
                        </div>
                        <div class="col-auto">
                            <label for="Period" class="form-label">Period:</label>
                            <select id="cboPeriod" class="form-select"><option value="selectperiod" selected>(SELECT PERIOD)</option></select>
                        </div>
                        <div class="col-auto">
                            <label for="Branch:" class="form-label"> Branch:</label>
                            <select id="cboBranch" class="form-select"><option value="" selected>(ALL BRANCHES)</option></select>
                        </div>
                        
                        <div class="my-4">
                        <input type="button" id="btnRefresh"  class=" btn btn-info"  value="Refresh"/>
                        <input type="button"  class=" btn btn-success" id="btnPrint" value="Print"/>
                    </tr>

                </div>
                </div>


                <div id="divChequeSalesList"  style="height:200px;">
                <table id='tblChequeSalesList'  class="table table-bordered">
                        <thead>
                            <tr>
                            <th>Date</th>
                            <th>ChequeNo</th>
                            <th>AccountNo</th>
                            <th>A/C Name</th>
                            <th>Amount</th>
                            <th>User</th>
                            <th>Bank</th>
                            <th>Bank Name</th>
                            <th>Branch</th>
                            <th>Payee</th>
                                
                            </tr>
                        </thead>
                        <tbody id='bdChequeSalesList'>
                        </tbody>
                   
                </table>
        </div>
        </form>
    
</div>
</asp:Content>


